import { testName } from '../../support';
import { K8S_KIND, VM_ACTION, YAML_VM_NAME } from '../../utils/const/index';
import {
  warningUserLoggedIn,
  noActiveUser,
  noUserLoggedIn,
  oneActiveUser,
  serialEmptyState,
  timeOfLogin,
  vncEmptyState,
} from '../../utils/const/string';
import { selectActionFromDropdown } from '../../views/actions';
import {
  connect,
  ctrlAltDel,
  emptyState,
  disconnect,
  disconnectSerial,
  loginSerial,
  loginVNC,
  sendKey,
} from '../../views/console';
import { actionButtons, alertDescription, dashboardTab, modalCancel } from '../../views/selector';
import { loggedInUser } from '../../views/selector-tabs';
import { tab } from '../../views/tab';
import { vm } from '../../views/vm';

describe('Test VM console tab', () => {
  before(() => {
    cy.Login();
    cy.createProject(testName);
    cy.visitVMsList();
    cy.createDefaultVM();
    tab.navigateToDetails();
    vm.start();
    cy.waitForLoginPrompt(YAML_VM_NAME, testName);
    tab.navigateToOverview();
    // cy.get(dashboardTab.guestAgentOK, { timeout: 300000 }).should('exist');
  });

  after(() => {
    cy.deleteResource(K8S_KIND.VM, YAML_VM_NAME, testName);
    cy.deleteTestProject(testName);
  });

  it('ID(CNV-872) VNC console connects', () => {
    tab.navigateToConsole();
    loginVNC();
    // disconnect VNC console
    cy.byButtonText(disconnect).click({ force: true });
    cy.get(emptyState).should('contain', vncEmptyState);
    cy.byButtonText(connect).click();
    // after login VNC console, scroll up is flaky
    // so revisit VM tabs explicitly
    // cy.reload();
    if (Cypress.env('DOWNSTREAM')) {
      tab.navigateToDetails();
      cy.get(loggedInUser).should('not.contain', noActiveUser);
      cy.get(loggedInUser).should('contain', timeOfLogin);
      tab.navigateToConsole();
      // send key
      cy.contains(sendKey).click();
      cy.contains(ctrlAltDel).click();
      tab.navigateToDetails();
      cy.get(loggedInUser).should('contain', noActiveUser);
    }
  });

  xit('ID(CNV-3609) Serial console connects', () => {
    tab.navigateToConsole();
    loginSerial();
    cy.reload();
    if (Cypress.env('DOWNSTREAM')) {
      tab.navigateToOverview();
      cy.get(dashboardTab.detailsCardItem)
        .eq(8)
        .should('not.contain', noUserLoggedIn); // Active Users
      cy.get(dashboardTab.detailsCardItem)
        .eq(8)
        .should('contain', oneActiveUser); // Active Users
      tab.navigateToConsole();
    }
    // verify warning showing on VM actions while user is logged in
    [VM_ACTION.Stop, VM_ACTION.Restart, VM_ACTION.Delete].forEach((action) => {
      selectActionFromDropdown(action, actionButtons.actionDropdownButton);
      cy.contains(alertDescription, warningUserLoggedIn).should('be.visible');
      cy.get(modalCancel).click();
    });
    // disconnect serial console
    disconnectSerial();
    cy.get(emptyState).should('contain', serialEmptyState);
    cy.byButtonText(connect).should('exist');
  });
});
