# Dex v2

## Streamlined deployments

Many of the changes between v1 and v2 were aimed at making dex easier to deploy and manage, perhaps the biggest pain point for dex v1. Dex is now a single, scalable binary with a sole source of configuration. Many components which previously had to be set through the API, such as OAuth2 clients and IDP connectors can now be specified statically. The new architecture lacks a singleton component eliminating deployment ordering. There are no more special development modes; instructions for running dex on a workstation translate with minimal changes to a production system.

All of this results in a much simpler deployment story. Write a config file, run the dex binary, and that's it.

## More storage backends

Dex's internal storage interface has been improved to support multiple backing databases including Postgres, SQLite3, and the Kubernetes API through Third Party Resources. This allows dex to meet a more diverse set of use cases instead of insisting on one particular deployment pattern. For example, The Kubernetes API implementation, a [key value store][k8s-api-docs], allows dex to be run natively on top of a Kubernetes cluster with extremely little administrative overhead. Starting with support for multiple storage backends also should help ensure that the dex storage interface is actually pluggable, rather than being coupled too tightly with a single implementation.

A more in depth discussion of existing storage options and how to add new ones can be found [here][storage-docs].

## Additional improvements

The rewrite came with several, miscellaneous improvements including:

* More powerful connectors. For example the GitHub connector can now query for teams.
* Combined the two APIs into a single [gRPC API][api-docs] with no complex authorization rules.
* Expanded OAuth2 capabilities such as the implicit flow. 
* Simplified codebase and improved testing.

## Rethinking registration

Dex v1 performed well when it could manage users. It provided features such as registration, email invites, password resets, administrative abilities, etc. However, login flows and APIs remain tightly coupled with concepts like registration and admin users even when v1 federated to an upstream identity provider (IDP) where it likely only had read only access to the actual user database.

Many of v2's use cases focus on federation to other IPDs rather than managing users itself. Because of this, options associated with registration, such as SMTP credentials, have been removed. We hope to add registration and user management back into the project through orthogonal applications using the [gRPC API][api-docs], but in a way that doesn't impact other use cases.

## Removed features

Dex v2 lacks certain features present in v1. For the most part _we aim to add most of these features back into v2_, but in a way that installations have to _opt in_ to a feature instead of burdening every deployment with extra configuration.

Notable missing features include:

* Registration flows.
* Local user management.
* SMTP configuration and email verification.
* Several of the login connectors that have yet to be ported.

## Support for dex v1

Dex v1 will continue to live under the `github.com/coreos/dex` repo on a branch. Bug fixes and minor changes will continue to be accepted, but development of new features by the dex team will largely cease.

[k8s-api-docs]: http://kubernetes.io/docs/api/
[storage-docs]: ./storage.md
[api-docs]: ./api.md
