# Devfile Registry Operator Proposal

## Problem
Currently, the devfile registry is deployed onto a running cluster by `kubectl apply`-ing a few yaml files. This works fine for a proof of concept or doing a quick demo, but there’s a few problems with this approach that make it infeasible long-term:

1) Configuration is difficult.
   
   For example, the current approach makes it difficult to programatically configure TLS and authentication for the OCI registry server when deploying.

2) Deployment isn't user friendly and hard to tell how/why something went wrong

3) Updates to the registry instance are not straightfoward

    Requires the registry administrator to manually edit and update the devfile registry deployment resource.

3) Deployment isn’t the same on Kubernetes and OpenShift.

   To handle this, we currently have to maintain two separate sets of yaml files for deploying the registry on Kubernetes or OpenShift.

## Solution
Implementing an operator to programatically deploy devfile registries will streamline the deployment process on both Kubernetes and OpenShift, as well as provide greater flexibility for customization and configuration when deploying it (especially as we add support for deploying with TLS and authentication enabled). It will also provide us the ability to onboard the devfile registry to OperatorHub in the future, if we wish.

## DevfileRegistry Custom Resource

### API Group:
`registry.devfile.io`

### API Version
`v1alpha1`

### Resource Kind
`DevfileRegistry`

### Scope
`Namespaced`

### Fields

`devfileIndexImage` (string) Image used to bootstrap the OCI registry with devfiles and host the index.json.

`ociRegistryImage` (string) Image used for the OCI registry instance. Defaults to `registry:2.7.1`

#### TLS
`enabled` (bool) TLS mode for the devfile registry. Defaults to true. If on OpenShift, the cluster's routing certificate will be re-used. If on Kubernetes, cert-manager will be used to provision a TLS secret.

`tlsSecretName` (string) Optional pre-existing Kubernetes secret for TLS termination on the ingress resource. If set, cert-manager will **not** be used to provision a TLS secret.

#### Storage
`enabled` (bool) Enables persistent storage for the registry. Defaults to true. Can be disabled for development or testing only.

`registryVolumeSize` (string). Size of the volume to use. Defaults to 1Gi.

#### Kubernetes Specific
`ingressDomain` (string) Ingress domain to be used when deploying on Kubernetes.

### DevfileRegistry Custom Resource Formatting
```
apiVersion: registry.devfile.io/v1alpha1
kind: DevfileRegistry
metadata:
  name: registry
spec:
  devfileIndexImage: ''
  ociRegistryImage: ''
  tls:
    enabled: true
    secretName: ''
  storage:
    enabled: true
    registryVolumeSize: '3Gi'
  k8s:
    ingressDomain: ''
```

## Operator Functionality

### `DevfileRegistry` Creation
When an instance of a `DevfileRegistry` resource is created in the namespace where the Devfile Registry operator is deployed, the following occurs in the operator's `reconcile` loop:

1) A service exposing the devfile index server and OCI registry is created
2) If persistence was enabled, a persistent volume claim (PVC) is provisioned.
3) The deployment containing the OCI registry and bootstrap container is deployed
4) (Kubernetes only) If `tls.enabled` is true and no pre-existing secret is specified in `tls.secretName`, provision a TLS secret using `cert-manager`.
4) The OpenShift route or Kubernetes ingress resource is created
    
    a) (OpenShift only) If TLS was enabled, configure the OpenShift route to re-use the cluster's certificate.
    
    b) (Kubernetes only) If TLS was enabled, configure the ingress resource to use the TLS secret either generated by us, or specified by the user.

5) Once the devfile registry index server is accessible, the URL field in the `DevfileRegistry` status is set to the URL of the index server.

As is standard in the operator-sdk, all subresources that are created by the operator (Deployments, services, etc) will be owned by the `DevfileRegistry` instance and watched by the operator.

### `DevfileRegistry` Update
As the operator is watching for changes on all instances of the `DevfileRegistry` custom resource, any updates to the fields of an instance of the resource will get detected by the operator and handled accordingly

Additionally, any updates to the `devfileIndexImage` field will be handled as outlined in the [Devfile Registry Lifecycle](https://docs.google.com/document/d/1rQHCp4SWslWWJv5KK3A_iXHvgbqjsuDkSKDD72ifJio/edit?usp=sharing) design doc.

### `DevfileRegistry` Delete
When an instance of a `DevfileRegistry` resource is deleted, the operator (and the Kubernetes garbage collector) will remove the instance from the cluster, along with any subresources owned by it (such as the devfile registry deployment, service, etc).