// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package redshift

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeClusterParameterGroupsInput struct {
	_ struct{} `type:"structure"`

	// An optional parameter that specifies the starting point to return a set of
	// response records. When the results of a DescribeClusterParameterGroups request
	// exceed the value specified in MaxRecords, AWS returns a value in the Marker
	// field of the response. You can retrieve the next set of response records
	// by providing the returned marker value in the Marker parameter and retrying
	// the request.
	Marker *string `type:"string"`

	// The maximum number of response records to return in each call. If the number
	// of remaining response records exceeds the specified MaxRecords value, a value
	// is returned in a marker field of the response. You can retrieve the next
	// set of records by retrying the command with the returned marker value.
	//
	// Default: 100
	//
	// Constraints: minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The name of a specific parameter group for which to return details. By default,
	// details about all parameter groups and the default parameter group are returned.
	ParameterGroupName *string `type:"string"`

	// A tag key or keys for which you want to return all matching cluster parameter
	// groups that are associated with the specified key or keys. For example, suppose
	// that you have parameter groups that are tagged with keys called owner and
	// environment. If you specify both of these tag keys in the request, Amazon
	// Redshift returns a response with the parameter groups that have either or
	// both of these tag keys associated with them.
	TagKeys []string `locationNameList:"TagKey" type:"list"`

	// A tag value or values for which you want to return all matching cluster parameter
	// groups that are associated with the specified tag value or values. For example,
	// suppose that you have parameter groups that are tagged with values called
	// admin and test. If you specify both of these tag values in the request, Amazon
	// Redshift returns a response with the parameter groups that have either or
	// both of these tag values associated with them.
	TagValues []string `locationNameList:"TagValue" type:"list"`
}

// String returns the string representation
func (s DescribeClusterParameterGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// Contains the output from the DescribeClusterParameterGroups action.
type DescribeClusterParameterGroupsOutput struct {
	_ struct{} `type:"structure"`

	// A value that indicates the starting point for the next set of response records
	// in a subsequent request. If a value is returned in a response, you can retrieve
	// the next set of records by providing this returned marker value in the Marker
	// parameter and retrying the command. If the Marker field is empty, all response
	// records have been retrieved for the request.
	Marker *string `type:"string"`

	// A list of ClusterParameterGroup instances. Each instance describes one cluster
	// parameter group.
	ParameterGroups []ClusterParameterGroup `locationNameList:"ClusterParameterGroup" type:"list"`
}

// String returns the string representation
func (s DescribeClusterParameterGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeClusterParameterGroups = "DescribeClusterParameterGroups"

// DescribeClusterParameterGroupsRequest returns a request value for making API operation for
// Amazon Redshift.
//
// Returns a list of Amazon Redshift parameter groups, including parameter groups
// you created and the default parameter group. For each parameter group, the
// response includes the parameter group name, description, and parameter group
// family name. You can optionally specify a name to retrieve the description
// of a specific parameter group.
//
// For more information about parameters and parameter groups, go to Amazon
// Redshift Parameter Groups (https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html)
// in the Amazon Redshift Cluster Management Guide.
//
// If you specify both tag keys and tag values in the same request, Amazon Redshift
// returns all parameter groups that match any combination of the specified
// keys and values. For example, if you have owner and environment for tag keys,
// and admin and test for tag values, all parameter groups that have any combination
// of those values are returned.
//
// If both tag keys and values are omitted from the request, parameter groups
// are returned regardless of whether they have tag keys or values associated
// with them.
//
//    // Example sending a request using DescribeClusterParameterGroupsRequest.
//    req := client.DescribeClusterParameterGroupsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterParameterGroups
func (c *Client) DescribeClusterParameterGroupsRequest(input *DescribeClusterParameterGroupsInput) DescribeClusterParameterGroupsRequest {
	op := &aws.Operation{
		Name:       opDescribeClusterParameterGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeClusterParameterGroupsInput{}
	}

	req := c.newRequest(op, input, &DescribeClusterParameterGroupsOutput{})
	return DescribeClusterParameterGroupsRequest{Request: req, Input: input, Copy: c.DescribeClusterParameterGroupsRequest}
}

// DescribeClusterParameterGroupsRequest is the request type for the
// DescribeClusterParameterGroups API operation.
type DescribeClusterParameterGroupsRequest struct {
	*aws.Request
	Input *DescribeClusterParameterGroupsInput
	Copy  func(*DescribeClusterParameterGroupsInput) DescribeClusterParameterGroupsRequest
}

// Send marshals and sends the DescribeClusterParameterGroups API request.
func (r DescribeClusterParameterGroupsRequest) Send(ctx context.Context) (*DescribeClusterParameterGroupsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeClusterParameterGroupsResponse{
		DescribeClusterParameterGroupsOutput: r.Request.Data.(*DescribeClusterParameterGroupsOutput),
		response:                             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewDescribeClusterParameterGroupsRequestPaginator returns a paginator for DescribeClusterParameterGroups.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.DescribeClusterParameterGroupsRequest(input)
//   p := redshift.NewDescribeClusterParameterGroupsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewDescribeClusterParameterGroupsPaginator(req DescribeClusterParameterGroupsRequest) DescribeClusterParameterGroupsPaginator {
	return DescribeClusterParameterGroupsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *DescribeClusterParameterGroupsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// DescribeClusterParameterGroupsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribeClusterParameterGroupsPaginator struct {
	aws.Pager
}

func (p *DescribeClusterParameterGroupsPaginator) CurrentPage() *DescribeClusterParameterGroupsOutput {
	return p.Pager.CurrentPage().(*DescribeClusterParameterGroupsOutput)
}

// DescribeClusterParameterGroupsResponse is the response type for the
// DescribeClusterParameterGroups API operation.
type DescribeClusterParameterGroupsResponse struct {
	*DescribeClusterParameterGroupsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeClusterParameterGroups request.
func (r *DescribeClusterParameterGroupsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
