package devfile

import (
	"encoding/json"
	"reflect"
	"testing"

	"github.com/devfile/registry-support/index/generator/schema"
)

func TestGetRegistrySamples(t *testing.T) {

	nodejsBase64Image := "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"

	quarkusBase64Image := "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"

	springBootBase64Image := "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"

	pythonBase64Image := "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"

	tests := []struct {
		name        string
		registry    string
		wantSamples []schema.Schema
		wantErr     bool
	}{
		{
			name:     "Fetch the sample placeholder",
			registry: "sample-placeholder",
			wantSamples: []schema.Schema{
				{
					Name:        "nodejs-basic",
					DisplayName: "Basic NodeJS",
					Description: "A simple Hello world NodeJS application",
					Tags:        []string{"NodeJS", "Express"},
					Icon:        nodejsBase64Image,
					Type:        schema.SampleDevfileType,
					ProjectType: "nodejs",
					Language:    "nodejs",
					Git: &schema.Git{
						Remotes: map[string]string{
							"origin": "https://github.com/redhat-developer/devfile-sample.git",
						},
					},
				},
				{
					Name:        "code-with-quarkus",
					DisplayName: "Basic Quarkus",
					Description: "A simple Hello World Java application using Quarkus",
					Tags:        []string{"Java", "Quarkus"},
					Icon:        quarkusBase64Image,
					Type:        schema.SampleDevfileType,
					ProjectType: "quarkus",
					Language:    "java",
					Git: &schema.Git{
						Remotes: map[string]string{
							"origin": "https://github.com/elsony/devfile-sample-code-with-quarkus.git",
						},
					},
				},
				{
					Name:        "java-springboot-basic",
					DisplayName: "Basic Spring Boot",
					Description: "A simple Hello World Java Spring Boot application using Maven",
					Tags:        []string{"Java", "Spring"},
					Icon:        springBootBase64Image,
					Type:        schema.SampleDevfileType,
					ProjectType: "springboot",
					Language:    "java",
					Git: &schema.Git{
						Remotes: map[string]string{
							"origin": "https://github.com/elsony/devfile-sample-java-springboot-basic.git",
						},
					},
				},
				{
					Name:        "python-basic",
					DisplayName: "Basic Python",
					Description: "A simple Hello World application using Python",
					Tags:        []string{"Python"},
					Icon:        pythonBase64Image,
					Type:        schema.SampleDevfileType,
					ProjectType: "python",
					Language:    "python",
					Git: &schema.Git{
						Remotes: map[string]string{
							"origin": "https://github.com/elsony/devfile-sample-python-basic.git",
						},
					},
				},
			},
		},
		{
			name:     "Invalid registry",
			registry: "invalid",
			wantErr:  true,
		},
	}
	for _, tt := range tests {
		t.Run(tt.name, func(t *testing.T) {
			bytes, err := GetRegistrySamples(tt.registry)
			if tt.wantErr && err == nil {
				t.Errorf("Expected error from test but got nil")
			} else if !tt.wantErr && err != nil {
				t.Errorf("Got unexpected error: %s", err)
			} else if !tt.wantErr {
				var registryIndex []schema.Schema
				err = json.Unmarshal(bytes, &registryIndex)
				if err != nil {
					t.Errorf("Got unexpected error: %s", err)
					return
				}

				if !reflect.DeepEqual(registryIndex, tt.wantSamples) {
					t.Errorf("expected %+v does not match actual %+v", registryIndex, tt.wantSamples)
				}
			}
		})
	}
}
