// Code generated by go generate; DO NOT EDIT.
/*
Copyright 2019 HAProxy Technologies

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package tests

import (
	"fmt"
	"strings"
	"testing"

	"github.com/haproxytech/config-parser/v4/parsers"
)

func TestHashType(t *testing.T) {
	tests := map[string]bool{
		"hash-type map-based":                  true,
		"hash-type map-based avalanche":        true,
		"hash-type consistent":                 true,
		"hash-type consistent avalanche":       true,
		"hash-type avalanche":                  true,
		"hash-type map-based sdbm":             true,
		"hash-type map-based djb2":             true,
		"hash-type map-based wt6":              true,
		"hash-type map-based crc32":            true,
		"hash-type consistent sdbm":            true,
		"hash-type consistent djb2":            true,
		"hash-type consistent wt6":             true,
		"hash-type consistent crc32":           true,
		"hash-type map-based sdbm avalanche":   true,
		"hash-type map-based djb2 avalanche":   true,
		"hash-type map-based wt6 avalanche":    true,
		"hash-type map-based crc32 avalanche":  true,
		"hash-type consistent sdbm avalanche":  true,
		"hash-type consistent djb2 avalanche":  true,
		"hash-type consistent wt6 avalanche":   true,
		"hash-type consistent crc32 avalanche": true,
		"hash-type":                            false,
		"---":                                  false,
		"--- ---":                              false,
	}
	parser := &parsers.HashType{}
	for command, shouldPass := range tests {
		t.Run(command, func(t *testing.T) {
			line := strings.TrimSpace(command)
			lines := strings.SplitN(line, "\n", -1)
			var err error
			parser.Init()
			if len(lines) > 1 {
				for _, line = range lines {
					line = strings.TrimSpace(line)
					if err = ProcessLine(line, parser); err != nil {
						break
					}
				}
			} else {
				err = ProcessLine(line, parser)
			}
			if shouldPass {
				if err != nil {
					t.Errorf(err.Error())
					return
				}
				result, err := parser.Result()
				if err != nil {
					t.Errorf(err.Error())
					return
				}
				var returnLine string
				if result[0].Comment == "" {
					returnLine = result[0].Data
				} else {
					returnLine = fmt.Sprintf("%s # %s", result[0].Data, result[0].Comment)
				}
				if command != returnLine {
					t.Errorf(fmt.Sprintf("error: has [%s] expects [%s]", returnLine, command))
				}
			} else {
				if err == nil {
					t.Errorf(fmt.Sprintf("error: did not throw error for line [%s]", line))
				}
				_, parseErr := parser.Result()
				if parseErr == nil {
					t.Errorf(fmt.Sprintf("error: did not throw error on result for line [%s]", line))
				}
			}
		})
	}
}
