// Code generated by go generate; DO NOT EDIT.
/*
Copyright 2019 HAProxy Technologies

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package tests

import (
	"fmt"
	"strings"
	"testing"

	"github.com/haproxytech/config-parser/v4/parsers/http"
)

func TestRequestshttp(t *testing.T) {
	tests := map[string]bool{
		"http-request capture req.cook_cnt(FirstVisit),bool len 10":                                  true,
		"http-request deny deny_status 0 unless { src 127.0.0.1 }":                                   true,
		"http-request set-map(map.lst) %[src] %[req.hdr(X-Value)] if value":                          true,
		"http-request set-map(map.lst) %[src] %[req.hdr(X-Value)]":                                   true,
		"http-request add-acl(map.lst) [src]":                                                        true,
		"http-request add-header X-value value":                                                      true,
		"http-request cache-use cache-name":                                                          true,
		"http-request cache-use cache-name if FALSE":                                                 true,
		"http-request del-acl(map.lst) [src]":                                                        true,
		"http-request allow":                                                                         true,
		"http-request auth":                                                                          true,
		"http-request del-header X-value":                                                            true,
		"http-request del-map(map.lst) %[src] if ! value":                                            true,
		"http-request del-map(map.lst) %[src]":                                                       true,
		"http-request deny":                                                                          true,
		"http-request disable-l7-retry":                                                              true,
		"http-request disable-l7-retry if FALSE":                                                     true,
		"http-request early-hint hint %[src]":                                                        true,
		"http-request early-hint hint %[src] if FALSE":                                               true,
		"http-request early-hint if FALSE":                                                           true,
		"http-request lua.foo":                                                                       true,
		"http-request lua.foo if FALSE":                                                              true,
		"http-request lua.foo param":                                                                 true,
		"http-request lua.foo param param2":                                                          true,
		"http-request redirect prefix https://mysite.com":                                            true,
		"http-request reject":                                                                        true,
		"http-request replace-header User-agent curl foo":                                            true,
		"http-request replace-path (.*) /foo":                                                        true,
		"http-request replace-uri ^http://(.*) https://1":                                            true,
		"http-request replace-uri ^http://(.*) https://1 if FALSE":                                   true,
		"http-request replace-value X-Forwarded-For ^192.168.(.*)$ 172.16.1":                         true,
		"http-request sc-inc-gpc0(1)":                                                                true,
		"http-request sc-inc-gpc0(1) if FALSE":                                                       true,
		"http-request sc-inc-gpc1(1)":                                                                true,
		"http-request sc-inc-gpc1(1) if FALSE":                                                       true,
		"http-request sc-set-gpt0(1) hdr(Host),lower":                                                true,
		"http-request sc-set-gpt0(1) 10":                                                             true,
		"http-request sc-set-gpt0(1) hdr(Host),lower if FALSE":                                       true,
		"http-request send-spoe-group engine group":                                                  true,
		"http-request set-header X-value value":                                                      true,
		"http-request set-log-level silent":                                                          true,
		"http-request set-mark 20":                                                                   true,
		"http-request set-mark 0x1Ab":                                                                true,
		"http-request set-nice 0":                                                                    true,
		"http-request set-nice 0 if FALSE":                                                           true,
		"http-request set-method POST":                                                               true,
		"http-request set-method POST if FALSE":                                                      true,
		"http-request set-path /%[hdr(host)]%[path]":                                                 true,
		"http-request set-priority-class req.hdr(priority)":                                          true,
		"http-request set-priority-class req.hdr(priority) if FALSE":                                 true,
		"http-request set-priority-offset req.hdr(offset)":                                           true,
		"http-request set-priority-offset req.hdr(offset) if FALSE":                                  true,
		"http-request set-query %[query,regsub(%3D,=,g)]":                                            true,
		"http-request set-src hdr(src)":                                                              true,
		"http-request set-src hdr(src) if FALSE":                                                     true,
		"http-request set-src-port hdr(port)":                                                        true,
		"http-request set-src-port hdr(port) if FALSE":                                               true,
		"http-request set-tos 0 if FALSE":                                                            true,
		"http-request set-tos 0":                                                                     true,
		"http-request set-uri /%[hdr(host)]%[path]":                                                  true,
		"http-request set-var(req.my_var) req.fhdr(user-agent),lower":                                true,
		"http-request silent-drop":                                                                   true,
		"http-request silent-drop if FALSE":                                                          true,
		"http-request strict-mode on":                                                                true,
		"http-request strict-mode on if FALSE":                                                       true,
		"http-request tarpit":                                                                        true,
		"http-request track-sc0 src":                                                                 true,
		"http-request track-sc1 src":                                                                 true,
		"http-request track-sc2 src":                                                                 true,
		"http-request unset-var(req.my_var)":                                                         true,
		"http-request unset-var(req.my_var) if FALSE":                                                true,
		"http-request wait-for-handshake":                                                            true,
		"http-request wait-for-handshake if FALSE":                                                   true,
		"http-request do-resolve(txn.myip,mydns) hdr(Host),lower":                                    true,
		"http-request do-resolve(txn.myip,mydns) hdr(Host),lower if { var(txn.myip) -m found }":      true,
		"http-request do-resolve(txn.myip,mydns) hdr(Host),lower unless { var(txn.myip) -m found }":  true,
		"http-request do-resolve(txn.myip,mydns,ipv4) hdr(Host),lower":                               true,
		"http-request do-resolve(txn.myip,mydns,ipv6) hdr(Host),lower":                               true,
		"http-request set-dst var(txn.myip)":                                                         true,
		"http-request set-dst var(txn.myip) if { var(txn.myip) -m found }":                           true,
		"http-request set-dst var(txn.myip) unless { var(txn.myip) -m found }":                       true,
		"http-request set-dst-port hdr(x-port)":                                                      true,
		"http-request set-dst-port hdr(x-port) if { var(txn.myip) -m found }":                        true,
		"http-request set-dst-port hdr(x-port) unless { var(txn.myip) -m found }":                    true,
		"http-request set-dst-port int(4000)":                                                        true,
		"http-request return status 400 default-errorfiles if { var(txn.myip) -m found }":            true,
		"http-request return status 400 errorfile /my/fancy/errorfile if { var(txn.myip) -m found }": true,
		"http-request return status 400 errorfiles myerror if { var(txn.myip) -m found }":            true,
		`http-request add-header Authorization Basic\ eC1oYXByb3h5LXJlY3J1aXRzOlBlb3BsZSB3aG8gZGVjb2RlIG1lc3NhZ2VzIG9mdGVuIGxvdmUgd29ya2luZyBhdCBIQVByb3h5LiBEbyBub3QgYmUgc2h5LCBjb250YWN0IHVz`:  true,
		`http-request add-header Authorisation "Basic eC1oYXByb3h5LXJlY3J1aXRzOlBlb3BsZSB3aG8gZGVjb2RlIG1lc3NhZ2VzIG9mdGVuIGxvdmUgd29ya2luZyBhdCBIQVByb3h5LiBEbyBub3QgYmUgc2h5LCBjb250YWN0IHVz"`: true,
		`http-request return status 200 content-type "text/plain" string "My content" if { var(txn.myip) -m found }`:                                                                             true,
		`http-request return status 200 content-type "text/plain" string "My content" unless { var(txn.myip) -m found }`:                                                                         true,
		`http-request return content-type "text/plain" string "My content" if { var(txn.myip) -m found }`:                                                                                        true,
		`http-request return content-type 'text/plain' string 'My content' if { var(txn.myip) -m found }`:                                                                                        true,
		`http-request return content-type "text/plain" lf-string "Hello, you are: %[src]" if { var(txn.myip) -m found }`:                                                                         true,
		`http-request return content-type "text/plain" file /my/fancy/response/file if { var(txn.myip) -m found }`:                                                                               true,
		`http-request return content-type "text/plain" lf-file /my/fancy/lof/format/response/file if { var(txn.myip) -m found }`:                                                                 true,
		`http-request return content-type "text/plain" string "My content" hdr X-value value if { var(txn.myip) -m found }`:                                                                      true,
		`http-request return content-type "text/plain" string "My content" hdr X-value x-value hdr Y-value y-value if { var(txn.myip) -m found }`:                                                true,
		`http-request return content-type "text/plain" lf-string "Hello, you are: %[src]"`:                                                                                                       true,
		"http-request": false,
		"http-request capture req.cook_cnt(FirstVisit),bool strlen 10": false,
		"http-request set-map(map.lst) %[src]":                         false,
		"http-request add-acl(map.lst)":                                false,
		"http-request add-header X-value":                              false,
		"http-request cache-use":                                       false,
		"http-request cache-use if FALSE":                              false,
		"http-request del-acl(map.lst)":                                false,
		"http-request del-header":                                      false,
		"http-request del-map(map.lst)":                                false,
		"http-request early-hint hint":                                 false,
		"http-request early-hint hint if FALSE":                        false,
		"http-request lua.":                                            false,
		"http-request lua. if FALSE":                                   false,
		"http-request lua. param":                                      false,
		"http-request redirect prefix":                                 false,
		"http-request replace-header User-agent curl":                  false,
		"http-request replace-path (.*)":                               false,
		"http-request replace-uri ^http://(.*)":                        false,
		"http-request replace-uri":                                     false,
		"http-request replace-uri ^http://(.*) if FALSE":               false,
		"http-request replace-value X-Forwarded-For ^192.168.(.*)$":    false,
		"http-request sc-inc-gpc0":                                     false,
		"http-request sc-inc-gpc1":                                     false,
		"http-request sc-set-gpt0(1)":                                  false,
		"http-request sc-set-gpt0":                                     false,
		"http-request sc-set-gpt0(1) if FALSE":                         false,
		"http-request send-spoe-group engine":                          false,
		"http-request set-header X-value":                              false,
		"http-request set-log-level":                                   false,
		"http-request set-mark":                                        false,
		"http-request set-nice":                                        false,
		"http-request set-method":                                      false,
		"http-request set-path":                                        false,
		"http-request set-priority-class":                              false,
		"http-request set-priority-offset":                             false,
		"http-request set-query":                                       false,
		"http-request set-src":                                         false,
		"http-request set-src-port":                                    false,
		"http-request set-tos":                                         false,
		"http-request set-uri":                                         false,
		"http-request set-var(req.my_var)":                             false,
		"http-request strict-mode":                                     false,
		"http-request strict-mode if FALSE":                            false,
		"http-request track-sc0":                                       false,
		"http-request track-sc1":                                       false,
		"http-request track-sc2":                                       false,
		"http-request unset-var(req.)":                                 false,
		"http-request unset-var(req)":                                  false,
		"http-request do-resolve(txn.myip)":                            false,
		"http-request do-resolve(txn.myip,mydns)":                      false,
		"http-request do-resolve(txn.myip,mydns,ipv4)":                 false,
		"http-request set-dst":                                         false,
		"http-request set-dst-port":                                    false,
		"---":                                                          false,
		"--- ---":                                                      false,
	}
	parser := &http.Requests{}
	for command, shouldPass := range tests {
		t.Run(command, func(t *testing.T) {
			line := strings.TrimSpace(command)
			lines := strings.SplitN(line, "\n", -1)
			var err error
			parser.Init()
			if len(lines) > 1 {
				for _, line = range lines {
					line = strings.TrimSpace(line)
					if err = ProcessLine(line, parser); err != nil {
						break
					}
				}
			} else {
				err = ProcessLine(line, parser)
			}
			if shouldPass {
				if err != nil {
					t.Errorf(err.Error())
					return
				}
				result, err := parser.Result()
				if err != nil {
					t.Errorf(err.Error())
					return
				}
				var returnLine string
				if result[0].Comment == "" {
					returnLine = result[0].Data
				} else {
					returnLine = fmt.Sprintf("%s # %s", result[0].Data, result[0].Comment)
				}
				if command != returnLine {
					t.Errorf(fmt.Sprintf("error: has [%s] expects [%s]", returnLine, command))
				}
			} else {
				if err == nil {
					t.Errorf(fmt.Sprintf("error: did not throw error for line [%s]", line))
				}
				_, parseErr := parser.Result()
				if parseErr == nil {
					t.Errorf(fmt.Sprintf("error: did not throw error on result for line [%s]", line))
				}
			}
		})
	}
}
