# Single Group to Multi-Group

<aside class="note warning">

<h1>Note</h1>

Multi-group scaffolding support was not present in the initial version of
the KubeBuilder v2 scaffolding (as of KubeBuilder v2.0.0).

To change the layout of your project to support Multi-Group run the command
`kubebuilder edit --multigroup=true`. Once you switch to a multi-group layout, the new Kinds
will be generated in the new layout but additional manual work is needed 
to move the old API groups to the new layout.

</aside>

While KubeBuilder v2 will not scaffold out a project structure compatible
with multiple API groups in the same repository by default, it's possible
to modify the default project structure to support it.

Let's migrate the [CronJob example][cronjob-tutorial].

Generally, we use the prefix for the API group as the directory name. We
can check `api/v1/groupversion_info.go` to find that out:

```go
// +groupName=batch.tutorial.kubebuilder.io
package v1
```

Then, we'll rename `api` to `apis` to be more clear, and we'll move our
existing APIs into a new subdirectory, "batch":

```bash
mkdir apis/batch
mv api/* apis/batch
# After ensuring that all was moved successfully remove the old directory `api/`
rm -rf api/ 
```


After moving the APIs to a new directory, the same needs to be applied to the controllers:

```bash
mkdir controllers/batch
mv controllers/* controllers/batch/
```

Next, we'll need to update all the references to the old package name. 
For CronJob, that'll be `main.go` and `controllers/batch/cronjob_controller.go`. 

If you've added additional files to your project, you'll need to track down
imports there as well.

Finally, we'll run the command which enable the multi-group layout in the project:

```
kubebuilder edit --multigroup=true
```

When the command `kubebuilder edit --multigroup=true` is executed it will add a new line 
to `PROJECT` that marks this a multi-group project:
                                                      
```yaml
version: "2"
domain: tutorial.kubebuilder.io
repo: tutorial.kubebuilder.io/project
multigroup: true
```

Note that this option indicates to KubeBuilder that this is a multi-group project. 

In this way, if the project is not new and has previous APIs already implemented will be in the previous structure. 
Notice that with the `multi-group` project the Kind API's files are
created under `apis/<group>/<version>` instead of `api/<version>`. 
Also, note that the controllers will be created under `controllers/<group>` instead of `controllers`. 
That is the reason why we moved the previously generated APIs with the provided scripts in the previous steps. 
Remember to update the references afterwards.

The [CronJob tutorial][cronjob-tutorial] explains each of these changes in
more detail (in the context of how they're generated by KubeBuilder for
single-group projects).

[multi-group-issue]: https://github.com/kubernetes-sigs/kubebuilder/issues/923 "KubeBuilder Issue #923"
[cronjob-tutorial]: /cronjob-tutorial/cronjob-tutorial.md "Tutorial: Building CronJob"
