package relay

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/relay/mgmt/2016-07-01/relay"

// AuthorizationRule description of a Namespace AuthorizationRules.
type AuthorizationRule struct {
	autorest.Response `json:"-"`
	// AuthorizationRuleProperties - Authorization Rule properties
	*AuthorizationRuleProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AuthorizationRule.
func (ar AuthorizationRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ar.AuthorizationRuleProperties != nil {
		objectMap["properties"] = ar.AuthorizationRuleProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AuthorizationRule struct.
func (ar *AuthorizationRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var authorizationRuleProperties AuthorizationRuleProperties
				err = json.Unmarshal(*v, &authorizationRuleProperties)
				if err != nil {
					return err
				}
				ar.AuthorizationRuleProperties = &authorizationRuleProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ar.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ar.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ar.Type = &typeVar
			}
		}
	}

	return nil
}

// AuthorizationRuleKeys namespace/Relay Connection String
type AuthorizationRuleKeys struct {
	autorest.Response `json:"-"`
	// PrimaryConnectionString - PrimaryConnectionString of the created Namespace AuthorizationRule.
	PrimaryConnectionString *string `json:"primaryConnectionString,omitempty"`
	// SecondaryConnectionString - SecondaryConnectionString of the created Namespace AuthorizationRule
	SecondaryConnectionString *string `json:"secondaryConnectionString,omitempty"`
	// PrimaryKey - A base64-encoded 256-bit primary key for signing and validating the SAS token
	PrimaryKey *string `json:"primaryKey,omitempty"`
	// SecondaryKey - A base64-encoded 256-bit secondary key for signing and validating the SAS token
	SecondaryKey *string `json:"secondaryKey,omitempty"`
	// KeyName - A string that describes the authorization rule
	KeyName *string `json:"keyName,omitempty"`
}

// AuthorizationRuleListResult the response of the List Namespace operation.
type AuthorizationRuleListResult struct {
	autorest.Response `json:"-"`
	// Value - Result of the List AuthorizationRules operation.
	Value *[]AuthorizationRule `json:"value,omitempty"`
	// NextLink - Link to the next set of results. Not empty if Value contains incomplete list of AuthorizationRules
	NextLink *string `json:"nextLink,omitempty"`
}

// AuthorizationRuleListResultIterator provides access to a complete listing of AuthorizationRule values.
type AuthorizationRuleListResultIterator struct {
	i    int
	page AuthorizationRuleListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AuthorizationRuleListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AuthorizationRuleListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AuthorizationRuleListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AuthorizationRuleListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AuthorizationRuleListResultIterator) Response() AuthorizationRuleListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AuthorizationRuleListResultIterator) Value() AuthorizationRule {
	if !iter.page.NotDone() {
		return AuthorizationRule{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AuthorizationRuleListResultIterator type.
func NewAuthorizationRuleListResultIterator(page AuthorizationRuleListResultPage) AuthorizationRuleListResultIterator {
	return AuthorizationRuleListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (arlr AuthorizationRuleListResult) IsEmpty() bool {
	return arlr.Value == nil || len(*arlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (arlr AuthorizationRuleListResult) hasNextLink() bool {
	return arlr.NextLink != nil && len(*arlr.NextLink) != 0
}

// authorizationRuleListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (arlr AuthorizationRuleListResult) authorizationRuleListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !arlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(arlr.NextLink)))
}

// AuthorizationRuleListResultPage contains a page of AuthorizationRule values.
type AuthorizationRuleListResultPage struct {
	fn   func(context.Context, AuthorizationRuleListResult) (AuthorizationRuleListResult, error)
	arlr AuthorizationRuleListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AuthorizationRuleListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AuthorizationRuleListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.arlr)
		if err != nil {
			return err
		}
		page.arlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AuthorizationRuleListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AuthorizationRuleListResultPage) NotDone() bool {
	return !page.arlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AuthorizationRuleListResultPage) Response() AuthorizationRuleListResult {
	return page.arlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AuthorizationRuleListResultPage) Values() []AuthorizationRule {
	if page.arlr.IsEmpty() {
		return nil
	}
	return *page.arlr.Value
}

// Creates a new instance of the AuthorizationRuleListResultPage type.
func NewAuthorizationRuleListResultPage(cur AuthorizationRuleListResult, getNextPage func(context.Context, AuthorizationRuleListResult) (AuthorizationRuleListResult, error)) AuthorizationRuleListResultPage {
	return AuthorizationRuleListResultPage{
		fn:   getNextPage,
		arlr: cur,
	}
}

// AuthorizationRuleProperties authorizationRule properties.
type AuthorizationRuleProperties struct {
	// Rights - The rights associated with the rule.
	Rights *[]AccessRights `json:"rights,omitempty"`
}

// CheckNameAvailability description of a Check Name availability request properties.
type CheckNameAvailability struct {
	// Name - The Name to check the namespce name availability and The namespace name can contain only letters, numbers, and hyphens. The namespace must start with a letter, and it must end with a letter or number.
	Name *string `json:"name,omitempty"`
}

// CheckNameAvailabilityResult description of a Check Name availability request properties.
type CheckNameAvailabilityResult struct {
	autorest.Response `json:"-"`
	// NameAvailable - Value indicating namespace is availability, true if the namespace is available; otherwise, false.
	NameAvailable *bool `json:"nameAvailable,omitempty"`
	// Reason - The reason for unavailability of a namespace. Possible values include: 'None', 'InvalidName', 'SubscriptionIsDisabled', 'NameInUse', 'NameInLockdown', 'TooManyNamespaceInCurrentSubscription'
	Reason UnavailableReason `json:"reason,omitempty"`
	// Message - READ-ONLY; The detailed info regarding the reason associated with the namespace.
	Message *string `json:"message,omitempty"`
}

// MarshalJSON is the custom marshaler for CheckNameAvailabilityResult.
func (cnar CheckNameAvailabilityResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cnar.NameAvailable != nil {
		objectMap["nameAvailable"] = cnar.NameAvailable
	}
	if cnar.Reason != "" {
		objectMap["reason"] = cnar.Reason
	}
	return json.Marshal(objectMap)
}

// ErrorResponse error reponse indicates Relay service is not able to process the incoming request. The
// reason is provided in the error message.
type ErrorResponse struct {
	// Code - Error code.
	Code *string `json:"code,omitempty"`
	// Message - Error message indicating why the operation failed.
	Message *string `json:"message,omitempty"`
}

// HybridConnection description of HybridConnection Resource.
type HybridConnection struct {
	autorest.Response `json:"-"`
	// HybridConnectionProperties - Properties of HybridConnection
	*HybridConnectionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for HybridConnection.
func (hc HybridConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if hc.HybridConnectionProperties != nil {
		objectMap["properties"] = hc.HybridConnectionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for HybridConnection struct.
func (hc *HybridConnection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var hybridConnectionProperties HybridConnectionProperties
				err = json.Unmarshal(*v, &hybridConnectionProperties)
				if err != nil {
					return err
				}
				hc.HybridConnectionProperties = &hybridConnectionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				hc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				hc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				hc.Type = &typeVar
			}
		}
	}

	return nil
}

// HybridConnectionListResult the response of the List HybridConnection operation.
type HybridConnectionListResult struct {
	autorest.Response `json:"-"`
	// Value - Result of the List HybridConnection .
	Value *[]HybridConnection `json:"value,omitempty"`
	// NextLink - Link to the next set of results. Not empty if Value contains incomplete list of HybridConnection operation
	NextLink *string `json:"nextLink,omitempty"`
}

// HybridConnectionListResultIterator provides access to a complete listing of HybridConnection values.
type HybridConnectionListResultIterator struct {
	i    int
	page HybridConnectionListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *HybridConnectionListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HybridConnectionListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *HybridConnectionListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter HybridConnectionListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter HybridConnectionListResultIterator) Response() HybridConnectionListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter HybridConnectionListResultIterator) Value() HybridConnection {
	if !iter.page.NotDone() {
		return HybridConnection{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the HybridConnectionListResultIterator type.
func NewHybridConnectionListResultIterator(page HybridConnectionListResultPage) HybridConnectionListResultIterator {
	return HybridConnectionListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (hclr HybridConnectionListResult) IsEmpty() bool {
	return hclr.Value == nil || len(*hclr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (hclr HybridConnectionListResult) hasNextLink() bool {
	return hclr.NextLink != nil && len(*hclr.NextLink) != 0
}

// hybridConnectionListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (hclr HybridConnectionListResult) hybridConnectionListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !hclr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(hclr.NextLink)))
}

// HybridConnectionListResultPage contains a page of HybridConnection values.
type HybridConnectionListResultPage struct {
	fn   func(context.Context, HybridConnectionListResult) (HybridConnectionListResult, error)
	hclr HybridConnectionListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *HybridConnectionListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HybridConnectionListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.hclr)
		if err != nil {
			return err
		}
		page.hclr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *HybridConnectionListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page HybridConnectionListResultPage) NotDone() bool {
	return !page.hclr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page HybridConnectionListResultPage) Response() HybridConnectionListResult {
	return page.hclr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page HybridConnectionListResultPage) Values() []HybridConnection {
	if page.hclr.IsEmpty() {
		return nil
	}
	return *page.hclr.Value
}

// Creates a new instance of the HybridConnectionListResultPage type.
func NewHybridConnectionListResultPage(cur HybridConnectionListResult, getNextPage func(context.Context, HybridConnectionListResult) (HybridConnectionListResult, error)) HybridConnectionListResultPage {
	return HybridConnectionListResultPage{
		fn:   getNextPage,
		hclr: cur,
	}
}

// HybridConnectionProperties properties of the HybridConnection.
type HybridConnectionProperties struct {
	// CreatedAt - READ-ONLY; The time the HybridConnection was created.
	CreatedAt *date.Time `json:"createdAt,omitempty"`
	// UpdatedAt - READ-ONLY; The time the namespace was updated.
	UpdatedAt *date.Time `json:"updatedAt,omitempty"`
	// ListenerCount - READ-ONLY; The number of listeners for this HybridConnection. min : 1 and max:25 supported
	ListenerCount *int32 `json:"listenerCount,omitempty"`
	// RequiresClientAuthorization - true if client authorization is needed for this HybridConnection; otherwise, false.
	RequiresClientAuthorization *bool `json:"requiresClientAuthorization,omitempty"`
	// UserMetadata - usermetadata is a placeholder to store user-defined string data for the HybridConnection endpoint.e.g. it can be used to store  descriptive data, such as list of teams and their contact information also user-defined configuration settings can be stored.
	UserMetadata *string `json:"userMetadata,omitempty"`
}

// MarshalJSON is the custom marshaler for HybridConnectionProperties.
func (hcp HybridConnectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if hcp.RequiresClientAuthorization != nil {
		objectMap["requiresClientAuthorization"] = hcp.RequiresClientAuthorization
	}
	if hcp.UserMetadata != nil {
		objectMap["userMetadata"] = hcp.UserMetadata
	}
	return json.Marshal(objectMap)
}

// Namespace description of a Namespace resource.
type Namespace struct {
	autorest.Response `json:"-"`
	// Sku - Sku of the Namespace.
	Sku *Sku `json:"sku,omitempty"`
	// NamespaceProperties - Description of Relay Namespace
	*NamespaceProperties `json:"properties,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Namespace.
func (n Namespace) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if n.Sku != nil {
		objectMap["sku"] = n.Sku
	}
	if n.NamespaceProperties != nil {
		objectMap["properties"] = n.NamespaceProperties
	}
	if n.Location != nil {
		objectMap["location"] = n.Location
	}
	if n.Tags != nil {
		objectMap["tags"] = n.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Namespace struct.
func (n *Namespace) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				n.Sku = &sku
			}
		case "properties":
			if v != nil {
				var namespaceProperties NamespaceProperties
				err = json.Unmarshal(*v, &namespaceProperties)
				if err != nil {
					return err
				}
				n.NamespaceProperties = &namespaceProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				n.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				n.Tags = tags
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				n.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				n.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				n.Type = &typeVar
			}
		}
	}

	return nil
}

// NamespaceListResult the response of the List Namespace operation.
type NamespaceListResult struct {
	autorest.Response `json:"-"`
	// Value - Result of the List Namespace operation.
	Value *[]Namespace `json:"value,omitempty"`
	// NextLink - Link to the next set of results. Not empty if Value contains incomplete list of Namespaces
	NextLink *string `json:"nextLink,omitempty"`
}

// NamespaceListResultIterator provides access to a complete listing of Namespace values.
type NamespaceListResultIterator struct {
	i    int
	page NamespaceListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *NamespaceListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/NamespaceListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *NamespaceListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter NamespaceListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter NamespaceListResultIterator) Response() NamespaceListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter NamespaceListResultIterator) Value() Namespace {
	if !iter.page.NotDone() {
		return Namespace{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the NamespaceListResultIterator type.
func NewNamespaceListResultIterator(page NamespaceListResultPage) NamespaceListResultIterator {
	return NamespaceListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (nlr NamespaceListResult) IsEmpty() bool {
	return nlr.Value == nil || len(*nlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (nlr NamespaceListResult) hasNextLink() bool {
	return nlr.NextLink != nil && len(*nlr.NextLink) != 0
}

// namespaceListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (nlr NamespaceListResult) namespaceListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !nlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(nlr.NextLink)))
}

// NamespaceListResultPage contains a page of Namespace values.
type NamespaceListResultPage struct {
	fn  func(context.Context, NamespaceListResult) (NamespaceListResult, error)
	nlr NamespaceListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *NamespaceListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/NamespaceListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.nlr)
		if err != nil {
			return err
		}
		page.nlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *NamespaceListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page NamespaceListResultPage) NotDone() bool {
	return !page.nlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page NamespaceListResultPage) Response() NamespaceListResult {
	return page.nlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page NamespaceListResultPage) Values() []Namespace {
	if page.nlr.IsEmpty() {
		return nil
	}
	return *page.nlr.Value
}

// Creates a new instance of the NamespaceListResultPage type.
func NewNamespaceListResultPage(cur NamespaceListResult, getNextPage func(context.Context, NamespaceListResult) (NamespaceListResult, error)) NamespaceListResultPage {
	return NamespaceListResultPage{
		fn:  getNextPage,
		nlr: cur,
	}
}

// NamespaceProperties properties of the Namespace.
type NamespaceProperties struct {
	// ProvisioningState - READ-ONLY; Provisioning state of the namespace.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// CreatedAt - READ-ONLY; The time the namespace was created.
	CreatedAt *date.Time `json:"createdAt,omitempty"`
	// UpdatedAt - READ-ONLY; The time the namespace was updated.
	UpdatedAt *date.Time `json:"updatedAt,omitempty"`
	// ServiceBusEndpoint - READ-ONLY; Endpoint you can use to perform Service Bus operations.
	ServiceBusEndpoint *string `json:"serviceBusEndpoint,omitempty"`
	// MetricID - READ-ONLY; Identifier for Azure Insights metrics
	MetricID *string `json:"metricId,omitempty"`
}

// NamespacesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type NamespacesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(NamespacesClient) (Namespace, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *NamespacesCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for NamespacesCreateOrUpdateFuture.Result.
func (future *NamespacesCreateOrUpdateFuture) result(client NamespacesClient) (n Namespace, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "relay.NamespacesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		n.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("relay.NamespacesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if n.Response.Response, err = future.GetResult(sender); err == nil && n.Response.Response.StatusCode != http.StatusNoContent {
		n, err = client.CreateOrUpdateResponder(n.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "relay.NamespacesCreateOrUpdateFuture", "Result", n.Response.Response, "Failure responding to request")
		}
	}
	return
}

// NamespacesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type NamespacesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(NamespacesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *NamespacesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for NamespacesDeleteFuture.Result.
func (future *NamespacesDeleteFuture) result(client NamespacesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "relay.NamespacesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("relay.NamespacesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// NamespaceUpdateParameter parameters supplied to the Patch Namespace operation.
type NamespaceUpdateParameter struct {
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// Sku - The sku of the created namespace
	Sku *Sku `json:"sku,omitempty"`
}

// MarshalJSON is the custom marshaler for NamespaceUpdateParameter.
func (nup NamespaceUpdateParameter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if nup.Tags != nil {
		objectMap["tags"] = nup.Tags
	}
	if nup.Sku != nil {
		objectMap["sku"] = nup.Sku
	}
	return json.Marshal(objectMap)
}

// Operation a EventHub REST API operation
type Operation struct {
	// Name - READ-ONLY; Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
	// Display - The object that represents the operation.
	Display *OperationDisplay `json:"display,omitempty"`
}

// MarshalJSON is the custom marshaler for Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if o.Display != nil {
		objectMap["display"] = o.Display
	}
	return json.Marshal(objectMap)
}

// OperationDisplay the object that represents the operation.
type OperationDisplay struct {
	// Provider - READ-ONLY; Service provider: Microsoft.EventHub
	Provider *string `json:"provider,omitempty"`
	// Resource - READ-ONLY; Resource on which the operation is performed: Invoice, etc.
	Resource *string `json:"resource,omitempty"`
	// Operation - READ-ONLY; Operation type: Read, write, delete, etc.
	Operation *string `json:"operation,omitempty"`
}

// OperationListResult result of the request to list EventHub operations. It contains a list of operations
// and a URL link to get the next set of results.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of EventHub operations supported by the Microsoft.EventHub resource provider.
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationListResultIterator provides access to a complete listing of Operation values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListResultIterator type.
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return OperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (olr OperationListResult) hasNextLink() bool {
	return olr.NextLink != nil && len(*olr.NextLink) != 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !olr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of Operation values.
type OperationListResultPage struct {
	fn  func(context.Context, OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.olr)
		if err != nil {
			return err
		}
		page.olr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []Operation {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Creates a new instance of the OperationListResultPage type.
func NewOperationListResultPage(cur OperationListResult, getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return OperationListResultPage{
		fn:  getNextPage,
		olr: cur,
	}
}

// RegenerateKeysParameters parameters supplied to the Regenerate Authorization Rule operation.
type RegenerateKeysParameters struct {
	// PolicyKey - Key that needs to be regenerated. Possible values include: 'PrimaryKey', 'SecondaryKey'
	PolicyKey PolicyKey `json:"policyKey,omitempty"`
}

// Resource the Resource definition
type Resource struct {
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// Sku sku of the Namespace.
type Sku struct {
	// Name - Name of this Sku
	Name *string `json:"name,omitempty"`
	// Tier - The tier of this particular SKU
	Tier *string `json:"tier,omitempty"`
}

// TrackedResource definition of Resource
type TrackedResource struct {
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	return json.Marshal(objectMap)
}

// WcfRelay description of WcfRelays Resource.
type WcfRelay struct {
	autorest.Response `json:"-"`
	// WcfRelayProperties - Properties of WcfRelay
	*WcfRelayProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for WcfRelay.
func (wr WcfRelay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wr.WcfRelayProperties != nil {
		objectMap["properties"] = wr.WcfRelayProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for WcfRelay struct.
func (wr *WcfRelay) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var wcfRelayProperties WcfRelayProperties
				err = json.Unmarshal(*v, &wcfRelayProperties)
				if err != nil {
					return err
				}
				wr.WcfRelayProperties = &wcfRelayProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				wr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				wr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				wr.Type = &typeVar
			}
		}
	}

	return nil
}

// WcfRelayProperties properties of the WcfRelay Properties.
type WcfRelayProperties struct {
	// RelayType - WCFRelay Type. Possible values include: 'NetTCP', 'HTTP'
	RelayType RelaytypeEnum `json:"relayType,omitempty"`
	// CreatedAt - READ-ONLY; The time the WCFRelay was created.
	CreatedAt *date.Time `json:"createdAt,omitempty"`
	// UpdatedAt - READ-ONLY; The time the namespace was updated.
	UpdatedAt *date.Time `json:"updatedAt,omitempty"`
	// ListenerCount - READ-ONLY; The number of listeners for this relay. min : 1 and max:25 supported
	ListenerCount *int32 `json:"listenerCount,omitempty"`
	// RequiresClientAuthorization - true if client authorization is needed for this relay; otherwise, false.
	RequiresClientAuthorization *bool `json:"requiresClientAuthorization,omitempty"`
	// RequiresTransportSecurity - true if transport security is needed for this relay; otherwise, false.
	RequiresTransportSecurity *bool `json:"requiresTransportSecurity,omitempty"`
	// IsDynamic - READ-ONLY; true if the relay is dynamic; otherwise, false.
	IsDynamic *bool `json:"isDynamic,omitempty"`
	// UserMetadata - usermetadata is a placeholder to store user-defined string data for the HybridConnection endpoint.e.g. it can be used to store  descriptive data, such as list of teams and their contact information also user-defined configuration settings can be stored.
	UserMetadata *string `json:"userMetadata,omitempty"`
}

// MarshalJSON is the custom marshaler for WcfRelayProperties.
func (wrp WcfRelayProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wrp.RelayType != "" {
		objectMap["relayType"] = wrp.RelayType
	}
	if wrp.RequiresClientAuthorization != nil {
		objectMap["requiresClientAuthorization"] = wrp.RequiresClientAuthorization
	}
	if wrp.RequiresTransportSecurity != nil {
		objectMap["requiresTransportSecurity"] = wrp.RequiresTransportSecurity
	}
	if wrp.UserMetadata != nil {
		objectMap["userMetadata"] = wrp.UserMetadata
	}
	return json.Marshal(objectMap)
}

// WcfRelaysListResult the response of the List WcfRelays operation.
type WcfRelaysListResult struct {
	autorest.Response `json:"-"`
	// Value - Result of the List WcfRelays .
	Value *[]WcfRelay `json:"value,omitempty"`
	// NextLink - Link to the next set of results. Not empty if Value contains incomplete list of WcfRelays operation
	NextLink *string `json:"nextLink,omitempty"`
}

// WcfRelaysListResultIterator provides access to a complete listing of WcfRelay values.
type WcfRelaysListResultIterator struct {
	i    int
	page WcfRelaysListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *WcfRelaysListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WcfRelaysListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *WcfRelaysListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter WcfRelaysListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter WcfRelaysListResultIterator) Response() WcfRelaysListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter WcfRelaysListResultIterator) Value() WcfRelay {
	if !iter.page.NotDone() {
		return WcfRelay{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the WcfRelaysListResultIterator type.
func NewWcfRelaysListResultIterator(page WcfRelaysListResultPage) WcfRelaysListResultIterator {
	return WcfRelaysListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (wrlr WcfRelaysListResult) IsEmpty() bool {
	return wrlr.Value == nil || len(*wrlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (wrlr WcfRelaysListResult) hasNextLink() bool {
	return wrlr.NextLink != nil && len(*wrlr.NextLink) != 0
}

// wcfRelaysListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (wrlr WcfRelaysListResult) wcfRelaysListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !wrlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(wrlr.NextLink)))
}

// WcfRelaysListResultPage contains a page of WcfRelay values.
type WcfRelaysListResultPage struct {
	fn   func(context.Context, WcfRelaysListResult) (WcfRelaysListResult, error)
	wrlr WcfRelaysListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *WcfRelaysListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WcfRelaysListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.wrlr)
		if err != nil {
			return err
		}
		page.wrlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *WcfRelaysListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page WcfRelaysListResultPage) NotDone() bool {
	return !page.wrlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page WcfRelaysListResultPage) Response() WcfRelaysListResult {
	return page.wrlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page WcfRelaysListResultPage) Values() []WcfRelay {
	if page.wrlr.IsEmpty() {
		return nil
	}
	return *page.wrlr.Value
}

// Creates a new instance of the WcfRelaysListResultPage type.
func NewWcfRelaysListResultPage(cur WcfRelaysListResult, getNextPage func(context.Context, WcfRelaysListResult) (WcfRelaysListResult, error)) WcfRelaysListResultPage {
	return WcfRelaysListResultPage{
		fn:   getNextPage,
		wrlr: cur,
	}
}
