package customerinsights

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"github.com/shopspring/decimal"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/customerinsights/mgmt/2017-04-26/customerinsights"

// AssignmentPrincipal the AssignmentPrincipal
type AssignmentPrincipal struct {
	// PrincipalID - The principal id being assigned to.
	PrincipalID *string `json:"principalId,omitempty"`
	// PrincipalType - The Type of the principal ID.
	PrincipalType *string `json:"principalType,omitempty"`
	// PrincipalMetadata - Other metadata for the principal.
	PrincipalMetadata map[string]*string `json:"principalMetadata"`
}

// MarshalJSON is the custom marshaler for AssignmentPrincipal.
func (ap AssignmentPrincipal) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ap.PrincipalID != nil {
		objectMap["principalId"] = ap.PrincipalID
	}
	if ap.PrincipalType != nil {
		objectMap["principalType"] = ap.PrincipalType
	}
	if ap.PrincipalMetadata != nil {
		objectMap["principalMetadata"] = ap.PrincipalMetadata
	}
	return json.Marshal(objectMap)
}

// AuthorizationPolicy the authorization policy.
type AuthorizationPolicy struct {
	autorest.Response `json:"-"`
	// PolicyName - READ-ONLY; Name of the policy.
	PolicyName *string `json:"policyName,omitempty"`
	// Permissions - The permissions associated with the policy.
	Permissions *[]PermissionTypes `json:"permissions,omitempty"`
	// PrimaryKey - Primary key associated with the policy.
	PrimaryKey *string `json:"primaryKey,omitempty"`
	// SecondaryKey - Secondary key associated with the policy.
	SecondaryKey *string `json:"secondaryKey,omitempty"`
}

// MarshalJSON is the custom marshaler for AuthorizationPolicy.
func (ap AuthorizationPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ap.Permissions != nil {
		objectMap["permissions"] = ap.Permissions
	}
	if ap.PrimaryKey != nil {
		objectMap["primaryKey"] = ap.PrimaryKey
	}
	if ap.SecondaryKey != nil {
		objectMap["secondaryKey"] = ap.SecondaryKey
	}
	return json.Marshal(objectMap)
}

// AuthorizationPolicyListResult the response of list authorization policy operation.
type AuthorizationPolicyListResult struct {
	autorest.Response `json:"-"`
	// Value - Results of the list operation.
	Value *[]AuthorizationPolicyResourceFormat `json:"value,omitempty"`
	// NextLink - Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// AuthorizationPolicyListResultIterator provides access to a complete listing of
// AuthorizationPolicyResourceFormat values.
type AuthorizationPolicyListResultIterator struct {
	i    int
	page AuthorizationPolicyListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AuthorizationPolicyListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AuthorizationPolicyListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AuthorizationPolicyListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AuthorizationPolicyListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AuthorizationPolicyListResultIterator) Response() AuthorizationPolicyListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AuthorizationPolicyListResultIterator) Value() AuthorizationPolicyResourceFormat {
	if !iter.page.NotDone() {
		return AuthorizationPolicyResourceFormat{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AuthorizationPolicyListResultIterator type.
func NewAuthorizationPolicyListResultIterator(page AuthorizationPolicyListResultPage) AuthorizationPolicyListResultIterator {
	return AuthorizationPolicyListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (aplr AuthorizationPolicyListResult) IsEmpty() bool {
	return aplr.Value == nil || len(*aplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (aplr AuthorizationPolicyListResult) hasNextLink() bool {
	return aplr.NextLink != nil && len(*aplr.NextLink) != 0
}

// authorizationPolicyListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (aplr AuthorizationPolicyListResult) authorizationPolicyListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !aplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(aplr.NextLink)))
}

// AuthorizationPolicyListResultPage contains a page of AuthorizationPolicyResourceFormat values.
type AuthorizationPolicyListResultPage struct {
	fn   func(context.Context, AuthorizationPolicyListResult) (AuthorizationPolicyListResult, error)
	aplr AuthorizationPolicyListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AuthorizationPolicyListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AuthorizationPolicyListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.aplr)
		if err != nil {
			return err
		}
		page.aplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AuthorizationPolicyListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AuthorizationPolicyListResultPage) NotDone() bool {
	return !page.aplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AuthorizationPolicyListResultPage) Response() AuthorizationPolicyListResult {
	return page.aplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AuthorizationPolicyListResultPage) Values() []AuthorizationPolicyResourceFormat {
	if page.aplr.IsEmpty() {
		return nil
	}
	return *page.aplr.Value
}

// Creates a new instance of the AuthorizationPolicyListResultPage type.
func NewAuthorizationPolicyListResultPage(cur AuthorizationPolicyListResult, getNextPage func(context.Context, AuthorizationPolicyListResult) (AuthorizationPolicyListResult, error)) AuthorizationPolicyListResultPage {
	return AuthorizationPolicyListResultPage{
		fn:   getNextPage,
		aplr: cur,
	}
}

// AuthorizationPolicyResourceFormat the authorization policy resource format.
type AuthorizationPolicyResourceFormat struct {
	autorest.Response    `json:"-"`
	*AuthorizationPolicy `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AuthorizationPolicyResourceFormat.
func (aprf AuthorizationPolicyResourceFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if aprf.AuthorizationPolicy != nil {
		objectMap["properties"] = aprf.AuthorizationPolicy
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AuthorizationPolicyResourceFormat struct.
func (aprf *AuthorizationPolicyResourceFormat) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var authorizationPolicy AuthorizationPolicy
				err = json.Unmarshal(*v, &authorizationPolicy)
				if err != nil {
					return err
				}
				aprf.AuthorizationPolicy = &authorizationPolicy
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				aprf.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				aprf.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				aprf.Type = &typeVar
			}
		}
	}

	return nil
}

// AzureBlobConnectorProperties the Azure Blob connector properties.
type AzureBlobConnectorProperties struct {
	// ConnectionKeyVaultURL - The connection KeyVault URL.
	ConnectionKeyVaultURL *string `json:"connectionKeyVaultUrl,omitempty"`
}

// CanonicalProfileDefinition definition of canonical profile.
type CanonicalProfileDefinition struct {
	// CanonicalProfileID - Canonical profile ID.
	CanonicalProfileID *int32 `json:"canonicalProfileId,omitempty"`
	// Properties - Properties of the canonical profile.
	Properties *[]CanonicalProfileDefinitionPropertiesItem `json:"properties,omitempty"`
}

// CanonicalProfileDefinitionPropertiesItem the definition of a canonical profile property.
type CanonicalProfileDefinitionPropertiesItem struct {
	// ProfileName - Profile name.
	ProfileName *string `json:"profileName,omitempty"`
	// ProfilePropertyName - Property name of profile.
	ProfilePropertyName *string `json:"profilePropertyName,omitempty"`
	// Rank - The rank.
	Rank *int32 `json:"rank,omitempty"`
	// Type - Type of canonical property value. Possible values include: 'Numeric', 'Categorical', 'DerivedCategorical', 'DerivedNumeric'
	Type CanonicalPropertyValueType `json:"type,omitempty"`
	// Value - Value of the canonical property.
	Value *string `json:"value,omitempty"`
}

// Connector properties of connector.
type Connector struct {
	// ConnectorID - READ-ONLY; ID of the connector.
	ConnectorID *int32 `json:"connectorId,omitempty"`
	// ConnectorName - Name of the connector.
	ConnectorName *string `json:"connectorName,omitempty"`
	// ConnectorType - Type of connector. Possible values include: 'None', 'CRM', 'AzureBlob', 'Salesforce', 'ExchangeOnline', 'Outbound'
	ConnectorType ConnectorTypes `json:"connectorType,omitempty"`
	// DisplayName - Display name of the connector.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - Description of the connector.
	Description *string `json:"description,omitempty"`
	// ConnectorProperties - The connector properties.
	ConnectorProperties map[string]interface{} `json:"connectorProperties"`
	// Created - READ-ONLY; The created time.
	Created *date.Time `json:"created,omitempty"`
	// LastModified - READ-ONLY; The last modified time.
	LastModified *date.Time `json:"lastModified,omitempty"`
	// State - READ-ONLY; State of connector. Possible values include: 'ConnectorStatesCreating', 'ConnectorStatesCreated', 'ConnectorStatesReady', 'ConnectorStatesExpiring', 'ConnectorStatesDeleting', 'ConnectorStatesFailed'
	State ConnectorStates `json:"state,omitempty"`
	// TenantID - READ-ONLY; The hub name.
	TenantID *string `json:"tenantId,omitempty"`
	// IsInternal - If this is an internal connector.
	IsInternal *bool `json:"isInternal,omitempty"`
}

// MarshalJSON is the custom marshaler for Connector.
func (c Connector) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if c.ConnectorName != nil {
		objectMap["connectorName"] = c.ConnectorName
	}
	if c.ConnectorType != "" {
		objectMap["connectorType"] = c.ConnectorType
	}
	if c.DisplayName != nil {
		objectMap["displayName"] = c.DisplayName
	}
	if c.Description != nil {
		objectMap["description"] = c.Description
	}
	if c.ConnectorProperties != nil {
		objectMap["connectorProperties"] = c.ConnectorProperties
	}
	if c.IsInternal != nil {
		objectMap["isInternal"] = c.IsInternal
	}
	return json.Marshal(objectMap)
}

// ConnectorListResult the response of list connector operation.
type ConnectorListResult struct {
	autorest.Response `json:"-"`
	// Value - Results of the list operation.
	Value *[]ConnectorResourceFormat `json:"value,omitempty"`
	// NextLink - Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ConnectorListResultIterator provides access to a complete listing of ConnectorResourceFormat values.
type ConnectorListResultIterator struct {
	i    int
	page ConnectorListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ConnectorListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ConnectorListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ConnectorListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ConnectorListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ConnectorListResultIterator) Response() ConnectorListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ConnectorListResultIterator) Value() ConnectorResourceFormat {
	if !iter.page.NotDone() {
		return ConnectorResourceFormat{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ConnectorListResultIterator type.
func NewConnectorListResultIterator(page ConnectorListResultPage) ConnectorListResultIterator {
	return ConnectorListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (clr ConnectorListResult) IsEmpty() bool {
	return clr.Value == nil || len(*clr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (clr ConnectorListResult) hasNextLink() bool {
	return clr.NextLink != nil && len(*clr.NextLink) != 0
}

// connectorListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (clr ConnectorListResult) connectorListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !clr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(clr.NextLink)))
}

// ConnectorListResultPage contains a page of ConnectorResourceFormat values.
type ConnectorListResultPage struct {
	fn  func(context.Context, ConnectorListResult) (ConnectorListResult, error)
	clr ConnectorListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ConnectorListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ConnectorListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.clr)
		if err != nil {
			return err
		}
		page.clr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ConnectorListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ConnectorListResultPage) NotDone() bool {
	return !page.clr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ConnectorListResultPage) Response() ConnectorListResult {
	return page.clr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ConnectorListResultPage) Values() []ConnectorResourceFormat {
	if page.clr.IsEmpty() {
		return nil
	}
	return *page.clr.Value
}

// Creates a new instance of the ConnectorListResultPage type.
func NewConnectorListResultPage(cur ConnectorListResult, getNextPage func(context.Context, ConnectorListResult) (ConnectorListResult, error)) ConnectorListResultPage {
	return ConnectorListResultPage{
		fn:  getNextPage,
		clr: cur,
	}
}

// ConnectorMapping the connector mapping definition.
type ConnectorMapping struct {
	// ConnectorName - READ-ONLY; The connector name.
	ConnectorName *string `json:"connectorName,omitempty"`
	// ConnectorType - Type of connector. Possible values include: 'None', 'CRM', 'AzureBlob', 'Salesforce', 'ExchangeOnline', 'Outbound'
	ConnectorType ConnectorTypes `json:"connectorType,omitempty"`
	// Created - READ-ONLY; The created time.
	Created *date.Time `json:"created,omitempty"`
	// LastModified - READ-ONLY; The last modified time.
	LastModified *date.Time `json:"lastModified,omitempty"`
	// EntityType - Defines which entity type the file should map to. Possible values include: 'EntityTypesNone', 'EntityTypesProfile', 'EntityTypesInteraction', 'EntityTypesRelationship'
	EntityType EntityTypes `json:"entityType,omitempty"`
	// EntityTypeName - The mapping entity name.
	EntityTypeName *string `json:"entityTypeName,omitempty"`
	// ConnectorMappingName - READ-ONLY; The connector mapping name
	ConnectorMappingName *string `json:"connectorMappingName,omitempty"`
	// DisplayName - Display name for the connector mapping.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - The description of the connector mapping.
	Description *string `json:"description,omitempty"`
	// DataFormatID - READ-ONLY; The DataFormat ID.
	DataFormatID *string `json:"dataFormatId,omitempty"`
	// MappingProperties - The properties of the mapping.
	MappingProperties *ConnectorMappingProperties `json:"mappingProperties,omitempty"`
	// NextRunTime - READ-ONLY; The next run time based on customer's settings.
	NextRunTime *date.Time `json:"nextRunTime,omitempty"`
	// RunID - READ-ONLY; The RunId.
	RunID *string `json:"runId,omitempty"`
	// State - READ-ONLY; State of connector mapping. Possible values include: 'Creating', 'Created', 'Failed', 'Ready', 'Running', 'Stopped', 'Expiring'
	State ConnectorMappingStates `json:"state,omitempty"`
	// TenantID - READ-ONLY; The hub name.
	TenantID *string `json:"tenantId,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectorMapping.
func (cm ConnectorMapping) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cm.ConnectorType != "" {
		objectMap["connectorType"] = cm.ConnectorType
	}
	if cm.EntityType != "" {
		objectMap["entityType"] = cm.EntityType
	}
	if cm.EntityTypeName != nil {
		objectMap["entityTypeName"] = cm.EntityTypeName
	}
	if cm.DisplayName != nil {
		objectMap["displayName"] = cm.DisplayName
	}
	if cm.Description != nil {
		objectMap["description"] = cm.Description
	}
	if cm.MappingProperties != nil {
		objectMap["mappingProperties"] = cm.MappingProperties
	}
	return json.Marshal(objectMap)
}

// ConnectorMappingAvailability connector mapping property availability.
type ConnectorMappingAvailability struct {
	// Frequency - The frequency to update. Possible values include: 'FrequencyTypesMinute', 'FrequencyTypesHour', 'FrequencyTypesDay', 'FrequencyTypesWeek', 'FrequencyTypesMonth'
	Frequency FrequencyTypes `json:"frequency,omitempty"`
	// Interval - The interval of the given frequency to use.
	Interval *int32 `json:"interval,omitempty"`
}

// ConnectorMappingCompleteOperation the complete operation.
type ConnectorMappingCompleteOperation struct {
	// CompletionOperationType - The type of completion operation. Possible values include: 'DoNothing', 'DeleteFile', 'MoveFile'
	CompletionOperationType CompletionOperationTypes `json:"completionOperationType,omitempty"`
	// DestinationFolder - The destination folder where files will be moved to once the import is done.
	DestinationFolder *string `json:"destinationFolder,omitempty"`
}

// ConnectorMappingErrorManagement the error management.
type ConnectorMappingErrorManagement struct {
	// ErrorManagementType - The type of error management to use for the mapping. Possible values include: 'RejectAndContinue', 'StopImport', 'RejectUntilLimit'
	ErrorManagementType ErrorManagementTypes `json:"errorManagementType,omitempty"`
	// ErrorLimit - The error limit allowed while importing data.
	ErrorLimit *int32 `json:"errorLimit,omitempty"`
}

// ConnectorMappingFormat connector mapping property format.
type ConnectorMappingFormat struct {
	// FormatType - The type mapping format.
	FormatType *string `json:"formatType,omitempty"`
	// ColumnDelimiter - The character that signifies a break between columns.
	ColumnDelimiter *string `json:"columnDelimiter,omitempty"`
	// AcceptLanguage - The oData language.
	AcceptLanguage *string `json:"acceptLanguage,omitempty"`
	// QuoteCharacter - Quote character, used to indicate enquoted fields.
	QuoteCharacter *string `json:"quoteCharacter,omitempty"`
	// QuoteEscapeCharacter - Escape character for quotes, can be the same as the quoteCharacter.
	QuoteEscapeCharacter *string `json:"quoteEscapeCharacter,omitempty"`
	// ArraySeparator - Character separating array elements.
	ArraySeparator *string `json:"arraySeparator,omitempty"`
}

// ConnectorMappingListResult the response of list connector mapping operation.
type ConnectorMappingListResult struct {
	autorest.Response `json:"-"`
	// Value - Results of the list operation.
	Value *[]ConnectorMappingResourceFormat `json:"value,omitempty"`
	// NextLink - Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ConnectorMappingListResultIterator provides access to a complete listing of
// ConnectorMappingResourceFormat values.
type ConnectorMappingListResultIterator struct {
	i    int
	page ConnectorMappingListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ConnectorMappingListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ConnectorMappingListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ConnectorMappingListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ConnectorMappingListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ConnectorMappingListResultIterator) Response() ConnectorMappingListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ConnectorMappingListResultIterator) Value() ConnectorMappingResourceFormat {
	if !iter.page.NotDone() {
		return ConnectorMappingResourceFormat{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ConnectorMappingListResultIterator type.
func NewConnectorMappingListResultIterator(page ConnectorMappingListResultPage) ConnectorMappingListResultIterator {
	return ConnectorMappingListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (cmlr ConnectorMappingListResult) IsEmpty() bool {
	return cmlr.Value == nil || len(*cmlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (cmlr ConnectorMappingListResult) hasNextLink() bool {
	return cmlr.NextLink != nil && len(*cmlr.NextLink) != 0
}

// connectorMappingListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (cmlr ConnectorMappingListResult) connectorMappingListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !cmlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(cmlr.NextLink)))
}

// ConnectorMappingListResultPage contains a page of ConnectorMappingResourceFormat values.
type ConnectorMappingListResultPage struct {
	fn   func(context.Context, ConnectorMappingListResult) (ConnectorMappingListResult, error)
	cmlr ConnectorMappingListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ConnectorMappingListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ConnectorMappingListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.cmlr)
		if err != nil {
			return err
		}
		page.cmlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ConnectorMappingListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ConnectorMappingListResultPage) NotDone() bool {
	return !page.cmlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ConnectorMappingListResultPage) Response() ConnectorMappingListResult {
	return page.cmlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ConnectorMappingListResultPage) Values() []ConnectorMappingResourceFormat {
	if page.cmlr.IsEmpty() {
		return nil
	}
	return *page.cmlr.Value
}

// Creates a new instance of the ConnectorMappingListResultPage type.
func NewConnectorMappingListResultPage(cur ConnectorMappingListResult, getNextPage func(context.Context, ConnectorMappingListResult) (ConnectorMappingListResult, error)) ConnectorMappingListResultPage {
	return ConnectorMappingListResultPage{
		fn:   getNextPage,
		cmlr: cur,
	}
}

// ConnectorMappingProperties the connector mapping properties.
type ConnectorMappingProperties struct {
	// FolderPath - The folder path for the mapping.
	FolderPath *string `json:"folderPath,omitempty"`
	// FileFilter - The file filter for the mapping.
	FileFilter *string `json:"fileFilter,omitempty"`
	// HasHeader - If the file contains a header or not.
	HasHeader *bool `json:"hasHeader,omitempty"`
	// ErrorManagement - The error management setting for the mapping.
	ErrorManagement *ConnectorMappingErrorManagement `json:"errorManagement,omitempty"`
	// Format - The format of mapping property.
	Format *ConnectorMappingFormat `json:"format,omitempty"`
	// Availability - The availability of mapping property.
	Availability *ConnectorMappingAvailability `json:"availability,omitempty"`
	// Structure - Ingestion mapping information at property level.
	Structure *[]ConnectorMappingStructure `json:"structure,omitempty"`
	// CompleteOperation - The operation after import is done.
	CompleteOperation *ConnectorMappingCompleteOperation `json:"completeOperation,omitempty"`
}

// ConnectorMappingResourceFormat the connector mapping resource format.
type ConnectorMappingResourceFormat struct {
	autorest.Response `json:"-"`
	*ConnectorMapping `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectorMappingResourceFormat.
func (cmrf ConnectorMappingResourceFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cmrf.ConnectorMapping != nil {
		objectMap["properties"] = cmrf.ConnectorMapping
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ConnectorMappingResourceFormat struct.
func (cmrf *ConnectorMappingResourceFormat) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var connectorMapping ConnectorMapping
				err = json.Unmarshal(*v, &connectorMapping)
				if err != nil {
					return err
				}
				cmrf.ConnectorMapping = &connectorMapping
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				cmrf.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cmrf.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cmrf.Type = &typeVar
			}
		}
	}

	return nil
}

// ConnectorMappingStructure connector mapping property structure.
type ConnectorMappingStructure struct {
	// PropertyName - The property name of the mapping entity.
	PropertyName *string `json:"propertyName,omitempty"`
	// ColumnName - The column name of the import file.
	ColumnName *string `json:"columnName,omitempty"`
	// CustomFormatSpecifier - Custom format specifier for input parsing.
	CustomFormatSpecifier *string `json:"customFormatSpecifier,omitempty"`
	// IsEncrypted - Indicates if the column is encrypted.
	IsEncrypted *bool `json:"isEncrypted,omitempty"`
}

// ConnectorResourceFormat the connector resource format.
type ConnectorResourceFormat struct {
	autorest.Response `json:"-"`
	*Connector        `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectorResourceFormat.
func (crf ConnectorResourceFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if crf.Connector != nil {
		objectMap["properties"] = crf.Connector
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ConnectorResourceFormat struct.
func (crf *ConnectorResourceFormat) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var connector Connector
				err = json.Unmarshal(*v, &connector)
				if err != nil {
					return err
				}
				crf.Connector = &connector
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				crf.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				crf.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				crf.Type = &typeVar
			}
		}
	}

	return nil
}

// ConnectorsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ConnectorsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ConnectorsClient) (ConnectorResourceFormat, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ConnectorsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ConnectorsCreateOrUpdateFuture.Result.
func (future *ConnectorsCreateOrUpdateFuture) result(client ConnectorsClient) (crf ConnectorResourceFormat, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "customerinsights.ConnectorsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		crf.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("customerinsights.ConnectorsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if crf.Response.Response, err = future.GetResult(sender); err == nil && crf.Response.Response.StatusCode != http.StatusNoContent {
		crf, err = client.CreateOrUpdateResponder(crf.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "customerinsights.ConnectorsCreateOrUpdateFuture", "Result", crf.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ConnectorsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ConnectorsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ConnectorsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ConnectorsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ConnectorsDeleteFuture.Result.
func (future *ConnectorsDeleteFuture) result(client ConnectorsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "customerinsights.ConnectorsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("customerinsights.ConnectorsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// CrmConnectorEntities the CRM connector entities.
type CrmConnectorEntities struct {
	// LogicalName - The logical name.
	LogicalName *string `json:"logicalName,omitempty"`
	// DisplayName - The display name.
	DisplayName *string `json:"displayName,omitempty"`
	// IsProfile - Indicating whether this is profile.
	IsProfile *bool `json:"isProfile,omitempty"`
}

// CrmConnectorProperties the CRM connector properties.
type CrmConnectorProperties struct {
	// ConnectionString - The connection string.
	ConnectionString *string `json:"connectionString,omitempty"`
	// OrganizationID - The organization ID.
	OrganizationID *string `json:"organizationId,omitempty"`
	// OrganizationURL - The organization URL.
	OrganizationURL *string `json:"organizationUrl,omitempty"`
	// Entities - The entities like account, contact, opportunity.
	Entities *[]CrmConnectorEntities `json:"entities,omitempty"`
	// AccessToken - The access token.
	AccessToken *string `json:"accessToken,omitempty"`
}

// DataSource data Source is a way for us to know the source of instances. A single type can have data
// coming in from multiple places. In activities we use this to determine precedence rules.
type DataSource struct {
	// Name - READ-ONLY; The data source name
	Name *string `json:"name,omitempty"`
	// DataSourceType - READ-ONLY; The data source type. Possible values include: 'DataSourceTypeConnector', 'DataSourceTypeLinkInteraction', 'DataSourceTypeSystemDefault'
	DataSourceType DataSourceType `json:"dataSourceType,omitempty"`
	// Status - READ-ONLY; The data source status. Possible values include: 'StatusNone', 'StatusActive', 'StatusDeleted'
	Status Status `json:"status,omitempty"`
	// ID - READ-ONLY; The data source ID.
	ID *int32 `json:"id,omitempty"`
	// DataSourceReferenceID - READ-ONLY; The data source reference id.
	DataSourceReferenceID *string `json:"dataSourceReferenceId,omitempty"`
}

// DataSourcePrecedence the data source precedence is a way to know the precedence of each data source.
type DataSourcePrecedence struct {
	*DataSource `json:"dataSource,omitempty"`
	// Precedence - the precedence value.
	Precedence *int32 `json:"precedence,omitempty"`
}

// MarshalJSON is the custom marshaler for DataSourcePrecedence.
func (dsp DataSourcePrecedence) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dsp.DataSource != nil {
		objectMap["dataSource"] = dsp.DataSource
	}
	if dsp.Precedence != nil {
		objectMap["precedence"] = dsp.Precedence
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DataSourcePrecedence struct.
func (dsp *DataSourcePrecedence) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "dataSource":
			if v != nil {
				var dataSource DataSource
				err = json.Unmarshal(*v, &dataSource)
				if err != nil {
					return err
				}
				dsp.DataSource = &dataSource
			}
		case "precedence":
			if v != nil {
				var precedence int32
				err = json.Unmarshal(*v, &precedence)
				if err != nil {
					return err
				}
				dsp.Precedence = &precedence
			}
		}
	}

	return nil
}

// EnrichingKpi the enriching KPI definition.
type EnrichingKpi struct {
	// EntityType - The mapping entity type. Possible values include: 'EntityTypesNone', 'EntityTypesProfile', 'EntityTypesInteraction', 'EntityTypesRelationship'
	EntityType EntityTypes `json:"entityType,omitempty"`
	// EntityTypeName - The mapping entity name.
	EntityTypeName *string `json:"entityTypeName,omitempty"`
	// TenantID - READ-ONLY; The hub name.
	TenantID *string `json:"tenantId,omitempty"`
	// KpiName - READ-ONLY; The KPI name.
	KpiName *string `json:"kpiName,omitempty"`
	// DisplayName - Localized display name for the KPI.
	DisplayName map[string]*string `json:"displayName"`
	// Description - Localized description for the KPI.
	Description map[string]*string `json:"description"`
	// CalculationWindow - The calculation window. Possible values include: 'Lifetime', 'Hour', 'Day', 'Week', 'Month'
	CalculationWindow CalculationWindowTypes `json:"calculationWindow,omitempty"`
	// CalculationWindowFieldName - Name of calculation window field.
	CalculationWindowFieldName *string `json:"calculationWindowFieldName,omitempty"`
	// Function - The computation function for the KPI. Possible values include: 'KpiFunctionsSum', 'KpiFunctionsAvg', 'KpiFunctionsMin', 'KpiFunctionsMax', 'KpiFunctionsLast', 'KpiFunctionsCount', 'KpiFunctionsNone', 'KpiFunctionsCountDistinct'
	Function KpiFunctions `json:"function,omitempty"`
	// Expression - The computation expression for the KPI.
	Expression *string `json:"expression,omitempty"`
	// Unit - The unit of measurement for the KPI.
	Unit *string `json:"unit,omitempty"`
	// Filter - The filter expression for the KPI.
	Filter *string `json:"filter,omitempty"`
	// GroupBy - the group by properties for the KPI.
	GroupBy *[]string `json:"groupBy,omitempty"`
	// GroupByMetadata - READ-ONLY; The KPI GroupByMetadata.
	GroupByMetadata *[]KpiGroupByMetadata `json:"groupByMetadata,omitempty"`
	// ParticipantProfilesMetadata - READ-ONLY; The participant profiles.
	ParticipantProfilesMetadata *[]KpiParticipantProfilesMetadata `json:"participantProfilesMetadata,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning state. Possible values include: 'ProvisioningStatesProvisioning', 'ProvisioningStatesSucceeded', 'ProvisioningStatesExpiring', 'ProvisioningStatesDeleting', 'ProvisioningStatesHumanIntervention', 'ProvisioningStatesFailed'
	ProvisioningState ProvisioningStates `json:"provisioningState,omitempty"`
	// ThresHolds - The KPI thresholds.
	ThresHolds *KpiThresholds `json:"thresHolds,omitempty"`
	// Aliases - The aliases.
	Aliases *[]KpiAlias `json:"aliases,omitempty"`
	// Extracts - The KPI extracts.
	Extracts *[]KpiExtract `json:"extracts,omitempty"`
}

// MarshalJSON is the custom marshaler for EnrichingKpi.
func (ek EnrichingKpi) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ek.EntityType != "" {
		objectMap["entityType"] = ek.EntityType
	}
	if ek.EntityTypeName != nil {
		objectMap["entityTypeName"] = ek.EntityTypeName
	}
	if ek.DisplayName != nil {
		objectMap["displayName"] = ek.DisplayName
	}
	if ek.Description != nil {
		objectMap["description"] = ek.Description
	}
	if ek.CalculationWindow != "" {
		objectMap["calculationWindow"] = ek.CalculationWindow
	}
	if ek.CalculationWindowFieldName != nil {
		objectMap["calculationWindowFieldName"] = ek.CalculationWindowFieldName
	}
	if ek.Function != "" {
		objectMap["function"] = ek.Function
	}
	if ek.Expression != nil {
		objectMap["expression"] = ek.Expression
	}
	if ek.Unit != nil {
		objectMap["unit"] = ek.Unit
	}
	if ek.Filter != nil {
		objectMap["filter"] = ek.Filter
	}
	if ek.GroupBy != nil {
		objectMap["groupBy"] = ek.GroupBy
	}
	if ek.ThresHolds != nil {
		objectMap["thresHolds"] = ek.ThresHolds
	}
	if ek.Aliases != nil {
		objectMap["aliases"] = ek.Aliases
	}
	if ek.Extracts != nil {
		objectMap["extracts"] = ek.Extracts
	}
	return json.Marshal(objectMap)
}

// EntityTypeDefinition describes an entity.
type EntityTypeDefinition struct {
	// APIEntitySetName - The api entity set name. This becomes the odata entity set name for the entity Type being referred in this object.
	APIEntitySetName *string `json:"apiEntitySetName,omitempty"`
	// EntityType - Type of entity. Possible values include: 'EntityTypesNone', 'EntityTypesProfile', 'EntityTypesInteraction', 'EntityTypesRelationship'
	EntityType EntityTypes `json:"entityType,omitempty"`
	// Fields - The properties of the Profile.
	Fields *[]PropertyDefinition `json:"fields,omitempty"`
	// InstancesCount - The instance count.
	InstancesCount *int32 `json:"instancesCount,omitempty"`
	// LastChangedUtc - READ-ONLY; The last changed time for the type definition.
	LastChangedUtc *date.Time `json:"lastChangedUtc,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning state. Possible values include: 'ProvisioningStatesProvisioning', 'ProvisioningStatesSucceeded', 'ProvisioningStatesExpiring', 'ProvisioningStatesDeleting', 'ProvisioningStatesHumanIntervention', 'ProvisioningStatesFailed'
	ProvisioningState ProvisioningStates `json:"provisioningState,omitempty"`
	// SchemaItemTypeLink - The schema org link. This helps ACI identify and suggest semantic models.
	SchemaItemTypeLink *string `json:"schemaItemTypeLink,omitempty"`
	// TenantID - READ-ONLY; The hub name.
	TenantID *string `json:"tenantId,omitempty"`
	// TimestampFieldName - The timestamp property name. Represents the time when the interaction or profile update happened.
	TimestampFieldName *string `json:"timestampFieldName,omitempty"`
	// TypeName - The name of the entity.
	TypeName *string `json:"typeName,omitempty"`
	// Attributes - The attributes for the Type.
	Attributes map[string][]string `json:"attributes"`
	// Description - Localized descriptions for the property.
	Description map[string]*string `json:"description"`
	// DisplayName - Localized display names for the property.
	DisplayName map[string]*string `json:"displayName"`
	// LocalizedAttributes - Any custom localized attributes for the Type.
	LocalizedAttributes map[string]map[string]*string `json:"localizedAttributes"`
	// SmallImage - Small Image associated with the Property or EntityType.
	SmallImage *string `json:"smallImage,omitempty"`
	// MediumImage - Medium Image associated with the Property or EntityType.
	MediumImage *string `json:"mediumImage,omitempty"`
	// LargeImage - Large Image associated with the Property or EntityType.
	LargeImage *string `json:"largeImage,omitempty"`
}

// MarshalJSON is the custom marshaler for EntityTypeDefinition.
func (etd EntityTypeDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if etd.APIEntitySetName != nil {
		objectMap["apiEntitySetName"] = etd.APIEntitySetName
	}
	if etd.EntityType != "" {
		objectMap["entityType"] = etd.EntityType
	}
	if etd.Fields != nil {
		objectMap["fields"] = etd.Fields
	}
	if etd.InstancesCount != nil {
		objectMap["instancesCount"] = etd.InstancesCount
	}
	if etd.SchemaItemTypeLink != nil {
		objectMap["schemaItemTypeLink"] = etd.SchemaItemTypeLink
	}
	if etd.TimestampFieldName != nil {
		objectMap["timestampFieldName"] = etd.TimestampFieldName
	}
	if etd.TypeName != nil {
		objectMap["typeName"] = etd.TypeName
	}
	if etd.Attributes != nil {
		objectMap["attributes"] = etd.Attributes
	}
	if etd.Description != nil {
		objectMap["description"] = etd.Description
	}
	if etd.DisplayName != nil {
		objectMap["displayName"] = etd.DisplayName
	}
	if etd.LocalizedAttributes != nil {
		objectMap["localizedAttributes"] = etd.LocalizedAttributes
	}
	if etd.SmallImage != nil {
		objectMap["smallImage"] = etd.SmallImage
	}
	if etd.MediumImage != nil {
		objectMap["mediumImage"] = etd.MediumImage
	}
	if etd.LargeImage != nil {
		objectMap["largeImage"] = etd.LargeImage
	}
	return json.Marshal(objectMap)
}

// GetImageUploadURLInput input type for getting image upload url.
type GetImageUploadURLInput struct {
	// EntityType - Type of entity. Can be Profile or Interaction.
	EntityType *string `json:"entityType,omitempty"`
	// EntityTypeName - Name of the entity type.
	EntityTypeName *string `json:"entityTypeName,omitempty"`
	// RelativePath - Relative path of the image.
	RelativePath *string `json:"relativePath,omitempty"`
}

// Hub hub resource.
type Hub struct {
	autorest.Response    `json:"-"`
	*HubPropertiesFormat `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Hub.
func (h Hub) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if h.HubPropertiesFormat != nil {
		objectMap["properties"] = h.HubPropertiesFormat
	}
	if h.Location != nil {
		objectMap["location"] = h.Location
	}
	if h.Tags != nil {
		objectMap["tags"] = h.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Hub struct.
func (h *Hub) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var hubPropertiesFormat HubPropertiesFormat
				err = json.Unmarshal(*v, &hubPropertiesFormat)
				if err != nil {
					return err
				}
				h.HubPropertiesFormat = &hubPropertiesFormat
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				h.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				h.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				h.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				h.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				h.Tags = tags
			}
		}
	}

	return nil
}

// HubBillingInfoFormat hub billing info.
type HubBillingInfoFormat struct {
	// SkuName - The sku name.
	SkuName *string `json:"skuName,omitempty"`
	// MinUnits - The minimum number of units will be billed. One unit is 10,000 Profiles and 100,000 Interactions.
	MinUnits *int32 `json:"minUnits,omitempty"`
	// MaxUnits - The maximum number of units can be used.  One unit is 10,000 Profiles and 100,000 Interactions.
	MaxUnits *int32 `json:"maxUnits,omitempty"`
}

// HubListResult response of list hub operation.
type HubListResult struct {
	autorest.Response `json:"-"`
	// Value - Results of the list operation.
	Value *[]Hub `json:"value,omitempty"`
	// NextLink - Link for next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// HubListResultIterator provides access to a complete listing of Hub values.
type HubListResultIterator struct {
	i    int
	page HubListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *HubListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HubListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *HubListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter HubListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter HubListResultIterator) Response() HubListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter HubListResultIterator) Value() Hub {
	if !iter.page.NotDone() {
		return Hub{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the HubListResultIterator type.
func NewHubListResultIterator(page HubListResultPage) HubListResultIterator {
	return HubListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (hlr HubListResult) IsEmpty() bool {
	return hlr.Value == nil || len(*hlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (hlr HubListResult) hasNextLink() bool {
	return hlr.NextLink != nil && len(*hlr.NextLink) != 0
}

// hubListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (hlr HubListResult) hubListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !hlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(hlr.NextLink)))
}

// HubListResultPage contains a page of Hub values.
type HubListResultPage struct {
	fn  func(context.Context, HubListResult) (HubListResult, error)
	hlr HubListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *HubListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HubListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.hlr)
		if err != nil {
			return err
		}
		page.hlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *HubListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page HubListResultPage) NotDone() bool {
	return !page.hlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page HubListResultPage) Response() HubListResult {
	return page.hlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page HubListResultPage) Values() []Hub {
	if page.hlr.IsEmpty() {
		return nil
	}
	return *page.hlr.Value
}

// Creates a new instance of the HubListResultPage type.
func NewHubListResultPage(cur HubListResult, getNextPage func(context.Context, HubListResult) (HubListResult, error)) HubListResultPage {
	return HubListResultPage{
		fn:  getNextPage,
		hlr: cur,
	}
}

// HubPropertiesFormat properties of hub.
type HubPropertiesFormat struct {
	// APIEndpoint - READ-ONLY; API endpoint URL of the hub.
	APIEndpoint *string `json:"apiEndpoint,omitempty"`
	// WebEndpoint - READ-ONLY; Web endpoint URL of the hub.
	WebEndpoint *string `json:"webEndpoint,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning state of the hub.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// TenantFeatures - The bit flags for enabled hub features. Bit 0 is set to 1 indicates graph is enabled, or disabled if set to 0. Bit 1 is set to 1 indicates the hub is disabled, or enabled if set to 0.
	TenantFeatures *int32 `json:"tenantFeatures,omitempty"`
	// HubBillingInfo - Billing settings of the hub.
	HubBillingInfo *HubBillingInfoFormat `json:"hubBillingInfo,omitempty"`
}

// MarshalJSON is the custom marshaler for HubPropertiesFormat.
func (hpf HubPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if hpf.TenantFeatures != nil {
		objectMap["tenantFeatures"] = hpf.TenantFeatures
	}
	if hpf.HubBillingInfo != nil {
		objectMap["hubBillingInfo"] = hpf.HubBillingInfo
	}
	return json.Marshal(objectMap)
}

// HubsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type HubsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(HubsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *HubsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for HubsDeleteFuture.Result.
func (future *HubsDeleteFuture) result(client HubsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "customerinsights.HubsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("customerinsights.HubsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ImageDefinition the image definition.
type ImageDefinition struct {
	autorest.Response `json:"-"`
	// ImageExists - Whether image exists already.
	ImageExists *bool `json:"imageExists,omitempty"`
	// ContentURL - Content URL for the image blob.
	ContentURL *string `json:"contentUrl,omitempty"`
	// RelativePath - Relative path of the image.
	RelativePath *string `json:"relativePath,omitempty"`
}

// InteractionListResult the response of list interaction operation.
type InteractionListResult struct {
	autorest.Response `json:"-"`
	// Value - Results of the list operation.
	Value *[]InteractionResourceFormat `json:"value,omitempty"`
	// NextLink - Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// InteractionListResultIterator provides access to a complete listing of InteractionResourceFormat values.
type InteractionListResultIterator struct {
	i    int
	page InteractionListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *InteractionListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/InteractionListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *InteractionListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter InteractionListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter InteractionListResultIterator) Response() InteractionListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter InteractionListResultIterator) Value() InteractionResourceFormat {
	if !iter.page.NotDone() {
		return InteractionResourceFormat{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the InteractionListResultIterator type.
func NewInteractionListResultIterator(page InteractionListResultPage) InteractionListResultIterator {
	return InteractionListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ilr InteractionListResult) IsEmpty() bool {
	return ilr.Value == nil || len(*ilr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ilr InteractionListResult) hasNextLink() bool {
	return ilr.NextLink != nil && len(*ilr.NextLink) != 0
}

// interactionListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ilr InteractionListResult) interactionListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !ilr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ilr.NextLink)))
}

// InteractionListResultPage contains a page of InteractionResourceFormat values.
type InteractionListResultPage struct {
	fn  func(context.Context, InteractionListResult) (InteractionListResult, error)
	ilr InteractionListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *InteractionListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/InteractionListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ilr)
		if err != nil {
			return err
		}
		page.ilr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *InteractionListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page InteractionListResultPage) NotDone() bool {
	return !page.ilr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page InteractionListResultPage) Response() InteractionListResult {
	return page.ilr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page InteractionListResultPage) Values() []InteractionResourceFormat {
	if page.ilr.IsEmpty() {
		return nil
	}
	return *page.ilr.Value
}

// Creates a new instance of the InteractionListResultPage type.
func NewInteractionListResultPage(cur InteractionListResult, getNextPage func(context.Context, InteractionListResult) (InteractionListResult, error)) InteractionListResultPage {
	return InteractionListResultPage{
		fn:  getNextPage,
		ilr: cur,
	}
}

// InteractionResourceFormat the interaction resource format.
type InteractionResourceFormat struct {
	autorest.Response          `json:"-"`
	*InteractionTypeDefinition `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for InteractionResourceFormat.
func (irf InteractionResourceFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if irf.InteractionTypeDefinition != nil {
		objectMap["properties"] = irf.InteractionTypeDefinition
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for InteractionResourceFormat struct.
func (irf *InteractionResourceFormat) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var interactionTypeDefinition InteractionTypeDefinition
				err = json.Unmarshal(*v, &interactionTypeDefinition)
				if err != nil {
					return err
				}
				irf.InteractionTypeDefinition = &interactionTypeDefinition
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				irf.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				irf.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				irf.Type = &typeVar
			}
		}
	}

	return nil
}

// InteractionsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type InteractionsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(InteractionsClient) (InteractionResourceFormat, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *InteractionsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for InteractionsCreateOrUpdateFuture.Result.
func (future *InteractionsCreateOrUpdateFuture) result(client InteractionsClient) (irf InteractionResourceFormat, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "customerinsights.InteractionsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		irf.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("customerinsights.InteractionsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if irf.Response.Response, err = future.GetResult(sender); err == nil && irf.Response.Response.StatusCode != http.StatusNoContent {
		irf, err = client.CreateOrUpdateResponder(irf.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "customerinsights.InteractionsCreateOrUpdateFuture", "Result", irf.Response.Response, "Failure responding to request")
		}
	}
	return
}

// InteractionTypeDefinition the Interaction Type Definition
type InteractionTypeDefinition struct {
	// IDPropertyNames - The id property names. Properties which uniquely identify an interaction instance.
	IDPropertyNames *[]string `json:"idPropertyNames,omitempty"`
	// ParticipantProfiles - Profiles that participated in the interaction.
	ParticipantProfiles *[]Participant `json:"participantProfiles,omitempty"`
	// PrimaryParticipantProfilePropertyName - The primary participant property name for an interaction ,This is used to logically represent the agent of the interaction, Specify the participant name here from ParticipantName.
	PrimaryParticipantProfilePropertyName *string `json:"primaryParticipantProfilePropertyName,omitempty"`
	// DataSourcePrecedenceRules - READ-ONLY; This is specific to interactions modeled as activities. Data sources are used to determine where data is stored and also in precedence rules.
	DataSourcePrecedenceRules *[]DataSourcePrecedence `json:"dataSourcePrecedenceRules,omitempty"`
	// DataSource - Default data source is specifically used in cases where data source is not specified in an instance.
	*DataSource `json:"defaultDataSource,omitempty"`
	// IsActivity - An interaction can be tagged as an activity only during create. This enables the interaction to be editable and can enable merging of properties from multiple data sources based on precedence, which is defined at a link level.
	IsActivity *bool `json:"isActivity,omitempty"`
	// APIEntitySetName - The api entity set name. This becomes the odata entity set name for the entity Type being referred in this object.
	APIEntitySetName *string `json:"apiEntitySetName,omitempty"`
	// EntityType - Type of entity. Possible values include: 'EntityTypesNone', 'EntityTypesProfile', 'EntityTypesInteraction', 'EntityTypesRelationship'
	EntityType EntityTypes `json:"entityType,omitempty"`
	// Fields - The properties of the Profile.
	Fields *[]PropertyDefinition `json:"fields,omitempty"`
	// InstancesCount - The instance count.
	InstancesCount *int32 `json:"instancesCount,omitempty"`
	// LastChangedUtc - READ-ONLY; The last changed time for the type definition.
	LastChangedUtc *date.Time `json:"lastChangedUtc,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning state. Possible values include: 'ProvisioningStatesProvisioning', 'ProvisioningStatesSucceeded', 'ProvisioningStatesExpiring', 'ProvisioningStatesDeleting', 'ProvisioningStatesHumanIntervention', 'ProvisioningStatesFailed'
	ProvisioningState ProvisioningStates `json:"provisioningState,omitempty"`
	// SchemaItemTypeLink - The schema org link. This helps ACI identify and suggest semantic models.
	SchemaItemTypeLink *string `json:"schemaItemTypeLink,omitempty"`
	// TenantID - READ-ONLY; The hub name.
	TenantID *string `json:"tenantId,omitempty"`
	// TimestampFieldName - The timestamp property name. Represents the time when the interaction or profile update happened.
	TimestampFieldName *string `json:"timestampFieldName,omitempty"`
	// TypeName - The name of the entity.
	TypeName *string `json:"typeName,omitempty"`
	// Attributes - The attributes for the Type.
	Attributes map[string][]string `json:"attributes"`
	// Description - Localized descriptions for the property.
	Description map[string]*string `json:"description"`
	// DisplayName - Localized display names for the property.
	DisplayName map[string]*string `json:"displayName"`
	// LocalizedAttributes - Any custom localized attributes for the Type.
	LocalizedAttributes map[string]map[string]*string `json:"localizedAttributes"`
	// SmallImage - Small Image associated with the Property or EntityType.
	SmallImage *string `json:"smallImage,omitempty"`
	// MediumImage - Medium Image associated with the Property or EntityType.
	MediumImage *string `json:"mediumImage,omitempty"`
	// LargeImage - Large Image associated with the Property or EntityType.
	LargeImage *string `json:"largeImage,omitempty"`
}

// MarshalJSON is the custom marshaler for InteractionTypeDefinition.
func (itd InteractionTypeDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if itd.IDPropertyNames != nil {
		objectMap["idPropertyNames"] = itd.IDPropertyNames
	}
	if itd.ParticipantProfiles != nil {
		objectMap["participantProfiles"] = itd.ParticipantProfiles
	}
	if itd.PrimaryParticipantProfilePropertyName != nil {
		objectMap["primaryParticipantProfilePropertyName"] = itd.PrimaryParticipantProfilePropertyName
	}
	if itd.DataSource != nil {
		objectMap["defaultDataSource"] = itd.DataSource
	}
	if itd.IsActivity != nil {
		objectMap["isActivity"] = itd.IsActivity
	}
	if itd.APIEntitySetName != nil {
		objectMap["apiEntitySetName"] = itd.APIEntitySetName
	}
	if itd.EntityType != "" {
		objectMap["entityType"] = itd.EntityType
	}
	if itd.Fields != nil {
		objectMap["fields"] = itd.Fields
	}
	if itd.InstancesCount != nil {
		objectMap["instancesCount"] = itd.InstancesCount
	}
	if itd.SchemaItemTypeLink != nil {
		objectMap["schemaItemTypeLink"] = itd.SchemaItemTypeLink
	}
	if itd.TimestampFieldName != nil {
		objectMap["timestampFieldName"] = itd.TimestampFieldName
	}
	if itd.TypeName != nil {
		objectMap["typeName"] = itd.TypeName
	}
	if itd.Attributes != nil {
		objectMap["attributes"] = itd.Attributes
	}
	if itd.Description != nil {
		objectMap["description"] = itd.Description
	}
	if itd.DisplayName != nil {
		objectMap["displayName"] = itd.DisplayName
	}
	if itd.LocalizedAttributes != nil {
		objectMap["localizedAttributes"] = itd.LocalizedAttributes
	}
	if itd.SmallImage != nil {
		objectMap["smallImage"] = itd.SmallImage
	}
	if itd.MediumImage != nil {
		objectMap["mediumImage"] = itd.MediumImage
	}
	if itd.LargeImage != nil {
		objectMap["largeImage"] = itd.LargeImage
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for InteractionTypeDefinition struct.
func (itd *InteractionTypeDefinition) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "idPropertyNames":
			if v != nil {
				var IDPropertyNames []string
				err = json.Unmarshal(*v, &IDPropertyNames)
				if err != nil {
					return err
				}
				itd.IDPropertyNames = &IDPropertyNames
			}
		case "participantProfiles":
			if v != nil {
				var participantProfiles []Participant
				err = json.Unmarshal(*v, &participantProfiles)
				if err != nil {
					return err
				}
				itd.ParticipantProfiles = &participantProfiles
			}
		case "primaryParticipantProfilePropertyName":
			if v != nil {
				var primaryParticipantProfilePropertyName string
				err = json.Unmarshal(*v, &primaryParticipantProfilePropertyName)
				if err != nil {
					return err
				}
				itd.PrimaryParticipantProfilePropertyName = &primaryParticipantProfilePropertyName
			}
		case "dataSourcePrecedenceRules":
			if v != nil {
				var dataSourcePrecedenceRules []DataSourcePrecedence
				err = json.Unmarshal(*v, &dataSourcePrecedenceRules)
				if err != nil {
					return err
				}
				itd.DataSourcePrecedenceRules = &dataSourcePrecedenceRules
			}
		case "defaultDataSource":
			if v != nil {
				var dataSource DataSource
				err = json.Unmarshal(*v, &dataSource)
				if err != nil {
					return err
				}
				itd.DataSource = &dataSource
			}
		case "isActivity":
			if v != nil {
				var isActivity bool
				err = json.Unmarshal(*v, &isActivity)
				if err != nil {
					return err
				}
				itd.IsActivity = &isActivity
			}
		case "apiEntitySetName":
			if v != nil {
				var APIEntitySetName string
				err = json.Unmarshal(*v, &APIEntitySetName)
				if err != nil {
					return err
				}
				itd.APIEntitySetName = &APIEntitySetName
			}
		case "entityType":
			if v != nil {
				var entityType EntityTypes
				err = json.Unmarshal(*v, &entityType)
				if err != nil {
					return err
				}
				itd.EntityType = entityType
			}
		case "fields":
			if v != nil {
				var fields []PropertyDefinition
				err = json.Unmarshal(*v, &fields)
				if err != nil {
					return err
				}
				itd.Fields = &fields
			}
		case "instancesCount":
			if v != nil {
				var instancesCount int32
				err = json.Unmarshal(*v, &instancesCount)
				if err != nil {
					return err
				}
				itd.InstancesCount = &instancesCount
			}
		case "lastChangedUtc":
			if v != nil {
				var lastChangedUtc date.Time
				err = json.Unmarshal(*v, &lastChangedUtc)
				if err != nil {
					return err
				}
				itd.LastChangedUtc = &lastChangedUtc
			}
		case "provisioningState":
			if v != nil {
				var provisioningState ProvisioningStates
				err = json.Unmarshal(*v, &provisioningState)
				if err != nil {
					return err
				}
				itd.ProvisioningState = provisioningState
			}
		case "schemaItemTypeLink":
			if v != nil {
				var schemaItemTypeLink string
				err = json.Unmarshal(*v, &schemaItemTypeLink)
				if err != nil {
					return err
				}
				itd.SchemaItemTypeLink = &schemaItemTypeLink
			}
		case "tenantId":
			if v != nil {
				var tenantID string
				err = json.Unmarshal(*v, &tenantID)
				if err != nil {
					return err
				}
				itd.TenantID = &tenantID
			}
		case "timestampFieldName":
			if v != nil {
				var timestampFieldName string
				err = json.Unmarshal(*v, &timestampFieldName)
				if err != nil {
					return err
				}
				itd.TimestampFieldName = &timestampFieldName
			}
		case "typeName":
			if v != nil {
				var typeName string
				err = json.Unmarshal(*v, &typeName)
				if err != nil {
					return err
				}
				itd.TypeName = &typeName
			}
		case "attributes":
			if v != nil {
				var attributes map[string][]string
				err = json.Unmarshal(*v, &attributes)
				if err != nil {
					return err
				}
				itd.Attributes = attributes
			}
		case "description":
			if v != nil {
				var description map[string]*string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				itd.Description = description
			}
		case "displayName":
			if v != nil {
				var displayName map[string]*string
				err = json.Unmarshal(*v, &displayName)
				if err != nil {
					return err
				}
				itd.DisplayName = displayName
			}
		case "localizedAttributes":
			if v != nil {
				var localizedAttributes map[string]map[string]*string
				err = json.Unmarshal(*v, &localizedAttributes)
				if err != nil {
					return err
				}
				itd.LocalizedAttributes = localizedAttributes
			}
		case "smallImage":
			if v != nil {
				var smallImage string
				err = json.Unmarshal(*v, &smallImage)
				if err != nil {
					return err
				}
				itd.SmallImage = &smallImage
			}
		case "mediumImage":
			if v != nil {
				var mediumImage string
				err = json.Unmarshal(*v, &mediumImage)
				if err != nil {
					return err
				}
				itd.MediumImage = &mediumImage
			}
		case "largeImage":
			if v != nil {
				var largeImage string
				err = json.Unmarshal(*v, &largeImage)
				if err != nil {
					return err
				}
				itd.LargeImage = &largeImage
			}
		}
	}

	return nil
}

// KpiAlias the KPI alias.
type KpiAlias struct {
	// AliasName - KPI alias name.
	AliasName *string `json:"aliasName,omitempty"`
	// Expression - The expression.
	Expression *string `json:"expression,omitempty"`
}

// KpiCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type KpiCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(KpiClient) (KpiResourceFormat, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *KpiCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for KpiCreateOrUpdateFuture.Result.
func (future *KpiCreateOrUpdateFuture) result(client KpiClient) (krf KpiResourceFormat, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "customerinsights.KpiCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		krf.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("customerinsights.KpiCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if krf.Response.Response, err = future.GetResult(sender); err == nil && krf.Response.Response.StatusCode != http.StatusNoContent {
		krf, err = client.CreateOrUpdateResponder(krf.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "customerinsights.KpiCreateOrUpdateFuture", "Result", krf.Response.Response, "Failure responding to request")
		}
	}
	return
}

// KpiDefinition defines the KPI Threshold limits.
type KpiDefinition struct {
	// EntityType - The mapping entity type. Possible values include: 'EntityTypesNone', 'EntityTypesProfile', 'EntityTypesInteraction', 'EntityTypesRelationship'
	EntityType EntityTypes `json:"entityType,omitempty"`
	// EntityTypeName - The mapping entity name.
	EntityTypeName *string `json:"entityTypeName,omitempty"`
	// TenantID - READ-ONLY; The hub name.
	TenantID *string `json:"tenantId,omitempty"`
	// KpiName - READ-ONLY; The KPI name.
	KpiName *string `json:"kpiName,omitempty"`
	// DisplayName - Localized display name for the KPI.
	DisplayName map[string]*string `json:"displayName"`
	// Description - Localized description for the KPI.
	Description map[string]*string `json:"description"`
	// CalculationWindow - The calculation window. Possible values include: 'Lifetime', 'Hour', 'Day', 'Week', 'Month'
	CalculationWindow CalculationWindowTypes `json:"calculationWindow,omitempty"`
	// CalculationWindowFieldName - Name of calculation window field.
	CalculationWindowFieldName *string `json:"calculationWindowFieldName,omitempty"`
	// Function - The computation function for the KPI. Possible values include: 'KpiFunctionsSum', 'KpiFunctionsAvg', 'KpiFunctionsMin', 'KpiFunctionsMax', 'KpiFunctionsLast', 'KpiFunctionsCount', 'KpiFunctionsNone', 'KpiFunctionsCountDistinct'
	Function KpiFunctions `json:"function,omitempty"`
	// Expression - The computation expression for the KPI.
	Expression *string `json:"expression,omitempty"`
	// Unit - The unit of measurement for the KPI.
	Unit *string `json:"unit,omitempty"`
	// Filter - The filter expression for the KPI.
	Filter *string `json:"filter,omitempty"`
	// GroupBy - the group by properties for the KPI.
	GroupBy *[]string `json:"groupBy,omitempty"`
	// GroupByMetadata - READ-ONLY; The KPI GroupByMetadata.
	GroupByMetadata *[]KpiGroupByMetadata `json:"groupByMetadata,omitempty"`
	// ParticipantProfilesMetadata - READ-ONLY; The participant profiles.
	ParticipantProfilesMetadata *[]KpiParticipantProfilesMetadata `json:"participantProfilesMetadata,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning state. Possible values include: 'ProvisioningStatesProvisioning', 'ProvisioningStatesSucceeded', 'ProvisioningStatesExpiring', 'ProvisioningStatesDeleting', 'ProvisioningStatesHumanIntervention', 'ProvisioningStatesFailed'
	ProvisioningState ProvisioningStates `json:"provisioningState,omitempty"`
	// ThresHolds - The KPI thresholds.
	ThresHolds *KpiThresholds `json:"thresHolds,omitempty"`
	// Aliases - The aliases.
	Aliases *[]KpiAlias `json:"aliases,omitempty"`
	// Extracts - The KPI extracts.
	Extracts *[]KpiExtract `json:"extracts,omitempty"`
}

// MarshalJSON is the custom marshaler for KpiDefinition.
func (kd KpiDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if kd.EntityType != "" {
		objectMap["entityType"] = kd.EntityType
	}
	if kd.EntityTypeName != nil {
		objectMap["entityTypeName"] = kd.EntityTypeName
	}
	if kd.DisplayName != nil {
		objectMap["displayName"] = kd.DisplayName
	}
	if kd.Description != nil {
		objectMap["description"] = kd.Description
	}
	if kd.CalculationWindow != "" {
		objectMap["calculationWindow"] = kd.CalculationWindow
	}
	if kd.CalculationWindowFieldName != nil {
		objectMap["calculationWindowFieldName"] = kd.CalculationWindowFieldName
	}
	if kd.Function != "" {
		objectMap["function"] = kd.Function
	}
	if kd.Expression != nil {
		objectMap["expression"] = kd.Expression
	}
	if kd.Unit != nil {
		objectMap["unit"] = kd.Unit
	}
	if kd.Filter != nil {
		objectMap["filter"] = kd.Filter
	}
	if kd.GroupBy != nil {
		objectMap["groupBy"] = kd.GroupBy
	}
	if kd.ThresHolds != nil {
		objectMap["thresHolds"] = kd.ThresHolds
	}
	if kd.Aliases != nil {
		objectMap["aliases"] = kd.Aliases
	}
	if kd.Extracts != nil {
		objectMap["extracts"] = kd.Extracts
	}
	return json.Marshal(objectMap)
}

// KpiDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type KpiDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(KpiClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *KpiDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for KpiDeleteFuture.Result.
func (future *KpiDeleteFuture) result(client KpiClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "customerinsights.KpiDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("customerinsights.KpiDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// KpiExtract the KPI extract.
type KpiExtract struct {
	// ExtractName - KPI extract name.
	ExtractName *string `json:"extractName,omitempty"`
	// Expression - The expression.
	Expression *string `json:"expression,omitempty"`
}

// KpiGroupByMetadata the KPI GroupBy field metadata.
type KpiGroupByMetadata struct {
	// DisplayName - The display name.
	DisplayName map[string]*string `json:"displayName"`
	// FieldName - The name of the field.
	FieldName *string `json:"fieldName,omitempty"`
	// FieldType - The type of the field.
	FieldType *string `json:"fieldType,omitempty"`
}

// MarshalJSON is the custom marshaler for KpiGroupByMetadata.
func (kgbm KpiGroupByMetadata) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if kgbm.DisplayName != nil {
		objectMap["displayName"] = kgbm.DisplayName
	}
	if kgbm.FieldName != nil {
		objectMap["fieldName"] = kgbm.FieldName
	}
	if kgbm.FieldType != nil {
		objectMap["fieldType"] = kgbm.FieldType
	}
	return json.Marshal(objectMap)
}

// KpiListResult the response of list KPI operation.
type KpiListResult struct {
	autorest.Response `json:"-"`
	// Value - Results of the list operation.
	Value *[]KpiResourceFormat `json:"value,omitempty"`
	// NextLink - Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// KpiListResultIterator provides access to a complete listing of KpiResourceFormat values.
type KpiListResultIterator struct {
	i    int
	page KpiListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *KpiListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/KpiListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *KpiListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter KpiListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter KpiListResultIterator) Response() KpiListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter KpiListResultIterator) Value() KpiResourceFormat {
	if !iter.page.NotDone() {
		return KpiResourceFormat{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the KpiListResultIterator type.
func NewKpiListResultIterator(page KpiListResultPage) KpiListResultIterator {
	return KpiListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (klr KpiListResult) IsEmpty() bool {
	return klr.Value == nil || len(*klr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (klr KpiListResult) hasNextLink() bool {
	return klr.NextLink != nil && len(*klr.NextLink) != 0
}

// kpiListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (klr KpiListResult) kpiListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !klr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(klr.NextLink)))
}

// KpiListResultPage contains a page of KpiResourceFormat values.
type KpiListResultPage struct {
	fn  func(context.Context, KpiListResult) (KpiListResult, error)
	klr KpiListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *KpiListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/KpiListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.klr)
		if err != nil {
			return err
		}
		page.klr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *KpiListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page KpiListResultPage) NotDone() bool {
	return !page.klr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page KpiListResultPage) Response() KpiListResult {
	return page.klr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page KpiListResultPage) Values() []KpiResourceFormat {
	if page.klr.IsEmpty() {
		return nil
	}
	return *page.klr.Value
}

// Creates a new instance of the KpiListResultPage type.
func NewKpiListResultPage(cur KpiListResult, getNextPage func(context.Context, KpiListResult) (KpiListResult, error)) KpiListResultPage {
	return KpiListResultPage{
		fn:  getNextPage,
		klr: cur,
	}
}

// KpiParticipantProfilesMetadata the KPI participant profile metadata.
type KpiParticipantProfilesMetadata struct {
	// TypeName - Name of the type.
	TypeName *string `json:"typeName,omitempty"`
}

// KpiResourceFormat the KPI resource format.
type KpiResourceFormat struct {
	autorest.Response `json:"-"`
	*KpiDefinition    `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for KpiResourceFormat.
func (krf KpiResourceFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if krf.KpiDefinition != nil {
		objectMap["properties"] = krf.KpiDefinition
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for KpiResourceFormat struct.
func (krf *KpiResourceFormat) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var kpiDefinition KpiDefinition
				err = json.Unmarshal(*v, &kpiDefinition)
				if err != nil {
					return err
				}
				krf.KpiDefinition = &kpiDefinition
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				krf.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				krf.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				krf.Type = &typeVar
			}
		}
	}

	return nil
}

// KpiThresholds defines the KPI Threshold limits.
type KpiThresholds struct {
	// LowerLimit - The lower threshold limit.
	LowerLimit *decimal.Decimal `json:"lowerLimit,omitempty"`
	// UpperLimit - The upper threshold limit.
	UpperLimit *decimal.Decimal `json:"upperLimit,omitempty"`
	// IncreasingKpi - Whether or not the KPI is an increasing KPI.
	IncreasingKpi *bool `json:"increasingKpi,omitempty"`
}

// LinkDefinition the definition of Link.
type LinkDefinition struct {
	// TenantID - READ-ONLY; The hub name.
	TenantID *string `json:"tenantId,omitempty"`
	// LinkName - READ-ONLY; The link name.
	LinkName *string `json:"linkName,omitempty"`
	// SourceEntityType - Type of source entity. Possible values include: 'EntityTypeNone', 'EntityTypeProfile', 'EntityTypeInteraction', 'EntityTypeRelationship'
	SourceEntityType EntityType `json:"sourceEntityType,omitempty"`
	// TargetEntityType - Type of target entity. Possible values include: 'EntityTypeNone', 'EntityTypeProfile', 'EntityTypeInteraction', 'EntityTypeRelationship'
	TargetEntityType EntityType `json:"targetEntityType,omitempty"`
	// SourceEntityTypeName - Name of the source Entity Type.
	SourceEntityTypeName *string `json:"sourceEntityTypeName,omitempty"`
	// TargetEntityTypeName - Name of the target Entity Type.
	TargetEntityTypeName *string `json:"targetEntityTypeName,omitempty"`
	// DisplayName - Localized display name for the Link.
	DisplayName map[string]*string `json:"displayName"`
	// Description - Localized descriptions for the Link.
	Description map[string]*string `json:"description"`
	// Mappings - The set of properties mappings between the source and target Types.
	Mappings *[]TypePropertiesMapping `json:"mappings,omitempty"`
	// ParticipantPropertyReferences - The properties that represent the participating profile.
	ParticipantPropertyReferences *[]ParticipantPropertyReference `json:"participantPropertyReferences,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning state. Possible values include: 'ProvisioningStatesProvisioning', 'ProvisioningStatesSucceeded', 'ProvisioningStatesExpiring', 'ProvisioningStatesDeleting', 'ProvisioningStatesHumanIntervention', 'ProvisioningStatesFailed'
	ProvisioningState ProvisioningStates `json:"provisioningState,omitempty"`
	// ReferenceOnly - Indicating whether the link is reference only link. This flag is ignored if the Mappings are defined. If the mappings are not defined and it is set to true, links processing will not create or update profiles.
	ReferenceOnly *bool `json:"referenceOnly,omitempty"`
	// OperationType - Determines whether this link is supposed to create or delete instances if Link is NOT Reference Only. Possible values include: 'Upsert', 'Delete'
	OperationType InstanceOperationType `json:"operationType,omitempty"`
}

// MarshalJSON is the custom marshaler for LinkDefinition.
func (ld LinkDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ld.SourceEntityType != "" {
		objectMap["sourceEntityType"] = ld.SourceEntityType
	}
	if ld.TargetEntityType != "" {
		objectMap["targetEntityType"] = ld.TargetEntityType
	}
	if ld.SourceEntityTypeName != nil {
		objectMap["sourceEntityTypeName"] = ld.SourceEntityTypeName
	}
	if ld.TargetEntityTypeName != nil {
		objectMap["targetEntityTypeName"] = ld.TargetEntityTypeName
	}
	if ld.DisplayName != nil {
		objectMap["displayName"] = ld.DisplayName
	}
	if ld.Description != nil {
		objectMap["description"] = ld.Description
	}
	if ld.Mappings != nil {
		objectMap["mappings"] = ld.Mappings
	}
	if ld.ParticipantPropertyReferences != nil {
		objectMap["participantPropertyReferences"] = ld.ParticipantPropertyReferences
	}
	if ld.ReferenceOnly != nil {
		objectMap["referenceOnly"] = ld.ReferenceOnly
	}
	if ld.OperationType != "" {
		objectMap["operationType"] = ld.OperationType
	}
	return json.Marshal(objectMap)
}

// LinkListResult the response of list link operation.
type LinkListResult struct {
	autorest.Response `json:"-"`
	// Value - Results of the list operation.
	Value *[]LinkResourceFormat `json:"value,omitempty"`
	// NextLink - Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// LinkListResultIterator provides access to a complete listing of LinkResourceFormat values.
type LinkListResultIterator struct {
	i    int
	page LinkListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *LinkListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LinkListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *LinkListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter LinkListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter LinkListResultIterator) Response() LinkListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter LinkListResultIterator) Value() LinkResourceFormat {
	if !iter.page.NotDone() {
		return LinkResourceFormat{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the LinkListResultIterator type.
func NewLinkListResultIterator(page LinkListResultPage) LinkListResultIterator {
	return LinkListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (llr LinkListResult) IsEmpty() bool {
	return llr.Value == nil || len(*llr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (llr LinkListResult) hasNextLink() bool {
	return llr.NextLink != nil && len(*llr.NextLink) != 0
}

// linkListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (llr LinkListResult) linkListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !llr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(llr.NextLink)))
}

// LinkListResultPage contains a page of LinkResourceFormat values.
type LinkListResultPage struct {
	fn  func(context.Context, LinkListResult) (LinkListResult, error)
	llr LinkListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *LinkListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LinkListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.llr)
		if err != nil {
			return err
		}
		page.llr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *LinkListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page LinkListResultPage) NotDone() bool {
	return !page.llr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page LinkListResultPage) Response() LinkListResult {
	return page.llr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page LinkListResultPage) Values() []LinkResourceFormat {
	if page.llr.IsEmpty() {
		return nil
	}
	return *page.llr.Value
}

// Creates a new instance of the LinkListResultPage type.
func NewLinkListResultPage(cur LinkListResult, getNextPage func(context.Context, LinkListResult) (LinkListResult, error)) LinkListResultPage {
	return LinkListResultPage{
		fn:  getNextPage,
		llr: cur,
	}
}

// LinkResourceFormat the link resource format.
type LinkResourceFormat struct {
	autorest.Response `json:"-"`
	*LinkDefinition   `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for LinkResourceFormat.
func (lrf LinkResourceFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lrf.LinkDefinition != nil {
		objectMap["properties"] = lrf.LinkDefinition
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for LinkResourceFormat struct.
func (lrf *LinkResourceFormat) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var linkDefinition LinkDefinition
				err = json.Unmarshal(*v, &linkDefinition)
				if err != nil {
					return err
				}
				lrf.LinkDefinition = &linkDefinition
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				lrf.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				lrf.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				lrf.Type = &typeVar
			}
		}
	}

	return nil
}

// LinksCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type LinksCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(LinksClient) (LinkResourceFormat, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *LinksCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for LinksCreateOrUpdateFuture.Result.
func (future *LinksCreateOrUpdateFuture) result(client LinksClient) (lrf LinkResourceFormat, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "customerinsights.LinksCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		lrf.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("customerinsights.LinksCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if lrf.Response.Response, err = future.GetResult(sender); err == nil && lrf.Response.Response.StatusCode != http.StatusNoContent {
		lrf, err = client.CreateOrUpdateResponder(lrf.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "customerinsights.LinksCreateOrUpdateFuture", "Result", lrf.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ListKpiDefinition ...
type ListKpiDefinition struct {
	autorest.Response `json:"-"`
	Value             *[]KpiDefinition `json:"value,omitempty"`
}

// MetadataDefinitionBase the Metadata definition base.
type MetadataDefinitionBase struct {
	// Attributes - The attributes for the Type.
	Attributes map[string][]string `json:"attributes"`
	// Description - Localized descriptions for the property.
	Description map[string]*string `json:"description"`
	// DisplayName - Localized display names for the property.
	DisplayName map[string]*string `json:"displayName"`
	// LocalizedAttributes - Any custom localized attributes for the Type.
	LocalizedAttributes map[string]map[string]*string `json:"localizedAttributes"`
	// SmallImage - Small Image associated with the Property or EntityType.
	SmallImage *string `json:"smallImage,omitempty"`
	// MediumImage - Medium Image associated with the Property or EntityType.
	MediumImage *string `json:"mediumImage,omitempty"`
	// LargeImage - Large Image associated with the Property or EntityType.
	LargeImage *string `json:"largeImage,omitempty"`
}

// MarshalJSON is the custom marshaler for MetadataDefinitionBase.
func (mdb MetadataDefinitionBase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mdb.Attributes != nil {
		objectMap["attributes"] = mdb.Attributes
	}
	if mdb.Description != nil {
		objectMap["description"] = mdb.Description
	}
	if mdb.DisplayName != nil {
		objectMap["displayName"] = mdb.DisplayName
	}
	if mdb.LocalizedAttributes != nil {
		objectMap["localizedAttributes"] = mdb.LocalizedAttributes
	}
	if mdb.SmallImage != nil {
		objectMap["smallImage"] = mdb.SmallImage
	}
	if mdb.MediumImage != nil {
		objectMap["mediumImage"] = mdb.MediumImage
	}
	if mdb.LargeImage != nil {
		objectMap["largeImage"] = mdb.LargeImage
	}
	return json.Marshal(objectMap)
}

// Operation a Customer Insights REST API operation
type Operation struct {
	// Name - READ-ONLY; Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
	// Display - The object that represents the operation.
	Display *OperationDisplay `json:"display,omitempty"`
}

// MarshalJSON is the custom marshaler for Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if o.Display != nil {
		objectMap["display"] = o.Display
	}
	return json.Marshal(objectMap)
}

// OperationDisplay the object that represents the operation.
type OperationDisplay struct {
	// Provider - READ-ONLY; Service provider: Microsoft.CustomerInsights
	Provider *string `json:"provider,omitempty"`
	// Resource - READ-ONLY; Resource on which the operation is performed: Invoice, etc.
	Resource *string `json:"resource,omitempty"`
	// Operation - READ-ONLY; Operation type: Read, write, delete, etc.
	Operation *string `json:"operation,omitempty"`
}

// OperationListResult result of the request to list Customer Insights operations. It contains a list of
// operations and a URL link to get the next set of results.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of Customer Insights operations supported by the Microsoft.CustomerInsights resource provider.
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationListResultIterator provides access to a complete listing of Operation values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListResultIterator type.
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return OperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (olr OperationListResult) hasNextLink() bool {
	return olr.NextLink != nil && len(*olr.NextLink) != 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !olr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of Operation values.
type OperationListResultPage struct {
	fn  func(context.Context, OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.olr)
		if err != nil {
			return err
		}
		page.olr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []Operation {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Creates a new instance of the OperationListResultPage type.
func NewOperationListResultPage(cur OperationListResult, getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return OperationListResultPage{
		fn:  getNextPage,
		olr: cur,
	}
}

// Participant describes a profile type participating in an interaction.
type Participant struct {
	// ProfileTypeName - Profile type name.
	ProfileTypeName *string `json:"profileTypeName,omitempty"`
	// ParticipantPropertyReferences - The property references.
	ParticipantPropertyReferences *[]ParticipantPropertyReference `json:"participantPropertyReferences,omitempty"`
	// ParticipantName - Participant name.
	ParticipantName *string `json:"participantName,omitempty"`
	// DisplayName - Localized display name.
	DisplayName map[string]*string `json:"displayName"`
	// Description - Localized descriptions.
	Description map[string]*string `json:"description"`
	// Role - The role that the participant is playing in the interaction.
	Role *string `json:"role,omitempty"`
}

// MarshalJSON is the custom marshaler for Participant.
func (p Participant) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if p.ProfileTypeName != nil {
		objectMap["profileTypeName"] = p.ProfileTypeName
	}
	if p.ParticipantPropertyReferences != nil {
		objectMap["participantPropertyReferences"] = p.ParticipantPropertyReferences
	}
	if p.ParticipantName != nil {
		objectMap["participantName"] = p.ParticipantName
	}
	if p.DisplayName != nil {
		objectMap["displayName"] = p.DisplayName
	}
	if p.Description != nil {
		objectMap["description"] = p.Description
	}
	if p.Role != nil {
		objectMap["role"] = p.Role
	}
	return json.Marshal(objectMap)
}

// ParticipantProfilePropertyReference the participant profile property reference.
type ParticipantProfilePropertyReference struct {
	// InteractionPropertyName - The source interaction property that maps to the target profile property.
	InteractionPropertyName *string `json:"interactionPropertyName,omitempty"`
	// ProfilePropertyName - The target profile property that maps to the source interaction property.
	ProfilePropertyName *string `json:"profilePropertyName,omitempty"`
}

// ParticipantPropertyReference the participant property reference.
type ParticipantPropertyReference struct {
	// SourcePropertyName - The source property that maps to the target property.
	SourcePropertyName *string `json:"sourcePropertyName,omitempty"`
	// TargetPropertyName - The target property that maps to the source property.
	TargetPropertyName *string `json:"targetPropertyName,omitempty"`
}

// Prediction the prediction definition.
type Prediction struct {
	// Description - Description of the prediction.
	Description map[string]*string `json:"description"`
	// DisplayName - Display name of the prediction.
	DisplayName map[string]*string `json:"displayName"`
	// InvolvedInteractionTypes - Interaction types involved in the prediction.
	InvolvedInteractionTypes *[]string `json:"involvedInteractionTypes,omitempty"`
	// InvolvedKpiTypes - KPI types involved in the prediction.
	InvolvedKpiTypes *[]string `json:"involvedKpiTypes,omitempty"`
	// InvolvedRelationships - Relationships involved in the prediction.
	InvolvedRelationships *[]string `json:"involvedRelationships,omitempty"`
	// NegativeOutcomeExpression - Negative outcome expression.
	NegativeOutcomeExpression *string `json:"negativeOutcomeExpression,omitempty"`
	// PositiveOutcomeExpression - Positive outcome expression.
	PositiveOutcomeExpression *string `json:"positiveOutcomeExpression,omitempty"`
	// PrimaryProfileType - Primary profile type.
	PrimaryProfileType *string `json:"primaryProfileType,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning state. Possible values include: 'ProvisioningStatesProvisioning', 'ProvisioningStatesSucceeded', 'ProvisioningStatesExpiring', 'ProvisioningStatesDeleting', 'ProvisioningStatesHumanIntervention', 'ProvisioningStatesFailed'
	ProvisioningState ProvisioningStates `json:"provisioningState,omitempty"`
	// PredictionName - Name of the prediction.
	PredictionName *string `json:"predictionName,omitempty"`
	// ScopeExpression - Scope expression.
	ScopeExpression *string `json:"scopeExpression,omitempty"`
	// TenantID - READ-ONLY; The hub name.
	TenantID *string `json:"tenantId,omitempty"`
	// AutoAnalyze - Whether do auto analyze.
	AutoAnalyze *bool `json:"autoAnalyze,omitempty"`
	// Mappings - Definition of the link mapping of prediction.
	Mappings *PredictionMappings `json:"mappings,omitempty"`
	// ScoreLabel - Score label.
	ScoreLabel *string `json:"scoreLabel,omitempty"`
	// Grades - The prediction grades.
	Grades *[]PredictionGradesItem `json:"grades,omitempty"`
	// SystemGeneratedEntities - READ-ONLY; System generated entities.
	SystemGeneratedEntities *PredictionSystemGeneratedEntities `json:"systemGeneratedEntities,omitempty"`
}

// MarshalJSON is the custom marshaler for Prediction.
func (p Prediction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if p.Description != nil {
		objectMap["description"] = p.Description
	}
	if p.DisplayName != nil {
		objectMap["displayName"] = p.DisplayName
	}
	if p.InvolvedInteractionTypes != nil {
		objectMap["involvedInteractionTypes"] = p.InvolvedInteractionTypes
	}
	if p.InvolvedKpiTypes != nil {
		objectMap["involvedKpiTypes"] = p.InvolvedKpiTypes
	}
	if p.InvolvedRelationships != nil {
		objectMap["involvedRelationships"] = p.InvolvedRelationships
	}
	if p.NegativeOutcomeExpression != nil {
		objectMap["negativeOutcomeExpression"] = p.NegativeOutcomeExpression
	}
	if p.PositiveOutcomeExpression != nil {
		objectMap["positiveOutcomeExpression"] = p.PositiveOutcomeExpression
	}
	if p.PrimaryProfileType != nil {
		objectMap["primaryProfileType"] = p.PrimaryProfileType
	}
	if p.PredictionName != nil {
		objectMap["predictionName"] = p.PredictionName
	}
	if p.ScopeExpression != nil {
		objectMap["scopeExpression"] = p.ScopeExpression
	}
	if p.AutoAnalyze != nil {
		objectMap["autoAnalyze"] = p.AutoAnalyze
	}
	if p.Mappings != nil {
		objectMap["mappings"] = p.Mappings
	}
	if p.ScoreLabel != nil {
		objectMap["scoreLabel"] = p.ScoreLabel
	}
	if p.Grades != nil {
		objectMap["grades"] = p.Grades
	}
	return json.Marshal(objectMap)
}

// PredictionDistributionDefinition the definition of the prediction distribution.
type PredictionDistributionDefinition struct {
	// TotalPositives - Total positive in the distribution.
	TotalPositives *int64 `json:"totalPositives,omitempty"`
	// TotalNegatives - Total negatives in the distribution.
	TotalNegatives *int64 `json:"totalNegatives,omitempty"`
	// Distributions - Distributions of the prediction.
	Distributions *[]PredictionDistributionDefinitionDistributionsItem `json:"distributions,omitempty"`
}

// PredictionDistributionDefinitionDistributionsItem the definition of a prediction distribution.
type PredictionDistributionDefinitionDistributionsItem struct {
	// ScoreThreshold - Score threshold.
	ScoreThreshold *int32 `json:"scoreThreshold,omitempty"`
	// Positives - Number of positives.
	Positives *int64 `json:"positives,omitempty"`
	// Negatives - Number of negatives.
	Negatives *int64 `json:"negatives,omitempty"`
	// PositivesAboveThreshold - Number of positives above threshold.
	PositivesAboveThreshold *int64 `json:"positivesAboveThreshold,omitempty"`
	// NegativesAboveThreshold - Number of negatives above threshold.
	NegativesAboveThreshold *int64 `json:"negativesAboveThreshold,omitempty"`
}

// PredictionGradesItem the definition of a prediction grade.
type PredictionGradesItem struct {
	// GradeName - Name of the grade.
	GradeName *string `json:"gradeName,omitempty"`
	// MinScoreThreshold - Minimum score threshold.
	MinScoreThreshold *int32 `json:"minScoreThreshold,omitempty"`
	// MaxScoreThreshold - Maximum score threshold.
	MaxScoreThreshold *int32 `json:"maxScoreThreshold,omitempty"`
}

// PredictionListResult the response of list predictions operation.
type PredictionListResult struct {
	autorest.Response `json:"-"`
	// Value - Results of the list operation.
	Value *[]PredictionResourceFormat `json:"value,omitempty"`
	// NextLink - Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// PredictionListResultIterator provides access to a complete listing of PredictionResourceFormat values.
type PredictionListResultIterator struct {
	i    int
	page PredictionListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PredictionListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PredictionListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PredictionListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PredictionListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PredictionListResultIterator) Response() PredictionListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PredictionListResultIterator) Value() PredictionResourceFormat {
	if !iter.page.NotDone() {
		return PredictionResourceFormat{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PredictionListResultIterator type.
func NewPredictionListResultIterator(page PredictionListResultPage) PredictionListResultIterator {
	return PredictionListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (plr PredictionListResult) IsEmpty() bool {
	return plr.Value == nil || len(*plr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (plr PredictionListResult) hasNextLink() bool {
	return plr.NextLink != nil && len(*plr.NextLink) != 0
}

// predictionListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (plr PredictionListResult) predictionListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !plr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(plr.NextLink)))
}

// PredictionListResultPage contains a page of PredictionResourceFormat values.
type PredictionListResultPage struct {
	fn  func(context.Context, PredictionListResult) (PredictionListResult, error)
	plr PredictionListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PredictionListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PredictionListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.plr)
		if err != nil {
			return err
		}
		page.plr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PredictionListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PredictionListResultPage) NotDone() bool {
	return !page.plr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PredictionListResultPage) Response() PredictionListResult {
	return page.plr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PredictionListResultPage) Values() []PredictionResourceFormat {
	if page.plr.IsEmpty() {
		return nil
	}
	return *page.plr.Value
}

// Creates a new instance of the PredictionListResultPage type.
func NewPredictionListResultPage(cur PredictionListResult, getNextPage func(context.Context, PredictionListResult) (PredictionListResult, error)) PredictionListResultPage {
	return PredictionListResultPage{
		fn:  getNextPage,
		plr: cur,
	}
}

// PredictionMappings definition of the link mapping of prediction.
type PredictionMappings struct {
	// Score - The score of the link mapping.
	Score *string `json:"score,omitempty"`
	// Grade - The grade of the link mapping.
	Grade *string `json:"grade,omitempty"`
	// Reason - The reason of the link mapping.
	Reason *string `json:"reason,omitempty"`
}

// PredictionModelStatus the prediction model status.
type PredictionModelStatus struct {
	autorest.Response `json:"-"`
	// TenantID - READ-ONLY; The hub name.
	TenantID *string `json:"tenantId,omitempty"`
	// PredictionName - READ-ONLY; The prediction name.
	PredictionName *string `json:"predictionName,omitempty"`
	// PredictionGUIDID - READ-ONLY; The prediction GUID ID.
	PredictionGUIDID *string `json:"predictionGuidId,omitempty"`
	// Status - Prediction model life cycle.  When prediction is in PendingModelConfirmation status, it is allowed to update the status to PendingFeaturing or Active through API. Possible values include: 'PredictionModelLifeCycleNew', 'PredictionModelLifeCycleProvisioning', 'PredictionModelLifeCycleProvisioningFailed', 'PredictionModelLifeCyclePendingDiscovering', 'PredictionModelLifeCycleDiscovering', 'PredictionModelLifeCyclePendingFeaturing', 'PredictionModelLifeCycleFeaturing', 'PredictionModelLifeCycleFeaturingFailed', 'PredictionModelLifeCyclePendingTraining', 'PredictionModelLifeCycleTraining', 'PredictionModelLifeCycleTrainingFailed', 'PredictionModelLifeCycleEvaluating', 'PredictionModelLifeCycleEvaluatingFailed', 'PredictionModelLifeCyclePendingModelConfirmation', 'PredictionModelLifeCycleActive', 'PredictionModelLifeCycleDeleted', 'PredictionModelLifeCycleHumanIntervention', 'PredictionModelLifeCycleFailed'
	Status PredictionModelLifeCycle `json:"status,omitempty"`
	// Message - READ-ONLY; The model status message.
	Message *string `json:"message,omitempty"`
	// TrainingSetCount - READ-ONLY; Count of the training set.
	TrainingSetCount *int32 `json:"trainingSetCount,omitempty"`
	// TestSetCount - READ-ONLY; Count of the test set.
	TestSetCount *int32 `json:"testSetCount,omitempty"`
	// ValidationSetCount - READ-ONLY; Count of the validation set.
	ValidationSetCount *int32 `json:"validationSetCount,omitempty"`
	// TrainingAccuracy - READ-ONLY; The training accuracy.
	TrainingAccuracy *int32 `json:"trainingAccuracy,omitempty"`
	// SignalsUsed - READ-ONLY; The signals used.
	SignalsUsed *int32 `json:"signalsUsed,omitempty"`
	// ModelVersion - READ-ONLY; Version of the model.
	ModelVersion *string `json:"modelVersion,omitempty"`
}

// MarshalJSON is the custom marshaler for PredictionModelStatus.
func (pms PredictionModelStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pms.Status != "" {
		objectMap["status"] = pms.Status
	}
	return json.Marshal(objectMap)
}

// PredictionResourceFormat the prediction resource format.
type PredictionResourceFormat struct {
	autorest.Response `json:"-"`
	*Prediction       `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for PredictionResourceFormat.
func (prf PredictionResourceFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if prf.Prediction != nil {
		objectMap["properties"] = prf.Prediction
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PredictionResourceFormat struct.
func (prf *PredictionResourceFormat) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var prediction Prediction
				err = json.Unmarshal(*v, &prediction)
				if err != nil {
					return err
				}
				prf.Prediction = &prediction
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				prf.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				prf.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				prf.Type = &typeVar
			}
		}
	}

	return nil
}

// PredictionsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type PredictionsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PredictionsClient) (PredictionResourceFormat, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *PredictionsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for PredictionsCreateOrUpdateFuture.Result.
func (future *PredictionsCreateOrUpdateFuture) result(client PredictionsClient) (prf PredictionResourceFormat, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "customerinsights.PredictionsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		prf.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("customerinsights.PredictionsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if prf.Response.Response, err = future.GetResult(sender); err == nil && prf.Response.Response.StatusCode != http.StatusNoContent {
		prf, err = client.CreateOrUpdateResponder(prf.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "customerinsights.PredictionsCreateOrUpdateFuture", "Result", prf.Response.Response, "Failure responding to request")
		}
	}
	return
}

// PredictionsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type PredictionsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PredictionsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *PredictionsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for PredictionsDeleteFuture.Result.
func (future *PredictionsDeleteFuture) result(client PredictionsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "customerinsights.PredictionsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("customerinsights.PredictionsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// PredictionSystemGeneratedEntities system generated entities.
type PredictionSystemGeneratedEntities struct {
	// GeneratedInteractionTypes - Generated interaction types.
	GeneratedInteractionTypes *[]string `json:"generatedInteractionTypes,omitempty"`
	// GeneratedLinks - Generated links.
	GeneratedLinks *[]string `json:"generatedLinks,omitempty"`
	// GeneratedKpis - Generated KPIs.
	GeneratedKpis map[string]*string `json:"generatedKpis"`
}

// MarshalJSON is the custom marshaler for PredictionSystemGeneratedEntities.
func (pGe PredictionSystemGeneratedEntities) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pGe.GeneratedInteractionTypes != nil {
		objectMap["generatedInteractionTypes"] = pGe.GeneratedInteractionTypes
	}
	if pGe.GeneratedLinks != nil {
		objectMap["generatedLinks"] = pGe.GeneratedLinks
	}
	if pGe.GeneratedKpis != nil {
		objectMap["generatedKpis"] = pGe.GeneratedKpis
	}
	return json.Marshal(objectMap)
}

// PredictionTrainingResults the training results of the prediction.
type PredictionTrainingResults struct {
	autorest.Response `json:"-"`
	// TenantID - READ-ONLY; The hub name.
	TenantID *string `json:"tenantId,omitempty"`
	// ScoreName - READ-ONLY; Score name.
	ScoreName *string `json:"scoreName,omitempty"`
	// PredictionDistribution - READ-ONLY; Prediction distribution.
	PredictionDistribution *PredictionDistributionDefinition `json:"predictionDistribution,omitempty"`
	// CanonicalProfiles - READ-ONLY; Canonical profiles.
	CanonicalProfiles *[]CanonicalProfileDefinition `json:"canonicalProfiles,omitempty"`
	// PrimaryProfileInstanceCount - READ-ONLY; Instance count of the primary profile.
	PrimaryProfileInstanceCount *int64 `json:"primaryProfileInstanceCount,omitempty"`
}

// ProfileEnumValidValuesFormat valid enum values in case of an enum property.
type ProfileEnumValidValuesFormat struct {
	// Value - The integer value of the enum member.
	Value *int32 `json:"value,omitempty"`
	// LocalizedValueNames - Localized names of the enum member.
	LocalizedValueNames map[string]*string `json:"localizedValueNames"`
}

// MarshalJSON is the custom marshaler for ProfileEnumValidValuesFormat.
func (pevvf ProfileEnumValidValuesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pevvf.Value != nil {
		objectMap["value"] = pevvf.Value
	}
	if pevvf.LocalizedValueNames != nil {
		objectMap["localizedValueNames"] = pevvf.LocalizedValueNames
	}
	return json.Marshal(objectMap)
}

// ProfileListResult the response of list profile operation.
type ProfileListResult struct {
	autorest.Response `json:"-"`
	// Value - Results of the list operation.
	Value *[]ProfileResourceFormat `json:"value,omitempty"`
	// NextLink - Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ProfileListResultIterator provides access to a complete listing of ProfileResourceFormat values.
type ProfileListResultIterator struct {
	i    int
	page ProfileListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ProfileListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProfileListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ProfileListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ProfileListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ProfileListResultIterator) Response() ProfileListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ProfileListResultIterator) Value() ProfileResourceFormat {
	if !iter.page.NotDone() {
		return ProfileResourceFormat{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ProfileListResultIterator type.
func NewProfileListResultIterator(page ProfileListResultPage) ProfileListResultIterator {
	return ProfileListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (plr ProfileListResult) IsEmpty() bool {
	return plr.Value == nil || len(*plr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (plr ProfileListResult) hasNextLink() bool {
	return plr.NextLink != nil && len(*plr.NextLink) != 0
}

// profileListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (plr ProfileListResult) profileListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !plr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(plr.NextLink)))
}

// ProfileListResultPage contains a page of ProfileResourceFormat values.
type ProfileListResultPage struct {
	fn  func(context.Context, ProfileListResult) (ProfileListResult, error)
	plr ProfileListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ProfileListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProfileListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.plr)
		if err != nil {
			return err
		}
		page.plr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ProfileListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ProfileListResultPage) NotDone() bool {
	return !page.plr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ProfileListResultPage) Response() ProfileListResult {
	return page.plr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ProfileListResultPage) Values() []ProfileResourceFormat {
	if page.plr.IsEmpty() {
		return nil
	}
	return *page.plr.Value
}

// Creates a new instance of the ProfileListResultPage type.
func NewProfileListResultPage(cur ProfileListResult, getNextPage func(context.Context, ProfileListResult) (ProfileListResult, error)) ProfileListResultPage {
	return ProfileListResultPage{
		fn:  getNextPage,
		plr: cur,
	}
}

// ProfileResourceFormat the profile resource format.
type ProfileResourceFormat struct {
	autorest.Response      `json:"-"`
	*ProfileTypeDefinition `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ProfileResourceFormat.
func (prf ProfileResourceFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if prf.ProfileTypeDefinition != nil {
		objectMap["properties"] = prf.ProfileTypeDefinition
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ProfileResourceFormat struct.
func (prf *ProfileResourceFormat) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var profileTypeDefinition ProfileTypeDefinition
				err = json.Unmarshal(*v, &profileTypeDefinition)
				if err != nil {
					return err
				}
				prf.ProfileTypeDefinition = &profileTypeDefinition
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				prf.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				prf.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				prf.Type = &typeVar
			}
		}
	}

	return nil
}

// ProfilesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ProfilesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ProfilesClient) (ProfileResourceFormat, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ProfilesCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ProfilesCreateOrUpdateFuture.Result.
func (future *ProfilesCreateOrUpdateFuture) result(client ProfilesClient) (prf ProfileResourceFormat, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "customerinsights.ProfilesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		prf.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("customerinsights.ProfilesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if prf.Response.Response, err = future.GetResult(sender); err == nil && prf.Response.Response.StatusCode != http.StatusNoContent {
		prf, err = client.CreateOrUpdateResponder(prf.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "customerinsights.ProfilesCreateOrUpdateFuture", "Result", prf.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ProfilesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ProfilesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ProfilesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ProfilesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ProfilesDeleteFuture.Result.
func (future *ProfilesDeleteFuture) result(client ProfilesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "customerinsights.ProfilesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("customerinsights.ProfilesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ProfileTypeDefinition the profile type definition.
type ProfileTypeDefinition struct {
	// StrongIds - The strong IDs.
	StrongIds *[]StrongID `json:"strongIds,omitempty"`
	// APIEntitySetName - The api entity set name. This becomes the odata entity set name for the entity Type being referred in this object.
	APIEntitySetName *string `json:"apiEntitySetName,omitempty"`
	// EntityType - Type of entity. Possible values include: 'EntityTypesNone', 'EntityTypesProfile', 'EntityTypesInteraction', 'EntityTypesRelationship'
	EntityType EntityTypes `json:"entityType,omitempty"`
	// Fields - The properties of the Profile.
	Fields *[]PropertyDefinition `json:"fields,omitempty"`
	// InstancesCount - The instance count.
	InstancesCount *int32 `json:"instancesCount,omitempty"`
	// LastChangedUtc - READ-ONLY; The last changed time for the type definition.
	LastChangedUtc *date.Time `json:"lastChangedUtc,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning state. Possible values include: 'ProvisioningStatesProvisioning', 'ProvisioningStatesSucceeded', 'ProvisioningStatesExpiring', 'ProvisioningStatesDeleting', 'ProvisioningStatesHumanIntervention', 'ProvisioningStatesFailed'
	ProvisioningState ProvisioningStates `json:"provisioningState,omitempty"`
	// SchemaItemTypeLink - The schema org link. This helps ACI identify and suggest semantic models.
	SchemaItemTypeLink *string `json:"schemaItemTypeLink,omitempty"`
	// TenantID - READ-ONLY; The hub name.
	TenantID *string `json:"tenantId,omitempty"`
	// TimestampFieldName - The timestamp property name. Represents the time when the interaction or profile update happened.
	TimestampFieldName *string `json:"timestampFieldName,omitempty"`
	// TypeName - The name of the entity.
	TypeName *string `json:"typeName,omitempty"`
	// Attributes - The attributes for the Type.
	Attributes map[string][]string `json:"attributes"`
	// Description - Localized descriptions for the property.
	Description map[string]*string `json:"description"`
	// DisplayName - Localized display names for the property.
	DisplayName map[string]*string `json:"displayName"`
	// LocalizedAttributes - Any custom localized attributes for the Type.
	LocalizedAttributes map[string]map[string]*string `json:"localizedAttributes"`
	// SmallImage - Small Image associated with the Property or EntityType.
	SmallImage *string `json:"smallImage,omitempty"`
	// MediumImage - Medium Image associated with the Property or EntityType.
	MediumImage *string `json:"mediumImage,omitempty"`
	// LargeImage - Large Image associated with the Property or EntityType.
	LargeImage *string `json:"largeImage,omitempty"`
}

// MarshalJSON is the custom marshaler for ProfileTypeDefinition.
func (ptd ProfileTypeDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ptd.StrongIds != nil {
		objectMap["strongIds"] = ptd.StrongIds
	}
	if ptd.APIEntitySetName != nil {
		objectMap["apiEntitySetName"] = ptd.APIEntitySetName
	}
	if ptd.EntityType != "" {
		objectMap["entityType"] = ptd.EntityType
	}
	if ptd.Fields != nil {
		objectMap["fields"] = ptd.Fields
	}
	if ptd.InstancesCount != nil {
		objectMap["instancesCount"] = ptd.InstancesCount
	}
	if ptd.SchemaItemTypeLink != nil {
		objectMap["schemaItemTypeLink"] = ptd.SchemaItemTypeLink
	}
	if ptd.TimestampFieldName != nil {
		objectMap["timestampFieldName"] = ptd.TimestampFieldName
	}
	if ptd.TypeName != nil {
		objectMap["typeName"] = ptd.TypeName
	}
	if ptd.Attributes != nil {
		objectMap["attributes"] = ptd.Attributes
	}
	if ptd.Description != nil {
		objectMap["description"] = ptd.Description
	}
	if ptd.DisplayName != nil {
		objectMap["displayName"] = ptd.DisplayName
	}
	if ptd.LocalizedAttributes != nil {
		objectMap["localizedAttributes"] = ptd.LocalizedAttributes
	}
	if ptd.SmallImage != nil {
		objectMap["smallImage"] = ptd.SmallImage
	}
	if ptd.MediumImage != nil {
		objectMap["mediumImage"] = ptd.MediumImage
	}
	if ptd.LargeImage != nil {
		objectMap["largeImage"] = ptd.LargeImage
	}
	return json.Marshal(objectMap)
}

// PropertyDefinition property definition.
type PropertyDefinition struct {
	// ArrayValueSeparator - Array value separator for properties with isArray set.
	ArrayValueSeparator *string `json:"arrayValueSeparator,omitempty"`
	// EnumValidValues - Describes valid values for an enum property.
	EnumValidValues *[]ProfileEnumValidValuesFormat `json:"enumValidValues,omitempty"`
	// FieldName - Name of the property.
	FieldName *string `json:"fieldName,omitempty"`
	// FieldType - Type of the property.
	FieldType *string `json:"fieldType,omitempty"`
	// IsArray - Indicates if the property is actually an array of the fieldType above on the data api.
	IsArray *bool `json:"isArray,omitempty"`
	// IsEnum - Indicates if the property is an enum.
	IsEnum *bool `json:"isEnum,omitempty"`
	// IsFlagEnum - Indicates if the property is an flag enum.
	IsFlagEnum *bool `json:"isFlagEnum,omitempty"`
	// IsImage - Whether the property is an Image.
	IsImage *bool `json:"isImage,omitempty"`
	// IsLocalizedString - Whether the property is a localized string.
	IsLocalizedString *bool `json:"isLocalizedString,omitempty"`
	// IsName - Whether the property is a name or a part of name.
	IsName *bool `json:"isName,omitempty"`
	// IsRequired - Whether property value is required on instances, IsRequired field only for Interaction. Profile Instance will not check for required field.
	IsRequired *bool `json:"isRequired,omitempty"`
	// PropertyID - The ID associated with the property.
	PropertyID *string `json:"propertyId,omitempty"`
	// SchemaItemPropLink - URL encoded schema.org item prop link for the property.
	SchemaItemPropLink *string `json:"schemaItemPropLink,omitempty"`
	// MaxLength - Max length of string. Used only if type is string.
	MaxLength *int32 `json:"maxLength,omitempty"`
	// IsAvailableInGraph - Whether property is available in graph or not.
	IsAvailableInGraph *bool `json:"isAvailableInGraph,omitempty"`
	// DataSourcePrecedenceRules - READ-ONLY; This is specific to interactions modeled as activities. Data sources are used to determine where data is stored and also in precedence rules.
	DataSourcePrecedenceRules *[]DataSourcePrecedence `json:"dataSourcePrecedenceRules,omitempty"`
}

// MarshalJSON is the custom marshaler for PropertyDefinition.
func (pd PropertyDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pd.ArrayValueSeparator != nil {
		objectMap["arrayValueSeparator"] = pd.ArrayValueSeparator
	}
	if pd.EnumValidValues != nil {
		objectMap["enumValidValues"] = pd.EnumValidValues
	}
	if pd.FieldName != nil {
		objectMap["fieldName"] = pd.FieldName
	}
	if pd.FieldType != nil {
		objectMap["fieldType"] = pd.FieldType
	}
	if pd.IsArray != nil {
		objectMap["isArray"] = pd.IsArray
	}
	if pd.IsEnum != nil {
		objectMap["isEnum"] = pd.IsEnum
	}
	if pd.IsFlagEnum != nil {
		objectMap["isFlagEnum"] = pd.IsFlagEnum
	}
	if pd.IsImage != nil {
		objectMap["isImage"] = pd.IsImage
	}
	if pd.IsLocalizedString != nil {
		objectMap["isLocalizedString"] = pd.IsLocalizedString
	}
	if pd.IsName != nil {
		objectMap["isName"] = pd.IsName
	}
	if pd.IsRequired != nil {
		objectMap["isRequired"] = pd.IsRequired
	}
	if pd.PropertyID != nil {
		objectMap["propertyId"] = pd.PropertyID
	}
	if pd.SchemaItemPropLink != nil {
		objectMap["schemaItemPropLink"] = pd.SchemaItemPropLink
	}
	if pd.MaxLength != nil {
		objectMap["maxLength"] = pd.MaxLength
	}
	if pd.IsAvailableInGraph != nil {
		objectMap["isAvailableInGraph"] = pd.IsAvailableInGraph
	}
	return json.Marshal(objectMap)
}

// ProxyResource common properties of proxy resource.
type ProxyResource struct {
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// RelationshipDefinition the definition of Relationship.
type RelationshipDefinition struct {
	// Cardinality - The Relationship Cardinality. Possible values include: 'OneToOne', 'OneToMany', 'ManyToMany'
	Cardinality CardinalityTypes `json:"cardinality,omitempty"`
	// DisplayName - Localized display name for the Relationship.
	DisplayName map[string]*string `json:"displayName"`
	// Description - Localized descriptions for the Relationship.
	Description map[string]*string `json:"description"`
	// ExpiryDateTimeUtc - The expiry date time in UTC.
	ExpiryDateTimeUtc *date.Time `json:"expiryDateTimeUtc,omitempty"`
	// Fields - The properties of the Relationship.
	Fields *[]PropertyDefinition `json:"fields,omitempty"`
	// LookupMappings - Optional property to be used to map fields in profile to their strong ids in related profile.
	LookupMappings *[]RelationshipTypeMapping `json:"lookupMappings,omitempty"`
	// ProfileType - Profile type.
	ProfileType *string `json:"profileType,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning state. Possible values include: 'ProvisioningStatesProvisioning', 'ProvisioningStatesSucceeded', 'ProvisioningStatesExpiring', 'ProvisioningStatesDeleting', 'ProvisioningStatesHumanIntervention', 'ProvisioningStatesFailed'
	ProvisioningState ProvisioningStates `json:"provisioningState,omitempty"`
	// RelationshipName - READ-ONLY; The Relationship name.
	RelationshipName *string `json:"relationshipName,omitempty"`
	// RelatedProfileType - Related profile being referenced.
	RelatedProfileType *string `json:"relatedProfileType,omitempty"`
	// RelationshipGUIDID - READ-ONLY; The relationship guid id.
	RelationshipGUIDID *string `json:"relationshipGuidId,omitempty"`
	// TenantID - READ-ONLY; The hub name.
	TenantID *string `json:"tenantId,omitempty"`
}

// MarshalJSON is the custom marshaler for RelationshipDefinition.
func (rd RelationshipDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rd.Cardinality != "" {
		objectMap["cardinality"] = rd.Cardinality
	}
	if rd.DisplayName != nil {
		objectMap["displayName"] = rd.DisplayName
	}
	if rd.Description != nil {
		objectMap["description"] = rd.Description
	}
	if rd.ExpiryDateTimeUtc != nil {
		objectMap["expiryDateTimeUtc"] = rd.ExpiryDateTimeUtc
	}
	if rd.Fields != nil {
		objectMap["fields"] = rd.Fields
	}
	if rd.LookupMappings != nil {
		objectMap["lookupMappings"] = rd.LookupMappings
	}
	if rd.ProfileType != nil {
		objectMap["profileType"] = rd.ProfileType
	}
	if rd.RelatedProfileType != nil {
		objectMap["relatedProfileType"] = rd.RelatedProfileType
	}
	return json.Marshal(objectMap)
}

// RelationshipLinkDefinition the definition of relationship link.
type RelationshipLinkDefinition struct {
	// DisplayName - Localized display name for the Relationship Link.
	DisplayName map[string]*string `json:"displayName"`
	// Description - Localized descriptions for the Relationship Link.
	Description map[string]*string `json:"description"`
	// InteractionType - The InteractionType associated with the Relationship Link.
	InteractionType *string `json:"interactionType,omitempty"`
	// LinkName - READ-ONLY; The name of the Relationship Link.
	LinkName *string `json:"linkName,omitempty"`
	// Mappings - The mappings between Interaction and Relationship fields.
	Mappings *[]RelationshipLinkFieldMapping `json:"mappings,omitempty"`
	// ProfilePropertyReferences - The property references for the Profile of the Relationship.
	ProfilePropertyReferences *[]ParticipantProfilePropertyReference `json:"profilePropertyReferences,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning state. Possible values include: 'ProvisioningStatesProvisioning', 'ProvisioningStatesSucceeded', 'ProvisioningStatesExpiring', 'ProvisioningStatesDeleting', 'ProvisioningStatesHumanIntervention', 'ProvisioningStatesFailed'
	ProvisioningState ProvisioningStates `json:"provisioningState,omitempty"`
	// RelatedProfilePropertyReferences - The property references for the Related Profile of the Relationship.
	RelatedProfilePropertyReferences *[]ParticipantProfilePropertyReference `json:"relatedProfilePropertyReferences,omitempty"`
	// RelationshipName - The Relationship associated with the Link.
	RelationshipName *string `json:"relationshipName,omitempty"`
	// RelationshipGUIDID - READ-ONLY; The relationship guid id.
	RelationshipGUIDID *string `json:"relationshipGuidId,omitempty"`
	// TenantID - READ-ONLY; The hub name.
	TenantID *string `json:"tenantId,omitempty"`
}

// MarshalJSON is the custom marshaler for RelationshipLinkDefinition.
func (rld RelationshipLinkDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rld.DisplayName != nil {
		objectMap["displayName"] = rld.DisplayName
	}
	if rld.Description != nil {
		objectMap["description"] = rld.Description
	}
	if rld.InteractionType != nil {
		objectMap["interactionType"] = rld.InteractionType
	}
	if rld.Mappings != nil {
		objectMap["mappings"] = rld.Mappings
	}
	if rld.ProfilePropertyReferences != nil {
		objectMap["profilePropertyReferences"] = rld.ProfilePropertyReferences
	}
	if rld.RelatedProfilePropertyReferences != nil {
		objectMap["relatedProfilePropertyReferences"] = rld.RelatedProfilePropertyReferences
	}
	if rld.RelationshipName != nil {
		objectMap["relationshipName"] = rld.RelationshipName
	}
	return json.Marshal(objectMap)
}

// RelationshipLinkFieldMapping the fields mapping for Relationships.
type RelationshipLinkFieldMapping struct {
	// InteractionFieldName - The field name on the Interaction Type.
	InteractionFieldName *string `json:"interactionFieldName,omitempty"`
	// LinkType - Link type. Possible values include: 'UpdateAlways', 'CopyIfNull'
	LinkType LinkTypes `json:"linkType,omitempty"`
	// RelationshipFieldName - The field name on the Relationship metadata.
	RelationshipFieldName *string `json:"relationshipFieldName,omitempty"`
}

// RelationshipLinkListResult the response of list relationship link operation.
type RelationshipLinkListResult struct {
	autorest.Response `json:"-"`
	// Value - Results of the list operation.
	Value *[]RelationshipLinkResourceFormat `json:"value,omitempty"`
	// NextLink - Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// RelationshipLinkListResultIterator provides access to a complete listing of
// RelationshipLinkResourceFormat values.
type RelationshipLinkListResultIterator struct {
	i    int
	page RelationshipLinkListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RelationshipLinkListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RelationshipLinkListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *RelationshipLinkListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RelationshipLinkListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RelationshipLinkListResultIterator) Response() RelationshipLinkListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RelationshipLinkListResultIterator) Value() RelationshipLinkResourceFormat {
	if !iter.page.NotDone() {
		return RelationshipLinkResourceFormat{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the RelationshipLinkListResultIterator type.
func NewRelationshipLinkListResultIterator(page RelationshipLinkListResultPage) RelationshipLinkListResultIterator {
	return RelationshipLinkListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rllr RelationshipLinkListResult) IsEmpty() bool {
	return rllr.Value == nil || len(*rllr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rllr RelationshipLinkListResult) hasNextLink() bool {
	return rllr.NextLink != nil && len(*rllr.NextLink) != 0
}

// relationshipLinkListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rllr RelationshipLinkListResult) relationshipLinkListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !rllr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rllr.NextLink)))
}

// RelationshipLinkListResultPage contains a page of RelationshipLinkResourceFormat values.
type RelationshipLinkListResultPage struct {
	fn   func(context.Context, RelationshipLinkListResult) (RelationshipLinkListResult, error)
	rllr RelationshipLinkListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RelationshipLinkListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RelationshipLinkListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rllr)
		if err != nil {
			return err
		}
		page.rllr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *RelationshipLinkListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RelationshipLinkListResultPage) NotDone() bool {
	return !page.rllr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RelationshipLinkListResultPage) Response() RelationshipLinkListResult {
	return page.rllr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RelationshipLinkListResultPage) Values() []RelationshipLinkResourceFormat {
	if page.rllr.IsEmpty() {
		return nil
	}
	return *page.rllr.Value
}

// Creates a new instance of the RelationshipLinkListResultPage type.
func NewRelationshipLinkListResultPage(cur RelationshipLinkListResult, getNextPage func(context.Context, RelationshipLinkListResult) (RelationshipLinkListResult, error)) RelationshipLinkListResultPage {
	return RelationshipLinkListResultPage{
		fn:   getNextPage,
		rllr: cur,
	}
}

// RelationshipLinkResourceFormat the relationship link resource format.
type RelationshipLinkResourceFormat struct {
	autorest.Response           `json:"-"`
	*RelationshipLinkDefinition `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for RelationshipLinkResourceFormat.
func (rlrf RelationshipLinkResourceFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rlrf.RelationshipLinkDefinition != nil {
		objectMap["properties"] = rlrf.RelationshipLinkDefinition
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RelationshipLinkResourceFormat struct.
func (rlrf *RelationshipLinkResourceFormat) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var relationshipLinkDefinition RelationshipLinkDefinition
				err = json.Unmarshal(*v, &relationshipLinkDefinition)
				if err != nil {
					return err
				}
				rlrf.RelationshipLinkDefinition = &relationshipLinkDefinition
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rlrf.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rlrf.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rlrf.Type = &typeVar
			}
		}
	}

	return nil
}

// RelationshipLinksCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type RelationshipLinksCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(RelationshipLinksClient) (RelationshipLinkResourceFormat, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *RelationshipLinksCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for RelationshipLinksCreateOrUpdateFuture.Result.
func (future *RelationshipLinksCreateOrUpdateFuture) result(client RelationshipLinksClient) (rlrf RelationshipLinkResourceFormat, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "customerinsights.RelationshipLinksCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		rlrf.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("customerinsights.RelationshipLinksCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if rlrf.Response.Response, err = future.GetResult(sender); err == nil && rlrf.Response.Response.StatusCode != http.StatusNoContent {
		rlrf, err = client.CreateOrUpdateResponder(rlrf.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "customerinsights.RelationshipLinksCreateOrUpdateFuture", "Result", rlrf.Response.Response, "Failure responding to request")
		}
	}
	return
}

// RelationshipLinksDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type RelationshipLinksDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(RelationshipLinksClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *RelationshipLinksDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for RelationshipLinksDeleteFuture.Result.
func (future *RelationshipLinksDeleteFuture) result(client RelationshipLinksClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "customerinsights.RelationshipLinksDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("customerinsights.RelationshipLinksDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// RelationshipListResult the response of list relationship operation.
type RelationshipListResult struct {
	autorest.Response `json:"-"`
	// Value - Results of the list operation.
	Value *[]RelationshipResourceFormat `json:"value,omitempty"`
	// NextLink - Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// RelationshipListResultIterator provides access to a complete listing of RelationshipResourceFormat
// values.
type RelationshipListResultIterator struct {
	i    int
	page RelationshipListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RelationshipListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RelationshipListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *RelationshipListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RelationshipListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RelationshipListResultIterator) Response() RelationshipListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RelationshipListResultIterator) Value() RelationshipResourceFormat {
	if !iter.page.NotDone() {
		return RelationshipResourceFormat{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the RelationshipListResultIterator type.
func NewRelationshipListResultIterator(page RelationshipListResultPage) RelationshipListResultIterator {
	return RelationshipListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rlr RelationshipListResult) IsEmpty() bool {
	return rlr.Value == nil || len(*rlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rlr RelationshipListResult) hasNextLink() bool {
	return rlr.NextLink != nil && len(*rlr.NextLink) != 0
}

// relationshipListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rlr RelationshipListResult) relationshipListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !rlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rlr.NextLink)))
}

// RelationshipListResultPage contains a page of RelationshipResourceFormat values.
type RelationshipListResultPage struct {
	fn  func(context.Context, RelationshipListResult) (RelationshipListResult, error)
	rlr RelationshipListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RelationshipListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RelationshipListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rlr)
		if err != nil {
			return err
		}
		page.rlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *RelationshipListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RelationshipListResultPage) NotDone() bool {
	return !page.rlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RelationshipListResultPage) Response() RelationshipListResult {
	return page.rlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RelationshipListResultPage) Values() []RelationshipResourceFormat {
	if page.rlr.IsEmpty() {
		return nil
	}
	return *page.rlr.Value
}

// Creates a new instance of the RelationshipListResultPage type.
func NewRelationshipListResultPage(cur RelationshipListResult, getNextPage func(context.Context, RelationshipListResult) (RelationshipListResult, error)) RelationshipListResultPage {
	return RelationshipListResultPage{
		fn:  getNextPage,
		rlr: cur,
	}
}

// RelationshipResourceFormat the relationship resource format.
type RelationshipResourceFormat struct {
	autorest.Response       `json:"-"`
	*RelationshipDefinition `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for RelationshipResourceFormat.
func (rrf RelationshipResourceFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rrf.RelationshipDefinition != nil {
		objectMap["properties"] = rrf.RelationshipDefinition
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RelationshipResourceFormat struct.
func (rrf *RelationshipResourceFormat) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var relationshipDefinition RelationshipDefinition
				err = json.Unmarshal(*v, &relationshipDefinition)
				if err != nil {
					return err
				}
				rrf.RelationshipDefinition = &relationshipDefinition
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rrf.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rrf.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rrf.Type = &typeVar
			}
		}
	}

	return nil
}

// RelationshipsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type RelationshipsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(RelationshipsClient) (RelationshipResourceFormat, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *RelationshipsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for RelationshipsCreateOrUpdateFuture.Result.
func (future *RelationshipsCreateOrUpdateFuture) result(client RelationshipsClient) (rrf RelationshipResourceFormat, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "customerinsights.RelationshipsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		rrf.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("customerinsights.RelationshipsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if rrf.Response.Response, err = future.GetResult(sender); err == nil && rrf.Response.Response.StatusCode != http.StatusNoContent {
		rrf, err = client.CreateOrUpdateResponder(rrf.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "customerinsights.RelationshipsCreateOrUpdateFuture", "Result", rrf.Response.Response, "Failure responding to request")
		}
	}
	return
}

// RelationshipsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type RelationshipsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(RelationshipsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *RelationshipsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for RelationshipsDeleteFuture.Result.
func (future *RelationshipsDeleteFuture) result(client RelationshipsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "customerinsights.RelationshipsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("customerinsights.RelationshipsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// RelationshipsLookup the definition of suggested relationship for the type.
type RelationshipsLookup struct {
	// ProfileName - READ-ONLY; The relationship profile.
	ProfileName *string `json:"profileName,omitempty"`
	// ProfilePropertyReferences - READ-ONLY; The property references for the profile type.
	ProfilePropertyReferences *[]ParticipantProfilePropertyReference `json:"profilePropertyReferences,omitempty"`
	// RelatedProfileName - READ-ONLY; The related profile.
	RelatedProfileName *string `json:"relatedProfileName,omitempty"`
	// RelatedProfilePropertyReferences - READ-ONLY; The property references for the related profile type.
	RelatedProfilePropertyReferences *[]ParticipantProfilePropertyReference `json:"relatedProfilePropertyReferences,omitempty"`
	// ExistingRelationshipName - READ-ONLY; The name of existing Relationship.
	ExistingRelationshipName *string `json:"existingRelationshipName,omitempty"`
}

// RelationshipTypeFieldMapping map a field of profile to its corresponding StrongId in Related Profile.
type RelationshipTypeFieldMapping struct {
	// ProfileFieldName - Specifies the fieldName in profile.
	ProfileFieldName *string `json:"profileFieldName,omitempty"`
	// RelatedProfileKeyProperty - Specifies the KeyProperty (from StrongId) of the related profile.
	RelatedProfileKeyProperty *string `json:"relatedProfileKeyProperty,omitempty"`
}

// RelationshipTypeMapping maps fields in Profile to their corresponding StrongIds in Related Profile.
type RelationshipTypeMapping struct {
	// FieldMappings - Maps a profile property with the StrongId of related profile. This is an array to support StrongIds that are composite key as well.
	FieldMappings *[]RelationshipTypeFieldMapping `json:"fieldMappings,omitempty"`
}

// Resource common properties of Azure resource.
type Resource struct {
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	return json.Marshal(objectMap)
}

// ResourceSetDescription the resource set description.
type ResourceSetDescription struct {
	// Elements - The elements included in the set.
	Elements *[]string `json:"elements,omitempty"`
	// Exceptions - The elements that are not included in the set, in case elements contains '*' indicating 'all'.
	Exceptions *[]string `json:"exceptions,omitempty"`
}

// Role the Role definition.
type Role struct {
	// RoleName - The role name.
	RoleName *string `json:"roleName,omitempty"`
	// Description - The description of the role.
	Description *string `json:"description,omitempty"`
}

// RoleAssignment the Role Assignment definition.
type RoleAssignment struct {
	// TenantID - READ-ONLY; The hub name.
	TenantID *string `json:"tenantId,omitempty"`
	// AssignmentName - READ-ONLY; The name of the metadata object.
	AssignmentName *string `json:"assignmentName,omitempty"`
	// DisplayName - Localized display names for the metadata.
	DisplayName map[string]*string `json:"displayName"`
	// Description - Localized description for the metadata.
	Description map[string]*string `json:"description"`
	// ProvisioningState - READ-ONLY; Provisioning state. Possible values include: 'ProvisioningStatesProvisioning', 'ProvisioningStatesSucceeded', 'ProvisioningStatesExpiring', 'ProvisioningStatesDeleting', 'ProvisioningStatesHumanIntervention', 'ProvisioningStatesFailed'
	ProvisioningState ProvisioningStates `json:"provisioningState,omitempty"`
	// Role - Type of roles. Possible values include: 'Admin', 'Reader', 'ManageAdmin', 'ManageReader', 'DataAdmin', 'DataReader'
	Role RoleTypes `json:"role,omitempty"`
	// Principals - The principals being assigned to.
	Principals *[]AssignmentPrincipal `json:"principals,omitempty"`
	// Profiles - Profiles set for the assignment.
	Profiles *ResourceSetDescription `json:"profiles,omitempty"`
	// Interactions - Interactions set for the assignment.
	Interactions *ResourceSetDescription `json:"interactions,omitempty"`
	// Links - Links set for the assignment.
	Links *ResourceSetDescription `json:"links,omitempty"`
	// Kpis - Kpis set for the assignment.
	Kpis *ResourceSetDescription `json:"kpis,omitempty"`
	// SasPolicies - Sas Policies set for the assignment.
	SasPolicies *ResourceSetDescription `json:"sasPolicies,omitempty"`
	// Connectors - Connectors set for the assignment.
	Connectors *ResourceSetDescription `json:"connectors,omitempty"`
	// Views - Views set for the assignment.
	Views *ResourceSetDescription `json:"views,omitempty"`
	// RelationshipLinks - The Role assignments set for the relationship links.
	RelationshipLinks *ResourceSetDescription `json:"relationshipLinks,omitempty"`
	// Relationships - The Role assignments set for the relationships.
	Relationships *ResourceSetDescription `json:"relationships,omitempty"`
	// WidgetTypes - Widget types set for the assignment.
	WidgetTypes *ResourceSetDescription `json:"widgetTypes,omitempty"`
	// RoleAssignments - The Role assignments set for the assignment.
	RoleAssignments *ResourceSetDescription `json:"roleAssignments,omitempty"`
	// ConflationPolicies - Widget types set for the assignment.
	ConflationPolicies *ResourceSetDescription `json:"conflationPolicies,omitempty"`
	// Segments - The Role assignments set for the assignment.
	Segments *ResourceSetDescription `json:"segments,omitempty"`
}

// MarshalJSON is the custom marshaler for RoleAssignment.
func (ra RoleAssignment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ra.DisplayName != nil {
		objectMap["displayName"] = ra.DisplayName
	}
	if ra.Description != nil {
		objectMap["description"] = ra.Description
	}
	if ra.Role != "" {
		objectMap["role"] = ra.Role
	}
	if ra.Principals != nil {
		objectMap["principals"] = ra.Principals
	}
	if ra.Profiles != nil {
		objectMap["profiles"] = ra.Profiles
	}
	if ra.Interactions != nil {
		objectMap["interactions"] = ra.Interactions
	}
	if ra.Links != nil {
		objectMap["links"] = ra.Links
	}
	if ra.Kpis != nil {
		objectMap["kpis"] = ra.Kpis
	}
	if ra.SasPolicies != nil {
		objectMap["sasPolicies"] = ra.SasPolicies
	}
	if ra.Connectors != nil {
		objectMap["connectors"] = ra.Connectors
	}
	if ra.Views != nil {
		objectMap["views"] = ra.Views
	}
	if ra.RelationshipLinks != nil {
		objectMap["relationshipLinks"] = ra.RelationshipLinks
	}
	if ra.Relationships != nil {
		objectMap["relationships"] = ra.Relationships
	}
	if ra.WidgetTypes != nil {
		objectMap["widgetTypes"] = ra.WidgetTypes
	}
	if ra.RoleAssignments != nil {
		objectMap["roleAssignments"] = ra.RoleAssignments
	}
	if ra.ConflationPolicies != nil {
		objectMap["conflationPolicies"] = ra.ConflationPolicies
	}
	if ra.Segments != nil {
		objectMap["segments"] = ra.Segments
	}
	return json.Marshal(objectMap)
}

// RoleAssignmentListResult the response of list role assignment operation.
type RoleAssignmentListResult struct {
	autorest.Response `json:"-"`
	// Value - Results of the list operation.
	Value *[]RoleAssignmentResourceFormat `json:"value,omitempty"`
	// NextLink - Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// RoleAssignmentListResultIterator provides access to a complete listing of RoleAssignmentResourceFormat
// values.
type RoleAssignmentListResultIterator struct {
	i    int
	page RoleAssignmentListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RoleAssignmentListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RoleAssignmentListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *RoleAssignmentListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RoleAssignmentListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RoleAssignmentListResultIterator) Response() RoleAssignmentListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RoleAssignmentListResultIterator) Value() RoleAssignmentResourceFormat {
	if !iter.page.NotDone() {
		return RoleAssignmentResourceFormat{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the RoleAssignmentListResultIterator type.
func NewRoleAssignmentListResultIterator(page RoleAssignmentListResultPage) RoleAssignmentListResultIterator {
	return RoleAssignmentListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ralr RoleAssignmentListResult) IsEmpty() bool {
	return ralr.Value == nil || len(*ralr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ralr RoleAssignmentListResult) hasNextLink() bool {
	return ralr.NextLink != nil && len(*ralr.NextLink) != 0
}

// roleAssignmentListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ralr RoleAssignmentListResult) roleAssignmentListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !ralr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ralr.NextLink)))
}

// RoleAssignmentListResultPage contains a page of RoleAssignmentResourceFormat values.
type RoleAssignmentListResultPage struct {
	fn   func(context.Context, RoleAssignmentListResult) (RoleAssignmentListResult, error)
	ralr RoleAssignmentListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RoleAssignmentListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RoleAssignmentListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ralr)
		if err != nil {
			return err
		}
		page.ralr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *RoleAssignmentListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RoleAssignmentListResultPage) NotDone() bool {
	return !page.ralr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RoleAssignmentListResultPage) Response() RoleAssignmentListResult {
	return page.ralr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RoleAssignmentListResultPage) Values() []RoleAssignmentResourceFormat {
	if page.ralr.IsEmpty() {
		return nil
	}
	return *page.ralr.Value
}

// Creates a new instance of the RoleAssignmentListResultPage type.
func NewRoleAssignmentListResultPage(cur RoleAssignmentListResult, getNextPage func(context.Context, RoleAssignmentListResult) (RoleAssignmentListResult, error)) RoleAssignmentListResultPage {
	return RoleAssignmentListResultPage{
		fn:   getNextPage,
		ralr: cur,
	}
}

// RoleAssignmentResourceFormat the Role Assignment resource format.
type RoleAssignmentResourceFormat struct {
	autorest.Response `json:"-"`
	*RoleAssignment   `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for RoleAssignmentResourceFormat.
func (rarf RoleAssignmentResourceFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rarf.RoleAssignment != nil {
		objectMap["properties"] = rarf.RoleAssignment
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RoleAssignmentResourceFormat struct.
func (rarf *RoleAssignmentResourceFormat) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var roleAssignment RoleAssignment
				err = json.Unmarshal(*v, &roleAssignment)
				if err != nil {
					return err
				}
				rarf.RoleAssignment = &roleAssignment
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rarf.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rarf.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rarf.Type = &typeVar
			}
		}
	}

	return nil
}

// RoleAssignmentsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type RoleAssignmentsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(RoleAssignmentsClient) (RoleAssignmentResourceFormat, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *RoleAssignmentsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for RoleAssignmentsCreateOrUpdateFuture.Result.
func (future *RoleAssignmentsCreateOrUpdateFuture) result(client RoleAssignmentsClient) (rarf RoleAssignmentResourceFormat, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "customerinsights.RoleAssignmentsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		rarf.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("customerinsights.RoleAssignmentsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if rarf.Response.Response, err = future.GetResult(sender); err == nil && rarf.Response.Response.StatusCode != http.StatusNoContent {
		rarf, err = client.CreateOrUpdateResponder(rarf.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "customerinsights.RoleAssignmentsCreateOrUpdateFuture", "Result", rarf.Response.Response, "Failure responding to request")
		}
	}
	return
}

// RoleListResult the response of list role assignment operation.
type RoleListResult struct {
	autorest.Response `json:"-"`
	// Value - Results of the list operation.
	Value *[]RoleResourceFormat `json:"value,omitempty"`
	// NextLink - Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// RoleListResultIterator provides access to a complete listing of RoleResourceFormat values.
type RoleListResultIterator struct {
	i    int
	page RoleListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RoleListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RoleListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *RoleListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RoleListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RoleListResultIterator) Response() RoleListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RoleListResultIterator) Value() RoleResourceFormat {
	if !iter.page.NotDone() {
		return RoleResourceFormat{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the RoleListResultIterator type.
func NewRoleListResultIterator(page RoleListResultPage) RoleListResultIterator {
	return RoleListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rlr RoleListResult) IsEmpty() bool {
	return rlr.Value == nil || len(*rlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rlr RoleListResult) hasNextLink() bool {
	return rlr.NextLink != nil && len(*rlr.NextLink) != 0
}

// roleListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rlr RoleListResult) roleListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !rlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rlr.NextLink)))
}

// RoleListResultPage contains a page of RoleResourceFormat values.
type RoleListResultPage struct {
	fn  func(context.Context, RoleListResult) (RoleListResult, error)
	rlr RoleListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RoleListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RoleListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rlr)
		if err != nil {
			return err
		}
		page.rlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *RoleListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RoleListResultPage) NotDone() bool {
	return !page.rlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RoleListResultPage) Response() RoleListResult {
	return page.rlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RoleListResultPage) Values() []RoleResourceFormat {
	if page.rlr.IsEmpty() {
		return nil
	}
	return *page.rlr.Value
}

// Creates a new instance of the RoleListResultPage type.
func NewRoleListResultPage(cur RoleListResult, getNextPage func(context.Context, RoleListResult) (RoleListResult, error)) RoleListResultPage {
	return RoleListResultPage{
		fn:  getNextPage,
		rlr: cur,
	}
}

// RoleResourceFormat the role resource format.
type RoleResourceFormat struct {
	*Role `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for RoleResourceFormat.
func (rrf RoleResourceFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rrf.Role != nil {
		objectMap["properties"] = rrf.Role
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RoleResourceFormat struct.
func (rrf *RoleResourceFormat) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var role Role
				err = json.Unmarshal(*v, &role)
				if err != nil {
					return err
				}
				rrf.Role = &role
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rrf.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rrf.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rrf.Type = &typeVar
			}
		}
	}

	return nil
}

// SalesforceConnectorProperties the Salesforce connector properties.
type SalesforceConnectorProperties struct {
	// Usersetting - The user settings.
	Usersetting *SalesforceDiscoverSetting `json:"usersetting,omitempty"`
	// Salesforcetables - The Salesforce tables.
	Salesforcetables *[]SalesforceTable `json:"salesforcetables,omitempty"`
}

// SalesforceDiscoverSetting salesforce discover setting.
type SalesforceDiscoverSetting struct {
	// SalesforceConnectionStringSecretURL - The salesforce connection string secret URL.
	SalesforceConnectionStringSecretURL *string `json:"salesforceConnectionStringSecretUrl,omitempty"`
}

// SalesforceTable salesforce table.
type SalesforceTable struct {
	// IsProfile - Indicating whether this instance is profile.
	IsProfile *string `json:"isProfile,omitempty"`
	// TableCategory - The table category.
	TableCategory *string `json:"tableCategory,omitempty"`
	// TableName - The name of the table.
	TableName *string `json:"tableName,omitempty"`
	// TableRemarks - The table remarks.
	TableRemarks *string `json:"tableRemarks,omitempty"`
	// TableSchema - The table schema.
	TableSchema *string `json:"tableSchema,omitempty"`
}

// StrongID property/Properties which represent a unique ID.
type StrongID struct {
	// KeyPropertyNames - The properties which make up the unique ID.
	KeyPropertyNames *[]string `json:"keyPropertyNames,omitempty"`
	// StrongIDName - The Name identifying the strong ID.
	StrongIDName *string `json:"strongIdName,omitempty"`
	// DisplayName - Localized display name.
	DisplayName map[string]*string `json:"displayName"`
	// Description - Localized descriptions.
	Description map[string]*string `json:"description"`
}

// MarshalJSON is the custom marshaler for StrongID.
func (si StrongID) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if si.KeyPropertyNames != nil {
		objectMap["keyPropertyNames"] = si.KeyPropertyNames
	}
	if si.StrongIDName != nil {
		objectMap["strongIdName"] = si.StrongIDName
	}
	if si.DisplayName != nil {
		objectMap["displayName"] = si.DisplayName
	}
	if si.Description != nil {
		objectMap["description"] = si.Description
	}
	return json.Marshal(objectMap)
}

// SuggestRelationshipLinksResponse the response of suggest relationship links operation.
type SuggestRelationshipLinksResponse struct {
	autorest.Response `json:"-"`
	// InteractionName - READ-ONLY; The interaction name.
	InteractionName *string `json:"interactionName,omitempty"`
	// SuggestedRelationships - READ-ONLY; Suggested relationships for the type.
	SuggestedRelationships *[]RelationshipsLookup `json:"suggestedRelationships,omitempty"`
}

// TypePropertiesMapping metadata for a Link's property mapping.
type TypePropertiesMapping struct {
	// SourcePropertyName -  Property name on the source Entity Type.
	SourcePropertyName *string `json:"sourcePropertyName,omitempty"`
	// TargetPropertyName - Property name on the target Entity Type.
	TargetPropertyName *string `json:"targetPropertyName,omitempty"`
	// LinkType - Link type. Possible values include: 'UpdateAlways', 'CopyIfNull'
	LinkType LinkTypes `json:"linkType,omitempty"`
}

// View the view in Customer 360 web application.
type View struct {
	// ViewName - READ-ONLY; Name of the view.
	ViewName *string `json:"viewName,omitempty"`
	// UserID - the user ID.
	UserID *string `json:"userId,omitempty"`
	// TenantID - READ-ONLY; the hub name.
	TenantID *string `json:"tenantId,omitempty"`
	// DisplayName - Localized display name for the view.
	DisplayName map[string]*string `json:"displayName"`
	// Definition - View definition.
	Definition *string `json:"definition,omitempty"`
	// Changed - READ-ONLY; Date time when view was last modified.
	Changed *date.Time `json:"changed,omitempty"`
	// Created - READ-ONLY; Date time when view was created.
	Created *date.Time `json:"created,omitempty"`
}

// MarshalJSON is the custom marshaler for View.
func (vVar View) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vVar.UserID != nil {
		objectMap["userId"] = vVar.UserID
	}
	if vVar.DisplayName != nil {
		objectMap["displayName"] = vVar.DisplayName
	}
	if vVar.Definition != nil {
		objectMap["definition"] = vVar.Definition
	}
	return json.Marshal(objectMap)
}

// ViewListResult the response of list view operation.
type ViewListResult struct {
	autorest.Response `json:"-"`
	// Value - Results of the list operation.
	Value *[]ViewResourceFormat `json:"value,omitempty"`
	// NextLink - Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ViewListResultIterator provides access to a complete listing of ViewResourceFormat values.
type ViewListResultIterator struct {
	i    int
	page ViewListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ViewListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ViewListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ViewListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ViewListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ViewListResultIterator) Response() ViewListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ViewListResultIterator) Value() ViewResourceFormat {
	if !iter.page.NotDone() {
		return ViewResourceFormat{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ViewListResultIterator type.
func NewViewListResultIterator(page ViewListResultPage) ViewListResultIterator {
	return ViewListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (vlr ViewListResult) IsEmpty() bool {
	return vlr.Value == nil || len(*vlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (vlr ViewListResult) hasNextLink() bool {
	return vlr.NextLink != nil && len(*vlr.NextLink) != 0
}

// viewListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (vlr ViewListResult) viewListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !vlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(vlr.NextLink)))
}

// ViewListResultPage contains a page of ViewResourceFormat values.
type ViewListResultPage struct {
	fn  func(context.Context, ViewListResult) (ViewListResult, error)
	vlr ViewListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ViewListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ViewListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.vlr)
		if err != nil {
			return err
		}
		page.vlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ViewListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ViewListResultPage) NotDone() bool {
	return !page.vlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ViewListResultPage) Response() ViewListResult {
	return page.vlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ViewListResultPage) Values() []ViewResourceFormat {
	if page.vlr.IsEmpty() {
		return nil
	}
	return *page.vlr.Value
}

// Creates a new instance of the ViewListResultPage type.
func NewViewListResultPage(cur ViewListResult, getNextPage func(context.Context, ViewListResult) (ViewListResult, error)) ViewListResultPage {
	return ViewListResultPage{
		fn:  getNextPage,
		vlr: cur,
	}
}

// ViewResourceFormat the view resource format.
type ViewResourceFormat struct {
	autorest.Response `json:"-"`
	*View             `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ViewResourceFormat.
func (vrf ViewResourceFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vrf.View != nil {
		objectMap["properties"] = vrf.View
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ViewResourceFormat struct.
func (vrf *ViewResourceFormat) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var view View
				err = json.Unmarshal(*v, &view)
				if err != nil {
					return err
				}
				vrf.View = &view
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vrf.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vrf.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vrf.Type = &typeVar
			}
		}
	}

	return nil
}

// WidgetType definition of WidgetType.
type WidgetType struct {
	// WidgetTypeName - READ-ONLY; Name of the widget type.
	WidgetTypeName *string `json:"widgetTypeName,omitempty"`
	// Definition - Definition for widget type.
	Definition *string `json:"definition,omitempty"`
	// Description - Description for widget type.
	Description *string `json:"description,omitempty"`
	// DisplayName - Localized display name for the widget type.
	DisplayName map[string]*string `json:"displayName"`
	// ImageURL - The image URL.
	ImageURL *string `json:"imageUrl,omitempty"`
	// TenantID - READ-ONLY; The hub name.
	TenantID *string `json:"tenantId,omitempty"`
	// WidgetVersion - The widget version.
	WidgetVersion *string `json:"widgetVersion,omitempty"`
	// Changed - READ-ONLY; Date time when widget type was last modified.
	Changed *date.Time `json:"changed,omitempty"`
	// Created - READ-ONLY; Date time when widget type was created.
	Created *date.Time `json:"created,omitempty"`
}

// MarshalJSON is the custom marshaler for WidgetType.
func (wt WidgetType) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wt.Definition != nil {
		objectMap["definition"] = wt.Definition
	}
	if wt.Description != nil {
		objectMap["description"] = wt.Description
	}
	if wt.DisplayName != nil {
		objectMap["displayName"] = wt.DisplayName
	}
	if wt.ImageURL != nil {
		objectMap["imageUrl"] = wt.ImageURL
	}
	if wt.WidgetVersion != nil {
		objectMap["widgetVersion"] = wt.WidgetVersion
	}
	return json.Marshal(objectMap)
}

// WidgetTypeListResult the response of list widget type operation.
type WidgetTypeListResult struct {
	autorest.Response `json:"-"`
	// Value - Results of the list operation.
	Value *[]WidgetTypeResourceFormat `json:"value,omitempty"`
	// NextLink - Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// WidgetTypeListResultIterator provides access to a complete listing of WidgetTypeResourceFormat values.
type WidgetTypeListResultIterator struct {
	i    int
	page WidgetTypeListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *WidgetTypeListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WidgetTypeListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *WidgetTypeListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter WidgetTypeListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter WidgetTypeListResultIterator) Response() WidgetTypeListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter WidgetTypeListResultIterator) Value() WidgetTypeResourceFormat {
	if !iter.page.NotDone() {
		return WidgetTypeResourceFormat{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the WidgetTypeListResultIterator type.
func NewWidgetTypeListResultIterator(page WidgetTypeListResultPage) WidgetTypeListResultIterator {
	return WidgetTypeListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (wtlr WidgetTypeListResult) IsEmpty() bool {
	return wtlr.Value == nil || len(*wtlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (wtlr WidgetTypeListResult) hasNextLink() bool {
	return wtlr.NextLink != nil && len(*wtlr.NextLink) != 0
}

// widgetTypeListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (wtlr WidgetTypeListResult) widgetTypeListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !wtlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(wtlr.NextLink)))
}

// WidgetTypeListResultPage contains a page of WidgetTypeResourceFormat values.
type WidgetTypeListResultPage struct {
	fn   func(context.Context, WidgetTypeListResult) (WidgetTypeListResult, error)
	wtlr WidgetTypeListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *WidgetTypeListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WidgetTypeListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.wtlr)
		if err != nil {
			return err
		}
		page.wtlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *WidgetTypeListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page WidgetTypeListResultPage) NotDone() bool {
	return !page.wtlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page WidgetTypeListResultPage) Response() WidgetTypeListResult {
	return page.wtlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page WidgetTypeListResultPage) Values() []WidgetTypeResourceFormat {
	if page.wtlr.IsEmpty() {
		return nil
	}
	return *page.wtlr.Value
}

// Creates a new instance of the WidgetTypeListResultPage type.
func NewWidgetTypeListResultPage(cur WidgetTypeListResult, getNextPage func(context.Context, WidgetTypeListResult) (WidgetTypeListResult, error)) WidgetTypeListResultPage {
	return WidgetTypeListResultPage{
		fn:   getNextPage,
		wtlr: cur,
	}
}

// WidgetTypeResourceFormat the WidgetTypeResourceFormat
type WidgetTypeResourceFormat struct {
	autorest.Response `json:"-"`
	*WidgetType       `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for WidgetTypeResourceFormat.
func (wtrf WidgetTypeResourceFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wtrf.WidgetType != nil {
		objectMap["properties"] = wtrf.WidgetType
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for WidgetTypeResourceFormat struct.
func (wtrf *WidgetTypeResourceFormat) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var widgetType WidgetType
				err = json.Unmarshal(*v, &widgetType)
				if err != nil {
					return err
				}
				wtrf.WidgetType = &widgetType
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				wtrf.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				wtrf.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				wtrf.Type = &typeVar
			}
		}
	}

	return nil
}
