package securityinsight

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"github.com/gofrs/uuid"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/securityinsight/mgmt/2020-01-01/securityinsight"

// AADDataConnector represents AAD (Azure Active Directory) data connector.
type AADDataConnector struct {
	// AADDataConnectorProperties - AAD (Azure Active Directory) data connector properties.
	*AADDataConnectorProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Etag - Etag of the azure resource
	Etag *string `json:"etag,omitempty"`
	// Kind - Possible values include: 'KindBasicDataConnectorKindDataConnector', 'KindBasicDataConnectorKindAzureActiveDirectory', 'KindBasicDataConnectorKindAzureAdvancedThreatProtection', 'KindBasicDataConnectorKindAzureSecurityCenter', 'KindBasicDataConnectorKindAmazonWebServicesCloudTrail', 'KindBasicDataConnectorKindMicrosoftCloudAppSecurity', 'KindBasicDataConnectorKindMicrosoftDefenderAdvancedThreatProtection', 'KindBasicDataConnectorKindOffice365', 'KindBasicDataConnectorKindThreatIntelligence'
	Kind KindBasicDataConnector `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for AADDataConnector.
func (adc AADDataConnector) MarshalJSON() ([]byte, error) {
	adc.Kind = KindBasicDataConnectorKindAzureActiveDirectory
	objectMap := make(map[string]interface{})
	if adc.AADDataConnectorProperties != nil {
		objectMap["properties"] = adc.AADDataConnectorProperties
	}
	if adc.Kind != "" {
		objectMap["kind"] = adc.Kind
	}
	if adc.Etag != nil {
		objectMap["etag"] = adc.Etag
	}
	return json.Marshal(objectMap)
}

// AsAADDataConnector is the BasicDataConnector implementation for AADDataConnector.
func (adc AADDataConnector) AsAADDataConnector() (*AADDataConnector, bool) {
	return &adc, true
}

// AsAATPDataConnector is the BasicDataConnector implementation for AADDataConnector.
func (adc AADDataConnector) AsAATPDataConnector() (*AATPDataConnector, bool) {
	return nil, false
}

// AsASCDataConnector is the BasicDataConnector implementation for AADDataConnector.
func (adc AADDataConnector) AsASCDataConnector() (*ASCDataConnector, bool) {
	return nil, false
}

// AsAwsCloudTrailDataConnector is the BasicDataConnector implementation for AADDataConnector.
func (adc AADDataConnector) AsAwsCloudTrailDataConnector() (*AwsCloudTrailDataConnector, bool) {
	return nil, false
}

// AsMCASDataConnector is the BasicDataConnector implementation for AADDataConnector.
func (adc AADDataConnector) AsMCASDataConnector() (*MCASDataConnector, bool) {
	return nil, false
}

// AsMDATPDataConnector is the BasicDataConnector implementation for AADDataConnector.
func (adc AADDataConnector) AsMDATPDataConnector() (*MDATPDataConnector, bool) {
	return nil, false
}

// AsOfficeDataConnector is the BasicDataConnector implementation for AADDataConnector.
func (adc AADDataConnector) AsOfficeDataConnector() (*OfficeDataConnector, bool) {
	return nil, false
}

// AsTIDataConnector is the BasicDataConnector implementation for AADDataConnector.
func (adc AADDataConnector) AsTIDataConnector() (*TIDataConnector, bool) {
	return nil, false
}

// AsDataConnector is the BasicDataConnector implementation for AADDataConnector.
func (adc AADDataConnector) AsDataConnector() (*DataConnector, bool) {
	return nil, false
}

// AsBasicDataConnector is the BasicDataConnector implementation for AADDataConnector.
func (adc AADDataConnector) AsBasicDataConnector() (BasicDataConnector, bool) {
	return &adc, true
}

// UnmarshalJSON is the custom unmarshaler for AADDataConnector struct.
func (adc *AADDataConnector) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var aADDataConnectorProperties AADDataConnectorProperties
				err = json.Unmarshal(*v, &aADDataConnectorProperties)
				if err != nil {
					return err
				}
				adc.AADDataConnectorProperties = &aADDataConnectorProperties
			}
		case "kind":
			if v != nil {
				var kind KindBasicDataConnector
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				adc.Kind = kind
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				adc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				adc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				adc.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				adc.Etag = &etag
			}
		}
	}

	return nil
}

// AADDataConnectorProperties AAD (Azure Active Directory) data connector properties.
type AADDataConnectorProperties struct {
	// TenantID - The tenant id to connect to, and get the data from.
	TenantID *string `json:"tenantId,omitempty"`
	// DataTypes - The available data types for the connector.
	DataTypes *AlertsDataTypeOfDataConnector `json:"dataTypes,omitempty"`
}

// AATPDataConnector represents AATP (Azure Advanced Threat Protection) data connector.
type AATPDataConnector struct {
	// AATPDataConnectorProperties - AATP (Azure Advanced Threat Protection) data connector properties.
	*AATPDataConnectorProperties `json:"properties,omitempty"`
	// Kind - Possible values include: 'KindBasicDataConnectorKindDataConnector', 'KindBasicDataConnectorKindAzureActiveDirectory', 'KindBasicDataConnectorKindAzureAdvancedThreatProtection', 'KindBasicDataConnectorKindAzureSecurityCenter', 'KindBasicDataConnectorKindAmazonWebServicesCloudTrail', 'KindBasicDataConnectorKindMicrosoftCloudAppSecurity', 'KindBasicDataConnectorKindMicrosoftDefenderAdvancedThreatProtection', 'KindBasicDataConnectorKindOffice365', 'KindBasicDataConnectorKindThreatIntelligence'
	Kind KindBasicDataConnector `json:"kind,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Etag - Etag of the azure resource
	Etag *string `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for AATPDataConnector.
func (adc AATPDataConnector) MarshalJSON() ([]byte, error) {
	adc.Kind = KindBasicDataConnectorKindAzureAdvancedThreatProtection
	objectMap := make(map[string]interface{})
	if adc.AATPDataConnectorProperties != nil {
		objectMap["properties"] = adc.AATPDataConnectorProperties
	}
	if adc.Kind != "" {
		objectMap["kind"] = adc.Kind
	}
	if adc.Etag != nil {
		objectMap["etag"] = adc.Etag
	}
	return json.Marshal(objectMap)
}

// AsAADDataConnector is the BasicDataConnector implementation for AATPDataConnector.
func (adc AATPDataConnector) AsAADDataConnector() (*AADDataConnector, bool) {
	return nil, false
}

// AsAATPDataConnector is the BasicDataConnector implementation for AATPDataConnector.
func (adc AATPDataConnector) AsAATPDataConnector() (*AATPDataConnector, bool) {
	return &adc, true
}

// AsASCDataConnector is the BasicDataConnector implementation for AATPDataConnector.
func (adc AATPDataConnector) AsASCDataConnector() (*ASCDataConnector, bool) {
	return nil, false
}

// AsAwsCloudTrailDataConnector is the BasicDataConnector implementation for AATPDataConnector.
func (adc AATPDataConnector) AsAwsCloudTrailDataConnector() (*AwsCloudTrailDataConnector, bool) {
	return nil, false
}

// AsMCASDataConnector is the BasicDataConnector implementation for AATPDataConnector.
func (adc AATPDataConnector) AsMCASDataConnector() (*MCASDataConnector, bool) {
	return nil, false
}

// AsMDATPDataConnector is the BasicDataConnector implementation for AATPDataConnector.
func (adc AATPDataConnector) AsMDATPDataConnector() (*MDATPDataConnector, bool) {
	return nil, false
}

// AsOfficeDataConnector is the BasicDataConnector implementation for AATPDataConnector.
func (adc AATPDataConnector) AsOfficeDataConnector() (*OfficeDataConnector, bool) {
	return nil, false
}

// AsTIDataConnector is the BasicDataConnector implementation for AATPDataConnector.
func (adc AATPDataConnector) AsTIDataConnector() (*TIDataConnector, bool) {
	return nil, false
}

// AsDataConnector is the BasicDataConnector implementation for AATPDataConnector.
func (adc AATPDataConnector) AsDataConnector() (*DataConnector, bool) {
	return nil, false
}

// AsBasicDataConnector is the BasicDataConnector implementation for AATPDataConnector.
func (adc AATPDataConnector) AsBasicDataConnector() (BasicDataConnector, bool) {
	return &adc, true
}

// UnmarshalJSON is the custom unmarshaler for AATPDataConnector struct.
func (adc *AATPDataConnector) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var aATPDataConnectorProperties AATPDataConnectorProperties
				err = json.Unmarshal(*v, &aATPDataConnectorProperties)
				if err != nil {
					return err
				}
				adc.AATPDataConnectorProperties = &aATPDataConnectorProperties
			}
		case "kind":
			if v != nil {
				var kind KindBasicDataConnector
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				adc.Kind = kind
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				adc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				adc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				adc.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				adc.Etag = &etag
			}
		}
	}

	return nil
}

// AATPDataConnectorProperties AATP (Azure Advanced Threat Protection) data connector properties.
type AATPDataConnectorProperties struct {
	// TenantID - The tenant id to connect to, and get the data from.
	TenantID *string `json:"tenantId,omitempty"`
	// DataTypes - The available data types for the connector.
	DataTypes *AlertsDataTypeOfDataConnector `json:"dataTypes,omitempty"`
}

// ActionPropertiesBase action property bag base.
type ActionPropertiesBase struct {
	// LogicAppResourceID - Logic App Resource Id, /subscriptions/{my-subscription}/resourceGroups/{my-resource-group}/providers/Microsoft.Logic/workflows/{my-workflow-id}.
	LogicAppResourceID *string `json:"logicAppResourceId,omitempty"`
}

// ActionRequest action for alert rule.
type ActionRequest struct {
	// ActionRequestProperties - Action properties for put request
	*ActionRequestProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Etag - Etag of the azure resource
	Etag *string `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for ActionRequest.
func (ar ActionRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ar.ActionRequestProperties != nil {
		objectMap["properties"] = ar.ActionRequestProperties
	}
	if ar.Etag != nil {
		objectMap["etag"] = ar.Etag
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ActionRequest struct.
func (ar *ActionRequest) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var actionRequestProperties ActionRequestProperties
				err = json.Unmarshal(*v, &actionRequestProperties)
				if err != nil {
					return err
				}
				ar.ActionRequestProperties = &actionRequestProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ar.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ar.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ar.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				ar.Etag = &etag
			}
		}
	}

	return nil
}

// ActionRequestProperties action property bag.
type ActionRequestProperties struct {
	// TriggerURI - Logic App Callback URL for this specific workflow.
	TriggerURI *string `json:"triggerUri,omitempty"`
	// LogicAppResourceID - Logic App Resource Id, /subscriptions/{my-subscription}/resourceGroups/{my-resource-group}/providers/Microsoft.Logic/workflows/{my-workflow-id}.
	LogicAppResourceID *string `json:"logicAppResourceId,omitempty"`
}

// ActionResponse action for alert rule.
type ActionResponse struct {
	autorest.Response `json:"-"`
	// Etag - Etag of the action.
	Etag *string `json:"etag,omitempty"`
	// ActionResponseProperties - Action properties for get request
	*ActionResponseProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ActionResponse.
func (ar ActionResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ar.Etag != nil {
		objectMap["etag"] = ar.Etag
	}
	if ar.ActionResponseProperties != nil {
		objectMap["properties"] = ar.ActionResponseProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ActionResponse struct.
func (ar *ActionResponse) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				ar.Etag = &etag
			}
		case "properties":
			if v != nil {
				var actionResponseProperties ActionResponseProperties
				err = json.Unmarshal(*v, &actionResponseProperties)
				if err != nil {
					return err
				}
				ar.ActionResponseProperties = &actionResponseProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ar.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ar.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ar.Type = &typeVar
			}
		}
	}

	return nil
}

// ActionResponseProperties action property bag.
type ActionResponseProperties struct {
	// WorkflowID - The name of the logic app's workflow.
	WorkflowID *string `json:"workflowId,omitempty"`
	// LogicAppResourceID - Logic App Resource Id, /subscriptions/{my-subscription}/resourceGroups/{my-resource-group}/providers/Microsoft.Logic/workflows/{my-workflow-id}.
	LogicAppResourceID *string `json:"logicAppResourceId,omitempty"`
}

// ActionsList list all the actions.
type ActionsList struct {
	autorest.Response `json:"-"`
	// NextLink - READ-ONLY; URL to fetch the next set of actions.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - Array of actions.
	Value *[]ActionResponse `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for ActionsList.
func (al ActionsList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if al.Value != nil {
		objectMap["value"] = al.Value
	}
	return json.Marshal(objectMap)
}

// ActionsListIterator provides access to a complete listing of ActionResponse values.
type ActionsListIterator struct {
	i    int
	page ActionsListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ActionsListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ActionsListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ActionsListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ActionsListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ActionsListIterator) Response() ActionsList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ActionsListIterator) Value() ActionResponse {
	if !iter.page.NotDone() {
		return ActionResponse{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ActionsListIterator type.
func NewActionsListIterator(page ActionsListPage) ActionsListIterator {
	return ActionsListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (al ActionsList) IsEmpty() bool {
	return al.Value == nil || len(*al.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (al ActionsList) hasNextLink() bool {
	return al.NextLink != nil && len(*al.NextLink) != 0
}

// actionsListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (al ActionsList) actionsListPreparer(ctx context.Context) (*http.Request, error) {
	if !al.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(al.NextLink)))
}

// ActionsListPage contains a page of ActionResponse values.
type ActionsListPage struct {
	fn func(context.Context, ActionsList) (ActionsList, error)
	al ActionsList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ActionsListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ActionsListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.al)
		if err != nil {
			return err
		}
		page.al = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ActionsListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ActionsListPage) NotDone() bool {
	return !page.al.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ActionsListPage) Response() ActionsList {
	return page.al
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ActionsListPage) Values() []ActionResponse {
	if page.al.IsEmpty() {
		return nil
	}
	return *page.al.Value
}

// Creates a new instance of the ActionsListPage type.
func NewActionsListPage(cur ActionsList, getNextPage func(context.Context, ActionsList) (ActionsList, error)) ActionsListPage {
	return ActionsListPage{
		fn: getNextPage,
		al: cur,
	}
}

// BasicAlertRule alert rule.
type BasicAlertRule interface {
	AsFusionAlertRule() (*FusionAlertRule, bool)
	AsMicrosoftSecurityIncidentCreationAlertRule() (*MicrosoftSecurityIncidentCreationAlertRule, bool)
	AsScheduledAlertRule() (*ScheduledAlertRule, bool)
	AsAlertRule() (*AlertRule, bool)
}

// AlertRule alert rule.
type AlertRule struct {
	autorest.Response `json:"-"`
	// Kind - Possible values include: 'KindKindAlertRule', 'KindKindFusion', 'KindKindMicrosoftSecurityIncidentCreation', 'KindKindScheduled'
	Kind Kind `json:"kind,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Etag - Etag of the azure resource
	Etag *string `json:"etag,omitempty"`
}

func unmarshalBasicAlertRule(body []byte) (BasicAlertRule, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["kind"] {
	case string(KindKindFusion):
		var far FusionAlertRule
		err := json.Unmarshal(body, &far)
		return far, err
	case string(KindKindMicrosoftSecurityIncidentCreation):
		var msicar MicrosoftSecurityIncidentCreationAlertRule
		err := json.Unmarshal(body, &msicar)
		return msicar, err
	case string(KindKindScheduled):
		var sar ScheduledAlertRule
		err := json.Unmarshal(body, &sar)
		return sar, err
	default:
		var ar AlertRule
		err := json.Unmarshal(body, &ar)
		return ar, err
	}
}
func unmarshalBasicAlertRuleArray(body []byte) ([]BasicAlertRule, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	arArray := make([]BasicAlertRule, len(rawMessages))

	for index, rawMessage := range rawMessages {
		ar, err := unmarshalBasicAlertRule(*rawMessage)
		if err != nil {
			return nil, err
		}
		arArray[index] = ar
	}
	return arArray, nil
}

// MarshalJSON is the custom marshaler for AlertRule.
func (ar AlertRule) MarshalJSON() ([]byte, error) {
	ar.Kind = KindKindAlertRule
	objectMap := make(map[string]interface{})
	if ar.Kind != "" {
		objectMap["kind"] = ar.Kind
	}
	if ar.Etag != nil {
		objectMap["etag"] = ar.Etag
	}
	return json.Marshal(objectMap)
}

// AsFusionAlertRule is the BasicAlertRule implementation for AlertRule.
func (ar AlertRule) AsFusionAlertRule() (*FusionAlertRule, bool) {
	return nil, false
}

// AsMicrosoftSecurityIncidentCreationAlertRule is the BasicAlertRule implementation for AlertRule.
func (ar AlertRule) AsMicrosoftSecurityIncidentCreationAlertRule() (*MicrosoftSecurityIncidentCreationAlertRule, bool) {
	return nil, false
}

// AsScheduledAlertRule is the BasicAlertRule implementation for AlertRule.
func (ar AlertRule) AsScheduledAlertRule() (*ScheduledAlertRule, bool) {
	return nil, false
}

// AsAlertRule is the BasicAlertRule implementation for AlertRule.
func (ar AlertRule) AsAlertRule() (*AlertRule, bool) {
	return &ar, true
}

// AsBasicAlertRule is the BasicAlertRule implementation for AlertRule.
func (ar AlertRule) AsBasicAlertRule() (BasicAlertRule, bool) {
	return &ar, true
}

// AlertRuleModel ...
type AlertRuleModel struct {
	autorest.Response `json:"-"`
	Value             BasicAlertRule `json:"value,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AlertRuleModel struct.
func (arm *AlertRuleModel) UnmarshalJSON(body []byte) error {
	ar, err := unmarshalBasicAlertRule(body)
	if err != nil {
		return err
	}
	arm.Value = ar

	return nil
}

// AlertRulesList list all the alert rules.
type AlertRulesList struct {
	autorest.Response `json:"-"`
	// NextLink - READ-ONLY; URL to fetch the next set of alert rules.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - Array of alert rules.
	Value *[]BasicAlertRule `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for AlertRulesList.
func (arl AlertRulesList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if arl.Value != nil {
		objectMap["value"] = arl.Value
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AlertRulesList struct.
func (arl *AlertRulesList) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "nextLink":
			if v != nil {
				var nextLink string
				err = json.Unmarshal(*v, &nextLink)
				if err != nil {
					return err
				}
				arl.NextLink = &nextLink
			}
		case "value":
			if v != nil {
				value, err := unmarshalBasicAlertRuleArray(*v)
				if err != nil {
					return err
				}
				arl.Value = &value
			}
		}
	}

	return nil
}

// AlertRulesListIterator provides access to a complete listing of AlertRule values.
type AlertRulesListIterator struct {
	i    int
	page AlertRulesListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AlertRulesListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertRulesListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AlertRulesListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AlertRulesListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AlertRulesListIterator) Response() AlertRulesList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AlertRulesListIterator) Value() BasicAlertRule {
	if !iter.page.NotDone() {
		return AlertRule{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AlertRulesListIterator type.
func NewAlertRulesListIterator(page AlertRulesListPage) AlertRulesListIterator {
	return AlertRulesListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (arl AlertRulesList) IsEmpty() bool {
	return arl.Value == nil || len(*arl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (arl AlertRulesList) hasNextLink() bool {
	return arl.NextLink != nil && len(*arl.NextLink) != 0
}

// alertRulesListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (arl AlertRulesList) alertRulesListPreparer(ctx context.Context) (*http.Request, error) {
	if !arl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(arl.NextLink)))
}

// AlertRulesListPage contains a page of BasicAlertRule values.
type AlertRulesListPage struct {
	fn  func(context.Context, AlertRulesList) (AlertRulesList, error)
	arl AlertRulesList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AlertRulesListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertRulesListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.arl)
		if err != nil {
			return err
		}
		page.arl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AlertRulesListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AlertRulesListPage) NotDone() bool {
	return !page.arl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AlertRulesListPage) Response() AlertRulesList {
	return page.arl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AlertRulesListPage) Values() []BasicAlertRule {
	if page.arl.IsEmpty() {
		return nil
	}
	return *page.arl.Value
}

// Creates a new instance of the AlertRulesListPage type.
func NewAlertRulesListPage(cur AlertRulesList, getNextPage func(context.Context, AlertRulesList) (AlertRulesList, error)) AlertRulesListPage {
	return AlertRulesListPage{
		fn:  getNextPage,
		arl: cur,
	}
}

// BasicAlertRuleTemplate alert rule template.
type BasicAlertRuleTemplate interface {
	AsFusionAlertRuleTemplate() (*FusionAlertRuleTemplate, bool)
	AsMicrosoftSecurityIncidentCreationAlertRuleTemplate() (*MicrosoftSecurityIncidentCreationAlertRuleTemplate, bool)
	AsScheduledAlertRuleTemplate() (*ScheduledAlertRuleTemplate, bool)
	AsAlertRuleTemplate() (*AlertRuleTemplate, bool)
}

// AlertRuleTemplate alert rule template.
type AlertRuleTemplate struct {
	autorest.Response `json:"-"`
	// Kind - Possible values include: 'KindBasicAlertRuleTemplateKindAlertRuleTemplate', 'KindBasicAlertRuleTemplateKindFusion', 'KindBasicAlertRuleTemplateKindMicrosoftSecurityIncidentCreation', 'KindBasicAlertRuleTemplateKindScheduled'
	Kind KindBasicAlertRuleTemplate `json:"kind,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
}

func unmarshalBasicAlertRuleTemplate(body []byte) (BasicAlertRuleTemplate, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["kind"] {
	case string(KindBasicAlertRuleTemplateKindFusion):
		var fart FusionAlertRuleTemplate
		err := json.Unmarshal(body, &fart)
		return fart, err
	case string(KindBasicAlertRuleTemplateKindMicrosoftSecurityIncidentCreation):
		var msicart MicrosoftSecurityIncidentCreationAlertRuleTemplate
		err := json.Unmarshal(body, &msicart)
		return msicart, err
	case string(KindBasicAlertRuleTemplateKindScheduled):
		var sart ScheduledAlertRuleTemplate
		err := json.Unmarshal(body, &sart)
		return sart, err
	default:
		var art AlertRuleTemplate
		err := json.Unmarshal(body, &art)
		return art, err
	}
}
func unmarshalBasicAlertRuleTemplateArray(body []byte) ([]BasicAlertRuleTemplate, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	artArray := make([]BasicAlertRuleTemplate, len(rawMessages))

	for index, rawMessage := range rawMessages {
		art, err := unmarshalBasicAlertRuleTemplate(*rawMessage)
		if err != nil {
			return nil, err
		}
		artArray[index] = art
	}
	return artArray, nil
}

// MarshalJSON is the custom marshaler for AlertRuleTemplate.
func (art AlertRuleTemplate) MarshalJSON() ([]byte, error) {
	art.Kind = KindBasicAlertRuleTemplateKindAlertRuleTemplate
	objectMap := make(map[string]interface{})
	if art.Kind != "" {
		objectMap["kind"] = art.Kind
	}
	return json.Marshal(objectMap)
}

// AsFusionAlertRuleTemplate is the BasicAlertRuleTemplate implementation for AlertRuleTemplate.
func (art AlertRuleTemplate) AsFusionAlertRuleTemplate() (*FusionAlertRuleTemplate, bool) {
	return nil, false
}

// AsMicrosoftSecurityIncidentCreationAlertRuleTemplate is the BasicAlertRuleTemplate implementation for AlertRuleTemplate.
func (art AlertRuleTemplate) AsMicrosoftSecurityIncidentCreationAlertRuleTemplate() (*MicrosoftSecurityIncidentCreationAlertRuleTemplate, bool) {
	return nil, false
}

// AsScheduledAlertRuleTemplate is the BasicAlertRuleTemplate implementation for AlertRuleTemplate.
func (art AlertRuleTemplate) AsScheduledAlertRuleTemplate() (*ScheduledAlertRuleTemplate, bool) {
	return nil, false
}

// AsAlertRuleTemplate is the BasicAlertRuleTemplate implementation for AlertRuleTemplate.
func (art AlertRuleTemplate) AsAlertRuleTemplate() (*AlertRuleTemplate, bool) {
	return &art, true
}

// AsBasicAlertRuleTemplate is the BasicAlertRuleTemplate implementation for AlertRuleTemplate.
func (art AlertRuleTemplate) AsBasicAlertRuleTemplate() (BasicAlertRuleTemplate, bool) {
	return &art, true
}

// AlertRuleTemplateDataSource alert rule template data sources
type AlertRuleTemplateDataSource struct {
	// ConnectorID - The connector id that provides the following data types
	ConnectorID *string `json:"connectorId,omitempty"`
	// DataTypes - The data types used by the alert rule template
	DataTypes *[]string `json:"dataTypes,omitempty"`
}

// AlertRuleTemplateModel ...
type AlertRuleTemplateModel struct {
	autorest.Response `json:"-"`
	Value             BasicAlertRuleTemplate `json:"value,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AlertRuleTemplateModel struct.
func (artm *AlertRuleTemplateModel) UnmarshalJSON(body []byte) error {
	art, err := unmarshalBasicAlertRuleTemplate(body)
	if err != nil {
		return err
	}
	artm.Value = art

	return nil
}

// AlertRuleTemplatesList list all the alert rule templates.
type AlertRuleTemplatesList struct {
	autorest.Response `json:"-"`
	// NextLink - READ-ONLY; URL to fetch the next set of alert rule templates.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - Array of alert rule templates.
	Value *[]BasicAlertRuleTemplate `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for AlertRuleTemplatesList.
func (artl AlertRuleTemplatesList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if artl.Value != nil {
		objectMap["value"] = artl.Value
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AlertRuleTemplatesList struct.
func (artl *AlertRuleTemplatesList) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "nextLink":
			if v != nil {
				var nextLink string
				err = json.Unmarshal(*v, &nextLink)
				if err != nil {
					return err
				}
				artl.NextLink = &nextLink
			}
		case "value":
			if v != nil {
				value, err := unmarshalBasicAlertRuleTemplateArray(*v)
				if err != nil {
					return err
				}
				artl.Value = &value
			}
		}
	}

	return nil
}

// AlertRuleTemplatesListIterator provides access to a complete listing of AlertRuleTemplate values.
type AlertRuleTemplatesListIterator struct {
	i    int
	page AlertRuleTemplatesListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AlertRuleTemplatesListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertRuleTemplatesListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AlertRuleTemplatesListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AlertRuleTemplatesListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AlertRuleTemplatesListIterator) Response() AlertRuleTemplatesList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AlertRuleTemplatesListIterator) Value() BasicAlertRuleTemplate {
	if !iter.page.NotDone() {
		return AlertRuleTemplate{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AlertRuleTemplatesListIterator type.
func NewAlertRuleTemplatesListIterator(page AlertRuleTemplatesListPage) AlertRuleTemplatesListIterator {
	return AlertRuleTemplatesListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (artl AlertRuleTemplatesList) IsEmpty() bool {
	return artl.Value == nil || len(*artl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (artl AlertRuleTemplatesList) hasNextLink() bool {
	return artl.NextLink != nil && len(*artl.NextLink) != 0
}

// alertRuleTemplatesListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (artl AlertRuleTemplatesList) alertRuleTemplatesListPreparer(ctx context.Context) (*http.Request, error) {
	if !artl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(artl.NextLink)))
}

// AlertRuleTemplatesListPage contains a page of BasicAlertRuleTemplate values.
type AlertRuleTemplatesListPage struct {
	fn   func(context.Context, AlertRuleTemplatesList) (AlertRuleTemplatesList, error)
	artl AlertRuleTemplatesList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AlertRuleTemplatesListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertRuleTemplatesListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.artl)
		if err != nil {
			return err
		}
		page.artl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AlertRuleTemplatesListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AlertRuleTemplatesListPage) NotDone() bool {
	return !page.artl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AlertRuleTemplatesListPage) Response() AlertRuleTemplatesList {
	return page.artl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AlertRuleTemplatesListPage) Values() []BasicAlertRuleTemplate {
	if page.artl.IsEmpty() {
		return nil
	}
	return *page.artl.Value
}

// Creates a new instance of the AlertRuleTemplatesListPage type.
func NewAlertRuleTemplatesListPage(cur AlertRuleTemplatesList, getNextPage func(context.Context, AlertRuleTemplatesList) (AlertRuleTemplatesList, error)) AlertRuleTemplatesListPage {
	return AlertRuleTemplatesListPage{
		fn:   getNextPage,
		artl: cur,
	}
}

// AlertsDataTypeOfDataConnector alerts data type for data connectors.
type AlertsDataTypeOfDataConnector struct {
	// Alerts - Alerts data type connection.
	Alerts *DataConnectorDataTypeCommon `json:"alerts,omitempty"`
}

// ASCDataConnector represents ASC (Azure Security Center) data connector.
type ASCDataConnector struct {
	// ASCDataConnectorProperties - ASC (Azure Security Center) data connector properties.
	*ASCDataConnectorProperties `json:"properties,omitempty"`
	// Kind - Possible values include: 'KindBasicDataConnectorKindDataConnector', 'KindBasicDataConnectorKindAzureActiveDirectory', 'KindBasicDataConnectorKindAzureAdvancedThreatProtection', 'KindBasicDataConnectorKindAzureSecurityCenter', 'KindBasicDataConnectorKindAmazonWebServicesCloudTrail', 'KindBasicDataConnectorKindMicrosoftCloudAppSecurity', 'KindBasicDataConnectorKindMicrosoftDefenderAdvancedThreatProtection', 'KindBasicDataConnectorKindOffice365', 'KindBasicDataConnectorKindThreatIntelligence'
	Kind KindBasicDataConnector `json:"kind,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Etag - Etag of the azure resource
	Etag *string `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for ASCDataConnector.
func (adc ASCDataConnector) MarshalJSON() ([]byte, error) {
	adc.Kind = KindBasicDataConnectorKindAzureSecurityCenter
	objectMap := make(map[string]interface{})
	if adc.ASCDataConnectorProperties != nil {
		objectMap["properties"] = adc.ASCDataConnectorProperties
	}
	if adc.Kind != "" {
		objectMap["kind"] = adc.Kind
	}
	if adc.Etag != nil {
		objectMap["etag"] = adc.Etag
	}
	return json.Marshal(objectMap)
}

// AsAADDataConnector is the BasicDataConnector implementation for ASCDataConnector.
func (adc ASCDataConnector) AsAADDataConnector() (*AADDataConnector, bool) {
	return nil, false
}

// AsAATPDataConnector is the BasicDataConnector implementation for ASCDataConnector.
func (adc ASCDataConnector) AsAATPDataConnector() (*AATPDataConnector, bool) {
	return nil, false
}

// AsASCDataConnector is the BasicDataConnector implementation for ASCDataConnector.
func (adc ASCDataConnector) AsASCDataConnector() (*ASCDataConnector, bool) {
	return &adc, true
}

// AsAwsCloudTrailDataConnector is the BasicDataConnector implementation for ASCDataConnector.
func (adc ASCDataConnector) AsAwsCloudTrailDataConnector() (*AwsCloudTrailDataConnector, bool) {
	return nil, false
}

// AsMCASDataConnector is the BasicDataConnector implementation for ASCDataConnector.
func (adc ASCDataConnector) AsMCASDataConnector() (*MCASDataConnector, bool) {
	return nil, false
}

// AsMDATPDataConnector is the BasicDataConnector implementation for ASCDataConnector.
func (adc ASCDataConnector) AsMDATPDataConnector() (*MDATPDataConnector, bool) {
	return nil, false
}

// AsOfficeDataConnector is the BasicDataConnector implementation for ASCDataConnector.
func (adc ASCDataConnector) AsOfficeDataConnector() (*OfficeDataConnector, bool) {
	return nil, false
}

// AsTIDataConnector is the BasicDataConnector implementation for ASCDataConnector.
func (adc ASCDataConnector) AsTIDataConnector() (*TIDataConnector, bool) {
	return nil, false
}

// AsDataConnector is the BasicDataConnector implementation for ASCDataConnector.
func (adc ASCDataConnector) AsDataConnector() (*DataConnector, bool) {
	return nil, false
}

// AsBasicDataConnector is the BasicDataConnector implementation for ASCDataConnector.
func (adc ASCDataConnector) AsBasicDataConnector() (BasicDataConnector, bool) {
	return &adc, true
}

// UnmarshalJSON is the custom unmarshaler for ASCDataConnector struct.
func (adc *ASCDataConnector) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var aSCDataConnectorProperties ASCDataConnectorProperties
				err = json.Unmarshal(*v, &aSCDataConnectorProperties)
				if err != nil {
					return err
				}
				adc.ASCDataConnectorProperties = &aSCDataConnectorProperties
			}
		case "kind":
			if v != nil {
				var kind KindBasicDataConnector
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				adc.Kind = kind
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				adc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				adc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				adc.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				adc.Etag = &etag
			}
		}
	}

	return nil
}

// ASCDataConnectorProperties ASC (Azure Security Center) data connector properties.
type ASCDataConnectorProperties struct {
	// SubscriptionID - The subscription id to connect to, and get the data from.
	SubscriptionID *string `json:"subscriptionId,omitempty"`
	// DataTypes - The available data types for the connector.
	DataTypes *AlertsDataTypeOfDataConnector `json:"dataTypes,omitempty"`
}

// AwsCloudTrailDataConnector represents Amazon Web Services CloudTrail data connector.
type AwsCloudTrailDataConnector struct {
	// AwsCloudTrailDataConnectorProperties - Amazon Web Services CloudTrail data connector properties.
	*AwsCloudTrailDataConnectorProperties `json:"properties,omitempty"`
	// Kind - Possible values include: 'KindBasicDataConnectorKindDataConnector', 'KindBasicDataConnectorKindAzureActiveDirectory', 'KindBasicDataConnectorKindAzureAdvancedThreatProtection', 'KindBasicDataConnectorKindAzureSecurityCenter', 'KindBasicDataConnectorKindAmazonWebServicesCloudTrail', 'KindBasicDataConnectorKindMicrosoftCloudAppSecurity', 'KindBasicDataConnectorKindMicrosoftDefenderAdvancedThreatProtection', 'KindBasicDataConnectorKindOffice365', 'KindBasicDataConnectorKindThreatIntelligence'
	Kind KindBasicDataConnector `json:"kind,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Etag - Etag of the azure resource
	Etag *string `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for AwsCloudTrailDataConnector.
func (actdc AwsCloudTrailDataConnector) MarshalJSON() ([]byte, error) {
	actdc.Kind = KindBasicDataConnectorKindAmazonWebServicesCloudTrail
	objectMap := make(map[string]interface{})
	if actdc.AwsCloudTrailDataConnectorProperties != nil {
		objectMap["properties"] = actdc.AwsCloudTrailDataConnectorProperties
	}
	if actdc.Kind != "" {
		objectMap["kind"] = actdc.Kind
	}
	if actdc.Etag != nil {
		objectMap["etag"] = actdc.Etag
	}
	return json.Marshal(objectMap)
}

// AsAADDataConnector is the BasicDataConnector implementation for AwsCloudTrailDataConnector.
func (actdc AwsCloudTrailDataConnector) AsAADDataConnector() (*AADDataConnector, bool) {
	return nil, false
}

// AsAATPDataConnector is the BasicDataConnector implementation for AwsCloudTrailDataConnector.
func (actdc AwsCloudTrailDataConnector) AsAATPDataConnector() (*AATPDataConnector, bool) {
	return nil, false
}

// AsASCDataConnector is the BasicDataConnector implementation for AwsCloudTrailDataConnector.
func (actdc AwsCloudTrailDataConnector) AsASCDataConnector() (*ASCDataConnector, bool) {
	return nil, false
}

// AsAwsCloudTrailDataConnector is the BasicDataConnector implementation for AwsCloudTrailDataConnector.
func (actdc AwsCloudTrailDataConnector) AsAwsCloudTrailDataConnector() (*AwsCloudTrailDataConnector, bool) {
	return &actdc, true
}

// AsMCASDataConnector is the BasicDataConnector implementation for AwsCloudTrailDataConnector.
func (actdc AwsCloudTrailDataConnector) AsMCASDataConnector() (*MCASDataConnector, bool) {
	return nil, false
}

// AsMDATPDataConnector is the BasicDataConnector implementation for AwsCloudTrailDataConnector.
func (actdc AwsCloudTrailDataConnector) AsMDATPDataConnector() (*MDATPDataConnector, bool) {
	return nil, false
}

// AsOfficeDataConnector is the BasicDataConnector implementation for AwsCloudTrailDataConnector.
func (actdc AwsCloudTrailDataConnector) AsOfficeDataConnector() (*OfficeDataConnector, bool) {
	return nil, false
}

// AsTIDataConnector is the BasicDataConnector implementation for AwsCloudTrailDataConnector.
func (actdc AwsCloudTrailDataConnector) AsTIDataConnector() (*TIDataConnector, bool) {
	return nil, false
}

// AsDataConnector is the BasicDataConnector implementation for AwsCloudTrailDataConnector.
func (actdc AwsCloudTrailDataConnector) AsDataConnector() (*DataConnector, bool) {
	return nil, false
}

// AsBasicDataConnector is the BasicDataConnector implementation for AwsCloudTrailDataConnector.
func (actdc AwsCloudTrailDataConnector) AsBasicDataConnector() (BasicDataConnector, bool) {
	return &actdc, true
}

// UnmarshalJSON is the custom unmarshaler for AwsCloudTrailDataConnector struct.
func (actdc *AwsCloudTrailDataConnector) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var awsCloudTrailDataConnectorProperties AwsCloudTrailDataConnectorProperties
				err = json.Unmarshal(*v, &awsCloudTrailDataConnectorProperties)
				if err != nil {
					return err
				}
				actdc.AwsCloudTrailDataConnectorProperties = &awsCloudTrailDataConnectorProperties
			}
		case "kind":
			if v != nil {
				var kind KindBasicDataConnector
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				actdc.Kind = kind
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				actdc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				actdc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				actdc.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				actdc.Etag = &etag
			}
		}
	}

	return nil
}

// AwsCloudTrailDataConnectorDataTypes the available data types for Amazon Web Services CloudTrail data
// connector.
type AwsCloudTrailDataConnectorDataTypes struct {
	// Logs - Logs data type.
	Logs *AwsCloudTrailDataConnectorDataTypesLogs `json:"logs,omitempty"`
}

// AwsCloudTrailDataConnectorDataTypesLogs logs data type.
type AwsCloudTrailDataConnectorDataTypesLogs struct {
	// State - Describe whether this data type connection is enabled or not. Possible values include: 'DataTypeStateEnabled', 'DataTypeStateDisabled'
	State DataTypeState `json:"state,omitempty"`
}

// AwsCloudTrailDataConnectorProperties amazon Web Services CloudTrail data connector properties.
type AwsCloudTrailDataConnectorProperties struct {
	// AwsRoleArn - The Aws Role Arn (with CloudTrailReadOnly policy) that is used to access the Aws account.
	AwsRoleArn *string `json:"awsRoleArn,omitempty"`
	// DataTypes - The available data types for the connector.
	DataTypes *AwsCloudTrailDataConnectorDataTypes `json:"dataTypes,omitempty"`
}

// Bookmark represents a bookmark in Azure Security Insights.
type Bookmark struct {
	autorest.Response `json:"-"`
	// BookmarkProperties - Bookmark properties
	*BookmarkProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Etag - Etag of the azure resource
	Etag *string `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for Bookmark.
func (b Bookmark) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if b.BookmarkProperties != nil {
		objectMap["properties"] = b.BookmarkProperties
	}
	if b.Etag != nil {
		objectMap["etag"] = b.Etag
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Bookmark struct.
func (b *Bookmark) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var bookmarkProperties BookmarkProperties
				err = json.Unmarshal(*v, &bookmarkProperties)
				if err != nil {
					return err
				}
				b.BookmarkProperties = &bookmarkProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				b.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				b.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				b.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				b.Etag = &etag
			}
		}
	}

	return nil
}

// BookmarkList list all the bookmarks.
type BookmarkList struct {
	autorest.Response `json:"-"`
	// NextLink - READ-ONLY; URL to fetch the next set of cases.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - Array of bookmarks.
	Value *[]Bookmark `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for BookmarkList.
func (bl BookmarkList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bl.Value != nil {
		objectMap["value"] = bl.Value
	}
	return json.Marshal(objectMap)
}

// BookmarkListIterator provides access to a complete listing of Bookmark values.
type BookmarkListIterator struct {
	i    int
	page BookmarkListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *BookmarkListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BookmarkListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *BookmarkListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter BookmarkListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter BookmarkListIterator) Response() BookmarkList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter BookmarkListIterator) Value() Bookmark {
	if !iter.page.NotDone() {
		return Bookmark{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the BookmarkListIterator type.
func NewBookmarkListIterator(page BookmarkListPage) BookmarkListIterator {
	return BookmarkListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (bl BookmarkList) IsEmpty() bool {
	return bl.Value == nil || len(*bl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (bl BookmarkList) hasNextLink() bool {
	return bl.NextLink != nil && len(*bl.NextLink) != 0
}

// bookmarkListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (bl BookmarkList) bookmarkListPreparer(ctx context.Context) (*http.Request, error) {
	if !bl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(bl.NextLink)))
}

// BookmarkListPage contains a page of Bookmark values.
type BookmarkListPage struct {
	fn func(context.Context, BookmarkList) (BookmarkList, error)
	bl BookmarkList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *BookmarkListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BookmarkListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.bl)
		if err != nil {
			return err
		}
		page.bl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *BookmarkListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page BookmarkListPage) NotDone() bool {
	return !page.bl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page BookmarkListPage) Response() BookmarkList {
	return page.bl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page BookmarkListPage) Values() []Bookmark {
	if page.bl.IsEmpty() {
		return nil
	}
	return *page.bl.Value
}

// Creates a new instance of the BookmarkListPage type.
func NewBookmarkListPage(cur BookmarkList, getNextPage func(context.Context, BookmarkList) (BookmarkList, error)) BookmarkListPage {
	return BookmarkListPage{
		fn: getNextPage,
		bl: cur,
	}
}

// BookmarkProperties describes bookmark properties
type BookmarkProperties struct {
	// Created - The time the bookmark was created
	Created *date.Time `json:"created,omitempty"`
	// CreatedBy - Describes a user that created the bookmark
	CreatedBy *UserInfo `json:"createdBy,omitempty"`
	// DisplayName - The display name of the bookmark
	DisplayName *string `json:"displayName,omitempty"`
	// Labels - List of labels relevant to this bookmark
	Labels *[]string `json:"labels,omitempty"`
	// Notes - The notes of the bookmark
	Notes *string `json:"notes,omitempty"`
	// Query - The query of the bookmark.
	Query *string `json:"query,omitempty"`
	// QueryResult - The query result of the bookmark.
	QueryResult *string `json:"queryResult,omitempty"`
	// Updated - The last time the bookmark was updated
	Updated *date.Time `json:"updated,omitempty"`
	// UpdatedBy - Describes a user that updated the bookmark
	UpdatedBy *UserInfo `json:"updatedBy,omitempty"`
	// EventTime - The bookmark event time
	EventTime *date.Time `json:"eventTime,omitempty"`
	// QueryStartTime - The start time for the query
	QueryStartTime *date.Time `json:"queryStartTime,omitempty"`
	// QueryEndTime - The end time for the query
	QueryEndTime *date.Time `json:"queryEndTime,omitempty"`
	// IncidentInfo - Describes an incident that relates to bookmark
	IncidentInfo *IncidentInfo `json:"incidentInfo,omitempty"`
}

// ClientInfo information on the client (user or application) that made some action
type ClientInfo struct {
	// Email - The email of the client.
	Email *string `json:"email,omitempty"`
	// Name - The name of the client.
	Name *string `json:"name,omitempty"`
	// ObjectID - The object id of the client.
	ObjectID *uuid.UUID `json:"objectId,omitempty"`
	// UserPrincipalName - The user principal name of the client.
	UserPrincipalName *string `json:"userPrincipalName,omitempty"`
}

// CloudError an error response for a resource management request.
type CloudError struct {
	// Error - The error object of the CloudError response
	Error *ErrorResponse `json:"error,omitempty"`
}

// BasicDataConnector data connector.
type BasicDataConnector interface {
	AsAADDataConnector() (*AADDataConnector, bool)
	AsAATPDataConnector() (*AATPDataConnector, bool)
	AsASCDataConnector() (*ASCDataConnector, bool)
	AsAwsCloudTrailDataConnector() (*AwsCloudTrailDataConnector, bool)
	AsMCASDataConnector() (*MCASDataConnector, bool)
	AsMDATPDataConnector() (*MDATPDataConnector, bool)
	AsOfficeDataConnector() (*OfficeDataConnector, bool)
	AsTIDataConnector() (*TIDataConnector, bool)
	AsDataConnector() (*DataConnector, bool)
}

// DataConnector data connector.
type DataConnector struct {
	autorest.Response `json:"-"`
	// Kind - Possible values include: 'KindBasicDataConnectorKindDataConnector', 'KindBasicDataConnectorKindAzureActiveDirectory', 'KindBasicDataConnectorKindAzureAdvancedThreatProtection', 'KindBasicDataConnectorKindAzureSecurityCenter', 'KindBasicDataConnectorKindAmazonWebServicesCloudTrail', 'KindBasicDataConnectorKindMicrosoftCloudAppSecurity', 'KindBasicDataConnectorKindMicrosoftDefenderAdvancedThreatProtection', 'KindBasicDataConnectorKindOffice365', 'KindBasicDataConnectorKindThreatIntelligence'
	Kind KindBasicDataConnector `json:"kind,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Etag - Etag of the azure resource
	Etag *string `json:"etag,omitempty"`
}

func unmarshalBasicDataConnector(body []byte) (BasicDataConnector, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["kind"] {
	case string(KindBasicDataConnectorKindAzureActiveDirectory):
		var adc AADDataConnector
		err := json.Unmarshal(body, &adc)
		return adc, err
	case string(KindBasicDataConnectorKindAzureAdvancedThreatProtection):
		var adc AATPDataConnector
		err := json.Unmarshal(body, &adc)
		return adc, err
	case string(KindBasicDataConnectorKindAzureSecurityCenter):
		var adc ASCDataConnector
		err := json.Unmarshal(body, &adc)
		return adc, err
	case string(KindBasicDataConnectorKindAmazonWebServicesCloudTrail):
		var actdc AwsCloudTrailDataConnector
		err := json.Unmarshal(body, &actdc)
		return actdc, err
	case string(KindBasicDataConnectorKindMicrosoftCloudAppSecurity):
		var mdc MCASDataConnector
		err := json.Unmarshal(body, &mdc)
		return mdc, err
	case string(KindBasicDataConnectorKindMicrosoftDefenderAdvancedThreatProtection):
		var mdc MDATPDataConnector
		err := json.Unmarshal(body, &mdc)
		return mdc, err
	case string(KindBasicDataConnectorKindOffice365):
		var odc OfficeDataConnector
		err := json.Unmarshal(body, &odc)
		return odc, err
	case string(KindBasicDataConnectorKindThreatIntelligence):
		var tdc TIDataConnector
		err := json.Unmarshal(body, &tdc)
		return tdc, err
	default:
		var dc DataConnector
		err := json.Unmarshal(body, &dc)
		return dc, err
	}
}
func unmarshalBasicDataConnectorArray(body []byte) ([]BasicDataConnector, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	dcArray := make([]BasicDataConnector, len(rawMessages))

	for index, rawMessage := range rawMessages {
		dc, err := unmarshalBasicDataConnector(*rawMessage)
		if err != nil {
			return nil, err
		}
		dcArray[index] = dc
	}
	return dcArray, nil
}

// MarshalJSON is the custom marshaler for DataConnector.
func (dc DataConnector) MarshalJSON() ([]byte, error) {
	dc.Kind = KindBasicDataConnectorKindDataConnector
	objectMap := make(map[string]interface{})
	if dc.Kind != "" {
		objectMap["kind"] = dc.Kind
	}
	if dc.Etag != nil {
		objectMap["etag"] = dc.Etag
	}
	return json.Marshal(objectMap)
}

// AsAADDataConnector is the BasicDataConnector implementation for DataConnector.
func (dc DataConnector) AsAADDataConnector() (*AADDataConnector, bool) {
	return nil, false
}

// AsAATPDataConnector is the BasicDataConnector implementation for DataConnector.
func (dc DataConnector) AsAATPDataConnector() (*AATPDataConnector, bool) {
	return nil, false
}

// AsASCDataConnector is the BasicDataConnector implementation for DataConnector.
func (dc DataConnector) AsASCDataConnector() (*ASCDataConnector, bool) {
	return nil, false
}

// AsAwsCloudTrailDataConnector is the BasicDataConnector implementation for DataConnector.
func (dc DataConnector) AsAwsCloudTrailDataConnector() (*AwsCloudTrailDataConnector, bool) {
	return nil, false
}

// AsMCASDataConnector is the BasicDataConnector implementation for DataConnector.
func (dc DataConnector) AsMCASDataConnector() (*MCASDataConnector, bool) {
	return nil, false
}

// AsMDATPDataConnector is the BasicDataConnector implementation for DataConnector.
func (dc DataConnector) AsMDATPDataConnector() (*MDATPDataConnector, bool) {
	return nil, false
}

// AsOfficeDataConnector is the BasicDataConnector implementation for DataConnector.
func (dc DataConnector) AsOfficeDataConnector() (*OfficeDataConnector, bool) {
	return nil, false
}

// AsTIDataConnector is the BasicDataConnector implementation for DataConnector.
func (dc DataConnector) AsTIDataConnector() (*TIDataConnector, bool) {
	return nil, false
}

// AsDataConnector is the BasicDataConnector implementation for DataConnector.
func (dc DataConnector) AsDataConnector() (*DataConnector, bool) {
	return &dc, true
}

// AsBasicDataConnector is the BasicDataConnector implementation for DataConnector.
func (dc DataConnector) AsBasicDataConnector() (BasicDataConnector, bool) {
	return &dc, true
}

// DataConnectorDataTypeCommon common field for data type in data connectors.
type DataConnectorDataTypeCommon struct {
	// State - Describe whether this data type connection is enabled or not. Possible values include: 'DataTypeStateEnabled', 'DataTypeStateDisabled'
	State DataTypeState `json:"state,omitempty"`
}

// DataConnectorList list all the data connectors.
type DataConnectorList struct {
	autorest.Response `json:"-"`
	// NextLink - READ-ONLY; URL to fetch the next set of data connectors.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - Array of data connectors.
	Value *[]BasicDataConnector `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for DataConnectorList.
func (dcl DataConnectorList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dcl.Value != nil {
		objectMap["value"] = dcl.Value
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DataConnectorList struct.
func (dcl *DataConnectorList) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "nextLink":
			if v != nil {
				var nextLink string
				err = json.Unmarshal(*v, &nextLink)
				if err != nil {
					return err
				}
				dcl.NextLink = &nextLink
			}
		case "value":
			if v != nil {
				value, err := unmarshalBasicDataConnectorArray(*v)
				if err != nil {
					return err
				}
				dcl.Value = &value
			}
		}
	}

	return nil
}

// DataConnectorListIterator provides access to a complete listing of DataConnector values.
type DataConnectorListIterator struct {
	i    int
	page DataConnectorListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DataConnectorListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DataConnectorListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DataConnectorListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DataConnectorListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DataConnectorListIterator) Response() DataConnectorList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DataConnectorListIterator) Value() BasicDataConnector {
	if !iter.page.NotDone() {
		return DataConnector{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DataConnectorListIterator type.
func NewDataConnectorListIterator(page DataConnectorListPage) DataConnectorListIterator {
	return DataConnectorListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dcl DataConnectorList) IsEmpty() bool {
	return dcl.Value == nil || len(*dcl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dcl DataConnectorList) hasNextLink() bool {
	return dcl.NextLink != nil && len(*dcl.NextLink) != 0
}

// dataConnectorListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dcl DataConnectorList) dataConnectorListPreparer(ctx context.Context) (*http.Request, error) {
	if !dcl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dcl.NextLink)))
}

// DataConnectorListPage contains a page of BasicDataConnector values.
type DataConnectorListPage struct {
	fn  func(context.Context, DataConnectorList) (DataConnectorList, error)
	dcl DataConnectorList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DataConnectorListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DataConnectorListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dcl)
		if err != nil {
			return err
		}
		page.dcl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DataConnectorListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DataConnectorListPage) NotDone() bool {
	return !page.dcl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DataConnectorListPage) Response() DataConnectorList {
	return page.dcl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DataConnectorListPage) Values() []BasicDataConnector {
	if page.dcl.IsEmpty() {
		return nil
	}
	return *page.dcl.Value
}

// Creates a new instance of the DataConnectorListPage type.
func NewDataConnectorListPage(cur DataConnectorList, getNextPage func(context.Context, DataConnectorList) (DataConnectorList, error)) DataConnectorListPage {
	return DataConnectorListPage{
		fn:  getNextPage,
		dcl: cur,
	}
}

// DataConnectorModel ...
type DataConnectorModel struct {
	autorest.Response `json:"-"`
	Value             BasicDataConnector `json:"value,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for DataConnectorModel struct.
func (dcm *DataConnectorModel) UnmarshalJSON(body []byte) error {
	dc, err := unmarshalBasicDataConnector(body)
	if err != nil {
		return err
	}
	dcm.Value = dc

	return nil
}

// DataConnectorTenantID properties data connector on tenant level.
type DataConnectorTenantID struct {
	// TenantID - The tenant id to connect to, and get the data from.
	TenantID *string `json:"tenantId,omitempty"`
}

// DataConnectorWithAlertsProperties data connector properties.
type DataConnectorWithAlertsProperties struct {
	// DataTypes - The available data types for the connector.
	DataTypes *AlertsDataTypeOfDataConnector `json:"dataTypes,omitempty"`
}

// ErrorAdditionalInfo the resource management error additional info.
type ErrorAdditionalInfo struct {
	// Type - READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty"`
	// Info - READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty"`
}

// ErrorResponse common error response for all Azure Resource Manager APIs to return error details for
// failed operations. (This also follows the OData error response format.)
type ErrorResponse struct {
	// Code - READ-ONLY; The error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; The error message.
	Message *string `json:"message,omitempty"`
	// Target - READ-ONLY; The error target.
	Target *string `json:"target,omitempty"`
	// Details - READ-ONLY; The error details.
	Details *[]ErrorResponse `json:"details,omitempty"`
	// AdditionalInfo - READ-ONLY; The error additional info.
	AdditionalInfo *[]ErrorAdditionalInfo `json:"additionalInfo,omitempty"`
}

// FusionAlertRule represents Fusion alert rule.
type FusionAlertRule struct {
	// FusionAlertRuleProperties - Fusion alert rule properties
	*FusionAlertRuleProperties `json:"properties,omitempty"`
	// Kind - Possible values include: 'KindKindAlertRule', 'KindKindFusion', 'KindKindMicrosoftSecurityIncidentCreation', 'KindKindScheduled'
	Kind Kind `json:"kind,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Etag - Etag of the azure resource
	Etag *string `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for FusionAlertRule.
func (far FusionAlertRule) MarshalJSON() ([]byte, error) {
	far.Kind = KindKindFusion
	objectMap := make(map[string]interface{})
	if far.FusionAlertRuleProperties != nil {
		objectMap["properties"] = far.FusionAlertRuleProperties
	}
	if far.Kind != "" {
		objectMap["kind"] = far.Kind
	}
	if far.Etag != nil {
		objectMap["etag"] = far.Etag
	}
	return json.Marshal(objectMap)
}

// AsFusionAlertRule is the BasicAlertRule implementation for FusionAlertRule.
func (far FusionAlertRule) AsFusionAlertRule() (*FusionAlertRule, bool) {
	return &far, true
}

// AsMicrosoftSecurityIncidentCreationAlertRule is the BasicAlertRule implementation for FusionAlertRule.
func (far FusionAlertRule) AsMicrosoftSecurityIncidentCreationAlertRule() (*MicrosoftSecurityIncidentCreationAlertRule, bool) {
	return nil, false
}

// AsScheduledAlertRule is the BasicAlertRule implementation for FusionAlertRule.
func (far FusionAlertRule) AsScheduledAlertRule() (*ScheduledAlertRule, bool) {
	return nil, false
}

// AsAlertRule is the BasicAlertRule implementation for FusionAlertRule.
func (far FusionAlertRule) AsAlertRule() (*AlertRule, bool) {
	return nil, false
}

// AsBasicAlertRule is the BasicAlertRule implementation for FusionAlertRule.
func (far FusionAlertRule) AsBasicAlertRule() (BasicAlertRule, bool) {
	return &far, true
}

// UnmarshalJSON is the custom unmarshaler for FusionAlertRule struct.
func (far *FusionAlertRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var fusionAlertRuleProperties FusionAlertRuleProperties
				err = json.Unmarshal(*v, &fusionAlertRuleProperties)
				if err != nil {
					return err
				}
				far.FusionAlertRuleProperties = &fusionAlertRuleProperties
			}
		case "kind":
			if v != nil {
				var kind Kind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				far.Kind = kind
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				far.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				far.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				far.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				far.Etag = &etag
			}
		}
	}

	return nil
}

// FusionAlertRuleProperties fusion alert rule base property bag.
type FusionAlertRuleProperties struct {
	// AlertRuleTemplateName - The Name of the alert rule template used to create this rule.
	AlertRuleTemplateName *string `json:"alertRuleTemplateName,omitempty"`
	// Description - READ-ONLY; The description of the alert rule.
	Description *string `json:"description,omitempty"`
	// DisplayName - READ-ONLY; The display name for alerts created by this alert rule.
	DisplayName *string `json:"displayName,omitempty"`
	// Enabled - Determines whether this alert rule is enabled or disabled.
	Enabled *bool `json:"enabled,omitempty"`
	// LastModifiedUtc - READ-ONLY; The last time that this alert has been modified.
	LastModifiedUtc *date.Time `json:"lastModifiedUtc,omitempty"`
	// Severity - READ-ONLY; The severity for alerts created by this alert rule. Possible values include: 'AlertSeverityHigh', 'AlertSeverityMedium', 'AlertSeverityLow', 'AlertSeverityInformational'
	Severity AlertSeverity `json:"severity,omitempty"`
	// Tactics - READ-ONLY; The tactics of the alert rule
	Tactics *[]AttackTactic `json:"tactics,omitempty"`
}

// MarshalJSON is the custom marshaler for FusionAlertRuleProperties.
func (farp FusionAlertRuleProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if farp.AlertRuleTemplateName != nil {
		objectMap["alertRuleTemplateName"] = farp.AlertRuleTemplateName
	}
	if farp.Enabled != nil {
		objectMap["enabled"] = farp.Enabled
	}
	return json.Marshal(objectMap)
}

// FusionAlertRuleTemplate represents Fusion alert rule template.
type FusionAlertRuleTemplate struct {
	// FusionAlertRuleTemplateProperties - Fusion alert rule template properties
	*FusionAlertRuleTemplateProperties `json:"properties,omitempty"`
	// Kind - Possible values include: 'KindBasicAlertRuleTemplateKindAlertRuleTemplate', 'KindBasicAlertRuleTemplateKindFusion', 'KindBasicAlertRuleTemplateKindMicrosoftSecurityIncidentCreation', 'KindBasicAlertRuleTemplateKindScheduled'
	Kind KindBasicAlertRuleTemplate `json:"kind,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for FusionAlertRuleTemplate.
func (fart FusionAlertRuleTemplate) MarshalJSON() ([]byte, error) {
	fart.Kind = KindBasicAlertRuleTemplateKindFusion
	objectMap := make(map[string]interface{})
	if fart.FusionAlertRuleTemplateProperties != nil {
		objectMap["properties"] = fart.FusionAlertRuleTemplateProperties
	}
	if fart.Kind != "" {
		objectMap["kind"] = fart.Kind
	}
	return json.Marshal(objectMap)
}

// AsFusionAlertRuleTemplate is the BasicAlertRuleTemplate implementation for FusionAlertRuleTemplate.
func (fart FusionAlertRuleTemplate) AsFusionAlertRuleTemplate() (*FusionAlertRuleTemplate, bool) {
	return &fart, true
}

// AsMicrosoftSecurityIncidentCreationAlertRuleTemplate is the BasicAlertRuleTemplate implementation for FusionAlertRuleTemplate.
func (fart FusionAlertRuleTemplate) AsMicrosoftSecurityIncidentCreationAlertRuleTemplate() (*MicrosoftSecurityIncidentCreationAlertRuleTemplate, bool) {
	return nil, false
}

// AsScheduledAlertRuleTemplate is the BasicAlertRuleTemplate implementation for FusionAlertRuleTemplate.
func (fart FusionAlertRuleTemplate) AsScheduledAlertRuleTemplate() (*ScheduledAlertRuleTemplate, bool) {
	return nil, false
}

// AsAlertRuleTemplate is the BasicAlertRuleTemplate implementation for FusionAlertRuleTemplate.
func (fart FusionAlertRuleTemplate) AsAlertRuleTemplate() (*AlertRuleTemplate, bool) {
	return nil, false
}

// AsBasicAlertRuleTemplate is the BasicAlertRuleTemplate implementation for FusionAlertRuleTemplate.
func (fart FusionAlertRuleTemplate) AsBasicAlertRuleTemplate() (BasicAlertRuleTemplate, bool) {
	return &fart, true
}

// UnmarshalJSON is the custom unmarshaler for FusionAlertRuleTemplate struct.
func (fart *FusionAlertRuleTemplate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var fusionAlertRuleTemplateProperties FusionAlertRuleTemplateProperties
				err = json.Unmarshal(*v, &fusionAlertRuleTemplateProperties)
				if err != nil {
					return err
				}
				fart.FusionAlertRuleTemplateProperties = &fusionAlertRuleTemplateProperties
			}
		case "kind":
			if v != nil {
				var kind KindBasicAlertRuleTemplate
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				fart.Kind = kind
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				fart.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				fart.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				fart.Type = &typeVar
			}
		}
	}

	return nil
}

// FusionAlertRuleTemplateProperties represents Fusion alert rule template properties
type FusionAlertRuleTemplateProperties struct {
	// AlertRulesCreatedByTemplateCount - the number of alert rules that were created by this template
	AlertRulesCreatedByTemplateCount *int32 `json:"alertRulesCreatedByTemplateCount,omitempty"`
	// CreatedDateUTC - READ-ONLY; The time that this alert rule template has been added.
	CreatedDateUTC *date.Time `json:"createdDateUTC,omitempty"`
	// Description - The description of the alert rule template.
	Description *string `json:"description,omitempty"`
	// DisplayName - The display name for alert rule template.
	DisplayName *string `json:"displayName,omitempty"`
	// RequiredDataConnectors - The required data connectors for this template
	RequiredDataConnectors *[]AlertRuleTemplateDataSource `json:"requiredDataConnectors,omitempty"`
	// Status - The alert rule template status. Possible values include: 'TemplateStatusInstalled', 'TemplateStatusAvailable', 'TemplateStatusNotAvailable'
	Status TemplateStatus `json:"status,omitempty"`
	// Severity - The severity for alerts created by this alert rule. Possible values include: 'AlertSeverityHigh', 'AlertSeverityMedium', 'AlertSeverityLow', 'AlertSeverityInformational'
	Severity AlertSeverity `json:"severity,omitempty"`
	// Tactics - The tactics of the alert rule template
	Tactics *[]AttackTactic `json:"tactics,omitempty"`
}

// MarshalJSON is the custom marshaler for FusionAlertRuleTemplateProperties.
func (fartp FusionAlertRuleTemplateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fartp.AlertRulesCreatedByTemplateCount != nil {
		objectMap["alertRulesCreatedByTemplateCount"] = fartp.AlertRulesCreatedByTemplateCount
	}
	if fartp.Description != nil {
		objectMap["description"] = fartp.Description
	}
	if fartp.DisplayName != nil {
		objectMap["displayName"] = fartp.DisplayName
	}
	if fartp.RequiredDataConnectors != nil {
		objectMap["requiredDataConnectors"] = fartp.RequiredDataConnectors
	}
	if fartp.Status != "" {
		objectMap["status"] = fartp.Status
	}
	if fartp.Severity != "" {
		objectMap["severity"] = fartp.Severity
	}
	if fartp.Tactics != nil {
		objectMap["tactics"] = fartp.Tactics
	}
	return json.Marshal(objectMap)
}

// Incident represents an incident in Azure Security Insights.
type Incident struct {
	autorest.Response `json:"-"`
	// IncidentProperties - Incident properties
	*IncidentProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Etag - Etag of the azure resource
	Etag *string `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for Incident.
func (i Incident) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if i.IncidentProperties != nil {
		objectMap["properties"] = i.IncidentProperties
	}
	if i.Etag != nil {
		objectMap["etag"] = i.Etag
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Incident struct.
func (i *Incident) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var incidentProperties IncidentProperties
				err = json.Unmarshal(*v, &incidentProperties)
				if err != nil {
					return err
				}
				i.IncidentProperties = &incidentProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				i.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				i.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				i.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				i.Etag = &etag
			}
		}
	}

	return nil
}

// IncidentAdditionalData incident additional data property bag.
type IncidentAdditionalData struct {
	// AlertsCount - READ-ONLY; The number of alerts in the incident
	AlertsCount *int32 `json:"alertsCount,omitempty"`
	// BookmarksCount - READ-ONLY; The number of bookmarks in the incident
	BookmarksCount *int32 `json:"bookmarksCount,omitempty"`
	// CommentsCount - READ-ONLY; The number of comments in the incident
	CommentsCount *int32 `json:"commentsCount,omitempty"`
	// AlertProductNames - READ-ONLY; List of product names of alerts in the incident
	AlertProductNames *[]string `json:"alertProductNames,omitempty"`
	// Tactics - READ-ONLY; The tactics associated with incident
	Tactics *[]AttackTactic `json:"tactics,omitempty"`
}

// IncidentComment represents an incident comment
type IncidentComment struct {
	autorest.Response `json:"-"`
	// IncidentCommentProperties - Incident comment properties
	*IncidentCommentProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for IncidentComment.
func (ic IncidentComment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ic.IncidentCommentProperties != nil {
		objectMap["properties"] = ic.IncidentCommentProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for IncidentComment struct.
func (ic *IncidentComment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var incidentCommentProperties IncidentCommentProperties
				err = json.Unmarshal(*v, &incidentCommentProperties)
				if err != nil {
					return err
				}
				ic.IncidentCommentProperties = &incidentCommentProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ic.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ic.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ic.Type = &typeVar
			}
		}
	}

	return nil
}

// IncidentCommentList list of incident comments.
type IncidentCommentList struct {
	autorest.Response `json:"-"`
	// NextLink - READ-ONLY; URL to fetch the next set of comments.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - Array of comments.
	Value *[]IncidentComment `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for IncidentCommentList.
func (icl IncidentCommentList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if icl.Value != nil {
		objectMap["value"] = icl.Value
	}
	return json.Marshal(objectMap)
}

// IncidentCommentListIterator provides access to a complete listing of IncidentComment values.
type IncidentCommentListIterator struct {
	i    int
	page IncidentCommentListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *IncidentCommentListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IncidentCommentListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *IncidentCommentListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter IncidentCommentListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter IncidentCommentListIterator) Response() IncidentCommentList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter IncidentCommentListIterator) Value() IncidentComment {
	if !iter.page.NotDone() {
		return IncidentComment{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the IncidentCommentListIterator type.
func NewIncidentCommentListIterator(page IncidentCommentListPage) IncidentCommentListIterator {
	return IncidentCommentListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (icl IncidentCommentList) IsEmpty() bool {
	return icl.Value == nil || len(*icl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (icl IncidentCommentList) hasNextLink() bool {
	return icl.NextLink != nil && len(*icl.NextLink) != 0
}

// incidentCommentListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (icl IncidentCommentList) incidentCommentListPreparer(ctx context.Context) (*http.Request, error) {
	if !icl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(icl.NextLink)))
}

// IncidentCommentListPage contains a page of IncidentComment values.
type IncidentCommentListPage struct {
	fn  func(context.Context, IncidentCommentList) (IncidentCommentList, error)
	icl IncidentCommentList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *IncidentCommentListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IncidentCommentListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.icl)
		if err != nil {
			return err
		}
		page.icl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *IncidentCommentListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page IncidentCommentListPage) NotDone() bool {
	return !page.icl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page IncidentCommentListPage) Response() IncidentCommentList {
	return page.icl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page IncidentCommentListPage) Values() []IncidentComment {
	if page.icl.IsEmpty() {
		return nil
	}
	return *page.icl.Value
}

// Creates a new instance of the IncidentCommentListPage type.
func NewIncidentCommentListPage(cur IncidentCommentList, getNextPage func(context.Context, IncidentCommentList) (IncidentCommentList, error)) IncidentCommentListPage {
	return IncidentCommentListPage{
		fn:  getNextPage,
		icl: cur,
	}
}

// IncidentCommentProperties incident comment property bag.
type IncidentCommentProperties struct {
	// CreatedTimeUtc - READ-ONLY; The time the comment was created
	CreatedTimeUtc *date.Time `json:"createdTimeUtc,omitempty"`
	// Message - The comment message
	Message *string `json:"message,omitempty"`
	// Author - READ-ONLY; Describes the client that created the comment
	Author *ClientInfo `json:"author,omitempty"`
}

// MarshalJSON is the custom marshaler for IncidentCommentProperties.
func (icp IncidentCommentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if icp.Message != nil {
		objectMap["message"] = icp.Message
	}
	return json.Marshal(objectMap)
}

// IncidentInfo describes related incident information for the bookmark
type IncidentInfo struct {
	// IncidentID - Incident Id
	IncidentID *string `json:"incidentId,omitempty"`
	// Severity - The severity of the incident. Possible values include: 'CaseSeverityCritical', 'CaseSeverityHigh', 'CaseSeverityMedium', 'CaseSeverityLow', 'CaseSeverityInformational'
	Severity CaseSeverity `json:"severity,omitempty"`
	// Title - The title of the incident
	Title *string `json:"title,omitempty"`
	// RelationName - Relation Name
	RelationName *string `json:"relationName,omitempty"`
}

// IncidentLabel represents an incident label
type IncidentLabel struct {
	// LabelName - The name of the label
	LabelName *string `json:"labelName,omitempty"`
	// LabelType - READ-ONLY; The type of the label. Possible values include: 'IncidentLabelTypeUser', 'IncidentLabelTypeSystem'
	LabelType IncidentLabelType `json:"labelType,omitempty"`
}

// MarshalJSON is the custom marshaler for IncidentLabel.
func (il IncidentLabel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if il.LabelName != nil {
		objectMap["labelName"] = il.LabelName
	}
	return json.Marshal(objectMap)
}

// IncidentList list all the incidents.
type IncidentList struct {
	autorest.Response `json:"-"`
	// NextLink - READ-ONLY; URL to fetch the next set of incidents.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - Array of incidents.
	Value *[]Incident `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for IncidentList.
func (il IncidentList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if il.Value != nil {
		objectMap["value"] = il.Value
	}
	return json.Marshal(objectMap)
}

// IncidentListIterator provides access to a complete listing of Incident values.
type IncidentListIterator struct {
	i    int
	page IncidentListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *IncidentListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IncidentListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *IncidentListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter IncidentListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter IncidentListIterator) Response() IncidentList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter IncidentListIterator) Value() Incident {
	if !iter.page.NotDone() {
		return Incident{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the IncidentListIterator type.
func NewIncidentListIterator(page IncidentListPage) IncidentListIterator {
	return IncidentListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (il IncidentList) IsEmpty() bool {
	return il.Value == nil || len(*il.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (il IncidentList) hasNextLink() bool {
	return il.NextLink != nil && len(*il.NextLink) != 0
}

// incidentListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (il IncidentList) incidentListPreparer(ctx context.Context) (*http.Request, error) {
	if !il.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(il.NextLink)))
}

// IncidentListPage contains a page of Incident values.
type IncidentListPage struct {
	fn func(context.Context, IncidentList) (IncidentList, error)
	il IncidentList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *IncidentListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IncidentListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.il)
		if err != nil {
			return err
		}
		page.il = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *IncidentListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page IncidentListPage) NotDone() bool {
	return !page.il.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page IncidentListPage) Response() IncidentList {
	return page.il
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page IncidentListPage) Values() []Incident {
	if page.il.IsEmpty() {
		return nil
	}
	return *page.il.Value
}

// Creates a new instance of the IncidentListPage type.
func NewIncidentListPage(cur IncidentList, getNextPage func(context.Context, IncidentList) (IncidentList, error)) IncidentListPage {
	return IncidentListPage{
		fn: getNextPage,
		il: cur,
	}
}

// IncidentOwnerInfo information on the user an incident is assigned to
type IncidentOwnerInfo struct {
	// Email - The email of the user the incident is assigned to.
	Email *string `json:"email,omitempty"`
	// AssignedTo - The name of the user the incident is assigned to.
	AssignedTo *string `json:"assignedTo,omitempty"`
	// ObjectID - The object id of the user the incident is assigned to.
	ObjectID *uuid.UUID `json:"objectId,omitempty"`
	// UserPrincipalName - The user principal name of the user the incident is assigned to.
	UserPrincipalName *string `json:"userPrincipalName,omitempty"`
}

// IncidentProperties describes incident properties
type IncidentProperties struct {
	// AdditionalData - READ-ONLY; Additional data on the incident
	AdditionalData *IncidentAdditionalData `json:"additionalData,omitempty"`
	// Classification - The reason the incident was closed. Possible values include: 'IncidentClassificationUndetermined', 'IncidentClassificationTruePositive', 'IncidentClassificationBenignPositive', 'IncidentClassificationFalsePositive'
	Classification IncidentClassification `json:"classification,omitempty"`
	// ClassificationComment - Describes the reason the incident was closed
	ClassificationComment *string `json:"classificationComment,omitempty"`
	// ClassificationReason - The classification reason the incident was closed with. Possible values include: 'IncidentClassificationReasonSuspiciousActivity', 'IncidentClassificationReasonSuspiciousButExpected', 'IncidentClassificationReasonIncorrectAlertLogic', 'IncidentClassificationReasonInaccurateData'
	ClassificationReason IncidentClassificationReason `json:"classificationReason,omitempty"`
	// CreatedTimeUtc - READ-ONLY; The time the incident was created
	CreatedTimeUtc *date.Time `json:"createdTimeUtc,omitempty"`
	// Description - The description of the incident
	Description *string `json:"description,omitempty"`
	// FirstActivityTimeUtc - The time of the first activity in the incident
	FirstActivityTimeUtc *date.Time `json:"firstActivityTimeUtc,omitempty"`
	// IncidentURL - READ-ONLY; The deep-link url to the incident in Azure portal
	IncidentURL *string `json:"incidentUrl,omitempty"`
	// IncidentNumber - READ-ONLY; A sequential number
	IncidentNumber *int32 `json:"incidentNumber,omitempty"`
	// Labels - List of labels relevant to this incident
	Labels *[]IncidentLabel `json:"labels,omitempty"`
	// LastActivityTimeUtc - The time of the last activity in the incident
	LastActivityTimeUtc *date.Time `json:"lastActivityTimeUtc,omitempty"`
	// LastModifiedTimeUtc - READ-ONLY; The last time the incident was updated
	LastModifiedTimeUtc *date.Time `json:"lastModifiedTimeUtc,omitempty"`
	// Owner - Describes a user that the incident is assigned to
	Owner *IncidentOwnerInfo `json:"owner,omitempty"`
	// RelatedAnalyticRuleIds - READ-ONLY; List of resource ids of Analytic rules related to the incident
	RelatedAnalyticRuleIds *[]string `json:"relatedAnalyticRuleIds,omitempty"`
	// Severity - The severity of the incident. Possible values include: 'IncidentSeverityHigh', 'IncidentSeverityMedium', 'IncidentSeverityLow', 'IncidentSeverityInformational'
	Severity IncidentSeverity `json:"severity,omitempty"`
	// Status - The status of the incident. Possible values include: 'IncidentStatusNew', 'IncidentStatusActive', 'IncidentStatusClosed'
	Status IncidentStatus `json:"status,omitempty"`
	// Title - The title of the incident
	Title *string `json:"title,omitempty"`
}

// MarshalJSON is the custom marshaler for IncidentProperties.
func (IP IncidentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if IP.Classification != "" {
		objectMap["classification"] = IP.Classification
	}
	if IP.ClassificationComment != nil {
		objectMap["classificationComment"] = IP.ClassificationComment
	}
	if IP.ClassificationReason != "" {
		objectMap["classificationReason"] = IP.ClassificationReason
	}
	if IP.Description != nil {
		objectMap["description"] = IP.Description
	}
	if IP.FirstActivityTimeUtc != nil {
		objectMap["firstActivityTimeUtc"] = IP.FirstActivityTimeUtc
	}
	if IP.Labels != nil {
		objectMap["labels"] = IP.Labels
	}
	if IP.LastActivityTimeUtc != nil {
		objectMap["lastActivityTimeUtc"] = IP.LastActivityTimeUtc
	}
	if IP.Owner != nil {
		objectMap["owner"] = IP.Owner
	}
	if IP.Severity != "" {
		objectMap["severity"] = IP.Severity
	}
	if IP.Status != "" {
		objectMap["status"] = IP.Status
	}
	if IP.Title != nil {
		objectMap["title"] = IP.Title
	}
	return json.Marshal(objectMap)
}

// MCASDataConnector represents MCAS (Microsoft Cloud App Security) data connector.
type MCASDataConnector struct {
	// MCASDataConnectorProperties - MCAS (Microsoft Cloud App Security) data connector properties.
	*MCASDataConnectorProperties `json:"properties,omitempty"`
	// Kind - Possible values include: 'KindBasicDataConnectorKindDataConnector', 'KindBasicDataConnectorKindAzureActiveDirectory', 'KindBasicDataConnectorKindAzureAdvancedThreatProtection', 'KindBasicDataConnectorKindAzureSecurityCenter', 'KindBasicDataConnectorKindAmazonWebServicesCloudTrail', 'KindBasicDataConnectorKindMicrosoftCloudAppSecurity', 'KindBasicDataConnectorKindMicrosoftDefenderAdvancedThreatProtection', 'KindBasicDataConnectorKindOffice365', 'KindBasicDataConnectorKindThreatIntelligence'
	Kind KindBasicDataConnector `json:"kind,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Etag - Etag of the azure resource
	Etag *string `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for MCASDataConnector.
func (mdc MCASDataConnector) MarshalJSON() ([]byte, error) {
	mdc.Kind = KindBasicDataConnectorKindMicrosoftCloudAppSecurity
	objectMap := make(map[string]interface{})
	if mdc.MCASDataConnectorProperties != nil {
		objectMap["properties"] = mdc.MCASDataConnectorProperties
	}
	if mdc.Kind != "" {
		objectMap["kind"] = mdc.Kind
	}
	if mdc.Etag != nil {
		objectMap["etag"] = mdc.Etag
	}
	return json.Marshal(objectMap)
}

// AsAADDataConnector is the BasicDataConnector implementation for MCASDataConnector.
func (mdc MCASDataConnector) AsAADDataConnector() (*AADDataConnector, bool) {
	return nil, false
}

// AsAATPDataConnector is the BasicDataConnector implementation for MCASDataConnector.
func (mdc MCASDataConnector) AsAATPDataConnector() (*AATPDataConnector, bool) {
	return nil, false
}

// AsASCDataConnector is the BasicDataConnector implementation for MCASDataConnector.
func (mdc MCASDataConnector) AsASCDataConnector() (*ASCDataConnector, bool) {
	return nil, false
}

// AsAwsCloudTrailDataConnector is the BasicDataConnector implementation for MCASDataConnector.
func (mdc MCASDataConnector) AsAwsCloudTrailDataConnector() (*AwsCloudTrailDataConnector, bool) {
	return nil, false
}

// AsMCASDataConnector is the BasicDataConnector implementation for MCASDataConnector.
func (mdc MCASDataConnector) AsMCASDataConnector() (*MCASDataConnector, bool) {
	return &mdc, true
}

// AsMDATPDataConnector is the BasicDataConnector implementation for MCASDataConnector.
func (mdc MCASDataConnector) AsMDATPDataConnector() (*MDATPDataConnector, bool) {
	return nil, false
}

// AsOfficeDataConnector is the BasicDataConnector implementation for MCASDataConnector.
func (mdc MCASDataConnector) AsOfficeDataConnector() (*OfficeDataConnector, bool) {
	return nil, false
}

// AsTIDataConnector is the BasicDataConnector implementation for MCASDataConnector.
func (mdc MCASDataConnector) AsTIDataConnector() (*TIDataConnector, bool) {
	return nil, false
}

// AsDataConnector is the BasicDataConnector implementation for MCASDataConnector.
func (mdc MCASDataConnector) AsDataConnector() (*DataConnector, bool) {
	return nil, false
}

// AsBasicDataConnector is the BasicDataConnector implementation for MCASDataConnector.
func (mdc MCASDataConnector) AsBasicDataConnector() (BasicDataConnector, bool) {
	return &mdc, true
}

// UnmarshalJSON is the custom unmarshaler for MCASDataConnector struct.
func (mdc *MCASDataConnector) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var mCASDataConnectorProperties MCASDataConnectorProperties
				err = json.Unmarshal(*v, &mCASDataConnectorProperties)
				if err != nil {
					return err
				}
				mdc.MCASDataConnectorProperties = &mCASDataConnectorProperties
			}
		case "kind":
			if v != nil {
				var kind KindBasicDataConnector
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				mdc.Kind = kind
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mdc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mdc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mdc.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				mdc.Etag = &etag
			}
		}
	}

	return nil
}

// MCASDataConnectorDataTypes the available data types for MCAS (Microsoft Cloud App Security) data
// connector.
type MCASDataConnectorDataTypes struct {
	// DiscoveryLogs - Discovery log data type connection.
	DiscoveryLogs *DataConnectorDataTypeCommon `json:"discoveryLogs,omitempty"`
	// Alerts - Alerts data type connection.
	Alerts *DataConnectorDataTypeCommon `json:"alerts,omitempty"`
}

// MCASDataConnectorProperties MCAS (Microsoft Cloud App Security) data connector properties.
type MCASDataConnectorProperties struct {
	// TenantID - The tenant id to connect to, and get the data from.
	TenantID *string `json:"tenantId,omitempty"`
	// DataTypes - The available data types for the connector.
	DataTypes *MCASDataConnectorDataTypes `json:"dataTypes,omitempty"`
}

// MDATPDataConnector represents MDATP (Microsoft Defender Advanced Threat Protection) data connector.
type MDATPDataConnector struct {
	// MDATPDataConnectorProperties - MDATP (Microsoft Defender Advanced Threat Protection) data connector properties.
	*MDATPDataConnectorProperties `json:"properties,omitempty"`
	// Kind - Possible values include: 'KindBasicDataConnectorKindDataConnector', 'KindBasicDataConnectorKindAzureActiveDirectory', 'KindBasicDataConnectorKindAzureAdvancedThreatProtection', 'KindBasicDataConnectorKindAzureSecurityCenter', 'KindBasicDataConnectorKindAmazonWebServicesCloudTrail', 'KindBasicDataConnectorKindMicrosoftCloudAppSecurity', 'KindBasicDataConnectorKindMicrosoftDefenderAdvancedThreatProtection', 'KindBasicDataConnectorKindOffice365', 'KindBasicDataConnectorKindThreatIntelligence'
	Kind KindBasicDataConnector `json:"kind,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Etag - Etag of the azure resource
	Etag *string `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for MDATPDataConnector.
func (mdc MDATPDataConnector) MarshalJSON() ([]byte, error) {
	mdc.Kind = KindBasicDataConnectorKindMicrosoftDefenderAdvancedThreatProtection
	objectMap := make(map[string]interface{})
	if mdc.MDATPDataConnectorProperties != nil {
		objectMap["properties"] = mdc.MDATPDataConnectorProperties
	}
	if mdc.Kind != "" {
		objectMap["kind"] = mdc.Kind
	}
	if mdc.Etag != nil {
		objectMap["etag"] = mdc.Etag
	}
	return json.Marshal(objectMap)
}

// AsAADDataConnector is the BasicDataConnector implementation for MDATPDataConnector.
func (mdc MDATPDataConnector) AsAADDataConnector() (*AADDataConnector, bool) {
	return nil, false
}

// AsAATPDataConnector is the BasicDataConnector implementation for MDATPDataConnector.
func (mdc MDATPDataConnector) AsAATPDataConnector() (*AATPDataConnector, bool) {
	return nil, false
}

// AsASCDataConnector is the BasicDataConnector implementation for MDATPDataConnector.
func (mdc MDATPDataConnector) AsASCDataConnector() (*ASCDataConnector, bool) {
	return nil, false
}

// AsAwsCloudTrailDataConnector is the BasicDataConnector implementation for MDATPDataConnector.
func (mdc MDATPDataConnector) AsAwsCloudTrailDataConnector() (*AwsCloudTrailDataConnector, bool) {
	return nil, false
}

// AsMCASDataConnector is the BasicDataConnector implementation for MDATPDataConnector.
func (mdc MDATPDataConnector) AsMCASDataConnector() (*MCASDataConnector, bool) {
	return nil, false
}

// AsMDATPDataConnector is the BasicDataConnector implementation for MDATPDataConnector.
func (mdc MDATPDataConnector) AsMDATPDataConnector() (*MDATPDataConnector, bool) {
	return &mdc, true
}

// AsOfficeDataConnector is the BasicDataConnector implementation for MDATPDataConnector.
func (mdc MDATPDataConnector) AsOfficeDataConnector() (*OfficeDataConnector, bool) {
	return nil, false
}

// AsTIDataConnector is the BasicDataConnector implementation for MDATPDataConnector.
func (mdc MDATPDataConnector) AsTIDataConnector() (*TIDataConnector, bool) {
	return nil, false
}

// AsDataConnector is the BasicDataConnector implementation for MDATPDataConnector.
func (mdc MDATPDataConnector) AsDataConnector() (*DataConnector, bool) {
	return nil, false
}

// AsBasicDataConnector is the BasicDataConnector implementation for MDATPDataConnector.
func (mdc MDATPDataConnector) AsBasicDataConnector() (BasicDataConnector, bool) {
	return &mdc, true
}

// UnmarshalJSON is the custom unmarshaler for MDATPDataConnector struct.
func (mdc *MDATPDataConnector) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var mDATPDataConnectorProperties MDATPDataConnectorProperties
				err = json.Unmarshal(*v, &mDATPDataConnectorProperties)
				if err != nil {
					return err
				}
				mdc.MDATPDataConnectorProperties = &mDATPDataConnectorProperties
			}
		case "kind":
			if v != nil {
				var kind KindBasicDataConnector
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				mdc.Kind = kind
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mdc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mdc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mdc.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				mdc.Etag = &etag
			}
		}
	}

	return nil
}

// MDATPDataConnectorProperties MDATP (Microsoft Defender Advanced Threat Protection) data connector
// properties.
type MDATPDataConnectorProperties struct {
	// TenantID - The tenant id to connect to, and get the data from.
	TenantID *string `json:"tenantId,omitempty"`
	// DataTypes - The available data types for the connector.
	DataTypes *AlertsDataTypeOfDataConnector `json:"dataTypes,omitempty"`
}

// MicrosoftSecurityIncidentCreationAlertRule represents MicrosoftSecurityIncidentCreation rule.
type MicrosoftSecurityIncidentCreationAlertRule struct {
	// MicrosoftSecurityIncidentCreationAlertRuleProperties - MicrosoftSecurityIncidentCreation rule properties
	*MicrosoftSecurityIncidentCreationAlertRuleProperties `json:"properties,omitempty"`
	// Kind - Possible values include: 'KindKindAlertRule', 'KindKindFusion', 'KindKindMicrosoftSecurityIncidentCreation', 'KindKindScheduled'
	Kind Kind `json:"kind,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Etag - Etag of the azure resource
	Etag *string `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for MicrosoftSecurityIncidentCreationAlertRule.
func (msicar MicrosoftSecurityIncidentCreationAlertRule) MarshalJSON() ([]byte, error) {
	msicar.Kind = KindKindMicrosoftSecurityIncidentCreation
	objectMap := make(map[string]interface{})
	if msicar.MicrosoftSecurityIncidentCreationAlertRuleProperties != nil {
		objectMap["properties"] = msicar.MicrosoftSecurityIncidentCreationAlertRuleProperties
	}
	if msicar.Kind != "" {
		objectMap["kind"] = msicar.Kind
	}
	if msicar.Etag != nil {
		objectMap["etag"] = msicar.Etag
	}
	return json.Marshal(objectMap)
}

// AsFusionAlertRule is the BasicAlertRule implementation for MicrosoftSecurityIncidentCreationAlertRule.
func (msicar MicrosoftSecurityIncidentCreationAlertRule) AsFusionAlertRule() (*FusionAlertRule, bool) {
	return nil, false
}

// AsMicrosoftSecurityIncidentCreationAlertRule is the BasicAlertRule implementation for MicrosoftSecurityIncidentCreationAlertRule.
func (msicar MicrosoftSecurityIncidentCreationAlertRule) AsMicrosoftSecurityIncidentCreationAlertRule() (*MicrosoftSecurityIncidentCreationAlertRule, bool) {
	return &msicar, true
}

// AsScheduledAlertRule is the BasicAlertRule implementation for MicrosoftSecurityIncidentCreationAlertRule.
func (msicar MicrosoftSecurityIncidentCreationAlertRule) AsScheduledAlertRule() (*ScheduledAlertRule, bool) {
	return nil, false
}

// AsAlertRule is the BasicAlertRule implementation for MicrosoftSecurityIncidentCreationAlertRule.
func (msicar MicrosoftSecurityIncidentCreationAlertRule) AsAlertRule() (*AlertRule, bool) {
	return nil, false
}

// AsBasicAlertRule is the BasicAlertRule implementation for MicrosoftSecurityIncidentCreationAlertRule.
func (msicar MicrosoftSecurityIncidentCreationAlertRule) AsBasicAlertRule() (BasicAlertRule, bool) {
	return &msicar, true
}

// UnmarshalJSON is the custom unmarshaler for MicrosoftSecurityIncidentCreationAlertRule struct.
func (msicar *MicrosoftSecurityIncidentCreationAlertRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var microsoftSecurityIncidentCreationAlertRuleProperties MicrosoftSecurityIncidentCreationAlertRuleProperties
				err = json.Unmarshal(*v, &microsoftSecurityIncidentCreationAlertRuleProperties)
				if err != nil {
					return err
				}
				msicar.MicrosoftSecurityIncidentCreationAlertRuleProperties = &microsoftSecurityIncidentCreationAlertRuleProperties
			}
		case "kind":
			if v != nil {
				var kind Kind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				msicar.Kind = kind
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				msicar.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				msicar.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				msicar.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				msicar.Etag = &etag
			}
		}
	}

	return nil
}

// MicrosoftSecurityIncidentCreationAlertRuleCommonProperties microsoftSecurityIncidentCreation rule common
// property bag.
type MicrosoftSecurityIncidentCreationAlertRuleCommonProperties struct {
	// DisplayNamesFilter - the alerts' displayNames on which the cases will be generated
	DisplayNamesFilter *[]string `json:"displayNamesFilter,omitempty"`
	// DisplayNamesExcludeFilter - the alerts' displayNames on which the cases will not be generated
	DisplayNamesExcludeFilter *[]string `json:"displayNamesExcludeFilter,omitempty"`
	// ProductFilter - The alerts' productName on which the cases will be generated. Possible values include: 'MicrosoftSecurityProductNameMicrosoftCloudAppSecurity', 'MicrosoftSecurityProductNameAzureSecurityCenter', 'MicrosoftSecurityProductNameAzureAdvancedThreatProtection', 'MicrosoftSecurityProductNameAzureActiveDirectoryIdentityProtection', 'MicrosoftSecurityProductNameAzureSecurityCenterforIoT'
	ProductFilter MicrosoftSecurityProductName `json:"productFilter,omitempty"`
	// SeveritiesFilter - the alerts' severities on which the cases will be generated
	SeveritiesFilter *[]AlertSeverity `json:"severitiesFilter,omitempty"`
}

// MicrosoftSecurityIncidentCreationAlertRuleProperties microsoftSecurityIncidentCreation rule property
// bag.
type MicrosoftSecurityIncidentCreationAlertRuleProperties struct {
	// AlertRuleTemplateName - The Name of the alert rule template used to create this rule.
	AlertRuleTemplateName *string `json:"alertRuleTemplateName,omitempty"`
	// Description - The description of the alert rule.
	Description *string `json:"description,omitempty"`
	// DisplayName - The display name for alerts created by this alert rule.
	DisplayName *string `json:"displayName,omitempty"`
	// Enabled - Determines whether this alert rule is enabled or disabled.
	Enabled *bool `json:"enabled,omitempty"`
	// LastModifiedUtc - READ-ONLY; The last time that this alert has been modified.
	LastModifiedUtc *date.Time `json:"lastModifiedUtc,omitempty"`
	// DisplayNamesFilter - the alerts' displayNames on which the cases will be generated
	DisplayNamesFilter *[]string `json:"displayNamesFilter,omitempty"`
	// DisplayNamesExcludeFilter - the alerts' displayNames on which the cases will not be generated
	DisplayNamesExcludeFilter *[]string `json:"displayNamesExcludeFilter,omitempty"`
	// ProductFilter - The alerts' productName on which the cases will be generated. Possible values include: 'MicrosoftSecurityProductNameMicrosoftCloudAppSecurity', 'MicrosoftSecurityProductNameAzureSecurityCenter', 'MicrosoftSecurityProductNameAzureAdvancedThreatProtection', 'MicrosoftSecurityProductNameAzureActiveDirectoryIdentityProtection', 'MicrosoftSecurityProductNameAzureSecurityCenterforIoT'
	ProductFilter MicrosoftSecurityProductName `json:"productFilter,omitempty"`
	// SeveritiesFilter - the alerts' severities on which the cases will be generated
	SeveritiesFilter *[]AlertSeverity `json:"severitiesFilter,omitempty"`
}

// MarshalJSON is the custom marshaler for MicrosoftSecurityIncidentCreationAlertRuleProperties.
func (msicarp MicrosoftSecurityIncidentCreationAlertRuleProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if msicarp.AlertRuleTemplateName != nil {
		objectMap["alertRuleTemplateName"] = msicarp.AlertRuleTemplateName
	}
	if msicarp.Description != nil {
		objectMap["description"] = msicarp.Description
	}
	if msicarp.DisplayName != nil {
		objectMap["displayName"] = msicarp.DisplayName
	}
	if msicarp.Enabled != nil {
		objectMap["enabled"] = msicarp.Enabled
	}
	if msicarp.DisplayNamesFilter != nil {
		objectMap["displayNamesFilter"] = msicarp.DisplayNamesFilter
	}
	if msicarp.DisplayNamesExcludeFilter != nil {
		objectMap["displayNamesExcludeFilter"] = msicarp.DisplayNamesExcludeFilter
	}
	if msicarp.ProductFilter != "" {
		objectMap["productFilter"] = msicarp.ProductFilter
	}
	if msicarp.SeveritiesFilter != nil {
		objectMap["severitiesFilter"] = msicarp.SeveritiesFilter
	}
	return json.Marshal(objectMap)
}

// MicrosoftSecurityIncidentCreationAlertRuleTemplate represents MicrosoftSecurityIncidentCreation rule
// template.
type MicrosoftSecurityIncidentCreationAlertRuleTemplate struct {
	// MicrosoftSecurityIncidentCreationAlertRuleTemplateProperties - MicrosoftSecurityIncidentCreation rule template properties
	*MicrosoftSecurityIncidentCreationAlertRuleTemplateProperties `json:"properties,omitempty"`
	// Kind - Possible values include: 'KindBasicAlertRuleTemplateKindAlertRuleTemplate', 'KindBasicAlertRuleTemplateKindFusion', 'KindBasicAlertRuleTemplateKindMicrosoftSecurityIncidentCreation', 'KindBasicAlertRuleTemplateKindScheduled'
	Kind KindBasicAlertRuleTemplate `json:"kind,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for MicrosoftSecurityIncidentCreationAlertRuleTemplate.
func (msicart MicrosoftSecurityIncidentCreationAlertRuleTemplate) MarshalJSON() ([]byte, error) {
	msicart.Kind = KindBasicAlertRuleTemplateKindMicrosoftSecurityIncidentCreation
	objectMap := make(map[string]interface{})
	if msicart.MicrosoftSecurityIncidentCreationAlertRuleTemplateProperties != nil {
		objectMap["properties"] = msicart.MicrosoftSecurityIncidentCreationAlertRuleTemplateProperties
	}
	if msicart.Kind != "" {
		objectMap["kind"] = msicart.Kind
	}
	return json.Marshal(objectMap)
}

// AsFusionAlertRuleTemplate is the BasicAlertRuleTemplate implementation for MicrosoftSecurityIncidentCreationAlertRuleTemplate.
func (msicart MicrosoftSecurityIncidentCreationAlertRuleTemplate) AsFusionAlertRuleTemplate() (*FusionAlertRuleTemplate, bool) {
	return nil, false
}

// AsMicrosoftSecurityIncidentCreationAlertRuleTemplate is the BasicAlertRuleTemplate implementation for MicrosoftSecurityIncidentCreationAlertRuleTemplate.
func (msicart MicrosoftSecurityIncidentCreationAlertRuleTemplate) AsMicrosoftSecurityIncidentCreationAlertRuleTemplate() (*MicrosoftSecurityIncidentCreationAlertRuleTemplate, bool) {
	return &msicart, true
}

// AsScheduledAlertRuleTemplate is the BasicAlertRuleTemplate implementation for MicrosoftSecurityIncidentCreationAlertRuleTemplate.
func (msicart MicrosoftSecurityIncidentCreationAlertRuleTemplate) AsScheduledAlertRuleTemplate() (*ScheduledAlertRuleTemplate, bool) {
	return nil, false
}

// AsAlertRuleTemplate is the BasicAlertRuleTemplate implementation for MicrosoftSecurityIncidentCreationAlertRuleTemplate.
func (msicart MicrosoftSecurityIncidentCreationAlertRuleTemplate) AsAlertRuleTemplate() (*AlertRuleTemplate, bool) {
	return nil, false
}

// AsBasicAlertRuleTemplate is the BasicAlertRuleTemplate implementation for MicrosoftSecurityIncidentCreationAlertRuleTemplate.
func (msicart MicrosoftSecurityIncidentCreationAlertRuleTemplate) AsBasicAlertRuleTemplate() (BasicAlertRuleTemplate, bool) {
	return &msicart, true
}

// UnmarshalJSON is the custom unmarshaler for MicrosoftSecurityIncidentCreationAlertRuleTemplate struct.
func (msicart *MicrosoftSecurityIncidentCreationAlertRuleTemplate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var microsoftSecurityIncidentCreationAlertRuleTemplateProperties MicrosoftSecurityIncidentCreationAlertRuleTemplateProperties
				err = json.Unmarshal(*v, &microsoftSecurityIncidentCreationAlertRuleTemplateProperties)
				if err != nil {
					return err
				}
				msicart.MicrosoftSecurityIncidentCreationAlertRuleTemplateProperties = &microsoftSecurityIncidentCreationAlertRuleTemplateProperties
			}
		case "kind":
			if v != nil {
				var kind KindBasicAlertRuleTemplate
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				msicart.Kind = kind
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				msicart.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				msicart.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				msicart.Type = &typeVar
			}
		}
	}

	return nil
}

// MicrosoftSecurityIncidentCreationAlertRuleTemplateProperties microsoftSecurityIncidentCreation rule
// template properties
type MicrosoftSecurityIncidentCreationAlertRuleTemplateProperties struct {
	// AlertRulesCreatedByTemplateCount - the number of alert rules that were created by this template
	AlertRulesCreatedByTemplateCount *int32 `json:"alertRulesCreatedByTemplateCount,omitempty"`
	// CreatedDateUTC - READ-ONLY; The time that this alert rule template has been added.
	CreatedDateUTC *date.Time `json:"createdDateUTC,omitempty"`
	// Description - The description of the alert rule template.
	Description *string `json:"description,omitempty"`
	// DisplayName - The display name for alert rule template.
	DisplayName *string `json:"displayName,omitempty"`
	// RequiredDataConnectors - The required data connectors for this template
	RequiredDataConnectors *[]AlertRuleTemplateDataSource `json:"requiredDataConnectors,omitempty"`
	// Status - The alert rule template status. Possible values include: 'TemplateStatusInstalled', 'TemplateStatusAvailable', 'TemplateStatusNotAvailable'
	Status TemplateStatus `json:"status,omitempty"`
	// DisplayNamesFilter - the alerts' displayNames on which the cases will be generated
	DisplayNamesFilter *[]string `json:"displayNamesFilter,omitempty"`
	// DisplayNamesExcludeFilter - the alerts' displayNames on which the cases will not be generated
	DisplayNamesExcludeFilter *[]string `json:"displayNamesExcludeFilter,omitempty"`
	// ProductFilter - The alerts' productName on which the cases will be generated. Possible values include: 'MicrosoftSecurityProductNameMicrosoftCloudAppSecurity', 'MicrosoftSecurityProductNameAzureSecurityCenter', 'MicrosoftSecurityProductNameAzureAdvancedThreatProtection', 'MicrosoftSecurityProductNameAzureActiveDirectoryIdentityProtection', 'MicrosoftSecurityProductNameAzureSecurityCenterforIoT'
	ProductFilter MicrosoftSecurityProductName `json:"productFilter,omitempty"`
	// SeveritiesFilter - the alerts' severities on which the cases will be generated
	SeveritiesFilter *[]AlertSeverity `json:"severitiesFilter,omitempty"`
}

// MarshalJSON is the custom marshaler for MicrosoftSecurityIncidentCreationAlertRuleTemplateProperties.
func (msicartp MicrosoftSecurityIncidentCreationAlertRuleTemplateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if msicartp.AlertRulesCreatedByTemplateCount != nil {
		objectMap["alertRulesCreatedByTemplateCount"] = msicartp.AlertRulesCreatedByTemplateCount
	}
	if msicartp.Description != nil {
		objectMap["description"] = msicartp.Description
	}
	if msicartp.DisplayName != nil {
		objectMap["displayName"] = msicartp.DisplayName
	}
	if msicartp.RequiredDataConnectors != nil {
		objectMap["requiredDataConnectors"] = msicartp.RequiredDataConnectors
	}
	if msicartp.Status != "" {
		objectMap["status"] = msicartp.Status
	}
	if msicartp.DisplayNamesFilter != nil {
		objectMap["displayNamesFilter"] = msicartp.DisplayNamesFilter
	}
	if msicartp.DisplayNamesExcludeFilter != nil {
		objectMap["displayNamesExcludeFilter"] = msicartp.DisplayNamesExcludeFilter
	}
	if msicartp.ProductFilter != "" {
		objectMap["productFilter"] = msicartp.ProductFilter
	}
	if msicartp.SeveritiesFilter != nil {
		objectMap["severitiesFilter"] = msicartp.SeveritiesFilter
	}
	return json.Marshal(objectMap)
}

// OfficeConsent consent for Office365 tenant that already made.
type OfficeConsent struct {
	// OfficeConsentProperties - Office consent properties
	*OfficeConsentProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for OfficeConsent.
func (oc OfficeConsent) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if oc.OfficeConsentProperties != nil {
		objectMap["properties"] = oc.OfficeConsentProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for OfficeConsent struct.
func (oc *OfficeConsent) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var officeConsentProperties OfficeConsentProperties
				err = json.Unmarshal(*v, &officeConsentProperties)
				if err != nil {
					return err
				}
				oc.OfficeConsentProperties = &officeConsentProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				oc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				oc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				oc.Type = &typeVar
			}
		}
	}

	return nil
}

// OfficeConsentList list of all the office365 consents.
type OfficeConsentList struct {
	// NextLink - READ-ONLY; URL to fetch the next set of office consents.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - Array of the consents.
	Value *[]OfficeConsent `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for OfficeConsentList.
func (ocl OfficeConsentList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ocl.Value != nil {
		objectMap["value"] = ocl.Value
	}
	return json.Marshal(objectMap)
}

// OfficeConsentProperties consent property bag.
type OfficeConsentProperties struct {
	// TenantID - The tenantId of the Office365 with the consent.
	TenantID *string `json:"tenantId,omitempty"`
	// TenantName - READ-ONLY; The tenant name of the Office365 with the consent.
	TenantName *string `json:"tenantName,omitempty"`
}

// MarshalJSON is the custom marshaler for OfficeConsentProperties.
func (ocp OfficeConsentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ocp.TenantID != nil {
		objectMap["tenantId"] = ocp.TenantID
	}
	return json.Marshal(objectMap)
}

// OfficeDataConnector represents office data connector.
type OfficeDataConnector struct {
	// OfficeDataConnectorProperties - Office data connector properties.
	*OfficeDataConnectorProperties `json:"properties,omitempty"`
	// Kind - Possible values include: 'KindBasicDataConnectorKindDataConnector', 'KindBasicDataConnectorKindAzureActiveDirectory', 'KindBasicDataConnectorKindAzureAdvancedThreatProtection', 'KindBasicDataConnectorKindAzureSecurityCenter', 'KindBasicDataConnectorKindAmazonWebServicesCloudTrail', 'KindBasicDataConnectorKindMicrosoftCloudAppSecurity', 'KindBasicDataConnectorKindMicrosoftDefenderAdvancedThreatProtection', 'KindBasicDataConnectorKindOffice365', 'KindBasicDataConnectorKindThreatIntelligence'
	Kind KindBasicDataConnector `json:"kind,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Etag - Etag of the azure resource
	Etag *string `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for OfficeDataConnector.
func (odc OfficeDataConnector) MarshalJSON() ([]byte, error) {
	odc.Kind = KindBasicDataConnectorKindOffice365
	objectMap := make(map[string]interface{})
	if odc.OfficeDataConnectorProperties != nil {
		objectMap["properties"] = odc.OfficeDataConnectorProperties
	}
	if odc.Kind != "" {
		objectMap["kind"] = odc.Kind
	}
	if odc.Etag != nil {
		objectMap["etag"] = odc.Etag
	}
	return json.Marshal(objectMap)
}

// AsAADDataConnector is the BasicDataConnector implementation for OfficeDataConnector.
func (odc OfficeDataConnector) AsAADDataConnector() (*AADDataConnector, bool) {
	return nil, false
}

// AsAATPDataConnector is the BasicDataConnector implementation for OfficeDataConnector.
func (odc OfficeDataConnector) AsAATPDataConnector() (*AATPDataConnector, bool) {
	return nil, false
}

// AsASCDataConnector is the BasicDataConnector implementation for OfficeDataConnector.
func (odc OfficeDataConnector) AsASCDataConnector() (*ASCDataConnector, bool) {
	return nil, false
}

// AsAwsCloudTrailDataConnector is the BasicDataConnector implementation for OfficeDataConnector.
func (odc OfficeDataConnector) AsAwsCloudTrailDataConnector() (*AwsCloudTrailDataConnector, bool) {
	return nil, false
}

// AsMCASDataConnector is the BasicDataConnector implementation for OfficeDataConnector.
func (odc OfficeDataConnector) AsMCASDataConnector() (*MCASDataConnector, bool) {
	return nil, false
}

// AsMDATPDataConnector is the BasicDataConnector implementation for OfficeDataConnector.
func (odc OfficeDataConnector) AsMDATPDataConnector() (*MDATPDataConnector, bool) {
	return nil, false
}

// AsOfficeDataConnector is the BasicDataConnector implementation for OfficeDataConnector.
func (odc OfficeDataConnector) AsOfficeDataConnector() (*OfficeDataConnector, bool) {
	return &odc, true
}

// AsTIDataConnector is the BasicDataConnector implementation for OfficeDataConnector.
func (odc OfficeDataConnector) AsTIDataConnector() (*TIDataConnector, bool) {
	return nil, false
}

// AsDataConnector is the BasicDataConnector implementation for OfficeDataConnector.
func (odc OfficeDataConnector) AsDataConnector() (*DataConnector, bool) {
	return nil, false
}

// AsBasicDataConnector is the BasicDataConnector implementation for OfficeDataConnector.
func (odc OfficeDataConnector) AsBasicDataConnector() (BasicDataConnector, bool) {
	return &odc, true
}

// UnmarshalJSON is the custom unmarshaler for OfficeDataConnector struct.
func (odc *OfficeDataConnector) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var officeDataConnectorProperties OfficeDataConnectorProperties
				err = json.Unmarshal(*v, &officeDataConnectorProperties)
				if err != nil {
					return err
				}
				odc.OfficeDataConnectorProperties = &officeDataConnectorProperties
			}
		case "kind":
			if v != nil {
				var kind KindBasicDataConnector
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				odc.Kind = kind
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				odc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				odc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				odc.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				odc.Etag = &etag
			}
		}
	}

	return nil
}

// OfficeDataConnectorDataTypes the available data types for office data connector.
type OfficeDataConnectorDataTypes struct {
	// Exchange - Exchange data type connection.
	Exchange *OfficeDataConnectorDataTypesExchange `json:"exchange,omitempty"`
	// SharePoint - SharePoint data type connection.
	SharePoint *OfficeDataConnectorDataTypesSharePoint `json:"sharePoint,omitempty"`
	// Teams - Teams data type connection.
	Teams *OfficeDataConnectorDataTypesTeams `json:"teams,omitempty"`
}

// OfficeDataConnectorDataTypesExchange exchange data type connection.
type OfficeDataConnectorDataTypesExchange struct {
	// State - Describe whether this data type connection is enabled or not. Possible values include: 'DataTypeStateEnabled', 'DataTypeStateDisabled'
	State DataTypeState `json:"state,omitempty"`
}

// OfficeDataConnectorDataTypesSharePoint sharePoint data type connection.
type OfficeDataConnectorDataTypesSharePoint struct {
	// State - Describe whether this data type connection is enabled or not. Possible values include: 'DataTypeStateEnabled', 'DataTypeStateDisabled'
	State DataTypeState `json:"state,omitempty"`
}

// OfficeDataConnectorDataTypesTeams teams data type connection.
type OfficeDataConnectorDataTypesTeams struct {
	// State - Describe whether this data type connection is enabled or not. Possible values include: 'DataTypeStateEnabled', 'DataTypeStateDisabled'
	State DataTypeState `json:"state,omitempty"`
}

// OfficeDataConnectorProperties office data connector properties.
type OfficeDataConnectorProperties struct {
	// TenantID - The tenant id to connect to, and get the data from.
	TenantID *string `json:"tenantId,omitempty"`
	// DataTypes - The available data types for the connector.
	DataTypes *OfficeDataConnectorDataTypes `json:"dataTypes,omitempty"`
}

// Operation operation provided by provider
type Operation struct {
	// Display - Properties of the operation
	Display *OperationDisplay `json:"display,omitempty"`
	// Name - Name of the operation
	Name *string `json:"name,omitempty"`
	// Origin - The origin of the operation
	Origin *string `json:"origin,omitempty"`
}

// OperationDisplay properties of the operation
type OperationDisplay struct {
	// Description - Description of the operation
	Description *string `json:"description,omitempty"`
	// Operation - Operation name
	Operation *string `json:"operation,omitempty"`
	// Provider - Provider name
	Provider *string `json:"provider,omitempty"`
	// Resource - Resource name
	Resource *string `json:"resource,omitempty"`
}

// OperationsList lists the operations available in the SecurityInsights RP.
type OperationsList struct {
	autorest.Response `json:"-"`
	// NextLink - URL to fetch the next set of operations.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - Array of operations
	Value *[]Operation `json:"value,omitempty"`
}

// OperationsListIterator provides access to a complete listing of Operation values.
type OperationsListIterator struct {
	i    int
	page OperationsListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationsListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationsListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationsListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationsListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationsListIterator) Response() OperationsList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationsListIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationsListIterator type.
func NewOperationsListIterator(page OperationsListPage) OperationsListIterator {
	return OperationsListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ol OperationsList) IsEmpty() bool {
	return ol.Value == nil || len(*ol.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ol OperationsList) hasNextLink() bool {
	return ol.NextLink != nil && len(*ol.NextLink) != 0
}

// operationsListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ol OperationsList) operationsListPreparer(ctx context.Context) (*http.Request, error) {
	if !ol.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ol.NextLink)))
}

// OperationsListPage contains a page of Operation values.
type OperationsListPage struct {
	fn func(context.Context, OperationsList) (OperationsList, error)
	ol OperationsList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationsListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationsListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ol)
		if err != nil {
			return err
		}
		page.ol = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationsListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationsListPage) NotDone() bool {
	return !page.ol.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationsListPage) Response() OperationsList {
	return page.ol
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationsListPage) Values() []Operation {
	if page.ol.IsEmpty() {
		return nil
	}
	return *page.ol.Value
}

// Creates a new instance of the OperationsListPage type.
func NewOperationsListPage(cur OperationsList, getNextPage func(context.Context, OperationsList) (OperationsList, error)) OperationsListPage {
	return OperationsListPage{
		fn: getNextPage,
		ol: cur,
	}
}

// Resource an azure resource object
type Resource struct {
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
}

// ResourceWithEtag an azure resource object with an Etag property
type ResourceWithEtag struct {
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Etag - Etag of the azure resource
	Etag *string `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceWithEtag.
func (rwe ResourceWithEtag) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rwe.Etag != nil {
		objectMap["etag"] = rwe.Etag
	}
	return json.Marshal(objectMap)
}

// ScheduledAlertRule represents scheduled alert rule.
type ScheduledAlertRule struct {
	// ScheduledAlertRuleProperties - Scheduled alert rule properties
	*ScheduledAlertRuleProperties `json:"properties,omitempty"`
	// Kind - Possible values include: 'KindKindAlertRule', 'KindKindFusion', 'KindKindMicrosoftSecurityIncidentCreation', 'KindKindScheduled'
	Kind Kind `json:"kind,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Etag - Etag of the azure resource
	Etag *string `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for ScheduledAlertRule.
func (sar ScheduledAlertRule) MarshalJSON() ([]byte, error) {
	sar.Kind = KindKindScheduled
	objectMap := make(map[string]interface{})
	if sar.ScheduledAlertRuleProperties != nil {
		objectMap["properties"] = sar.ScheduledAlertRuleProperties
	}
	if sar.Kind != "" {
		objectMap["kind"] = sar.Kind
	}
	if sar.Etag != nil {
		objectMap["etag"] = sar.Etag
	}
	return json.Marshal(objectMap)
}

// AsFusionAlertRule is the BasicAlertRule implementation for ScheduledAlertRule.
func (sar ScheduledAlertRule) AsFusionAlertRule() (*FusionAlertRule, bool) {
	return nil, false
}

// AsMicrosoftSecurityIncidentCreationAlertRule is the BasicAlertRule implementation for ScheduledAlertRule.
func (sar ScheduledAlertRule) AsMicrosoftSecurityIncidentCreationAlertRule() (*MicrosoftSecurityIncidentCreationAlertRule, bool) {
	return nil, false
}

// AsScheduledAlertRule is the BasicAlertRule implementation for ScheduledAlertRule.
func (sar ScheduledAlertRule) AsScheduledAlertRule() (*ScheduledAlertRule, bool) {
	return &sar, true
}

// AsAlertRule is the BasicAlertRule implementation for ScheduledAlertRule.
func (sar ScheduledAlertRule) AsAlertRule() (*AlertRule, bool) {
	return nil, false
}

// AsBasicAlertRule is the BasicAlertRule implementation for ScheduledAlertRule.
func (sar ScheduledAlertRule) AsBasicAlertRule() (BasicAlertRule, bool) {
	return &sar, true
}

// UnmarshalJSON is the custom unmarshaler for ScheduledAlertRule struct.
func (sar *ScheduledAlertRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var scheduledAlertRuleProperties ScheduledAlertRuleProperties
				err = json.Unmarshal(*v, &scheduledAlertRuleProperties)
				if err != nil {
					return err
				}
				sar.ScheduledAlertRuleProperties = &scheduledAlertRuleProperties
			}
		case "kind":
			if v != nil {
				var kind Kind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				sar.Kind = kind
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sar.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sar.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sar.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				sar.Etag = &etag
			}
		}
	}

	return nil
}

// ScheduledAlertRuleCommonProperties schedule alert rule template property bag.
type ScheduledAlertRuleCommonProperties struct {
	// Query - The query that creates alerts for this rule.
	Query *string `json:"query,omitempty"`
	// QueryFrequency - The frequency (in ISO 8601 duration format) for this alert rule to run.
	QueryFrequency *string `json:"queryFrequency,omitempty"`
	// QueryPeriod - The period (in ISO 8601 duration format) that this alert rule looks at.
	QueryPeriod *string `json:"queryPeriod,omitempty"`
	// Severity - The severity for alerts created by this alert rule. Possible values include: 'AlertSeverityHigh', 'AlertSeverityMedium', 'AlertSeverityLow', 'AlertSeverityInformational'
	Severity AlertSeverity `json:"severity,omitempty"`
	// TriggerOperator - The operation against the threshold that triggers alert rule. Possible values include: 'TriggerOperatorGreaterThan', 'TriggerOperatorLessThan', 'TriggerOperatorEqual', 'TriggerOperatorNotEqual'
	TriggerOperator TriggerOperator `json:"triggerOperator,omitempty"`
	// TriggerThreshold - The threshold triggers this alert rule.
	TriggerThreshold *int32 `json:"triggerThreshold,omitempty"`
}

// ScheduledAlertRuleProperties scheduled alert rule base property bag.
type ScheduledAlertRuleProperties struct {
	// AlertRuleTemplateName - The Name of the alert rule template used to create this rule.
	AlertRuleTemplateName *string `json:"alertRuleTemplateName,omitempty"`
	// Description - The description of the alert rule.
	Description *string `json:"description,omitempty"`
	// DisplayName - The display name for alerts created by this alert rule.
	DisplayName *string `json:"displayName,omitempty"`
	// Enabled - Determines whether this alert rule is enabled or disabled.
	Enabled *bool `json:"enabled,omitempty"`
	// LastModifiedUtc - READ-ONLY; The last time that this alert rule has been modified.
	LastModifiedUtc *date.Time `json:"lastModifiedUtc,omitempty"`
	// SuppressionDuration - The suppression (in ISO 8601 duration format) to wait since last time this alert rule been triggered.
	SuppressionDuration *string `json:"suppressionDuration,omitempty"`
	// SuppressionEnabled - Determines whether the suppression for this alert rule is enabled or disabled.
	SuppressionEnabled *bool `json:"suppressionEnabled,omitempty"`
	// Tactics - The tactics of the alert rule
	Tactics *[]AttackTactic `json:"tactics,omitempty"`
	// Query - The query that creates alerts for this rule.
	Query *string `json:"query,omitempty"`
	// QueryFrequency - The frequency (in ISO 8601 duration format) for this alert rule to run.
	QueryFrequency *string `json:"queryFrequency,omitempty"`
	// QueryPeriod - The period (in ISO 8601 duration format) that this alert rule looks at.
	QueryPeriod *string `json:"queryPeriod,omitempty"`
	// Severity - The severity for alerts created by this alert rule. Possible values include: 'AlertSeverityHigh', 'AlertSeverityMedium', 'AlertSeverityLow', 'AlertSeverityInformational'
	Severity AlertSeverity `json:"severity,omitempty"`
	// TriggerOperator - The operation against the threshold that triggers alert rule. Possible values include: 'TriggerOperatorGreaterThan', 'TriggerOperatorLessThan', 'TriggerOperatorEqual', 'TriggerOperatorNotEqual'
	TriggerOperator TriggerOperator `json:"triggerOperator,omitempty"`
	// TriggerThreshold - The threshold triggers this alert rule.
	TriggerThreshold *int32 `json:"triggerThreshold,omitempty"`
}

// MarshalJSON is the custom marshaler for ScheduledAlertRuleProperties.
func (sarp ScheduledAlertRuleProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sarp.AlertRuleTemplateName != nil {
		objectMap["alertRuleTemplateName"] = sarp.AlertRuleTemplateName
	}
	if sarp.Description != nil {
		objectMap["description"] = sarp.Description
	}
	if sarp.DisplayName != nil {
		objectMap["displayName"] = sarp.DisplayName
	}
	if sarp.Enabled != nil {
		objectMap["enabled"] = sarp.Enabled
	}
	if sarp.SuppressionDuration != nil {
		objectMap["suppressionDuration"] = sarp.SuppressionDuration
	}
	if sarp.SuppressionEnabled != nil {
		objectMap["suppressionEnabled"] = sarp.SuppressionEnabled
	}
	if sarp.Tactics != nil {
		objectMap["tactics"] = sarp.Tactics
	}
	if sarp.Query != nil {
		objectMap["query"] = sarp.Query
	}
	if sarp.QueryFrequency != nil {
		objectMap["queryFrequency"] = sarp.QueryFrequency
	}
	if sarp.QueryPeriod != nil {
		objectMap["queryPeriod"] = sarp.QueryPeriod
	}
	if sarp.Severity != "" {
		objectMap["severity"] = sarp.Severity
	}
	if sarp.TriggerOperator != "" {
		objectMap["triggerOperator"] = sarp.TriggerOperator
	}
	if sarp.TriggerThreshold != nil {
		objectMap["triggerThreshold"] = sarp.TriggerThreshold
	}
	return json.Marshal(objectMap)
}

// ScheduledAlertRuleTemplate represents scheduled alert rule template.
type ScheduledAlertRuleTemplate struct {
	// ScheduledAlertRuleTemplateProperties - Scheduled alert rule template properties
	*ScheduledAlertRuleTemplateProperties `json:"properties,omitempty"`
	// Kind - Possible values include: 'KindBasicAlertRuleTemplateKindAlertRuleTemplate', 'KindBasicAlertRuleTemplateKindFusion', 'KindBasicAlertRuleTemplateKindMicrosoftSecurityIncidentCreation', 'KindBasicAlertRuleTemplateKindScheduled'
	Kind KindBasicAlertRuleTemplate `json:"kind,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ScheduledAlertRuleTemplate.
func (sart ScheduledAlertRuleTemplate) MarshalJSON() ([]byte, error) {
	sart.Kind = KindBasicAlertRuleTemplateKindScheduled
	objectMap := make(map[string]interface{})
	if sart.ScheduledAlertRuleTemplateProperties != nil {
		objectMap["properties"] = sart.ScheduledAlertRuleTemplateProperties
	}
	if sart.Kind != "" {
		objectMap["kind"] = sart.Kind
	}
	return json.Marshal(objectMap)
}

// AsFusionAlertRuleTemplate is the BasicAlertRuleTemplate implementation for ScheduledAlertRuleTemplate.
func (sart ScheduledAlertRuleTemplate) AsFusionAlertRuleTemplate() (*FusionAlertRuleTemplate, bool) {
	return nil, false
}

// AsMicrosoftSecurityIncidentCreationAlertRuleTemplate is the BasicAlertRuleTemplate implementation for ScheduledAlertRuleTemplate.
func (sart ScheduledAlertRuleTemplate) AsMicrosoftSecurityIncidentCreationAlertRuleTemplate() (*MicrosoftSecurityIncidentCreationAlertRuleTemplate, bool) {
	return nil, false
}

// AsScheduledAlertRuleTemplate is the BasicAlertRuleTemplate implementation for ScheduledAlertRuleTemplate.
func (sart ScheduledAlertRuleTemplate) AsScheduledAlertRuleTemplate() (*ScheduledAlertRuleTemplate, bool) {
	return &sart, true
}

// AsAlertRuleTemplate is the BasicAlertRuleTemplate implementation for ScheduledAlertRuleTemplate.
func (sart ScheduledAlertRuleTemplate) AsAlertRuleTemplate() (*AlertRuleTemplate, bool) {
	return nil, false
}

// AsBasicAlertRuleTemplate is the BasicAlertRuleTemplate implementation for ScheduledAlertRuleTemplate.
func (sart ScheduledAlertRuleTemplate) AsBasicAlertRuleTemplate() (BasicAlertRuleTemplate, bool) {
	return &sart, true
}

// UnmarshalJSON is the custom unmarshaler for ScheduledAlertRuleTemplate struct.
func (sart *ScheduledAlertRuleTemplate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var scheduledAlertRuleTemplateProperties ScheduledAlertRuleTemplateProperties
				err = json.Unmarshal(*v, &scheduledAlertRuleTemplateProperties)
				if err != nil {
					return err
				}
				sart.ScheduledAlertRuleTemplateProperties = &scheduledAlertRuleTemplateProperties
			}
		case "kind":
			if v != nil {
				var kind KindBasicAlertRuleTemplate
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				sart.Kind = kind
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sart.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sart.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sart.Type = &typeVar
			}
		}
	}

	return nil
}

// ScheduledAlertRuleTemplateProperties scheduled alert rule template properties
type ScheduledAlertRuleTemplateProperties struct {
	// AlertRulesCreatedByTemplateCount - the number of alert rules that were created by this template
	AlertRulesCreatedByTemplateCount *int32 `json:"alertRulesCreatedByTemplateCount,omitempty"`
	// CreatedDateUTC - READ-ONLY; The time that this alert rule template has been added.
	CreatedDateUTC *date.Time `json:"createdDateUTC,omitempty"`
	// Description - The description of the alert rule template.
	Description *string `json:"description,omitempty"`
	// DisplayName - The display name for alert rule template.
	DisplayName *string `json:"displayName,omitempty"`
	// RequiredDataConnectors - The required data connectors for this template
	RequiredDataConnectors *[]AlertRuleTemplateDataSource `json:"requiredDataConnectors,omitempty"`
	// Status - The alert rule template status. Possible values include: 'TemplateStatusInstalled', 'TemplateStatusAvailable', 'TemplateStatusNotAvailable'
	Status TemplateStatus `json:"status,omitempty"`
	// Query - The query that creates alerts for this rule.
	Query *string `json:"query,omitempty"`
	// QueryFrequency - The frequency (in ISO 8601 duration format) for this alert rule to run.
	QueryFrequency *string `json:"queryFrequency,omitempty"`
	// QueryPeriod - The period (in ISO 8601 duration format) that this alert rule looks at.
	QueryPeriod *string `json:"queryPeriod,omitempty"`
	// Severity - The severity for alerts created by this alert rule. Possible values include: 'AlertSeverityHigh', 'AlertSeverityMedium', 'AlertSeverityLow', 'AlertSeverityInformational'
	Severity AlertSeverity `json:"severity,omitempty"`
	// TriggerOperator - The operation against the threshold that triggers alert rule. Possible values include: 'TriggerOperatorGreaterThan', 'TriggerOperatorLessThan', 'TriggerOperatorEqual', 'TriggerOperatorNotEqual'
	TriggerOperator TriggerOperator `json:"triggerOperator,omitempty"`
	// TriggerThreshold - The threshold triggers this alert rule.
	TriggerThreshold *int32 `json:"triggerThreshold,omitempty"`
	// Tactics - The tactics of the alert rule template
	Tactics *[]AttackTactic `json:"tactics,omitempty"`
}

// MarshalJSON is the custom marshaler for ScheduledAlertRuleTemplateProperties.
func (sartp ScheduledAlertRuleTemplateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sartp.AlertRulesCreatedByTemplateCount != nil {
		objectMap["alertRulesCreatedByTemplateCount"] = sartp.AlertRulesCreatedByTemplateCount
	}
	if sartp.Description != nil {
		objectMap["description"] = sartp.Description
	}
	if sartp.DisplayName != nil {
		objectMap["displayName"] = sartp.DisplayName
	}
	if sartp.RequiredDataConnectors != nil {
		objectMap["requiredDataConnectors"] = sartp.RequiredDataConnectors
	}
	if sartp.Status != "" {
		objectMap["status"] = sartp.Status
	}
	if sartp.Query != nil {
		objectMap["query"] = sartp.Query
	}
	if sartp.QueryFrequency != nil {
		objectMap["queryFrequency"] = sartp.QueryFrequency
	}
	if sartp.QueryPeriod != nil {
		objectMap["queryPeriod"] = sartp.QueryPeriod
	}
	if sartp.Severity != "" {
		objectMap["severity"] = sartp.Severity
	}
	if sartp.TriggerOperator != "" {
		objectMap["triggerOperator"] = sartp.TriggerOperator
	}
	if sartp.TriggerThreshold != nil {
		objectMap["triggerThreshold"] = sartp.TriggerThreshold
	}
	if sartp.Tactics != nil {
		objectMap["tactics"] = sartp.Tactics
	}
	return json.Marshal(objectMap)
}

// BasicSettings the Settings.
type BasicSettings interface {
	AsToggleSettings() (*ToggleSettings, bool)
	AsUebaSettings() (*UebaSettings, bool)
	AsSettings() (*Settings, bool)
}

// Settings the Settings.
type Settings struct {
	// Kind - Possible values include: 'KindBasicSettingsKindSettings', 'KindBasicSettingsKindToggleSettings', 'KindBasicSettingsKindUebaSettings'
	Kind KindBasicSettings `json:"kind,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Etag - Etag of the azure resource
	Etag *string `json:"etag,omitempty"`
}

func unmarshalBasicSettings(body []byte) (BasicSettings, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["kind"] {
	case string(KindBasicSettingsKindToggleSettings):
		var ts ToggleSettings
		err := json.Unmarshal(body, &ts)
		return ts, err
	case string(KindBasicSettingsKindUebaSettings):
		var us UebaSettings
		err := json.Unmarshal(body, &us)
		return us, err
	default:
		var s Settings
		err := json.Unmarshal(body, &s)
		return s, err
	}
}
func unmarshalBasicSettingsArray(body []byte) ([]BasicSettings, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	sArray := make([]BasicSettings, len(rawMessages))

	for index, rawMessage := range rawMessages {
		s, err := unmarshalBasicSettings(*rawMessage)
		if err != nil {
			return nil, err
		}
		sArray[index] = s
	}
	return sArray, nil
}

// MarshalJSON is the custom marshaler for Settings.
func (s Settings) MarshalJSON() ([]byte, error) {
	s.Kind = KindBasicSettingsKindSettings
	objectMap := make(map[string]interface{})
	if s.Kind != "" {
		objectMap["kind"] = s.Kind
	}
	if s.Etag != nil {
		objectMap["etag"] = s.Etag
	}
	return json.Marshal(objectMap)
}

// AsToggleSettings is the BasicSettings implementation for Settings.
func (s Settings) AsToggleSettings() (*ToggleSettings, bool) {
	return nil, false
}

// AsUebaSettings is the BasicSettings implementation for Settings.
func (s Settings) AsUebaSettings() (*UebaSettings, bool) {
	return nil, false
}

// AsSettings is the BasicSettings implementation for Settings.
func (s Settings) AsSettings() (*Settings, bool) {
	return &s, true
}

// AsBasicSettings is the BasicSettings implementation for Settings.
func (s Settings) AsBasicSettings() (BasicSettings, bool) {
	return &s, true
}

// ThreatIntelligence threatIntelligence property bag.
type ThreatIntelligence struct {
	// Confidence - READ-ONLY; Confidence (must be between 0 and 1)
	Confidence *float64 `json:"confidence,omitempty"`
	// ProviderName - READ-ONLY; Name of the provider from whom this Threat Intelligence information was received
	ProviderName *string `json:"providerName,omitempty"`
	// ReportLink - READ-ONLY; Report link
	ReportLink *string `json:"reportLink,omitempty"`
	// ThreatDescription - READ-ONLY; Threat description (free text)
	ThreatDescription *string `json:"threatDescription,omitempty"`
	// ThreatName - READ-ONLY; Threat name (e.g. "Jedobot malware")
	ThreatName *string `json:"threatName,omitempty"`
	// ThreatType - READ-ONLY; Threat type (e.g. "Botnet")
	ThreatType *string `json:"threatType,omitempty"`
}

// TIDataConnector represents threat intelligence data connector.
type TIDataConnector struct {
	// TIDataConnectorProperties - TI (Threat Intelligence) data connector properties.
	*TIDataConnectorProperties `json:"properties,omitempty"`
	// Kind - Possible values include: 'KindBasicDataConnectorKindDataConnector', 'KindBasicDataConnectorKindAzureActiveDirectory', 'KindBasicDataConnectorKindAzureAdvancedThreatProtection', 'KindBasicDataConnectorKindAzureSecurityCenter', 'KindBasicDataConnectorKindAmazonWebServicesCloudTrail', 'KindBasicDataConnectorKindMicrosoftCloudAppSecurity', 'KindBasicDataConnectorKindMicrosoftDefenderAdvancedThreatProtection', 'KindBasicDataConnectorKindOffice365', 'KindBasicDataConnectorKindThreatIntelligence'
	Kind KindBasicDataConnector `json:"kind,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Etag - Etag of the azure resource
	Etag *string `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for TIDataConnector.
func (tdc TIDataConnector) MarshalJSON() ([]byte, error) {
	tdc.Kind = KindBasicDataConnectorKindThreatIntelligence
	objectMap := make(map[string]interface{})
	if tdc.TIDataConnectorProperties != nil {
		objectMap["properties"] = tdc.TIDataConnectorProperties
	}
	if tdc.Kind != "" {
		objectMap["kind"] = tdc.Kind
	}
	if tdc.Etag != nil {
		objectMap["etag"] = tdc.Etag
	}
	return json.Marshal(objectMap)
}

// AsAADDataConnector is the BasicDataConnector implementation for TIDataConnector.
func (tdc TIDataConnector) AsAADDataConnector() (*AADDataConnector, bool) {
	return nil, false
}

// AsAATPDataConnector is the BasicDataConnector implementation for TIDataConnector.
func (tdc TIDataConnector) AsAATPDataConnector() (*AATPDataConnector, bool) {
	return nil, false
}

// AsASCDataConnector is the BasicDataConnector implementation for TIDataConnector.
func (tdc TIDataConnector) AsASCDataConnector() (*ASCDataConnector, bool) {
	return nil, false
}

// AsAwsCloudTrailDataConnector is the BasicDataConnector implementation for TIDataConnector.
func (tdc TIDataConnector) AsAwsCloudTrailDataConnector() (*AwsCloudTrailDataConnector, bool) {
	return nil, false
}

// AsMCASDataConnector is the BasicDataConnector implementation for TIDataConnector.
func (tdc TIDataConnector) AsMCASDataConnector() (*MCASDataConnector, bool) {
	return nil, false
}

// AsMDATPDataConnector is the BasicDataConnector implementation for TIDataConnector.
func (tdc TIDataConnector) AsMDATPDataConnector() (*MDATPDataConnector, bool) {
	return nil, false
}

// AsOfficeDataConnector is the BasicDataConnector implementation for TIDataConnector.
func (tdc TIDataConnector) AsOfficeDataConnector() (*OfficeDataConnector, bool) {
	return nil, false
}

// AsTIDataConnector is the BasicDataConnector implementation for TIDataConnector.
func (tdc TIDataConnector) AsTIDataConnector() (*TIDataConnector, bool) {
	return &tdc, true
}

// AsDataConnector is the BasicDataConnector implementation for TIDataConnector.
func (tdc TIDataConnector) AsDataConnector() (*DataConnector, bool) {
	return nil, false
}

// AsBasicDataConnector is the BasicDataConnector implementation for TIDataConnector.
func (tdc TIDataConnector) AsBasicDataConnector() (BasicDataConnector, bool) {
	return &tdc, true
}

// UnmarshalJSON is the custom unmarshaler for TIDataConnector struct.
func (tdc *TIDataConnector) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var tIDataConnectorProperties TIDataConnectorProperties
				err = json.Unmarshal(*v, &tIDataConnectorProperties)
				if err != nil {
					return err
				}
				tdc.TIDataConnectorProperties = &tIDataConnectorProperties
			}
		case "kind":
			if v != nil {
				var kind KindBasicDataConnector
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				tdc.Kind = kind
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				tdc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				tdc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				tdc.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				tdc.Etag = &etag
			}
		}
	}

	return nil
}

// TIDataConnectorDataTypes the available data types for TI (Threat Intelligence) data connector.
type TIDataConnectorDataTypes struct {
	// Indicators - Data type for indicators connection.
	Indicators *TIDataConnectorDataTypesIndicators `json:"indicators,omitempty"`
}

// TIDataConnectorDataTypesIndicators data type for indicators connection.
type TIDataConnectorDataTypesIndicators struct {
	// State - Describe whether this data type connection is enabled or not. Possible values include: 'DataTypeStateEnabled', 'DataTypeStateDisabled'
	State DataTypeState `json:"state,omitempty"`
}

// TIDataConnectorProperties TI (Threat Intelligence) data connector properties.
type TIDataConnectorProperties struct {
	// TenantID - The tenant id to connect to, and get the data from.
	TenantID *string `json:"tenantId,omitempty"`
	// TipLookbackPeriod - The lookback period for the feed to be imported.
	TipLookbackPeriod *date.Time `json:"tipLookbackPeriod,omitempty"`
	// DataTypes - The available data types for the connector.
	DataTypes *TIDataConnectorDataTypes `json:"dataTypes,omitempty"`
}

// ToggleSettings settings with single toggle.
type ToggleSettings struct {
	// ToggleSettingsProperties - toggle properties
	*ToggleSettingsProperties `json:"properties,omitempty"`
	// Kind - Possible values include: 'KindBasicSettingsKindSettings', 'KindBasicSettingsKindToggleSettings', 'KindBasicSettingsKindUebaSettings'
	Kind KindBasicSettings `json:"kind,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Etag - Etag of the azure resource
	Etag *string `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for ToggleSettings.
func (ts ToggleSettings) MarshalJSON() ([]byte, error) {
	ts.Kind = KindBasicSettingsKindToggleSettings
	objectMap := make(map[string]interface{})
	if ts.ToggleSettingsProperties != nil {
		objectMap["properties"] = ts.ToggleSettingsProperties
	}
	if ts.Kind != "" {
		objectMap["kind"] = ts.Kind
	}
	if ts.Etag != nil {
		objectMap["etag"] = ts.Etag
	}
	return json.Marshal(objectMap)
}

// AsToggleSettings is the BasicSettings implementation for ToggleSettings.
func (ts ToggleSettings) AsToggleSettings() (*ToggleSettings, bool) {
	return &ts, true
}

// AsUebaSettings is the BasicSettings implementation for ToggleSettings.
func (ts ToggleSettings) AsUebaSettings() (*UebaSettings, bool) {
	return nil, false
}

// AsSettings is the BasicSettings implementation for ToggleSettings.
func (ts ToggleSettings) AsSettings() (*Settings, bool) {
	return nil, false
}

// AsBasicSettings is the BasicSettings implementation for ToggleSettings.
func (ts ToggleSettings) AsBasicSettings() (BasicSettings, bool) {
	return &ts, true
}

// UnmarshalJSON is the custom unmarshaler for ToggleSettings struct.
func (ts *ToggleSettings) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var toggleSettingsProperties ToggleSettingsProperties
				err = json.Unmarshal(*v, &toggleSettingsProperties)
				if err != nil {
					return err
				}
				ts.ToggleSettingsProperties = &toggleSettingsProperties
			}
		case "kind":
			if v != nil {
				var kind KindBasicSettings
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ts.Kind = kind
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ts.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ts.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ts.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				ts.Etag = &etag
			}
		}
	}

	return nil
}

// ToggleSettingsProperties toggle property bag.
type ToggleSettingsProperties struct {
	// IsEnabled - Determines whether the setting is enable or disabled.
	IsEnabled *bool `json:"isEnabled,omitempty"`
}

// UebaSettings represents settings for User and Entity Behavior Analytics enablement.
type UebaSettings struct {
	// UebaSettingsProperties - User and Entity Behavior Analytics settings properties
	*UebaSettingsProperties `json:"properties,omitempty"`
	// Kind - Possible values include: 'KindBasicSettingsKindSettings', 'KindBasicSettingsKindToggleSettings', 'KindBasicSettingsKindUebaSettings'
	Kind KindBasicSettings `json:"kind,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Etag - Etag of the azure resource
	Etag *string `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for UebaSettings.
func (us UebaSettings) MarshalJSON() ([]byte, error) {
	us.Kind = KindBasicSettingsKindUebaSettings
	objectMap := make(map[string]interface{})
	if us.UebaSettingsProperties != nil {
		objectMap["properties"] = us.UebaSettingsProperties
	}
	if us.Kind != "" {
		objectMap["kind"] = us.Kind
	}
	if us.Etag != nil {
		objectMap["etag"] = us.Etag
	}
	return json.Marshal(objectMap)
}

// AsToggleSettings is the BasicSettings implementation for UebaSettings.
func (us UebaSettings) AsToggleSettings() (*ToggleSettings, bool) {
	return nil, false
}

// AsUebaSettings is the BasicSettings implementation for UebaSettings.
func (us UebaSettings) AsUebaSettings() (*UebaSettings, bool) {
	return &us, true
}

// AsSettings is the BasicSettings implementation for UebaSettings.
func (us UebaSettings) AsSettings() (*Settings, bool) {
	return nil, false
}

// AsBasicSettings is the BasicSettings implementation for UebaSettings.
func (us UebaSettings) AsBasicSettings() (BasicSettings, bool) {
	return &us, true
}

// UnmarshalJSON is the custom unmarshaler for UebaSettings struct.
func (us *UebaSettings) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var uebaSettingsProperties UebaSettingsProperties
				err = json.Unmarshal(*v, &uebaSettingsProperties)
				if err != nil {
					return err
				}
				us.UebaSettingsProperties = &uebaSettingsProperties
			}
		case "kind":
			if v != nil {
				var kind KindBasicSettings
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				us.Kind = kind
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				us.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				us.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				us.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				us.Etag = &etag
			}
		}
	}

	return nil
}

// UebaSettingsProperties user and Entity Behavior Analytics settings property bag.
type UebaSettingsProperties struct {
	// AtpLicenseStatus - READ-ONLY; Determines whether the tenant has ATP (Advanced Threat Protection) license. Possible values include: 'LicenseStatusEnabled', 'LicenseStatusDisabled'
	AtpLicenseStatus LicenseStatus `json:"atpLicenseStatus,omitempty"`
	// IsEnabled - Determines whether User and Entity Behavior Analytics is enabled for this workspace.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// StatusInMcas - READ-ONLY; Determines whether User and Entity Behavior Analytics is enabled from MCAS (Microsoft Cloud App Security). Possible values include: 'StatusInMcasEnabled', 'StatusInMcasDisabled'
	StatusInMcas StatusInMcas `json:"statusInMcas,omitempty"`
}

// MarshalJSON is the custom marshaler for UebaSettingsProperties.
func (usp UebaSettingsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if usp.IsEnabled != nil {
		objectMap["isEnabled"] = usp.IsEnabled
	}
	return json.Marshal(objectMap)
}

// UserInfo user information that made some action
type UserInfo struct {
	// Email - READ-ONLY; The email of the user.
	Email *string `json:"email,omitempty"`
	// Name - READ-ONLY; The name of the user.
	Name *string `json:"name,omitempty"`
	// ObjectID - The object id of the user.
	ObjectID *uuid.UUID `json:"objectId,omitempty"`
}

// MarshalJSON is the custom marshaler for UserInfo.
func (UI UserInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if UI.ObjectID != nil {
		objectMap["objectId"] = UI.ObjectID
	}
	return json.Marshal(objectMap)
}
