package securityinsight

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// AlertRuleKind enumerates the values for alert rule kind.
type AlertRuleKind string

const (
	// AlertRuleKindFusion ...
	AlertRuleKindFusion AlertRuleKind = "Fusion"
	// AlertRuleKindMicrosoftSecurityIncidentCreation ...
	AlertRuleKindMicrosoftSecurityIncidentCreation AlertRuleKind = "MicrosoftSecurityIncidentCreation"
	// AlertRuleKindScheduled ...
	AlertRuleKindScheduled AlertRuleKind = "Scheduled"
)

// PossibleAlertRuleKindValues returns an array of possible values for the AlertRuleKind const type.
func PossibleAlertRuleKindValues() []AlertRuleKind {
	return []AlertRuleKind{AlertRuleKindFusion, AlertRuleKindMicrosoftSecurityIncidentCreation, AlertRuleKindScheduled}
}

// AlertSeverity enumerates the values for alert severity.
type AlertSeverity string

const (
	// AlertSeverityHigh High severity
	AlertSeverityHigh AlertSeverity = "High"
	// AlertSeverityInformational Informational severity
	AlertSeverityInformational AlertSeverity = "Informational"
	// AlertSeverityLow Low severity
	AlertSeverityLow AlertSeverity = "Low"
	// AlertSeverityMedium Medium severity
	AlertSeverityMedium AlertSeverity = "Medium"
)

// PossibleAlertSeverityValues returns an array of possible values for the AlertSeverity const type.
func PossibleAlertSeverityValues() []AlertSeverity {
	return []AlertSeverity{AlertSeverityHigh, AlertSeverityInformational, AlertSeverityLow, AlertSeverityMedium}
}

// AttackTactic enumerates the values for attack tactic.
type AttackTactic string

const (
	// AttackTacticCollection ...
	AttackTacticCollection AttackTactic = "Collection"
	// AttackTacticCommandAndControl ...
	AttackTacticCommandAndControl AttackTactic = "CommandAndControl"
	// AttackTacticCredentialAccess ...
	AttackTacticCredentialAccess AttackTactic = "CredentialAccess"
	// AttackTacticDefenseEvasion ...
	AttackTacticDefenseEvasion AttackTactic = "DefenseEvasion"
	// AttackTacticDiscovery ...
	AttackTacticDiscovery AttackTactic = "Discovery"
	// AttackTacticExecution ...
	AttackTacticExecution AttackTactic = "Execution"
	// AttackTacticExfiltration ...
	AttackTacticExfiltration AttackTactic = "Exfiltration"
	// AttackTacticImpact ...
	AttackTacticImpact AttackTactic = "Impact"
	// AttackTacticInitialAccess ...
	AttackTacticInitialAccess AttackTactic = "InitialAccess"
	// AttackTacticLateralMovement ...
	AttackTacticLateralMovement AttackTactic = "LateralMovement"
	// AttackTacticPersistence ...
	AttackTacticPersistence AttackTactic = "Persistence"
	// AttackTacticPrivilegeEscalation ...
	AttackTacticPrivilegeEscalation AttackTactic = "PrivilegeEscalation"
)

// PossibleAttackTacticValues returns an array of possible values for the AttackTactic const type.
func PossibleAttackTacticValues() []AttackTactic {
	return []AttackTactic{AttackTacticCollection, AttackTacticCommandAndControl, AttackTacticCredentialAccess, AttackTacticDefenseEvasion, AttackTacticDiscovery, AttackTacticExecution, AttackTacticExfiltration, AttackTacticImpact, AttackTacticInitialAccess, AttackTacticLateralMovement, AttackTacticPersistence, AttackTacticPrivilegeEscalation}
}

// CaseSeverity enumerates the values for case severity.
type CaseSeverity string

const (
	// CaseSeverityCritical Critical severity
	CaseSeverityCritical CaseSeverity = "Critical"
	// CaseSeverityHigh High severity
	CaseSeverityHigh CaseSeverity = "High"
	// CaseSeverityInformational Informational severity
	CaseSeverityInformational CaseSeverity = "Informational"
	// CaseSeverityLow Low severity
	CaseSeverityLow CaseSeverity = "Low"
	// CaseSeverityMedium Medium severity
	CaseSeverityMedium CaseSeverity = "Medium"
)

// PossibleCaseSeverityValues returns an array of possible values for the CaseSeverity const type.
func PossibleCaseSeverityValues() []CaseSeverity {
	return []CaseSeverity{CaseSeverityCritical, CaseSeverityHigh, CaseSeverityInformational, CaseSeverityLow, CaseSeverityMedium}
}

// DataConnectorKind enumerates the values for data connector kind.
type DataConnectorKind string

const (
	// DataConnectorKindAmazonWebServicesCloudTrail ...
	DataConnectorKindAmazonWebServicesCloudTrail DataConnectorKind = "AmazonWebServicesCloudTrail"
	// DataConnectorKindAzureActiveDirectory ...
	DataConnectorKindAzureActiveDirectory DataConnectorKind = "AzureActiveDirectory"
	// DataConnectorKindAzureAdvancedThreatProtection ...
	DataConnectorKindAzureAdvancedThreatProtection DataConnectorKind = "AzureAdvancedThreatProtection"
	// DataConnectorKindAzureSecurityCenter ...
	DataConnectorKindAzureSecurityCenter DataConnectorKind = "AzureSecurityCenter"
	// DataConnectorKindMicrosoftCloudAppSecurity ...
	DataConnectorKindMicrosoftCloudAppSecurity DataConnectorKind = "MicrosoftCloudAppSecurity"
	// DataConnectorKindMicrosoftDefenderAdvancedThreatProtection ...
	DataConnectorKindMicrosoftDefenderAdvancedThreatProtection DataConnectorKind = "MicrosoftDefenderAdvancedThreatProtection"
	// DataConnectorKindOffice365 ...
	DataConnectorKindOffice365 DataConnectorKind = "Office365"
	// DataConnectorKindThreatIntelligence ...
	DataConnectorKindThreatIntelligence DataConnectorKind = "ThreatIntelligence"
)

// PossibleDataConnectorKindValues returns an array of possible values for the DataConnectorKind const type.
func PossibleDataConnectorKindValues() []DataConnectorKind {
	return []DataConnectorKind{DataConnectorKindAmazonWebServicesCloudTrail, DataConnectorKindAzureActiveDirectory, DataConnectorKindAzureAdvancedThreatProtection, DataConnectorKindAzureSecurityCenter, DataConnectorKindMicrosoftCloudAppSecurity, DataConnectorKindMicrosoftDefenderAdvancedThreatProtection, DataConnectorKindOffice365, DataConnectorKindThreatIntelligence}
}

// DataTypeState enumerates the values for data type state.
type DataTypeState string

const (
	// DataTypeStateDisabled ...
	DataTypeStateDisabled DataTypeState = "Disabled"
	// DataTypeStateEnabled ...
	DataTypeStateEnabled DataTypeState = "Enabled"
)

// PossibleDataTypeStateValues returns an array of possible values for the DataTypeState const type.
func PossibleDataTypeStateValues() []DataTypeState {
	return []DataTypeState{DataTypeStateDisabled, DataTypeStateEnabled}
}

// IncidentClassification enumerates the values for incident classification.
type IncidentClassification string

const (
	// IncidentClassificationBenignPositive Incident was benign positive
	IncidentClassificationBenignPositive IncidentClassification = "BenignPositive"
	// IncidentClassificationFalsePositive Incident was false positive
	IncidentClassificationFalsePositive IncidentClassification = "FalsePositive"
	// IncidentClassificationTruePositive Incident was true positive
	IncidentClassificationTruePositive IncidentClassification = "TruePositive"
	// IncidentClassificationUndetermined Incident classification was undetermined
	IncidentClassificationUndetermined IncidentClassification = "Undetermined"
)

// PossibleIncidentClassificationValues returns an array of possible values for the IncidentClassification const type.
func PossibleIncidentClassificationValues() []IncidentClassification {
	return []IncidentClassification{IncidentClassificationBenignPositive, IncidentClassificationFalsePositive, IncidentClassificationTruePositive, IncidentClassificationUndetermined}
}

// IncidentClassificationReason enumerates the values for incident classification reason.
type IncidentClassificationReason string

const (
	// IncidentClassificationReasonInaccurateData Classification reason was inaccurate data
	IncidentClassificationReasonInaccurateData IncidentClassificationReason = "InaccurateData"
	// IncidentClassificationReasonIncorrectAlertLogic Classification reason was incorrect alert logic
	IncidentClassificationReasonIncorrectAlertLogic IncidentClassificationReason = "IncorrectAlertLogic"
	// IncidentClassificationReasonSuspiciousActivity Classification reason was suspicious activity
	IncidentClassificationReasonSuspiciousActivity IncidentClassificationReason = "SuspiciousActivity"
	// IncidentClassificationReasonSuspiciousButExpected Classification reason was suspicious but expected
	IncidentClassificationReasonSuspiciousButExpected IncidentClassificationReason = "SuspiciousButExpected"
)

// PossibleIncidentClassificationReasonValues returns an array of possible values for the IncidentClassificationReason const type.
func PossibleIncidentClassificationReasonValues() []IncidentClassificationReason {
	return []IncidentClassificationReason{IncidentClassificationReasonInaccurateData, IncidentClassificationReasonIncorrectAlertLogic, IncidentClassificationReasonSuspiciousActivity, IncidentClassificationReasonSuspiciousButExpected}
}

// IncidentLabelType enumerates the values for incident label type.
type IncidentLabelType string

const (
	// IncidentLabelTypeSystem Label automatically created by the system
	IncidentLabelTypeSystem IncidentLabelType = "System"
	// IncidentLabelTypeUser Label manually created by a user
	IncidentLabelTypeUser IncidentLabelType = "User"
)

// PossibleIncidentLabelTypeValues returns an array of possible values for the IncidentLabelType const type.
func PossibleIncidentLabelTypeValues() []IncidentLabelType {
	return []IncidentLabelType{IncidentLabelTypeSystem, IncidentLabelTypeUser}
}

// IncidentSeverity enumerates the values for incident severity.
type IncidentSeverity string

const (
	// IncidentSeverityHigh High severity
	IncidentSeverityHigh IncidentSeverity = "High"
	// IncidentSeverityInformational Informational severity
	IncidentSeverityInformational IncidentSeverity = "Informational"
	// IncidentSeverityLow Low severity
	IncidentSeverityLow IncidentSeverity = "Low"
	// IncidentSeverityMedium Medium severity
	IncidentSeverityMedium IncidentSeverity = "Medium"
)

// PossibleIncidentSeverityValues returns an array of possible values for the IncidentSeverity const type.
func PossibleIncidentSeverityValues() []IncidentSeverity {
	return []IncidentSeverity{IncidentSeverityHigh, IncidentSeverityInformational, IncidentSeverityLow, IncidentSeverityMedium}
}

// IncidentStatus enumerates the values for incident status.
type IncidentStatus string

const (
	// IncidentStatusActive An active incident which is being handled
	IncidentStatusActive IncidentStatus = "Active"
	// IncidentStatusClosed A non-active incident
	IncidentStatusClosed IncidentStatus = "Closed"
	// IncidentStatusNew An active incident which isn't being handled currently
	IncidentStatusNew IncidentStatus = "New"
)

// PossibleIncidentStatusValues returns an array of possible values for the IncidentStatus const type.
func PossibleIncidentStatusValues() []IncidentStatus {
	return []IncidentStatus{IncidentStatusActive, IncidentStatusClosed, IncidentStatusNew}
}

// Kind enumerates the values for kind.
type Kind string

const (
	// KindKindAlertRule ...
	KindKindAlertRule Kind = "AlertRule"
	// KindKindFusion ...
	KindKindFusion Kind = "Fusion"
	// KindKindMicrosoftSecurityIncidentCreation ...
	KindKindMicrosoftSecurityIncidentCreation Kind = "MicrosoftSecurityIncidentCreation"
	// KindKindScheduled ...
	KindKindScheduled Kind = "Scheduled"
)

// PossibleKindValues returns an array of possible values for the Kind const type.
func PossibleKindValues() []Kind {
	return []Kind{KindKindAlertRule, KindKindFusion, KindKindMicrosoftSecurityIncidentCreation, KindKindScheduled}
}

// KindBasicAlertRuleTemplate enumerates the values for kind basic alert rule template.
type KindBasicAlertRuleTemplate string

const (
	// KindBasicAlertRuleTemplateKindAlertRuleTemplate ...
	KindBasicAlertRuleTemplateKindAlertRuleTemplate KindBasicAlertRuleTemplate = "AlertRuleTemplate"
	// KindBasicAlertRuleTemplateKindFusion ...
	KindBasicAlertRuleTemplateKindFusion KindBasicAlertRuleTemplate = "Fusion"
	// KindBasicAlertRuleTemplateKindMicrosoftSecurityIncidentCreation ...
	KindBasicAlertRuleTemplateKindMicrosoftSecurityIncidentCreation KindBasicAlertRuleTemplate = "MicrosoftSecurityIncidentCreation"
	// KindBasicAlertRuleTemplateKindScheduled ...
	KindBasicAlertRuleTemplateKindScheduled KindBasicAlertRuleTemplate = "Scheduled"
)

// PossibleKindBasicAlertRuleTemplateValues returns an array of possible values for the KindBasicAlertRuleTemplate const type.
func PossibleKindBasicAlertRuleTemplateValues() []KindBasicAlertRuleTemplate {
	return []KindBasicAlertRuleTemplate{KindBasicAlertRuleTemplateKindAlertRuleTemplate, KindBasicAlertRuleTemplateKindFusion, KindBasicAlertRuleTemplateKindMicrosoftSecurityIncidentCreation, KindBasicAlertRuleTemplateKindScheduled}
}

// KindBasicDataConnector enumerates the values for kind basic data connector.
type KindBasicDataConnector string

const (
	// KindBasicDataConnectorKindAmazonWebServicesCloudTrail ...
	KindBasicDataConnectorKindAmazonWebServicesCloudTrail KindBasicDataConnector = "AmazonWebServicesCloudTrail"
	// KindBasicDataConnectorKindAzureActiveDirectory ...
	KindBasicDataConnectorKindAzureActiveDirectory KindBasicDataConnector = "AzureActiveDirectory"
	// KindBasicDataConnectorKindAzureAdvancedThreatProtection ...
	KindBasicDataConnectorKindAzureAdvancedThreatProtection KindBasicDataConnector = "AzureAdvancedThreatProtection"
	// KindBasicDataConnectorKindAzureSecurityCenter ...
	KindBasicDataConnectorKindAzureSecurityCenter KindBasicDataConnector = "AzureSecurityCenter"
	// KindBasicDataConnectorKindDataConnector ...
	KindBasicDataConnectorKindDataConnector KindBasicDataConnector = "DataConnector"
	// KindBasicDataConnectorKindMicrosoftCloudAppSecurity ...
	KindBasicDataConnectorKindMicrosoftCloudAppSecurity KindBasicDataConnector = "MicrosoftCloudAppSecurity"
	// KindBasicDataConnectorKindMicrosoftDefenderAdvancedThreatProtection ...
	KindBasicDataConnectorKindMicrosoftDefenderAdvancedThreatProtection KindBasicDataConnector = "MicrosoftDefenderAdvancedThreatProtection"
	// KindBasicDataConnectorKindOffice365 ...
	KindBasicDataConnectorKindOffice365 KindBasicDataConnector = "Office365"
	// KindBasicDataConnectorKindThreatIntelligence ...
	KindBasicDataConnectorKindThreatIntelligence KindBasicDataConnector = "ThreatIntelligence"
)

// PossibleKindBasicDataConnectorValues returns an array of possible values for the KindBasicDataConnector const type.
func PossibleKindBasicDataConnectorValues() []KindBasicDataConnector {
	return []KindBasicDataConnector{KindBasicDataConnectorKindAmazonWebServicesCloudTrail, KindBasicDataConnectorKindAzureActiveDirectory, KindBasicDataConnectorKindAzureAdvancedThreatProtection, KindBasicDataConnectorKindAzureSecurityCenter, KindBasicDataConnectorKindDataConnector, KindBasicDataConnectorKindMicrosoftCloudAppSecurity, KindBasicDataConnectorKindMicrosoftDefenderAdvancedThreatProtection, KindBasicDataConnectorKindOffice365, KindBasicDataConnectorKindThreatIntelligence}
}

// KindBasicSettings enumerates the values for kind basic settings.
type KindBasicSettings string

const (
	// KindBasicSettingsKindSettings ...
	KindBasicSettingsKindSettings KindBasicSettings = "Settings"
	// KindBasicSettingsKindToggleSettings ...
	KindBasicSettingsKindToggleSettings KindBasicSettings = "ToggleSettings"
	// KindBasicSettingsKindUebaSettings ...
	KindBasicSettingsKindUebaSettings KindBasicSettings = "UebaSettings"
)

// PossibleKindBasicSettingsValues returns an array of possible values for the KindBasicSettings const type.
func PossibleKindBasicSettingsValues() []KindBasicSettings {
	return []KindBasicSettings{KindBasicSettingsKindSettings, KindBasicSettingsKindToggleSettings, KindBasicSettingsKindUebaSettings}
}

// LicenseStatus enumerates the values for license status.
type LicenseStatus string

const (
	// LicenseStatusDisabled ...
	LicenseStatusDisabled LicenseStatus = "Disabled"
	// LicenseStatusEnabled ...
	LicenseStatusEnabled LicenseStatus = "Enabled"
)

// PossibleLicenseStatusValues returns an array of possible values for the LicenseStatus const type.
func PossibleLicenseStatusValues() []LicenseStatus {
	return []LicenseStatus{LicenseStatusDisabled, LicenseStatusEnabled}
}

// MicrosoftSecurityProductName enumerates the values for microsoft security product name.
type MicrosoftSecurityProductName string

const (
	// MicrosoftSecurityProductNameAzureActiveDirectoryIdentityProtection ...
	MicrosoftSecurityProductNameAzureActiveDirectoryIdentityProtection MicrosoftSecurityProductName = "Azure Active Directory Identity Protection"
	// MicrosoftSecurityProductNameAzureAdvancedThreatProtection ...
	MicrosoftSecurityProductNameAzureAdvancedThreatProtection MicrosoftSecurityProductName = "Azure Advanced Threat Protection"
	// MicrosoftSecurityProductNameAzureSecurityCenter ...
	MicrosoftSecurityProductNameAzureSecurityCenter MicrosoftSecurityProductName = "Azure Security Center"
	// MicrosoftSecurityProductNameAzureSecurityCenterforIoT ...
	MicrosoftSecurityProductNameAzureSecurityCenterforIoT MicrosoftSecurityProductName = "Azure Security Center for IoT"
	// MicrosoftSecurityProductNameMicrosoftCloudAppSecurity ...
	MicrosoftSecurityProductNameMicrosoftCloudAppSecurity MicrosoftSecurityProductName = "Microsoft Cloud App Security"
)

// PossibleMicrosoftSecurityProductNameValues returns an array of possible values for the MicrosoftSecurityProductName const type.
func PossibleMicrosoftSecurityProductNameValues() []MicrosoftSecurityProductName {
	return []MicrosoftSecurityProductName{MicrosoftSecurityProductNameAzureActiveDirectoryIdentityProtection, MicrosoftSecurityProductNameAzureAdvancedThreatProtection, MicrosoftSecurityProductNameAzureSecurityCenter, MicrosoftSecurityProductNameAzureSecurityCenterforIoT, MicrosoftSecurityProductNameMicrosoftCloudAppSecurity}
}

// SettingKind enumerates the values for setting kind.
type SettingKind string

const (
	// SettingKindToggleSettings ...
	SettingKindToggleSettings SettingKind = "ToggleSettings"
	// SettingKindUebaSettings ...
	SettingKindUebaSettings SettingKind = "UebaSettings"
)

// PossibleSettingKindValues returns an array of possible values for the SettingKind const type.
func PossibleSettingKindValues() []SettingKind {
	return []SettingKind{SettingKindToggleSettings, SettingKindUebaSettings}
}

// StatusInMcas enumerates the values for status in mcas.
type StatusInMcas string

const (
	// StatusInMcasDisabled ...
	StatusInMcasDisabled StatusInMcas = "Disabled"
	// StatusInMcasEnabled ...
	StatusInMcasEnabled StatusInMcas = "Enabled"
)

// PossibleStatusInMcasValues returns an array of possible values for the StatusInMcas const type.
func PossibleStatusInMcasValues() []StatusInMcas {
	return []StatusInMcas{StatusInMcasDisabled, StatusInMcasEnabled}
}

// TemplateStatus enumerates the values for template status.
type TemplateStatus string

const (
	// TemplateStatusAvailable Alert rule template is available.
	TemplateStatusAvailable TemplateStatus = "Available"
	// TemplateStatusInstalled Alert rule template installed. and can not use more then once
	TemplateStatusInstalled TemplateStatus = "Installed"
	// TemplateStatusNotAvailable Alert rule template is not available
	TemplateStatusNotAvailable TemplateStatus = "NotAvailable"
)

// PossibleTemplateStatusValues returns an array of possible values for the TemplateStatus const type.
func PossibleTemplateStatusValues() []TemplateStatus {
	return []TemplateStatus{TemplateStatusAvailable, TemplateStatusInstalled, TemplateStatusNotAvailable}
}

// TriggerOperator enumerates the values for trigger operator.
type TriggerOperator string

const (
	// TriggerOperatorEqual ...
	TriggerOperatorEqual TriggerOperator = "Equal"
	// TriggerOperatorGreaterThan ...
	TriggerOperatorGreaterThan TriggerOperator = "GreaterThan"
	// TriggerOperatorLessThan ...
	TriggerOperatorLessThan TriggerOperator = "LessThan"
	// TriggerOperatorNotEqual ...
	TriggerOperatorNotEqual TriggerOperator = "NotEqual"
)

// PossibleTriggerOperatorValues returns an array of possible values for the TriggerOperator const type.
func PossibleTriggerOperatorValues() []TriggerOperator {
	return []TriggerOperator{TriggerOperatorEqual, TriggerOperatorGreaterThan, TriggerOperatorLessThan, TriggerOperatorNotEqual}
}
