/*
Copyright 2020 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by counterfeiter. DO NOT EDIT.
package releasefakes

import (
	"sync"
)

type FakeTestGridClient struct {
	BlockingTestsStub        func(string) ([]string, error)
	blockingTestsMutex       sync.RWMutex
	blockingTestsArgsForCall []struct {
		arg1 string
	}
	blockingTestsReturns struct {
		result1 []string
		result2 error
	}
	blockingTestsReturnsOnCall map[int]struct {
		result1 []string
		result2 error
	}
	invocations      map[string][][]interface{}
	invocationsMutex sync.RWMutex
}

func (fake *FakeTestGridClient) BlockingTests(arg1 string) ([]string, error) {
	fake.blockingTestsMutex.Lock()
	ret, specificReturn := fake.blockingTestsReturnsOnCall[len(fake.blockingTestsArgsForCall)]
	fake.blockingTestsArgsForCall = append(fake.blockingTestsArgsForCall, struct {
		arg1 string
	}{arg1})
	fake.recordInvocation("BlockingTests", []interface{}{arg1})
	fake.blockingTestsMutex.Unlock()
	if fake.BlockingTestsStub != nil {
		return fake.BlockingTestsStub(arg1)
	}
	if specificReturn {
		return ret.result1, ret.result2
	}
	fakeReturns := fake.blockingTestsReturns
	return fakeReturns.result1, fakeReturns.result2
}

func (fake *FakeTestGridClient) BlockingTestsCallCount() int {
	fake.blockingTestsMutex.RLock()
	defer fake.blockingTestsMutex.RUnlock()
	return len(fake.blockingTestsArgsForCall)
}

func (fake *FakeTestGridClient) BlockingTestsCalls(stub func(string) ([]string, error)) {
	fake.blockingTestsMutex.Lock()
	defer fake.blockingTestsMutex.Unlock()
	fake.BlockingTestsStub = stub
}

func (fake *FakeTestGridClient) BlockingTestsArgsForCall(i int) string {
	fake.blockingTestsMutex.RLock()
	defer fake.blockingTestsMutex.RUnlock()
	argsForCall := fake.blockingTestsArgsForCall[i]
	return argsForCall.arg1
}

func (fake *FakeTestGridClient) BlockingTestsReturns(result1 []string, result2 error) {
	fake.blockingTestsMutex.Lock()
	defer fake.blockingTestsMutex.Unlock()
	fake.BlockingTestsStub = nil
	fake.blockingTestsReturns = struct {
		result1 []string
		result2 error
	}{result1, result2}
}

func (fake *FakeTestGridClient) BlockingTestsReturnsOnCall(i int, result1 []string, result2 error) {
	fake.blockingTestsMutex.Lock()
	defer fake.blockingTestsMutex.Unlock()
	fake.BlockingTestsStub = nil
	if fake.blockingTestsReturnsOnCall == nil {
		fake.blockingTestsReturnsOnCall = make(map[int]struct {
			result1 []string
			result2 error
		})
	}
	fake.blockingTestsReturnsOnCall[i] = struct {
		result1 []string
		result2 error
	}{result1, result2}
}

func (fake *FakeTestGridClient) Invocations() map[string][][]interface{} {
	fake.invocationsMutex.RLock()
	defer fake.invocationsMutex.RUnlock()
	fake.blockingTestsMutex.RLock()
	defer fake.blockingTestsMutex.RUnlock()
	copiedInvocations := map[string][][]interface{}{}
	for key, value := range fake.invocations {
		copiedInvocations[key] = value
	}
	return copiedInvocations
}

func (fake *FakeTestGridClient) recordInvocation(key string, args []interface{}) {
	fake.invocationsMutex.Lock()
	defer fake.invocationsMutex.Unlock()
	if fake.invocations == nil {
		fake.invocations = map[string][][]interface{}{}
	}
	if fake.invocations[key] == nil {
		fake.invocations[key] = [][]interface{}{}
	}
	fake.invocations[key] = append(fake.invocations[key], args)
}
