# Copyright 2019 The Bazel Authors. All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

DEFAULT_VERSION = "1.14"

MIN_SUPPORTED_VERSION = "1.11"

SDK_REPOSITORIES = {
    "1.14": {
        "darwin_amd64": ("go1.14.darwin-amd64.tar.gz", "2472dcd681b761501fadb35ec361503efd27de2ba2270b2fe35cb6ece7362243"),
        "freebsd_386": ("go1.14.freebsd-386.tar.gz", "9717901860aab759ff1e555b0e62d58669939f7b2a86fc45d4015db29c92614d"),
        "freebsd_amd64": ("go1.14.freebsd-amd64.tar.gz", "d86041687515ac3729807cdaa6787a1a10ee4cfdefd427043dcdb20544096fa1"),
        "linux_386": ("go1.14.linux-386.tar.gz", "cdcdab6c8d1f2dcea3bbec793352ef84db167a2eb6c60ff69e5cf94dca575f9a"),
        "linux_amd64": ("go1.14.linux-amd64.tar.gz", "08df79b46b0adf498ea9f320a0f23d6ec59e9003660b4c9c1ce8e5e2c6f823ca"),
        "linux_arm64": ("go1.14.linux-arm64.tar.gz", "cd813387f770c07819912f8ff4b9796a4e317dee92548b7226a19e60ac79eb27"),
        "linux_arm": ("go1.14.linux-armv6l.tar.gz", "b5e682176d7ad3944404619a39b585453a740a2f82683e789f4279ec285b7ecd"),
        "linux_ppc64le": ("go1.14.linux-ppc64le.tar.gz", "b896b5eba616d27fd3bb8218de6bef557cb62221e42f73c84ae4b89cdb602dec"),
        "linux_s390x": ("go1.14.linux-s390x.tar.gz", "22e67470fe872c893face196f02323a11ffe89999260c136b9c50f06619e0243"),
        "windows_386": ("go1.14.windows-386.zip", "adb634bedc4143b67c50b2e60f36a2cbcad6ab05ec41a972e2115701584170a2"),
        "windows_amd64": ("go1.14.windows-amd64.zip", "cc2f1e8d19744fe0b2e979bf9a4f9d224e416f4f54cb6cf3aa8b5e9c0865de37"),
    },
    "1.13.8": {
        "darwin_amd64": ("go1.13.8.darwin-amd64.tar.gz", "e7bad54950e1d18c716ac9202b5406e7d4aca9aa4ca9e334a9742f75c2167a9c"),
        "freebsd_386": ("go1.13.8.freebsd-386.tar.gz", "5e02b9d3a3b5d7c61d43eea80b27875a9350472ffcb80c08fad857076d670d8b"),
        "freebsd_amd64": ("go1.13.8.freebsd-amd64.tar.gz", "d8ea8fa5f93ba66f1f011fe40706635a95d754704da68ec7c406ba52ed4ec93a"),
        "linux_386": ("go1.13.8.linux-386.tar.gz", "2305c1c46b3eaf574c7b03cfa6b167c199a2b52da85872317438c90074fdb46e"),
        "linux_amd64": ("go1.13.8.linux-amd64.tar.gz", "0567734d558aef19112f2b2873caa0c600f1b4a5827930eb5a7f35235219e9d8"),
        "linux_arm64": ("go1.13.8.linux-arm64.tar.gz", "b46c0235054d0eb69a295a2634aec8a11c7ae19b3dc53556a626b89dc1f8cdb0"),
        "linux_arm": ("go1.13.8.linux-armv6l.tar.gz", "75f590d8e048a97cbf8b09837b15b3e6b44e1374718a96a5c3a994843ef44a4d"),
        "linux_ppc64le": ("go1.13.8.linux-ppc64le.tar.gz", "4c987b3969d33a93880a218064d2330d7f55c9b58698e78db6b56012058e91a9"),
        "linux_s390x": ("go1.13.8.linux-s390x.tar.gz", "994f961df0d7bdbfa6f7eed604539acf9159444dabdff3ce8e938d095d85f756"),
        "windows_386": ("go1.13.8.windows-386.zip", "00c765048392c78fd3681ea5279c408e21fc94f033a504a1158fc6279fb068e3"),
        "windows_amd64": ("go1.13.8.windows-amd64.zip", "aaf0888907144ca7070c8dad03fcf1308f77a42d2f6e4d2a609e64e9ae73cf4f"),
    },
    "1.13.7": {
        "darwin_amd64": ("go1.13.7.darwin-amd64.tar.gz", "8436f846b49c2b14a96d90eef6b2a6e0a0e1943bbb767299c1ecabb795b042b9"),
        "freebsd_386": ("go1.13.7.freebsd-386.tar.gz", "b205d3657ca050b0c69d1fe4a76a2f66aa879f5ef87cc2814241610906e19924"),
        "freebsd_amd64": ("go1.13.7.freebsd-amd64.tar.gz", "6952d9746ba04ea86341690dc93763f6b68319f7bec2b11d7028e1cffa408bdb"),
        "linux_386": ("go1.13.7.linux-386.tar.gz", "93e82683f32d9fe7fda9b686415aeee599a92c4e450b69519bb53e1d62144a85"),
        "linux_amd64": ("go1.13.7.linux-amd64.tar.gz", "b3dd4bd781a0271b33168e627f7f43886b4c5d1c794a4015abf34e99c6526ca3"),
        "linux_arm64": ("go1.13.7.linux-arm64.tar.gz", "8717de6c662ada01b7bf318f5025c046b57f8c10cd39a88268bdc171cc7e4eab"),
        "linux_arm": ("go1.13.7.linux-armv6l.tar.gz", "ff8b870222d82c38a0108810706811dcbd1fcdbddc877789184a0f903cbdf11a"),
        "linux_ppc64le": ("go1.13.7.linux-ppc64le.tar.gz", "8fe0aeb41e87fd901845c9598f17f1aae90dca25d2d2744e9664c173fbf7f784"),
        "linux_s390x": ("go1.13.7.linux-s390x.tar.gz", "7d405e515029d19131bae2820310681c31b665178998335ecc4494e8de01dfeb"),
        "windows_386": ("go1.13.7.windows-386.zip", "cf9b1a2f96240adb98dc4081121ac308bf6f8d2760f96d45f429ec571602cefc"),
        "windows_amd64": ("go1.13.7.windows-amd64.zip", "03befd335ee9ddf1d10cae52e84eb5a37408b8e105acc1c29e30bbbbd8143749"),
    },
    "1.13.6": {
        "darwin_amd64": ("go1.13.6.darwin-amd64.tar.gz", "1ee0dc6a7abf389dac898cbe27e28c4388a61e45cba2632c01d749e25003007f"),
        "freebsd_386": ("go1.13.6.freebsd-386.tar.gz", "e02727feb4680cd643f9b8f5e953196675d0b9d4129dba1d5fbd98db01c24643"),
        "freebsd_amd64": ("go1.13.6.freebsd-amd64.tar.gz", "c8153d236558aa878b7bc844ebede38f09ac846bee037f0f57a8dd75e36d8056"),
        "linux_386": ("go1.13.6.linux-386.tar.gz", "27feb013106da784f09e560720aa41ab395c67f7eed4c4a0fce04bc6e3d01c7d"),
        "linux_amd64": ("go1.13.6.linux-amd64.tar.gz", "a1bc06deb070155c4f67c579f896a45eeda5a8fa54f35ba233304074c4abbbbd"),
        "linux_arm64": ("go1.13.6.linux-arm64.tar.gz", "0a18125c4ed80f9c3045cf92384670907c4796b43ed63c4307210fe93e5bbca5"),
        "linux_arm": ("go1.13.6.linux-armv6l.tar.gz", "37a1a83e363dcf146a67fa839d170fd1afb13009585fdd493d0a3370fbe6f785"),
        "linux_ppc64le": ("go1.13.6.linux-ppc64le.tar.gz", "26a977a8af5dc50a562f0a57b58dded5fa3bacfe77722cf8a84ea54ca54728dd"),
        "linux_s390x": ("go1.13.6.linux-s390x.tar.gz", "5cd9900a1fa0f0cac657930b648381cad9b8c5e2bbc77caf86a6fb5cedad0017"),
        "windows_386": ("go1.13.6.windows-386.zip", "6b1595d3b5b5fbdbaf6031502d90a694d1e7ae297433fc01c6c48fe8bc987495"),
        "windows_amd64": ("go1.13.6.windows-amd64.zip", "66eae07e03310b67d279701028ba8dc6948cd0acdc6fbe21c22bfa9a2bc48884"),
    },
    "1.13.5": {
        "darwin_amd64": ("go1.13.5.darwin-amd64.tar.gz", "97f9ec90d54f3a580789f1f855b17282e7dbccb69a44b20a20c2167e907db800"),
        "freebsd_386": ("go1.13.5.freebsd-386.tar.gz", "005b45ed277374d50acef5daa889139ed4e8fdd34c7e5c6e134d846cbe12c7f2"),
        "freebsd_amd64": ("go1.13.5.freebsd-amd64.tar.gz", "9da24f876f321c1485d46f597546d72c3d38a5d8eade45724fdc40cc19fc042a"),
        "linux_386": ("go1.13.5.linux-386.tar.gz", "3b830fa25f79ab08b476f02c84ea4125f41296b074017b492ac1ff748cf1c7c9"),
        "linux_amd64": ("go1.13.5.linux-amd64.tar.gz", "512103d7ad296467814a6e3f635631bd35574cab3369a97a323c9a585ccaa569"),
        "linux_arm64": ("go1.13.5.linux-arm64.tar.gz", "227b718923e20c846460bbecddde9cb86bad73acc5fb6f8e1a96b81b5c84668b"),
        "linux_arm": ("go1.13.5.linux-armv6l.tar.gz", "26259f61d52ee2297b1e8feef3a0fc82144b666a2b95512402c31cc49713c133"),
        "linux_ppc64le": ("go1.13.5.linux-ppc64le.tar.gz", "292814a5ea42a6fc43e1d1ea61c01334e53959e7ab34de86eb5f6efa9742afb6"),
        "linux_s390x": ("go1.13.5.linux-s390x.tar.gz", "cfbb2959f243880abd1e2efd85d798b8d7ae4a502ab87c4b722c1bd3541e5dc3"),
        "windows_386": ("go1.13.5.windows-386.zip", "5a9ace58c0fb487a07a3dec494a59957aa8425fbefd04d1a3fb1d0aa0d95fb8d"),
        "windows_amd64": ("go1.13.5.windows-amd64.zip", "027275e04d795fbadc898ba7a50ed0ab2161ff4c5e613c94dbb066b2ca24ec11"),
    },
    "1.13.4": {
        "darwin_amd64": ("go1.13.4.darwin-amd64.tar.gz", "a9088c44a984c4ba64179619606cc65d9d0cb92988012cfc94fbb29ca09edac7"),
        "freebsd_386": ("go1.13.4.freebsd-386.tar.gz", "ecb75927a71e232ef849c4f75388e2132c04bc429b0e2501d7bac5598fbd34f2"),
        "freebsd_amd64": ("go1.13.4.freebsd-amd64.tar.gz", "2eeb50a31c61a8ce468ab7c350e6b6c43d8e9572c796742c8b3da8422c46e470"),
        "linux_386": ("go1.13.4.linux-386.tar.gz", "497934398ca57c7c207ce3388f099823923b4c7b74394d6ed64cd2d3751aecb8"),
        "linux_amd64": ("go1.13.4.linux-amd64.tar.gz", "692d17071736f74be04a72a06dab9cac1cd759377bd85316e52b2227604c004c"),
        "linux_arm64": ("go1.13.4.linux-arm64.tar.gz", "8b8d99eb07206f082468fb4d0ec962a819ae45d54065fc1ed6e2c502e774aaf0"),
        "linux_arm": ("go1.13.4.linux-armv6l.tar.gz", "9f76e6353c9ae2dcad1731b7239531eb8be2fe171f29f2a9c5040945a930fd41"),
        "linux_ppc64le": ("go1.13.4.linux-ppc64le.tar.gz", "815bf3c7100e73cfac50c4a07c8eeb4b0458a49ffa0e13a74a6cf7ad8e2a6499"),
        "linux_s390x": ("go1.13.4.linux-s390x.tar.gz", "efc6947e8eb0a6409f4c8ba62b00ae4e54404064bc221df1b73364a95945a350"),
        "windows_386": ("go1.13.4.windows-386.zip", "a6956184e31b5c97ee76ed736f1c5b708ace7f5673511862f9fcb8ab64851286"),
        "windows_amd64": ("go1.13.4.windows-amd64.zip", "ab8b7f7a2a4f7b58720fb2128b32c7471092961ff46a01d9384fb489d8212a0b"),
    },
    "1.13.3": {
        "darwin_amd64": ("go1.13.3.darwin-amd64.tar.gz", "dde04dec8730d72e4d350a4e1b123a3f94aa15e7f34ed8163e72c948916c48ae"),
        "freebsd_386": ("go1.13.3.freebsd-386.tar.gz", "1a79e9013a4421b5e99c0bed81b97460a012d22513a0efedc6107add43e579e7"),
        "freebsd_amd64": ("go1.13.3.freebsd-amd64.tar.gz", "d5337c217ae111ade704a4c3ca618921d4d7ef6d52236a137e70e691e4188c02"),
        "linux_386": ("go1.13.3.linux-386.tar.gz", "c68ebb127924ee753d05fcd4cc893e3409a6754e8884bb04e5248e9b5849f6ba"),
        "linux_amd64": ("go1.13.3.linux-amd64.tar.gz", "0804bf02020dceaa8a7d7275ee79f7a142f1996bfd0c39216ccb405f93f994c0"),
        "linux_arm64": ("go1.13.3.linux-arm64.tar.gz", "9fa65ae42665baff53802091b49b83af6f2e397986b6cbea2ae30e2c7ee0f2f2"),
        "linux_arm": ("go1.13.3.linux-armv6l.tar.gz", "9f15d6aa4098cd53ec5cb48d1a1e554d062b2263a03985d50c2568757d966dc6"),
        "linux_ppc64le": ("go1.13.3.linux-ppc64le.tar.gz", "2373b60d7f7b4825b1d0ec195079833a3dac72ddd55b207ee22b0032b1a658d9"),
        "linux_s390x": ("go1.13.3.linux-s390x.tar.gz", "9241ce5bf362b7066c90da5abc4c85ec7b4054637e1a8a01b8cc83281e228b7e"),
        "windows_386": ("go1.13.3.windows-386.zip", "b27a4266652f1a72b4023bccd1b036ba356cc6a27c18d329a8e624759626298d"),
        "windows_amd64": ("go1.13.3.windows-amd64.zip", "9585efeab37783152c81c6ce373b22e68f45c6801dc2c208bfd1e47b646efbef"),
    },
    "1.13.2": {
        "darwin_amd64": ("go1.13.2.darwin-amd64.tar.gz", "fdf29cc185ece8b038b41b469c2c6095891059b4acad94042e4a777f2f0a1116"),
        "freebsd_386": ("go1.13.2.freebsd-386.tar.gz", "687206009c7643d8657c7b15573e1a399e15fecef301184fb8684a11ae885e3e"),
        "freebsd_amd64": ("go1.13.2.freebsd-amd64.tar.gz", "71f163fdf4a2a0d82a951f07237978f852def373294daa481d487d15e0c5cb76"),
        "linux_386": ("go1.13.2.linux-386.tar.gz", "468f116889631405da0c89b1765985e8bbeddbf8642c2a552a81f0bfbe58ab55"),
        "linux_amd64": ("go1.13.2.linux-amd64.tar.gz", "293b41a6ccd735eebcfb4094b6931bfd187595555cecf3e4386e9e119220c0b7"),
        "linux_arm64": ("go1.13.2.linux-arm64.tar.gz", "a2d27f341d6b7968f9da229990aa9ab7a6d4bd1c722945be11576a09eb538482"),
        "linux_arm": ("go1.13.2.linux-armv6l.tar.gz", "6f2e90b5d08a177be14938a905f7b91e9b17052318b5ea0e6d7c0a83af252421"),
        "linux_ppc64le": ("go1.13.2.linux-ppc64le.tar.gz", "ffcc3651fce34fc6418e33836d5417c0e6b713fda99033259e67538fa802900a"),
        "linux_s390x": ("go1.13.2.linux-s390x.tar.gz", "dbed59db3e4f57df7c86120be37bdbf3516891214174b771cff40d81ba8577e2"),
        "windows_386": ("go1.13.2.windows-386.zip", "c0c5ac83e354b76f78532ed83590151648dfd52d58dd832ecaee9ea0daa07c42"),
        "windows_amd64": ("go1.13.2.windows-amd64.zip", "003c99e778d6f73ba677fec4b66c3bdbbb144b318cfe6ffbe26ed8493b2db9a5"),
    },
    "1.13.1": {
        "darwin_amd64": ("go1.13.1.darwin-amd64.tar.gz", "f3985fced3adecb62dd1e636cfa5eb9fea8f3e98101d9fcc4964d8f1ec255b7f"),
        "freebsd_386": ("go1.13.1.freebsd-386.tar.gz", "3d3a97cc1c778326df13a9a5460bce14094402edbcfb9f529f507344cfea0bc4"),
        "freebsd_amd64": ("go1.13.1.freebsd-amd64.tar.gz", "1ae71f3a02c95cd559f5943aced2f337fb8b58b95db47001ebca48992c7df1d3"),
        "linux_386": ("go1.13.1.linux-386.tar.gz", "4bf7a961fda7ad892b8824002036de8c0f290df05df2e8f11252d1f8c77dcd8f"),
        "linux_amd64": ("go1.13.1.linux-amd64.tar.gz", "94f874037b82ea5353f4061e543681a0e79657f787437974214629af8407d124"),
        "linux_arm64": ("go1.13.1.linux-arm64.tar.gz", "8af8787b7c2a3c0eb3f20f872577fcb6c36098bf725c59c4923921443084c807"),
        "linux_arm": ("go1.13.1.linux-armv6l.tar.gz", "7c75d4002321ea4a066dfe13f6dd5168076e9a231317c5afd55e78b86f478e37"),
        "linux_ppc64le": ("go1.13.1.linux-ppc64le.tar.gz", "72422c68dbed013ee321a05dbb97d9c8d6b2c75f347de707138c2c748fc4aceb"),
        "linux_s390x": ("go1.13.1.linux-s390x.tar.gz", "5f0859ae1037ad7af6cdb6d16f638de908fd9de044d463eeab92b9578d4c7c75"),
        "windows_386": ("go1.13.1.windows-386.zip", "bc0010efa39d5d46e2d7c7bbb702ca37796d95b395003e22080414076556c590"),
        "windows_amd64": ("go1.13.1.windows-amd64.zip", "24cb08d369c1962cccacedc56fd79dc130f623b3b667a316554621ad6ac9b442"),
    },
    "1.13": {
        "darwin_amd64": ("go1.13.darwin-amd64.tar.gz", "234ebbba1fbed8474340f79059cfb3af2a0f8b531c4ff0785346e0710e4003dd"),
        "freebsd_386": ("go1.13.freebsd-386.tar.gz", "4035d0a07c1cfa0e75f56414757ac7c609a801c78cc6df9d1d41927426c325a7"),
        "freebsd_amd64": ("go1.13.freebsd-amd64.tar.gz", "a8391447ea6c77b67163f7dd9fd3708fd9ba396ae128fd77dac4f8c249c8c223"),
        "linux_386": ("go1.13.linux-386.tar.gz", "519b3e6ae4db011b93b60e6fabb055773ae6448355b6909a6befef87e02d98f5"),
        "linux_amd64": ("go1.13.linux-amd64.tar.gz", "68a2297eb099d1a76097905a2ce334e3155004ec08cdea85f24527be3c48e856"),
        "linux_arm64": ("go1.13.linux-arm64.tar.gz", "e2a61328101eff3b9c1ba47ecfec5eb2fdc3eb35d8c27d505737ba98bfcb197b"),
        "linux_arm": ("go1.13.linux-armv6l.tar.gz", "931906d67cae1222f501e7be26e0ee73ba89420be0c4591925901cb9a4e156f0"),
        "linux_ppc64le": ("go1.13.linux-ppc64le.tar.gz", "807b036bb058061b6090635e2a8612aaf301895dce70a773bbcd67fa1e57337c"),
        "linux_s390x": ("go1.13.linux-s390x.tar.gz", "b7122795910b70b68e4118d0d34685a30925f4dd861c065cf20b699a7783807a"),
        "windows_386": ("go1.13.windows-386.zip", "c9ad29eff640bf8cb551853c649fd63acd777fcb28db26712d07983a973cb327"),
        "windows_amd64": ("go1.13.windows-amd64.zip", "7d162b83157d3171961f8e05a55b7da8476244df3fac28a5da1c9e215acfea89"),
    },
    "1.12.17": {
        "darwin_amd64": ("go1.12.17.darwin-amd64.tar.gz", "a2f58b4bf10f3e882c1a43eba27a2aba65fc815384fbdfc46331c13bca5f5f24"),
        "freebsd_386": ("go1.12.17.freebsd-386.tar.gz", "d097d90391154c238669881ddfffc1090e7760f70f89f2dc104e2a87118be6c7"),
        "freebsd_amd64": ("go1.12.17.freebsd-amd64.tar.gz", "de4adf8157dc68149e9db895b2de827b356346842d12d47d0bbc1c79756ff347"),
        "linux_386": ("go1.12.17.linux-386.tar.gz", "e33fc10c0486b02a019f120996d77792d8f19aae8bfdda97350a622a65d6b824"),
        "linux_amd64": ("go1.12.17.linux-amd64.tar.gz", "a53dd476129d496047487bfd53d021dd17e0c96895865a0e7d0469ce3db8c8d2"),
        "linux_arm64": ("go1.12.17.linux-arm64.tar.gz", "9d0819cce1451abdb090071880fe8771f16a3bcee71d6f6906023d17799574e2"),
        "linux_arm": ("go1.12.17.linux-armv6l.tar.gz", "a883c806fccb3eddb26da4a1a1f8536de863aee6807ed6c99606261877af7b99"),
        "linux_ppc64le": ("go1.12.17.linux-ppc64le.tar.gz", "dca4df132da7579c352bccd9d6f4ecb8d8d61893a84b0feffcee2bb4246114a3"),
        "linux_s390x": ("go1.12.17.linux-s390x.tar.gz", "e50ffb6e0d7e7573ed9ca0f5228bdd43238a25ac34916de027036ff97322d236"),
        "windows_386": ("go1.12.17.windows-386.zip", "f24af21ee3765b7d747c65811925de5f732f70edbeaaf4f4e75d8a5019a9ed6e"),
        "windows_amd64": ("go1.12.17.windows-amd64.zip", "78ba5f19feaea1cf9327c8d3af69278a8476995d145ba57edd01ab5c1c6ecea7"),
    },
    "1.12.16": {
        "darwin_amd64": ("go1.12.16.darwin-amd64.tar.gz", "5d11cb80375f8758f90d5787b1e349604a9e38815fb1f8944322b3d4d2952180"),
        "freebsd_386": ("go1.12.16.freebsd-386.tar.gz", "fd0632920773e1779588fc95e1864e74cd3d2df47712234717b06508b330f9b7"),
        "freebsd_amd64": ("go1.12.16.freebsd-amd64.tar.gz", "3f0a65d47a51f4128556866d1a1f2b3b87674c91a7371fb2439672f9368a3f37"),
        "linux_386": ("go1.12.16.linux-386.tar.gz", "e6ebf5622203f2ceee138af16c765818bf65b74668d5e73c1da6491c3e890a88"),
        "linux_amd64": ("go1.12.16.linux-amd64.tar.gz", "bf3a85d75658144c06ce986ba05e07ef08af4320089b74b1d41de3b0f340ea7e"),
        "linux_arm64": ("go1.12.16.linux-arm64.tar.gz", "a01df310bfeffc67480982cf6ad50c9b83f9aaf4ac855d5e581b95eb727bb24c"),
        "linux_arm": ("go1.12.16.linux-armv6l.tar.gz", "2f77688eaf25d8ae58adc5164de0fc13d600705c2ebadc6e1138e5ce9ceadc41"),
        "linux_ppc64le": ("go1.12.16.linux-ppc64le.tar.gz", "7c133932d1beae68a483dbac69bb0e1023fa08196ebee100594b79c0672ce67c"),
        "linux_s390x": ("go1.12.16.linux-s390x.tar.gz", "e93326caefb3945054f9c98dd7934892b69dcb46d343cd3582c777874f5d2716"),
        "windows_386": ("go1.12.16.windows-386.zip", "a9cf5bd6f8aca26ce941ef79497aa5a3bc445df40fb31b6ae4cb722ad148db56"),
        "windows_amd64": ("go1.12.16.windows-amd64.zip", "d2a570e4872ba2260fb6369e2e9cc217e8f1541388d6f790520eeaf4447fef2f"),
    },
    "1.12.15": {
        "darwin_amd64": ("go1.12.15.darwin-amd64.tar.gz", "3a7afb588f3783545abb514d1d67ca27d33fb99ace69ff09880c2e76a0875d6e"),
        "freebsd_386": ("go1.12.15.freebsd-386.tar.gz", "25b3a2f19d76ad0d3e9e43b79783759756b50aabcf6ac9c4bb3df75bf6e0d47c"),
        "freebsd_amd64": ("go1.12.15.freebsd-amd64.tar.gz", "231a2be434fa1f7415ad8e92df3825a53910086392f43a7290da9be0439f701e"),
        "linux_386": ("go1.12.15.linux-386.tar.gz", "608c9fb90b2b35f7b4e4b110a9c6919d8902311388c6309487b5f77aed9d2b74"),
        "linux_amd64": ("go1.12.15.linux-amd64.tar.gz", "61068419f3d3fcd3cc415c352c4a93d6ae0e723ac18a22ac572b4904d78b5a4c"),
        "linux_arm64": ("go1.12.15.linux-arm64.tar.gz", "cff1a28f0b207dd54230bf822cdcfbcc7cd411261a9366616a05a1fa1fbeedd3"),
        "linux_arm": ("go1.12.15.linux-armv6l.tar.gz", "3a36d168bf80c780694bf25d6cb2ed0dbb6d4bc29b1c82bb29e819d9dbe6347b"),
        "linux_ppc64le": ("go1.12.15.linux-ppc64le.tar.gz", "4fe9ce71a6cd9acd56f0e898dd87d95ed9bc83a6a5be0863e9b5b646e05eee05"),
        "linux_s390x": ("go1.12.15.linux-s390x.tar.gz", "a02061245a738bc80c645251cddd7a22c1ea9fee0726d5caf5da7645dea3787e"),
        "windows_386": ("go1.12.15.windows-386.zip", "70723f28f73b9be4c2b835f9ac7867b5114d2d7d74ac0f863571914ab85a2a1a"),
        "windows_amd64": ("go1.12.15.windows-amd64.zip", "80e7a471bef2a05d4729b38762b4534523ac4779c7b32d48ac85eaa490c111a5"),
    },
    "1.12.14": {
        "darwin_amd64": ("go1.12.14.darwin-amd64.tar.gz", "b2ae6b0e328978df715b23f8531b484c67473074326d07985faae8a781c87c00"),
        "freebsd_386": ("go1.12.14.freebsd-386.tar.gz", "8edea443b40209344018dd14ae2f534cedf68d5775283ebca764bf01302b05fe"),
        "freebsd_amd64": ("go1.12.14.freebsd-amd64.tar.gz", "3a94a75572f9d2c1dbc1e830caef8a6ec9f2634d556c855a142c1f53f30b2575"),
        "linux_386": ("go1.12.14.linux-386.tar.gz", "76dda90b4fc0410212094b433cfdc40c9802fba972427e95cbdec3c5b94fd7a6"),
        "linux_amd64": ("go1.12.14.linux-amd64.tar.gz", "925a1a9d8b31c2425d7313fe73d3342288968a66e26cd8bf1b6b5656f4603fcb"),
        "linux_arm64": ("go1.12.14.linux-arm64.tar.gz", "1ab765f4cf74f05cfba40ddcea9160ca6cf9a57915036a559ca1691942862e7c"),
        "linux_arm": ("go1.12.14.linux-armv6l.tar.gz", "c7aa5562168b6eb3a4bb54af061d68bcb6b9ecae9d785f9a38255c107c986b73"),
        "linux_ppc64le": ("go1.12.14.linux-ppc64le.tar.gz", "4e237b1357922e186337989914201e98bd9aed855f4034a5918476650484f83d"),
        "linux_s390x": ("go1.12.14.linux-s390x.tar.gz", "affd9764e5b163591ca87f351984c17d74e518e03b9d5e16f2be57bd30a82c80"),
        "windows_386": ("go1.12.14.windows-386.zip", "430f0fe3916202ef1a1573b69537af1e3866ab314528d80635c69a27b278b568"),
        "windows_amd64": ("go1.12.14.windows-amd64.zip", "80f6ca5f5edd87bae7c009340148cd9828a61dd66de5ee7862843b0840afd4f4"),
    },
    "1.12.13": {
        "darwin_amd64": ("go1.12.13.darwin-amd64.tar.gz", "6d3de6f7d7c0e8162aaa009128839fa5afcba578dcbd6ff034a82419d82480e9"),
        "freebsd_386": ("go1.12.13.freebsd-386.tar.gz", "aad712bd70b34bb8d72f9a3add12a2520f81cdd45a5763650b44361982b51133"),
        "freebsd_amd64": ("go1.12.13.freebsd-amd64.tar.gz", "0b0560747a5bf2646a339cbd899aae6d97c4057d516ede1fa3d8b509e9346725"),
        "linux_386": ("go1.12.13.linux-386.tar.gz", "fafcb585591557b7b16d9b22dec4654193d205cf444b1810ab2988f658585e23"),
        "linux_amd64": ("go1.12.13.linux-amd64.tar.gz", "da036454cb3353f9f507f0ceed4048feac611065e4e1818b434365eb32ac9bdc"),
        "linux_arm64": ("go1.12.13.linux-arm64.tar.gz", "dcfcb3785292c98f7a75c2276169dfe2d445c19f8ffe1d40b3f7b8f59712d361"),
        "linux_arm": ("go1.12.13.linux-armv6l.tar.gz", "bf061cc3d4951e07904496b5c3d6c82419309d24634835522d786673a3f5438f"),
        "linux_ppc64le": ("go1.12.13.linux-ppc64le.tar.gz", "77056264abcf5444ed0d9ab7552552ae2145ca8fb6c39d33db3c735eaf3f42d2"),
        "linux_s390x": ("go1.12.13.linux-s390x.tar.gz", "8ef1ffbe7d0e944a52aadd529fc88fd6a2303ec67ee7eeb906712ca38ada0c91"),
        "windows_386": ("go1.12.13.windows-386.zip", "b3cd68a8a1dfcb565377a32eae6ec6897a19d49282b5c6a5b4cbb628ec49a5d5"),
        "windows_amd64": ("go1.12.13.windows-amd64.zip", "c441a298e8b510d3cdabfd361885cd6762e33eaceb27cbb0eabe6757f9d1f07d"),
    },
    "1.12.12": {
        "darwin_amd64": ("go1.12.12.darwin-amd64.tar.gz", "4fb0d6f9b09177f871c8fb5cd09d5d859a5de9e81b2322fd8f847b6d9a7e1bdb"),
        "freebsd_386": ("go1.12.12.freebsd-386.tar.gz", "6b006fa12e59f2200d6ad0173f5074dce43fa503511da2fcf69528fdd9ff215b"),
        "freebsd_amd64": ("go1.12.12.freebsd-amd64.tar.gz", "709adccdd9ac3964c2dd52db5ce8de3c0f29e2d6b45b86d72ed509eaf0113e3d"),
        "linux_386": ("go1.12.12.linux-386.tar.gz", "59a48035f9b1387347e8a8a0f7c6d693e6bc84e0374ef802fb8ec61f894db073"),
        "linux_amd64": ("go1.12.12.linux-amd64.tar.gz", "4cf11ac6a8fa42d26ab85e27a5d916ee171900a87745d9f7d4a29a21587d78fc"),
        "linux_arm64": ("go1.12.12.linux-arm64.tar.gz", "a7e2fed536904f2bf7007deed3609b3484c55660821bd2faaeb6928fa62fd33e"),
        "linux_arm": ("go1.12.12.linux-armv6l.tar.gz", "ed3cda3c2d0648a712fa13cfc25e82431772231ef8f3db70de2fa9c2b893a5ab"),
        "linux_ppc64le": ("go1.12.12.linux-ppc64le.tar.gz", "adee3f914baf578bd21526479f45f99782791dcd12bfba2a7ca2d3fb79e4d623"),
        "linux_s390x": ("go1.12.12.linux-s390x.tar.gz", "24b0be352713a6e047b21093cf2aaaf22c7757d3606839ddd26da60e7f18dba6"),
        "windows_386": ("go1.12.12.windows-386.zip", "1884c77352d6b9e0fff2f01efe8ef09ea2886d95dc916e264872c8da24746457"),
        "windows_amd64": ("go1.12.12.windows-amd64.zip", "2d030b382514a3c4b76dd0786f810ce50409cebaf311a6b79addc353627263a8"),
    },
    "1.12.11": {
        "darwin_amd64": ("go1.12.11.darwin-amd64.tar.gz", "ab254d828a47b686a2625d3c4e29f3fe02d57caf297e94bc1fcf763cbbeb7f38"),
        "freebsd_386": ("go1.12.11.freebsd-386.tar.gz", "a86b47261e85d7639b46e423ee01e43bba1cf6904c9b0a089386427947493669"),
        "freebsd_amd64": ("go1.12.11.freebsd-amd64.tar.gz", "a97c00c0d135b939ade821fab8613ebe82563156fe575c837f76a1d3f9f0e6bd"),
        "linux_386": ("go1.12.11.linux-386.tar.gz", "9d979c489471c5ec9b9cd6b0922f061b2dca7b801effc39d7826a1255e8221c9"),
        "linux_amd64": ("go1.12.11.linux-amd64.tar.gz", "2c5960292da8b747d83f171a28a04116b2977e809169c344268c893e4cf0a857"),
        "linux_arm64": ("go1.12.11.linux-arm64.tar.gz", "a05361badb95f6cc5724e32f59b0f33048dfca63b539cf2bd8ab77fa4f2ba923"),
        "linux_arm": ("go1.12.11.linux-armv6l.tar.gz", "895766c9c1d1a32e9e0e7ea2f9fac6f33df0397954564c05b56ecdc58605fd1e"),
        "linux_ppc64le": ("go1.12.11.linux-ppc64le.tar.gz", "8f962f84bd36f5caad78710b32e074406d12e864e334bf6c8820836dbd1b6409"),
        "linux_s390x": ("go1.12.11.linux-s390x.tar.gz", "faa9de31cc41c0ecb79382569f1269758a7e51ca526aaf849d7189da6e28f716"),
        "windows_386": ("go1.12.11.windows-386.zip", "1d49f4178e2fc28e7da0d7640e96ca7aa013ab199a14658ec06ce62cc3057175"),
        "windows_amd64": ("go1.12.11.windows-amd64.zip", "0b0c8dbcb9efa5f32c1249fc9c59ce0eb07d7a69b50ba48f0a713d0527231f2f"),
    },
    "1.12.10": {
        "darwin_amd64": ("go1.12.10.darwin-amd64.tar.gz", "a9d98865652c471c2ffb8b9148ebfa69e0393af43a091555b326c72d8c227657"),
        "freebsd_386": ("go1.12.10.freebsd-386.tar.gz", "8ab16e116ae668db577464ce3f5084ea0889db8310652acf022947c4b628ac75"),
        "freebsd_amd64": ("go1.12.10.freebsd-amd64.tar.gz", "47e60ab46c8c24876f26c17d3f856e0d1a272f0a07971a74e26cfa3048b54a21"),
        "linux_386": ("go1.12.10.linux-386.tar.gz", "863ad8abc9a9a18a9d55e2a3a2c68046ae57ccd34c2fa0159b70d015957391d6"),
        "linux_amd64": ("go1.12.10.linux-amd64.tar.gz", "aaa84147433aed24e70b31da369bb6ca2859464a45de47c2a5023d8573412f6b"),
        "linux_arm64": ("go1.12.10.linux-arm64.tar.gz", "d45d1eebe10a33a3d850cafcefd45200091a9ddb880857135307ee0de9424d24"),
        "linux_arm": ("go1.12.10.linux-armv6l.tar.gz", "b20a897e3a078637a91e8c91ff69a27bcefea7384a0019e56fbfd21f8170fe6b"),
        "linux_ppc64le": ("go1.12.10.linux-ppc64le.tar.gz", "9c5787aeca109c6f90f0ef82328f9ec8d54cf5a4a51d23bfedfc440e92649f9d"),
        "linux_s390x": ("go1.12.10.linux-s390x.tar.gz", "a8ab50d133db183d9afa304f79c9e994c9208aec9d1bf14b04cd2bda478f406a"),
        "windows_386": ("go1.12.10.windows-386.zip", "577aebddb488d9010a4d6bbd19c2ea282ff5f05013eecda84a3fbf7fd8c9f770"),
        "windows_amd64": ("go1.12.10.windows-amd64.zip", "38ea3422a4b7e60a8959b1d6b570ecc28d8c39faefac0f79d1e7104ce3204967"),
    },
    "1.12.9": {
        "darwin_amd64": ("go1.12.9.darwin-amd64.tar.gz", "4f189102b15de0be1852d03a764acb7ac5ea2c67672a6ad3a340bd18d0e04bb4"),
        "freebsd_386": ("go1.12.9.freebsd-386.tar.gz", "d0d57f404c9741a92c8da35e8c1845461f11e8b6981892cd4f8713fef25e11fd"),
        "freebsd_amd64": ("go1.12.9.freebsd-amd64.tar.gz", "1b63491d0c7a8d074f42c40716159b92b8d7fbe351c121bc16f5367cc81fdb82"),
        "linux_386": ("go1.12.9.linux-386.tar.gz", "c40824a3e6c948b8ecad8fe9095b620c488b3d8d6694bdd48084a4798db4799a"),
        "linux_amd64": ("go1.12.9.linux-amd64.tar.gz", "ac2a6efcc1f5ec8bdc0db0a988bb1d301d64b6d61b7e8d9e42f662fbb75a2b9b"),
        "linux_arm64": ("go1.12.9.linux-arm64.tar.gz", "3606dc6ce8b4a5faad81d7365714a86b3162df041a32f44568418c9efbd7f646"),
        "linux_arm": ("go1.12.9.linux-armv6l.tar.gz", "0d9be0efa9cd296d6f8ab47de45356ba45cb82102bc5df2614f7af52e3fb5842"),
        "linux_ppc64le": ("go1.12.9.linux-ppc64le.tar.gz", "2e74c071c6a68446c9b00c1717ceeb59a826025b9202b3b0efed4f128e868b30"),
        "linux_s390x": ("go1.12.9.linux-s390x.tar.gz", "2aac6de8e83b253b8413781a2f9a0733384d859cff1b89a2ad0d13814541c336"),
        "windows_386": ("go1.12.9.windows-386.zip", "96e54c9801973a255417d9827d470fd0fae14ad8c9274577012c01f97cd534dd"),
        "windows_amd64": ("go1.12.9.windows-amd64.zip", "ec7550b32ff080b17060b9d4fde7bee94d9cf3c42e846e3a62fe4a3047ec79e3"),
    },
    "1.12.8": {
        "darwin_amd64": ("go1.12.8.darwin-amd64.tar.gz", "609c8d4913944c0836b0bb291de840dfa2cd45c733b1e50af7a18b1c00bc78f8"),
        "freebsd_386": ("go1.12.8.freebsd-386.tar.gz", "707bfd48533fd5aece36fb479f9f895edf864b7d66baacf11d3035be6356a460"),
        "freebsd_amd64": ("go1.12.8.freebsd-amd64.tar.gz", "9a1cb954a043e0f6d825acb0fb9d29d5a82cd9818a70212aa51cf6fbad58d35b"),
        "linux_386": ("go1.12.8.linux-386.tar.gz", "be164c4e04205c4fc713e81594bc2fdd4c94dff3d567ec8e0072223dd0778287"),
        "linux_amd64": ("go1.12.8.linux-amd64.tar.gz", "bd26cd4962a362ed3c11835bca32c2e131c2ae050304f2c4df9fa6ded8db85d2"),
        "linux_arm64": ("go1.12.8.linux-arm64.tar.gz", "15e9e0b5b414d1a0322896368c0050af6ab1cd82d050e93f8eceb38ef2626652"),
        "linux_arm": ("go1.12.8.linux-armv6l.tar.gz", "b6b057e7b5c740894132ce30e70503d7d36988dcd61a00f0865d1e7d6dcc74ca"),
        "linux_ppc64le": ("go1.12.8.linux-ppc64le.tar.gz", "24a65f8a702ade1854f86ddf96eda554a8abd89c8a54ddc32788769419e90232"),
        "linux_s390x": ("go1.12.8.linux-s390x.tar.gz", "db78fc8f9610cb27ac35aab55cb11698f4daa2101acdf46f0ba64e1db16323e5"),
        "windows_386": ("go1.12.8.windows-386.zip", "e07fec097549c4bba0cf5712723f459c56c812f29056707c16581684e45485f2"),
        "windows_amd64": ("go1.12.8.windows-amd64.zip", "4352ed90240ddc1b6379adf3210b849b8e89a173ca00616f2beff53df9fef3c8"),
    },
    "1.12.7": {
        "darwin_amd64": ("go1.12.7.darwin-amd64.tar.gz", "282a8b54ea8339bbe0d34b8bdc1128511d04a6bd875ac8596bc6cac708e287ef"),
        "freebsd_386": ("go1.12.7.freebsd-386.tar.gz", "588aee896fde2059b0e0941457f85ee1a0aa2cc8c7fa052bd6505f1e823551da"),
        "freebsd_amd64": ("go1.12.7.freebsd-amd64.tar.gz", "3421c0461931e088ca26bfe6a401e96fca5797fef41297d712b115563d173e41"),
        "linux_386": ("go1.12.7.linux-386.tar.gz", "ae2424b7ff557a708be12d3141f25b645966489ca49af1ad10b4fbe4c97d4c41"),
        "linux_amd64": ("go1.12.7.linux-amd64.tar.gz", "66d83bfb5a9ede000e33c6579a91a29e6b101829ad41fffb5c5bb6c900e109d9"),
        "linux_arm64": ("go1.12.7.linux-arm64.tar.gz", "4da1f7198a8fa0c4067852656b6c10153a4eca5a26aca28ef02ae9f4a7939ba5"),
        "linux_arm": ("go1.12.7.linux-armv6l.tar.gz", "48edbe936e9eb74f259bfc4b621fafca4d4ec43156b4ee7bd0d979f257dcd60a"),
        "linux_ppc64le": ("go1.12.7.linux-ppc64le.tar.gz", "8eda20600d90247efbfa70d116d80056e11192d62592240975b2a8c53caa5bf3"),
        "linux_s390x": ("go1.12.7.linux-s390x.tar.gz", "3374ac3d646555e50be790091b51849319cfcb176904048458c7f4252337fce8"),
        "windows_386": ("go1.12.7.windows-386.zip", "bf55b97f5fd9f2fd9e4f0b182e296ee531262d1f8458169f8b42d989c2370e5c"),
        "windows_amd64": ("go1.12.7.windows-amd64.zip", "502712c0e29edc6b9cda6fa5e4b6ff9b36e27d225373baead8708c9634aa8e50"),
    },
    "1.12.6": {
        "darwin_amd64": ("go1.12.6.darwin-amd64.tar.gz", "b12bbac3227e72c2964e638e85d6621996bd3c03e172e752334112c3f757ba6e"),
        "freebsd_386": ("go1.12.6.freebsd-386.tar.gz", "5dcdffc8102ff1f53596b7cf0da83d66b1f3f59180e050cb299499aa731f68ac"),
        "freebsd_amd64": ("go1.12.6.freebsd-amd64.tar.gz", "93a273bf283292142fc505bb18a3996e73009d9451c0c245b72013728da3f0af"),
        "linux_386": ("go1.12.6.linux-386.tar.gz", "7aaf25164a9ab5e1005c15535ed16ee122df50ac192c2d79b7940315c2b74f2c"),
        "linux_amd64": ("go1.12.6.linux-amd64.tar.gz", "dbcf71a3c1ea53b8d54ef1b48c85a39a6c9a935d01fc8291ff2b92028e59913c"),
        "linux_arm64": ("go1.12.6.linux-arm64.tar.gz", "8f4e3909c74b4f3f3956715f32419b28d32a4ad57dbd79f74b7a8a920b21a1a3"),
        "linux_arm": ("go1.12.6.linux-armv6l.tar.gz", "0708fbc125e7b782b44d450f3a3864859419b3691121ad401f1b9f00e488bddb"),
        "linux_ppc64le": ("go1.12.6.linux-ppc64le.tar.gz", "67eacb68c1e251c1428e588776c5a02e287a508e3d44f940d31d8ff5d57f0eef"),
        "linux_s390x": ("go1.12.6.linux-s390x.tar.gz", "c14baa10b87a38e56f28a176fae8a839e9052b0e691bdc0461677d4bcedea9aa"),
        "windows_386": ("go1.12.6.windows-386.zip", "9d5644ef8e94ad0853e1a86d5465a4600fe5b2cedc946fff80de46135eab2486"),
        "windows_amd64": ("go1.12.6.windows-amd64.zip", "9badf7bbc0ed55f2db967434b033a2cddf2e46dbdc5bb8560d8fde019e8e19d3"),
    },
    "1.12.5": {
        "darwin_amd64": ("go1.12.5.darwin-amd64.tar.gz", "566d0b407f7d4aa5a1315988b562bbe4e9422a93ce2fbf27a664cddcb9a3e617"),
        "freebsd_386": ("go1.12.5.freebsd-386.tar.gz", "b842330ad695bac9ea57d0a9d3aafaaf34921ec85702bccc2067f448e868332b"),
        "freebsd_amd64": ("go1.12.5.freebsd-amd64.tar.gz", "082acae7f5d2c780521f95fd177a08aacaccc0e38042d4ef981f7d7211a27b8a"),
        "linux_386": ("go1.12.5.linux-386.tar.gz", "146605e13bf337ff3aacd941a816c5d97a8fef8b5817e07fcec4540632085980"),
        "linux_amd64": ("go1.12.5.linux-amd64.tar.gz", "aea86e3c73495f205929cfebba0d63f1382c8ac59be081b6351681415f4063cf"),
        "linux_arm64": ("go1.12.5.linux-arm64.tar.gz", "ff09f34935cd189a4912f3f308ec83e4683c309304144eae9cf60ebc552e7cd8"),
        "linux_arm": ("go1.12.5.linux-armv6l.tar.gz", "311f5e76c7cec1ec752474a61d837e474b8e750b8e3eed267911ab57c0e5da9a"),
        "linux_ppc64le": ("go1.12.5.linux-ppc64le.tar.gz", "e88b2a2098bc79ad33912d1d27bc3282a7f3231b6f4672f306465bf46ff784ca"),
        "linux_s390x": ("go1.12.5.linux-s390x.tar.gz", "168d297ec910cb446d1aea878baeb85f1387209f9eb55dde68bddcd4c006dcbb"),
        "windows_386": ("go1.12.5.windows-386.zip", "9b8cfd668c182d39f2039bbb290cd062de438c7cc48ab3f4d9a326fce3538a03"),
        "windows_amd64": ("go1.12.5.windows-amd64.zip", "ccb694279aab39fe0e70629261f13b0307ee40d2d5e1138ed94738023ab04baa"),
    },
    "1.12.4": {
        "darwin_amd64": ("go1.12.4.darwin-amd64.tar.gz", "50af1aa6bf783358d68e125c5a72a1ba41fb83cee8f25b58ce59138896730a49"),
        "freebsd_386": ("go1.12.4.freebsd-386.tar.gz", "8695afc656e75ecf72c6a9c617b0399bf864f4aa2b4017badbf98c5f56494244"),
        "freebsd_amd64": ("go1.12.4.freebsd-amd64.tar.gz", "44f30606b1f2063bf1277f154b82910dbbe6183513aa8271391a320f45595e4b"),
        "linux_386": ("go1.12.4.linux-386.tar.gz", "eba5c51f657c1b05d5930475d1723758cd86db74499125ab48f0f9d1863845f7"),
        "linux_amd64": ("go1.12.4.linux-amd64.tar.gz", "d7d1f1f88ddfe55840712dc1747f37a790cbcaa448f6c9cf51bbe10aa65442f5"),
        "linux_arm64": ("go1.12.4.linux-arm64.tar.gz", "b7d7b4319b2d86a2ed20cef3b47aa23f0c97612b469178deecd021610f6917df"),
        "linux_arm": ("go1.12.4.linux-armv6l.tar.gz", "c43457b6d89016e9b79b92823003fd7858fb02aea22b335cfd204e0b5be71d92"),
        "linux_ppc64le": ("go1.12.4.linux-ppc64le.tar.gz", "51642f3cd6ef9af6c4a092c2929e4fb478f102fe949921bd77ecd6905952c216"),
        "linux_s390x": ("go1.12.4.linux-s390x.tar.gz", "0aab0f368c090da71f52531ebac977cc7396b692145acee557b3f9500b42467a"),
        "windows_386": ("go1.12.4.windows-386.zip", "4bc649c74c63aec9829523843669794b41e46f99bc78dd3a52f312604d36b165"),
        "windows_amd64": ("go1.12.4.windows-amd64.zip", "25b043ebacca2fa2c87bbcd7463be5f34fbd225247c101888f81647fadbdfca0"),
    },
    "1.12.3": {
        "darwin_amd64": ("go1.12.3.darwin-amd64.tar.gz", "edb7aad4607509e3eb9f8bd3b43fb9c419b4a007874a9f6e2f99c541411f9304"),
        "freebsd_386": ("go1.12.3.freebsd-386.tar.gz", "a8f01edb1d18469b49b45302560f60afdf0bc56794a20a50b87d902d0a4e3d47"),
        "freebsd_amd64": ("go1.12.3.freebsd-amd64.tar.gz", "eee2439553351ae323152529c72fe831b892821dde6e1f4145526ca6aed63349"),
        "linux_386": ("go1.12.3.linux-386.tar.gz", "67599ae0788ed88260531d4be4293cb8f5199e5c7e06d30c6bd95eb54f014be7"),
        "linux_amd64": ("go1.12.3.linux-amd64.tar.gz", "3924819eed16e55114f02d25d03e77c916ec40b7fd15c8acb5838b63135b03df"),
        "linux_arm64": ("go1.12.3.linux-arm64.tar.gz", "4deb7f3b90d03f71f5cac3654e0e1f9cb46c45b85c5475510222b958e4ea2ed6"),
        "linux_arm": ("go1.12.3.linux-armv6l.tar.gz", "efce59fac5ebc7302263ca1093fe2c3252c1b936f5b1ae08afc328eea0403c79"),
        "linux_ppc64le": ("go1.12.3.linux-ppc64le.tar.gz", "8bd04e742be8ed3f7f6fd2c78e2303be2ee70709cdc28758f101765a5e7d6dc1"),
        "linux_s390x": ("go1.12.3.linux-s390x.tar.gz", "102fe607818ba21b9853ddfa3b1225b2af802010af3a032c6487144fbb7f3521"),
        "windows_386": ("go1.12.3.windows-386.zip", "de3446df6f764030c5945800134c191f092dc14d2301f12fee6c8f611ac18829"),
        "windows_amd64": ("go1.12.3.windows-amd64.zip", "1806e089e85b84f192d782a7f70f90a32e0eccfd181405857e612f806ec04059"),
    },
    "1.12.2": {
        "darwin_amd64": ("go1.12.2.darwin-amd64.tar.gz", "82f1c27fefeefb1dc42ed34cab32c2d826e111ade3418066e7049ba8046713f9"),
        "freebsd_386": ("go1.12.2.freebsd-386.tar.gz", "8b642520509242472d48c8ab8ed7518410965c180e253691835a1faf2d8aa44f"),
        "freebsd_amd64": ("go1.12.2.freebsd-amd64.tar.gz", "de534316c754819225549ad99fd52c56fe138f87d909c8fc109bba04db1c1400"),
        "linux_386": ("go1.12.2.linux-386.tar.gz", "3005a7937ff2be7ea9badd416cc37dfe2ff589d3a311f1685de0a805e45455b6"),
        "linux_amd64": ("go1.12.2.linux-amd64.tar.gz", "f28c1fde8f293cc5c83ae8de76373cf76ae9306909564f54e0edcf140ce8fe3f"),
        "linux_arm64": ("go1.12.2.linux-arm64.tar.gz", "598558fe54bbdce8b676f81e37f514dd70b8fc1377086658ae6e836480e900eb"),
        "linux_arm": ("go1.12.2.linux-armv6l.tar.gz", "38d92116cd8c408e995972ff7fb0b6453c4f2214bde602d1772bd88f9d4d5c60"),
        "linux_ppc64le": ("go1.12.2.linux-ppc64le.tar.gz", "62be1d5f38e322edc21de0debd3051247faff59890c343a7f2173c15098dbd35"),
        "linux_s390x": ("go1.12.2.linux-s390x.tar.gz", "a41b0b11f5e34c3cccd7619bddf79a6d4b94bcbd2160fefcdf25f0afe87cad0a"),
        "windows_386": ("go1.12.2.windows-386.zip", "12d61e2b448709c6c3cc6b1bdff87f0f5a54ed0a515a130f9cee4384cde3c993"),
        "windows_amd64": ("go1.12.2.windows-amd64.zip", "4197135ef2221c9d7772063e1bdcd3f51de37811b19a678db87d7fc735a218f9"),
    },
    "1.12.1": {
        "darwin_amd64": ("go1.12.1.darwin-amd64.tar.gz", "1a3d311d77bc685a23f6243a1cb8c52538c4f976239c27dda2d2820225eb8fc9"),
        "freebsd_386": ("go1.12.1.freebsd-386.tar.gz", "392724db9f1cf38630a5ae7ee5c67f1416e8715500298cf81eb777fc4e6858c1"),
        "freebsd_amd64": ("go1.12.1.freebsd-amd64.tar.gz", "aecf1590f5ddbecc506d9e3941df95ecca71e779b1d52b0be82f7f0c14ba2abe"),
        "linux_386": ("go1.12.1.linux-386.tar.gz", "af74b6572dd0c133e5de121928616eab60a6252c66f6d9b15007c82207416a2c"),
        "linux_amd64": ("go1.12.1.linux-amd64.tar.gz", "2a3fdabf665496a0db5f41ec6af7a9b15a49fbe71a85a50ca38b1f13a103aeec"),
        "linux_arm64": ("go1.12.1.linux-arm64.tar.gz", "10dba44cf95c7aa7abc3c72610c12ebcaf7cad6eed761d5ad92736ca3bc0d547"),
        "linux_arm": ("go1.12.1.linux-armv6l.tar.gz", "ceac33f07f8fdbccd6c6f7339db33479e1be8c206e67458ba259470fe796dbf2"),
        "linux_ppc64le": ("go1.12.1.linux-ppc64le.tar.gz", "e1258c81f420c88339abf40888423904c0023497b4e9bbffac9ee484597a57d3"),
        "linux_s390x": ("go1.12.1.linux-s390x.tar.gz", "a9b8f49be6b2083e2586c2ce8a2a86d5dbf47cca64ac6195546a81c9927f9513"),
        "windows_386": ("go1.12.1.windows-386.zip", "f424dd3340c5739a87cfd1f836d387df69cecddce2a94f14a057261bb7068172"),
        "windows_amd64": ("go1.12.1.windows-amd64.zip", "2f4849b512fffb2cf2028608aa066cc1b79e730fd146c7b89015797162f08ec5"),
    },
    "1.12": {
        "darwin_amd64": ("go1.12.darwin-amd64.tar.gz", "6c7e07349403f71588ef4e93a6d4ae31f8e5de1497a0a42fd998fe9b6bd07c8e"),
        "freebsd_386": ("go1.12.freebsd-386.tar.gz", "5f66cc122e91249d9b371b2c8635b0b50db513812e3efaf9d6defbc28bff3a1c"),
        "freebsd_amd64": ("go1.12.freebsd-amd64.tar.gz", "b4c063a3f39de4f837475cb982507926d7cab4f64d35e1dc0d6dce555b3fe143"),
        "linux_386": ("go1.12.linux-386.tar.gz", "3ac1db65a6fa5c13f424b53ee181755429df0c33775733cede1e0d540440fd7b"),
        "linux_amd64": ("go1.12.linux-amd64.tar.gz", "750a07fef8579ae4839458701f4df690e0b20b8bcce33b437e4df89c451b6f13"),
        "linux_arm64": ("go1.12.linux-arm64.tar.gz", "b7bf59c2f1ac48eb587817a2a30b02168ecc99635fc19b6e677cce01406e3fac"),
        "linux_arm": ("go1.12.linux-armv6l.tar.gz", "ea0636f055763d309437461b5817452419411eb1f598dc7f35999fae05bcb79a"),
        "linux_ppc64le": ("go1.12.linux-ppc64le.tar.gz", "5be21e7035efa4a270802ea04fb104dc7a54e3492641ae44632170b93166fb68"),
        "linux_s390x": ("go1.12.linux-s390x.tar.gz", "c0aef360b99ebb4b834db8b5b22777b73a11fa37b382121b24bf587c40603915"),
        "windows_386": ("go1.12.windows-386.zip", "c6606bfdc4d8b080fc40f72a072eb380ead77a02a4f99a6b953df6d9c7029970"),
        "windows_amd64": ("go1.12.windows-amd64.zip", "880ced1aecef08b3471a84381b6c7e2c0e846b81dd97ecb629b534d941f282bd"),
    },
    "1.11.13": {
        "darwin_amd64": ("go1.11.13.darwin-amd64.tar.gz", "43b7b4a4c7f1729132dafbc2452e7838e1808ee759bd11f4f0359c82182589bc"),
        "freebsd_386": ("go1.11.13.freebsd-386.tar.gz", "930ba8e7122f3304600e4e28c02aa91b0899d6d48de34d575da34393b8bb6201"),
        "freebsd_amd64": ("go1.11.13.freebsd-amd64.tar.gz", "02e42d47da46b250ee5aa0b8e1d5aff097adee5ad6be9d7963ad57a005878fca"),
        "linux_386": ("go1.11.13.linux-386.tar.gz", "282e20167a7aaaba7b23de980696e1944a004efd0079e80d675d66b263ef595b"),
        "linux_amd64": ("go1.11.13.linux-amd64.tar.gz", "50fe8e13592f8cf22304b9c4adfc11849a2c3d281b1d7e09c924ae24874c6daa"),
        "linux_arm64": ("go1.11.13.linux-arm64.tar.gz", "e94329c97b38b5bffe9c18e84e9f521dc995e02df7696897a7626293da9ac593"),
        "linux_arm": ("go1.11.13.linux-armv6l.tar.gz", "513eb46158917662e1588cb89f51d11839730e46847778646c36c69c687bfdc5"),
        "linux_ppc64le": ("go1.11.13.linux-ppc64le.tar.gz", "ad3c7397ddd41a5af9d9bf3c560d3d0f8c1bdef4ac4d21819a021ea88e25efca"),
        "linux_s390x": ("go1.11.13.linux-s390x.tar.gz", "bd00bd27e641450f165a37a83f1e83a4ef3c626ef5675b77184e9c0147257657"),
        "windows_386": ("go1.11.13.windows-386.zip", "50adc8ab5d41ad16ebde3fa657b91349838d534e43d55a2b9123b81973849230"),
        "windows_amd64": ("go1.11.13.windows-amd64.zip", "55752de84439d0ed744ad681ae0915314516e69091fb86cab9701628ce3a65ff"),
    },
    "1.11.12": {
        "darwin_amd64": ("go1.11.12.darwin-amd64.tar.gz", "d2e1f708f3aef540ab27bcecd5c7e995c28e3a6db799d20393dd886ad3937a4c"),
        "freebsd_386": ("go1.11.12.freebsd-386.tar.gz", "9d634ad1c815c5fe7845b982900205b91244c0a71b86d295f6c2d6ae0909edaa"),
        "freebsd_amd64": ("go1.11.12.freebsd-amd64.tar.gz", "be3017c5a71858f7a850081dbcf9b2975ee824d0f31040ca31e2170022f76fd1"),
        "linux_386": ("go1.11.12.linux-386.tar.gz", "8467e68d6ed6f6a95c6db6a1e352fc529f256bba0955eaef472e50cf4c0cba61"),
        "linux_amd64": ("go1.11.12.linux-amd64.tar.gz", "14ec881815eb9e6618f95df5eb385d961283efc196d97912595ba6484a56180d"),
        "linux_arm64": ("go1.11.12.linux-arm64.tar.gz", "d79c075773fc3121d0e719b83b46115efff685ade94545a52f3ac22f43d76196"),
        "linux_arm": ("go1.11.12.linux-armv6l.tar.gz", "5ffe422dc054909da4e468cb0df6e2cd41cebfe4fd9515f32bb3e3fbfc416016"),
        "linux_ppc64le": ("go1.11.12.linux-ppc64le.tar.gz", "92bd4dc0dc8227fb22ad88545dd72669923019760cd640d4cca189860870561a"),
        "linux_s390x": ("go1.11.12.linux-s390x.tar.gz", "a4d100a1c92e50fd9b8a4d529da0ef0f4509c72643d6fb481918fd543f5871c0"),
        "windows_386": ("go1.11.12.windows-386.zip", "de4e2046d9e7afee0787fb72d0e4280bd684c67757a360ef9060083ab20f2c73"),
        "windows_amd64": ("go1.11.12.windows-amd64.zip", "a86e41e06d39f68ea8fa6a7765ce529abe3ec5037ba3a3bff2e6d25455a4fa34"),
    },
    "1.11.11": {
        "darwin_amd64": ("go1.11.11.darwin-amd64.tar.gz", "7b235cc8a51b68d2370e629aacb60226e5791e33f4c6bf2abb30b43817149450"),
        "freebsd_386": ("go1.11.11.freebsd-386.tar.gz", "96be77e7f3bbe87bef174c4d2854c09cfe96d7c97888eb11a9702db6b5038320"),
        "freebsd_amd64": ("go1.11.11.freebsd-amd64.tar.gz", "77e08891f254eb9b784427bcf1b2ec5bcf1bc53c1f6bcccf630a889a55df8f6d"),
        "linux_386": ("go1.11.11.linux-386.tar.gz", "c711fe5025608e14bcd0efda9403e9b8f05cb4a53a125e296d639c10d280a65f"),
        "linux_amd64": ("go1.11.11.linux-amd64.tar.gz", "2fd47b824d6e32154b0f6c8742d066d816667715763e06cebb710304b195c775"),
        "linux_arm64": ("go1.11.11.linux-arm64.tar.gz", "5ee39ea08e5d8c017658f36d0f969b17a44d49576214f4a00710f2d98bb773be"),
        "linux_arm": ("go1.11.11.linux-armv6l.tar.gz", "c2b882a5fbb3bac5c9cc6d65bfe17a5febfe0251a339fc059306bb825dec9b17"),
        "linux_ppc64le": ("go1.11.11.linux-ppc64le.tar.gz", "98ff7ff2367239e26745231aabeaf9d7e51c40b616bb9aa15d4376792ff581d1"),
        "linux_s390x": ("go1.11.11.linux-s390x.tar.gz", "d7471874ed396f72dd550c3593c9f42d5e3d38a2cca7658e669305bf9023e6c8"),
        "windows_386": ("go1.11.11.windows-386.zip", "cbe55adb6f0748bfe8c0bbad8d42e311d0bd045300b5b3af2ff3a636211e359f"),
        "windows_amd64": ("go1.11.11.windows-amd64.zip", "38018a1a0fa341687cee2f71c0e7578f852bbf017ad48907cda6cc28d1b84140"),
    },
    "1.11.10": {
        "darwin_amd64": ("go1.11.10.darwin-amd64.tar.gz", "194d7ce2b88a791147be64860f21bac8eeec8f372c9e9caab6c72c3bd525a039"),
        "freebsd_386": ("go1.11.10.freebsd-386.tar.gz", "5e90549194981e78a6d222c9a1f882952309f36fc93021173a1c179ec292de03"),
        "freebsd_amd64": ("go1.11.10.freebsd-amd64.tar.gz", "cccd4951358735d0acb7e67e8db842062a51f348c471d222d7b9b1e87877e109"),
        "linux_386": ("go1.11.10.linux-386.tar.gz", "619ddab5b56597d72681467810c63238063ab0d221fe0df9b2e85608c10161e5"),
        "linux_amd64": ("go1.11.10.linux-amd64.tar.gz", "aefaa228b68641e266d1f23f1d95dba33f17552ba132878b65bb798ffa37e6d0"),
        "linux_arm64": ("go1.11.10.linux-arm64.tar.gz", "6743c54f0e33873c113cbd66df7749e81785f378567734831c2e5d3b6b6aa2b8"),
        "linux_arm": ("go1.11.10.linux-armv6l.tar.gz", "29812e3443c469de6b976e4e44b5e6402d55f6358a544278addc22446a0abe8b"),
        "linux_ppc64le": ("go1.11.10.linux-ppc64le.tar.gz", "a6c7129e92fe325645229846257e563dab1d970bb0e61820d63524df2b54fcf8"),
        "linux_s390x": ("go1.11.10.linux-s390x.tar.gz", "35f196abd74db6f049018829ea6230fde6b8c2e24d2da9f9e75ce0e6d0292b49"),
        "windows_386": ("go1.11.10.windows-386.zip", "a74ca1c26c8c73a6b0843a82630da69f43e7f71aad8171a40e5872cc3b06913f"),
        "windows_amd64": ("go1.11.10.windows-amd64.zip", "e0354b5cef18dbf5867fff022ed4264c441df504f3cb86c90d8b987eca336f78"),
    },
    "1.11.9": {
        "darwin_amd64": ("go1.11.9.darwin-amd64.tar.gz", "6b842edbd72ffc0c1243a8f4bbbc8b0fd0b44dd0176b0203eb8ebf9dd7057006"),
        "freebsd_386": ("go1.11.9.freebsd-386.tar.gz", "2f58d4fb7d94cd0947f36d9422e20a3d4aba95dd3eec9826a9828194a13eb8a5"),
        "freebsd_amd64": ("go1.11.9.freebsd-amd64.tar.gz", "10da27ca2ab83399417e08ad78b5770de594c96c1cdb809d2d8df4d36959f263"),
        "linux_386": ("go1.11.9.linux-386.tar.gz", "0fa4001fcf1ef0644e261bf6dde02fc9f10ae4df6d74fda61fc4d3c3cbef1d79"),
        "linux_amd64": ("go1.11.9.linux-amd64.tar.gz", "e88aa3e39104e3ba6a95a4e05629348b4a1ec82791fb3c941a493ca349730608"),
        "linux_arm64": ("go1.11.9.linux-arm64.tar.gz", "892ab6c2510c4caa5905b3b1b6a1d4c6f04e384841fec50881ca2be7e8accf05"),
        "linux_armv6l": ("go1.11.9.linux-armv6l.tar.gz", "f0d7b039cae61efdc346669f3459460e3dc03b6c6de528ca107fc53970cba0d1"),
        "linux_ppc64le": ("go1.11.9.linux-ppc64le.tar.gz", "6a0a6a80997529543a434667f404ead2da88ac8fecc59bfba82f62bd2588e6c8"),
        "linux_s390x": ("go1.11.9.linux-s390x.tar.gz", "0dd7073469d0f414b264fbadc4f720f9582b13ff6a0a978a9ef23020f9e42ac1"),
        "windows_386": ("go1.11.9.windows-386.zip", "ce999ecbd89375592de1536718be4307fbc9fdccde860a5cc388b5d471b6af59"),
        "windows_amd64": ("go1.11.9.windows-amd64.zip", "f3f3e3c428131d5be65d79cf8663b3a81b6675e5cf9780c3b0769cfca6824922"),
    },
    "1.11.8": {
        "darwin_amd64": ("go1.11.8.darwin-amd64.tar.gz", "2bbd6ddc3e74bbadc2d2700a9372be1a82816b3de6c6c4915825d631c317c11d"),
        "freebsd_386": ("go1.11.8.freebsd-386.tar.gz", "ff029f93abde0880c201789389e4da0c43bdf8cddd45b6ddb1c999db33e40190"),
        "freebsd_amd64": ("go1.11.8.freebsd-amd64.tar.gz", "e5183aedcf3a8e1a5acb608833d2652c24d450c4b00b51a94be352190e272a26"),
        "linux_386": ("go1.11.8.linux-386.tar.gz", "e0e62a02516fa2197a2eb319a6957e7bd7007005a11b4da5c6650879999db899"),
        "linux_amd64": ("go1.11.8.linux-amd64.tar.gz", "e32ab1c934b747999d04e8a550b97f4647f8b1b43e152de5650d4476bfd1d2e1"),
        "linux_arm64": ("go1.11.8.linux-arm64.tar.gz", "68c42239d118b27f5e52a449f444c8a53e64a181b12d9ecbda14d0c3b765a5ee"),
        "linux_arm": ("go1.11.8.linux-armv6l.tar.gz", "c5d4fd90242761c214124eedb0ffc35af52be19e7a4eb4006b036b5dcb422c87"),
        "linux_ppc64le": ("go1.11.8.linux-ppc64le.tar.gz", "4f0559832957c37022f771420902c1f19100c0a5b391c4957753c521a9eba56e"),
        "linux_s390x": ("go1.11.8.linux-s390x.tar.gz", "023928ee1d896af181c62acfd0a4e7bd713c8503a9b3b9aec745a3a830630e1b"),
        "windows_386": ("go1.11.8.windows-386.zip", "4c9e043790d9f477f23a90ac8cfbaffa46953ee8ba888152cf5b72a249688e6f"),
        "windows_amd64": ("go1.11.8.windows-amd64.zip", "6b9d9f18ace455dcec2e72a0c6740fb23fe5f39433df3522b76ce05dcdcb1808"),
    },
    "1.11.7": {
        "darwin_amd64": ("go1.11.7.darwin-amd64.tar.gz", "61059849b936e4987d0ad800c05357624cd2085748e3889c0ea29def4f0275ae"),
        "freebsd_386": ("go1.11.7.freebsd-386.tar.gz", "2e64f5b1510ba3789114d8853dcbfb8cfaac87323352c4dd06d9f95dbbecc2f3"),
        "freebsd_amd64": ("go1.11.7.freebsd-amd64.tar.gz", "30d99a0934d44878608dea3de8db59824ed56881c517a273450d7ba0cc124090"),
        "linux_386": ("go1.11.7.linux-386.tar.gz", "86d11a58bd99298719cb7ebea160255aefc56735d14089d2b2241d581967a482"),
        "linux_amd64": ("go1.11.7.linux-amd64.tar.gz", "db687814288b3b541c1754dfd4ecc2b8fd0d5e7995624945e3054a350ca573d8"),
        "linux_arm64": ("go1.11.7.linux-arm64.tar.gz", "fe7ba5046aa4f52ae8fa36531aac4a949ad8e10c02b0f4aa05a420b4e803f8c6"),
        "linux_armv6l": ("go1.11.7.linux-armv6l.tar.gz", "7d6ae2e119a432a4b00a6dc2c2085f56ead4973f40d58e534308f1535b45afc2"),
        "linux_ppc64le": ("go1.11.7.linux-ppc64le.tar.gz", "43b04f58b37808f86f526e6f1a8d6643fe196c1314acc3d7db710ec9ae960d18"),
        "linux_s390x": ("go1.11.7.linux-s390x.tar.gz", "178932743c7af70c94f170f800202f490e0f85e74796dabe0a23d50630ba0333"),
        "windows_386": ("go1.11.7.windows-386.zip", "ae166b92ce5f2d878e5f375685bfbce6322f72bdbd98b2ec710f2449faeca3a8"),
        "windows_amd64": ("go1.11.7.windows-amd64.zip", "7d2a8f2f90f4e989bd3fcb8ab70949a0a3cdb0ed416cd9f61768b4cfc214c09e"),
    },
    "1.11.6": {
        "darwin_amd64": ("go1.11.6.darwin-amd64.tar.gz", "3f1d8af129ee362990b98ba8a77ed9a595fd497d4c934e01d8cdd902d18cc97a"),
        "freebsd_386": ("go1.11.6.freebsd-386.tar.gz", "7a9e639ab153e86b9202193255b2ab21708ea2a5078735c1fe6a7023b7e104b0"),
        "freebsd_amd64": ("go1.11.6.freebsd-amd64.tar.gz", "27cfee907a4d83614b8ffeb122a3e238821c9e9287d04c126658c635cc91a5c7"),
        "linux_386": ("go1.11.6.linux-386.tar.gz", "7d90e484bb92e68648c1a7b6b1790e97af33718bae457d2ee02ee5d1dd0ce2b7"),
        "linux_amd64": ("go1.11.6.linux-amd64.tar.gz", "4e1864282d8d20010d6385a12a1e35641783a380a7c57907bfb46a5499c5eb49"),
        "linux_arm64": ("go1.11.6.linux-arm64.tar.gz", "29f64505cea47c57a46e2c8001ecf8d0c01cbf1ec86de96f4e3126b94a12ebb7"),
        "linux_arm": ("go1.11.6.linux-armv6l.tar.gz", "62597fe72f1170cbb939958823555a701510e00362eb8a10b7ace6e59c8e7e6e"),
        "linux_ppc64le": ("go1.11.6.linux-ppc64le.tar.gz", "43d7cc7d3cdc1e57af33a13296b48713735f55e25aa655187afb19a707143c77"),
        "linux_s390x": ("go1.11.6.linux-s390x.tar.gz", "c7f83fa5975a8f11641962bad79f89a7e17a6580d0d21ca828733dc0cfe470f7"),
        "windows_386": ("go1.11.6.windows-386.zip", "11a2903eb117820931a995b3288b66aa2c176f6c45def12c854fecf4d9c7f69b"),
        "windows_amd64": ("go1.11.6.windows-amd64.zip", "a91a1efb00028b222445f4bcb6c84548bbd74962e53c87b68f0bce65de29c1ae"),
    },
    "1.11.5": {
        "darwin_amd64": ("go1.11.5.darwin-amd64.tar.gz", "b970d8fdd5245193073395ce7b7775dd9deea980d4ce5e68b3b80ee9edcf2afc"),
        "freebsd_386": ("go1.11.5.freebsd-386.tar.gz", "29d208de22cf4561404f4e4866cbb3d937d1043ce65e0a4e4bb88a8c8ac754ea"),
        "freebsd_amd64": ("go1.11.5.freebsd-amd64.tar.gz", "edd594da33d497a3499b362af3a3b3281c2e1de2b68b869154d4151aa82d85e2"),
        "linux_386": ("go1.11.5.linux-386.tar.gz", "acd8e05f8d3eed406e09bb58eab89de3f0a139d4aef15f74adeed2d2c24cb440"),
        "linux_amd64": ("go1.11.5.linux-amd64.tar.gz", "ff54aafedff961eb94792487e827515da683d61a5f9482f668008832631e5d25"),
        "linux_arm64": ("go1.11.5.linux-arm64.tar.gz", "6ee9a5714444182a236d3cc4636e74cfc5e24a1bacf0463ac71dcf0e7d4288ed"),
        "linux_arm": ("go1.11.5.linux-armv6l.tar.gz", "b26b53c94923f78955236386fee0725ef4e76b6cb47e0df0ed0c0c4724e7b198"),
        "linux_ppc64le": ("go1.11.5.linux-ppc64le.tar.gz", "66e83152c68cb35d41f21453377d6a811585c9e01a6ac54b19f7a6e2cbb3d1f5"),
        "linux_s390x": ("go1.11.5.linux-s390x.tar.gz", "56209e5498c64a8338cd6f0fe0c2e2cbf6857c0acdb10c774894f0cc0d19f413"),
        "windows_386": ("go1.11.5.windows-386.zip", "b569f7a45056ab810364d7ac9ee6357e9a098fc3e4c75e016948736fa93ee229"),
        "windows_amd64": ("go1.11.5.windows-amd64.zip", "1c734fe614fa052f44694e993f2d06f24a56b6703ee46fdfb2b9bf277819fe40"),
    },
    "1.11.4": {
        "darwin_amd64": ("go1.11.4.darwin-amd64.tar.gz", "48ea987fb610894b3108ecf42e7a4fd1c1e3eabcaeb570e388c75af1f1375f80"),
        "freebsd_386": ("go1.11.4.freebsd-386.tar.gz", "7c302a5fcb25c7a4d370e856218b748994bbb129810306260293cdfba0a80650"),
        "freebsd_amd64": ("go1.11.4.freebsd-amd64.tar.gz", "e5a99add3e60e38ef559e211584bb09a883ccc46a6fb1432dcaa9fd052689b71"),
        "linux_386": ("go1.11.4.linux-386.tar.gz", "cecd2da1849043237d5f0756a93d601db6798fa3bb27a14563d201088aa415f3"),
        "linux_amd64": ("go1.11.4.linux-amd64.tar.gz", "fb26c30e6a04ad937bbc657a1b5bba92f80096af1e8ee6da6430c045a8db3a5b"),
        "linux_arm64": ("go1.11.4.linux-arm64.tar.gz", "b76df430ba8caff197b8558921deef782cdb20b62fa36fa93f81a8c08ab7c8e7"),
        "linux_arm": ("go1.11.4.linux-armv6l.tar.gz", "9f7a71d27fef69f654a93e265560c8d9db1a2ca3f1dcdbe5288c46facfde5821"),
        "linux_ppc64le": ("go1.11.4.linux-ppc64le.tar.gz", "1f10146826acd56716b00b9188079af53823ddd79ceb6362e78e2f3aafb370ab"),
        "linux_s390x": ("go1.11.4.linux-s390x.tar.gz", "4467442dacf89eb94c5d6f9f700204cb360be82db60e6296cc2ef8d0e890cd42"),
        "windows_386": ("go1.11.4.windows-386.zip", "bc25ea25406878986f91c92ae802f25f033cb0163b4aeac7e7185f71d0ede788"),
        "windows_amd64": ("go1.11.4.windows-amd64.zip", "eeb20e21702f2b9469d9381df5de85e2f731b64a1f54effe196d0f7d0227fe14"),
    },
    "1.11.3": {
        "darwin_amd64": ("go1.11.3.darwin-amd64.tar.gz", "3d164d44fcb06a4bbd69d19d8d91308d601f7d855a1037346389644803fdf148"),
        "freebsd_386": ("go1.11.3.freebsd-386.tar.gz", "2b4aacf3dc09c8b210fe3daf00f7c17c97d29503070200ba46e04f2d93790672"),
        "freebsd_amd64": ("go1.11.3.freebsd-amd64.tar.gz", "29b3fcc8d80ac1ea10cd82ca78d3dac4e7242333b882855ea7bc8e3a9d974116"),
        "linux_386": ("go1.11.3.linux-386.tar.gz", "c3fadf7f8652c060e18b7907fb8e15b853955b25aa661dbd991f6d6bc581d7a9"),
        "linux_amd64": ("go1.11.3.linux-amd64.tar.gz", "d20a4869ffb13cee0f7ee777bf18c7b9b67ef0375f93fac1298519e0c227a07f"),
        "linux_arm64": ("go1.11.3.linux-arm64.tar.gz", "723c54cb081dd629a44d620197e4a789dccdfe6dee7f8b4ad7a6659f76952056"),
        "linux_arm": ("go1.11.3.linux-armv6l.tar.gz", "384933e6e97b74c5125011c8f0539362bbed5a015978a34e441d7333d8e519b9"),
        "linux_ppc64le": ("go1.11.3.linux-ppc64le.tar.gz", "57c89a047ef4f539580af4cadebf1364a906891b065afa0664592e72a034b0ee"),
        "linux_s390x": ("go1.11.3.linux-s390x.tar.gz", "183258709c051ceb2900dee5ee681abb0bc440624c8f657374bde2a5658bef27"),
        "windows_386": ("go1.11.3.windows-386.zip", "07a38035d642ae81820551ce486f2ac7d541c0caf910659452b4661656db0691"),
        "windows_amd64": ("go1.11.3.windows-amd64.zip", "bc168207115eb0686e226ed3708337b161946c1acb0437603e1221e94f2e1f0f"),
    },
    "1.11.2": {
        "darwin_amd64": ("go1.11.2.darwin-amd64.tar.gz", "be2a9382ef85792280951a78e789e8891ddb1df4ac718cd241ea9d977c85c683"),
        "freebsd_386": ("go1.11.2.freebsd-386.tar.gz", "7daf8c1995e6eb343c4b487ba4d6b8fb5463cdead8a8bde867a25cc7168ff77b"),
        "freebsd_amd64": ("go1.11.2.freebsd-amd64.tar.gz", "a0b46726b102067bdd9a9b863f2bce4d23e4478118162bb9b2362733eb28cabf"),
        "linux_386": ("go1.11.2.linux-386.tar.gz", "e74f2f37b43b9b1bcf18008a11e0efb8921b41dff399a4f48ac09a4f25729881"),
        "linux_amd64": ("go1.11.2.linux-amd64.tar.gz", "1dfe664fa3d8ad714bbd15a36627992effd150ddabd7523931f077b3926d736d"),
        "linux_arm64": ("go1.11.2.linux-arm64.tar.gz", "98a42b9b8d3bacbcc6351a1e39af52eff582d0bc3ac804cd5a97ce497dd84026"),
        "linux_arm": ("go1.11.2.linux-armv6l.tar.gz", "b9d16a8eb1f7b8fdadd27232f6300aa8b4427e5e4cb148c4be4089db8fb56429"),
        "linux_ppc64le": ("go1.11.2.linux-ppc64le.tar.gz", "23291935a299fdfde4b6a988ce3faa0c7a498aab6d56bbafbf1e7476468529a3"),
        "linux_s390x": ("go1.11.2.linux-s390x.tar.gz", "a67ef820ef8cfecc8d68c69dd5bf513aaf647c09b6605570af425bf5fe8a32f0"),
        "windows_386": ("go1.11.2.windows-386.zip", "c0c5ab568d9cf260cd7d281e0a489ef91f4b943813d99dac78b61607dca17283"),
        "windows_amd64": ("go1.11.2.windows-amd64.zip", "086c59df0dce54d88f30edd50160393deceb27e73b8d6b46b9ee3f88b0c02e28"),
    },
    "1.11.1": {
        "darwin_amd64": ("go1.11.1.darwin-amd64.tar.gz", "1f2b29c8b08a140f06c88d055ad68104ccea9ca75fd28fbc95fe1eeb61a29bef"),
        "freebsd_386": ("go1.11.1.freebsd-386.tar.gz", "db02787955495a4128811705dabf1b09c6d9674d59ebf93bc7be40a1ead7d91f"),
        "freebsd_amd64": ("go1.11.1.freebsd-amd64.tar.gz", "b2618f92bf5365c3e4f2a1f82997505d6356364310fdc0b9137734c4c9df29d8"),
        "linux_386": ("go1.11.1.linux-386.tar.gz", "52935db83719739d84a389a8f3b14544874fba803a316250b8d596313283aadf"),
        "linux_amd64": ("go1.11.1.linux-amd64.tar.gz", "2871270d8ff0c8c69f161aaae42f9f28739855ff5c5204752a8d92a1c9f63993"),
        "linux_arm64": ("go1.11.1.linux-arm64.tar.gz", "25e1a281b937022c70571ac5a538c9402dd74bceb71c2526377a7e5747df5522"),
        "linux_arm": ("go1.11.1.linux-armv6l.tar.gz", "bc601e428f458da6028671d66581b026092742baf6d3124748bb044c82497d42"),
        "linux_ppc64le": ("go1.11.1.linux-ppc64le.tar.gz", "f929d434d6db09fc4c6b67b03951596e576af5d02ff009633ca3c5be1c832bdd"),
        "linux_s390x": ("go1.11.1.linux-s390x.tar.gz", "93afc048ad72fa2a0e5ec56bcdcd8a34213eb262aee6f39a7e4dfeeb7e564c9d"),
        "windows_386": ("go1.11.1.windows-386.zip", "5cc3681c954e23d40b0c2565765ec34f4b4e834348e03e1d1e6fd1c3a75b8202"),
        "windows_amd64": ("go1.11.1.windows-amd64.zip", "230a08d4260ded9d769f072512a49bffe8bfaff8323e839c2db7cf7c9c788130"),
    },
    "1.11": {
        "darwin_amd64": ("go1.11.darwin-amd64.tar.gz", "9749e6cb9c6d05cf10445a7c9899b58e72325c54fee9783ed1ac679be8e1e073"),
        "freebsd_386": ("go1.11.freebsd-386.tar.gz", "e4c2a9bd43932cb8f3226e866737e4a0f8cdda93db9d82754a0ffea04af1a259"),
        "freebsd_amd64": ("go1.11.freebsd-amd64.tar.gz", "535a7561a229bfe7bece68c8e315421fd9fbbd3a599b461944113c8d8240b28f"),
        "linux_386": ("go1.11.linux-386.tar.gz", "1a91932b65b4af2f84ef2dce10d790e6a0d3d22c9ea1bdf3d8c4d9279dfa680e"),
        "linux_amd64": ("go1.11.linux-amd64.tar.gz", "b3fcf280ff86558e0559e185b601c9eade0fd24c900b4c63cd14d1d38613e499"),
        "linux_arm64": ("go1.11.linux-arm64.tar.gz", "e4853168f41d0bea65e4d38f992a2d44b58552605f623640c5ead89d515c56c9"),
        "linux_arm": ("go1.11.linux-armv6l.tar.gz", "8ffeb3577d8ca5477064f1cb8739835973c866487f2bf81df1227eaa96826acd"),
        "linux_ppc64le": ("go1.11.linux-ppc64le.tar.gz", "e874d617f0e322f8c2dda8c23ea3a2ea21d5dfe7177abb1f8b6a0ac7cd653272"),
        "linux_s390x": ("go1.11.linux-s390x.tar.gz", "c113495fbb175d6beb1b881750de1dd034c7ae8657c30b3de8808032c9af0a15"),
        "windows_386": ("go1.11.windows-386.zip", "d3279f0e3d728637352eff0aa1e11268a0eb01f13644bcbce1c066139f5a90db"),
        "windows_amd64": ("go1.11.windows-amd64.zip", "29f9291270f0b303d0b270f993972ead215b1bad3cc674a0b8a09699d978aeb4"),
    },
}
