/*
Copyright 2020 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by counterfeiter. DO NOT EDIT.
package anagofakes

import (
	"sync"
)

type FakeReleaseClient struct {
	ArchiveStub        func() error
	archiveMutex       sync.RWMutex
	archiveArgsForCall []struct {
	}
	archiveReturns struct {
		result1 error
	}
	archiveReturnsOnCall map[int]struct {
		result1 error
	}
	CheckPrerequisitesStub        func() error
	checkPrerequisitesMutex       sync.RWMutex
	checkPrerequisitesArgsForCall []struct {
	}
	checkPrerequisitesReturns struct {
		result1 error
	}
	checkPrerequisitesReturnsOnCall map[int]struct {
		result1 error
	}
	CheckReleaseBranchStateStub        func() error
	checkReleaseBranchStateMutex       sync.RWMutex
	checkReleaseBranchStateArgsForCall []struct {
	}
	checkReleaseBranchStateReturns struct {
		result1 error
	}
	checkReleaseBranchStateReturnsOnCall map[int]struct {
		result1 error
	}
	CreateAnnouncementStub        func() error
	createAnnouncementMutex       sync.RWMutex
	createAnnouncementArgsForCall []struct {
	}
	createAnnouncementReturns struct {
		result1 error
	}
	createAnnouncementReturnsOnCall map[int]struct {
		result1 error
	}
	GenerateReleaseVersionStub        func() error
	generateReleaseVersionMutex       sync.RWMutex
	generateReleaseVersionArgsForCall []struct {
	}
	generateReleaseVersionReturns struct {
		result1 error
	}
	generateReleaseVersionReturnsOnCall map[int]struct {
		result1 error
	}
	InitLogFileStub        func() error
	initLogFileMutex       sync.RWMutex
	initLogFileArgsForCall []struct {
	}
	initLogFileReturns struct {
		result1 error
	}
	initLogFileReturnsOnCall map[int]struct {
		result1 error
	}
	InitStateStub        func()
	initStateMutex       sync.RWMutex
	initStateArgsForCall []struct {
	}
	PrepareWorkspaceStub        func() error
	prepareWorkspaceMutex       sync.RWMutex
	prepareWorkspaceArgsForCall []struct {
	}
	prepareWorkspaceReturns struct {
		result1 error
	}
	prepareWorkspaceReturnsOnCall map[int]struct {
		result1 error
	}
	PushArtifactsStub        func() error
	pushArtifactsMutex       sync.RWMutex
	pushArtifactsArgsForCall []struct {
	}
	pushArtifactsReturns struct {
		result1 error
	}
	pushArtifactsReturnsOnCall map[int]struct {
		result1 error
	}
	PushGitObjectsStub        func() error
	pushGitObjectsMutex       sync.RWMutex
	pushGitObjectsArgsForCall []struct {
	}
	pushGitObjectsReturns struct {
		result1 error
	}
	pushGitObjectsReturnsOnCall map[int]struct {
		result1 error
	}
	SubmitStub        func(bool) error
	submitMutex       sync.RWMutex
	submitArgsForCall []struct {
		arg1 bool
	}
	submitReturns struct {
		result1 error
	}
	submitReturnsOnCall map[int]struct {
		result1 error
	}
	UpdateGitHubPageStub        func() error
	updateGitHubPageMutex       sync.RWMutex
	updateGitHubPageArgsForCall []struct {
	}
	updateGitHubPageReturns struct {
		result1 error
	}
	updateGitHubPageReturnsOnCall map[int]struct {
		result1 error
	}
	ValidateOptionsStub        func() error
	validateOptionsMutex       sync.RWMutex
	validateOptionsArgsForCall []struct {
	}
	validateOptionsReturns struct {
		result1 error
	}
	validateOptionsReturnsOnCall map[int]struct {
		result1 error
	}
	invocations      map[string][][]interface{}
	invocationsMutex sync.RWMutex
}

func (fake *FakeReleaseClient) Archive() error {
	fake.archiveMutex.Lock()
	ret, specificReturn := fake.archiveReturnsOnCall[len(fake.archiveArgsForCall)]
	fake.archiveArgsForCall = append(fake.archiveArgsForCall, struct {
	}{})
	stub := fake.ArchiveStub
	fakeReturns := fake.archiveReturns
	fake.recordInvocation("Archive", []interface{}{})
	fake.archiveMutex.Unlock()
	if stub != nil {
		return stub()
	}
	if specificReturn {
		return ret.result1
	}
	return fakeReturns.result1
}

func (fake *FakeReleaseClient) ArchiveCallCount() int {
	fake.archiveMutex.RLock()
	defer fake.archiveMutex.RUnlock()
	return len(fake.archiveArgsForCall)
}

func (fake *FakeReleaseClient) ArchiveCalls(stub func() error) {
	fake.archiveMutex.Lock()
	defer fake.archiveMutex.Unlock()
	fake.ArchiveStub = stub
}

func (fake *FakeReleaseClient) ArchiveReturns(result1 error) {
	fake.archiveMutex.Lock()
	defer fake.archiveMutex.Unlock()
	fake.ArchiveStub = nil
	fake.archiveReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeReleaseClient) ArchiveReturnsOnCall(i int, result1 error) {
	fake.archiveMutex.Lock()
	defer fake.archiveMutex.Unlock()
	fake.ArchiveStub = nil
	if fake.archiveReturnsOnCall == nil {
		fake.archiveReturnsOnCall = make(map[int]struct {
			result1 error
		})
	}
	fake.archiveReturnsOnCall[i] = struct {
		result1 error
	}{result1}
}

func (fake *FakeReleaseClient) CheckPrerequisites() error {
	fake.checkPrerequisitesMutex.Lock()
	ret, specificReturn := fake.checkPrerequisitesReturnsOnCall[len(fake.checkPrerequisitesArgsForCall)]
	fake.checkPrerequisitesArgsForCall = append(fake.checkPrerequisitesArgsForCall, struct {
	}{})
	stub := fake.CheckPrerequisitesStub
	fakeReturns := fake.checkPrerequisitesReturns
	fake.recordInvocation("CheckPrerequisites", []interface{}{})
	fake.checkPrerequisitesMutex.Unlock()
	if stub != nil {
		return stub()
	}
	if specificReturn {
		return ret.result1
	}
	return fakeReturns.result1
}

func (fake *FakeReleaseClient) CheckPrerequisitesCallCount() int {
	fake.checkPrerequisitesMutex.RLock()
	defer fake.checkPrerequisitesMutex.RUnlock()
	return len(fake.checkPrerequisitesArgsForCall)
}

func (fake *FakeReleaseClient) CheckPrerequisitesCalls(stub func() error) {
	fake.checkPrerequisitesMutex.Lock()
	defer fake.checkPrerequisitesMutex.Unlock()
	fake.CheckPrerequisitesStub = stub
}

func (fake *FakeReleaseClient) CheckPrerequisitesReturns(result1 error) {
	fake.checkPrerequisitesMutex.Lock()
	defer fake.checkPrerequisitesMutex.Unlock()
	fake.CheckPrerequisitesStub = nil
	fake.checkPrerequisitesReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeReleaseClient) CheckPrerequisitesReturnsOnCall(i int, result1 error) {
	fake.checkPrerequisitesMutex.Lock()
	defer fake.checkPrerequisitesMutex.Unlock()
	fake.CheckPrerequisitesStub = nil
	if fake.checkPrerequisitesReturnsOnCall == nil {
		fake.checkPrerequisitesReturnsOnCall = make(map[int]struct {
			result1 error
		})
	}
	fake.checkPrerequisitesReturnsOnCall[i] = struct {
		result1 error
	}{result1}
}

func (fake *FakeReleaseClient) CheckReleaseBranchState() error {
	fake.checkReleaseBranchStateMutex.Lock()
	ret, specificReturn := fake.checkReleaseBranchStateReturnsOnCall[len(fake.checkReleaseBranchStateArgsForCall)]
	fake.checkReleaseBranchStateArgsForCall = append(fake.checkReleaseBranchStateArgsForCall, struct {
	}{})
	stub := fake.CheckReleaseBranchStateStub
	fakeReturns := fake.checkReleaseBranchStateReturns
	fake.recordInvocation("CheckReleaseBranchState", []interface{}{})
	fake.checkReleaseBranchStateMutex.Unlock()
	if stub != nil {
		return stub()
	}
	if specificReturn {
		return ret.result1
	}
	return fakeReturns.result1
}

func (fake *FakeReleaseClient) CheckReleaseBranchStateCallCount() int {
	fake.checkReleaseBranchStateMutex.RLock()
	defer fake.checkReleaseBranchStateMutex.RUnlock()
	return len(fake.checkReleaseBranchStateArgsForCall)
}

func (fake *FakeReleaseClient) CheckReleaseBranchStateCalls(stub func() error) {
	fake.checkReleaseBranchStateMutex.Lock()
	defer fake.checkReleaseBranchStateMutex.Unlock()
	fake.CheckReleaseBranchStateStub = stub
}

func (fake *FakeReleaseClient) CheckReleaseBranchStateReturns(result1 error) {
	fake.checkReleaseBranchStateMutex.Lock()
	defer fake.checkReleaseBranchStateMutex.Unlock()
	fake.CheckReleaseBranchStateStub = nil
	fake.checkReleaseBranchStateReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeReleaseClient) CheckReleaseBranchStateReturnsOnCall(i int, result1 error) {
	fake.checkReleaseBranchStateMutex.Lock()
	defer fake.checkReleaseBranchStateMutex.Unlock()
	fake.CheckReleaseBranchStateStub = nil
	if fake.checkReleaseBranchStateReturnsOnCall == nil {
		fake.checkReleaseBranchStateReturnsOnCall = make(map[int]struct {
			result1 error
		})
	}
	fake.checkReleaseBranchStateReturnsOnCall[i] = struct {
		result1 error
	}{result1}
}

func (fake *FakeReleaseClient) CreateAnnouncement() error {
	fake.createAnnouncementMutex.Lock()
	ret, specificReturn := fake.createAnnouncementReturnsOnCall[len(fake.createAnnouncementArgsForCall)]
	fake.createAnnouncementArgsForCall = append(fake.createAnnouncementArgsForCall, struct {
	}{})
	stub := fake.CreateAnnouncementStub
	fakeReturns := fake.createAnnouncementReturns
	fake.recordInvocation("CreateAnnouncement", []interface{}{})
	fake.createAnnouncementMutex.Unlock()
	if stub != nil {
		return stub()
	}
	if specificReturn {
		return ret.result1
	}
	return fakeReturns.result1
}

func (fake *FakeReleaseClient) CreateAnnouncementCallCount() int {
	fake.createAnnouncementMutex.RLock()
	defer fake.createAnnouncementMutex.RUnlock()
	return len(fake.createAnnouncementArgsForCall)
}

func (fake *FakeReleaseClient) CreateAnnouncementCalls(stub func() error) {
	fake.createAnnouncementMutex.Lock()
	defer fake.createAnnouncementMutex.Unlock()
	fake.CreateAnnouncementStub = stub
}

func (fake *FakeReleaseClient) CreateAnnouncementReturns(result1 error) {
	fake.createAnnouncementMutex.Lock()
	defer fake.createAnnouncementMutex.Unlock()
	fake.CreateAnnouncementStub = nil
	fake.createAnnouncementReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeReleaseClient) CreateAnnouncementReturnsOnCall(i int, result1 error) {
	fake.createAnnouncementMutex.Lock()
	defer fake.createAnnouncementMutex.Unlock()
	fake.CreateAnnouncementStub = nil
	if fake.createAnnouncementReturnsOnCall == nil {
		fake.createAnnouncementReturnsOnCall = make(map[int]struct {
			result1 error
		})
	}
	fake.createAnnouncementReturnsOnCall[i] = struct {
		result1 error
	}{result1}
}

func (fake *FakeReleaseClient) GenerateReleaseVersion() error {
	fake.generateReleaseVersionMutex.Lock()
	ret, specificReturn := fake.generateReleaseVersionReturnsOnCall[len(fake.generateReleaseVersionArgsForCall)]
	fake.generateReleaseVersionArgsForCall = append(fake.generateReleaseVersionArgsForCall, struct {
	}{})
	stub := fake.GenerateReleaseVersionStub
	fakeReturns := fake.generateReleaseVersionReturns
	fake.recordInvocation("GenerateReleaseVersion", []interface{}{})
	fake.generateReleaseVersionMutex.Unlock()
	if stub != nil {
		return stub()
	}
	if specificReturn {
		return ret.result1
	}
	return fakeReturns.result1
}

func (fake *FakeReleaseClient) GenerateReleaseVersionCallCount() int {
	fake.generateReleaseVersionMutex.RLock()
	defer fake.generateReleaseVersionMutex.RUnlock()
	return len(fake.generateReleaseVersionArgsForCall)
}

func (fake *FakeReleaseClient) GenerateReleaseVersionCalls(stub func() error) {
	fake.generateReleaseVersionMutex.Lock()
	defer fake.generateReleaseVersionMutex.Unlock()
	fake.GenerateReleaseVersionStub = stub
}

func (fake *FakeReleaseClient) GenerateReleaseVersionReturns(result1 error) {
	fake.generateReleaseVersionMutex.Lock()
	defer fake.generateReleaseVersionMutex.Unlock()
	fake.GenerateReleaseVersionStub = nil
	fake.generateReleaseVersionReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeReleaseClient) GenerateReleaseVersionReturnsOnCall(i int, result1 error) {
	fake.generateReleaseVersionMutex.Lock()
	defer fake.generateReleaseVersionMutex.Unlock()
	fake.GenerateReleaseVersionStub = nil
	if fake.generateReleaseVersionReturnsOnCall == nil {
		fake.generateReleaseVersionReturnsOnCall = make(map[int]struct {
			result1 error
		})
	}
	fake.generateReleaseVersionReturnsOnCall[i] = struct {
		result1 error
	}{result1}
}

func (fake *FakeReleaseClient) InitLogFile() error {
	fake.initLogFileMutex.Lock()
	ret, specificReturn := fake.initLogFileReturnsOnCall[len(fake.initLogFileArgsForCall)]
	fake.initLogFileArgsForCall = append(fake.initLogFileArgsForCall, struct {
	}{})
	stub := fake.InitLogFileStub
	fakeReturns := fake.initLogFileReturns
	fake.recordInvocation("InitLogFile", []interface{}{})
	fake.initLogFileMutex.Unlock()
	if stub != nil {
		return stub()
	}
	if specificReturn {
		return ret.result1
	}
	return fakeReturns.result1
}

func (fake *FakeReleaseClient) InitLogFileCallCount() int {
	fake.initLogFileMutex.RLock()
	defer fake.initLogFileMutex.RUnlock()
	return len(fake.initLogFileArgsForCall)
}

func (fake *FakeReleaseClient) InitLogFileCalls(stub func() error) {
	fake.initLogFileMutex.Lock()
	defer fake.initLogFileMutex.Unlock()
	fake.InitLogFileStub = stub
}

func (fake *FakeReleaseClient) InitLogFileReturns(result1 error) {
	fake.initLogFileMutex.Lock()
	defer fake.initLogFileMutex.Unlock()
	fake.InitLogFileStub = nil
	fake.initLogFileReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeReleaseClient) InitLogFileReturnsOnCall(i int, result1 error) {
	fake.initLogFileMutex.Lock()
	defer fake.initLogFileMutex.Unlock()
	fake.InitLogFileStub = nil
	if fake.initLogFileReturnsOnCall == nil {
		fake.initLogFileReturnsOnCall = make(map[int]struct {
			result1 error
		})
	}
	fake.initLogFileReturnsOnCall[i] = struct {
		result1 error
	}{result1}
}

func (fake *FakeReleaseClient) InitState() {
	fake.initStateMutex.Lock()
	fake.initStateArgsForCall = append(fake.initStateArgsForCall, struct {
	}{})
	stub := fake.InitStateStub
	fake.recordInvocation("InitState", []interface{}{})
	fake.initStateMutex.Unlock()
	if stub != nil {
		fake.InitStateStub()
	}
}

func (fake *FakeReleaseClient) InitStateCallCount() int {
	fake.initStateMutex.RLock()
	defer fake.initStateMutex.RUnlock()
	return len(fake.initStateArgsForCall)
}

func (fake *FakeReleaseClient) InitStateCalls(stub func()) {
	fake.initStateMutex.Lock()
	defer fake.initStateMutex.Unlock()
	fake.InitStateStub = stub
}

func (fake *FakeReleaseClient) PrepareWorkspace() error {
	fake.prepareWorkspaceMutex.Lock()
	ret, specificReturn := fake.prepareWorkspaceReturnsOnCall[len(fake.prepareWorkspaceArgsForCall)]
	fake.prepareWorkspaceArgsForCall = append(fake.prepareWorkspaceArgsForCall, struct {
	}{})
	stub := fake.PrepareWorkspaceStub
	fakeReturns := fake.prepareWorkspaceReturns
	fake.recordInvocation("PrepareWorkspace", []interface{}{})
	fake.prepareWorkspaceMutex.Unlock()
	if stub != nil {
		return stub()
	}
	if specificReturn {
		return ret.result1
	}
	return fakeReturns.result1
}

func (fake *FakeReleaseClient) PrepareWorkspaceCallCount() int {
	fake.prepareWorkspaceMutex.RLock()
	defer fake.prepareWorkspaceMutex.RUnlock()
	return len(fake.prepareWorkspaceArgsForCall)
}

func (fake *FakeReleaseClient) PrepareWorkspaceCalls(stub func() error) {
	fake.prepareWorkspaceMutex.Lock()
	defer fake.prepareWorkspaceMutex.Unlock()
	fake.PrepareWorkspaceStub = stub
}

func (fake *FakeReleaseClient) PrepareWorkspaceReturns(result1 error) {
	fake.prepareWorkspaceMutex.Lock()
	defer fake.prepareWorkspaceMutex.Unlock()
	fake.PrepareWorkspaceStub = nil
	fake.prepareWorkspaceReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeReleaseClient) PrepareWorkspaceReturnsOnCall(i int, result1 error) {
	fake.prepareWorkspaceMutex.Lock()
	defer fake.prepareWorkspaceMutex.Unlock()
	fake.PrepareWorkspaceStub = nil
	if fake.prepareWorkspaceReturnsOnCall == nil {
		fake.prepareWorkspaceReturnsOnCall = make(map[int]struct {
			result1 error
		})
	}
	fake.prepareWorkspaceReturnsOnCall[i] = struct {
		result1 error
	}{result1}
}

func (fake *FakeReleaseClient) PushArtifacts() error {
	fake.pushArtifactsMutex.Lock()
	ret, specificReturn := fake.pushArtifactsReturnsOnCall[len(fake.pushArtifactsArgsForCall)]
	fake.pushArtifactsArgsForCall = append(fake.pushArtifactsArgsForCall, struct {
	}{})
	stub := fake.PushArtifactsStub
	fakeReturns := fake.pushArtifactsReturns
	fake.recordInvocation("PushArtifacts", []interface{}{})
	fake.pushArtifactsMutex.Unlock()
	if stub != nil {
		return stub()
	}
	if specificReturn {
		return ret.result1
	}
	return fakeReturns.result1
}

func (fake *FakeReleaseClient) PushArtifactsCallCount() int {
	fake.pushArtifactsMutex.RLock()
	defer fake.pushArtifactsMutex.RUnlock()
	return len(fake.pushArtifactsArgsForCall)
}

func (fake *FakeReleaseClient) PushArtifactsCalls(stub func() error) {
	fake.pushArtifactsMutex.Lock()
	defer fake.pushArtifactsMutex.Unlock()
	fake.PushArtifactsStub = stub
}

func (fake *FakeReleaseClient) PushArtifactsReturns(result1 error) {
	fake.pushArtifactsMutex.Lock()
	defer fake.pushArtifactsMutex.Unlock()
	fake.PushArtifactsStub = nil
	fake.pushArtifactsReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeReleaseClient) PushArtifactsReturnsOnCall(i int, result1 error) {
	fake.pushArtifactsMutex.Lock()
	defer fake.pushArtifactsMutex.Unlock()
	fake.PushArtifactsStub = nil
	if fake.pushArtifactsReturnsOnCall == nil {
		fake.pushArtifactsReturnsOnCall = make(map[int]struct {
			result1 error
		})
	}
	fake.pushArtifactsReturnsOnCall[i] = struct {
		result1 error
	}{result1}
}

func (fake *FakeReleaseClient) PushGitObjects() error {
	fake.pushGitObjectsMutex.Lock()
	ret, specificReturn := fake.pushGitObjectsReturnsOnCall[len(fake.pushGitObjectsArgsForCall)]
	fake.pushGitObjectsArgsForCall = append(fake.pushGitObjectsArgsForCall, struct {
	}{})
	stub := fake.PushGitObjectsStub
	fakeReturns := fake.pushGitObjectsReturns
	fake.recordInvocation("PushGitObjects", []interface{}{})
	fake.pushGitObjectsMutex.Unlock()
	if stub != nil {
		return stub()
	}
	if specificReturn {
		return ret.result1
	}
	return fakeReturns.result1
}

func (fake *FakeReleaseClient) PushGitObjectsCallCount() int {
	fake.pushGitObjectsMutex.RLock()
	defer fake.pushGitObjectsMutex.RUnlock()
	return len(fake.pushGitObjectsArgsForCall)
}

func (fake *FakeReleaseClient) PushGitObjectsCalls(stub func() error) {
	fake.pushGitObjectsMutex.Lock()
	defer fake.pushGitObjectsMutex.Unlock()
	fake.PushGitObjectsStub = stub
}

func (fake *FakeReleaseClient) PushGitObjectsReturns(result1 error) {
	fake.pushGitObjectsMutex.Lock()
	defer fake.pushGitObjectsMutex.Unlock()
	fake.PushGitObjectsStub = nil
	fake.pushGitObjectsReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeReleaseClient) PushGitObjectsReturnsOnCall(i int, result1 error) {
	fake.pushGitObjectsMutex.Lock()
	defer fake.pushGitObjectsMutex.Unlock()
	fake.PushGitObjectsStub = nil
	if fake.pushGitObjectsReturnsOnCall == nil {
		fake.pushGitObjectsReturnsOnCall = make(map[int]struct {
			result1 error
		})
	}
	fake.pushGitObjectsReturnsOnCall[i] = struct {
		result1 error
	}{result1}
}

func (fake *FakeReleaseClient) Submit(arg1 bool) error {
	fake.submitMutex.Lock()
	ret, specificReturn := fake.submitReturnsOnCall[len(fake.submitArgsForCall)]
	fake.submitArgsForCall = append(fake.submitArgsForCall, struct {
		arg1 bool
	}{arg1})
	stub := fake.SubmitStub
	fakeReturns := fake.submitReturns
	fake.recordInvocation("Submit", []interface{}{arg1})
	fake.submitMutex.Unlock()
	if stub != nil {
		return stub(arg1)
	}
	if specificReturn {
		return ret.result1
	}
	return fakeReturns.result1
}

func (fake *FakeReleaseClient) SubmitCallCount() int {
	fake.submitMutex.RLock()
	defer fake.submitMutex.RUnlock()
	return len(fake.submitArgsForCall)
}

func (fake *FakeReleaseClient) SubmitCalls(stub func(bool) error) {
	fake.submitMutex.Lock()
	defer fake.submitMutex.Unlock()
	fake.SubmitStub = stub
}

func (fake *FakeReleaseClient) SubmitArgsForCall(i int) bool {
	fake.submitMutex.RLock()
	defer fake.submitMutex.RUnlock()
	argsForCall := fake.submitArgsForCall[i]
	return argsForCall.arg1
}

func (fake *FakeReleaseClient) SubmitReturns(result1 error) {
	fake.submitMutex.Lock()
	defer fake.submitMutex.Unlock()
	fake.SubmitStub = nil
	fake.submitReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeReleaseClient) SubmitReturnsOnCall(i int, result1 error) {
	fake.submitMutex.Lock()
	defer fake.submitMutex.Unlock()
	fake.SubmitStub = nil
	if fake.submitReturnsOnCall == nil {
		fake.submitReturnsOnCall = make(map[int]struct {
			result1 error
		})
	}
	fake.submitReturnsOnCall[i] = struct {
		result1 error
	}{result1}
}

func (fake *FakeReleaseClient) UpdateGitHubPage() error {
	fake.updateGitHubPageMutex.Lock()
	ret, specificReturn := fake.updateGitHubPageReturnsOnCall[len(fake.updateGitHubPageArgsForCall)]
	fake.updateGitHubPageArgsForCall = append(fake.updateGitHubPageArgsForCall, struct {
	}{})
	stub := fake.UpdateGitHubPageStub
	fakeReturns := fake.updateGitHubPageReturns
	fake.recordInvocation("UpdateGitHubPage", []interface{}{})
	fake.updateGitHubPageMutex.Unlock()
	if stub != nil {
		return stub()
	}
	if specificReturn {
		return ret.result1
	}
	return fakeReturns.result1
}

func (fake *FakeReleaseClient) UpdateGitHubPageCallCount() int {
	fake.updateGitHubPageMutex.RLock()
	defer fake.updateGitHubPageMutex.RUnlock()
	return len(fake.updateGitHubPageArgsForCall)
}

func (fake *FakeReleaseClient) UpdateGitHubPageCalls(stub func() error) {
	fake.updateGitHubPageMutex.Lock()
	defer fake.updateGitHubPageMutex.Unlock()
	fake.UpdateGitHubPageStub = stub
}

func (fake *FakeReleaseClient) UpdateGitHubPageReturns(result1 error) {
	fake.updateGitHubPageMutex.Lock()
	defer fake.updateGitHubPageMutex.Unlock()
	fake.UpdateGitHubPageStub = nil
	fake.updateGitHubPageReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeReleaseClient) UpdateGitHubPageReturnsOnCall(i int, result1 error) {
	fake.updateGitHubPageMutex.Lock()
	defer fake.updateGitHubPageMutex.Unlock()
	fake.UpdateGitHubPageStub = nil
	if fake.updateGitHubPageReturnsOnCall == nil {
		fake.updateGitHubPageReturnsOnCall = make(map[int]struct {
			result1 error
		})
	}
	fake.updateGitHubPageReturnsOnCall[i] = struct {
		result1 error
	}{result1}
}

func (fake *FakeReleaseClient) ValidateOptions() error {
	fake.validateOptionsMutex.Lock()
	ret, specificReturn := fake.validateOptionsReturnsOnCall[len(fake.validateOptionsArgsForCall)]
	fake.validateOptionsArgsForCall = append(fake.validateOptionsArgsForCall, struct {
	}{})
	stub := fake.ValidateOptionsStub
	fakeReturns := fake.validateOptionsReturns
	fake.recordInvocation("ValidateOptions", []interface{}{})
	fake.validateOptionsMutex.Unlock()
	if stub != nil {
		return stub()
	}
	if specificReturn {
		return ret.result1
	}
	return fakeReturns.result1
}

func (fake *FakeReleaseClient) ValidateOptionsCallCount() int {
	fake.validateOptionsMutex.RLock()
	defer fake.validateOptionsMutex.RUnlock()
	return len(fake.validateOptionsArgsForCall)
}

func (fake *FakeReleaseClient) ValidateOptionsCalls(stub func() error) {
	fake.validateOptionsMutex.Lock()
	defer fake.validateOptionsMutex.Unlock()
	fake.ValidateOptionsStub = stub
}

func (fake *FakeReleaseClient) ValidateOptionsReturns(result1 error) {
	fake.validateOptionsMutex.Lock()
	defer fake.validateOptionsMutex.Unlock()
	fake.ValidateOptionsStub = nil
	fake.validateOptionsReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeReleaseClient) ValidateOptionsReturnsOnCall(i int, result1 error) {
	fake.validateOptionsMutex.Lock()
	defer fake.validateOptionsMutex.Unlock()
	fake.ValidateOptionsStub = nil
	if fake.validateOptionsReturnsOnCall == nil {
		fake.validateOptionsReturnsOnCall = make(map[int]struct {
			result1 error
		})
	}
	fake.validateOptionsReturnsOnCall[i] = struct {
		result1 error
	}{result1}
}

func (fake *FakeReleaseClient) Invocations() map[string][][]interface{} {
	fake.invocationsMutex.RLock()
	defer fake.invocationsMutex.RUnlock()
	fake.archiveMutex.RLock()
	defer fake.archiveMutex.RUnlock()
	fake.checkPrerequisitesMutex.RLock()
	defer fake.checkPrerequisitesMutex.RUnlock()
	fake.checkReleaseBranchStateMutex.RLock()
	defer fake.checkReleaseBranchStateMutex.RUnlock()
	fake.createAnnouncementMutex.RLock()
	defer fake.createAnnouncementMutex.RUnlock()
	fake.generateReleaseVersionMutex.RLock()
	defer fake.generateReleaseVersionMutex.RUnlock()
	fake.initLogFileMutex.RLock()
	defer fake.initLogFileMutex.RUnlock()
	fake.initStateMutex.RLock()
	defer fake.initStateMutex.RUnlock()
	fake.prepareWorkspaceMutex.RLock()
	defer fake.prepareWorkspaceMutex.RUnlock()
	fake.pushArtifactsMutex.RLock()
	defer fake.pushArtifactsMutex.RUnlock()
	fake.pushGitObjectsMutex.RLock()
	defer fake.pushGitObjectsMutex.RUnlock()
	fake.submitMutex.RLock()
	defer fake.submitMutex.RUnlock()
	fake.updateGitHubPageMutex.RLock()
	defer fake.updateGitHubPageMutex.RUnlock()
	fake.validateOptionsMutex.RLock()
	defer fake.validateOptionsMutex.RUnlock()
	copiedInvocations := map[string][][]interface{}{}
	for key, value := range fake.invocations {
		copiedInvocations[key] = value
	}
	return copiedInvocations
}

func (fake *FakeReleaseClient) recordInvocation(key string, args []interface{}) {
	fake.invocationsMutex.Lock()
	defer fake.invocationsMutex.Unlock()
	if fake.invocations == nil {
		fake.invocations = map[string][][]interface{}{}
	}
	if fake.invocations[key] == nil {
		fake.invocations[key] = [][]interface{}{}
	}
	fake.invocations[key] = append(fake.invocations[key], args)
}
