/*
Copyright 2020 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by counterfeiter. DO NOT EDIT.
package anagofakes

import (
	"sync"
)

type FakeStageClient struct {
	BuildStub        func() error
	buildMutex       sync.RWMutex
	buildArgsForCall []struct {
	}
	buildReturns struct {
		result1 error
	}
	buildReturnsOnCall map[int]struct {
		result1 error
	}
	CheckPrerequisitesStub        func() error
	checkPrerequisitesMutex       sync.RWMutex
	checkPrerequisitesArgsForCall []struct {
	}
	checkPrerequisitesReturns struct {
		result1 error
	}
	checkPrerequisitesReturnsOnCall map[int]struct {
		result1 error
	}
	CheckReleaseBranchStateStub        func() error
	checkReleaseBranchStateMutex       sync.RWMutex
	checkReleaseBranchStateArgsForCall []struct {
	}
	checkReleaseBranchStateReturns struct {
		result1 error
	}
	checkReleaseBranchStateReturnsOnCall map[int]struct {
		result1 error
	}
	GenerateChangelogStub        func() error
	generateChangelogMutex       sync.RWMutex
	generateChangelogArgsForCall []struct {
	}
	generateChangelogReturns struct {
		result1 error
	}
	generateChangelogReturnsOnCall map[int]struct {
		result1 error
	}
	GenerateReleaseVersionStub        func() error
	generateReleaseVersionMutex       sync.RWMutex
	generateReleaseVersionArgsForCall []struct {
	}
	generateReleaseVersionReturns struct {
		result1 error
	}
	generateReleaseVersionReturnsOnCall map[int]struct {
		result1 error
	}
	InitLogFileStub        func() error
	initLogFileMutex       sync.RWMutex
	initLogFileArgsForCall []struct {
	}
	initLogFileReturns struct {
		result1 error
	}
	initLogFileReturnsOnCall map[int]struct {
		result1 error
	}
	InitStateStub        func()
	initStateMutex       sync.RWMutex
	initStateArgsForCall []struct {
	}
	PrepareWorkspaceStub        func() error
	prepareWorkspaceMutex       sync.RWMutex
	prepareWorkspaceArgsForCall []struct {
	}
	prepareWorkspaceReturns struct {
		result1 error
	}
	prepareWorkspaceReturnsOnCall map[int]struct {
		result1 error
	}
	StageArtifactsStub        func() error
	stageArtifactsMutex       sync.RWMutex
	stageArtifactsArgsForCall []struct {
	}
	stageArtifactsReturns struct {
		result1 error
	}
	stageArtifactsReturnsOnCall map[int]struct {
		result1 error
	}
	SubmitStub        func(bool) error
	submitMutex       sync.RWMutex
	submitArgsForCall []struct {
		arg1 bool
	}
	submitReturns struct {
		result1 error
	}
	submitReturnsOnCall map[int]struct {
		result1 error
	}
	TagRepositoryStub        func() error
	tagRepositoryMutex       sync.RWMutex
	tagRepositoryArgsForCall []struct {
	}
	tagRepositoryReturns struct {
		result1 error
	}
	tagRepositoryReturnsOnCall map[int]struct {
		result1 error
	}
	ValidateOptionsStub        func() error
	validateOptionsMutex       sync.RWMutex
	validateOptionsArgsForCall []struct {
	}
	validateOptionsReturns struct {
		result1 error
	}
	validateOptionsReturnsOnCall map[int]struct {
		result1 error
	}
	invocations      map[string][][]interface{}
	invocationsMutex sync.RWMutex
}

func (fake *FakeStageClient) Build() error {
	fake.buildMutex.Lock()
	ret, specificReturn := fake.buildReturnsOnCall[len(fake.buildArgsForCall)]
	fake.buildArgsForCall = append(fake.buildArgsForCall, struct {
	}{})
	stub := fake.BuildStub
	fakeReturns := fake.buildReturns
	fake.recordInvocation("Build", []interface{}{})
	fake.buildMutex.Unlock()
	if stub != nil {
		return stub()
	}
	if specificReturn {
		return ret.result1
	}
	return fakeReturns.result1
}

func (fake *FakeStageClient) BuildCallCount() int {
	fake.buildMutex.RLock()
	defer fake.buildMutex.RUnlock()
	return len(fake.buildArgsForCall)
}

func (fake *FakeStageClient) BuildCalls(stub func() error) {
	fake.buildMutex.Lock()
	defer fake.buildMutex.Unlock()
	fake.BuildStub = stub
}

func (fake *FakeStageClient) BuildReturns(result1 error) {
	fake.buildMutex.Lock()
	defer fake.buildMutex.Unlock()
	fake.BuildStub = nil
	fake.buildReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageClient) BuildReturnsOnCall(i int, result1 error) {
	fake.buildMutex.Lock()
	defer fake.buildMutex.Unlock()
	fake.BuildStub = nil
	if fake.buildReturnsOnCall == nil {
		fake.buildReturnsOnCall = make(map[int]struct {
			result1 error
		})
	}
	fake.buildReturnsOnCall[i] = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageClient) CheckPrerequisites() error {
	fake.checkPrerequisitesMutex.Lock()
	ret, specificReturn := fake.checkPrerequisitesReturnsOnCall[len(fake.checkPrerequisitesArgsForCall)]
	fake.checkPrerequisitesArgsForCall = append(fake.checkPrerequisitesArgsForCall, struct {
	}{})
	stub := fake.CheckPrerequisitesStub
	fakeReturns := fake.checkPrerequisitesReturns
	fake.recordInvocation("CheckPrerequisites", []interface{}{})
	fake.checkPrerequisitesMutex.Unlock()
	if stub != nil {
		return stub()
	}
	if specificReturn {
		return ret.result1
	}
	return fakeReturns.result1
}

func (fake *FakeStageClient) CheckPrerequisitesCallCount() int {
	fake.checkPrerequisitesMutex.RLock()
	defer fake.checkPrerequisitesMutex.RUnlock()
	return len(fake.checkPrerequisitesArgsForCall)
}

func (fake *FakeStageClient) CheckPrerequisitesCalls(stub func() error) {
	fake.checkPrerequisitesMutex.Lock()
	defer fake.checkPrerequisitesMutex.Unlock()
	fake.CheckPrerequisitesStub = stub
}

func (fake *FakeStageClient) CheckPrerequisitesReturns(result1 error) {
	fake.checkPrerequisitesMutex.Lock()
	defer fake.checkPrerequisitesMutex.Unlock()
	fake.CheckPrerequisitesStub = nil
	fake.checkPrerequisitesReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageClient) CheckPrerequisitesReturnsOnCall(i int, result1 error) {
	fake.checkPrerequisitesMutex.Lock()
	defer fake.checkPrerequisitesMutex.Unlock()
	fake.CheckPrerequisitesStub = nil
	if fake.checkPrerequisitesReturnsOnCall == nil {
		fake.checkPrerequisitesReturnsOnCall = make(map[int]struct {
			result1 error
		})
	}
	fake.checkPrerequisitesReturnsOnCall[i] = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageClient) CheckReleaseBranchState() error {
	fake.checkReleaseBranchStateMutex.Lock()
	ret, specificReturn := fake.checkReleaseBranchStateReturnsOnCall[len(fake.checkReleaseBranchStateArgsForCall)]
	fake.checkReleaseBranchStateArgsForCall = append(fake.checkReleaseBranchStateArgsForCall, struct {
	}{})
	stub := fake.CheckReleaseBranchStateStub
	fakeReturns := fake.checkReleaseBranchStateReturns
	fake.recordInvocation("CheckReleaseBranchState", []interface{}{})
	fake.checkReleaseBranchStateMutex.Unlock()
	if stub != nil {
		return stub()
	}
	if specificReturn {
		return ret.result1
	}
	return fakeReturns.result1
}

func (fake *FakeStageClient) CheckReleaseBranchStateCallCount() int {
	fake.checkReleaseBranchStateMutex.RLock()
	defer fake.checkReleaseBranchStateMutex.RUnlock()
	return len(fake.checkReleaseBranchStateArgsForCall)
}

func (fake *FakeStageClient) CheckReleaseBranchStateCalls(stub func() error) {
	fake.checkReleaseBranchStateMutex.Lock()
	defer fake.checkReleaseBranchStateMutex.Unlock()
	fake.CheckReleaseBranchStateStub = stub
}

func (fake *FakeStageClient) CheckReleaseBranchStateReturns(result1 error) {
	fake.checkReleaseBranchStateMutex.Lock()
	defer fake.checkReleaseBranchStateMutex.Unlock()
	fake.CheckReleaseBranchStateStub = nil
	fake.checkReleaseBranchStateReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageClient) CheckReleaseBranchStateReturnsOnCall(i int, result1 error) {
	fake.checkReleaseBranchStateMutex.Lock()
	defer fake.checkReleaseBranchStateMutex.Unlock()
	fake.CheckReleaseBranchStateStub = nil
	if fake.checkReleaseBranchStateReturnsOnCall == nil {
		fake.checkReleaseBranchStateReturnsOnCall = make(map[int]struct {
			result1 error
		})
	}
	fake.checkReleaseBranchStateReturnsOnCall[i] = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageClient) GenerateChangelog() error {
	fake.generateChangelogMutex.Lock()
	ret, specificReturn := fake.generateChangelogReturnsOnCall[len(fake.generateChangelogArgsForCall)]
	fake.generateChangelogArgsForCall = append(fake.generateChangelogArgsForCall, struct {
	}{})
	stub := fake.GenerateChangelogStub
	fakeReturns := fake.generateChangelogReturns
	fake.recordInvocation("GenerateChangelog", []interface{}{})
	fake.generateChangelogMutex.Unlock()
	if stub != nil {
		return stub()
	}
	if specificReturn {
		return ret.result1
	}
	return fakeReturns.result1
}

func (fake *FakeStageClient) GenerateChangelogCallCount() int {
	fake.generateChangelogMutex.RLock()
	defer fake.generateChangelogMutex.RUnlock()
	return len(fake.generateChangelogArgsForCall)
}

func (fake *FakeStageClient) GenerateChangelogCalls(stub func() error) {
	fake.generateChangelogMutex.Lock()
	defer fake.generateChangelogMutex.Unlock()
	fake.GenerateChangelogStub = stub
}

func (fake *FakeStageClient) GenerateChangelogReturns(result1 error) {
	fake.generateChangelogMutex.Lock()
	defer fake.generateChangelogMutex.Unlock()
	fake.GenerateChangelogStub = nil
	fake.generateChangelogReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageClient) GenerateChangelogReturnsOnCall(i int, result1 error) {
	fake.generateChangelogMutex.Lock()
	defer fake.generateChangelogMutex.Unlock()
	fake.GenerateChangelogStub = nil
	if fake.generateChangelogReturnsOnCall == nil {
		fake.generateChangelogReturnsOnCall = make(map[int]struct {
			result1 error
		})
	}
	fake.generateChangelogReturnsOnCall[i] = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageClient) GenerateReleaseVersion() error {
	fake.generateReleaseVersionMutex.Lock()
	ret, specificReturn := fake.generateReleaseVersionReturnsOnCall[len(fake.generateReleaseVersionArgsForCall)]
	fake.generateReleaseVersionArgsForCall = append(fake.generateReleaseVersionArgsForCall, struct {
	}{})
	stub := fake.GenerateReleaseVersionStub
	fakeReturns := fake.generateReleaseVersionReturns
	fake.recordInvocation("GenerateReleaseVersion", []interface{}{})
	fake.generateReleaseVersionMutex.Unlock()
	if stub != nil {
		return stub()
	}
	if specificReturn {
		return ret.result1
	}
	return fakeReturns.result1
}

func (fake *FakeStageClient) GenerateReleaseVersionCallCount() int {
	fake.generateReleaseVersionMutex.RLock()
	defer fake.generateReleaseVersionMutex.RUnlock()
	return len(fake.generateReleaseVersionArgsForCall)
}

func (fake *FakeStageClient) GenerateReleaseVersionCalls(stub func() error) {
	fake.generateReleaseVersionMutex.Lock()
	defer fake.generateReleaseVersionMutex.Unlock()
	fake.GenerateReleaseVersionStub = stub
}

func (fake *FakeStageClient) GenerateReleaseVersionReturns(result1 error) {
	fake.generateReleaseVersionMutex.Lock()
	defer fake.generateReleaseVersionMutex.Unlock()
	fake.GenerateReleaseVersionStub = nil
	fake.generateReleaseVersionReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageClient) GenerateReleaseVersionReturnsOnCall(i int, result1 error) {
	fake.generateReleaseVersionMutex.Lock()
	defer fake.generateReleaseVersionMutex.Unlock()
	fake.GenerateReleaseVersionStub = nil
	if fake.generateReleaseVersionReturnsOnCall == nil {
		fake.generateReleaseVersionReturnsOnCall = make(map[int]struct {
			result1 error
		})
	}
	fake.generateReleaseVersionReturnsOnCall[i] = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageClient) InitLogFile() error {
	fake.initLogFileMutex.Lock()
	ret, specificReturn := fake.initLogFileReturnsOnCall[len(fake.initLogFileArgsForCall)]
	fake.initLogFileArgsForCall = append(fake.initLogFileArgsForCall, struct {
	}{})
	stub := fake.InitLogFileStub
	fakeReturns := fake.initLogFileReturns
	fake.recordInvocation("InitLogFile", []interface{}{})
	fake.initLogFileMutex.Unlock()
	if stub != nil {
		return stub()
	}
	if specificReturn {
		return ret.result1
	}
	return fakeReturns.result1
}

func (fake *FakeStageClient) InitLogFileCallCount() int {
	fake.initLogFileMutex.RLock()
	defer fake.initLogFileMutex.RUnlock()
	return len(fake.initLogFileArgsForCall)
}

func (fake *FakeStageClient) InitLogFileCalls(stub func() error) {
	fake.initLogFileMutex.Lock()
	defer fake.initLogFileMutex.Unlock()
	fake.InitLogFileStub = stub
}

func (fake *FakeStageClient) InitLogFileReturns(result1 error) {
	fake.initLogFileMutex.Lock()
	defer fake.initLogFileMutex.Unlock()
	fake.InitLogFileStub = nil
	fake.initLogFileReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageClient) InitLogFileReturnsOnCall(i int, result1 error) {
	fake.initLogFileMutex.Lock()
	defer fake.initLogFileMutex.Unlock()
	fake.InitLogFileStub = nil
	if fake.initLogFileReturnsOnCall == nil {
		fake.initLogFileReturnsOnCall = make(map[int]struct {
			result1 error
		})
	}
	fake.initLogFileReturnsOnCall[i] = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageClient) InitState() {
	fake.initStateMutex.Lock()
	fake.initStateArgsForCall = append(fake.initStateArgsForCall, struct {
	}{})
	stub := fake.InitStateStub
	fake.recordInvocation("InitState", []interface{}{})
	fake.initStateMutex.Unlock()
	if stub != nil {
		fake.InitStateStub()
	}
}

func (fake *FakeStageClient) InitStateCallCount() int {
	fake.initStateMutex.RLock()
	defer fake.initStateMutex.RUnlock()
	return len(fake.initStateArgsForCall)
}

func (fake *FakeStageClient) InitStateCalls(stub func()) {
	fake.initStateMutex.Lock()
	defer fake.initStateMutex.Unlock()
	fake.InitStateStub = stub
}

func (fake *FakeStageClient) PrepareWorkspace() error {
	fake.prepareWorkspaceMutex.Lock()
	ret, specificReturn := fake.prepareWorkspaceReturnsOnCall[len(fake.prepareWorkspaceArgsForCall)]
	fake.prepareWorkspaceArgsForCall = append(fake.prepareWorkspaceArgsForCall, struct {
	}{})
	stub := fake.PrepareWorkspaceStub
	fakeReturns := fake.prepareWorkspaceReturns
	fake.recordInvocation("PrepareWorkspace", []interface{}{})
	fake.prepareWorkspaceMutex.Unlock()
	if stub != nil {
		return stub()
	}
	if specificReturn {
		return ret.result1
	}
	return fakeReturns.result1
}

func (fake *FakeStageClient) PrepareWorkspaceCallCount() int {
	fake.prepareWorkspaceMutex.RLock()
	defer fake.prepareWorkspaceMutex.RUnlock()
	return len(fake.prepareWorkspaceArgsForCall)
}

func (fake *FakeStageClient) PrepareWorkspaceCalls(stub func() error) {
	fake.prepareWorkspaceMutex.Lock()
	defer fake.prepareWorkspaceMutex.Unlock()
	fake.PrepareWorkspaceStub = stub
}

func (fake *FakeStageClient) PrepareWorkspaceReturns(result1 error) {
	fake.prepareWorkspaceMutex.Lock()
	defer fake.prepareWorkspaceMutex.Unlock()
	fake.PrepareWorkspaceStub = nil
	fake.prepareWorkspaceReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageClient) PrepareWorkspaceReturnsOnCall(i int, result1 error) {
	fake.prepareWorkspaceMutex.Lock()
	defer fake.prepareWorkspaceMutex.Unlock()
	fake.PrepareWorkspaceStub = nil
	if fake.prepareWorkspaceReturnsOnCall == nil {
		fake.prepareWorkspaceReturnsOnCall = make(map[int]struct {
			result1 error
		})
	}
	fake.prepareWorkspaceReturnsOnCall[i] = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageClient) StageArtifacts() error {
	fake.stageArtifactsMutex.Lock()
	ret, specificReturn := fake.stageArtifactsReturnsOnCall[len(fake.stageArtifactsArgsForCall)]
	fake.stageArtifactsArgsForCall = append(fake.stageArtifactsArgsForCall, struct {
	}{})
	stub := fake.StageArtifactsStub
	fakeReturns := fake.stageArtifactsReturns
	fake.recordInvocation("StageArtifacts", []interface{}{})
	fake.stageArtifactsMutex.Unlock()
	if stub != nil {
		return stub()
	}
	if specificReturn {
		return ret.result1
	}
	return fakeReturns.result1
}

func (fake *FakeStageClient) StageArtifactsCallCount() int {
	fake.stageArtifactsMutex.RLock()
	defer fake.stageArtifactsMutex.RUnlock()
	return len(fake.stageArtifactsArgsForCall)
}

func (fake *FakeStageClient) StageArtifactsCalls(stub func() error) {
	fake.stageArtifactsMutex.Lock()
	defer fake.stageArtifactsMutex.Unlock()
	fake.StageArtifactsStub = stub
}

func (fake *FakeStageClient) StageArtifactsReturns(result1 error) {
	fake.stageArtifactsMutex.Lock()
	defer fake.stageArtifactsMutex.Unlock()
	fake.StageArtifactsStub = nil
	fake.stageArtifactsReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageClient) StageArtifactsReturnsOnCall(i int, result1 error) {
	fake.stageArtifactsMutex.Lock()
	defer fake.stageArtifactsMutex.Unlock()
	fake.StageArtifactsStub = nil
	if fake.stageArtifactsReturnsOnCall == nil {
		fake.stageArtifactsReturnsOnCall = make(map[int]struct {
			result1 error
		})
	}
	fake.stageArtifactsReturnsOnCall[i] = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageClient) Submit(arg1 bool) error {
	fake.submitMutex.Lock()
	ret, specificReturn := fake.submitReturnsOnCall[len(fake.submitArgsForCall)]
	fake.submitArgsForCall = append(fake.submitArgsForCall, struct {
		arg1 bool
	}{arg1})
	stub := fake.SubmitStub
	fakeReturns := fake.submitReturns
	fake.recordInvocation("Submit", []interface{}{arg1})
	fake.submitMutex.Unlock()
	if stub != nil {
		return stub(arg1)
	}
	if specificReturn {
		return ret.result1
	}
	return fakeReturns.result1
}

func (fake *FakeStageClient) SubmitCallCount() int {
	fake.submitMutex.RLock()
	defer fake.submitMutex.RUnlock()
	return len(fake.submitArgsForCall)
}

func (fake *FakeStageClient) SubmitCalls(stub func(bool) error) {
	fake.submitMutex.Lock()
	defer fake.submitMutex.Unlock()
	fake.SubmitStub = stub
}

func (fake *FakeStageClient) SubmitArgsForCall(i int) bool {
	fake.submitMutex.RLock()
	defer fake.submitMutex.RUnlock()
	argsForCall := fake.submitArgsForCall[i]
	return argsForCall.arg1
}

func (fake *FakeStageClient) SubmitReturns(result1 error) {
	fake.submitMutex.Lock()
	defer fake.submitMutex.Unlock()
	fake.SubmitStub = nil
	fake.submitReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageClient) SubmitReturnsOnCall(i int, result1 error) {
	fake.submitMutex.Lock()
	defer fake.submitMutex.Unlock()
	fake.SubmitStub = nil
	if fake.submitReturnsOnCall == nil {
		fake.submitReturnsOnCall = make(map[int]struct {
			result1 error
		})
	}
	fake.submitReturnsOnCall[i] = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageClient) TagRepository() error {
	fake.tagRepositoryMutex.Lock()
	ret, specificReturn := fake.tagRepositoryReturnsOnCall[len(fake.tagRepositoryArgsForCall)]
	fake.tagRepositoryArgsForCall = append(fake.tagRepositoryArgsForCall, struct {
	}{})
	stub := fake.TagRepositoryStub
	fakeReturns := fake.tagRepositoryReturns
	fake.recordInvocation("TagRepository", []interface{}{})
	fake.tagRepositoryMutex.Unlock()
	if stub != nil {
		return stub()
	}
	if specificReturn {
		return ret.result1
	}
	return fakeReturns.result1
}

func (fake *FakeStageClient) TagRepositoryCallCount() int {
	fake.tagRepositoryMutex.RLock()
	defer fake.tagRepositoryMutex.RUnlock()
	return len(fake.tagRepositoryArgsForCall)
}

func (fake *FakeStageClient) TagRepositoryCalls(stub func() error) {
	fake.tagRepositoryMutex.Lock()
	defer fake.tagRepositoryMutex.Unlock()
	fake.TagRepositoryStub = stub
}

func (fake *FakeStageClient) TagRepositoryReturns(result1 error) {
	fake.tagRepositoryMutex.Lock()
	defer fake.tagRepositoryMutex.Unlock()
	fake.TagRepositoryStub = nil
	fake.tagRepositoryReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageClient) TagRepositoryReturnsOnCall(i int, result1 error) {
	fake.tagRepositoryMutex.Lock()
	defer fake.tagRepositoryMutex.Unlock()
	fake.TagRepositoryStub = nil
	if fake.tagRepositoryReturnsOnCall == nil {
		fake.tagRepositoryReturnsOnCall = make(map[int]struct {
			result1 error
		})
	}
	fake.tagRepositoryReturnsOnCall[i] = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageClient) ValidateOptions() error {
	fake.validateOptionsMutex.Lock()
	ret, specificReturn := fake.validateOptionsReturnsOnCall[len(fake.validateOptionsArgsForCall)]
	fake.validateOptionsArgsForCall = append(fake.validateOptionsArgsForCall, struct {
	}{})
	stub := fake.ValidateOptionsStub
	fakeReturns := fake.validateOptionsReturns
	fake.recordInvocation("ValidateOptions", []interface{}{})
	fake.validateOptionsMutex.Unlock()
	if stub != nil {
		return stub()
	}
	if specificReturn {
		return ret.result1
	}
	return fakeReturns.result1
}

func (fake *FakeStageClient) ValidateOptionsCallCount() int {
	fake.validateOptionsMutex.RLock()
	defer fake.validateOptionsMutex.RUnlock()
	return len(fake.validateOptionsArgsForCall)
}

func (fake *FakeStageClient) ValidateOptionsCalls(stub func() error) {
	fake.validateOptionsMutex.Lock()
	defer fake.validateOptionsMutex.Unlock()
	fake.ValidateOptionsStub = stub
}

func (fake *FakeStageClient) ValidateOptionsReturns(result1 error) {
	fake.validateOptionsMutex.Lock()
	defer fake.validateOptionsMutex.Unlock()
	fake.ValidateOptionsStub = nil
	fake.validateOptionsReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageClient) ValidateOptionsReturnsOnCall(i int, result1 error) {
	fake.validateOptionsMutex.Lock()
	defer fake.validateOptionsMutex.Unlock()
	fake.ValidateOptionsStub = nil
	if fake.validateOptionsReturnsOnCall == nil {
		fake.validateOptionsReturnsOnCall = make(map[int]struct {
			result1 error
		})
	}
	fake.validateOptionsReturnsOnCall[i] = struct {
		result1 error
	}{result1}
}

func (fake *FakeStageClient) Invocations() map[string][][]interface{} {
	fake.invocationsMutex.RLock()
	defer fake.invocationsMutex.RUnlock()
	fake.buildMutex.RLock()
	defer fake.buildMutex.RUnlock()
	fake.checkPrerequisitesMutex.RLock()
	defer fake.checkPrerequisitesMutex.RUnlock()
	fake.checkReleaseBranchStateMutex.RLock()
	defer fake.checkReleaseBranchStateMutex.RUnlock()
	fake.generateChangelogMutex.RLock()
	defer fake.generateChangelogMutex.RUnlock()
	fake.generateReleaseVersionMutex.RLock()
	defer fake.generateReleaseVersionMutex.RUnlock()
	fake.initLogFileMutex.RLock()
	defer fake.initLogFileMutex.RUnlock()
	fake.initStateMutex.RLock()
	defer fake.initStateMutex.RUnlock()
	fake.prepareWorkspaceMutex.RLock()
	defer fake.prepareWorkspaceMutex.RUnlock()
	fake.stageArtifactsMutex.RLock()
	defer fake.stageArtifactsMutex.RUnlock()
	fake.submitMutex.RLock()
	defer fake.submitMutex.RUnlock()
	fake.tagRepositoryMutex.RLock()
	defer fake.tagRepositoryMutex.RUnlock()
	fake.validateOptionsMutex.RLock()
	defer fake.validateOptionsMutex.RUnlock()
	copiedInvocations := map[string][][]interface{}{}
	for key, value := range fake.invocations {
		copiedInvocations[key] = value
	}
	return copiedInvocations
}

func (fake *FakeStageClient) recordInvocation(key string, args []interface{}) {
	fake.invocationsMutex.Lock()
	defer fake.invocationsMutex.Unlock()
	if fake.invocations == nil {
		fake.invocations = map[string][][]interface{}{}
	}
	if fake.invocations[key] == nil {
		fake.invocations[key] = [][]interface{}{}
	}
	fake.invocations[key] = append(fake.invocations[key], args)
}
