/*
Copyright 2020 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by counterfeiter. DO NOT EDIT.
package gcbfakes

import (
	"sync"
	"time"

	cloudbuild "google.golang.org/api/cloudbuild/v1"
)

type FakeHistoryImpl struct {
	GetJobsByTagStub        func(string, string) ([]*cloudbuild.Build, error)
	getJobsByTagMutex       sync.RWMutex
	getJobsByTagArgsForCall []struct {
		arg1 string
		arg2 string
	}
	getJobsByTagReturns struct {
		result1 []*cloudbuild.Build
		result2 error
	}
	getJobsByTagReturnsOnCall map[int]struct {
		result1 []*cloudbuild.Build
		result2 error
	}
	ParseTimeStub        func(string, string) (time.Time, error)
	parseTimeMutex       sync.RWMutex
	parseTimeArgsForCall []struct {
		arg1 string
		arg2 string
	}
	parseTimeReturns struct {
		result1 time.Time
		result2 error
	}
	parseTimeReturnsOnCall map[int]struct {
		result1 time.Time
		result2 error
	}
	invocations      map[string][][]interface{}
	invocationsMutex sync.RWMutex
}

func (fake *FakeHistoryImpl) GetJobsByTag(arg1 string, arg2 string) ([]*cloudbuild.Build, error) {
	fake.getJobsByTagMutex.Lock()
	ret, specificReturn := fake.getJobsByTagReturnsOnCall[len(fake.getJobsByTagArgsForCall)]
	fake.getJobsByTagArgsForCall = append(fake.getJobsByTagArgsForCall, struct {
		arg1 string
		arg2 string
	}{arg1, arg2})
	stub := fake.GetJobsByTagStub
	fakeReturns := fake.getJobsByTagReturns
	fake.recordInvocation("GetJobsByTag", []interface{}{arg1, arg2})
	fake.getJobsByTagMutex.Unlock()
	if stub != nil {
		return stub(arg1, arg2)
	}
	if specificReturn {
		return ret.result1, ret.result2
	}
	return fakeReturns.result1, fakeReturns.result2
}

func (fake *FakeHistoryImpl) GetJobsByTagCallCount() int {
	fake.getJobsByTagMutex.RLock()
	defer fake.getJobsByTagMutex.RUnlock()
	return len(fake.getJobsByTagArgsForCall)
}

func (fake *FakeHistoryImpl) GetJobsByTagCalls(stub func(string, string) ([]*cloudbuild.Build, error)) {
	fake.getJobsByTagMutex.Lock()
	defer fake.getJobsByTagMutex.Unlock()
	fake.GetJobsByTagStub = stub
}

func (fake *FakeHistoryImpl) GetJobsByTagArgsForCall(i int) (string, string) {
	fake.getJobsByTagMutex.RLock()
	defer fake.getJobsByTagMutex.RUnlock()
	argsForCall := fake.getJobsByTagArgsForCall[i]
	return argsForCall.arg1, argsForCall.arg2
}

func (fake *FakeHistoryImpl) GetJobsByTagReturns(result1 []*cloudbuild.Build, result2 error) {
	fake.getJobsByTagMutex.Lock()
	defer fake.getJobsByTagMutex.Unlock()
	fake.GetJobsByTagStub = nil
	fake.getJobsByTagReturns = struct {
		result1 []*cloudbuild.Build
		result2 error
	}{result1, result2}
}

func (fake *FakeHistoryImpl) GetJobsByTagReturnsOnCall(i int, result1 []*cloudbuild.Build, result2 error) {
	fake.getJobsByTagMutex.Lock()
	defer fake.getJobsByTagMutex.Unlock()
	fake.GetJobsByTagStub = nil
	if fake.getJobsByTagReturnsOnCall == nil {
		fake.getJobsByTagReturnsOnCall = make(map[int]struct {
			result1 []*cloudbuild.Build
			result2 error
		})
	}
	fake.getJobsByTagReturnsOnCall[i] = struct {
		result1 []*cloudbuild.Build
		result2 error
	}{result1, result2}
}

func (fake *FakeHistoryImpl) ParseTime(arg1 string, arg2 string) (time.Time, error) {
	fake.parseTimeMutex.Lock()
	ret, specificReturn := fake.parseTimeReturnsOnCall[len(fake.parseTimeArgsForCall)]
	fake.parseTimeArgsForCall = append(fake.parseTimeArgsForCall, struct {
		arg1 string
		arg2 string
	}{arg1, arg2})
	stub := fake.ParseTimeStub
	fakeReturns := fake.parseTimeReturns
	fake.recordInvocation("ParseTime", []interface{}{arg1, arg2})
	fake.parseTimeMutex.Unlock()
	if stub != nil {
		return stub(arg1, arg2)
	}
	if specificReturn {
		return ret.result1, ret.result2
	}
	return fakeReturns.result1, fakeReturns.result2
}

func (fake *FakeHistoryImpl) ParseTimeCallCount() int {
	fake.parseTimeMutex.RLock()
	defer fake.parseTimeMutex.RUnlock()
	return len(fake.parseTimeArgsForCall)
}

func (fake *FakeHistoryImpl) ParseTimeCalls(stub func(string, string) (time.Time, error)) {
	fake.parseTimeMutex.Lock()
	defer fake.parseTimeMutex.Unlock()
	fake.ParseTimeStub = stub
}

func (fake *FakeHistoryImpl) ParseTimeArgsForCall(i int) (string, string) {
	fake.parseTimeMutex.RLock()
	defer fake.parseTimeMutex.RUnlock()
	argsForCall := fake.parseTimeArgsForCall[i]
	return argsForCall.arg1, argsForCall.arg2
}

func (fake *FakeHistoryImpl) ParseTimeReturns(result1 time.Time, result2 error) {
	fake.parseTimeMutex.Lock()
	defer fake.parseTimeMutex.Unlock()
	fake.ParseTimeStub = nil
	fake.parseTimeReturns = struct {
		result1 time.Time
		result2 error
	}{result1, result2}
}

func (fake *FakeHistoryImpl) ParseTimeReturnsOnCall(i int, result1 time.Time, result2 error) {
	fake.parseTimeMutex.Lock()
	defer fake.parseTimeMutex.Unlock()
	fake.ParseTimeStub = nil
	if fake.parseTimeReturnsOnCall == nil {
		fake.parseTimeReturnsOnCall = make(map[int]struct {
			result1 time.Time
			result2 error
		})
	}
	fake.parseTimeReturnsOnCall[i] = struct {
		result1 time.Time
		result2 error
	}{result1, result2}
}

func (fake *FakeHistoryImpl) Invocations() map[string][][]interface{} {
	fake.invocationsMutex.RLock()
	defer fake.invocationsMutex.RUnlock()
	fake.getJobsByTagMutex.RLock()
	defer fake.getJobsByTagMutex.RUnlock()
	fake.parseTimeMutex.RLock()
	defer fake.parseTimeMutex.RUnlock()
	copiedInvocations := map[string][][]interface{}{}
	for key, value := range fake.invocations {
		copiedInvocations[key] = value
	}
	return copiedInvocations
}

func (fake *FakeHistoryImpl) recordInvocation(key string, args []interface{}) {
	fake.invocationsMutex.Lock()
	defer fake.invocationsMutex.Unlock()
	if fake.invocations == nil {
		fake.invocations = map[string][][]interface{}{}
	}
	if fake.invocations[key] == nil {
		fake.invocations[key] = [][]interface{}{}
	}
	fake.invocations[key] = append(fake.invocations[key], args)
}
