/*
Copyright 2020 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by counterfeiter. DO NOT EDIT.
package gcbfakes

import (
	"sync"

	"k8s.io/release/pkg/gcp/gcb"
)

type FakeListJobs struct {
	ListJobsStub        func(string, int64) error
	listJobsMutex       sync.RWMutex
	listJobsArgsForCall []struct {
		arg1 string
		arg2 int64
	}
	listJobsReturns struct {
		result1 error
	}
	listJobsReturnsOnCall map[int]struct {
		result1 error
	}
	invocations      map[string][][]interface{}
	invocationsMutex sync.RWMutex
}

func (fake *FakeListJobs) ListJobs(arg1 string, arg2 int64) error {
	fake.listJobsMutex.Lock()
	ret, specificReturn := fake.listJobsReturnsOnCall[len(fake.listJobsArgsForCall)]
	fake.listJobsArgsForCall = append(fake.listJobsArgsForCall, struct {
		arg1 string
		arg2 int64
	}{arg1, arg2})
	stub := fake.ListJobsStub
	fakeReturns := fake.listJobsReturns
	fake.recordInvocation("ListJobs", []interface{}{arg1, arg2})
	fake.listJobsMutex.Unlock()
	if stub != nil {
		return stub(arg1, arg2)
	}
	if specificReturn {
		return ret.result1
	}
	return fakeReturns.result1
}

func (fake *FakeListJobs) ListJobsCallCount() int {
	fake.listJobsMutex.RLock()
	defer fake.listJobsMutex.RUnlock()
	return len(fake.listJobsArgsForCall)
}

func (fake *FakeListJobs) ListJobsCalls(stub func(string, int64) error) {
	fake.listJobsMutex.Lock()
	defer fake.listJobsMutex.Unlock()
	fake.ListJobsStub = stub
}

func (fake *FakeListJobs) ListJobsArgsForCall(i int) (string, int64) {
	fake.listJobsMutex.RLock()
	defer fake.listJobsMutex.RUnlock()
	argsForCall := fake.listJobsArgsForCall[i]
	return argsForCall.arg1, argsForCall.arg2
}

func (fake *FakeListJobs) ListJobsReturns(result1 error) {
	fake.listJobsMutex.Lock()
	defer fake.listJobsMutex.Unlock()
	fake.ListJobsStub = nil
	fake.listJobsReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeListJobs) ListJobsReturnsOnCall(i int, result1 error) {
	fake.listJobsMutex.Lock()
	defer fake.listJobsMutex.Unlock()
	fake.ListJobsStub = nil
	if fake.listJobsReturnsOnCall == nil {
		fake.listJobsReturnsOnCall = make(map[int]struct {
			result1 error
		})
	}
	fake.listJobsReturnsOnCall[i] = struct {
		result1 error
	}{result1}
}

func (fake *FakeListJobs) Invocations() map[string][][]interface{} {
	fake.invocationsMutex.RLock()
	defer fake.invocationsMutex.RUnlock()
	fake.listJobsMutex.RLock()
	defer fake.listJobsMutex.RUnlock()
	copiedInvocations := map[string][][]interface{}{}
	for key, value := range fake.invocations {
		copiedInvocations[key] = value
	}
	return copiedInvocations
}

func (fake *FakeListJobs) recordInvocation(key string, args []interface{}) {
	fake.invocationsMutex.Lock()
	defer fake.invocationsMutex.Unlock()
	if fake.invocations == nil {
		fake.invocations = map[string][][]interface{}{}
	}
	if fake.invocations[key] == nil {
		fake.invocations[key] = [][]interface{}{}
	}
	fake.invocations[key] = append(fake.invocations[key], args)
}

var _ gcb.ListJobs = new(FakeListJobs)
