/*
Copyright 2020 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by counterfeiter. DO NOT EDIT.
package gcbfakes

import (
	"sync"

	"k8s.io/release/pkg/gcp/gcb"
	"k8s.io/release/pkg/release"
)

type FakeVersion struct {
	GetKubeVersionForBranchStub        func(release.VersionType, string) (string, error)
	getKubeVersionForBranchMutex       sync.RWMutex
	getKubeVersionForBranchArgsForCall []struct {
		arg1 release.VersionType
		arg2 string
	}
	getKubeVersionForBranchReturns struct {
		result1 string
		result2 error
	}
	getKubeVersionForBranchReturnsOnCall map[int]struct {
		result1 string
		result2 error
	}
	invocations      map[string][][]interface{}
	invocationsMutex sync.RWMutex
}

func (fake *FakeVersion) GetKubeVersionForBranch(arg1 release.VersionType, arg2 string) (string, error) {
	fake.getKubeVersionForBranchMutex.Lock()
	ret, specificReturn := fake.getKubeVersionForBranchReturnsOnCall[len(fake.getKubeVersionForBranchArgsForCall)]
	fake.getKubeVersionForBranchArgsForCall = append(fake.getKubeVersionForBranchArgsForCall, struct {
		arg1 release.VersionType
		arg2 string
	}{arg1, arg2})
	stub := fake.GetKubeVersionForBranchStub
	fakeReturns := fake.getKubeVersionForBranchReturns
	fake.recordInvocation("GetKubeVersionForBranch", []interface{}{arg1, arg2})
	fake.getKubeVersionForBranchMutex.Unlock()
	if stub != nil {
		return stub(arg1, arg2)
	}
	if specificReturn {
		return ret.result1, ret.result2
	}
	return fakeReturns.result1, fakeReturns.result2
}

func (fake *FakeVersion) GetKubeVersionForBranchCallCount() int {
	fake.getKubeVersionForBranchMutex.RLock()
	defer fake.getKubeVersionForBranchMutex.RUnlock()
	return len(fake.getKubeVersionForBranchArgsForCall)
}

func (fake *FakeVersion) GetKubeVersionForBranchCalls(stub func(release.VersionType, string) (string, error)) {
	fake.getKubeVersionForBranchMutex.Lock()
	defer fake.getKubeVersionForBranchMutex.Unlock()
	fake.GetKubeVersionForBranchStub = stub
}

func (fake *FakeVersion) GetKubeVersionForBranchArgsForCall(i int) (release.VersionType, string) {
	fake.getKubeVersionForBranchMutex.RLock()
	defer fake.getKubeVersionForBranchMutex.RUnlock()
	argsForCall := fake.getKubeVersionForBranchArgsForCall[i]
	return argsForCall.arg1, argsForCall.arg2
}

func (fake *FakeVersion) GetKubeVersionForBranchReturns(result1 string, result2 error) {
	fake.getKubeVersionForBranchMutex.Lock()
	defer fake.getKubeVersionForBranchMutex.Unlock()
	fake.GetKubeVersionForBranchStub = nil
	fake.getKubeVersionForBranchReturns = struct {
		result1 string
		result2 error
	}{result1, result2}
}

func (fake *FakeVersion) GetKubeVersionForBranchReturnsOnCall(i int, result1 string, result2 error) {
	fake.getKubeVersionForBranchMutex.Lock()
	defer fake.getKubeVersionForBranchMutex.Unlock()
	fake.GetKubeVersionForBranchStub = nil
	if fake.getKubeVersionForBranchReturnsOnCall == nil {
		fake.getKubeVersionForBranchReturnsOnCall = make(map[int]struct {
			result1 string
			result2 error
		})
	}
	fake.getKubeVersionForBranchReturnsOnCall[i] = struct {
		result1 string
		result2 error
	}{result1, result2}
}

func (fake *FakeVersion) Invocations() map[string][][]interface{} {
	fake.invocationsMutex.RLock()
	defer fake.invocationsMutex.RUnlock()
	fake.getKubeVersionForBranchMutex.RLock()
	defer fake.getKubeVersionForBranchMutex.RUnlock()
	copiedInvocations := map[string][][]interface{}{}
	for key, value := range fake.invocations {
		copiedInvocations[key] = value
	}
	return copiedInvocations
}

func (fake *FakeVersion) recordInvocation(key string, args []interface{}) {
	fake.invocationsMutex.Lock()
	defer fake.invocationsMutex.Unlock()
	if fake.invocations == nil {
		fake.invocations = map[string][][]interface{}{}
	}
	if fake.invocations[key] == nil {
		fake.invocations[key] = [][]interface{}{}
	}
	fake.invocations[key] = append(fake.invocations[key], args)
}

var _ gcb.Version = new(FakeVersion)
