/*
Copyright 2020 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by counterfeiter. DO NOT EDIT.
package mailfakes

import (
	"sync"

	"github.com/sendgrid/rest"
	"k8s.io/release/pkg/mail"
)

type FakeAPIClient struct {
	APIStub        func(rest.Request) (*rest.Response, error)
	aPIMutex       sync.RWMutex
	aPIArgsForCall []struct {
		arg1 rest.Request
	}
	aPIReturns struct {
		result1 *rest.Response
		result2 error
	}
	aPIReturnsOnCall map[int]struct {
		result1 *rest.Response
		result2 error
	}
	invocations      map[string][][]interface{}
	invocationsMutex sync.RWMutex
}

func (fake *FakeAPIClient) API(arg1 rest.Request) (*rest.Response, error) {
	fake.aPIMutex.Lock()
	ret, specificReturn := fake.aPIReturnsOnCall[len(fake.aPIArgsForCall)]
	fake.aPIArgsForCall = append(fake.aPIArgsForCall, struct {
		arg1 rest.Request
	}{arg1})
	stub := fake.APIStub
	fakeReturns := fake.aPIReturns
	fake.recordInvocation("API", []interface{}{arg1})
	fake.aPIMutex.Unlock()
	if stub != nil {
		return stub(arg1)
	}
	if specificReturn {
		return ret.result1, ret.result2
	}
	return fakeReturns.result1, fakeReturns.result2
}

func (fake *FakeAPIClient) APICallCount() int {
	fake.aPIMutex.RLock()
	defer fake.aPIMutex.RUnlock()
	return len(fake.aPIArgsForCall)
}

func (fake *FakeAPIClient) APICalls(stub func(rest.Request) (*rest.Response, error)) {
	fake.aPIMutex.Lock()
	defer fake.aPIMutex.Unlock()
	fake.APIStub = stub
}

func (fake *FakeAPIClient) APIArgsForCall(i int) rest.Request {
	fake.aPIMutex.RLock()
	defer fake.aPIMutex.RUnlock()
	argsForCall := fake.aPIArgsForCall[i]
	return argsForCall.arg1
}

func (fake *FakeAPIClient) APIReturns(result1 *rest.Response, result2 error) {
	fake.aPIMutex.Lock()
	defer fake.aPIMutex.Unlock()
	fake.APIStub = nil
	fake.aPIReturns = struct {
		result1 *rest.Response
		result2 error
	}{result1, result2}
}

func (fake *FakeAPIClient) APIReturnsOnCall(i int, result1 *rest.Response, result2 error) {
	fake.aPIMutex.Lock()
	defer fake.aPIMutex.Unlock()
	fake.APIStub = nil
	if fake.aPIReturnsOnCall == nil {
		fake.aPIReturnsOnCall = make(map[int]struct {
			result1 *rest.Response
			result2 error
		})
	}
	fake.aPIReturnsOnCall[i] = struct {
		result1 *rest.Response
		result2 error
	}{result1, result2}
}

func (fake *FakeAPIClient) Invocations() map[string][][]interface{} {
	fake.invocationsMutex.RLock()
	defer fake.invocationsMutex.RUnlock()
	fake.aPIMutex.RLock()
	defer fake.aPIMutex.RUnlock()
	copiedInvocations := map[string][][]interface{}{}
	for key, value := range fake.invocations {
		copiedInvocations[key] = value
	}
	return copiedInvocations
}

func (fake *FakeAPIClient) recordInvocation(key string, args []interface{}) {
	fake.invocationsMutex.Lock()
	defer fake.invocationsMutex.Unlock()
	if fake.invocations == nil {
		fake.invocations = map[string][][]interface{}{}
	}
	if fake.invocations[key] == nil {
		fake.invocations[key] = [][]interface{}{}
	}
	fake.invocations[key] = append(fake.invocations[key], args)
}

var _ mail.APIClient = new(FakeAPIClient)
