---
title: v1.4.0
weight: 998996000
---

## Change your operator's finalizer names

The finalizer name format suggested by [Kubernetes docs](https://kubernetes.io/docs/tasks/extend-kubernetes/custom-resources/custom-resource-definitions/#finalizers) is `<qualified-group>/<finalizer-name>`, while the format previously documented by Operator SDK docs was `<finalizer-name>.<qualified-group>`. If your operator uses any finalizers with names matching the incorrect format, change them to match the official format. For example, `finalizer.cache.example.com` should be changed to `cache.example.com/finalizer`.

_See [#4472](https://github.com/operator-framework/operator-sdk/pull/4472) for more details._

## For Helm and Ansible projects, fix the helm-operator and ansible-operator URLs in the Makefile

- Helm projects:
	Old: `https://github.com/operator-framework/operator-sdk/releases/download/v1.3.0/helm-operator-v1.3.0-$(ARCHOPER)-$(OSOPER)`
	New: `https://github.com/operator-framework/operator-sdk/releases/download/v1.3.1/helm-operator_$(OS)_$(ARCH)`
- Ansible projects:
	Old: `https://github.com/operator-framework/operator-sdk/releases/download/v1.3.0/ansible-operator-v1.3.0-$(ARCHOPER)-$(OSOPER)`
	New: `https://github.com/operator-framework/operator-sdk/releases/download/v1.3.1/ansible-operator_$(OS)_$(ARCH)`

_See [#4407](https://github.com/operator-framework/operator-sdk/pull/4407) for more details._

## For Helm and Ansible projects, fix the `helm-operator`, `ansible-operator`, and `kustomize` Makefile rules

These rules will download a local binary but not use it if a global binary is present.
See the diff in [this PR](https://github.com/operator-framework/operator-sdk/pull/4407) for how to fix this.

_See [#4412](https://github.com/operator-framework/operator-sdk/pull/4407) for more details._

## For Helm-based operators, add Liveness and Readiness probe

New projects built with the tool will have the probes configured by default. The endpoints `/healthz` and `/readyz` are available now in the image based provided.
You can update your pre-existing project to use them. For that update the Dockerfile to use the latest release base image, then add the following to the `manager` container in `config/default/manager/manager.yaml`:
```yaml
  livenessProbe:
    httpGet:
      path: /healthz
      port: 8081
    initialDelaySeconds: 15
    periodSeconds: 20
  readinessProbe:
    httpGet:
      path: /readyz
      port: 8081
    initialDelaySeconds: 5
    periodSeconds: 10
```

_See [#4326](https://github.com/operator-framework/operator-sdk/pull/4326) for more details._

## For Ansible-based operators, add Liveness and Readiness probe

New projects built with the tool will have the probes configured by default. The endpoints `/healthz` and `/readyz` are available now in the image based provided.
You can update your pre-existing project to use them. For that update the Dockerfile to use the latest release base image, then add the following to the `manager` container in `config/default/manager/manager.yaml`:
```yaml
  livenessProbe:
    httpGet:
      path: /healthz
      port: 6789
    initialDelaySeconds: 15
    periodSeconds: 20
  readinessProbe:
    httpGet:
      path: /readyz
      port: 6789
    initialDelaySeconds: 5
    periodSeconds: 10
```

_See [#4326](https://github.com/operator-framework/operator-sdk/pull/4326) for more details._

## (go/v2) Change `go` PROJECT plugin object to `manifests` and `scorecard` objects

The `manifests` and `scorecard` plugins that create OLM and scorecard manifests, respectively, now have plugin objects that direct `create` subcommands to create related files. While the old `go` plugin configuration object is still supported, these new objects will be useful in the future as configuration options are added to their respective plugins:

Old:
```yaml
version: 3-alpha
...
plugins:
  go.sdk.operatorframework.io/v2-alpha: {}
```

New:
```yaml
version: 3-alpha
...
plugins:
  manifests.sdk.operatorframework.io/v2: {}
  scorecard.sdk.operatorframework.io/v2: {}
```

_See [#4419](https://github.com/operator-framework/operator-sdk/pull/4419) for more details._

## (ansible/v1, helm/v1) Add `manifests` and `scorecard` plugin objects to your PROJECT

The `manifests` and `scorecard` plugins that create OLM and scorecard manifests, respectively, now have plugin objects that direct `create` subcommands to create related files. While not necessary to add, these new plugin configuration objects in the PROJECT file will be useful in the future as configuration options are added to their respective plugins:
```yaml
version: 3-alpha
...
plugins:
  manifests.sdk.operatorframework.io/v2: {}
  scorecard.sdk.operatorframework.io/v2: {}
```

_See [#4419](https://github.com/operator-framework/operator-sdk/pull/4419) for more details._

## Move positional directory argument `.` in `docker-build` make target

The directory argument `.` in the `docker-build` make target was moved to the last positional argument to align with `podman`'s expectations, making substitution cleaner.

Old:
```make
docker-build:
  docker build . -t ${IMG}
```

New:
```make
docker-build:
  docker build -t ${IMG} .
```

Alternatively, you could replace it programmatically
```sh
sed -i 's/docker build . -t ${IMG}/docker build -t ${IMG} ./' $(git grep -l 'docker.*build \. ')
```

_See [#4466](https://github.com/operator-framework/operator-sdk/pull/4466) for more details._
