package compute

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"net/http"
)

// OperationalizationClustersClient is the these APIs allow end users to operate on Azure Machine Learning Compute
// resources. They support the following operations:<ul><li>Create or update a cluster</li><li>Get a
// cluster</li><li>Patch a cluster</li><li>Delete a cluster</li><li>Get keys for a cluster</li><li>Check if updates are
// available for system services in a cluster</li><li>Update system services in a cluster</li><li>Get all clusters in a
// resource group</li><li>Get all clusters in a subscription</li></ul>
type OperationalizationClustersClient struct {
	BaseClient
}

// NewOperationalizationClustersClient creates an instance of the OperationalizationClustersClient client.
func NewOperationalizationClustersClient(subscriptionID string) OperationalizationClustersClient {
	return NewOperationalizationClustersClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewOperationalizationClustersClientWithBaseURI creates an instance of the OperationalizationClustersClient client.
func NewOperationalizationClustersClientWithBaseURI(baseURI string, subscriptionID string) OperationalizationClustersClient {
	return OperationalizationClustersClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// CheckUpdate checks if updates are available for system services in the cluster
//
// resourceGroupName is name of the resource group in which the cluster is located. clusterName is the name of the
// cluster.
func (client OperationalizationClustersClient) CheckUpdate(ctx context.Context, resourceGroupName string, clusterName string) (result OperationalizationClustersCheckUpdateFuture, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}},
		{TargetValue: clusterName,
			Constraints: []validation.Constraint{{Target: "clusterName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "clusterName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "clusterName", Name: validation.Pattern, Rule: `^[a-zA-Z][-\w\._\(\)]+[a-zA-Z0-9]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("compute.OperationalizationClustersClient", "CheckUpdate", err.Error())
	}

	req, err := client.CheckUpdatePreparer(ctx, resourceGroupName, clusterName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.OperationalizationClustersClient", "CheckUpdate", nil, "Failure preparing request")
		return
	}

	result, err = client.CheckUpdateSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.OperationalizationClustersClient", "CheckUpdate", result.Response(), "Failure sending request")
		return
	}

	return
}

// CheckUpdatePreparer prepares the CheckUpdate request.
func (client OperationalizationClustersClient) CheckUpdatePreparer(ctx context.Context, resourceGroupName string, clusterName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"clusterName":       autorest.Encode("path", clusterName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2017-06-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningCompute/operationalizationClusters/{clusterName}/checkUpdate", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CheckUpdateSender sends the CheckUpdate request. The method will close the
// http.Response Body if it receives an error.
func (client OperationalizationClustersClient) CheckUpdateSender(req *http.Request) (future OperationalizationClustersCheckUpdateFuture, err error) {
	sender := autorest.DecorateSender(client, azure.DoRetryWithRegistration(client.Client))
	future.Future = azure.NewFuture(req)
	future.req = req
	_, err = future.Done(sender)
	if err != nil {
		return
	}
	err = autorest.Respond(future.Response(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted))
	return
}

// CheckUpdateResponder handles the response to the CheckUpdate request. The method always
// closes the http.Response Body.
func (client OperationalizationClustersClient) CheckUpdateResponder(resp *http.Response) (result CheckUpdateResponse, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdate create or update an operationalization cluster.
//
// resourceGroupName is name of the resource group in which the cluster is located. clusterName is the name of the
// cluster. parameters is parameters supplied to create or update an Operationalization cluster.
func (client OperationalizationClustersClient) CreateOrUpdate(ctx context.Context, resourceGroupName string, clusterName string, parameters OperationalizationCluster) (result OperationalizationClustersCreateOrUpdateFuture, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}},
		{TargetValue: clusterName,
			Constraints: []validation.Constraint{{Target: "clusterName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "clusterName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "clusterName", Name: validation.Pattern, Rule: `^[a-zA-Z][-\w\._\(\)]+[a-zA-Z0-9]$`, Chain: nil}}},
		{TargetValue: parameters,
			Constraints: []validation.Constraint{{Target: "parameters.OperationalizationClusterProperties", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "parameters.OperationalizationClusterProperties.ClusterType", Name: validation.Null, Rule: true, Chain: nil},
					{Target: "parameters.OperationalizationClusterProperties.ContainerService", Name: validation.Null, Rule: true,
						Chain: []validation.Constraint{{Target: "parameters.OperationalizationClusterProperties.ContainerService.OrchestratorType", Name: validation.Null, Rule: true, Chain: nil},
							{Target: "parameters.OperationalizationClusterProperties.ContainerService.OrchestratorProperties", Name: validation.Null, Rule: true,
								Chain: []validation.Constraint{{Target: "parameters.OperationalizationClusterProperties.ContainerService.OrchestratorProperties.ServicePrincipal", Name: validation.Null, Rule: true,
									Chain: []validation.Constraint{{Target: "parameters.OperationalizationClusterProperties.ContainerService.OrchestratorProperties.ServicePrincipal.ClientID", Name: validation.Null, Rule: true, Chain: nil},
										{Target: "parameters.OperationalizationClusterProperties.ContainerService.OrchestratorProperties.ServicePrincipal.Secret", Name: validation.Null, Rule: true, Chain: nil},
									}},
								}},
							{Target: "parameters.OperationalizationClusterProperties.ContainerService.AgentCount", Name: validation.Null, Rule: false,
								Chain: []validation.Constraint{{Target: "parameters.OperationalizationClusterProperties.ContainerService.AgentCount", Name: validation.InclusiveMaximum, Rule: 100, Chain: nil},
									{Target: "parameters.OperationalizationClusterProperties.ContainerService.AgentCount", Name: validation.InclusiveMinimum, Rule: 1, Chain: nil},
								}},
						}},
					{Target: "parameters.OperationalizationClusterProperties.GlobalServiceConfiguration", Name: validation.Null, Rule: false,
						Chain: []validation.Constraint{{Target: "parameters.OperationalizationClusterProperties.GlobalServiceConfiguration.ServiceAuth", Name: validation.Null, Rule: false,
							Chain: []validation.Constraint{{Target: "parameters.OperationalizationClusterProperties.GlobalServiceConfiguration.ServiceAuth.PrimaryAuthKeyHash", Name: validation.Null, Rule: true, Chain: nil},
								{Target: "parameters.OperationalizationClusterProperties.GlobalServiceConfiguration.ServiceAuth.SecondaryAuthKeyHash", Name: validation.Null, Rule: true, Chain: nil},
							}},
							{Target: "parameters.OperationalizationClusterProperties.GlobalServiceConfiguration.AutoScale", Name: validation.Null, Rule: false,
								Chain: []validation.Constraint{{Target: "parameters.OperationalizationClusterProperties.GlobalServiceConfiguration.AutoScale.MinReplicas", Name: validation.Null, Rule: false,
									Chain: []validation.Constraint{{Target: "parameters.OperationalizationClusterProperties.GlobalServiceConfiguration.AutoScale.MinReplicas", Name: validation.InclusiveMinimum, Rule: 1, Chain: nil}}},
									{Target: "parameters.OperationalizationClusterProperties.GlobalServiceConfiguration.AutoScale.MaxReplicas", Name: validation.Null, Rule: false,
										Chain: []validation.Constraint{{Target: "parameters.OperationalizationClusterProperties.GlobalServiceConfiguration.AutoScale.MaxReplicas", Name: validation.InclusiveMinimum, Rule: 1, Chain: nil}}},
								}},
						}},
				}}}}}); err != nil {
		return result, validation.NewError("compute.OperationalizationClustersClient", "CreateOrUpdate", err.Error())
	}

	req, err := client.CreateOrUpdatePreparer(ctx, resourceGroupName, clusterName, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.OperationalizationClustersClient", "CreateOrUpdate", nil, "Failure preparing request")
		return
	}

	result, err = client.CreateOrUpdateSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.OperationalizationClustersClient", "CreateOrUpdate", result.Response(), "Failure sending request")
		return
	}

	return
}

// CreateOrUpdatePreparer prepares the CreateOrUpdate request.
func (client OperationalizationClustersClient) CreateOrUpdatePreparer(ctx context.Context, resourceGroupName string, clusterName string, parameters OperationalizationCluster) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"clusterName":       autorest.Encode("path", clusterName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2017-06-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningCompute/operationalizationClusters/{clusterName}", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateSender sends the CreateOrUpdate request. The method will close the
// http.Response Body if it receives an error.
func (client OperationalizationClustersClient) CreateOrUpdateSender(req *http.Request) (future OperationalizationClustersCreateOrUpdateFuture, err error) {
	sender := autorest.DecorateSender(client, azure.DoRetryWithRegistration(client.Client))
	future.Future = azure.NewFuture(req)
	future.req = req
	_, err = future.Done(sender)
	if err != nil {
		return
	}
	err = autorest.Respond(future.Response(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated))
	return
}

// CreateOrUpdateResponder handles the response to the CreateOrUpdate request. The method always
// closes the http.Response Body.
func (client OperationalizationClustersClient) CreateOrUpdateResponder(resp *http.Response) (result OperationalizationCluster, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Delete deletes the specified cluster.
//
// resourceGroupName is name of the resource group in which the cluster is located. clusterName is the name of the
// cluster.
func (client OperationalizationClustersClient) Delete(ctx context.Context, resourceGroupName string, clusterName string) (result OperationalizationClustersDeleteFuture, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}},
		{TargetValue: clusterName,
			Constraints: []validation.Constraint{{Target: "clusterName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "clusterName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "clusterName", Name: validation.Pattern, Rule: `^[a-zA-Z][-\w\._\(\)]+[a-zA-Z0-9]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("compute.OperationalizationClustersClient", "Delete", err.Error())
	}

	req, err := client.DeletePreparer(ctx, resourceGroupName, clusterName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.OperationalizationClustersClient", "Delete", nil, "Failure preparing request")
		return
	}

	result, err = client.DeleteSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.OperationalizationClustersClient", "Delete", result.Response(), "Failure sending request")
		return
	}

	return
}

// DeletePreparer prepares the Delete request.
func (client OperationalizationClustersClient) DeletePreparer(ctx context.Context, resourceGroupName string, clusterName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"clusterName":       autorest.Encode("path", clusterName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2017-06-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningCompute/operationalizationClusters/{clusterName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSender sends the Delete request. The method will close the
// http.Response Body if it receives an error.
func (client OperationalizationClustersClient) DeleteSender(req *http.Request) (future OperationalizationClustersDeleteFuture, err error) {
	sender := autorest.DecorateSender(client, azure.DoRetryWithRegistration(client.Client))
	future.Future = azure.NewFuture(req)
	future.req = req
	_, err = future.Done(sender)
	if err != nil {
		return
	}
	err = autorest.Respond(future.Response(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusNoContent))
	return
}

// DeleteResponder handles the response to the Delete request. The method always
// closes the http.Response Body.
func (client OperationalizationClustersClient) DeleteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Get gets the operationalization cluster resource view. Note that the credentials are not returned by this call. Call
// ListKeys to get them.
//
// resourceGroupName is name of the resource group in which the cluster is located. clusterName is the name of the
// cluster.
func (client OperationalizationClustersClient) Get(ctx context.Context, resourceGroupName string, clusterName string) (result OperationalizationCluster, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}},
		{TargetValue: clusterName,
			Constraints: []validation.Constraint{{Target: "clusterName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "clusterName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "clusterName", Name: validation.Pattern, Rule: `^[a-zA-Z][-\w\._\(\)]+[a-zA-Z0-9]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("compute.OperationalizationClustersClient", "Get", err.Error())
	}

	req, err := client.GetPreparer(ctx, resourceGroupName, clusterName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.OperationalizationClustersClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "compute.OperationalizationClustersClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.OperationalizationClustersClient", "Get", resp, "Failure responding to request")
	}

	return
}

// GetPreparer prepares the Get request.
func (client OperationalizationClustersClient) GetPreparer(ctx context.Context, resourceGroupName string, clusterName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"clusterName":       autorest.Encode("path", clusterName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2017-06-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningCompute/operationalizationClusters/{clusterName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client OperationalizationClustersClient) GetSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client OperationalizationClustersClient) GetResponder(resp *http.Response) (result OperationalizationCluster, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListByResourceGroup gets the clusters in the specified resource group.
//
// resourceGroupName is name of the resource group in which the cluster is located. skiptoken is continuation token
// for pagination.
func (client OperationalizationClustersClient) ListByResourceGroup(ctx context.Context, resourceGroupName string, skiptoken string) (result PaginatedOperationalizationClustersListPage, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("compute.OperationalizationClustersClient", "ListByResourceGroup", err.Error())
	}

	result.fn = client.listByResourceGroupNextResults
	req, err := client.ListByResourceGroupPreparer(ctx, resourceGroupName, skiptoken)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.OperationalizationClustersClient", "ListByResourceGroup", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByResourceGroupSender(req)
	if err != nil {
		result.pocl.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "compute.OperationalizationClustersClient", "ListByResourceGroup", resp, "Failure sending request")
		return
	}

	result.pocl, err = client.ListByResourceGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.OperationalizationClustersClient", "ListByResourceGroup", resp, "Failure responding to request")
	}

	return
}

// ListByResourceGroupPreparer prepares the ListByResourceGroup request.
func (client OperationalizationClustersClient) ListByResourceGroupPreparer(ctx context.Context, resourceGroupName string, skiptoken string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2017-06-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(skiptoken) > 0 {
		queryParameters["$skiptoken"] = autorest.Encode("query", skiptoken)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningCompute/operationalizationClusters", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListByResourceGroupSender sends the ListByResourceGroup request. The method will close the
// http.Response Body if it receives an error.
func (client OperationalizationClustersClient) ListByResourceGroupSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListByResourceGroupResponder handles the response to the ListByResourceGroup request. The method always
// closes the http.Response Body.
func (client OperationalizationClustersClient) ListByResourceGroupResponder(resp *http.Response) (result PaginatedOperationalizationClustersList, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listByResourceGroupNextResults retrieves the next set of results, if any.
func (client OperationalizationClustersClient) listByResourceGroupNextResults(lastResults PaginatedOperationalizationClustersList) (result PaginatedOperationalizationClustersList, err error) {
	req, err := lastResults.paginatedOperationalizationClustersListPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "compute.OperationalizationClustersClient", "listByResourceGroupNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListByResourceGroupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "compute.OperationalizationClustersClient", "listByResourceGroupNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListByResourceGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.OperationalizationClustersClient", "listByResourceGroupNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListByResourceGroupComplete enumerates all values, automatically crossing page boundaries as required.
func (client OperationalizationClustersClient) ListByResourceGroupComplete(ctx context.Context, resourceGroupName string, skiptoken string) (result PaginatedOperationalizationClustersListIterator, err error) {
	result.page, err = client.ListByResourceGroup(ctx, resourceGroupName, skiptoken)
	return
}

// ListBySubscriptionID gets the operationalization clusters in the specified subscription.
//
// skiptoken is continuation token for pagination.
func (client OperationalizationClustersClient) ListBySubscriptionID(ctx context.Context, skiptoken string) (result PaginatedOperationalizationClustersListPage, err error) {
	result.fn = client.listBySubscriptionIDNextResults
	req, err := client.ListBySubscriptionIDPreparer(ctx, skiptoken)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.OperationalizationClustersClient", "ListBySubscriptionID", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListBySubscriptionIDSender(req)
	if err != nil {
		result.pocl.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "compute.OperationalizationClustersClient", "ListBySubscriptionID", resp, "Failure sending request")
		return
	}

	result.pocl, err = client.ListBySubscriptionIDResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.OperationalizationClustersClient", "ListBySubscriptionID", resp, "Failure responding to request")
	}

	return
}

// ListBySubscriptionIDPreparer prepares the ListBySubscriptionID request.
func (client OperationalizationClustersClient) ListBySubscriptionIDPreparer(ctx context.Context, skiptoken string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2017-06-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(skiptoken) > 0 {
		queryParameters["$skiptoken"] = autorest.Encode("query", skiptoken)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.MachineLearningCompute/operationalizationClusters", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListBySubscriptionIDSender sends the ListBySubscriptionID request. The method will close the
// http.Response Body if it receives an error.
func (client OperationalizationClustersClient) ListBySubscriptionIDSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListBySubscriptionIDResponder handles the response to the ListBySubscriptionID request. The method always
// closes the http.Response Body.
func (client OperationalizationClustersClient) ListBySubscriptionIDResponder(resp *http.Response) (result PaginatedOperationalizationClustersList, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listBySubscriptionIDNextResults retrieves the next set of results, if any.
func (client OperationalizationClustersClient) listBySubscriptionIDNextResults(lastResults PaginatedOperationalizationClustersList) (result PaginatedOperationalizationClustersList, err error) {
	req, err := lastResults.paginatedOperationalizationClustersListPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "compute.OperationalizationClustersClient", "listBySubscriptionIDNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListBySubscriptionIDSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "compute.OperationalizationClustersClient", "listBySubscriptionIDNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListBySubscriptionIDResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.OperationalizationClustersClient", "listBySubscriptionIDNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListBySubscriptionIDComplete enumerates all values, automatically crossing page boundaries as required.
func (client OperationalizationClustersClient) ListBySubscriptionIDComplete(ctx context.Context, skiptoken string) (result PaginatedOperationalizationClustersListIterator, err error) {
	result.page, err = client.ListBySubscriptionID(ctx, skiptoken)
	return
}

// ListKeys gets the credentials for the specified cluster such as Storage, ACR and ACS credentials. This is a long
// running operation because it fetches keys from dependencies.
//
// resourceGroupName is name of the resource group in which the cluster is located. clusterName is the name of the
// cluster.
func (client OperationalizationClustersClient) ListKeys(ctx context.Context, resourceGroupName string, clusterName string) (result OperationalizationClustersListKeysFuture, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}},
		{TargetValue: clusterName,
			Constraints: []validation.Constraint{{Target: "clusterName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "clusterName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "clusterName", Name: validation.Pattern, Rule: `^[a-zA-Z][-\w\._\(\)]+[a-zA-Z0-9]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("compute.OperationalizationClustersClient", "ListKeys", err.Error())
	}

	req, err := client.ListKeysPreparer(ctx, resourceGroupName, clusterName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.OperationalizationClustersClient", "ListKeys", nil, "Failure preparing request")
		return
	}

	result, err = client.ListKeysSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.OperationalizationClustersClient", "ListKeys", result.Response(), "Failure sending request")
		return
	}

	return
}

// ListKeysPreparer prepares the ListKeys request.
func (client OperationalizationClustersClient) ListKeysPreparer(ctx context.Context, resourceGroupName string, clusterName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"clusterName":       autorest.Encode("path", clusterName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2017-06-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningCompute/operationalizationClusters/{clusterName}/listKeys", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListKeysSender sends the ListKeys request. The method will close the
// http.Response Body if it receives an error.
func (client OperationalizationClustersClient) ListKeysSender(req *http.Request) (future OperationalizationClustersListKeysFuture, err error) {
	sender := autorest.DecorateSender(client, azure.DoRetryWithRegistration(client.Client))
	future.Future = azure.NewFuture(req)
	future.req = req
	_, err = future.Done(sender)
	if err != nil {
		return
	}
	err = autorest.Respond(future.Response(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted))
	return
}

// ListKeysResponder handles the response to the ListKeys request. The method always
// closes the http.Response Body.
func (client OperationalizationClustersClient) ListKeysResponder(resp *http.Response) (result OperationalizationClusterCredentials, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Update the PATCH operation can be used to update only the tags for a cluster. Use PUT operation to update other
// properties.
//
// resourceGroupName is name of the resource group in which the cluster is located. clusterName is the name of the
// cluster. parameters is the parameters supplied to patch the cluster.
func (client OperationalizationClustersClient) Update(ctx context.Context, resourceGroupName string, clusterName string, parameters OperationalizationClusterUpdateParameters) (result OperationalizationCluster, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}},
		{TargetValue: clusterName,
			Constraints: []validation.Constraint{{Target: "clusterName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "clusterName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "clusterName", Name: validation.Pattern, Rule: `^[a-zA-Z][-\w\._\(\)]+[a-zA-Z0-9]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("compute.OperationalizationClustersClient", "Update", err.Error())
	}

	req, err := client.UpdatePreparer(ctx, resourceGroupName, clusterName, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.OperationalizationClustersClient", "Update", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "compute.OperationalizationClustersClient", "Update", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.OperationalizationClustersClient", "Update", resp, "Failure responding to request")
	}

	return
}

// UpdatePreparer prepares the Update request.
func (client OperationalizationClustersClient) UpdatePreparer(ctx context.Context, resourceGroupName string, clusterName string, parameters OperationalizationClusterUpdateParameters) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"clusterName":       autorest.Encode("path", clusterName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2017-06-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningCompute/operationalizationClusters/{clusterName}", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateSender sends the Update request. The method will close the
// http.Response Body if it receives an error.
func (client OperationalizationClustersClient) UpdateSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// UpdateResponder handles the response to the Update request. The method always
// closes the http.Response Body.
func (client OperationalizationClustersClient) UpdateResponder(resp *http.Response) (result OperationalizationCluster, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateSystem updates system services in a cluster.
//
// resourceGroupName is name of the resource group in which the cluster is located. clusterName is the name of the
// cluster.
func (client OperationalizationClustersClient) UpdateSystem(ctx context.Context, resourceGroupName string, clusterName string) (result OperationalizationClustersUpdateSystemFuture, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}},
		{TargetValue: clusterName,
			Constraints: []validation.Constraint{{Target: "clusterName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "clusterName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "clusterName", Name: validation.Pattern, Rule: `^[a-zA-Z][-\w\._\(\)]+[a-zA-Z0-9]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("compute.OperationalizationClustersClient", "UpdateSystem", err.Error())
	}

	req, err := client.UpdateSystemPreparer(ctx, resourceGroupName, clusterName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.OperationalizationClustersClient", "UpdateSystem", nil, "Failure preparing request")
		return
	}

	result, err = client.UpdateSystemSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "compute.OperationalizationClustersClient", "UpdateSystem", result.Response(), "Failure sending request")
		return
	}

	return
}

// UpdateSystemPreparer prepares the UpdateSystem request.
func (client OperationalizationClustersClient) UpdateSystemPreparer(ctx context.Context, resourceGroupName string, clusterName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"clusterName":       autorest.Encode("path", clusterName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2017-06-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningCompute/operationalizationClusters/{clusterName}/updateSystem", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateSystemSender sends the UpdateSystem request. The method will close the
// http.Response Body if it receives an error.
func (client OperationalizationClustersClient) UpdateSystemSender(req *http.Request) (future OperationalizationClustersUpdateSystemFuture, err error) {
	sender := autorest.DecorateSender(client, azure.DoRetryWithRegistration(client.Client))
	future.Future = azure.NewFuture(req)
	future.req = req
	_, err = future.Done(sender)
	if err != nil {
		return
	}
	err = autorest.Respond(future.Response(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted))
	return
}

// UpdateSystemResponder handles the response to the UpdateSystem request. The method always
// closes the http.Response Body.
func (client OperationalizationClustersClient) UpdateSystemResponder(resp *http.Response) (result UpdateSystemResponse, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
