/*
Cloud Hypervisor API

Local HTTP based API for managing and inspecting a cloud-hypervisor virtual machine.

API version: 0.3.0
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package openapi

import (
	"encoding/json"
)

// FsConfig struct for FsConfig
type FsConfig struct {
	Tag        string  `json:"tag"`
	Socket     string  `json:"socket"`
	NumQueues  int32   `json:"num_queues"`
	QueueSize  int32   `json:"queue_size"`
	Dax        bool    `json:"dax"`
	CacheSize  int64   `json:"cache_size"`
	PciSegment *int32  `json:"pci_segment,omitempty"`
	Id         *string `json:"id,omitempty"`
}

// NewFsConfig instantiates a new FsConfig object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewFsConfig(tag string, socket string, numQueues int32, queueSize int32, dax bool, cacheSize int64) *FsConfig {
	this := FsConfig{}
	this.Tag = tag
	this.Socket = socket
	this.NumQueues = numQueues
	this.QueueSize = queueSize
	this.Dax = dax
	this.CacheSize = cacheSize
	return &this
}

// NewFsConfigWithDefaults instantiates a new FsConfig object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewFsConfigWithDefaults() *FsConfig {
	this := FsConfig{}
	var numQueues int32 = 1
	this.NumQueues = numQueues
	var queueSize int32 = 1024
	this.QueueSize = queueSize
	var dax bool = true
	this.Dax = dax
	return &this
}

// GetTag returns the Tag field value
func (o *FsConfig) GetTag() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Tag
}

// GetTagOk returns a tuple with the Tag field value
// and a boolean to check if the value has been set.
func (o *FsConfig) GetTagOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Tag, true
}

// SetTag sets field value
func (o *FsConfig) SetTag(v string) {
	o.Tag = v
}

// GetSocket returns the Socket field value
func (o *FsConfig) GetSocket() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Socket
}

// GetSocketOk returns a tuple with the Socket field value
// and a boolean to check if the value has been set.
func (o *FsConfig) GetSocketOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Socket, true
}

// SetSocket sets field value
func (o *FsConfig) SetSocket(v string) {
	o.Socket = v
}

// GetNumQueues returns the NumQueues field value
func (o *FsConfig) GetNumQueues() int32 {
	if o == nil {
		var ret int32
		return ret
	}

	return o.NumQueues
}

// GetNumQueuesOk returns a tuple with the NumQueues field value
// and a boolean to check if the value has been set.
func (o *FsConfig) GetNumQueuesOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return &o.NumQueues, true
}

// SetNumQueues sets field value
func (o *FsConfig) SetNumQueues(v int32) {
	o.NumQueues = v
}

// GetQueueSize returns the QueueSize field value
func (o *FsConfig) GetQueueSize() int32 {
	if o == nil {
		var ret int32
		return ret
	}

	return o.QueueSize
}

// GetQueueSizeOk returns a tuple with the QueueSize field value
// and a boolean to check if the value has been set.
func (o *FsConfig) GetQueueSizeOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return &o.QueueSize, true
}

// SetQueueSize sets field value
func (o *FsConfig) SetQueueSize(v int32) {
	o.QueueSize = v
}

// GetDax returns the Dax field value
func (o *FsConfig) GetDax() bool {
	if o == nil {
		var ret bool
		return ret
	}

	return o.Dax
}

// GetDaxOk returns a tuple with the Dax field value
// and a boolean to check if the value has been set.
func (o *FsConfig) GetDaxOk() (*bool, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Dax, true
}

// SetDax sets field value
func (o *FsConfig) SetDax(v bool) {
	o.Dax = v
}

// GetCacheSize returns the CacheSize field value
func (o *FsConfig) GetCacheSize() int64 {
	if o == nil {
		var ret int64
		return ret
	}

	return o.CacheSize
}

// GetCacheSizeOk returns a tuple with the CacheSize field value
// and a boolean to check if the value has been set.
func (o *FsConfig) GetCacheSizeOk() (*int64, bool) {
	if o == nil {
		return nil, false
	}
	return &o.CacheSize, true
}

// SetCacheSize sets field value
func (o *FsConfig) SetCacheSize(v int64) {
	o.CacheSize = v
}

// GetPciSegment returns the PciSegment field value if set, zero value otherwise.
func (o *FsConfig) GetPciSegment() int32 {
	if o == nil || o.PciSegment == nil {
		var ret int32
		return ret
	}
	return *o.PciSegment
}

// GetPciSegmentOk returns a tuple with the PciSegment field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *FsConfig) GetPciSegmentOk() (*int32, bool) {
	if o == nil || o.PciSegment == nil {
		return nil, false
	}
	return o.PciSegment, true
}

// HasPciSegment returns a boolean if a field has been set.
func (o *FsConfig) HasPciSegment() bool {
	if o != nil && o.PciSegment != nil {
		return true
	}

	return false
}

// SetPciSegment gets a reference to the given int32 and assigns it to the PciSegment field.
func (o *FsConfig) SetPciSegment(v int32) {
	o.PciSegment = &v
}

// GetId returns the Id field value if set, zero value otherwise.
func (o *FsConfig) GetId() string {
	if o == nil || o.Id == nil {
		var ret string
		return ret
	}
	return *o.Id
}

// GetIdOk returns a tuple with the Id field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *FsConfig) GetIdOk() (*string, bool) {
	if o == nil || o.Id == nil {
		return nil, false
	}
	return o.Id, true
}

// HasId returns a boolean if a field has been set.
func (o *FsConfig) HasId() bool {
	if o != nil && o.Id != nil {
		return true
	}

	return false
}

// SetId gets a reference to the given string and assigns it to the Id field.
func (o *FsConfig) SetId(v string) {
	o.Id = &v
}

func (o FsConfig) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if true {
		toSerialize["tag"] = o.Tag
	}
	if true {
		toSerialize["socket"] = o.Socket
	}
	if true {
		toSerialize["num_queues"] = o.NumQueues
	}
	if true {
		toSerialize["queue_size"] = o.QueueSize
	}
	if true {
		toSerialize["dax"] = o.Dax
	}
	if true {
		toSerialize["cache_size"] = o.CacheSize
	}
	if o.PciSegment != nil {
		toSerialize["pci_segment"] = o.PciSegment
	}
	if o.Id != nil {
		toSerialize["id"] = o.Id
	}
	return json.Marshal(toSerialize)
}

type NullableFsConfig struct {
	value *FsConfig
	isSet bool
}

func (v NullableFsConfig) Get() *FsConfig {
	return v.value
}

func (v *NullableFsConfig) Set(val *FsConfig) {
	v.value = val
	v.isSet = true
}

func (v NullableFsConfig) IsSet() bool {
	return v.isSet
}

func (v *NullableFsConfig) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableFsConfig(val *FsConfig) *NullableFsConfig {
	return &NullableFsConfig{value: val, isSet: true}
}

func (v NullableFsConfig) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableFsConfig) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
