/*
Cloud Hypervisor API

Local HTTP based API for managing and inspecting a cloud-hypervisor virtual machine.

API version: 0.3.0
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package openapi

import (
	"encoding/json"
)

// SendMigrationData struct for SendMigrationData
type SendMigrationData struct {
	DestinationUrl *string `json:"destination_url,omitempty"`
	Local          *bool   `json:"local,omitempty"`
}

// NewSendMigrationData instantiates a new SendMigrationData object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewSendMigrationData() *SendMigrationData {
	this := SendMigrationData{}
	return &this
}

// NewSendMigrationDataWithDefaults instantiates a new SendMigrationData object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewSendMigrationDataWithDefaults() *SendMigrationData {
	this := SendMigrationData{}
	return &this
}

// GetDestinationUrl returns the DestinationUrl field value if set, zero value otherwise.
func (o *SendMigrationData) GetDestinationUrl() string {
	if o == nil || o.DestinationUrl == nil {
		var ret string
		return ret
	}
	return *o.DestinationUrl
}

// GetDestinationUrlOk returns a tuple with the DestinationUrl field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SendMigrationData) GetDestinationUrlOk() (*string, bool) {
	if o == nil || o.DestinationUrl == nil {
		return nil, false
	}
	return o.DestinationUrl, true
}

// HasDestinationUrl returns a boolean if a field has been set.
func (o *SendMigrationData) HasDestinationUrl() bool {
	if o != nil && o.DestinationUrl != nil {
		return true
	}

	return false
}

// SetDestinationUrl gets a reference to the given string and assigns it to the DestinationUrl field.
func (o *SendMigrationData) SetDestinationUrl(v string) {
	o.DestinationUrl = &v
}

// GetLocal returns the Local field value if set, zero value otherwise.
func (o *SendMigrationData) GetLocal() bool {
	if o == nil || o.Local == nil {
		var ret bool
		return ret
	}
	return *o.Local
}

// GetLocalOk returns a tuple with the Local field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SendMigrationData) GetLocalOk() (*bool, bool) {
	if o == nil || o.Local == nil {
		return nil, false
	}
	return o.Local, true
}

// HasLocal returns a boolean if a field has been set.
func (o *SendMigrationData) HasLocal() bool {
	if o != nil && o.Local != nil {
		return true
	}

	return false
}

// SetLocal gets a reference to the given bool and assigns it to the Local field.
func (o *SendMigrationData) SetLocal(v bool) {
	o.Local = &v
}

func (o SendMigrationData) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.DestinationUrl != nil {
		toSerialize["destination_url"] = o.DestinationUrl
	}
	if o.Local != nil {
		toSerialize["local"] = o.Local
	}
	return json.Marshal(toSerialize)
}

type NullableSendMigrationData struct {
	value *SendMigrationData
	isSet bool
}

func (v NullableSendMigrationData) Get() *SendMigrationData {
	return v.value
}

func (v *NullableSendMigrationData) Set(val *SendMigrationData) {
	v.value = val
	v.isSet = true
}

func (v NullableSendMigrationData) IsSet() bool {
	return v.isSet
}

func (v *NullableSendMigrationData) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableSendMigrationData(val *SendMigrationData) *NullableSendMigrationData {
	return &NullableSendMigrationData{value: val, isSet: true}
}

func (v NullableSendMigrationData) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableSendMigrationData) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
