package sls

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QuerySafService invokes the sls.QuerySafService API synchronously
func (client *Client) QuerySafService(request *QuerySafServiceRequest) (response *QuerySafServiceResponse, err error) {
	response = CreateQuerySafServiceResponse()
	err = client.DoAction(request, response)
	return
}

// QuerySafServiceWithChan invokes the sls.QuerySafService API asynchronously
func (client *Client) QuerySafServiceWithChan(request *QuerySafServiceRequest) (<-chan *QuerySafServiceResponse, <-chan error) {
	responseChan := make(chan *QuerySafServiceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QuerySafService(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QuerySafServiceWithCallback invokes the sls.QuerySafService API asynchronously
func (client *Client) QuerySafServiceWithCallback(request *QuerySafServiceRequest, callback func(response *QuerySafServiceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QuerySafServiceResponse
		var err error
		defer close(result)
		response, err = client.QuerySafService(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QuerySafServiceRequest is the request struct for api QuerySafService
type QuerySafServiceRequest struct {
	*requests.RpcRequest
	ParamType   string `position:"Query" name:"ParamType"`
	ProjectName string `position:"Query" name:"ProjectName"`
	ParamValue  string `position:"Query" name:"ParamValue"`
}

// QuerySafServiceResponse is the response struct for api QuerySafService
type QuerySafServiceResponse struct {
	*responses.BaseResponse
	RequestId string                 `json:"RequestId" xml:"RequestId"`
	Code      string                 `json:"Code" xml:"Code"`
	Score     string                 `json:"Score" xml:"Score"`
	Ext       map[string]interface{} `json:"Ext" xml:"Ext"`
}

// CreateQuerySafServiceRequest creates a request to invoke QuerySafService API
func CreateQuerySafServiceRequest() (request *QuerySafServiceRequest) {
	request = &QuerySafServiceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sls", "2019-10-23", "QuerySafService", "", "")
	request.Method = requests.POST
	return
}

// CreateQuerySafServiceResponse creates a response to parse from QuerySafService response
func CreateQuerySafServiceResponse() (response *QuerySafServiceResponse) {
	response = &QuerySafServiceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
