// Code generated by protoc-gen-go. DO NOT EDIT.
// source: opencensus/proto/stats/v1/stats.proto

package v1

import (
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

type Measure_Type int32

const (
	// Unknown type.
	Measure_TYPE_UNSPECIFIED Measure_Type = 0
	// Indicates an int64 Measure.
	Measure_INT64 Measure_Type = 1
	// Indicates a double Measure.
	Measure_DOUBLE Measure_Type = 2
)

var Measure_Type_name = map[int32]string{
	0: "TYPE_UNSPECIFIED",
	1: "INT64",
	2: "DOUBLE",
}

var Measure_Type_value = map[string]int32{
	"TYPE_UNSPECIFIED": 0,
	"INT64":            1,
	"DOUBLE":           2,
}

func (x Measure_Type) String() string {
	return proto.EnumName(Measure_Type_name, int32(x))
}

func (Measure_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_5cb731b1ef81fd07, []int{1, 0}
}

// TODO(bdrutu): Consider if this should be moved to a "tags" directory to match the API structure.
type Tag struct {
	Key                  string   `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Value                string   `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Tag) Reset()         { *m = Tag{} }
func (m *Tag) String() string { return proto.CompactTextString(m) }
func (*Tag) ProtoMessage()    {}
func (*Tag) Descriptor() ([]byte, []int) {
	return fileDescriptor_5cb731b1ef81fd07, []int{0}
}

func (m *Tag) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Tag.Unmarshal(m, b)
}
func (m *Tag) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Tag.Marshal(b, m, deterministic)
}
func (m *Tag) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Tag.Merge(m, src)
}
func (m *Tag) XXX_Size() int {
	return xxx_messageInfo_Tag.Size(m)
}
func (m *Tag) XXX_DiscardUnknown() {
	xxx_messageInfo_Tag.DiscardUnknown(m)
}

var xxx_messageInfo_Tag proto.InternalMessageInfo

func (m *Tag) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

func (m *Tag) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

// Measure .
type Measure struct {
	// A string by which the measure will be referred to, e.g. "rpc_server_latency". Names MUST be
	// unique within the library.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Describes the measure, e.g. "RPC latency in seconds".
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Describes the unit used for the Measure. Follows the format described by
	// http://unitsofmeasure.org/ucum.html.
	Unit string `protobuf:"bytes,3,opt,name=unit,proto3" json:"unit,omitempty"`
	// The type used for this Measure.
	Type                 Measure_Type `protobuf:"varint,4,opt,name=type,proto3,enum=opencensus.proto.stats.v1.Measure_Type" json:"type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *Measure) Reset()         { *m = Measure{} }
func (m *Measure) String() string { return proto.CompactTextString(m) }
func (*Measure) ProtoMessage()    {}
func (*Measure) Descriptor() ([]byte, []int) {
	return fileDescriptor_5cb731b1ef81fd07, []int{1}
}

func (m *Measure) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Measure.Unmarshal(m, b)
}
func (m *Measure) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Measure.Marshal(b, m, deterministic)
}
func (m *Measure) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Measure.Merge(m, src)
}
func (m *Measure) XXX_Size() int {
	return xxx_messageInfo_Measure.Size(m)
}
func (m *Measure) XXX_DiscardUnknown() {
	xxx_messageInfo_Measure.DiscardUnknown(m)
}

var xxx_messageInfo_Measure proto.InternalMessageInfo

func (m *Measure) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Measure) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Measure) GetUnit() string {
	if m != nil {
		return m.Unit
	}
	return ""
}

func (m *Measure) GetType() Measure_Type {
	if m != nil {
		return m.Type
	}
	return Measure_TYPE_UNSPECIFIED
}

type View struct {
	// A string by which the View will be referred to, e.g. "rpc_latency". Names MUST be unique
	// within the library.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Describes the view, e.g. "RPC latency distribution"
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// The Measure to which this view is applied.
	Measure *Measure `protobuf:"bytes,3,opt,name=measure,proto3" json:"measure,omitempty"`
	// An array of tag keys. These values associated with tags of this name form the basis by which
	// individual stats will be aggregated (one aggregation per unique tag value). If none are
	// provided, then all data is recorded in a single aggregation.
	Columns []string `protobuf:"bytes,4,rep,name=columns,proto3" json:"columns,omitempty"`
	// The description of the aggregation used for this view which describes how data collected are
	// aggregated.
	//
	// Types that are valid to be assigned to Aggregation:
	//	*View_CountAggregation
	//	*View_SumAggregation
	//	*View_LastValueAggregation
	//	*View_DistributionAggregation
	Aggregation          isView_Aggregation `protobuf_oneof:"aggregation"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *View) Reset()         { *m = View{} }
func (m *View) String() string { return proto.CompactTextString(m) }
func (*View) ProtoMessage()    {}
func (*View) Descriptor() ([]byte, []int) {
	return fileDescriptor_5cb731b1ef81fd07, []int{2}
}

func (m *View) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_View.Unmarshal(m, b)
}
func (m *View) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_View.Marshal(b, m, deterministic)
}
func (m *View) XXX_Merge(src proto.Message) {
	xxx_messageInfo_View.Merge(m, src)
}
func (m *View) XXX_Size() int {
	return xxx_messageInfo_View.Size(m)
}
func (m *View) XXX_DiscardUnknown() {
	xxx_messageInfo_View.DiscardUnknown(m)
}

var xxx_messageInfo_View proto.InternalMessageInfo

func (m *View) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *View) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *View) GetMeasure() *Measure {
	if m != nil {
		return m.Measure
	}
	return nil
}

func (m *View) GetColumns() []string {
	if m != nil {
		return m.Columns
	}
	return nil
}

type isView_Aggregation interface {
	isView_Aggregation()
}

type View_CountAggregation struct {
	CountAggregation *CountAggregation `protobuf:"bytes,5,opt,name=count_aggregation,json=countAggregation,proto3,oneof"`
}

type View_SumAggregation struct {
	SumAggregation *SumAggregation `protobuf:"bytes,6,opt,name=sum_aggregation,json=sumAggregation,proto3,oneof"`
}

type View_LastValueAggregation struct {
	LastValueAggregation *LastValueAggregation `protobuf:"bytes,7,opt,name=last_value_aggregation,json=lastValueAggregation,proto3,oneof"`
}

type View_DistributionAggregation struct {
	DistributionAggregation *DistributionAggregation `protobuf:"bytes,8,opt,name=distribution_aggregation,json=distributionAggregation,proto3,oneof"`
}

func (*View_CountAggregation) isView_Aggregation() {}

func (*View_SumAggregation) isView_Aggregation() {}

func (*View_LastValueAggregation) isView_Aggregation() {}

func (*View_DistributionAggregation) isView_Aggregation() {}

func (m *View) GetAggregation() isView_Aggregation {
	if m != nil {
		return m.Aggregation
	}
	return nil
}

func (m *View) GetCountAggregation() *CountAggregation {
	if x, ok := m.GetAggregation().(*View_CountAggregation); ok {
		return x.CountAggregation
	}
	return nil
}

func (m *View) GetSumAggregation() *SumAggregation {
	if x, ok := m.GetAggregation().(*View_SumAggregation); ok {
		return x.SumAggregation
	}
	return nil
}

func (m *View) GetLastValueAggregation() *LastValueAggregation {
	if x, ok := m.GetAggregation().(*View_LastValueAggregation); ok {
		return x.LastValueAggregation
	}
	return nil
}

func (m *View) GetDistributionAggregation() *DistributionAggregation {
	if x, ok := m.GetAggregation().(*View_DistributionAggregation); ok {
		return x.DistributionAggregation
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*View) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _View_OneofMarshaler, _View_OneofUnmarshaler, _View_OneofSizer, []interface{}{
		(*View_CountAggregation)(nil),
		(*View_SumAggregation)(nil),
		(*View_LastValueAggregation)(nil),
		(*View_DistributionAggregation)(nil),
	}
}

func _View_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*View)
	// aggregation
	switch x := m.Aggregation.(type) {
	case *View_CountAggregation:
		b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.CountAggregation); err != nil {
			return err
		}
	case *View_SumAggregation:
		b.EncodeVarint(6<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.SumAggregation); err != nil {
			return err
		}
	case *View_LastValueAggregation:
		b.EncodeVarint(7<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.LastValueAggregation); err != nil {
			return err
		}
	case *View_DistributionAggregation:
		b.EncodeVarint(8<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.DistributionAggregation); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("View.Aggregation has unexpected type %T", x)
	}
	return nil
}

func _View_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*View)
	switch tag {
	case 5: // aggregation.count_aggregation
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(CountAggregation)
		err := b.DecodeMessage(msg)
		m.Aggregation = &View_CountAggregation{msg}
		return true, err
	case 6: // aggregation.sum_aggregation
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(SumAggregation)
		err := b.DecodeMessage(msg)
		m.Aggregation = &View_SumAggregation{msg}
		return true, err
	case 7: // aggregation.last_value_aggregation
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(LastValueAggregation)
		err := b.DecodeMessage(msg)
		m.Aggregation = &View_LastValueAggregation{msg}
		return true, err
	case 8: // aggregation.distribution_aggregation
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(DistributionAggregation)
		err := b.DecodeMessage(msg)
		m.Aggregation = &View_DistributionAggregation{msg}
		return true, err
	default:
		return false, nil
	}
}

func _View_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*View)
	// aggregation
	switch x := m.Aggregation.(type) {
	case *View_CountAggregation:
		s := proto.Size(x.CountAggregation)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *View_SumAggregation:
		s := proto.Size(x.SumAggregation)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *View_LastValueAggregation:
		s := proto.Size(x.LastValueAggregation)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *View_DistributionAggregation:
		s := proto.Size(x.DistributionAggregation)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type CountAggregation struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CountAggregation) Reset()         { *m = CountAggregation{} }
func (m *CountAggregation) String() string { return proto.CompactTextString(m) }
func (*CountAggregation) ProtoMessage()    {}
func (*CountAggregation) Descriptor() ([]byte, []int) {
	return fileDescriptor_5cb731b1ef81fd07, []int{3}
}

func (m *CountAggregation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CountAggregation.Unmarshal(m, b)
}
func (m *CountAggregation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CountAggregation.Marshal(b, m, deterministic)
}
func (m *CountAggregation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CountAggregation.Merge(m, src)
}
func (m *CountAggregation) XXX_Size() int {
	return xxx_messageInfo_CountAggregation.Size(m)
}
func (m *CountAggregation) XXX_DiscardUnknown() {
	xxx_messageInfo_CountAggregation.DiscardUnknown(m)
}

var xxx_messageInfo_CountAggregation proto.InternalMessageInfo

type SumAggregation struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SumAggregation) Reset()         { *m = SumAggregation{} }
func (m *SumAggregation) String() string { return proto.CompactTextString(m) }
func (*SumAggregation) ProtoMessage()    {}
func (*SumAggregation) Descriptor() ([]byte, []int) {
	return fileDescriptor_5cb731b1ef81fd07, []int{4}
}

func (m *SumAggregation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SumAggregation.Unmarshal(m, b)
}
func (m *SumAggregation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SumAggregation.Marshal(b, m, deterministic)
}
func (m *SumAggregation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SumAggregation.Merge(m, src)
}
func (m *SumAggregation) XXX_Size() int {
	return xxx_messageInfo_SumAggregation.Size(m)
}
func (m *SumAggregation) XXX_DiscardUnknown() {
	xxx_messageInfo_SumAggregation.DiscardUnknown(m)
}

var xxx_messageInfo_SumAggregation proto.InternalMessageInfo

type LastValueAggregation struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LastValueAggregation) Reset()         { *m = LastValueAggregation{} }
func (m *LastValueAggregation) String() string { return proto.CompactTextString(m) }
func (*LastValueAggregation) ProtoMessage()    {}
func (*LastValueAggregation) Descriptor() ([]byte, []int) {
	return fileDescriptor_5cb731b1ef81fd07, []int{5}
}

func (m *LastValueAggregation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LastValueAggregation.Unmarshal(m, b)
}
func (m *LastValueAggregation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LastValueAggregation.Marshal(b, m, deterministic)
}
func (m *LastValueAggregation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LastValueAggregation.Merge(m, src)
}
func (m *LastValueAggregation) XXX_Size() int {
	return xxx_messageInfo_LastValueAggregation.Size(m)
}
func (m *LastValueAggregation) XXX_DiscardUnknown() {
	xxx_messageInfo_LastValueAggregation.DiscardUnknown(m)
}

var xxx_messageInfo_LastValueAggregation proto.InternalMessageInfo

type DistributionAggregation struct {
	// A Distribution may optionally contain a histogram of the values in the
	// population. The bucket boundaries for that histogram are described by
	// `bucket_bounds`. This defines `size(bucket_bounds) + 1` (= N)
	// buckets. The boundaries for bucket index i are:
	//
	// (-infinity, bucket_bounds[i]) for i == 0
	// [bucket_bounds[i-1], bucket_bounds[i]) for 0 < i < N-2
	// [bucket_bounds[i-1], +infinity) for i == N-1
	//
	// i.e. an underflow bucket (number 0), zero or more finite buckets (1
	// through N - 2, and an overflow bucket (N - 1), with inclusive lower
	// bounds and exclusive upper bounds.
	//
	// If `bucket_bounds` has no elements (zero size), then there is no
	// histogram associated with the Distribution. If `bucket_bounds` has only
	// one element, there are no finite buckets, and that single element is the
	// common boundary of the overflow and underflow buckets. The values must
	// be monotonically increasing.
	BucketBounds         []float64 `protobuf:"fixed64,1,rep,packed,name=bucket_bounds,json=bucketBounds,proto3" json:"bucket_bounds,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *DistributionAggregation) Reset()         { *m = DistributionAggregation{} }
func (m *DistributionAggregation) String() string { return proto.CompactTextString(m) }
func (*DistributionAggregation) ProtoMessage()    {}
func (*DistributionAggregation) Descriptor() ([]byte, []int) {
	return fileDescriptor_5cb731b1ef81fd07, []int{6}
}

func (m *DistributionAggregation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DistributionAggregation.Unmarshal(m, b)
}
func (m *DistributionAggregation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DistributionAggregation.Marshal(b, m, deterministic)
}
func (m *DistributionAggregation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DistributionAggregation.Merge(m, src)
}
func (m *DistributionAggregation) XXX_Size() int {
	return xxx_messageInfo_DistributionAggregation.Size(m)
}
func (m *DistributionAggregation) XXX_DiscardUnknown() {
	xxx_messageInfo_DistributionAggregation.DiscardUnknown(m)
}

var xxx_messageInfo_DistributionAggregation proto.InternalMessageInfo

func (m *DistributionAggregation) GetBucketBounds() []float64 {
	if m != nil {
		return m.BucketBounds
	}
	return nil
}

// Describes a data point to be collected for a Measure.
type Measurement struct {
	Tags []*Tag `protobuf:"bytes,1,rep,name=tags,proto3" json:"tags,omitempty"`
	// The name of the measure to which the value is applied.
	MeasureName string `protobuf:"bytes,2,opt,name=measure_name,json=measureName,proto3" json:"measure_name,omitempty"`
	// The recorded value, MUST have the appropriate type to match the Measure.
	//
	// Types that are valid to be assigned to Value:
	//	*Measurement_DoubleValue
	//	*Measurement_IntValue
	Value isMeasurement_Value `protobuf_oneof:"value"`
	// The time when this measurement was recorded. If the implementation uses a async buffer to
	// record measurements this may be the time when the measurement was read from the buffer.
	Time                 *timestamp.Timestamp `protobuf:"bytes,5,opt,name=time,proto3" json:"time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *Measurement) Reset()         { *m = Measurement{} }
func (m *Measurement) String() string { return proto.CompactTextString(m) }
func (*Measurement) ProtoMessage()    {}
func (*Measurement) Descriptor() ([]byte, []int) {
	return fileDescriptor_5cb731b1ef81fd07, []int{7}
}

func (m *Measurement) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Measurement.Unmarshal(m, b)
}
func (m *Measurement) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Measurement.Marshal(b, m, deterministic)
}
func (m *Measurement) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Measurement.Merge(m, src)
}
func (m *Measurement) XXX_Size() int {
	return xxx_messageInfo_Measurement.Size(m)
}
func (m *Measurement) XXX_DiscardUnknown() {
	xxx_messageInfo_Measurement.DiscardUnknown(m)
}

var xxx_messageInfo_Measurement proto.InternalMessageInfo

func (m *Measurement) GetTags() []*Tag {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *Measurement) GetMeasureName() string {
	if m != nil {
		return m.MeasureName
	}
	return ""
}

type isMeasurement_Value interface {
	isMeasurement_Value()
}

type Measurement_DoubleValue struct {
	DoubleValue float64 `protobuf:"fixed64,3,opt,name=double_value,json=doubleValue,proto3,oneof"`
}

type Measurement_IntValue struct {
	IntValue int64 `protobuf:"varint,4,opt,name=int_value,json=intValue,proto3,oneof"`
}

func (*Measurement_DoubleValue) isMeasurement_Value() {}

func (*Measurement_IntValue) isMeasurement_Value() {}

func (m *Measurement) GetValue() isMeasurement_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *Measurement) GetDoubleValue() float64 {
	if x, ok := m.GetValue().(*Measurement_DoubleValue); ok {
		return x.DoubleValue
	}
	return 0
}

func (m *Measurement) GetIntValue() int64 {
	if x, ok := m.GetValue().(*Measurement_IntValue); ok {
		return x.IntValue
	}
	return 0
}

func (m *Measurement) GetTime() *timestamp.Timestamp {
	if m != nil {
		return m.Time
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Measurement) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Measurement_OneofMarshaler, _Measurement_OneofUnmarshaler, _Measurement_OneofSizer, []interface{}{
		(*Measurement_DoubleValue)(nil),
		(*Measurement_IntValue)(nil),
	}
}

func _Measurement_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Measurement)
	// value
	switch x := m.Value.(type) {
	case *Measurement_DoubleValue:
		b.EncodeVarint(3<<3 | proto.WireFixed64)
		b.EncodeFixed64(math.Float64bits(x.DoubleValue))
	case *Measurement_IntValue:
		b.EncodeVarint(4<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.IntValue))
	case nil:
	default:
		return fmt.Errorf("Measurement.Value has unexpected type %T", x)
	}
	return nil
}

func _Measurement_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Measurement)
	switch tag {
	case 3: // value.double_value
		if wire != proto.WireFixed64 {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeFixed64()
		m.Value = &Measurement_DoubleValue{math.Float64frombits(x)}
		return true, err
	case 4: // value.int_value
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Value = &Measurement_IntValue{int64(x)}
		return true, err
	default:
		return false, nil
	}
}

func _Measurement_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Measurement)
	// value
	switch x := m.Value.(type) {
	case *Measurement_DoubleValue:
		n += 1 // tag and wire
		n += 8
	case *Measurement_IntValue:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(x.IntValue))
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

func init() {
	proto.RegisterEnum("opencensus.proto.stats.v1.Measure_Type", Measure_Type_name, Measure_Type_value)
	proto.RegisterType((*Tag)(nil), "opencensus.proto.stats.v1.Tag")
	proto.RegisterType((*Measure)(nil), "opencensus.proto.stats.v1.Measure")
	proto.RegisterType((*View)(nil), "opencensus.proto.stats.v1.View")
	proto.RegisterType((*CountAggregation)(nil), "opencensus.proto.stats.v1.CountAggregation")
	proto.RegisterType((*SumAggregation)(nil), "opencensus.proto.stats.v1.SumAggregation")
	proto.RegisterType((*LastValueAggregation)(nil), "opencensus.proto.stats.v1.LastValueAggregation")
	proto.RegisterType((*DistributionAggregation)(nil), "opencensus.proto.stats.v1.DistributionAggregation")
	proto.RegisterType((*Measurement)(nil), "opencensus.proto.stats.v1.Measurement")
}

func init() {
	proto.RegisterFile("opencensus/proto/stats/v1/stats.proto", fileDescriptor_5cb731b1ef81fd07)
}

var fileDescriptor_5cb731b1ef81fd07 = []byte{
	// 634 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x54, 0xef, 0x4e, 0xdb, 0x3e,
	0x14, 0x6d, 0x68, 0xa0, 0xf4, 0x16, 0xf8, 0xe5, 0x67, 0x55, 0x90, 0xa1, 0xfd, 0xe9, 0x82, 0xa6,
	0x75, 0x9a, 0x9a, 0x88, 0x32, 0xed, 0xcb, 0xa6, 0x49, 0x0b, 0x74, 0x02, 0x89, 0xb1, 0x2a, 0x04,
	0xa4, 0xf1, 0xa5, 0x4a, 0x52, 0x2f, 0x8b, 0x68, 0xec, 0xa8, 0xb6, 0x99, 0x78, 0xaa, 0x3d, 0xc5,
	0x1e, 0x64, 0x6f, 0x32, 0xd9, 0x4e, 0x55, 0x82, 0x68, 0x27, 0xed, 0xdb, 0xf5, 0xc9, 0x3d, 0xf7,
	0xf8, 0x5e, 0x9f, 0x5c, 0x78, 0x41, 0x0b, 0x4c, 0x12, 0x4c, 0x98, 0x60, 0x5e, 0x31, 0xa5, 0x9c,
	0x7a, 0x8c, 0x47, 0x9c, 0x79, 0x37, 0xfb, 0x3a, 0x70, 0x15, 0x88, 0x1e, 0xcd, 0xd3, 0x34, 0xe2,
	0xea, 0xaf, 0x37, 0xfb, 0xbb, 0xcf, 0x52, 0x4a, 0xd3, 0x09, 0xd6, 0xec, 0x58, 0x7c, 0xf3, 0x78,
	0x96, 0x63, 0xc6, 0xa3, 0xbc, 0xd0, 0x99, 0x4e, 0x0f, 0xea, 0x61, 0x94, 0x22, 0x0b, 0xea, 0xd7,
	0xf8, 0xd6, 0x36, 0x3a, 0x46, 0xb7, 0x19, 0xc8, 0x10, 0xb5, 0x61, 0xf5, 0x26, 0x9a, 0x08, 0x6c,
	0xaf, 0x28, 0x4c, 0x1f, 0x9c, 0x5f, 0x06, 0x34, 0x3e, 0xe3, 0x88, 0x89, 0x29, 0x46, 0x08, 0x4c,
	0x12, 0xe5, 0xb8, 0x24, 0xa9, 0x18, 0x75, 0xa0, 0x35, 0xc6, 0x2c, 0x99, 0x66, 0x05, 0xcf, 0x28,
	0x29, 0xb9, 0x77, 0x21, 0xc9, 0x12, 0x24, 0xe3, 0x76, 0x5d, 0xb3, 0x64, 0x8c, 0xde, 0x81, 0xc9,
	0x6f, 0x0b, 0x6c, 0x9b, 0x1d, 0xa3, 0xbb, 0xd5, 0x7f, 0xe9, 0x2e, 0xec, 0xc7, 0x2d, 0xb5, 0xdd,
	0xf0, 0xb6, 0xc0, 0x81, 0x22, 0x39, 0x07, 0x60, 0xca, 0x13, 0x6a, 0x83, 0x15, 0x7e, 0x1d, 0x0e,
	0x46, 0x17, 0x67, 0xe7, 0xc3, 0xc1, 0xe1, 0xc9, 0xa7, 0x93, 0xc1, 0x91, 0x55, 0x43, 0x4d, 0x58,
	0x3d, 0x39, 0x0b, 0xdf, 0xbe, 0xb1, 0x0c, 0x04, 0xb0, 0x76, 0xf4, 0xe5, 0xc2, 0x3f, 0x1d, 0x58,
	0x2b, 0xce, 0x4f, 0x13, 0xcc, 0xcb, 0x0c, 0xff, 0xf8, 0xc7, 0x26, 0xde, 0x43, 0x23, 0xd7, 0x37,
	0x51, 0x7d, 0xb4, 0xfa, 0xce, 0xdf, 0xef, 0x1c, 0xcc, 0x28, 0xc8, 0x86, 0x46, 0x42, 0x27, 0x22,
	0x27, 0xcc, 0x36, 0x3b, 0xf5, 0x6e, 0x33, 0x98, 0x1d, 0xd1, 0x15, 0xfc, 0x9f, 0x50, 0x41, 0xf8,
	0x28, 0x4a, 0xd3, 0x29, 0x4e, 0x23, 0xa5, 0xbf, 0xaa, 0x14, 0x5e, 0x2f, 0x51, 0x38, 0x94, 0x9c,
	0x8f, 0x73, 0xca, 0x71, 0x2d, 0xb0, 0x92, 0x7b, 0x18, 0x0a, 0xe1, 0x3f, 0x26, 0xf2, 0x4a, 0xe5,
	0x35, 0x55, 0xf9, 0xd5, 0x92, 0xca, 0xe7, 0x22, 0xaf, 0xd6, 0xdd, 0x62, 0x15, 0x04, 0xa5, 0xb0,
	0x3d, 0x89, 0x18, 0x1f, 0x29, 0x7b, 0x54, 0x8a, 0x37, 0x54, 0x71, 0x6f, 0x49, 0xf1, 0xd3, 0x88,
	0xf1, 0x4b, 0xc9, 0xab, 0x4a, 0xb4, 0x27, 0x0f, 0xe0, 0x88, 0x82, 0x3d, 0xce, 0x18, 0x9f, 0x66,
	0xb1, 0x90, 0xe7, 0x8a, 0xd4, 0xba, 0x92, 0xea, 0x2f, 0x91, 0x3a, 0xba, 0x43, 0xad, 0xaa, 0xed,
	0x8c, 0x1f, 0xfe, 0xe4, 0x6f, 0x42, 0xeb, 0x8e, 0x86, 0x83, 0xc0, 0xba, 0x3f, 0x66, 0xc7, 0x82,
	0xad, 0xea, 0x80, 0x9c, 0x6d, 0x68, 0x3f, 0xd4, 0x95, 0xf3, 0x01, 0x76, 0x16, 0x5c, 0x01, 0xed,
	0xc1, 0x66, 0x2c, 0x92, 0x6b, 0xcc, 0x47, 0x31, 0x15, 0x64, 0xcc, 0x6c, 0xa3, 0x53, 0xef, 0x1a,
	0xc1, 0x86, 0x06, 0x7d, 0x85, 0x39, 0xbf, 0x0d, 0x68, 0x95, 0x3e, 0xca, 0x31, 0xe1, 0xa8, 0x0f,
	0x26, 0x8f, 0x52, 0x9d, 0xdb, 0xea, 0x3f, 0x5d, 0xd2, 0x79, 0x18, 0xa5, 0x81, 0xca, 0x45, 0xcf,
	0x61, 0xa3, 0x74, 0xe0, 0x48, 0x59, 0xbe, 0xf4, 0x75, 0x89, 0x9d, 0x49, 0xe7, 0xef, 0xc1, 0xc6,
	0x98, 0x8a, 0x78, 0x82, 0xf5, 0x7b, 0x2a, 0x73, 0x1b, 0xc7, 0xb5, 0xa0, 0xa5, 0x51, 0xd5, 0x16,
	0x7a, 0x02, 0xcd, 0x8c, 0x94, 0x2f, 0xae, 0x7e, 0xd9, 0xfa, 0x71, 0x2d, 0x58, 0xcf, 0x88, 0xee,
	0x1a, 0xb9, 0x60, 0xca, 0x25, 0x53, 0xda, 0x76, 0xd7, 0xd5, 0x1b, 0xc8, 0x9d, 0x6d, 0x20, 0x37,
	0x9c, 0x6d, 0xa0, 0x40, 0xe5, 0xf9, 0x8d, 0x72, 0xd1, 0xf8, 0x05, 0x3c, 0xce, 0xe8, 0xe2, 0x4e,
	0x7c, 0x38, 0x97, 0xd1, 0x50, 0x82, 0x43, 0xe3, 0xca, 0x4f, 0x33, 0xfe, 0x5d, 0xc4, 0x6e, 0x42,
	0x73, 0x4f, 0xe7, 0xf7, 0x32, 0xc2, 0xf8, 0x54, 0xc8, 0xf9, 0xa8, 0xc9, 0x7a, 0xf3, 0x52, 0x3d,
	0xbd, 0x3d, 0x53, 0x4c, 0x7a, 0xe9, 0x7c, 0x89, 0xc6, 0x6b, 0x0a, 0x3e, 0xf8, 0x13, 0x00, 0x00,
	0xff, 0xff, 0x79, 0x51, 0x3a, 0x83, 0x68, 0x05, 0x00, 0x00,
}
