// +build go1.9

// Copyright 2019 Microsoft Corporation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/tools/profileBuilder

package backup

import original "github.com/Azure/azure-sdk-for-go/services/recoveryservices/mgmt/2017-07-01/backup"

type BackupsClient = original.BackupsClient

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type BaseClient = original.BaseClient
type EnginesClient = original.EnginesClient
type ExportJobsOperationResultsClient = original.ExportJobsOperationResultsClient
type FeatureSupportClient = original.FeatureSupportClient
type ItemLevelRecoveryConnectionsClient = original.ItemLevelRecoveryConnectionsClient
type JobCancellationsClient = original.JobCancellationsClient
type JobDetailsClient = original.JobDetailsClient
type JobOperationResultsClient = original.JobOperationResultsClient
type JobsClient = original.JobsClient
type JobsGroupClient = original.JobsGroupClient
type AzureFileShareType = original.AzureFileShareType

const (
	Invalid AzureFileShareType = original.Invalid
	XSMB    AzureFileShareType = original.XSMB
	XSync   AzureFileShareType = original.XSync
)

type ContainerType = original.ContainerType

const (
	ContainerTypeAzureBackupServerContainer ContainerType = original.ContainerTypeAzureBackupServerContainer
	ContainerTypeAzureSQLContainer          ContainerType = original.ContainerTypeAzureSQLContainer
	ContainerTypeCluster                    ContainerType = original.ContainerTypeCluster
	ContainerTypeDPMContainer               ContainerType = original.ContainerTypeDPMContainer
	ContainerTypeGenericContainer           ContainerType = original.ContainerTypeGenericContainer
	ContainerTypeIaasVMContainer            ContainerType = original.ContainerTypeIaasVMContainer
	ContainerTypeIaasVMServiceContainer     ContainerType = original.ContainerTypeIaasVMServiceContainer
	ContainerTypeInvalid                    ContainerType = original.ContainerTypeInvalid
	ContainerTypeMABContainer               ContainerType = original.ContainerTypeMABContainer
	ContainerTypeSQLAGWorkLoadContainer     ContainerType = original.ContainerTypeSQLAGWorkLoadContainer
	ContainerTypeStorageContainer           ContainerType = original.ContainerTypeStorageContainer
	ContainerTypeUnknown                    ContainerType = original.ContainerTypeUnknown
	ContainerTypeVCenter                    ContainerType = original.ContainerTypeVCenter
	ContainerTypeVMAppContainer             ContainerType = original.ContainerTypeVMAppContainer
	ContainerTypeWindows                    ContainerType = original.ContainerTypeWindows
)

type ContainerTypeBasicProtectionContainer = original.ContainerTypeBasicProtectionContainer

const (
	ContainerTypeAzureBackupServerContainer1            ContainerTypeBasicProtectionContainer = original.ContainerTypeAzureBackupServerContainer1
	ContainerTypeAzureSQLContainer1                     ContainerTypeBasicProtectionContainer = original.ContainerTypeAzureSQLContainer1
	ContainerTypeAzureWorkloadContainer                 ContainerTypeBasicProtectionContainer = original.ContainerTypeAzureWorkloadContainer
	ContainerTypeDPMContainer1                          ContainerTypeBasicProtectionContainer = original.ContainerTypeDPMContainer1
	ContainerTypeGenericContainer1                      ContainerTypeBasicProtectionContainer = original.ContainerTypeGenericContainer1
	ContainerTypeIaaSVMContainer                        ContainerTypeBasicProtectionContainer = original.ContainerTypeIaaSVMContainer
	ContainerTypeMicrosoftClassicComputevirtualMachines ContainerTypeBasicProtectionContainer = original.ContainerTypeMicrosoftClassicComputevirtualMachines
	ContainerTypeMicrosoftComputevirtualMachines        ContainerTypeBasicProtectionContainer = original.ContainerTypeMicrosoftComputevirtualMachines
	ContainerTypeProtectionContainer                    ContainerTypeBasicProtectionContainer = original.ContainerTypeProtectionContainer
	ContainerTypeSQLAGWorkLoadContainer1                ContainerTypeBasicProtectionContainer = original.ContainerTypeSQLAGWorkLoadContainer1
	ContainerTypeStorageContainer1                      ContainerTypeBasicProtectionContainer = original.ContainerTypeStorageContainer1
	ContainerTypeVMAppContainer1                        ContainerTypeBasicProtectionContainer = original.ContainerTypeVMAppContainer1
	ContainerTypeWindows1                               ContainerTypeBasicProtectionContainer = original.ContainerTypeWindows1
)

type CopyOptions = original.CopyOptions

const (
	CopyOptionsCreateCopy     CopyOptions = original.CopyOptionsCreateCopy
	CopyOptionsFailOnConflict CopyOptions = original.CopyOptionsFailOnConflict
	CopyOptionsInvalid        CopyOptions = original.CopyOptionsInvalid
	CopyOptionsOverwrite      CopyOptions = original.CopyOptionsOverwrite
	CopyOptionsSkip           CopyOptions = original.CopyOptionsSkip
)

type CreateMode = original.CreateMode

const (
	CreateModeDefault CreateMode = original.CreateModeDefault
	CreateModeInvalid CreateMode = original.CreateModeInvalid
	CreateModeRecover CreateMode = original.CreateModeRecover
)

type DataSourceType = original.DataSourceType

const (
	DataSourceTypeAzureFileShare    DataSourceType = original.DataSourceTypeAzureFileShare
	DataSourceTypeAzureSQLDb        DataSourceType = original.DataSourceTypeAzureSQLDb
	DataSourceTypeClient            DataSourceType = original.DataSourceTypeClient
	DataSourceTypeExchange          DataSourceType = original.DataSourceTypeExchange
	DataSourceTypeFileFolder        DataSourceType = original.DataSourceTypeFileFolder
	DataSourceTypeGenericDataSource DataSourceType = original.DataSourceTypeGenericDataSource
	DataSourceTypeInvalid           DataSourceType = original.DataSourceTypeInvalid
	DataSourceTypeSAPHanaDatabase   DataSourceType = original.DataSourceTypeSAPHanaDatabase
	DataSourceTypeSharepoint        DataSourceType = original.DataSourceTypeSharepoint
	DataSourceTypeSQLDataBase       DataSourceType = original.DataSourceTypeSQLDataBase
	DataSourceTypeSQLDB             DataSourceType = original.DataSourceTypeSQLDB
	DataSourceTypeSystemState       DataSourceType = original.DataSourceTypeSystemState
	DataSourceTypeVM                DataSourceType = original.DataSourceTypeVM
	DataSourceTypeVMwareVM          DataSourceType = original.DataSourceTypeVMwareVM
)

type DayOfWeek = original.DayOfWeek

const (
	Friday    DayOfWeek = original.Friday
	Monday    DayOfWeek = original.Monday
	Saturday  DayOfWeek = original.Saturday
	Sunday    DayOfWeek = original.Sunday
	Thursday  DayOfWeek = original.Thursday
	Tuesday   DayOfWeek = original.Tuesday
	Wednesday DayOfWeek = original.Wednesday
)

type EngineType = original.EngineType

const (
	BackupEngineTypeAzureBackupServerEngine EngineType = original.BackupEngineTypeAzureBackupServerEngine
	BackupEngineTypeBackupEngineBase        EngineType = original.BackupEngineTypeBackupEngineBase
	BackupEngineTypeDpmBackupEngine         EngineType = original.BackupEngineTypeDpmBackupEngine
)

type EnhancedSecurityState = original.EnhancedSecurityState

const (
	EnhancedSecurityStateDisabled EnhancedSecurityState = original.EnhancedSecurityStateDisabled
	EnhancedSecurityStateEnabled  EnhancedSecurityState = original.EnhancedSecurityStateEnabled
	EnhancedSecurityStateInvalid  EnhancedSecurityState = original.EnhancedSecurityStateInvalid
)

type FabricName = original.FabricName

const (
	FabricNameAzure   FabricName = original.FabricNameAzure
	FabricNameInvalid FabricName = original.FabricNameInvalid
)

type FeatureType = original.FeatureType

const (
	FeatureTypeAzureBackupGoals      FeatureType = original.FeatureTypeAzureBackupGoals
	FeatureTypeAzureVMResourceBackup FeatureType = original.FeatureTypeAzureVMResourceBackup
	FeatureTypeFeatureSupportRequest FeatureType = original.FeatureTypeFeatureSupportRequest
)

type HealthState = original.HealthState

const (
	HealthStateActionRequired  HealthState = original.HealthStateActionRequired
	HealthStateActionSuggested HealthState = original.HealthStateActionSuggested
	HealthStateInvalid         HealthState = original.HealthStateInvalid
	HealthStatePassed          HealthState = original.HealthStatePassed
)

type HealthStatus = original.HealthStatus

const (
	HealthStatusActionRequired  HealthStatus = original.HealthStatusActionRequired
	HealthStatusActionSuggested HealthStatus = original.HealthStatusActionSuggested
	HealthStatusInvalid         HealthStatus = original.HealthStatusInvalid
	HealthStatusPassed          HealthStatus = original.HealthStatusPassed
)

type HTTPStatusCode = original.HTTPStatusCode

const (
	Accepted                     HTTPStatusCode = original.Accepted
	Ambiguous                    HTTPStatusCode = original.Ambiguous
	BadGateway                   HTTPStatusCode = original.BadGateway
	BadRequest                   HTTPStatusCode = original.BadRequest
	Conflict                     HTTPStatusCode = original.Conflict
	Continue                     HTTPStatusCode = original.Continue
	Created                      HTTPStatusCode = original.Created
	ExpectationFailed            HTTPStatusCode = original.ExpectationFailed
	Forbidden                    HTTPStatusCode = original.Forbidden
	Found                        HTTPStatusCode = original.Found
	GatewayTimeout               HTTPStatusCode = original.GatewayTimeout
	Gone                         HTTPStatusCode = original.Gone
	HTTPVersionNotSupported      HTTPStatusCode = original.HTTPVersionNotSupported
	InternalServerError          HTTPStatusCode = original.InternalServerError
	LengthRequired               HTTPStatusCode = original.LengthRequired
	MethodNotAllowed             HTTPStatusCode = original.MethodNotAllowed
	Moved                        HTTPStatusCode = original.Moved
	MovedPermanently             HTTPStatusCode = original.MovedPermanently
	MultipleChoices              HTTPStatusCode = original.MultipleChoices
	NoContent                    HTTPStatusCode = original.NoContent
	NonAuthoritativeInformation  HTTPStatusCode = original.NonAuthoritativeInformation
	NotAcceptable                HTTPStatusCode = original.NotAcceptable
	NotFound                     HTTPStatusCode = original.NotFound
	NotImplemented               HTTPStatusCode = original.NotImplemented
	NotModified                  HTTPStatusCode = original.NotModified
	OK                           HTTPStatusCode = original.OK
	PartialContent               HTTPStatusCode = original.PartialContent
	PaymentRequired              HTTPStatusCode = original.PaymentRequired
	PreconditionFailed           HTTPStatusCode = original.PreconditionFailed
	ProxyAuthenticationRequired  HTTPStatusCode = original.ProxyAuthenticationRequired
	Redirect                     HTTPStatusCode = original.Redirect
	RedirectKeepVerb             HTTPStatusCode = original.RedirectKeepVerb
	RedirectMethod               HTTPStatusCode = original.RedirectMethod
	RequestedRangeNotSatisfiable HTTPStatusCode = original.RequestedRangeNotSatisfiable
	RequestEntityTooLarge        HTTPStatusCode = original.RequestEntityTooLarge
	RequestTimeout               HTTPStatusCode = original.RequestTimeout
	RequestURITooLong            HTTPStatusCode = original.RequestURITooLong
	ResetContent                 HTTPStatusCode = original.ResetContent
	SeeOther                     HTTPStatusCode = original.SeeOther
	ServiceUnavailable           HTTPStatusCode = original.ServiceUnavailable
	SwitchingProtocols           HTTPStatusCode = original.SwitchingProtocols
	TemporaryRedirect            HTTPStatusCode = original.TemporaryRedirect
	Unauthorized                 HTTPStatusCode = original.Unauthorized
	UnsupportedMediaType         HTTPStatusCode = original.UnsupportedMediaType
	Unused                       HTTPStatusCode = original.Unused
	UpgradeRequired              HTTPStatusCode = original.UpgradeRequired
	UseProxy                     HTTPStatusCode = original.UseProxy
)

type InquiryStatus = original.InquiryStatus

const (
	InquiryStatusFailed  InquiryStatus = original.InquiryStatusFailed
	InquiryStatusInvalid InquiryStatus = original.InquiryStatusInvalid
	InquiryStatusSuccess InquiryStatus = original.InquiryStatusSuccess
)

type ItemType = original.ItemType

const (
	ItemTypeAzureFileShare    ItemType = original.ItemTypeAzureFileShare
	ItemTypeAzureSQLDb        ItemType = original.ItemTypeAzureSQLDb
	ItemTypeClient            ItemType = original.ItemTypeClient
	ItemTypeExchange          ItemType = original.ItemTypeExchange
	ItemTypeFileFolder        ItemType = original.ItemTypeFileFolder
	ItemTypeGenericDataSource ItemType = original.ItemTypeGenericDataSource
	ItemTypeInvalid           ItemType = original.ItemTypeInvalid
	ItemTypeSAPHanaDatabase   ItemType = original.ItemTypeSAPHanaDatabase
	ItemTypeSharepoint        ItemType = original.ItemTypeSharepoint
	ItemTypeSQLDataBase       ItemType = original.ItemTypeSQLDataBase
	ItemTypeSQLDB             ItemType = original.ItemTypeSQLDB
	ItemTypeSystemState       ItemType = original.ItemTypeSystemState
	ItemTypeVM                ItemType = original.ItemTypeVM
	ItemTypeVMwareVM          ItemType = original.ItemTypeVMwareVM
)

type JobOperationType = original.JobOperationType

const (
	JobOperationTypeBackup           JobOperationType = original.JobOperationTypeBackup
	JobOperationTypeConfigureBackup  JobOperationType = original.JobOperationTypeConfigureBackup
	JobOperationTypeDeleteBackupData JobOperationType = original.JobOperationTypeDeleteBackupData
	JobOperationTypeDisableBackup    JobOperationType = original.JobOperationTypeDisableBackup
	JobOperationTypeInvalid          JobOperationType = original.JobOperationTypeInvalid
	JobOperationTypeRegister         JobOperationType = original.JobOperationTypeRegister
	JobOperationTypeRestore          JobOperationType = original.JobOperationTypeRestore
	JobOperationTypeUnRegister       JobOperationType = original.JobOperationTypeUnRegister
)

type JobStatus = original.JobStatus

const (
	JobStatusCancelled             JobStatus = original.JobStatusCancelled
	JobStatusCancelling            JobStatus = original.JobStatusCancelling
	JobStatusCompleted             JobStatus = original.JobStatusCompleted
	JobStatusCompletedWithWarnings JobStatus = original.JobStatusCompletedWithWarnings
	JobStatusFailed                JobStatus = original.JobStatusFailed
	JobStatusInProgress            JobStatus = original.JobStatusInProgress
	JobStatusInvalid               JobStatus = original.JobStatusInvalid
)

type JobSupportedAction = original.JobSupportedAction

const (
	JobSupportedActionCancellable JobSupportedAction = original.JobSupportedActionCancellable
	JobSupportedActionInvalid     JobSupportedAction = original.JobSupportedActionInvalid
	JobSupportedActionRetriable   JobSupportedAction = original.JobSupportedActionRetriable
)

type JobType = original.JobType

const (
	JobTypeAzureIaaSVMJob   JobType = original.JobTypeAzureIaaSVMJob
	JobTypeAzureStorageJob  JobType = original.JobTypeAzureStorageJob
	JobTypeAzureWorkloadJob JobType = original.JobTypeAzureWorkloadJob
	JobTypeDpmJob           JobType = original.JobTypeDpmJob
	JobTypeJob              JobType = original.JobTypeJob
	JobTypeMabJob           JobType = original.JobTypeMabJob
)

type LastBackupStatus = original.LastBackupStatus

const (
	LastBackupStatusHealthy   LastBackupStatus = original.LastBackupStatusHealthy
	LastBackupStatusInvalid   LastBackupStatus = original.LastBackupStatusInvalid
	LastBackupStatusIRPending LastBackupStatus = original.LastBackupStatusIRPending
	LastBackupStatusUnhealthy LastBackupStatus = original.LastBackupStatusUnhealthy
)

type MabServerType = original.MabServerType

const (
	MabServerTypeAzureBackupServerContainer MabServerType = original.MabServerTypeAzureBackupServerContainer
	MabServerTypeAzureSQLContainer          MabServerType = original.MabServerTypeAzureSQLContainer
	MabServerTypeCluster                    MabServerType = original.MabServerTypeCluster
	MabServerTypeDPMContainer               MabServerType = original.MabServerTypeDPMContainer
	MabServerTypeGenericContainer           MabServerType = original.MabServerTypeGenericContainer
	MabServerTypeIaasVMContainer            MabServerType = original.MabServerTypeIaasVMContainer
	MabServerTypeIaasVMServiceContainer     MabServerType = original.MabServerTypeIaasVMServiceContainer
	MabServerTypeInvalid                    MabServerType = original.MabServerTypeInvalid
	MabServerTypeMABContainer               MabServerType = original.MabServerTypeMABContainer
	MabServerTypeSQLAGWorkLoadContainer     MabServerType = original.MabServerTypeSQLAGWorkLoadContainer
	MabServerTypeStorageContainer           MabServerType = original.MabServerTypeStorageContainer
	MabServerTypeUnknown                    MabServerType = original.MabServerTypeUnknown
	MabServerTypeVCenter                    MabServerType = original.MabServerTypeVCenter
	MabServerTypeVMAppContainer             MabServerType = original.MabServerTypeVMAppContainer
	MabServerTypeWindows                    MabServerType = original.MabServerTypeWindows
)

type ManagementType = original.ManagementType

const (
	ManagementTypeAzureBackupServer ManagementType = original.ManagementTypeAzureBackupServer
	ManagementTypeAzureIaasVM       ManagementType = original.ManagementTypeAzureIaasVM
	ManagementTypeAzureSQL          ManagementType = original.ManagementTypeAzureSQL
	ManagementTypeAzureStorage      ManagementType = original.ManagementTypeAzureStorage
	ManagementTypeAzureWorkload     ManagementType = original.ManagementTypeAzureWorkload
	ManagementTypeDefaultBackup     ManagementType = original.ManagementTypeDefaultBackup
	ManagementTypeDPM               ManagementType = original.ManagementTypeDPM
	ManagementTypeInvalid           ManagementType = original.ManagementTypeInvalid
	ManagementTypeMAB               ManagementType = original.ManagementTypeMAB
)

type ManagementTypeBasicProtectionPolicy = original.ManagementTypeBasicProtectionPolicy

const (
	BackupManagementTypeAzureIaasVM             ManagementTypeBasicProtectionPolicy = original.BackupManagementTypeAzureIaasVM
	BackupManagementTypeAzureSQL                ManagementTypeBasicProtectionPolicy = original.BackupManagementTypeAzureSQL
	BackupManagementTypeAzureStorage            ManagementTypeBasicProtectionPolicy = original.BackupManagementTypeAzureStorage
	BackupManagementTypeAzureWorkload           ManagementTypeBasicProtectionPolicy = original.BackupManagementTypeAzureWorkload
	BackupManagementTypeGenericProtectionPolicy ManagementTypeBasicProtectionPolicy = original.BackupManagementTypeGenericProtectionPolicy
	BackupManagementTypeMAB                     ManagementTypeBasicProtectionPolicy = original.BackupManagementTypeMAB
	BackupManagementTypeProtectionPolicy        ManagementTypeBasicProtectionPolicy = original.BackupManagementTypeProtectionPolicy
)

type MonthOfYear = original.MonthOfYear

const (
	MonthOfYearApril     MonthOfYear = original.MonthOfYearApril
	MonthOfYearAugust    MonthOfYear = original.MonthOfYearAugust
	MonthOfYearDecember  MonthOfYear = original.MonthOfYearDecember
	MonthOfYearFebruary  MonthOfYear = original.MonthOfYearFebruary
	MonthOfYearInvalid   MonthOfYear = original.MonthOfYearInvalid
	MonthOfYearJanuary   MonthOfYear = original.MonthOfYearJanuary
	MonthOfYearJuly      MonthOfYear = original.MonthOfYearJuly
	MonthOfYearJune      MonthOfYear = original.MonthOfYearJune
	MonthOfYearMarch     MonthOfYear = original.MonthOfYearMarch
	MonthOfYearMay       MonthOfYear = original.MonthOfYearMay
	MonthOfYearNovember  MonthOfYear = original.MonthOfYearNovember
	MonthOfYearOctober   MonthOfYear = original.MonthOfYearOctober
	MonthOfYearSeptember MonthOfYear = original.MonthOfYearSeptember
)

type ObjectType = original.ObjectType

const (
	ObjectTypeExportJobsOperationResultInfo ObjectType = original.ObjectTypeExportJobsOperationResultInfo
	ObjectTypeOperationResultInfo           ObjectType = original.ObjectTypeOperationResultInfo
	ObjectTypeOperationResultInfoBase       ObjectType = original.ObjectTypeOperationResultInfoBase
)

type ObjectTypeBasicILRRequest = original.ObjectTypeBasicILRRequest

const (
	ObjectTypeIaasVMILRRegistrationRequest ObjectTypeBasicILRRequest = original.ObjectTypeIaasVMILRRegistrationRequest
	ObjectTypeILRRequest                   ObjectTypeBasicILRRequest = original.ObjectTypeILRRequest
)

type ObjectTypeBasicOperationStatusExtendedInfo = original.ObjectTypeBasicOperationStatusExtendedInfo

const (
	ObjectTypeOperationStatusExtendedInfo             ObjectTypeBasicOperationStatusExtendedInfo = original.ObjectTypeOperationStatusExtendedInfo
	ObjectTypeOperationStatusJobExtendedInfo          ObjectTypeBasicOperationStatusExtendedInfo = original.ObjectTypeOperationStatusJobExtendedInfo
	ObjectTypeOperationStatusJobsExtendedInfo         ObjectTypeBasicOperationStatusExtendedInfo = original.ObjectTypeOperationStatusJobsExtendedInfo
	ObjectTypeOperationStatusProvisionILRExtendedInfo ObjectTypeBasicOperationStatusExtendedInfo = original.ObjectTypeOperationStatusProvisionILRExtendedInfo
)

type ObjectTypeBasicRecoveryPoint = original.ObjectTypeBasicRecoveryPoint

const (
	ObjectTypeAzureFileShareRecoveryPoint                  ObjectTypeBasicRecoveryPoint = original.ObjectTypeAzureFileShareRecoveryPoint
	ObjectTypeAzureWorkloadRecoveryPoint                   ObjectTypeBasicRecoveryPoint = original.ObjectTypeAzureWorkloadRecoveryPoint
	ObjectTypeAzureWorkloadSAPHanaPointInTimeRecoveryPoint ObjectTypeBasicRecoveryPoint = original.ObjectTypeAzureWorkloadSAPHanaPointInTimeRecoveryPoint
	ObjectTypeAzureWorkloadSAPHanaRecoveryPoint            ObjectTypeBasicRecoveryPoint = original.ObjectTypeAzureWorkloadSAPHanaRecoveryPoint
	ObjectTypeAzureWorkloadSQLPointInTimeRecoveryPoint     ObjectTypeBasicRecoveryPoint = original.ObjectTypeAzureWorkloadSQLPointInTimeRecoveryPoint
	ObjectTypeAzureWorkloadSQLRecoveryPoint                ObjectTypeBasicRecoveryPoint = original.ObjectTypeAzureWorkloadSQLRecoveryPoint
	ObjectTypeGenericRecoveryPoint                         ObjectTypeBasicRecoveryPoint = original.ObjectTypeGenericRecoveryPoint
	ObjectTypeIaasVMRecoveryPoint                          ObjectTypeBasicRecoveryPoint = original.ObjectTypeIaasVMRecoveryPoint
	ObjectTypeRecoveryPoint                                ObjectTypeBasicRecoveryPoint = original.ObjectTypeRecoveryPoint
)

type ObjectTypeBasicRequest = original.ObjectTypeBasicRequest

const (
	ObjectTypeAzureFileShareBackupRequest ObjectTypeBasicRequest = original.ObjectTypeAzureFileShareBackupRequest
	ObjectTypeAzureWorkloadBackupRequest  ObjectTypeBasicRequest = original.ObjectTypeAzureWorkloadBackupRequest
	ObjectTypeBackupRequest               ObjectTypeBasicRequest = original.ObjectTypeBackupRequest
	ObjectTypeIaasVMBackupRequest         ObjectTypeBasicRequest = original.ObjectTypeIaasVMBackupRequest
)

type ObjectTypeBasicRestoreRequest = original.ObjectTypeBasicRestoreRequest

const (
	ObjectTypeAzureFileShareRestoreRequest                  ObjectTypeBasicRestoreRequest = original.ObjectTypeAzureFileShareRestoreRequest
	ObjectTypeAzureWorkloadRestoreRequest                   ObjectTypeBasicRestoreRequest = original.ObjectTypeAzureWorkloadRestoreRequest
	ObjectTypeAzureWorkloadSAPHanaPointInTimeRestoreRequest ObjectTypeBasicRestoreRequest = original.ObjectTypeAzureWorkloadSAPHanaPointInTimeRestoreRequest
	ObjectTypeAzureWorkloadSAPHanaRestoreRequest            ObjectTypeBasicRestoreRequest = original.ObjectTypeAzureWorkloadSAPHanaRestoreRequest
	ObjectTypeAzureWorkloadSQLPointInTimeRestoreRequest     ObjectTypeBasicRestoreRequest = original.ObjectTypeAzureWorkloadSQLPointInTimeRestoreRequest
	ObjectTypeAzureWorkloadSQLRestoreRequest                ObjectTypeBasicRestoreRequest = original.ObjectTypeAzureWorkloadSQLRestoreRequest
	ObjectTypeIaasVMRestoreRequest                          ObjectTypeBasicRestoreRequest = original.ObjectTypeIaasVMRestoreRequest
	ObjectTypeRestoreRequest                                ObjectTypeBasicRestoreRequest = original.ObjectTypeRestoreRequest
)

type ObjectTypeBasicValidateOperationRequest = original.ObjectTypeBasicValidateOperationRequest

const (
	ObjectTypeValidateIaasVMRestoreOperationRequest ObjectTypeBasicValidateOperationRequest = original.ObjectTypeValidateIaasVMRestoreOperationRequest
	ObjectTypeValidateOperationRequest              ObjectTypeBasicValidateOperationRequest = original.ObjectTypeValidateOperationRequest
	ObjectTypeValidateRestoreOperationRequest       ObjectTypeBasicValidateOperationRequest = original.ObjectTypeValidateRestoreOperationRequest
)

type OperationStatusValues = original.OperationStatusValues

const (
	OperationStatusValuesCanceled   OperationStatusValues = original.OperationStatusValuesCanceled
	OperationStatusValuesFailed     OperationStatusValues = original.OperationStatusValuesFailed
	OperationStatusValuesInProgress OperationStatusValues = original.OperationStatusValuesInProgress
	OperationStatusValuesInvalid    OperationStatusValues = original.OperationStatusValuesInvalid
	OperationStatusValuesSucceeded  OperationStatusValues = original.OperationStatusValuesSucceeded
)

type OverwriteOptions = original.OverwriteOptions

const (
	OverwriteOptionsFailOnConflict OverwriteOptions = original.OverwriteOptionsFailOnConflict
	OverwriteOptionsInvalid        OverwriteOptions = original.OverwriteOptionsInvalid
	OverwriteOptionsOverwrite      OverwriteOptions = original.OverwriteOptionsOverwrite
)

type ProtectableContainerType = original.ProtectableContainerType

const (
	ProtectableContainerTypeProtectableContainer ProtectableContainerType = original.ProtectableContainerTypeProtectableContainer
	ProtectableContainerTypeStorageContainer     ProtectableContainerType = original.ProtectableContainerTypeStorageContainer
	ProtectableContainerTypeVMAppContainer       ProtectableContainerType = original.ProtectableContainerTypeVMAppContainer
)

type ProtectableItemType = original.ProtectableItemType

const (
	ProtectableItemTypeAzureFileShare                         ProtectableItemType = original.ProtectableItemTypeAzureFileShare
	ProtectableItemTypeAzureVMWorkloadProtectableItem         ProtectableItemType = original.ProtectableItemTypeAzureVMWorkloadProtectableItem
	ProtectableItemTypeIaaSVMProtectableItem                  ProtectableItemType = original.ProtectableItemTypeIaaSVMProtectableItem
	ProtectableItemTypeMicrosoftClassicComputevirtualMachines ProtectableItemType = original.ProtectableItemTypeMicrosoftClassicComputevirtualMachines
	ProtectableItemTypeMicrosoftComputevirtualMachines        ProtectableItemType = original.ProtectableItemTypeMicrosoftComputevirtualMachines
	ProtectableItemTypeSAPHanaDatabase                        ProtectableItemType = original.ProtectableItemTypeSAPHanaDatabase
	ProtectableItemTypeSAPHanaSystem                          ProtectableItemType = original.ProtectableItemTypeSAPHanaSystem
	ProtectableItemTypeSQLAvailabilityGroupContainer          ProtectableItemType = original.ProtectableItemTypeSQLAvailabilityGroupContainer
	ProtectableItemTypeSQLDataBase                            ProtectableItemType = original.ProtectableItemTypeSQLDataBase
	ProtectableItemTypeSQLInstance                            ProtectableItemType = original.ProtectableItemTypeSQLInstance
	ProtectableItemTypeWorkloadProtectableItem                ProtectableItemType = original.ProtectableItemTypeWorkloadProtectableItem
)

type ProtectedItemHealthStatus = original.ProtectedItemHealthStatus

const (
	ProtectedItemHealthStatusHealthy      ProtectedItemHealthStatus = original.ProtectedItemHealthStatusHealthy
	ProtectedItemHealthStatusInvalid      ProtectedItemHealthStatus = original.ProtectedItemHealthStatusInvalid
	ProtectedItemHealthStatusIRPending    ProtectedItemHealthStatus = original.ProtectedItemHealthStatusIRPending
	ProtectedItemHealthStatusNotReachable ProtectedItemHealthStatus = original.ProtectedItemHealthStatusNotReachable
	ProtectedItemHealthStatusUnhealthy    ProtectedItemHealthStatus = original.ProtectedItemHealthStatusUnhealthy
)

type ProtectedItemState = original.ProtectedItemState

const (
	ProtectedItemStateInvalid           ProtectedItemState = original.ProtectedItemStateInvalid
	ProtectedItemStateIRPending         ProtectedItemState = original.ProtectedItemStateIRPending
	ProtectedItemStateProtected         ProtectedItemState = original.ProtectedItemStateProtected
	ProtectedItemStateProtectionError   ProtectedItemState = original.ProtectedItemStateProtectionError
	ProtectedItemStateProtectionPaused  ProtectedItemState = original.ProtectedItemStateProtectionPaused
	ProtectedItemStateProtectionStopped ProtectedItemState = original.ProtectedItemStateProtectionStopped
)

type ProtectedItemType = original.ProtectedItemType

const (
	ProtectedItemTypeAzureFileShareProtectedItem            ProtectedItemType = original.ProtectedItemTypeAzureFileShareProtectedItem
	ProtectedItemTypeAzureIaaSVMProtectedItem               ProtectedItemType = original.ProtectedItemTypeAzureIaaSVMProtectedItem
	ProtectedItemTypeAzureVMWorkloadProtectedItem           ProtectedItemType = original.ProtectedItemTypeAzureVMWorkloadProtectedItem
	ProtectedItemTypeAzureVMWorkloadSAPHanaDatabase         ProtectedItemType = original.ProtectedItemTypeAzureVMWorkloadSAPHanaDatabase
	ProtectedItemTypeAzureVMWorkloadSQLDatabase             ProtectedItemType = original.ProtectedItemTypeAzureVMWorkloadSQLDatabase
	ProtectedItemTypeDPMProtectedItem                       ProtectedItemType = original.ProtectedItemTypeDPMProtectedItem
	ProtectedItemTypeGenericProtectedItem                   ProtectedItemType = original.ProtectedItemTypeGenericProtectedItem
	ProtectedItemTypeMabFileFolderProtectedItem             ProtectedItemType = original.ProtectedItemTypeMabFileFolderProtectedItem
	ProtectedItemTypeMicrosoftClassicComputevirtualMachines ProtectedItemType = original.ProtectedItemTypeMicrosoftClassicComputevirtualMachines
	ProtectedItemTypeMicrosoftComputevirtualMachines        ProtectedItemType = original.ProtectedItemTypeMicrosoftComputevirtualMachines
	ProtectedItemTypeMicrosoftSqlserversdatabases           ProtectedItemType = original.ProtectedItemTypeMicrosoftSqlserversdatabases
	ProtectedItemTypeProtectedItem                          ProtectedItemType = original.ProtectedItemTypeProtectedItem
)

type ProtectionIntentItemType = original.ProtectionIntentItemType

const (
	ProtectionIntentItemTypeAzureResourceItem                    ProtectionIntentItemType = original.ProtectionIntentItemTypeAzureResourceItem
	ProtectionIntentItemTypeAzureWorkloadAutoProtectionIntent    ProtectionIntentItemType = original.ProtectionIntentItemTypeAzureWorkloadAutoProtectionIntent
	ProtectionIntentItemTypeAzureWorkloadSQLAutoProtectionIntent ProtectionIntentItemType = original.ProtectionIntentItemTypeAzureWorkloadSQLAutoProtectionIntent
	ProtectionIntentItemTypeProtectionIntent                     ProtectionIntentItemType = original.ProtectionIntentItemTypeProtectionIntent
	ProtectionIntentItemTypeRecoveryServiceVaultItem             ProtectionIntentItemType = original.ProtectionIntentItemTypeRecoveryServiceVaultItem
)

type ProtectionState = original.ProtectionState

const (
	ProtectionStateInvalid           ProtectionState = original.ProtectionStateInvalid
	ProtectionStateIRPending         ProtectionState = original.ProtectionStateIRPending
	ProtectionStateProtected         ProtectionState = original.ProtectionStateProtected
	ProtectionStateProtectionError   ProtectionState = original.ProtectionStateProtectionError
	ProtectionStateProtectionPaused  ProtectionState = original.ProtectionStateProtectionPaused
	ProtectionStateProtectionStopped ProtectionState = original.ProtectionStateProtectionStopped
)

type ProtectionStatus = original.ProtectionStatus

const (
	ProtectionStatusInvalid          ProtectionStatus = original.ProtectionStatusInvalid
	ProtectionStatusNotProtected     ProtectionStatus = original.ProtectionStatusNotProtected
	ProtectionStatusProtected        ProtectionStatus = original.ProtectionStatusProtected
	ProtectionStatusProtecting       ProtectionStatus = original.ProtectionStatusProtecting
	ProtectionStatusProtectionFailed ProtectionStatus = original.ProtectionStatusProtectionFailed
)

type RecoveryPointTierStatus = original.RecoveryPointTierStatus

const (
	RecoveryPointTierStatusDeleted  RecoveryPointTierStatus = original.RecoveryPointTierStatusDeleted
	RecoveryPointTierStatusDisabled RecoveryPointTierStatus = original.RecoveryPointTierStatusDisabled
	RecoveryPointTierStatusInvalid  RecoveryPointTierStatus = original.RecoveryPointTierStatusInvalid
	RecoveryPointTierStatusValid    RecoveryPointTierStatus = original.RecoveryPointTierStatusValid
)

type RecoveryPointTierType = original.RecoveryPointTierType

const (
	RecoveryPointTierTypeHardenedRP RecoveryPointTierType = original.RecoveryPointTierTypeHardenedRP
	RecoveryPointTierTypeInstantRP  RecoveryPointTierType = original.RecoveryPointTierTypeInstantRP
	RecoveryPointTierTypeInvalid    RecoveryPointTierType = original.RecoveryPointTierTypeInvalid
)

type RecoveryType = original.RecoveryType

const (
	RecoveryTypeAlternateLocation RecoveryType = original.RecoveryTypeAlternateLocation
	RecoveryTypeInvalid           RecoveryType = original.RecoveryTypeInvalid
	RecoveryTypeOriginalLocation  RecoveryType = original.RecoveryTypeOriginalLocation
	RecoveryTypeRestoreDisks      RecoveryType = original.RecoveryTypeRestoreDisks
)

type RestorePointQueryType = original.RestorePointQueryType

const (
	RestorePointQueryTypeAll                 RestorePointQueryType = original.RestorePointQueryTypeAll
	RestorePointQueryTypeDifferential        RestorePointQueryType = original.RestorePointQueryTypeDifferential
	RestorePointQueryTypeFull                RestorePointQueryType = original.RestorePointQueryTypeFull
	RestorePointQueryTypeFullAndDifferential RestorePointQueryType = original.RestorePointQueryTypeFullAndDifferential
	RestorePointQueryTypeInvalid             RestorePointQueryType = original.RestorePointQueryTypeInvalid
	RestorePointQueryTypeLog                 RestorePointQueryType = original.RestorePointQueryTypeLog
)

type RestorePointType = original.RestorePointType

const (
	RestorePointTypeDifferential RestorePointType = original.RestorePointTypeDifferential
	RestorePointTypeFull         RestorePointType = original.RestorePointTypeFull
	RestorePointTypeInvalid      RestorePointType = original.RestorePointTypeInvalid
	RestorePointTypeLog          RestorePointType = original.RestorePointTypeLog
)

type RestoreRequestType = original.RestoreRequestType

const (
	RestoreRequestTypeFullShareRestore RestoreRequestType = original.RestoreRequestTypeFullShareRestore
	RestoreRequestTypeInvalid          RestoreRequestType = original.RestoreRequestTypeInvalid
	RestoreRequestTypeItemLevelRestore RestoreRequestType = original.RestoreRequestTypeItemLevelRestore
)

type RetentionDurationType = original.RetentionDurationType

const (
	RetentionDurationTypeDays    RetentionDurationType = original.RetentionDurationTypeDays
	RetentionDurationTypeInvalid RetentionDurationType = original.RetentionDurationTypeInvalid
	RetentionDurationTypeMonths  RetentionDurationType = original.RetentionDurationTypeMonths
	RetentionDurationTypeWeeks   RetentionDurationType = original.RetentionDurationTypeWeeks
	RetentionDurationTypeYears   RetentionDurationType = original.RetentionDurationTypeYears
)

type RetentionPolicyType = original.RetentionPolicyType

const (
	RetentionPolicyTypeLongTermRetentionPolicy RetentionPolicyType = original.RetentionPolicyTypeLongTermRetentionPolicy
	RetentionPolicyTypeRetentionPolicy         RetentionPolicyType = original.RetentionPolicyTypeRetentionPolicy
	RetentionPolicyTypeSimpleRetentionPolicy   RetentionPolicyType = original.RetentionPolicyTypeSimpleRetentionPolicy
)

type RetentionScheduleFormat = original.RetentionScheduleFormat

const (
	RetentionScheduleFormatDaily   RetentionScheduleFormat = original.RetentionScheduleFormatDaily
	RetentionScheduleFormatInvalid RetentionScheduleFormat = original.RetentionScheduleFormatInvalid
	RetentionScheduleFormatWeekly  RetentionScheduleFormat = original.RetentionScheduleFormatWeekly
)

type SchedulePolicyType = original.SchedulePolicyType

const (
	SchedulePolicyTypeLogSchedulePolicy      SchedulePolicyType = original.SchedulePolicyTypeLogSchedulePolicy
	SchedulePolicyTypeLongTermSchedulePolicy SchedulePolicyType = original.SchedulePolicyTypeLongTermSchedulePolicy
	SchedulePolicyTypeSchedulePolicy         SchedulePolicyType = original.SchedulePolicyTypeSchedulePolicy
	SchedulePolicyTypeSimpleSchedulePolicy   SchedulePolicyType = original.SchedulePolicyTypeSimpleSchedulePolicy
)

type ScheduleRunType = original.ScheduleRunType

const (
	ScheduleRunTypeDaily   ScheduleRunType = original.ScheduleRunTypeDaily
	ScheduleRunTypeInvalid ScheduleRunType = original.ScheduleRunTypeInvalid
	ScheduleRunTypeWeekly  ScheduleRunType = original.ScheduleRunTypeWeekly
)

type SQLDataDirectoryType = original.SQLDataDirectoryType

const (
	SQLDataDirectoryTypeData    SQLDataDirectoryType = original.SQLDataDirectoryTypeData
	SQLDataDirectoryTypeInvalid SQLDataDirectoryType = original.SQLDataDirectoryTypeInvalid
	SQLDataDirectoryTypeLog     SQLDataDirectoryType = original.SQLDataDirectoryTypeLog
)

type StorageType = original.StorageType

const (
	StorageTypeGeoRedundant     StorageType = original.StorageTypeGeoRedundant
	StorageTypeInvalid          StorageType = original.StorageTypeInvalid
	StorageTypeLocallyRedundant StorageType = original.StorageTypeLocallyRedundant
)

type StorageTypeState = original.StorageTypeState

const (
	StorageTypeStateInvalid  StorageTypeState = original.StorageTypeStateInvalid
	StorageTypeStateLocked   StorageTypeState = original.StorageTypeStateLocked
	StorageTypeStateUnlocked StorageTypeState = original.StorageTypeStateUnlocked
)

type SupportStatus = original.SupportStatus

const (
	SupportStatusDefaultOFF   SupportStatus = original.SupportStatusDefaultOFF
	SupportStatusDefaultON    SupportStatus = original.SupportStatusDefaultON
	SupportStatusInvalid      SupportStatus = original.SupportStatusInvalid
	SupportStatusNotSupported SupportStatus = original.SupportStatusNotSupported
	SupportStatusSupported    SupportStatus = original.SupportStatusSupported
)

type Type = original.Type

const (
	TypeBackupProtectedItemCountSummary       Type = original.TypeBackupProtectedItemCountSummary
	TypeBackupProtectionContainerCountSummary Type = original.TypeBackupProtectionContainerCountSummary
	TypeInvalid                               Type = original.TypeInvalid
)

type TypeEnum = original.TypeEnum

const (
	TypeEnumCopyOnlyFull TypeEnum = original.TypeEnumCopyOnlyFull
	TypeEnumDifferential TypeEnum = original.TypeEnumDifferential
	TypeEnumFull         TypeEnum = original.TypeEnumFull
	TypeEnumInvalid      TypeEnum = original.TypeEnumInvalid
	TypeEnumLog          TypeEnum = original.TypeEnumLog
)

type UsagesUnit = original.UsagesUnit

const (
	Bytes          UsagesUnit = original.Bytes
	BytesPerSecond UsagesUnit = original.BytesPerSecond
	Count          UsagesUnit = original.Count
	CountPerSecond UsagesUnit = original.CountPerSecond
	Percent        UsagesUnit = original.Percent
	Seconds        UsagesUnit = original.Seconds
)

type ValidationStatus = original.ValidationStatus

const (
	ValidationStatusFailed    ValidationStatus = original.ValidationStatusFailed
	ValidationStatusInvalid   ValidationStatus = original.ValidationStatusInvalid
	ValidationStatusSucceeded ValidationStatus = original.ValidationStatusSucceeded
)

type WeekOfMonth = original.WeekOfMonth

const (
	WeekOfMonthFirst   WeekOfMonth = original.WeekOfMonthFirst
	WeekOfMonthFourth  WeekOfMonth = original.WeekOfMonthFourth
	WeekOfMonthInvalid WeekOfMonth = original.WeekOfMonthInvalid
	WeekOfMonthLast    WeekOfMonth = original.WeekOfMonthLast
	WeekOfMonthSecond  WeekOfMonth = original.WeekOfMonthSecond
	WeekOfMonthThird   WeekOfMonth = original.WeekOfMonthThird
)

type WorkloadItemType = original.WorkloadItemType

const (
	WorkloadItemTypeInvalid         WorkloadItemType = original.WorkloadItemTypeInvalid
	WorkloadItemTypeSAPHanaDatabase WorkloadItemType = original.WorkloadItemTypeSAPHanaDatabase
	WorkloadItemTypeSAPHanaSystem   WorkloadItemType = original.WorkloadItemTypeSAPHanaSystem
	WorkloadItemTypeSQLDataBase     WorkloadItemType = original.WorkloadItemTypeSQLDataBase
	WorkloadItemTypeSQLInstance     WorkloadItemType = original.WorkloadItemTypeSQLInstance
)

type WorkloadItemTypeBasicWorkloadItem = original.WorkloadItemTypeBasicWorkloadItem

const (
	WorkloadItemTypeAzureVMWorkloadItem WorkloadItemTypeBasicWorkloadItem = original.WorkloadItemTypeAzureVMWorkloadItem
	WorkloadItemTypeSAPHanaDatabase1    WorkloadItemTypeBasicWorkloadItem = original.WorkloadItemTypeSAPHanaDatabase1
	WorkloadItemTypeSAPHanaSystem1      WorkloadItemTypeBasicWorkloadItem = original.WorkloadItemTypeSAPHanaSystem1
	WorkloadItemTypeSQLDataBase1        WorkloadItemTypeBasicWorkloadItem = original.WorkloadItemTypeSQLDataBase1
	WorkloadItemTypeSQLInstance1        WorkloadItemTypeBasicWorkloadItem = original.WorkloadItemTypeSQLInstance1
	WorkloadItemTypeWorkloadItem        WorkloadItemTypeBasicWorkloadItem = original.WorkloadItemTypeWorkloadItem
)

type WorkloadType = original.WorkloadType

const (
	WorkloadTypeAzureFileShare    WorkloadType = original.WorkloadTypeAzureFileShare
	WorkloadTypeAzureSQLDb        WorkloadType = original.WorkloadTypeAzureSQLDb
	WorkloadTypeClient            WorkloadType = original.WorkloadTypeClient
	WorkloadTypeExchange          WorkloadType = original.WorkloadTypeExchange
	WorkloadTypeFileFolder        WorkloadType = original.WorkloadTypeFileFolder
	WorkloadTypeGenericDataSource WorkloadType = original.WorkloadTypeGenericDataSource
	WorkloadTypeInvalid           WorkloadType = original.WorkloadTypeInvalid
	WorkloadTypeSAPHanaDatabase   WorkloadType = original.WorkloadTypeSAPHanaDatabase
	WorkloadTypeSharepoint        WorkloadType = original.WorkloadTypeSharepoint
	WorkloadTypeSQLDataBase       WorkloadType = original.WorkloadTypeSQLDataBase
	WorkloadTypeSQLDB             WorkloadType = original.WorkloadTypeSQLDB
	WorkloadTypeSystemState       WorkloadType = original.WorkloadTypeSystemState
	WorkloadTypeVM                WorkloadType = original.WorkloadTypeVM
	WorkloadTypeVMwareVM          WorkloadType = original.WorkloadTypeVMwareVM
)

type AzureBackupGoalFeatureSupportRequest = original.AzureBackupGoalFeatureSupportRequest
type AzureBackupServerContainer = original.AzureBackupServerContainer
type AzureBackupServerEngine = original.AzureBackupServerEngine
type AzureFileShareBackupRequest = original.AzureFileShareBackupRequest
type AzureFileShareProtectableItem = original.AzureFileShareProtectableItem
type AzureFileshareProtectedItem = original.AzureFileshareProtectedItem
type AzureFileshareProtectedItemExtendedInfo = original.AzureFileshareProtectedItemExtendedInfo
type AzureFileShareProtectionPolicy = original.AzureFileShareProtectionPolicy
type AzureFileShareRecoveryPoint = original.AzureFileShareRecoveryPoint
type AzureFileShareRestoreRequest = original.AzureFileShareRestoreRequest
type AzureIaaSClassicComputeVMContainer = original.AzureIaaSClassicComputeVMContainer
type AzureIaaSClassicComputeVMProtectableItem = original.AzureIaaSClassicComputeVMProtectableItem
type AzureIaaSClassicComputeVMProtectedItem = original.AzureIaaSClassicComputeVMProtectedItem
type AzureIaaSComputeVMContainer = original.AzureIaaSComputeVMContainer
type AzureIaaSComputeVMProtectableItem = original.AzureIaaSComputeVMProtectableItem
type AzureIaaSComputeVMProtectedItem = original.AzureIaaSComputeVMProtectedItem
type AzureIaaSVMErrorInfo = original.AzureIaaSVMErrorInfo
type AzureIaaSVMHealthDetails = original.AzureIaaSVMHealthDetails
type AzureIaaSVMJob = original.AzureIaaSVMJob
type AzureIaaSVMJobExtendedInfo = original.AzureIaaSVMJobExtendedInfo
type AzureIaaSVMJobTaskDetails = original.AzureIaaSVMJobTaskDetails
type BasicAzureIaaSVMProtectedItem = original.BasicAzureIaaSVMProtectedItem
type AzureIaaSVMProtectedItem = original.AzureIaaSVMProtectedItem
type AzureIaaSVMProtectedItemExtendedInfo = original.AzureIaaSVMProtectedItemExtendedInfo
type AzureIaaSVMProtectionPolicy = original.AzureIaaSVMProtectionPolicy
type BasicAzureRecoveryServiceVaultProtectionIntent = original.BasicAzureRecoveryServiceVaultProtectionIntent
type AzureRecoveryServiceVaultProtectionIntent = original.AzureRecoveryServiceVaultProtectionIntent
type AzureResourceProtectionIntent = original.AzureResourceProtectionIntent
type AzureSQLAGWorkloadContainerProtectionContainer = original.AzureSQLAGWorkloadContainerProtectionContainer
type AzureSQLContainer = original.AzureSQLContainer
type AzureSQLProtectedItem = original.AzureSQLProtectedItem
type AzureSQLProtectedItemExtendedInfo = original.AzureSQLProtectedItemExtendedInfo
type AzureSQLProtectionPolicy = original.AzureSQLProtectionPolicy
type AzureStorageContainer = original.AzureStorageContainer
type AzureStorageErrorInfo = original.AzureStorageErrorInfo
type AzureStorageJob = original.AzureStorageJob
type AzureStorageJobExtendedInfo = original.AzureStorageJobExtendedInfo
type AzureStorageJobTaskDetails = original.AzureStorageJobTaskDetails
type AzureStorageProtectableContainer = original.AzureStorageProtectableContainer
type AzureVMAppContainerProtectableContainer = original.AzureVMAppContainerProtectableContainer
type AzureVMAppContainerProtectionContainer = original.AzureVMAppContainerProtectionContainer
type AzureVMResourceFeatureSupportRequest = original.AzureVMResourceFeatureSupportRequest
type AzureVMResourceFeatureSupportResponse = original.AzureVMResourceFeatureSupportResponse
type BasicAzureVMWorkloadItem = original.BasicAzureVMWorkloadItem
type AzureVMWorkloadItem = original.AzureVMWorkloadItem
type BasicAzureVMWorkloadProtectableItem = original.BasicAzureVMWorkloadProtectableItem
type AzureVMWorkloadProtectableItem = original.AzureVMWorkloadProtectableItem
type BasicAzureVMWorkloadProtectedItem = original.BasicAzureVMWorkloadProtectedItem
type AzureVMWorkloadProtectedItem = original.AzureVMWorkloadProtectedItem
type AzureVMWorkloadProtectedItemExtendedInfo = original.AzureVMWorkloadProtectedItemExtendedInfo
type AzureVMWorkloadProtectionPolicy = original.AzureVMWorkloadProtectionPolicy
type AzureVMWorkloadSAPHanaDatabaseProtectableItem = original.AzureVMWorkloadSAPHanaDatabaseProtectableItem
type AzureVMWorkloadSAPHanaDatabaseProtectedItem = original.AzureVMWorkloadSAPHanaDatabaseProtectedItem
type AzureVMWorkloadSAPHanaDatabaseWorkloadItem = original.AzureVMWorkloadSAPHanaDatabaseWorkloadItem
type AzureVMWorkloadSAPHanaSystemProtectableItem = original.AzureVMWorkloadSAPHanaSystemProtectableItem
type AzureVMWorkloadSAPHanaSystemWorkloadItem = original.AzureVMWorkloadSAPHanaSystemWorkloadItem
type AzureVMWorkloadSQLAvailabilityGroupProtectableItem = original.AzureVMWorkloadSQLAvailabilityGroupProtectableItem
type AzureVMWorkloadSQLDatabaseProtectableItem = original.AzureVMWorkloadSQLDatabaseProtectableItem
type AzureVMWorkloadSQLDatabaseProtectedItem = original.AzureVMWorkloadSQLDatabaseProtectedItem
type AzureVMWorkloadSQLDatabaseWorkloadItem = original.AzureVMWorkloadSQLDatabaseWorkloadItem
type AzureVMWorkloadSQLInstanceProtectableItem = original.AzureVMWorkloadSQLInstanceProtectableItem
type AzureVMWorkloadSQLInstanceWorkloadItem = original.AzureVMWorkloadSQLInstanceWorkloadItem
type BasicAzureWorkloadAutoProtectionIntent = original.BasicAzureWorkloadAutoProtectionIntent
type AzureWorkloadAutoProtectionIntent = original.AzureWorkloadAutoProtectionIntent
type AzureWorkloadBackupRequest = original.AzureWorkloadBackupRequest
type BasicAzureWorkloadContainer = original.BasicAzureWorkloadContainer
type AzureWorkloadContainer = original.AzureWorkloadContainer
type AzureWorkloadContainerExtendedInfo = original.AzureWorkloadContainerExtendedInfo
type AzureWorkloadErrorInfo = original.AzureWorkloadErrorInfo
type AzureWorkloadJob = original.AzureWorkloadJob
type AzureWorkloadJobExtendedInfo = original.AzureWorkloadJobExtendedInfo
type AzureWorkloadJobTaskDetails = original.AzureWorkloadJobTaskDetails
type BasicAzureWorkloadRecoveryPoint = original.BasicAzureWorkloadRecoveryPoint
type AzureWorkloadRecoveryPoint = original.AzureWorkloadRecoveryPoint
type BasicAzureWorkloadRestoreRequest = original.BasicAzureWorkloadRestoreRequest
type AzureWorkloadRestoreRequest = original.AzureWorkloadRestoreRequest
type AzureWorkloadSAPHanaPointInTimeRecoveryPoint = original.AzureWorkloadSAPHanaPointInTimeRecoveryPoint
type AzureWorkloadSAPHanaPointInTimeRestoreRequest = original.AzureWorkloadSAPHanaPointInTimeRestoreRequest
type BasicAzureWorkloadSAPHanaRecoveryPoint = original.BasicAzureWorkloadSAPHanaRecoveryPoint
type AzureWorkloadSAPHanaRecoveryPoint = original.AzureWorkloadSAPHanaRecoveryPoint
type BasicAzureWorkloadSAPHanaRestoreRequest = original.BasicAzureWorkloadSAPHanaRestoreRequest
type AzureWorkloadSAPHanaRestoreRequest = original.AzureWorkloadSAPHanaRestoreRequest
type AzureWorkloadSQLAutoProtectionIntent = original.AzureWorkloadSQLAutoProtectionIntent
type AzureWorkloadSQLPointInTimeRecoveryPoint = original.AzureWorkloadSQLPointInTimeRecoveryPoint
type AzureWorkloadSQLPointInTimeRestoreRequest = original.AzureWorkloadSQLPointInTimeRestoreRequest
type BasicAzureWorkloadSQLRecoveryPoint = original.BasicAzureWorkloadSQLRecoveryPoint
type AzureWorkloadSQLRecoveryPoint = original.AzureWorkloadSQLRecoveryPoint
type AzureWorkloadSQLRecoveryPointExtendedInfo = original.AzureWorkloadSQLRecoveryPointExtendedInfo
type BasicAzureWorkloadSQLRestoreRequest = original.BasicAzureWorkloadSQLRestoreRequest
type AzureWorkloadSQLRestoreRequest = original.AzureWorkloadSQLRestoreRequest
type BEKDetails = original.BEKDetails
type BMSBackupEngineQueryObject = original.BMSBackupEngineQueryObject
type BMSBackupEnginesQueryObject = original.BMSBackupEnginesQueryObject
type BMSBackupSummariesQueryObject = original.BMSBackupSummariesQueryObject
type BMSContainerQueryObject = original.BMSContainerQueryObject
type BMSContainersInquiryQueryObject = original.BMSContainersInquiryQueryObject
type BMSPOQueryObject = original.BMSPOQueryObject
type BMSRefreshContainersQueryObject = original.BMSRefreshContainersQueryObject
type BMSRPQueryObject = original.BMSRPQueryObject
type BMSWorkloadItemQueryObject = original.BMSWorkloadItemQueryObject
type ClientDiscoveryDisplay = original.ClientDiscoveryDisplay
type ClientDiscoveryForLogSpecification = original.ClientDiscoveryForLogSpecification
type ClientDiscoveryForProperties = original.ClientDiscoveryForProperties
type ClientDiscoveryForServiceSpecification = original.ClientDiscoveryForServiceSpecification
type ClientDiscoveryResponse = original.ClientDiscoveryResponse
type ClientDiscoveryResponseIterator = original.ClientDiscoveryResponseIterator
type ClientDiscoveryResponsePage = original.ClientDiscoveryResponsePage
type ClientDiscoveryValueForSingleAPI = original.ClientDiscoveryValueForSingleAPI
type ClientScriptForConnect = original.ClientScriptForConnect
type ContainerIdentityInfo = original.ContainerIdentityInfo
type DailyRetentionFormat = original.DailyRetentionFormat
type DailyRetentionSchedule = original.DailyRetentionSchedule
type Day = original.Day
type DistributedNodesInfo = original.DistributedNodesInfo
type DpmBackupEngine = original.DpmBackupEngine
type DpmContainer = original.DpmContainer
type DPMContainerExtendedInfo = original.DPMContainerExtendedInfo
type DpmErrorInfo = original.DpmErrorInfo
type DpmJob = original.DpmJob
type DpmJobExtendedInfo = original.DpmJobExtendedInfo
type DpmJobTaskDetails = original.DpmJobTaskDetails
type DPMProtectedItem = original.DPMProtectedItem
type DPMProtectedItemExtendedInfo = original.DPMProtectedItemExtendedInfo
type EncryptionDetails = original.EncryptionDetails
type BasicEngineBase = original.BasicEngineBase
type EngineBase = original.EngineBase
type EngineBaseResource = original.EngineBaseResource
type EngineBaseResourceList = original.EngineBaseResourceList
type EngineBaseResourceListIterator = original.EngineBaseResourceListIterator
type EngineBaseResourceListPage = original.EngineBaseResourceListPage
type EngineExtendedInfo = original.EngineExtendedInfo
type ErrorDetail = original.ErrorDetail
type ExportJobsOperationResultInfo = original.ExportJobsOperationResultInfo
type BasicFeatureSupportRequest = original.BasicFeatureSupportRequest
type FeatureSupportRequest = original.FeatureSupportRequest
type GenericContainer = original.GenericContainer
type GenericContainerExtendedInfo = original.GenericContainerExtendedInfo
type GenericProtectedItem = original.GenericProtectedItem
type GenericProtectionPolicy = original.GenericProtectionPolicy
type GenericRecoveryPoint = original.GenericRecoveryPoint
type GetProtectedItemQueryObject = original.GetProtectedItemQueryObject
type IaasVMBackupRequest = original.IaasVMBackupRequest
type BasicIaaSVMContainer = original.BasicIaaSVMContainer
type IaaSVMContainer = original.IaaSVMContainer
type IaasVMILRRegistrationRequest = original.IaasVMILRRegistrationRequest
type BasicIaaSVMProtectableItem = original.BasicIaaSVMProtectableItem
type IaaSVMProtectableItem = original.IaaSVMProtectableItem
type IaasVMRecoveryPoint = original.IaasVMRecoveryPoint
type IaasVMRestoreRequest = original.IaasVMRestoreRequest
type BasicILRRequest = original.BasicILRRequest
type ILRRequest = original.ILRRequest
type ILRRequestResource = original.ILRRequestResource
type InquiryInfo = original.InquiryInfo
type InquiryValidation = original.InquiryValidation
type InstantItemRecoveryTarget = original.InstantItemRecoveryTarget
type BasicJob = original.BasicJob
type Job = original.Job
type JobQueryObject = original.JobQueryObject
type JobResource = original.JobResource
type JobResourceList = original.JobResourceList
type JobResourceListIterator = original.JobResourceListIterator
type JobResourceListPage = original.JobResourceListPage
type KEKDetails = original.KEKDetails
type KeyAndSecretDetails = original.KeyAndSecretDetails
type LogSchedulePolicy = original.LogSchedulePolicy
type LongTermRetentionPolicy = original.LongTermRetentionPolicy
type LongTermSchedulePolicy = original.LongTermSchedulePolicy
type MabContainer = original.MabContainer
type MabContainerExtendedInfo = original.MabContainerExtendedInfo
type MABContainerHealthDetails = original.MABContainerHealthDetails
type MabErrorInfo = original.MabErrorInfo
type MabFileFolderProtectedItem = original.MabFileFolderProtectedItem
type MabFileFolderProtectedItemExtendedInfo = original.MabFileFolderProtectedItemExtendedInfo
type MabJob = original.MabJob
type MabJobExtendedInfo = original.MabJobExtendedInfo
type MabJobTaskDetails = original.MabJobTaskDetails
type MabProtectionPolicy = original.MabProtectionPolicy
type ManagementUsage = original.ManagementUsage
type ManagementUsageList = original.ManagementUsageList
type MonthlyRetentionSchedule = original.MonthlyRetentionSchedule
type NameInfo = original.NameInfo
type OperationResultInfo = original.OperationResultInfo
type BasicOperationResultInfoBase = original.BasicOperationResultInfoBase
type OperationResultInfoBase = original.OperationResultInfoBase
type OperationResultInfoBaseResource = original.OperationResultInfoBaseResource
type OperationStatus = original.OperationStatus
type OperationStatusError = original.OperationStatusError
type BasicOperationStatusExtendedInfo = original.BasicOperationStatusExtendedInfo
type OperationStatusExtendedInfo = original.OperationStatusExtendedInfo
type OperationStatusJobExtendedInfo = original.OperationStatusJobExtendedInfo
type OperationStatusJobsExtendedInfo = original.OperationStatusJobsExtendedInfo
type OperationStatusProvisionILRExtendedInfo = original.OperationStatusProvisionILRExtendedInfo
type OperationWorkerResponse = original.OperationWorkerResponse
type PointInTimeRange = original.PointInTimeRange
type PreBackupValidation = original.PreBackupValidation
type PreValidateEnableBackupRequest = original.PreValidateEnableBackupRequest
type PreValidateEnableBackupResponse = original.PreValidateEnableBackupResponse
type BasicProtectableContainer = original.BasicProtectableContainer
type ProtectableContainer = original.ProtectableContainer
type ProtectableContainerResource = original.ProtectableContainerResource
type ProtectableContainerResourceList = original.ProtectableContainerResourceList
type ProtectableContainerResourceListIterator = original.ProtectableContainerResourceListIterator
type ProtectableContainerResourceListPage = original.ProtectableContainerResourceListPage
type BasicProtectedItem = original.BasicProtectedItem
type ProtectedItem = original.ProtectedItem
type ProtectedItemQueryObject = original.ProtectedItemQueryObject
type ProtectedItemResource = original.ProtectedItemResource
type ProtectedItemResourceList = original.ProtectedItemResourceList
type ProtectedItemResourceListIterator = original.ProtectedItemResourceListIterator
type ProtectedItemResourceListPage = original.ProtectedItemResourceListPage
type BasicProtectionContainer = original.BasicProtectionContainer
type ProtectionContainer = original.ProtectionContainer
type ProtectionContainerResource = original.ProtectionContainerResource
type ProtectionContainerResourceList = original.ProtectionContainerResourceList
type ProtectionContainerResourceListIterator = original.ProtectionContainerResourceListIterator
type ProtectionContainerResourceListPage = original.ProtectionContainerResourceListPage
type BasicProtectionIntent = original.BasicProtectionIntent
type ProtectionIntent = original.ProtectionIntent
type ProtectionIntentResource = original.ProtectionIntentResource
type BasicProtectionPolicy = original.BasicProtectionPolicy
type ProtectionPolicy = original.ProtectionPolicy
type ProtectionPolicyQueryObject = original.ProtectionPolicyQueryObject
type ProtectionPolicyResource = original.ProtectionPolicyResource
type ProtectionPolicyResourceList = original.ProtectionPolicyResourceList
type ProtectionPolicyResourceListIterator = original.ProtectionPolicyResourceListIterator
type ProtectionPolicyResourceListPage = original.ProtectionPolicyResourceListPage
type BasicRecoveryPoint = original.BasicRecoveryPoint
type RecoveryPoint = original.RecoveryPoint
type RecoveryPointResource = original.RecoveryPointResource
type RecoveryPointResourceList = original.RecoveryPointResourceList
type RecoveryPointResourceListIterator = original.RecoveryPointResourceListIterator
type RecoveryPointResourceListPage = original.RecoveryPointResourceListPage
type RecoveryPointTierInformation = original.RecoveryPointTierInformation
type BasicRequest = original.BasicRequest
type Request = original.Request
type RequestResource = original.RequestResource
type Resource = original.Resource
type ResourceConfig = original.ResourceConfig
type ResourceConfigResource = original.ResourceConfigResource
type ResourceList = original.ResourceList
type ResourceVaultConfig = original.ResourceVaultConfig
type ResourceVaultConfigResource = original.ResourceVaultConfigResource
type RestoreFileSpecs = original.RestoreFileSpecs
type BasicRestoreRequest = original.BasicRestoreRequest
type RestoreRequest = original.RestoreRequest
type RestoreRequestResource = original.RestoreRequestResource
type RetentionDuration = original.RetentionDuration
type BasicRetentionPolicy = original.BasicRetentionPolicy
type RetentionPolicy = original.RetentionPolicy
type BasicSchedulePolicy = original.BasicSchedulePolicy
type SchedulePolicy = original.SchedulePolicy
type Settings = original.Settings
type SimpleRetentionPolicy = original.SimpleRetentionPolicy
type SimpleSchedulePolicy = original.SimpleSchedulePolicy
type SQLDataDirectory = original.SQLDataDirectory
type SQLDataDirectoryMapping = original.SQLDataDirectoryMapping
type StatusRequest = original.StatusRequest
type StatusResponse = original.StatusResponse
type SubProtectionPolicy = original.SubProtectionPolicy
type TargetAFSRestoreInfo = original.TargetAFSRestoreInfo
type TargetRestoreInfo = original.TargetRestoreInfo
type TokenInformation = original.TokenInformation
type ValidateIaasVMRestoreOperationRequest = original.ValidateIaasVMRestoreOperationRequest
type BasicValidateOperationRequest = original.BasicValidateOperationRequest
type ValidateOperationRequest = original.ValidateOperationRequest
type ValidateOperationResponse = original.ValidateOperationResponse
type ValidateOperationsResponse = original.ValidateOperationsResponse
type BasicValidateRestoreOperationRequest = original.BasicValidateRestoreOperationRequest
type ValidateRestoreOperationRequest = original.ValidateRestoreOperationRequest
type WeeklyRetentionFormat = original.WeeklyRetentionFormat
type WeeklyRetentionSchedule = original.WeeklyRetentionSchedule
type WorkloadInquiryDetails = original.WorkloadInquiryDetails
type BasicWorkloadItem = original.BasicWorkloadItem
type WorkloadItem = original.WorkloadItem
type WorkloadItemResource = original.WorkloadItemResource
type WorkloadItemResourceList = original.WorkloadItemResourceList
type WorkloadItemResourceListIterator = original.WorkloadItemResourceListIterator
type WorkloadItemResourceListPage = original.WorkloadItemResourceListPage
type BasicWorkloadProtectableItem = original.BasicWorkloadProtectableItem
type WorkloadProtectableItem = original.WorkloadProtectableItem
type WorkloadProtectableItemResource = original.WorkloadProtectableItemResource
type WorkloadProtectableItemResourceList = original.WorkloadProtectableItemResourceList
type WorkloadProtectableItemResourceListIterator = original.WorkloadProtectableItemResourceListIterator
type WorkloadProtectableItemResourceListPage = original.WorkloadProtectableItemResourceListPage
type YearlyRetentionSchedule = original.YearlyRetentionSchedule
type OperationClient = original.OperationClient
type OperationResultsClient = original.OperationResultsClient
type OperationsClient = original.OperationsClient
type OperationStatusesClient = original.OperationStatusesClient
type PoliciesClient = original.PoliciesClient
type ProtectableContainersClient = original.ProtectableContainersClient
type ProtectableItemsClient = original.ProtectableItemsClient
type ProtectedItemOperationResultsClient = original.ProtectedItemOperationResultsClient
type ProtectedItemOperationStatusesClient = original.ProtectedItemOperationStatusesClient
type ProtectedItemsClient = original.ProtectedItemsClient
type ProtectedItemsGroupClient = original.ProtectedItemsGroupClient
type ProtectionContainerOperationResultsClient = original.ProtectionContainerOperationResultsClient
type ProtectionContainerRefreshOperationResultsClient = original.ProtectionContainerRefreshOperationResultsClient
type ProtectionContainersClient = original.ProtectionContainersClient
type ProtectionContainersGroupClient = original.ProtectionContainersGroupClient
type ProtectionIntentClient = original.ProtectionIntentClient
type ProtectionPoliciesClient = original.ProtectionPoliciesClient
type ProtectionPolicyOperationResultsClient = original.ProtectionPolicyOperationResultsClient
type ProtectionPolicyOperationStatusesClient = original.ProtectionPolicyOperationStatusesClient
type RecoveryPointsClient = original.RecoveryPointsClient
type ResourceStorageConfigsClient = original.ResourceStorageConfigsClient
type ResourceVaultConfigsClient = original.ResourceVaultConfigsClient
type RestoresClient = original.RestoresClient
type SecurityPINsClient = original.SecurityPINsClient
type StatusClient = original.StatusClient
type UsageSummariesClient = original.UsageSummariesClient
type WorkloadItemsClient = original.WorkloadItemsClient

func NewBackupsClient(subscriptionID string) BackupsClient {
	return original.NewBackupsClient(subscriptionID)
}
func NewBackupsClientWithBaseURI(baseURI string, subscriptionID string) BackupsClient {
	return original.NewBackupsClientWithBaseURI(baseURI, subscriptionID)
}
func New(subscriptionID string) BaseClient {
	return original.New(subscriptionID)
}
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID)
}
func NewEnginesClient(subscriptionID string) EnginesClient {
	return original.NewEnginesClient(subscriptionID)
}
func NewEnginesClientWithBaseURI(baseURI string, subscriptionID string) EnginesClient {
	return original.NewEnginesClientWithBaseURI(baseURI, subscriptionID)
}
func NewExportJobsOperationResultsClient(subscriptionID string) ExportJobsOperationResultsClient {
	return original.NewExportJobsOperationResultsClient(subscriptionID)
}
func NewExportJobsOperationResultsClientWithBaseURI(baseURI string, subscriptionID string) ExportJobsOperationResultsClient {
	return original.NewExportJobsOperationResultsClientWithBaseURI(baseURI, subscriptionID)
}
func NewFeatureSupportClient(subscriptionID string) FeatureSupportClient {
	return original.NewFeatureSupportClient(subscriptionID)
}
func NewFeatureSupportClientWithBaseURI(baseURI string, subscriptionID string) FeatureSupportClient {
	return original.NewFeatureSupportClientWithBaseURI(baseURI, subscriptionID)
}
func NewItemLevelRecoveryConnectionsClient(subscriptionID string) ItemLevelRecoveryConnectionsClient {
	return original.NewItemLevelRecoveryConnectionsClient(subscriptionID)
}
func NewItemLevelRecoveryConnectionsClientWithBaseURI(baseURI string, subscriptionID string) ItemLevelRecoveryConnectionsClient {
	return original.NewItemLevelRecoveryConnectionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewJobCancellationsClient(subscriptionID string) JobCancellationsClient {
	return original.NewJobCancellationsClient(subscriptionID)
}
func NewJobCancellationsClientWithBaseURI(baseURI string, subscriptionID string) JobCancellationsClient {
	return original.NewJobCancellationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewJobDetailsClient(subscriptionID string) JobDetailsClient {
	return original.NewJobDetailsClient(subscriptionID)
}
func NewJobDetailsClientWithBaseURI(baseURI string, subscriptionID string) JobDetailsClient {
	return original.NewJobDetailsClientWithBaseURI(baseURI, subscriptionID)
}
func NewJobOperationResultsClient(subscriptionID string) JobOperationResultsClient {
	return original.NewJobOperationResultsClient(subscriptionID)
}
func NewJobOperationResultsClientWithBaseURI(baseURI string, subscriptionID string) JobOperationResultsClient {
	return original.NewJobOperationResultsClientWithBaseURI(baseURI, subscriptionID)
}
func NewJobsClient(subscriptionID string) JobsClient {
	return original.NewJobsClient(subscriptionID)
}
func NewJobsClientWithBaseURI(baseURI string, subscriptionID string) JobsClient {
	return original.NewJobsClientWithBaseURI(baseURI, subscriptionID)
}
func NewJobsGroupClient(subscriptionID string) JobsGroupClient {
	return original.NewJobsGroupClient(subscriptionID)
}
func NewJobsGroupClientWithBaseURI(baseURI string, subscriptionID string) JobsGroupClient {
	return original.NewJobsGroupClientWithBaseURI(baseURI, subscriptionID)
}
func PossibleAzureFileShareTypeValues() []AzureFileShareType {
	return original.PossibleAzureFileShareTypeValues()
}
func PossibleContainerTypeValues() []ContainerType {
	return original.PossibleContainerTypeValues()
}
func PossibleContainerTypeBasicProtectionContainerValues() []ContainerTypeBasicProtectionContainer {
	return original.PossibleContainerTypeBasicProtectionContainerValues()
}
func PossibleCopyOptionsValues() []CopyOptions {
	return original.PossibleCopyOptionsValues()
}
func PossibleCreateModeValues() []CreateMode {
	return original.PossibleCreateModeValues()
}
func PossibleDataSourceTypeValues() []DataSourceType {
	return original.PossibleDataSourceTypeValues()
}
func PossibleDayOfWeekValues() []DayOfWeek {
	return original.PossibleDayOfWeekValues()
}
func PossibleEngineTypeValues() []EngineType {
	return original.PossibleEngineTypeValues()
}
func PossibleEnhancedSecurityStateValues() []EnhancedSecurityState {
	return original.PossibleEnhancedSecurityStateValues()
}
func PossibleFabricNameValues() []FabricName {
	return original.PossibleFabricNameValues()
}
func PossibleFeatureTypeValues() []FeatureType {
	return original.PossibleFeatureTypeValues()
}
func PossibleHealthStateValues() []HealthState {
	return original.PossibleHealthStateValues()
}
func PossibleHealthStatusValues() []HealthStatus {
	return original.PossibleHealthStatusValues()
}
func PossibleHTTPStatusCodeValues() []HTTPStatusCode {
	return original.PossibleHTTPStatusCodeValues()
}
func PossibleInquiryStatusValues() []InquiryStatus {
	return original.PossibleInquiryStatusValues()
}
func PossibleItemTypeValues() []ItemType {
	return original.PossibleItemTypeValues()
}
func PossibleJobOperationTypeValues() []JobOperationType {
	return original.PossibleJobOperationTypeValues()
}
func PossibleJobStatusValues() []JobStatus {
	return original.PossibleJobStatusValues()
}
func PossibleJobSupportedActionValues() []JobSupportedAction {
	return original.PossibleJobSupportedActionValues()
}
func PossibleJobTypeValues() []JobType {
	return original.PossibleJobTypeValues()
}
func PossibleLastBackupStatusValues() []LastBackupStatus {
	return original.PossibleLastBackupStatusValues()
}
func PossibleMabServerTypeValues() []MabServerType {
	return original.PossibleMabServerTypeValues()
}
func PossibleManagementTypeValues() []ManagementType {
	return original.PossibleManagementTypeValues()
}
func PossibleManagementTypeBasicProtectionPolicyValues() []ManagementTypeBasicProtectionPolicy {
	return original.PossibleManagementTypeBasicProtectionPolicyValues()
}
func PossibleMonthOfYearValues() []MonthOfYear {
	return original.PossibleMonthOfYearValues()
}
func PossibleObjectTypeValues() []ObjectType {
	return original.PossibleObjectTypeValues()
}
func PossibleObjectTypeBasicILRRequestValues() []ObjectTypeBasicILRRequest {
	return original.PossibleObjectTypeBasicILRRequestValues()
}
func PossibleObjectTypeBasicOperationStatusExtendedInfoValues() []ObjectTypeBasicOperationStatusExtendedInfo {
	return original.PossibleObjectTypeBasicOperationStatusExtendedInfoValues()
}
func PossibleObjectTypeBasicRecoveryPointValues() []ObjectTypeBasicRecoveryPoint {
	return original.PossibleObjectTypeBasicRecoveryPointValues()
}
func PossibleObjectTypeBasicRequestValues() []ObjectTypeBasicRequest {
	return original.PossibleObjectTypeBasicRequestValues()
}
func PossibleObjectTypeBasicRestoreRequestValues() []ObjectTypeBasicRestoreRequest {
	return original.PossibleObjectTypeBasicRestoreRequestValues()
}
func PossibleObjectTypeBasicValidateOperationRequestValues() []ObjectTypeBasicValidateOperationRequest {
	return original.PossibleObjectTypeBasicValidateOperationRequestValues()
}
func PossibleOperationStatusValuesValues() []OperationStatusValues {
	return original.PossibleOperationStatusValuesValues()
}
func PossibleOverwriteOptionsValues() []OverwriteOptions {
	return original.PossibleOverwriteOptionsValues()
}
func PossibleProtectableContainerTypeValues() []ProtectableContainerType {
	return original.PossibleProtectableContainerTypeValues()
}
func PossibleProtectableItemTypeValues() []ProtectableItemType {
	return original.PossibleProtectableItemTypeValues()
}
func PossibleProtectedItemHealthStatusValues() []ProtectedItemHealthStatus {
	return original.PossibleProtectedItemHealthStatusValues()
}
func PossibleProtectedItemStateValues() []ProtectedItemState {
	return original.PossibleProtectedItemStateValues()
}
func PossibleProtectedItemTypeValues() []ProtectedItemType {
	return original.PossibleProtectedItemTypeValues()
}
func PossibleProtectionIntentItemTypeValues() []ProtectionIntentItemType {
	return original.PossibleProtectionIntentItemTypeValues()
}
func PossibleProtectionStateValues() []ProtectionState {
	return original.PossibleProtectionStateValues()
}
func PossibleProtectionStatusValues() []ProtectionStatus {
	return original.PossibleProtectionStatusValues()
}
func PossibleRecoveryPointTierStatusValues() []RecoveryPointTierStatus {
	return original.PossibleRecoveryPointTierStatusValues()
}
func PossibleRecoveryPointTierTypeValues() []RecoveryPointTierType {
	return original.PossibleRecoveryPointTierTypeValues()
}
func PossibleRecoveryTypeValues() []RecoveryType {
	return original.PossibleRecoveryTypeValues()
}
func PossibleRestorePointQueryTypeValues() []RestorePointQueryType {
	return original.PossibleRestorePointQueryTypeValues()
}
func PossibleRestorePointTypeValues() []RestorePointType {
	return original.PossibleRestorePointTypeValues()
}
func PossibleRestoreRequestTypeValues() []RestoreRequestType {
	return original.PossibleRestoreRequestTypeValues()
}
func PossibleRetentionDurationTypeValues() []RetentionDurationType {
	return original.PossibleRetentionDurationTypeValues()
}
func PossibleRetentionPolicyTypeValues() []RetentionPolicyType {
	return original.PossibleRetentionPolicyTypeValues()
}
func PossibleRetentionScheduleFormatValues() []RetentionScheduleFormat {
	return original.PossibleRetentionScheduleFormatValues()
}
func PossibleSchedulePolicyTypeValues() []SchedulePolicyType {
	return original.PossibleSchedulePolicyTypeValues()
}
func PossibleScheduleRunTypeValues() []ScheduleRunType {
	return original.PossibleScheduleRunTypeValues()
}
func PossibleSQLDataDirectoryTypeValues() []SQLDataDirectoryType {
	return original.PossibleSQLDataDirectoryTypeValues()
}
func PossibleStorageTypeValues() []StorageType {
	return original.PossibleStorageTypeValues()
}
func PossibleStorageTypeStateValues() []StorageTypeState {
	return original.PossibleStorageTypeStateValues()
}
func PossibleSupportStatusValues() []SupportStatus {
	return original.PossibleSupportStatusValues()
}
func PossibleTypeValues() []Type {
	return original.PossibleTypeValues()
}
func PossibleTypeEnumValues() []TypeEnum {
	return original.PossibleTypeEnumValues()
}
func PossibleUsagesUnitValues() []UsagesUnit {
	return original.PossibleUsagesUnitValues()
}
func PossibleValidationStatusValues() []ValidationStatus {
	return original.PossibleValidationStatusValues()
}
func PossibleWeekOfMonthValues() []WeekOfMonth {
	return original.PossibleWeekOfMonthValues()
}
func PossibleWorkloadItemTypeValues() []WorkloadItemType {
	return original.PossibleWorkloadItemTypeValues()
}
func PossibleWorkloadItemTypeBasicWorkloadItemValues() []WorkloadItemTypeBasicWorkloadItem {
	return original.PossibleWorkloadItemTypeBasicWorkloadItemValues()
}
func PossibleWorkloadTypeValues() []WorkloadType {
	return original.PossibleWorkloadTypeValues()
}
func NewOperationClient(subscriptionID string) OperationClient {
	return original.NewOperationClient(subscriptionID)
}
func NewOperationClientWithBaseURI(baseURI string, subscriptionID string) OperationClient {
	return original.NewOperationClientWithBaseURI(baseURI, subscriptionID)
}
func NewOperationResultsClient(subscriptionID string) OperationResultsClient {
	return original.NewOperationResultsClient(subscriptionID)
}
func NewOperationResultsClientWithBaseURI(baseURI string, subscriptionID string) OperationResultsClient {
	return original.NewOperationResultsClientWithBaseURI(baseURI, subscriptionID)
}
func NewOperationsClient(subscriptionID string) OperationsClient {
	return original.NewOperationsClient(subscriptionID)
}
func NewOperationsClientWithBaseURI(baseURI string, subscriptionID string) OperationsClient {
	return original.NewOperationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewOperationStatusesClient(subscriptionID string) OperationStatusesClient {
	return original.NewOperationStatusesClient(subscriptionID)
}
func NewOperationStatusesClientWithBaseURI(baseURI string, subscriptionID string) OperationStatusesClient {
	return original.NewOperationStatusesClientWithBaseURI(baseURI, subscriptionID)
}
func NewPoliciesClient(subscriptionID string) PoliciesClient {
	return original.NewPoliciesClient(subscriptionID)
}
func NewPoliciesClientWithBaseURI(baseURI string, subscriptionID string) PoliciesClient {
	return original.NewPoliciesClientWithBaseURI(baseURI, subscriptionID)
}
func NewProtectableContainersClient(subscriptionID string) ProtectableContainersClient {
	return original.NewProtectableContainersClient(subscriptionID)
}
func NewProtectableContainersClientWithBaseURI(baseURI string, subscriptionID string) ProtectableContainersClient {
	return original.NewProtectableContainersClientWithBaseURI(baseURI, subscriptionID)
}
func NewProtectableItemsClient(subscriptionID string) ProtectableItemsClient {
	return original.NewProtectableItemsClient(subscriptionID)
}
func NewProtectableItemsClientWithBaseURI(baseURI string, subscriptionID string) ProtectableItemsClient {
	return original.NewProtectableItemsClientWithBaseURI(baseURI, subscriptionID)
}
func NewProtectedItemOperationResultsClient(subscriptionID string) ProtectedItemOperationResultsClient {
	return original.NewProtectedItemOperationResultsClient(subscriptionID)
}
func NewProtectedItemOperationResultsClientWithBaseURI(baseURI string, subscriptionID string) ProtectedItemOperationResultsClient {
	return original.NewProtectedItemOperationResultsClientWithBaseURI(baseURI, subscriptionID)
}
func NewProtectedItemOperationStatusesClient(subscriptionID string) ProtectedItemOperationStatusesClient {
	return original.NewProtectedItemOperationStatusesClient(subscriptionID)
}
func NewProtectedItemOperationStatusesClientWithBaseURI(baseURI string, subscriptionID string) ProtectedItemOperationStatusesClient {
	return original.NewProtectedItemOperationStatusesClientWithBaseURI(baseURI, subscriptionID)
}
func NewProtectedItemsClient(subscriptionID string) ProtectedItemsClient {
	return original.NewProtectedItemsClient(subscriptionID)
}
func NewProtectedItemsClientWithBaseURI(baseURI string, subscriptionID string) ProtectedItemsClient {
	return original.NewProtectedItemsClientWithBaseURI(baseURI, subscriptionID)
}
func NewProtectedItemsGroupClient(subscriptionID string) ProtectedItemsGroupClient {
	return original.NewProtectedItemsGroupClient(subscriptionID)
}
func NewProtectedItemsGroupClientWithBaseURI(baseURI string, subscriptionID string) ProtectedItemsGroupClient {
	return original.NewProtectedItemsGroupClientWithBaseURI(baseURI, subscriptionID)
}
func NewProtectionContainerOperationResultsClient(subscriptionID string) ProtectionContainerOperationResultsClient {
	return original.NewProtectionContainerOperationResultsClient(subscriptionID)
}
func NewProtectionContainerOperationResultsClientWithBaseURI(baseURI string, subscriptionID string) ProtectionContainerOperationResultsClient {
	return original.NewProtectionContainerOperationResultsClientWithBaseURI(baseURI, subscriptionID)
}
func NewProtectionContainerRefreshOperationResultsClient(subscriptionID string) ProtectionContainerRefreshOperationResultsClient {
	return original.NewProtectionContainerRefreshOperationResultsClient(subscriptionID)
}
func NewProtectionContainerRefreshOperationResultsClientWithBaseURI(baseURI string, subscriptionID string) ProtectionContainerRefreshOperationResultsClient {
	return original.NewProtectionContainerRefreshOperationResultsClientWithBaseURI(baseURI, subscriptionID)
}
func NewProtectionContainersClient(subscriptionID string) ProtectionContainersClient {
	return original.NewProtectionContainersClient(subscriptionID)
}
func NewProtectionContainersClientWithBaseURI(baseURI string, subscriptionID string) ProtectionContainersClient {
	return original.NewProtectionContainersClientWithBaseURI(baseURI, subscriptionID)
}
func NewProtectionContainersGroupClient(subscriptionID string) ProtectionContainersGroupClient {
	return original.NewProtectionContainersGroupClient(subscriptionID)
}
func NewProtectionContainersGroupClientWithBaseURI(baseURI string, subscriptionID string) ProtectionContainersGroupClient {
	return original.NewProtectionContainersGroupClientWithBaseURI(baseURI, subscriptionID)
}
func NewProtectionIntentClient(subscriptionID string) ProtectionIntentClient {
	return original.NewProtectionIntentClient(subscriptionID)
}
func NewProtectionIntentClientWithBaseURI(baseURI string, subscriptionID string) ProtectionIntentClient {
	return original.NewProtectionIntentClientWithBaseURI(baseURI, subscriptionID)
}
func NewProtectionPoliciesClient(subscriptionID string) ProtectionPoliciesClient {
	return original.NewProtectionPoliciesClient(subscriptionID)
}
func NewProtectionPoliciesClientWithBaseURI(baseURI string, subscriptionID string) ProtectionPoliciesClient {
	return original.NewProtectionPoliciesClientWithBaseURI(baseURI, subscriptionID)
}
func NewProtectionPolicyOperationResultsClient(subscriptionID string) ProtectionPolicyOperationResultsClient {
	return original.NewProtectionPolicyOperationResultsClient(subscriptionID)
}
func NewProtectionPolicyOperationResultsClientWithBaseURI(baseURI string, subscriptionID string) ProtectionPolicyOperationResultsClient {
	return original.NewProtectionPolicyOperationResultsClientWithBaseURI(baseURI, subscriptionID)
}
func NewProtectionPolicyOperationStatusesClient(subscriptionID string) ProtectionPolicyOperationStatusesClient {
	return original.NewProtectionPolicyOperationStatusesClient(subscriptionID)
}
func NewProtectionPolicyOperationStatusesClientWithBaseURI(baseURI string, subscriptionID string) ProtectionPolicyOperationStatusesClient {
	return original.NewProtectionPolicyOperationStatusesClientWithBaseURI(baseURI, subscriptionID)
}
func NewRecoveryPointsClient(subscriptionID string) RecoveryPointsClient {
	return original.NewRecoveryPointsClient(subscriptionID)
}
func NewRecoveryPointsClientWithBaseURI(baseURI string, subscriptionID string) RecoveryPointsClient {
	return original.NewRecoveryPointsClientWithBaseURI(baseURI, subscriptionID)
}
func NewResourceStorageConfigsClient(subscriptionID string) ResourceStorageConfigsClient {
	return original.NewResourceStorageConfigsClient(subscriptionID)
}
func NewResourceStorageConfigsClientWithBaseURI(baseURI string, subscriptionID string) ResourceStorageConfigsClient {
	return original.NewResourceStorageConfigsClientWithBaseURI(baseURI, subscriptionID)
}
func NewResourceVaultConfigsClient(subscriptionID string) ResourceVaultConfigsClient {
	return original.NewResourceVaultConfigsClient(subscriptionID)
}
func NewResourceVaultConfigsClientWithBaseURI(baseURI string, subscriptionID string) ResourceVaultConfigsClient {
	return original.NewResourceVaultConfigsClientWithBaseURI(baseURI, subscriptionID)
}
func NewRestoresClient(subscriptionID string) RestoresClient {
	return original.NewRestoresClient(subscriptionID)
}
func NewRestoresClientWithBaseURI(baseURI string, subscriptionID string) RestoresClient {
	return original.NewRestoresClientWithBaseURI(baseURI, subscriptionID)
}
func NewSecurityPINsClient(subscriptionID string) SecurityPINsClient {
	return original.NewSecurityPINsClient(subscriptionID)
}
func NewSecurityPINsClientWithBaseURI(baseURI string, subscriptionID string) SecurityPINsClient {
	return original.NewSecurityPINsClientWithBaseURI(baseURI, subscriptionID)
}
func NewStatusClient(subscriptionID string) StatusClient {
	return original.NewStatusClient(subscriptionID)
}
func NewStatusClientWithBaseURI(baseURI string, subscriptionID string) StatusClient {
	return original.NewStatusClientWithBaseURI(baseURI, subscriptionID)
}
func NewUsageSummariesClient(subscriptionID string) UsageSummariesClient {
	return original.NewUsageSummariesClient(subscriptionID)
}
func NewUsageSummariesClientWithBaseURI(baseURI string, subscriptionID string) UsageSummariesClient {
	return original.NewUsageSummariesClientWithBaseURI(baseURI, subscriptionID)
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
func NewWorkloadItemsClient(subscriptionID string) WorkloadItemsClient {
	return original.NewWorkloadItemsClient(subscriptionID)
}
func NewWorkloadItemsClientWithBaseURI(baseURI string, subscriptionID string) WorkloadItemsClient {
	return original.NewWorkloadItemsClientWithBaseURI(baseURI, subscriptionID)
}
