package cbn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateTransitRouterPeerAttachment invokes the cbn.CreateTransitRouterPeerAttachment API synchronously
func (client *Client) CreateTransitRouterPeerAttachment(request *CreateTransitRouterPeerAttachmentRequest) (response *CreateTransitRouterPeerAttachmentResponse, err error) {
	response = CreateCreateTransitRouterPeerAttachmentResponse()
	err = client.DoAction(request, response)
	return
}

// CreateTransitRouterPeerAttachmentWithChan invokes the cbn.CreateTransitRouterPeerAttachment API asynchronously
func (client *Client) CreateTransitRouterPeerAttachmentWithChan(request *CreateTransitRouterPeerAttachmentRequest) (<-chan *CreateTransitRouterPeerAttachmentResponse, <-chan error) {
	responseChan := make(chan *CreateTransitRouterPeerAttachmentResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateTransitRouterPeerAttachment(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateTransitRouterPeerAttachmentWithCallback invokes the cbn.CreateTransitRouterPeerAttachment API asynchronously
func (client *Client) CreateTransitRouterPeerAttachmentWithCallback(request *CreateTransitRouterPeerAttachmentRequest, callback func(response *CreateTransitRouterPeerAttachmentResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateTransitRouterPeerAttachmentResponse
		var err error
		defer close(result)
		response, err = client.CreateTransitRouterPeerAttachment(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateTransitRouterPeerAttachmentRequest is the request struct for api CreateTransitRouterPeerAttachment
type CreateTransitRouterPeerAttachmentRequest struct {
	*requests.RpcRequest
	ResourceOwnerId                    requests.Integer `position:"Query" name:"ResourceOwnerId"`
	BandwidthType                      string           `position:"Query" name:"BandwidthType"`
	ClientToken                        string           `position:"Query" name:"ClientToken"`
	CenId                              string           `position:"Query" name:"CenId"`
	RouteTableAssociationEnabled       requests.Boolean `position:"Query" name:"RouteTableAssociationEnabled"`
	TransitRouterAttachmentName        string           `position:"Query" name:"TransitRouterAttachmentName"`
	AutoPublishRouteEnabled            requests.Boolean `position:"Query" name:"AutoPublishRouteEnabled"`
	RouteTablePropagationEnabled       requests.Boolean `position:"Query" name:"RouteTablePropagationEnabled"`
	DryRun                             requests.Boolean `position:"Query" name:"DryRun"`
	ResourceOwnerAccount               string           `position:"Query" name:"ResourceOwnerAccount"`
	Bandwidth                          requests.Integer `position:"Query" name:"Bandwidth"`
	OwnerAccount                       string           `position:"Query" name:"OwnerAccount"`
	OwnerId                            requests.Integer `position:"Query" name:"OwnerId"`
	TransitRouterId                    string           `position:"Query" name:"TransitRouterId"`
	ResourceType                       string           `position:"Query" name:"ResourceType"`
	TransitRouterAttachmentDescription string           `position:"Query" name:"TransitRouterAttachmentDescription"`
	PeerTransitRouterRegionId          string           `position:"Query" name:"PeerTransitRouterRegionId"`
	CenBandwidthPackageId              string           `position:"Query" name:"CenBandwidthPackageId"`
	PeerTransitRouterId                string           `position:"Query" name:"PeerTransitRouterId"`
}

// CreateTransitRouterPeerAttachmentResponse is the response struct for api CreateTransitRouterPeerAttachment
type CreateTransitRouterPeerAttachmentResponse struct {
	*responses.BaseResponse
	RequestId                 string `json:"RequestId" xml:"RequestId"`
	TransitRouterAttachmentId string `json:"TransitRouterAttachmentId" xml:"TransitRouterAttachmentId"`
}

// CreateCreateTransitRouterPeerAttachmentRequest creates a request to invoke CreateTransitRouterPeerAttachment API
func CreateCreateTransitRouterPeerAttachmentRequest() (request *CreateTransitRouterPeerAttachmentRequest) {
	request = &CreateTransitRouterPeerAttachmentRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cbn", "2017-09-12", "CreateTransitRouterPeerAttachment", "cbn", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateTransitRouterPeerAttachmentResponse creates a response to parse from CreateTransitRouterPeerAttachment response
func CreateCreateTransitRouterPeerAttachmentResponse() (response *CreateTransitRouterPeerAttachmentResponse) {
	response = &CreateTransitRouterPeerAttachmentResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
