package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateNumber400Order invokes the cloudcallcenter.CreateNumber400Order API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/createnumber400order.html
func (client *Client) CreateNumber400Order(request *CreateNumber400OrderRequest) (response *CreateNumber400OrderResponse, err error) {
	response = CreateCreateNumber400OrderResponse()
	err = client.DoAction(request, response)
	return
}

// CreateNumber400OrderWithChan invokes the cloudcallcenter.CreateNumber400Order API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/createnumber400order.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateNumber400OrderWithChan(request *CreateNumber400OrderRequest) (<-chan *CreateNumber400OrderResponse, <-chan error) {
	responseChan := make(chan *CreateNumber400OrderResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateNumber400Order(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateNumber400OrderWithCallback invokes the cloudcallcenter.CreateNumber400Order API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/createnumber400order.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateNumber400OrderWithCallback(request *CreateNumber400OrderRequest, callback func(response *CreateNumber400OrderResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateNumber400OrderResponse
		var err error
		defer close(result)
		response, err = client.CreateNumber400Order(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateNumber400OrderRequest is the request struct for api CreateNumber400Order
type CreateNumber400OrderRequest struct {
	*requests.RpcRequest
	SpecId                 string           `position:"Query" name:"SpecId"`
	SpecName               string           `position:"Query" name:"SpecName"`
	RealNameInsId          string           `position:"Query" name:"RealNameInsId"`
	RegionNameProvince     string           `position:"Query" name:"RegionNameProvince"`
	Type                   string           `position:"Query" name:"Type"`
	GuaranteedPackageLevel requests.Integer `position:"Query" name:"GuaranteedPackageLevel"`
	MonthlyPrice           requests.Integer `position:"Query" name:"MonthlyPrice"`
	Number                 *[]string        `position:"Query" name:"Number"  type:"Repeated"`
	CorpName               string           `position:"Query" name:"CorpName"`
	RegionNameCity         string           `position:"Query" name:"RegionNameCity"`
}

// CreateNumber400OrderResponse is the response struct for api CreateNumber400Order
type CreateNumber400OrderResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	OrderPayUrl    string `json:"OrderPayUrl" xml:"OrderPayUrl"`
}

// CreateCreateNumber400OrderRequest creates a request to invoke CreateNumber400Order API
func CreateCreateNumber400OrderRequest() (request *CreateNumber400OrderRequest) {
	request = &CreateNumber400OrderRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "CreateNumber400Order", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateNumber400OrderResponse creates a response to parse from CreateNumber400Order response
func CreateCreateNumber400OrderResponse() (response *CreateNumber400OrderResponse) {
	response = &CreateNumber400OrderResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
