package dds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeKernelReleaseNotes invokes the dds.DescribeKernelReleaseNotes API synchronously
func (client *Client) DescribeKernelReleaseNotes(request *DescribeKernelReleaseNotesRequest) (response *DescribeKernelReleaseNotesResponse, err error) {
	response = CreateDescribeKernelReleaseNotesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeKernelReleaseNotesWithChan invokes the dds.DescribeKernelReleaseNotes API asynchronously
func (client *Client) DescribeKernelReleaseNotesWithChan(request *DescribeKernelReleaseNotesRequest) (<-chan *DescribeKernelReleaseNotesResponse, <-chan error) {
	responseChan := make(chan *DescribeKernelReleaseNotesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeKernelReleaseNotes(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeKernelReleaseNotesWithCallback invokes the dds.DescribeKernelReleaseNotes API asynchronously
func (client *Client) DescribeKernelReleaseNotesWithCallback(request *DescribeKernelReleaseNotesRequest, callback func(response *DescribeKernelReleaseNotesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeKernelReleaseNotesResponse
		var err error
		defer close(result)
		response, err = client.DescribeKernelReleaseNotes(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeKernelReleaseNotesRequest is the request struct for api DescribeKernelReleaseNotes
type DescribeKernelReleaseNotesRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	KernelVersion        string           `position:"Query" name:"KernelVersion"`
	SecurityToken        string           `position:"Query" name:"SecurityToken"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeKernelReleaseNotesResponse is the response struct for api DescribeKernelReleaseNotes
type DescribeKernelReleaseNotesResponse struct {
	*responses.BaseResponse
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	ReleaseNotes ReleaseNotes `json:"ReleaseNotes" xml:"ReleaseNotes"`
}

// CreateDescribeKernelReleaseNotesRequest creates a request to invoke DescribeKernelReleaseNotes API
func CreateDescribeKernelReleaseNotesRequest() (request *DescribeKernelReleaseNotesRequest) {
	request = &DescribeKernelReleaseNotesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dds", "2015-12-01", "DescribeKernelReleaseNotes", "dds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeKernelReleaseNotesResponse creates a response to parse from DescribeKernelReleaseNotes response
func CreateDescribeKernelReleaseNotesResponse() (response *DescribeKernelReleaseNotesResponse) {
	response = &DescribeKernelReleaseNotesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
