package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetServiceMethodPage invokes the edas.GetServiceMethodPage API synchronously
func (client *Client) GetServiceMethodPage(request *GetServiceMethodPageRequest) (response *GetServiceMethodPageResponse, err error) {
	response = CreateGetServiceMethodPageResponse()
	err = client.DoAction(request, response)
	return
}

// GetServiceMethodPageWithChan invokes the edas.GetServiceMethodPage API asynchronously
func (client *Client) GetServiceMethodPageWithChan(request *GetServiceMethodPageRequest) (<-chan *GetServiceMethodPageResponse, <-chan error) {
	responseChan := make(chan *GetServiceMethodPageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetServiceMethodPage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetServiceMethodPageWithCallback invokes the edas.GetServiceMethodPage API asynchronously
func (client *Client) GetServiceMethodPageWithCallback(request *GetServiceMethodPageRequest, callback func(response *GetServiceMethodPageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetServiceMethodPageResponse
		var err error
		defer close(result)
		response, err = client.GetServiceMethodPage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetServiceMethodPageRequest is the request struct for api GetServiceMethodPage
type GetServiceMethodPageRequest struct {
	*requests.RoaRequest
	RegistryType     string           `position:"Query" name:"registryType"`
	Origin           string           `position:"Query" name:"origin"`
	Ip               string           `position:"Query" name:"ip"`
	Source           string           `position:"Query" name:"source"`
	PageNumber       requests.Integer `position:"Query" name:"pageNumber"`
	Path             string           `position:"Query" name:"path"`
	ServiceType      string           `position:"Query" name:"serviceType"`
	AppId            string           `position:"Query" name:"appId"`
	Namespace        string           `position:"Query" name:"namespace"`
	ServiceVersion   string           `position:"Query" name:"serviceVersion"`
	PageSize         requests.Integer `position:"Query" name:"pageSize"`
	Name             string           `position:"Query" name:"name"`
	ServiceName      string           `position:"Query" name:"serviceName"`
	Region           string           `position:"Query" name:"region"`
	ServiceId        string           `position:"Query" name:"serviceId"`
	MethodController string           `position:"Query" name:"methodController"`
	Group            string           `position:"Query" name:"group"`
}

// GetServiceMethodPageResponse is the response struct for api GetServiceMethodPage
type GetServiceMethodPageResponse struct {
	*responses.BaseResponse
	Code      string                     `json:"Code" xml:"Code"`
	Message   string                     `json:"Message" xml:"Message"`
	Success   bool                       `json:"Success" xml:"Success"`
	RequestId string                     `json:"RequestId" xml:"RequestId"`
	HttpCode  string                     `json:"HttpCode" xml:"HttpCode"`
	Data      DataInGetServiceMethodPage `json:"Data" xml:"Data"`
}

// CreateGetServiceMethodPageRequest creates a request to invoke GetServiceMethodPage API
func CreateGetServiceMethodPageRequest() (request *GetServiceMethodPageRequest) {
	request = &GetServiceMethodPageRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "GetServiceMethodPage", "/pop/sp/api/mseForOam/getServiceMethodPage", "edas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetServiceMethodPageResponse creates a response to parse from GetServiceMethodPage response
func CreateGetServiceMethodPageResponse() (response *GetServiceMethodPageResponse) {
	response = &GetServiceMethodPageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
