package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDiskOpsActivity invokes the emr.DescribeDiskOpsActivity API synchronously
func (client *Client) DescribeDiskOpsActivity(request *DescribeDiskOpsActivityRequest) (response *DescribeDiskOpsActivityResponse, err error) {
	response = CreateDescribeDiskOpsActivityResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDiskOpsActivityWithChan invokes the emr.DescribeDiskOpsActivity API asynchronously
func (client *Client) DescribeDiskOpsActivityWithChan(request *DescribeDiskOpsActivityRequest) (<-chan *DescribeDiskOpsActivityResponse, <-chan error) {
	responseChan := make(chan *DescribeDiskOpsActivityResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDiskOpsActivity(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDiskOpsActivityWithCallback invokes the emr.DescribeDiskOpsActivity API asynchronously
func (client *Client) DescribeDiskOpsActivityWithCallback(request *DescribeDiskOpsActivityRequest, callback func(response *DescribeDiskOpsActivityResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDiskOpsActivityResponse
		var err error
		defer close(result)
		response, err = client.DescribeDiskOpsActivity(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDiskOpsActivityRequest is the request struct for api DescribeDiskOpsActivity
type DescribeDiskOpsActivityRequest struct {
	*requests.RpcRequest
	EventId         string           `position:"Query" name:"EventId"`
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	CurrentStage    string           `position:"Query" name:"CurrentStage"`
	ClusterId       string           `position:"Query" name:"ClusterId"`
	InstanceId      string           `position:"Query" name:"InstanceId"`
	DiskId          string           `position:"Query" name:"DiskId"`
	CurrentState    string           `position:"Query" name:"CurrentState"`
}

// DescribeDiskOpsActivityResponse is the response struct for api DescribeDiskOpsActivity
type DescribeDiskOpsActivityResponse struct {
	*responses.BaseResponse
	RequestId       string `json:"RequestId" xml:"RequestId"`
	ClusterType     string `json:"ClusterType" xml:"ClusterType"`
	CurrentActivity string `json:"CurrentActivity" xml:"CurrentActivity"`
	ActivityState   string `json:"ActivityState" xml:"ActivityState"`
	ErrorMessage    string `json:"ErrorMessage" xml:"ErrorMessage"`
	NeedReboot      bool   `json:"NeedReboot" xml:"NeedReboot"`
}

// CreateDescribeDiskOpsActivityRequest creates a request to invoke DescribeDiskOpsActivity API
func CreateDescribeDiskOpsActivityRequest() (request *DescribeDiskOpsActivityRequest) {
	request = &DescribeDiskOpsActivityRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "DescribeDiskOpsActivity", "emr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDiskOpsActivityResponse creates a response to parse from DescribeDiskOpsActivity response
func CreateDescribeDiskOpsActivityResponse() (response *DescribeDiskOpsActivityResponse) {
	response = &DescribeDiskOpsActivityResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
