package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListDiskOpsEvents invokes the emr.ListDiskOpsEvents API synchronously
func (client *Client) ListDiskOpsEvents(request *ListDiskOpsEventsRequest) (response *ListDiskOpsEventsResponse, err error) {
	response = CreateListDiskOpsEventsResponse()
	err = client.DoAction(request, response)
	return
}

// ListDiskOpsEventsWithChan invokes the emr.ListDiskOpsEvents API asynchronously
func (client *Client) ListDiskOpsEventsWithChan(request *ListDiskOpsEventsRequest) (<-chan *ListDiskOpsEventsResponse, <-chan error) {
	responseChan := make(chan *ListDiskOpsEventsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListDiskOpsEvents(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListDiskOpsEventsWithCallback invokes the emr.ListDiskOpsEvents API asynchronously
func (client *Client) ListDiskOpsEventsWithCallback(request *ListDiskOpsEventsRequest, callback func(response *ListDiskOpsEventsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListDiskOpsEventsResponse
		var err error
		defer close(result)
		response, err = client.ListDiskOpsEvents(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListDiskOpsEventsRequest is the request struct for api ListDiskOpsEvents
type ListDiskOpsEventsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	EndTime         requests.Integer `position:"Query" name:"EndTime"`
	ClusterId       string           `position:"Query" name:"ClusterId"`
	StartTime       requests.Integer `position:"Query" name:"StartTime"`
	PageNumber      requests.Integer `position:"Query" name:"PageNumber"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
}

// ListDiskOpsEventsResponse is the response struct for api ListDiskOpsEvents
type ListDiskOpsEventsResponse struct {
	*responses.BaseResponse
	RequestId  string    `json:"RequestId" xml:"RequestId"`
	PageNumber int       `json:"PageNumber" xml:"PageNumber"`
	PageSize   int       `json:"PageSize" xml:"PageSize"`
	TotalCount int       `json:"TotalCount" xml:"TotalCount"`
	EventList  EventList `json:"EventList" xml:"EventList"`
}

// CreateListDiskOpsEventsRequest creates a request to invoke ListDiskOpsEvents API
func CreateListDiskOpsEventsRequest() (request *ListDiskOpsEventsRequest) {
	request = &ListDiskOpsEventsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ListDiskOpsEvents", "emr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListDiskOpsEventsResponse creates a response to parse from ListDiskOpsEvents response
func CreateListDiskOpsEventsResponse() (response *ListDiskOpsEventsResponse) {
	response = &ListDiskOpsEventsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
