package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RunDiskOpsActivity invokes the emr.RunDiskOpsActivity API synchronously
func (client *Client) RunDiskOpsActivity(request *RunDiskOpsActivityRequest) (response *RunDiskOpsActivityResponse, err error) {
	response = CreateRunDiskOpsActivityResponse()
	err = client.DoAction(request, response)
	return
}

// RunDiskOpsActivityWithChan invokes the emr.RunDiskOpsActivity API asynchronously
func (client *Client) RunDiskOpsActivityWithChan(request *RunDiskOpsActivityRequest) (<-chan *RunDiskOpsActivityResponse, <-chan error) {
	responseChan := make(chan *RunDiskOpsActivityResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RunDiskOpsActivity(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RunDiskOpsActivityWithCallback invokes the emr.RunDiskOpsActivity API asynchronously
func (client *Client) RunDiskOpsActivityWithCallback(request *RunDiskOpsActivityRequest, callback func(response *RunDiskOpsActivityResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RunDiskOpsActivityResponse
		var err error
		defer close(result)
		response, err = client.RunDiskOpsActivity(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RunDiskOpsActivityRequest is the request struct for api RunDiskOpsActivity
type RunDiskOpsActivityRequest struct {
	*requests.RpcRequest
	EventId         string           `position:"Query" name:"EventId"`
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	CurrentStage    string           `position:"Query" name:"CurrentStage"`
	ClusterId       string           `position:"Query" name:"ClusterId"`
	InstanceId      string           `position:"Query" name:"InstanceId"`
	DiskId          string           `position:"Query" name:"DiskId"`
	CurrentState    string           `position:"Query" name:"CurrentState"`
}

// RunDiskOpsActivityResponse is the response struct for api RunDiskOpsActivity
type RunDiskOpsActivityResponse struct {
	*responses.BaseResponse
	RequestId       string `json:"RequestId" xml:"RequestId"`
	ClusterType     string `json:"ClusterType" xml:"ClusterType"`
	CurrentActivity string `json:"CurrentActivity" xml:"CurrentActivity"`
	ActivityState   string `json:"ActivityState" xml:"ActivityState"`
	ErrorMessage    string `json:"ErrorMessage" xml:"ErrorMessage"`
	NeedReboot      bool   `json:"NeedReboot" xml:"NeedReboot"`
}

// CreateRunDiskOpsActivityRequest creates a request to invoke RunDiskOpsActivity API
func CreateRunDiskOpsActivityRequest() (request *RunDiskOpsActivityRequest) {
	request = &RunDiskOpsActivityRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "RunDiskOpsActivity", "emr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRunDiskOpsActivityResponse creates a response to parse from RunDiskOpsActivity response
func CreateRunDiskOpsActivityResponse() (response *RunDiskOpsActivityResponse) {
	response = &RunDiskOpsActivityResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
