package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CloneNacosConfig invokes the mse.CloneNacosConfig API synchronously
func (client *Client) CloneNacosConfig(request *CloneNacosConfigRequest) (response *CloneNacosConfigResponse, err error) {
	response = CreateCloneNacosConfigResponse()
	err = client.DoAction(request, response)
	return
}

// CloneNacosConfigWithChan invokes the mse.CloneNacosConfig API asynchronously
func (client *Client) CloneNacosConfigWithChan(request *CloneNacosConfigRequest) (<-chan *CloneNacosConfigResponse, <-chan error) {
	responseChan := make(chan *CloneNacosConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CloneNacosConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CloneNacosConfigWithCallback invokes the mse.CloneNacosConfig API asynchronously
func (client *Client) CloneNacosConfigWithCallback(request *CloneNacosConfigRequest, callback func(response *CloneNacosConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CloneNacosConfigResponse
		var err error
		defer close(result)
		response, err = client.CloneNacosConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CloneNacosConfigRequest is the request struct for api CloneNacosConfig
type CloneNacosConfigRequest struct {
	*requests.RpcRequest
	TargetNamespaceId string `position:"Query" name:"TargetNamespaceId"`
	InstanceId        string `position:"Query" name:"InstanceId"`
	Ids               string `position:"Query" name:"Ids"`
	OriginNamespaceId string `position:"Query" name:"OriginNamespaceId"`
	Policy            string `position:"Query" name:"Policy"`
}

// CloneNacosConfigResponse is the response struct for api CloneNacosConfig
type CloneNacosConfigResponse struct {
	*responses.BaseResponse
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	Code           int    `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	DynamicMessage string `json:"DynamicMessage" xml:"DynamicMessage"`
	Data           Data   `json:"Data" xml:"Data"`
}

// CreateCloneNacosConfigRequest creates a request to invoke CloneNacosConfig API
func CreateCloneNacosConfigRequest() (request *CloneNacosConfigRequest) {
	request = &CloneNacosConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "CloneNacosConfig", "", "")
	request.Method = requests.POST
	return
}

// CreateCloneNacosConfigResponse creates a response to parse from CloneNacosConfig response
func CreateCloneNacosConfigResponse() (response *CloneNacosConfigResponse) {
	response = &CloneNacosConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
