package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateGovernanceKubernetesCluster invokes the mse.CreateGovernanceKubernetesCluster API synchronously
func (client *Client) CreateGovernanceKubernetesCluster(request *CreateGovernanceKubernetesClusterRequest) (response *CreateGovernanceKubernetesClusterResponse, err error) {
	response = CreateCreateGovernanceKubernetesClusterResponse()
	err = client.DoAction(request, response)
	return
}

// CreateGovernanceKubernetesClusterWithChan invokes the mse.CreateGovernanceKubernetesCluster API asynchronously
func (client *Client) CreateGovernanceKubernetesClusterWithChan(request *CreateGovernanceKubernetesClusterRequest) (<-chan *CreateGovernanceKubernetesClusterResponse, <-chan error) {
	responseChan := make(chan *CreateGovernanceKubernetesClusterResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateGovernanceKubernetesCluster(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateGovernanceKubernetesClusterWithCallback invokes the mse.CreateGovernanceKubernetesCluster API asynchronously
func (client *Client) CreateGovernanceKubernetesClusterWithCallback(request *CreateGovernanceKubernetesClusterRequest, callback func(response *CreateGovernanceKubernetesClusterResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateGovernanceKubernetesClusterResponse
		var err error
		defer close(result)
		response, err = client.CreateGovernanceKubernetesCluster(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateGovernanceKubernetesClusterRequest is the request struct for api CreateGovernanceKubernetesCluster
type CreateGovernanceKubernetesClusterRequest struct {
	*requests.RpcRequest
	ClusterName    string           `position:"Query" name:"ClusterName"`
	NameSpaceInfos string           `position:"Query" name:"NameSpaceInfos"`
	ClusterId      string           `position:"Query" name:"ClusterId"`
	K8sVersion     string           `position:"Query" name:"K8sVersion"`
	PilotStartTime requests.Integer `position:"Query" name:"PilotStartTime"`
}

// CreateGovernanceKubernetesClusterResponse is the response struct for api CreateGovernanceKubernetesCluster
type CreateGovernanceKubernetesClusterResponse struct {
	*responses.BaseResponse
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Data           int64  `json:"Data" xml:"Data"`
	Code           int    `json:"Code" xml:"Code"`
	Success        string `json:"Success" xml:"Success"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
}

// CreateCreateGovernanceKubernetesClusterRequest creates a request to invoke CreateGovernanceKubernetesCluster API
func CreateCreateGovernanceKubernetesClusterRequest() (request *CreateGovernanceKubernetesClusterRequest) {
	request = &CreateGovernanceKubernetesClusterRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "CreateGovernanceKubernetesCluster", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateGovernanceKubernetesClusterResponse creates a response to parse from CreateGovernanceKubernetesCluster response
func CreateCreateGovernanceKubernetesClusterResponse() (response *CreateGovernanceKubernetesClusterResponse) {
	response = &CreateGovernanceKubernetesClusterResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
