package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetGatewayOption invokes the mse.GetGatewayOption API synchronously
func (client *Client) GetGatewayOption(request *GetGatewayOptionRequest) (response *GetGatewayOptionResponse, err error) {
	response = CreateGetGatewayOptionResponse()
	err = client.DoAction(request, response)
	return
}

// GetGatewayOptionWithChan invokes the mse.GetGatewayOption API asynchronously
func (client *Client) GetGatewayOptionWithChan(request *GetGatewayOptionRequest) (<-chan *GetGatewayOptionResponse, <-chan error) {
	responseChan := make(chan *GetGatewayOptionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetGatewayOption(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetGatewayOptionWithCallback invokes the mse.GetGatewayOption API asynchronously
func (client *Client) GetGatewayOptionWithCallback(request *GetGatewayOptionRequest, callback func(response *GetGatewayOptionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetGatewayOptionResponse
		var err error
		defer close(result)
		response, err = client.GetGatewayOption(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetGatewayOptionRequest is the request struct for api GetGatewayOption
type GetGatewayOptionRequest struct {
	*requests.RpcRequest
	GatewayId requests.Integer `position:"Query" name:"GatewayId"`
}

// GetGatewayOptionResponse is the response struct for api GetGatewayOption
type GetGatewayOptionResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	Code           int    `json:"Code" xml:"Code"`
	Success        bool   `json:"Success" xml:"Success"`
	Data           Data   `json:"Data" xml:"Data"`
}

// CreateGetGatewayOptionRequest creates a request to invoke GetGatewayOption API
func CreateGetGatewayOptionRequest() (request *GetGatewayOptionRequest) {
	request = &GetGatewayOptionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "GetGatewayOption", "", "")
	request.Method = requests.POST
	return
}

// CreateGetGatewayOptionResponse creates a response to parse from GetGatewayOption response
func CreateGetGatewayOptionResponse() (response *GetGatewayOptionResponse) {
	response = &GetGatewayOptionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
