package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListAlarmRules invokes the mse.ListAlarmRules API synchronously
func (client *Client) ListAlarmRules(request *ListAlarmRulesRequest) (response *ListAlarmRulesResponse, err error) {
	response = CreateListAlarmRulesResponse()
	err = client.DoAction(request, response)
	return
}

// ListAlarmRulesWithChan invokes the mse.ListAlarmRules API asynchronously
func (client *Client) ListAlarmRulesWithChan(request *ListAlarmRulesRequest) (<-chan *ListAlarmRulesResponse, <-chan error) {
	responseChan := make(chan *ListAlarmRulesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListAlarmRules(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListAlarmRulesWithCallback invokes the mse.ListAlarmRules API asynchronously
func (client *Client) ListAlarmRulesWithCallback(request *ListAlarmRulesRequest, callback func(response *ListAlarmRulesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListAlarmRulesResponse
		var err error
		defer close(result)
		response, err = client.ListAlarmRules(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListAlarmRulesRequest is the request struct for api ListAlarmRules
type ListAlarmRulesRequest struct {
	*requests.RpcRequest
	AlarmMseType string           `position:"Query" name:"AlarmMseType"`
	PageNum      requests.Integer `position:"Query" name:"PageNum"`
	RequestPars  string           `position:"Query" name:"RequestPars"`
	PageSize     requests.Integer `position:"Query" name:"PageSize"`
}

// ListAlarmRulesResponse is the response struct for api ListAlarmRules
type ListAlarmRulesResponse struct {
	*responses.BaseResponse
	HttpCode   string           `json:"HttpCode" xml:"HttpCode"`
	TotalCount int              `json:"TotalCount" xml:"TotalCount"`
	RequestId  string           `json:"RequestId" xml:"RequestId"`
	Message    string           `json:"Message" xml:"Message"`
	PageSize   int              `json:"PageSize" xml:"PageSize"`
	PageNumber int              `json:"PageNumber" xml:"PageNumber"`
	ErrorCode  string           `json:"ErrorCode" xml:"ErrorCode"`
	Success    bool             `json:"Success" xml:"Success"`
	Data       []AlarmRuleModel `json:"Data" xml:"Data"`
}

// CreateListAlarmRulesRequest creates a request to invoke ListAlarmRules API
func CreateListAlarmRulesRequest() (request *ListAlarmRulesRequest) {
	request = &ListAlarmRulesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "ListAlarmRules", "", "")
	request.Method = requests.GET
	return
}

// CreateListAlarmRulesResponse creates a response to parse from ListAlarmRules response
func CreateListAlarmRulesResponse() (response *ListAlarmRulesResponse) {
	response = &ListAlarmRulesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
