package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListClusterVersions invokes the mse.ListClusterVersions API synchronously
func (client *Client) ListClusterVersions(request *ListClusterVersionsRequest) (response *ListClusterVersionsResponse, err error) {
	response = CreateListClusterVersionsResponse()
	err = client.DoAction(request, response)
	return
}

// ListClusterVersionsWithChan invokes the mse.ListClusterVersions API asynchronously
func (client *Client) ListClusterVersionsWithChan(request *ListClusterVersionsRequest) (<-chan *ListClusterVersionsResponse, <-chan error) {
	responseChan := make(chan *ListClusterVersionsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListClusterVersions(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListClusterVersionsWithCallback invokes the mse.ListClusterVersions API asynchronously
func (client *Client) ListClusterVersionsWithCallback(request *ListClusterVersionsRequest, callback func(response *ListClusterVersionsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListClusterVersionsResponse
		var err error
		defer close(result)
		response, err = client.ListClusterVersions(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListClusterVersionsRequest is the request struct for api ListClusterVersions
type ListClusterVersionsRequest struct {
	*requests.RpcRequest
	ClusterType string `position:"Query" name:"ClusterType"`
}

// ListClusterVersionsResponse is the response struct for api ListClusterVersions
type ListClusterVersionsResponse struct {
	*responses.BaseResponse
	HttpStatusCode int        `json:"HttpStatusCode" xml:"HttpStatusCode"`
	RequestId      string     `json:"RequestId" xml:"RequestId"`
	Success        bool       `json:"Success" xml:"Success"`
	ErrorCode      string     `json:"ErrorCode" xml:"ErrorCode"`
	Code           int        `json:"Code" xml:"Code"`
	Message        string     `json:"Message" xml:"Message"`
	DynamicMessage string     `json:"DynamicMessage" xml:"DynamicMessage"`
	Data           []DataItem `json:"Data" xml:"Data"`
}

// CreateListClusterVersionsRequest creates a request to invoke ListClusterVersions API
func CreateListClusterVersionsRequest() (request *ListClusterVersionsRequest) {
	request = &ListClusterVersionsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "ListClusterVersions", "", "")
	request.Method = requests.POST
	return
}

// CreateListClusterVersionsResponse creates a response to parse from ListClusterVersions response
func CreateListClusterVersionsResponse() (response *ListClusterVersionsResponse) {
	response = &ListClusterVersionsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
