package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListNacosConfigs invokes the mse.ListNacosConfigs API synchronously
func (client *Client) ListNacosConfigs(request *ListNacosConfigsRequest) (response *ListNacosConfigsResponse, err error) {
	response = CreateListNacosConfigsResponse()
	err = client.DoAction(request, response)
	return
}

// ListNacosConfigsWithChan invokes the mse.ListNacosConfigs API asynchronously
func (client *Client) ListNacosConfigsWithChan(request *ListNacosConfigsRequest) (<-chan *ListNacosConfigsResponse, <-chan error) {
	responseChan := make(chan *ListNacosConfigsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListNacosConfigs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListNacosConfigsWithCallback invokes the mse.ListNacosConfigs API asynchronously
func (client *Client) ListNacosConfigsWithCallback(request *ListNacosConfigsRequest, callback func(response *ListNacosConfigsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListNacosConfigsResponse
		var err error
		defer close(result)
		response, err = client.ListNacosConfigs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListNacosConfigsRequest is the request struct for api ListNacosConfigs
type ListNacosConfigsRequest struct {
	*requests.RpcRequest
	PageNum     requests.Integer `position:"Query" name:"PageNum"`
	Tags        string           `position:"Query" name:"Tags"`
	InstanceId  string           `position:"Query" name:"InstanceId"`
	DataId      string           `position:"Query" name:"DataId"`
	AppName     string           `position:"Query" name:"AppName"`
	NamespaceId string           `position:"Query" name:"NamespaceId"`
	RequestPars string           `position:"Query" name:"RequestPars"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
	Group       string           `position:"Query" name:"Group"`
}

// ListNacosConfigsResponse is the response struct for api ListNacosConfigs
type ListNacosConfigsResponse struct {
	*responses.BaseResponse
	HttpCode       string                    `json:"HttpCode" xml:"HttpCode"`
	TotalCount     int                       `json:"TotalCount" xml:"TotalCount"`
	RequestId      string                    `json:"RequestId" xml:"RequestId"`
	Message        string                    `json:"Message" xml:"Message"`
	PageSize       int                       `json:"PageSize" xml:"PageSize"`
	PageNumber     int                       `json:"PageNumber" xml:"PageNumber"`
	ErrorCode      string                    `json:"ErrorCode" xml:"ErrorCode"`
	Code           int                       `json:"Code" xml:"Code"`
	Success        bool                      `json:"Success" xml:"Success"`
	Configurations []NacosConfigForListModel `json:"Configurations" xml:"Configurations"`
}

// CreateListNacosConfigsRequest creates a request to invoke ListNacosConfigs API
func CreateListNacosConfigsRequest() (request *ListNacosConfigsRequest) {
	request = &ListNacosConfigsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "ListNacosConfigs", "", "")
	request.Method = requests.POST
	return
}

// CreateListNacosConfigsResponse creates a response to parse from ListNacosConfigs response
func CreateListNacosConfigsResponse() (response *ListNacosConfigsResponse) {
	response = &ListNacosConfigsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
