package retailcloud

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetInstTransInfo invokes the retailcloud.GetInstTransInfo API synchronously
func (client *Client) GetInstTransInfo(request *GetInstTransInfoRequest) (response *GetInstTransInfoResponse, err error) {
	response = CreateGetInstTransInfoResponse()
	err = client.DoAction(request, response)
	return
}

// GetInstTransInfoWithChan invokes the retailcloud.GetInstTransInfo API asynchronously
func (client *Client) GetInstTransInfoWithChan(request *GetInstTransInfoRequest) (<-chan *GetInstTransInfoResponse, <-chan error) {
	responseChan := make(chan *GetInstTransInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetInstTransInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetInstTransInfoWithCallback invokes the retailcloud.GetInstTransInfo API asynchronously
func (client *Client) GetInstTransInfoWithCallback(request *GetInstTransInfoRequest, callback func(response *GetInstTransInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetInstTransInfoResponse
		var err error
		defer close(result)
		response, err = client.GetInstTransInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetInstTransInfoRequest is the request struct for api GetInstTransInfo
type GetInstTransInfoRequest struct {
	*requests.RpcRequest
	AliyunUid           string `position:"Body" name:"aliyunUid"`
	AliyunEquipId       string `position:"Body" name:"aliyunEquipId"`
	AliyunCommodityCode string `position:"Body" name:"aliyunCommodityCode"`
}

// GetInstTransInfoResponse is the response struct for api GetInstTransInfo
type GetInstTransInfoResponse struct {
	*responses.BaseResponse
	InstanceId  string `json:"instanceId" xml:"instanceId"`
	IsAutoRenew bool   `json:"isAutoRenew" xml:"isAutoRenew"`
	RenewCycle  int    `json:"renewCycle" xml:"renewCycle"`
	ChargeType  string `json:"chargeType" xml:"chargeType"`
	EndTime     int64  `json:"endTime" xml:"endTime"`
	StartTime   int64  `json:"startTime" xml:"startTime"`
}

// CreateGetInstTransInfoRequest creates a request to invoke GetInstTransInfo API
func CreateGetInstTransInfoRequest() (request *GetInstTransInfoRequest) {
	request = &GetInstTransInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("retailcloud", "2018-03-13", "GetInstTransInfo", "", "")
	request.Method = requests.POST
	return
}

// CreateGetInstTransInfoResponse creates a response to parse from GetInstTransInfo response
func CreateGetInstTransInfoResponse() (response *GetInstTransInfoResponse) {
	response = &GetInstTransInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
