package waf_openapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeInstanceInfos invokes the waf_openapi.DescribeInstanceInfos API synchronously
func (client *Client) DescribeInstanceInfos(request *DescribeInstanceInfosRequest) (response *DescribeInstanceInfosResponse, err error) {
	response = CreateDescribeInstanceInfosResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeInstanceInfosWithChan invokes the waf_openapi.DescribeInstanceInfos API asynchronously
func (client *Client) DescribeInstanceInfosWithChan(request *DescribeInstanceInfosRequest) (<-chan *DescribeInstanceInfosResponse, <-chan error) {
	responseChan := make(chan *DescribeInstanceInfosResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeInstanceInfos(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeInstanceInfosWithCallback invokes the waf_openapi.DescribeInstanceInfos API asynchronously
func (client *Client) DescribeInstanceInfosWithCallback(request *DescribeInstanceInfosRequest, callback func(response *DescribeInstanceInfosResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeInstanceInfosResponse
		var err error
		defer close(result)
		response, err = client.DescribeInstanceInfos(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeInstanceInfosRequest is the request struct for api DescribeInstanceInfos
type DescribeInstanceInfosRequest struct {
	*requests.RpcRequest
	ResourceGroupId string `position:"Query" name:"ResourceGroupId"`
	InstanceId      string `position:"Query" name:"InstanceId"`
	SourceIp        string `position:"Query" name:"SourceIp"`
	InstanceSource  string `position:"Query" name:"InstanceSource"`
	Lang            string `position:"Query" name:"Lang"`
}

// DescribeInstanceInfosResponse is the response struct for api DescribeInstanceInfos
type DescribeInstanceInfosResponse struct {
	*responses.BaseResponse
	RequestId     string         `json:"RequestId" xml:"RequestId"`
	InstanceInfos []InstanceInfo `json:"InstanceInfos" xml:"InstanceInfos"`
}

// CreateDescribeInstanceInfosRequest creates a request to invoke DescribeInstanceInfos API
func CreateDescribeInstanceInfosRequest() (request *DescribeInstanceInfosRequest) {
	request = &DescribeInstanceInfosRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("waf-openapi", "2019-09-10", "DescribeInstanceInfos", "waf", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeInstanceInfosResponse creates a response to parse from DescribeInstanceInfos response
func CreateDescribeInstanceInfosResponse() (response *DescribeInstanceInfosResponse) {
	response = &DescribeInstanceInfosResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
