/*

Copyright 2017 Google Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

*/

// Code generated by protoc-gen-go.
// source: credstore.proto
// DO NOT EDIT!

/*
Package api is a generated protocol buffer package.

It is generated from these files:
	credstore.proto

It has these top-level messages:
	AuthRequest
	AuthReply
	SigningKeyRequest
	SigningKeyReply
	GetTokenRequest
	GetTokenReply
*/
package api

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

type AuthRequest struct {
}

func (m *AuthRequest) Reset()                    { *m = AuthRequest{} }
func (m *AuthRequest) String() string            { return proto.CompactTextString(m) }
func (*AuthRequest) ProtoMessage()               {}
func (*AuthRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

type AuthReply struct {
	// JWT that can be used with other CredStore RPCs.
	AuthJwt string `protobuf:"bytes,1,opt,name=auth_jwt,json=authJwt" json:"auth_jwt,omitempty"`
}

func (m *AuthReply) Reset()                    { *m = AuthReply{} }
func (m *AuthReply) String() string            { return proto.CompactTextString(m) }
func (*AuthReply) ProtoMessage()               {}
func (*AuthReply) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *AuthReply) GetAuthJwt() string {
	if m != nil {
		return m.AuthJwt
	}
	return ""
}

type SigningKeyRequest struct {
}

func (m *SigningKeyRequest) Reset()                    { *m = SigningKeyRequest{} }
func (m *SigningKeyRequest) String() string            { return proto.CompactTextString(m) }
func (*SigningKeyRequest) ProtoMessage()               {}
func (*SigningKeyRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

type SigningKeyReply struct {
	// DER-encoded public key used to sign JWTs on this server.
	SigningKey []byte `protobuf:"bytes,1,opt,name=signing_key,json=signingKey,proto3" json:"signing_key,omitempty"`
}

func (m *SigningKeyReply) Reset()                    { *m = SigningKeyReply{} }
func (m *SigningKeyReply) String() string            { return proto.CompactTextString(m) }
func (*SigningKeyReply) ProtoMessage()               {}
func (*SigningKeyReply) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *SigningKeyReply) GetSigningKey() []byte {
	if m != nil {
		return m.SigningKey
	}
	return nil
}

type GetTokenRequest struct {
	// Target RPC endpoint.
	Target string `protobuf:"bytes,1,opt,name=target" json:"target,omitempty"`
}

func (m *GetTokenRequest) Reset()                    { *m = GetTokenRequest{} }
func (m *GetTokenRequest) String() string            { return proto.CompactTextString(m) }
func (*GetTokenRequest) ProtoMessage()               {}
func (*GetTokenRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *GetTokenRequest) GetTarget() string {
	if m != nil {
		return m.Target
	}
	return ""
}

type GetTokenReply struct {
	// JWT to use with target RPC.
	SessionJwt string `protobuf:"bytes,1,opt,name=session_jwt,json=sessionJwt" json:"session_jwt,omitempty"`
}

func (m *GetTokenReply) Reset()                    { *m = GetTokenReply{} }
func (m *GetTokenReply) String() string            { return proto.CompactTextString(m) }
func (*GetTokenReply) ProtoMessage()               {}
func (*GetTokenReply) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

func (m *GetTokenReply) GetSessionJwt() string {
	if m != nil {
		return m.SessionJwt
	}
	return ""
}

func init() {
	proto.RegisterType((*AuthRequest)(nil), "api.AuthRequest")
	proto.RegisterType((*AuthReply)(nil), "api.AuthReply")
	proto.RegisterType((*SigningKeyRequest)(nil), "api.SigningKeyRequest")
	proto.RegisterType((*SigningKeyReply)(nil), "api.SigningKeyReply")
	proto.RegisterType((*GetTokenRequest)(nil), "api.GetTokenRequest")
	proto.RegisterType((*GetTokenReply)(nil), "api.GetTokenReply")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for CredStoreAuth service

type CredStoreAuthClient interface {
	// Auth takes in jwt.AppToken (bundled into the binary) and returns a jwt.AppToken,
	// useable for other RPCs with credstore.
	Auth(ctx context.Context, in *AuthRequest, opts ...grpc.CallOption) (*AuthReply, error)
	// Returns the currently used public key.
	SigningKey(ctx context.Context, in *SigningKeyRequest, opts ...grpc.CallOption) (*SigningKeyReply, error)
}

type credStoreAuthClient struct {
	cc *grpc.ClientConn
}

func NewCredStoreAuthClient(cc *grpc.ClientConn) CredStoreAuthClient {
	return &credStoreAuthClient{cc}
}

func (c *credStoreAuthClient) Auth(ctx context.Context, in *AuthRequest, opts ...grpc.CallOption) (*AuthReply, error) {
	out := new(AuthReply)
	err := grpc.Invoke(ctx, "/api.CredStoreAuth/Auth", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *credStoreAuthClient) SigningKey(ctx context.Context, in *SigningKeyRequest, opts ...grpc.CallOption) (*SigningKeyReply, error) {
	out := new(SigningKeyReply)
	err := grpc.Invoke(ctx, "/api.CredStoreAuth/SigningKey", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for CredStoreAuth service

type CredStoreAuthServer interface {
	// Auth takes in jwt.AppToken (bundled into the binary) and returns a jwt.AppToken,
	// useable for other RPCs with credstore.
	Auth(context.Context, *AuthRequest) (*AuthReply, error)
	// Returns the currently used public key.
	SigningKey(context.Context, *SigningKeyRequest) (*SigningKeyReply, error)
}

func RegisterCredStoreAuthServer(s *grpc.Server, srv CredStoreAuthServer) {
	s.RegisterService(&_CredStoreAuth_serviceDesc, srv)
}

func _CredStoreAuth_Auth_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AuthRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CredStoreAuthServer).Auth(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.CredStoreAuth/Auth",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CredStoreAuthServer).Auth(ctx, req.(*AuthRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CredStoreAuth_SigningKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SigningKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CredStoreAuthServer).SigningKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.CredStoreAuth/SigningKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CredStoreAuthServer).SigningKey(ctx, req.(*SigningKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _CredStoreAuth_serviceDesc = grpc.ServiceDesc{
	ServiceName: "api.CredStoreAuth",
	HandlerType: (*CredStoreAuthServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Auth",
			Handler:    _CredStoreAuth_Auth_Handler,
		},
		{
			MethodName: "SigningKey",
			Handler:    _CredStoreAuth_SigningKey_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "credstore.proto",
}

// Client API for CredStore service

type CredStoreClient interface {
	// GetToken provides a JWT token for remote endpoint based on its DNS name.
	GetToken(ctx context.Context, in *GetTokenRequest, opts ...grpc.CallOption) (*GetTokenReply, error)
}

type credStoreClient struct {
	cc *grpc.ClientConn
}

func NewCredStoreClient(cc *grpc.ClientConn) CredStoreClient {
	return &credStoreClient{cc}
}

func (c *credStoreClient) GetToken(ctx context.Context, in *GetTokenRequest, opts ...grpc.CallOption) (*GetTokenReply, error) {
	out := new(GetTokenReply)
	err := grpc.Invoke(ctx, "/api.CredStore/GetToken", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for CredStore service

type CredStoreServer interface {
	// GetToken provides a JWT token for remote endpoint based on its DNS name.
	GetToken(context.Context, *GetTokenRequest) (*GetTokenReply, error)
}

func RegisterCredStoreServer(s *grpc.Server, srv CredStoreServer) {
	s.RegisterService(&_CredStore_serviceDesc, srv)
}

func _CredStore_GetToken_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTokenRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CredStoreServer).GetToken(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.CredStore/GetToken",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CredStoreServer).GetToken(ctx, req.(*GetTokenRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _CredStore_serviceDesc = grpc.ServiceDesc{
	ServiceName: "api.CredStore",
	HandlerType: (*CredStoreServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetToken",
			Handler:    _CredStore_GetToken_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "credstore.proto",
}

func init() { proto.RegisterFile("credstore.proto", fileDescriptor0) }

var fileDescriptor0 = []byte{
	// 264 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x64, 0x91, 0x41, 0x4b, 0xc3, 0x40,
	0x10, 0x46, 0x2d, 0x4a, 0x6d, 0xa6, 0xc6, 0xe8, 0x2a, 0x45, 0x73, 0x51, 0xf6, 0x20, 0xea, 0x21,
	0x48, 0x04, 0x4f, 0x5e, 0xa4, 0x07, 0xa1, 0xde, 0x52, 0xef, 0x25, 0xda, 0x21, 0x5d, 0x5b, 0xb2,
	0xeb, 0xee, 0x84, 0xb0, 0xff, 0xbe, 0x64, 0x93, 0xb4, 0xa1, 0x39, 0x85, 0x79, 0x99, 0xf9, 0x66,
	0x1e, 0x0b, 0xc1, 0xaf, 0xc6, 0xa5, 0x21, 0xa9, 0x31, 0x52, 0x5a, 0x92, 0x64, 0xc7, 0xa9, 0x12,
	0xdc, 0x87, 0xf1, 0x47, 0x41, 0xab, 0x04, 0xff, 0x0b, 0x34, 0xc4, 0x1f, 0xc0, 0xab, 0x4b, 0xb5,
	0xb1, 0xec, 0x16, 0x46, 0x69, 0x41, 0xab, 0xc5, 0x5f, 0x49, 0x37, 0x83, 0xfb, 0xc1, 0xa3, 0x97,
	0x9c, 0x56, 0xf5, 0xac, 0x24, 0x7e, 0x05, 0x97, 0x73, 0x91, 0xe5, 0x22, 0xcf, 0xbe, 0xd0, 0xb6,
	0xc3, 0x31, 0x04, 0x5d, 0x58, 0x45, 0xdc, 0xc1, 0xd8, 0xd4, 0x68, 0xb1, 0x46, 0xeb, 0x52, 0xce,
	0x12, 0x30, 0xbb, 0x2e, 0xfe, 0x04, 0xc1, 0x27, 0xd2, 0xb7, 0x5c, 0x63, 0xde, 0xc4, 0xb0, 0x09,
	0x0c, 0x29, 0xd5, 0x19, 0xb6, 0x4b, 0x9b, 0x8a, 0xbf, 0x80, 0xbf, 0x6f, 0x6d, 0xc3, 0xd1, 0x18,
	0x21, 0xf3, 0xce, 0x89, 0xd0, 0xa0, 0x59, 0x49, 0xb1, 0x05, 0x7f, 0xaa, 0x71, 0x39, 0xaf, 0xa4,
	0x2b, 0x2d, 0xf6, 0x0c, 0x27, 0xee, 0x7b, 0x11, 0xa5, 0x4a, 0x44, 0x1d, 0xf1, 0xf0, 0xbc, 0x43,
	0xd4, 0xc6, 0xf2, 0x23, 0xf6, 0x0e, 0xb0, 0xb7, 0x61, 0x13, 0xf7, 0xbf, 0xe7, 0x1c, 0x5e, 0xf7,
	0xb8, 0x9b, 0x8e, 0xa7, 0xe0, 0xed, 0x56, 0xb3, 0x37, 0x18, 0xb5, 0x97, 0xb3, 0x7a, 0xe0, 0xc0,
	0x39, 0x64, 0x07, 0xd4, 0x85, 0xfc, 0x0c, 0xdd, 0x43, 0xbd, 0x6e, 0x03, 0x00, 0x00, 0xff, 0xff,
	0x99, 0x63, 0x48, 0x6d, 0xbb, 0x01, 0x00, 0x00,
}
