#!/bin/bash

LOG=$2
CONF=/etc/cpfs/lustre.conf

case "$1" in
    start)
        #
        # do nothing if config doesn't exist
        #
        if [ ! -f ${CONF} ]; then
            echo "Skip config lustre because $CONF not exists" >> ${LOG}
            exit
        fi

        echo "Setting up lustre config..." >> ${LOG}

        # Set mount options
        options=`tr -d '\r' < $CONF`
        for option in $options; do
            if [ -z "$option" ]; then
                continue # ignore empty line
            fi
            lctl set_param $option >> ${LOG}
            [ $? -eq 0 ] || { echo "Lctl set_param $option failed" >> ${LOG}; exit 1; }
        done
        echo "Lustre config done" >> ${LOG}
        ;;
    stop)
        ;;
    *)
        echo "Usage: $0 {start|stop} [log]"
        exit 3
        ;;
    esac
