#!/bin/bash

LOG=$2
CONF=/etc/cpfs/cgroup.conf
CGROUP_NAME=cpfs_cpu_conf
CGROUP_DIR_NAME=/sys/fs/cgroup/cpu/$CGROUP_NAME

add_cpfs_pid()
{
    cpfs_pid=`ps -ef | grep "$1" | grep -v "grep" | awk '{print $2}'`
    [ -z "$cpfs_pid" ] && { echo "$1 pid not found"; return 1; }
    cgclassify -g cpu:$CGROUP_NAME $cpfs_pid
    [ $? -eq 0 ] && { return 0; } || { echo "$1 pid $cpfs_pid add cgroup $CGROUP_NAME failed"; return 1; }
}

# If not install libcgroups, exit
command -v cgclassify >/dev/null 2>&1 || { echo "Need install libcgroup and libcgroup-tools" >> ${LOG}; exit 1; }

case "$1" in
    start)
        #
        # do nothing if config doesn't exist
        #
        if [ -f ${CONF} ]; then
            . ${CONF}
        else
            echo "Skip config cgroup because $CONF not exists" >> ${LOG}
            exit
        fi
        [[ -z "$CPU_SHARES_VAL" || $CPU_SHARES_VAL -eq 0 ]] && { echo "Skip cgroup config because no CPU_SHARES_VAL" >> ${LOG}; exit; }

        echo "Setting up cgroup config..." >> ${LOG}

        # Check cgroup directory exist or not
        [ ! -d "$CGROUP_DIR_NAME" ] && mkdir -p $CGROUP_DIR_NAME
        [ $? -eq 0 ] || { echo "Mkdir $CGROUP_DIR_NAME failed" >> ${LOG}; exit 1; }

        # Set cpu.shares value
        echo $CPU_SHARES_VAL > $CGROUP_DIR_NAME/cpu.shares
        if [ `cat $CGROUP_DIR_NAME/cpu.shares` -ne $CPU_SHARES_VAL ]; then
            echo "Cpu.shares set failed" >> ${LOG}
            exit 1
        fi
        echo "Set cgroup ${CGROUP_DIR_NAME}/cpu.shares to ${CPU_SHARES_VAL}" >> ${LOG}

        # Add pid
        res=`add_cpfs_pid socknal`
        [ $? -eq 0 ] && echo "Add socknal to cgroup done" >> ${LOG} || { echo "$res" >> ${LOG}; exit 1; }
        res=`add_cpfs_pid ptlrpc`
        [ $? -eq 0 ] && echo "Add ptlrpc to cgroup done" >> ${LOG} || { echo "$res" >> ${LOG}; exit 1; }
        res=`add_cpfs_pid ldlm`
        [ $? -eq 0 ] && echo "Add ldlm to cgroup done" >> ${LOG} || { echo "$res" >> ${LOG}; exit 1; }
        ;;
    stop)
        echo "Removing cgroup config..." >> ${LOG}
        if [ -d "$CGROUP_DIR_NAME" ]; then
            cgdelete cpu:$CGROUP_NAME
            if [ $? -ne 0 ]; then
                echo "Cgroup delete failed" >> ${LOG}
                exit 1
            fi
            echo "Cgroup $CGROUP_NAME deleted" >> ${LOG}
        fi
        ;;
    *)
        echo "Usage: $0 {start|stop} [log]"
        exit 3
        ;;
    esac

