// Copyright 2021 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package recommender provides access to the Recommender API.
//
// For product documentation, see: https://cloud.google.com/recommender/docs/
//
// Creating a client
//
// Usage example:
//
//   import "google.golang.org/api/recommender/v1"
//   ...
//   ctx := context.Background()
//   recommenderService, err := recommender.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for authentication.
//
// For information on how to create and obtain Application Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API keys), use option.WithAPIKey:
//
//   recommenderService, err := recommender.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth flow), use option.WithTokenSource:
//
//   config := &oauth2.Config{...}
//   // ...
//   token, err := config.Exchange(ctx, ...)
//   recommenderService, err := recommender.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See https://godoc.org/google.golang.org/api/option/ for details on options.
package recommender // import "google.golang.org/api/recommender/v1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	googleapi "google.golang.org/api/googleapi"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint

const apiId = "recommender:v1"
const apiName = "recommender"
const apiVersion = "v1"
const basePath = "https://recommender.googleapis.com/"
const mtlsBasePath = "https://recommender.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the
	// email address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := option.WithScopes(
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s, err := New(client)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	s := &Service{client: client, BasePath: basePath}
	s.BillingAccounts = NewBillingAccountsService(s)
	s.Folders = NewFoldersService(s)
	s.Organizations = NewOrganizationsService(s)
	s.Projects = NewProjectsService(s)
	return s, nil
}

type Service struct {
	client    *http.Client
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	BillingAccounts *BillingAccountsService

	Folders *FoldersService

	Organizations *OrganizationsService

	Projects *ProjectsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewBillingAccountsService(s *Service) *BillingAccountsService {
	rs := &BillingAccountsService{s: s}
	rs.Locations = NewBillingAccountsLocationsService(s)
	return rs
}

type BillingAccountsService struct {
	s *Service

	Locations *BillingAccountsLocationsService
}

func NewBillingAccountsLocationsService(s *Service) *BillingAccountsLocationsService {
	rs := &BillingAccountsLocationsService{s: s}
	rs.InsightTypes = NewBillingAccountsLocationsInsightTypesService(s)
	rs.Recommenders = NewBillingAccountsLocationsRecommendersService(s)
	return rs
}

type BillingAccountsLocationsService struct {
	s *Service

	InsightTypes *BillingAccountsLocationsInsightTypesService

	Recommenders *BillingAccountsLocationsRecommendersService
}

func NewBillingAccountsLocationsInsightTypesService(s *Service) *BillingAccountsLocationsInsightTypesService {
	rs := &BillingAccountsLocationsInsightTypesService{s: s}
	rs.Insights = NewBillingAccountsLocationsInsightTypesInsightsService(s)
	return rs
}

type BillingAccountsLocationsInsightTypesService struct {
	s *Service

	Insights *BillingAccountsLocationsInsightTypesInsightsService
}

func NewBillingAccountsLocationsInsightTypesInsightsService(s *Service) *BillingAccountsLocationsInsightTypesInsightsService {
	rs := &BillingAccountsLocationsInsightTypesInsightsService{s: s}
	return rs
}

type BillingAccountsLocationsInsightTypesInsightsService struct {
	s *Service
}

func NewBillingAccountsLocationsRecommendersService(s *Service) *BillingAccountsLocationsRecommendersService {
	rs := &BillingAccountsLocationsRecommendersService{s: s}
	rs.Recommendations = NewBillingAccountsLocationsRecommendersRecommendationsService(s)
	return rs
}

type BillingAccountsLocationsRecommendersService struct {
	s *Service

	Recommendations *BillingAccountsLocationsRecommendersRecommendationsService
}

func NewBillingAccountsLocationsRecommendersRecommendationsService(s *Service) *BillingAccountsLocationsRecommendersRecommendationsService {
	rs := &BillingAccountsLocationsRecommendersRecommendationsService{s: s}
	return rs
}

type BillingAccountsLocationsRecommendersRecommendationsService struct {
	s *Service
}

func NewFoldersService(s *Service) *FoldersService {
	rs := &FoldersService{s: s}
	rs.Locations = NewFoldersLocationsService(s)
	return rs
}

type FoldersService struct {
	s *Service

	Locations *FoldersLocationsService
}

func NewFoldersLocationsService(s *Service) *FoldersLocationsService {
	rs := &FoldersLocationsService{s: s}
	rs.InsightTypes = NewFoldersLocationsInsightTypesService(s)
	rs.Recommenders = NewFoldersLocationsRecommendersService(s)
	return rs
}

type FoldersLocationsService struct {
	s *Service

	InsightTypes *FoldersLocationsInsightTypesService

	Recommenders *FoldersLocationsRecommendersService
}

func NewFoldersLocationsInsightTypesService(s *Service) *FoldersLocationsInsightTypesService {
	rs := &FoldersLocationsInsightTypesService{s: s}
	rs.Insights = NewFoldersLocationsInsightTypesInsightsService(s)
	return rs
}

type FoldersLocationsInsightTypesService struct {
	s *Service

	Insights *FoldersLocationsInsightTypesInsightsService
}

func NewFoldersLocationsInsightTypesInsightsService(s *Service) *FoldersLocationsInsightTypesInsightsService {
	rs := &FoldersLocationsInsightTypesInsightsService{s: s}
	return rs
}

type FoldersLocationsInsightTypesInsightsService struct {
	s *Service
}

func NewFoldersLocationsRecommendersService(s *Service) *FoldersLocationsRecommendersService {
	rs := &FoldersLocationsRecommendersService{s: s}
	rs.Recommendations = NewFoldersLocationsRecommendersRecommendationsService(s)
	return rs
}

type FoldersLocationsRecommendersService struct {
	s *Service

	Recommendations *FoldersLocationsRecommendersRecommendationsService
}

func NewFoldersLocationsRecommendersRecommendationsService(s *Service) *FoldersLocationsRecommendersRecommendationsService {
	rs := &FoldersLocationsRecommendersRecommendationsService{s: s}
	return rs
}

type FoldersLocationsRecommendersRecommendationsService struct {
	s *Service
}

func NewOrganizationsService(s *Service) *OrganizationsService {
	rs := &OrganizationsService{s: s}
	rs.Locations = NewOrganizationsLocationsService(s)
	return rs
}

type OrganizationsService struct {
	s *Service

	Locations *OrganizationsLocationsService
}

func NewOrganizationsLocationsService(s *Service) *OrganizationsLocationsService {
	rs := &OrganizationsLocationsService{s: s}
	rs.InsightTypes = NewOrganizationsLocationsInsightTypesService(s)
	rs.Recommenders = NewOrganizationsLocationsRecommendersService(s)
	return rs
}

type OrganizationsLocationsService struct {
	s *Service

	InsightTypes *OrganizationsLocationsInsightTypesService

	Recommenders *OrganizationsLocationsRecommendersService
}

func NewOrganizationsLocationsInsightTypesService(s *Service) *OrganizationsLocationsInsightTypesService {
	rs := &OrganizationsLocationsInsightTypesService{s: s}
	rs.Insights = NewOrganizationsLocationsInsightTypesInsightsService(s)
	return rs
}

type OrganizationsLocationsInsightTypesService struct {
	s *Service

	Insights *OrganizationsLocationsInsightTypesInsightsService
}

func NewOrganizationsLocationsInsightTypesInsightsService(s *Service) *OrganizationsLocationsInsightTypesInsightsService {
	rs := &OrganizationsLocationsInsightTypesInsightsService{s: s}
	return rs
}

type OrganizationsLocationsInsightTypesInsightsService struct {
	s *Service
}

func NewOrganizationsLocationsRecommendersService(s *Service) *OrganizationsLocationsRecommendersService {
	rs := &OrganizationsLocationsRecommendersService{s: s}
	rs.Recommendations = NewOrganizationsLocationsRecommendersRecommendationsService(s)
	return rs
}

type OrganizationsLocationsRecommendersService struct {
	s *Service

	Recommendations *OrganizationsLocationsRecommendersRecommendationsService
}

func NewOrganizationsLocationsRecommendersRecommendationsService(s *Service) *OrganizationsLocationsRecommendersRecommendationsService {
	rs := &OrganizationsLocationsRecommendersRecommendationsService{s: s}
	return rs
}

type OrganizationsLocationsRecommendersRecommendationsService struct {
	s *Service
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.Locations = NewProjectsLocationsService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	Locations *ProjectsLocationsService
}

func NewProjectsLocationsService(s *Service) *ProjectsLocationsService {
	rs := &ProjectsLocationsService{s: s}
	rs.InsightTypes = NewProjectsLocationsInsightTypesService(s)
	rs.Recommenders = NewProjectsLocationsRecommendersService(s)
	return rs
}

type ProjectsLocationsService struct {
	s *Service

	InsightTypes *ProjectsLocationsInsightTypesService

	Recommenders *ProjectsLocationsRecommendersService
}

func NewProjectsLocationsInsightTypesService(s *Service) *ProjectsLocationsInsightTypesService {
	rs := &ProjectsLocationsInsightTypesService{s: s}
	rs.Insights = NewProjectsLocationsInsightTypesInsightsService(s)
	return rs
}

type ProjectsLocationsInsightTypesService struct {
	s *Service

	Insights *ProjectsLocationsInsightTypesInsightsService
}

func NewProjectsLocationsInsightTypesInsightsService(s *Service) *ProjectsLocationsInsightTypesInsightsService {
	rs := &ProjectsLocationsInsightTypesInsightsService{s: s}
	return rs
}

type ProjectsLocationsInsightTypesInsightsService struct {
	s *Service
}

func NewProjectsLocationsRecommendersService(s *Service) *ProjectsLocationsRecommendersService {
	rs := &ProjectsLocationsRecommendersService{s: s}
	rs.Recommendations = NewProjectsLocationsRecommendersRecommendationsService(s)
	return rs
}

type ProjectsLocationsRecommendersService struct {
	s *Service

	Recommendations *ProjectsLocationsRecommendersRecommendationsService
}

func NewProjectsLocationsRecommendersRecommendationsService(s *Service) *ProjectsLocationsRecommendersRecommendationsService {
	rs := &ProjectsLocationsRecommendersRecommendationsService{s: s}
	return rs
}

type ProjectsLocationsRecommendersRecommendationsService struct {
	s *Service
}

// GoogleCloudRecommenderV1CostProjection: Contains metadata about how
// much money a recommendation can save or incur.
type GoogleCloudRecommenderV1CostProjection struct {
	// Cost: An approximate projection on amount saved or amount incurred.
	// Negative cost units indicate cost savings and positive cost units
	// indicate increase. See google.type.Money documentation for
	// positive/negative units.
	Cost *GoogleTypeMoney `json:"cost,omitempty"`

	// Duration: Duration for which this cost applies.
	Duration string `json:"duration,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Cost") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Cost") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRecommenderV1CostProjection) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRecommenderV1CostProjection
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRecommenderV1Impact: Contains the impact a recommendation
// can have for a given category.
type GoogleCloudRecommenderV1Impact struct {
	// Category: Category that is being targeted.
	//
	// Possible values:
	//   "CATEGORY_UNSPECIFIED" - Default unspecified category. Don't use
	// directly.
	//   "COST" - Indicates a potential increase or decrease in cost.
	//   "SECURITY" - Indicates a potential increase or decrease in
	// security.
	//   "PERFORMANCE" - Indicates a potential increase or decrease in
	// performance.
	//   "MANAGEABILITY" - Indicates a potential increase or decrease in
	// manageability.
	Category string `json:"category,omitempty"`

	// CostProjection: Use with CategoryType.COST
	CostProjection *GoogleCloudRecommenderV1CostProjection `json:"costProjection,omitempty"`

	// SecurityProjection: Use with CategoryType.SECURITY
	SecurityProjection *GoogleCloudRecommenderV1SecurityProjection `json:"securityProjection,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Category") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Category") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRecommenderV1Impact) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRecommenderV1Impact
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRecommenderV1Insight: An insight along with the
// information used to derive the insight. The insight may have
// associated recomendations as well.
type GoogleCloudRecommenderV1Insight struct {
	// AssociatedRecommendations: Recommendations derived from this insight.
	AssociatedRecommendations []*GoogleCloudRecommenderV1InsightRecommendationReference `json:"associatedRecommendations,omitempty"`

	// Category: Category being targeted by the insight.
	//
	// Possible values:
	//   "CATEGORY_UNSPECIFIED" - Unspecified category.
	//   "COST" - The insight is related to cost.
	//   "SECURITY" - The insight is related to security.
	//   "PERFORMANCE" - The insight is related to performance.
	//   "MANAGEABILITY" - This insight is related to manageability.
	Category string `json:"category,omitempty"`

	// Content: A struct of custom fields to explain the insight. Example:
	// "grantedPermissionsCount": "1000"
	Content googleapi.RawMessage `json:"content,omitempty"`

	// Description: Free-form human readable summary in English. The maximum
	// length is 500 characters.
	Description string `json:"description,omitempty"`

	// Etag: Fingerprint of the Insight. Provides optimistic locking when
	// updating states.
	Etag string `json:"etag,omitempty"`

	// InsightSubtype: Insight subtype. Insight content schema will be
	// stable for a given subtype.
	InsightSubtype string `json:"insightSubtype,omitempty"`

	// LastRefreshTime: Timestamp of the latest data used to generate the
	// insight.
	LastRefreshTime string `json:"lastRefreshTime,omitempty"`

	// Name: Name of the insight.
	Name string `json:"name,omitempty"`

	// ObservationPeriod: Observation period that led to the insight. The
	// source data used to generate the insight ends at last_refresh_time
	// and begins at (last_refresh_time - observation_period).
	ObservationPeriod string `json:"observationPeriod,omitempty"`

	// Severity: Insight's severity.
	//
	// Possible values:
	//   "SEVERITY_UNSPECIFIED" - Insight has unspecified severity.
	//   "LOW" - Insight has low severity.
	//   "MEDIUM" - Insight has medium severity.
	//   "HIGH" - Insight has high severity.
	//   "CRITICAL" - Insight has critical severity.
	Severity string `json:"severity,omitempty"`

	// StateInfo: Information state and metadata.
	StateInfo *GoogleCloudRecommenderV1InsightStateInfo `json:"stateInfo,omitempty"`

	// TargetResources: Fully qualified resource names that this insight is
	// targeting.
	TargetResources []string `json:"targetResources,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g.
	// "AssociatedRecommendations") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "AssociatedRecommendations") to include in API requests with the JSON
	// null value. By default, fields with empty values are omitted from API
	// requests. However, any field with an empty value appearing in
	// NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRecommenderV1Insight) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRecommenderV1Insight
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRecommenderV1InsightRecommendationReference: Reference to
// an associated recommendation.
type GoogleCloudRecommenderV1InsightRecommendationReference struct {
	// Recommendation: Recommendation resource name, e.g.
	// projects/[PROJECT_NUMBER]/locations/[LOCATION]/recommenders/[RECOMMEND
	// ER_ID]/recommendations/[RECOMMENDATION_ID]
	Recommendation string `json:"recommendation,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Recommendation") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Recommendation") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRecommenderV1InsightRecommendationReference) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRecommenderV1InsightRecommendationReference
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRecommenderV1InsightStateInfo: Information related to
// insight state.
type GoogleCloudRecommenderV1InsightStateInfo struct {
	// State: Insight state.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unspecified state.
	//   "ACTIVE" - Insight is active. Content for ACTIVE insights can be
	// updated by Google. ACTIVE insights can be marked DISMISSED OR
	// ACCEPTED.
	//   "ACCEPTED" - Some action has been taken based on this insight.
	// Insights become accepted when a recommendation derived from the
	// insight has been marked CLAIMED, SUCCEEDED, or FAILED. ACTIVE
	// insights can also be marked ACCEPTED explicitly. Content for ACCEPTED
	// insights is immutable. ACCEPTED insights can only be marked ACCEPTED
	// (which may update state metadata).
	//   "DISMISSED" - Insight is dismissed. Content for DISMISSED insights
	// can be updated by Google. DISMISSED insights can be marked as ACTIVE.
	State string `json:"state,omitempty"`

	// StateMetadata: A map of metadata for the state, provided by user or
	// automations systems.
	StateMetadata map[string]string `json:"stateMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "State") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "State") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRecommenderV1InsightStateInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRecommenderV1InsightStateInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRecommenderV1ListInsightsResponse: Response to the
// `ListInsights` method.
type GoogleCloudRecommenderV1ListInsightsResponse struct {
	// Insights: The set of insights for the `parent` resource.
	Insights []*GoogleCloudRecommenderV1Insight `json:"insights,omitempty"`

	// NextPageToken: A token that can be used to request the next page of
	// results. This field is empty if there are no additional results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Insights") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Insights") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRecommenderV1ListInsightsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRecommenderV1ListInsightsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRecommenderV1ListRecommendationsResponse: Response to the
// `ListRecommendations` method.
type GoogleCloudRecommenderV1ListRecommendationsResponse struct {
	// NextPageToken: A token that can be used to request the next page of
	// results. This field is empty if there are no additional results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Recommendations: The set of recommendations for the `parent`
	// resource.
	Recommendations []*GoogleCloudRecommenderV1Recommendation `json:"recommendations,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRecommenderV1ListRecommendationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRecommenderV1ListRecommendationsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRecommenderV1MarkInsightAcceptedRequest: Request for the
// `MarkInsightAccepted` method.
type GoogleCloudRecommenderV1MarkInsightAcceptedRequest struct {
	// Etag: Required. Fingerprint of the Insight. Provides optimistic
	// locking.
	Etag string `json:"etag,omitempty"`

	// StateMetadata: Optional. State properties user wish to include with
	// this state. Full replace of the current state_metadata.
	StateMetadata map[string]string `json:"stateMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Etag") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Etag") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRecommenderV1MarkInsightAcceptedRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRecommenderV1MarkInsightAcceptedRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRecommenderV1MarkRecommendationClaimedRequest: Request for
// the `MarkRecommendationClaimed` Method.
type GoogleCloudRecommenderV1MarkRecommendationClaimedRequest struct {
	// Etag: Required. Fingerprint of the Recommendation. Provides
	// optimistic locking.
	Etag string `json:"etag,omitempty"`

	// StateMetadata: State properties to include with this state.
	// Overwrites any existing `state_metadata`. Keys must match the regex
	// `/^a-z0-9{0,62}$/`. Values must match the regex
	// `/^[a-zA-Z0-9_./-]{0,255}$/`.
	StateMetadata map[string]string `json:"stateMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Etag") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Etag") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRecommenderV1MarkRecommendationClaimedRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRecommenderV1MarkRecommendationClaimedRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRecommenderV1MarkRecommendationFailedRequest: Request for
// the `MarkRecommendationFailed` Method.
type GoogleCloudRecommenderV1MarkRecommendationFailedRequest struct {
	// Etag: Required. Fingerprint of the Recommendation. Provides
	// optimistic locking.
	Etag string `json:"etag,omitempty"`

	// StateMetadata: State properties to include with this state.
	// Overwrites any existing `state_metadata`. Keys must match the regex
	// `/^a-z0-9{0,62}$/`. Values must match the regex
	// `/^[a-zA-Z0-9_./-]{0,255}$/`.
	StateMetadata map[string]string `json:"stateMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Etag") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Etag") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRecommenderV1MarkRecommendationFailedRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRecommenderV1MarkRecommendationFailedRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRecommenderV1MarkRecommendationSucceededRequest: Request
// for the `MarkRecommendationSucceeded` Method.
type GoogleCloudRecommenderV1MarkRecommendationSucceededRequest struct {
	// Etag: Required. Fingerprint of the Recommendation. Provides
	// optimistic locking.
	Etag string `json:"etag,omitempty"`

	// StateMetadata: State properties to include with this state.
	// Overwrites any existing `state_metadata`. Keys must match the regex
	// `/^a-z0-9{0,62}$/`. Values must match the regex
	// `/^[a-zA-Z0-9_./-]{0,255}$/`.
	StateMetadata map[string]string `json:"stateMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Etag") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Etag") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRecommenderV1MarkRecommendationSucceededRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRecommenderV1MarkRecommendationSucceededRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRecommenderV1Operation: Contains an operation for a
// resource loosely based on the JSON-PATCH format with support for: *
// Custom filters for describing partial array patch. * Extended path
// values for describing nested arrays. * Custom fields for describing
// the resource for which the operation is being described. * Allows
// extension to custom operations not natively supported by RFC6902. See
// https://tools.ietf.org/html/rfc6902 for details on the original RFC.
type GoogleCloudRecommenderV1Operation struct {
	// Action: Type of this operation. Contains one of 'add', 'remove',
	// 'replace', 'move', 'copy', 'test' and custom operations. This field
	// is case-insensitive and always populated.
	Action string `json:"action,omitempty"`

	// Path: Path to the target field being operated on. If the operation is
	// at the resource level, then path should be "/". This field is always
	// populated.
	Path string `json:"path,omitempty"`

	// PathFilters: Set of filters to apply if `path` refers to array
	// elements or nested array elements in order to narrow down to a single
	// unique element that is being tested/modified. This is intended to be
	// an exact match per filter. To perform advanced matching, use
	// path_value_matchers. * Example: ``` { "/versions/*/name" : "it-123"
	// "/versions/*/targetSize/percent": 20 } ``` * Example: ``` {
	// "/bindings/*/role": "roles/owner" "/bindings/*/condition" : null }
	// ``` * Example: ``` { "/bindings/*/role": "roles/owner"
	// "/bindings/*/members/*" : ["x@example.com", "y@example.com"] } ```
	// When both path_filters and path_value_matchers are set, an implicit
	// AND must be performed.
	PathFilters googleapi.RawMessage `json:"pathFilters,omitempty"`

	// PathValueMatchers: Similar to path_filters, this contains set of
	// filters to apply if `path` field refers to array elements. This is
	// meant to support value matching beyond exact match. To perform exact
	// match, use path_filters. When both path_filters and
	// path_value_matchers are set, an implicit AND must be performed.
	PathValueMatchers map[string]GoogleCloudRecommenderV1ValueMatcher `json:"pathValueMatchers,omitempty"`

	// Resource: Contains the fully qualified resource name. This field is
	// always populated. ex:
	// //cloudresourcemanager.googleapis.com/projects/foo.
	Resource string `json:"resource,omitempty"`

	// ResourceType: Type of GCP resource being modified/tested. This field
	// is always populated. Example:
	// cloudresourcemanager.googleapis.com/Project,
	// compute.googleapis.com/Instance
	ResourceType string `json:"resourceType,omitempty"`

	// SourcePath: Can be set with action 'copy' or 'move' to indicate the
	// source field within resource or source_resource, ignored if provided
	// for other operation types.
	SourcePath string `json:"sourcePath,omitempty"`

	// SourceResource: Can be set with action 'copy' to copy resource
	// configuration across different resources of the same type. Example: A
	// resource clone can be done via action = 'copy', path = "/", from =
	// "/", source_resource = and resource_name = . This field is empty for
	// all other values of `action`.
	SourceResource string `json:"sourceResource,omitempty"`

	// Value: Value for the `path` field. Will be set for
	// actions:'add'/'replace'. Maybe set for action: 'test'. Either this or
	// `value_matcher` will be set for 'test' operation. An exact match must
	// be performed.
	Value interface{} `json:"value,omitempty"`

	// ValueMatcher: Can be set for action 'test' for advanced matching for
	// the value of 'path' field. Either this or `value` will be set for
	// 'test' operation.
	ValueMatcher *GoogleCloudRecommenderV1ValueMatcher `json:"valueMatcher,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Action") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRecommenderV1Operation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRecommenderV1Operation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRecommenderV1OperationGroup: Group of operations that need
// to be performed atomically.
type GoogleCloudRecommenderV1OperationGroup struct {
	// Operations: List of operations across one or more resources that
	// belong to this group. Loosely based on RFC6902 and should be
	// performed in the order they appear.
	Operations []*GoogleCloudRecommenderV1Operation `json:"operations,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Operations") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Operations") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRecommenderV1OperationGroup) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRecommenderV1OperationGroup
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRecommenderV1Recommendation: A recommendation along with a
// suggested action. E.g., a rightsizing recommendation for an
// underutilized VM, IAM role recommendations, etc
type GoogleCloudRecommenderV1Recommendation struct {
	// AdditionalImpact: Optional set of additional impact that this
	// recommendation may have when trying to optimize for the primary
	// category. These may be positive or negative.
	AdditionalImpact []*GoogleCloudRecommenderV1Impact `json:"additionalImpact,omitempty"`

	// AssociatedInsights: Insights that led to this recommendation.
	AssociatedInsights []*GoogleCloudRecommenderV1RecommendationInsightReference `json:"associatedInsights,omitempty"`

	// Content: Content of the recommendation describing recommended changes
	// to resources.
	Content *GoogleCloudRecommenderV1RecommendationContent `json:"content,omitempty"`

	// Description: Free-form human readable summary in English. The maximum
	// length is 500 characters.
	Description string `json:"description,omitempty"`

	// Etag: Fingerprint of the Recommendation. Provides optimistic locking
	// when updating states.
	Etag string `json:"etag,omitempty"`

	// LastRefreshTime: Last time this recommendation was refreshed by the
	// system that created it in the first place.
	LastRefreshTime string `json:"lastRefreshTime,omitempty"`

	// Name: Name of recommendation.
	Name string `json:"name,omitempty"`

	// PrimaryImpact: The primary impact that this recommendation can have
	// while trying to optimize for one category.
	PrimaryImpact *GoogleCloudRecommenderV1Impact `json:"primaryImpact,omitempty"`

	// Priority: Recommendation's priority.
	//
	// Possible values:
	//   "PRIORITY_UNSPECIFIED" - Recommendation has unspecified priority.
	//   "P4" - Recommendation has P4 priority (lowest priority).
	//   "P3" - Recommendation has P3 priority (second lowest priority).
	//   "P2" - Recommendation has P2 priority (second highest priority).
	//   "P1" - Recommendation has P1 priority (highest priority).
	Priority string `json:"priority,omitempty"`

	// RecommenderSubtype: Contains an identifier for a subtype of
	// recommendations produced for the same recommender. Subtype is a
	// function of content and impact, meaning a new subtype might be added
	// when significant changes to `content` or `primary_impact.category`
	// are introduced. See the Recommenders section to see a list of
	// subtypes for a given Recommender. Examples: For recommender =
	// "google.iam.policy.Recommender", recommender_subtype can be one of
	// "REMOVE_ROLE"/"REPLACE_ROLE"
	RecommenderSubtype string `json:"recommenderSubtype,omitempty"`

	// StateInfo: Information for state. Contains state and metadata.
	StateInfo *GoogleCloudRecommenderV1RecommendationStateInfo `json:"stateInfo,omitempty"`

	// XorGroupId: Corresponds to a mutually exclusive group ID within a
	// recommender. A non-empty ID indicates that the recommendation belongs
	// to a mutually exclusive group. This means that only one
	// recommendation within the group is suggested to be applied.
	XorGroupId string `json:"xorGroupId,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AdditionalImpact") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AdditionalImpact") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRecommenderV1Recommendation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRecommenderV1Recommendation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRecommenderV1RecommendationContent: Contains what
// resources are changing and how they are changing.
type GoogleCloudRecommenderV1RecommendationContent struct {
	// OperationGroups: Operations to one or more Google Cloud resources
	// grouped in such a way that, all operations within one group are
	// expected to be performed atomically and in an order.
	OperationGroups []*GoogleCloudRecommenderV1OperationGroup `json:"operationGroups,omitempty"`

	// Overview: Condensed overview information about the recommendation.
	Overview googleapi.RawMessage `json:"overview,omitempty"`

	// ForceSendFields is a list of field names (e.g. "OperationGroups") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "OperationGroups") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRecommenderV1RecommendationContent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRecommenderV1RecommendationContent
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRecommenderV1RecommendationInsightReference: Reference to
// an associated insight.
type GoogleCloudRecommenderV1RecommendationInsightReference struct {
	// Insight: Insight resource name, e.g.
	// projects/[PROJECT_NUMBER]/locations/[LOCATION]/insightTypes/[INSIGHT_T
	// YPE_ID]/insights/[INSIGHT_ID]
	Insight string `json:"insight,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Insight") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Insight") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRecommenderV1RecommendationInsightReference) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRecommenderV1RecommendationInsightReference
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRecommenderV1RecommendationStateInfo: Information for
// state. Contains state and metadata.
type GoogleCloudRecommenderV1RecommendationStateInfo struct {
	// State: The state of the recommendation, Eg ACTIVE, SUCCEEDED, FAILED.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Default state. Don't use directly.
	//   "ACTIVE" - Recommendation is active and can be applied.
	// Recommendations content can be updated by Google. ACTIVE
	// recommendations can be marked as CLAIMED, SUCCEEDED, or FAILED.
	//   "CLAIMED" - Recommendation is in claimed state. Recommendations
	// content is immutable and cannot be updated by Google. CLAIMED
	// recommendations can be marked as CLAIMED, SUCCEEDED, or FAILED.
	//   "SUCCEEDED" - Recommendation is in succeeded state. Recommendations
	// content is immutable and cannot be updated by Google. SUCCEEDED
	// recommendations can be marked as SUCCEEDED, or FAILED.
	//   "FAILED" - Recommendation is in failed state. Recommendations
	// content is immutable and cannot be updated by Google. FAILED
	// recommendations can be marked as SUCCEEDED, or FAILED.
	//   "DISMISSED" - Recommendation is in dismissed state. Recommendation
	// content can be updated by Google. DISMISSED recommendations can be
	// marked as ACTIVE.
	State string `json:"state,omitempty"`

	// StateMetadata: A map of metadata for the state, provided by user or
	// automations systems.
	StateMetadata map[string]string `json:"stateMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "State") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "State") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRecommenderV1RecommendationStateInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRecommenderV1RecommendationStateInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRecommenderV1SecurityProjection: Contains various ways of
// describing the impact on Security.
type GoogleCloudRecommenderV1SecurityProjection struct {
	// Details: Additional security impact details that is provided by the
	// recommender.
	Details googleapi.RawMessage `json:"details,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Details") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Details") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRecommenderV1SecurityProjection) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRecommenderV1SecurityProjection
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRecommenderV1ValueMatcher: Contains various matching
// options for values for a GCP resource field.
type GoogleCloudRecommenderV1ValueMatcher struct {
	// MatchesPattern: To be used for full regex matching. The regular
	// expression is using the Google RE2 syntax
	// (https://github.com/google/re2/wiki/Syntax), so to be used with
	// RE2::FullMatch
	MatchesPattern string `json:"matchesPattern,omitempty"`

	// ForceSendFields is a list of field names (e.g. "MatchesPattern") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MatchesPattern") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRecommenderV1ValueMatcher) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRecommenderV1ValueMatcher
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleTypeMoney: Represents an amount of money with its currency
// type.
type GoogleTypeMoney struct {
	// CurrencyCode: The three-letter currency code defined in ISO 4217.
	CurrencyCode string `json:"currencyCode,omitempty"`

	// Nanos: Number of nano (10^-9) units of the amount. The value must be
	// between -999,999,999 and +999,999,999 inclusive. If `units` is
	// positive, `nanos` must be positive or zero. If `units` is zero,
	// `nanos` can be positive, zero, or negative. If `units` is negative,
	// `nanos` must be negative or zero. For example $-1.75 is represented
	// as `units`=-1 and `nanos`=-750,000,000.
	Nanos int64 `json:"nanos,omitempty"`

	// Units: The whole units of the amount. For example if `currencyCode`
	// is "USD", then 1 unit is one US dollar.
	Units int64 `json:"units,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "CurrencyCode") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CurrencyCode") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleTypeMoney) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleTypeMoney
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// method id "recommender.billingAccounts.locations.insightTypes.insights.get":

type BillingAccountsLocationsInsightTypesInsightsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the requested insight. Requires the recommender.*.get IAM
// permission for the specified insight type.
//
// - name: Name of the insight.
func (r *BillingAccountsLocationsInsightTypesInsightsService) Get(name string) *BillingAccountsLocationsInsightTypesInsightsGetCall {
	c := &BillingAccountsLocationsInsightTypesInsightsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *BillingAccountsLocationsInsightTypesInsightsGetCall) Fields(s ...googleapi.Field) *BillingAccountsLocationsInsightTypesInsightsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *BillingAccountsLocationsInsightTypesInsightsGetCall) IfNoneMatch(entityTag string) *BillingAccountsLocationsInsightTypesInsightsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *BillingAccountsLocationsInsightTypesInsightsGetCall) Context(ctx context.Context) *BillingAccountsLocationsInsightTypesInsightsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *BillingAccountsLocationsInsightTypesInsightsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BillingAccountsLocationsInsightTypesInsightsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211207")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "recommender.billingAccounts.locations.insightTypes.insights.get" call.
// Exactly one of *GoogleCloudRecommenderV1Insight or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleCloudRecommenderV1Insight.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *BillingAccountsLocationsInsightTypesInsightsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRecommenderV1Insight, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudRecommenderV1Insight{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the requested insight. Requires the recommender.*.get IAM permission for the specified insight type.",
	//   "flatPath": "v1/billingAccounts/{billingAccountsId}/locations/{locationsId}/insightTypes/{insightTypesId}/insights/{insightsId}",
	//   "httpMethod": "GET",
	//   "id": "recommender.billingAccounts.locations.insightTypes.insights.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Name of the insight.",
	//       "location": "path",
	//       "pattern": "^billingAccounts/[^/]+/locations/[^/]+/insightTypes/[^/]+/insights/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudRecommenderV1Insight"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "recommender.billingAccounts.locations.insightTypes.insights.list":

type BillingAccountsLocationsInsightTypesInsightsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists insights for the specified Cloud Resource. Requires the
// recommender.*.list IAM permission for the specified insight type.
//
// - parent: The container resource on which to execute the request.
//   Acceptable formats: *
//   `projects/[PROJECT_NUMBER]/locations/[LOCATION]/insightTypes/[INSIGH
//   T_TYPE_ID]` *
//   `projects/[PROJECT_ID]/locations/[LOCATION]/insightTypes/[INSIGHT_TY
//   PE_ID]` *
//   `billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION]/insightTy
//   pes/[INSIGHT_TYPE_ID]` *
//   `folders/[FOLDER_ID]/locations/[LOCATION]/insightTypes/[INSIGHT_TYPE
//   _ID]` *
//   `organizations/[ORGANIZATION_ID]/locations/[LOCATION]/insightTypes/[
//   INSIGHT_TYPE_ID]` LOCATION here refers to GCP Locations:
//   https://cloud.google.com/about/locations/ INSIGHT_TYPE_ID refers to
//   supported insight types:
//   https://cloud.google.com/recommender/docs/insights/insight-types.
func (r *BillingAccountsLocationsInsightTypesInsightsService) List(parent string) *BillingAccountsLocationsInsightTypesInsightsListCall {
	c := &BillingAccountsLocationsInsightTypesInsightsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filter expression to
// restrict the insights returned. Supported filter fields: *
// `stateInfo.state` * `insightSubtype` * `severity` Examples: *
// `stateInfo.state = ACTIVE OR stateInfo.state = DISMISSED` *
// `insightSubtype = PERMISSIONS_USAGE` * `severity = CRITICAL OR
// severity = HIGH` * `stateInfo.state = ACTIVE AND (severity = CRITICAL
// OR severity = HIGH)` (These expressions are based on the filter
// language described at https://google.aip.dev/160)
func (c *BillingAccountsLocationsInsightTypesInsightsListCall) Filter(filter string) *BillingAccountsLocationsInsightTypesInsightsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of results to return from this request. Non-positive values are
// ignored. If not specified, the server will determine the number of
// results to return.
func (c *BillingAccountsLocationsInsightTypesInsightsListCall) PageSize(pageSize int64) *BillingAccountsLocationsInsightTypesInsightsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": If present,
// retrieves the next batch of results from the preceding call to this
// method. `page_token` must be the value of `next_page_token` from the
// previous response. The values of other method parameters must be
// identical to those in the previous call.
func (c *BillingAccountsLocationsInsightTypesInsightsListCall) PageToken(pageToken string) *BillingAccountsLocationsInsightTypesInsightsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *BillingAccountsLocationsInsightTypesInsightsListCall) Fields(s ...googleapi.Field) *BillingAccountsLocationsInsightTypesInsightsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *BillingAccountsLocationsInsightTypesInsightsListCall) IfNoneMatch(entityTag string) *BillingAccountsLocationsInsightTypesInsightsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *BillingAccountsLocationsInsightTypesInsightsListCall) Context(ctx context.Context) *BillingAccountsLocationsInsightTypesInsightsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *BillingAccountsLocationsInsightTypesInsightsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BillingAccountsLocationsInsightTypesInsightsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211207")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/insights")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "recommender.billingAccounts.locations.insightTypes.insights.list" call.
// Exactly one of *GoogleCloudRecommenderV1ListInsightsResponse or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudRecommenderV1ListInsightsResponse.ServerResponse.Header
// or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *BillingAccountsLocationsInsightTypesInsightsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRecommenderV1ListInsightsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudRecommenderV1ListInsightsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists insights for the specified Cloud Resource. Requires the recommender.*.list IAM permission for the specified insight type.",
	//   "flatPath": "v1/billingAccounts/{billingAccountsId}/locations/{locationsId}/insightTypes/{insightTypesId}/insights",
	//   "httpMethod": "GET",
	//   "id": "recommender.billingAccounts.locations.insightTypes.insights.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "Optional. Filter expression to restrict the insights returned. Supported filter fields: * `stateInfo.state` * `insightSubtype` * `severity` Examples: * `stateInfo.state = ACTIVE OR stateInfo.state = DISMISSED` * `insightSubtype = PERMISSIONS_USAGE` * `severity = CRITICAL OR severity = HIGH` * `stateInfo.state = ACTIVE AND (severity = CRITICAL OR severity = HIGH)` (These expressions are based on the filter language described at https://google.aip.dev/160)",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "Optional. The maximum number of results to return from this request. Non-positive values are ignored. If not specified, the server will determine the number of results to return.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "Optional. If present, retrieves the next batch of results from the preceding call to this method. `page_token` must be the value of `next_page_token` from the previous response. The values of other method parameters must be identical to those in the previous call.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The container resource on which to execute the request. Acceptable formats: * `projects/[PROJECT_NUMBER]/locations/[LOCATION]/insightTypes/[INSIGHT_TYPE_ID]` * `projects/[PROJECT_ID]/locations/[LOCATION]/insightTypes/[INSIGHT_TYPE_ID]` * `billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION]/insightTypes/[INSIGHT_TYPE_ID]` * `folders/[FOLDER_ID]/locations/[LOCATION]/insightTypes/[INSIGHT_TYPE_ID]` * `organizations/[ORGANIZATION_ID]/locations/[LOCATION]/insightTypes/[INSIGHT_TYPE_ID]` LOCATION here refers to GCP Locations: https://cloud.google.com/about/locations/ INSIGHT_TYPE_ID refers to supported insight types: https://cloud.google.com/recommender/docs/insights/insight-types.",
	//       "location": "path",
	//       "pattern": "^billingAccounts/[^/]+/locations/[^/]+/insightTypes/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/insights",
	//   "response": {
	//     "$ref": "GoogleCloudRecommenderV1ListInsightsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *BillingAccountsLocationsInsightTypesInsightsListCall) Pages(ctx context.Context, f func(*GoogleCloudRecommenderV1ListInsightsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "recommender.billingAccounts.locations.insightTypes.insights.markAccepted":

type BillingAccountsLocationsInsightTypesInsightsMarkAcceptedCall struct {
	s                                                  *Service
	name                                               string
	googlecloudrecommenderv1markinsightacceptedrequest *GoogleCloudRecommenderV1MarkInsightAcceptedRequest
	urlParams_                                         gensupport.URLParams
	ctx_                                               context.Context
	header_                                            http.Header
}

// MarkAccepted: Marks the Insight State as Accepted. Users can use this
// method to indicate to the Recommender API that they have applied some
// action based on the insight. This stops the insight content from
// being updated. MarkInsightAccepted can be applied to insights in
// ACTIVE state. Requires the recommender.*.update IAM permission for
// the specified insight.
//
// - name: Name of the insight.
func (r *BillingAccountsLocationsInsightTypesInsightsService) MarkAccepted(name string, googlecloudrecommenderv1markinsightacceptedrequest *GoogleCloudRecommenderV1MarkInsightAcceptedRequest) *BillingAccountsLocationsInsightTypesInsightsMarkAcceptedCall {
	c := &BillingAccountsLocationsInsightTypesInsightsMarkAcceptedCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudrecommenderv1markinsightacceptedrequest = googlecloudrecommenderv1markinsightacceptedrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *BillingAccountsLocationsInsightTypesInsightsMarkAcceptedCall) Fields(s ...googleapi.Field) *BillingAccountsLocationsInsightTypesInsightsMarkAcceptedCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *BillingAccountsLocationsInsightTypesInsightsMarkAcceptedCall) Context(ctx context.Context) *BillingAccountsLocationsInsightTypesInsightsMarkAcceptedCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *BillingAccountsLocationsInsightTypesInsightsMarkAcceptedCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BillingAccountsLocationsInsightTypesInsightsMarkAcceptedCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211207")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudrecommenderv1markinsightacceptedrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:markAccepted")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "recommender.billingAccounts.locations.insightTypes.insights.markAccepted" call.
// Exactly one of *GoogleCloudRecommenderV1Insight or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleCloudRecommenderV1Insight.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *BillingAccountsLocationsInsightTypesInsightsMarkAcceptedCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRecommenderV1Insight, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudRecommenderV1Insight{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Marks the Insight State as Accepted. Users can use this method to indicate to the Recommender API that they have applied some action based on the insight. This stops the insight content from being updated. MarkInsightAccepted can be applied to insights in ACTIVE state. Requires the recommender.*.update IAM permission for the specified insight.",
	//   "flatPath": "v1/billingAccounts/{billingAccountsId}/locations/{locationsId}/insightTypes/{insightTypesId}/insights/{insightsId}:markAccepted",
	//   "httpMethod": "POST",
	//   "id": "recommender.billingAccounts.locations.insightTypes.insights.markAccepted",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Name of the insight.",
	//       "location": "path",
	//       "pattern": "^billingAccounts/[^/]+/locations/[^/]+/insightTypes/[^/]+/insights/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}:markAccepted",
	//   "request": {
	//     "$ref": "GoogleCloudRecommenderV1MarkInsightAcceptedRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudRecommenderV1Insight"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "recommender.billingAccounts.locations.recommenders.recommendations.get":

type BillingAccountsLocationsRecommendersRecommendationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the requested recommendation. Requires the
// recommender.*.get IAM permission for the specified recommender.
//
// - name: Name of the recommendation.
func (r *BillingAccountsLocationsRecommendersRecommendationsService) Get(name string) *BillingAccountsLocationsRecommendersRecommendationsGetCall {
	c := &BillingAccountsLocationsRecommendersRecommendationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *BillingAccountsLocationsRecommendersRecommendationsGetCall) Fields(s ...googleapi.Field) *BillingAccountsLocationsRecommendersRecommendationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *BillingAccountsLocationsRecommendersRecommendationsGetCall) IfNoneMatch(entityTag string) *BillingAccountsLocationsRecommendersRecommendationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *BillingAccountsLocationsRecommendersRecommendationsGetCall) Context(ctx context.Context) *BillingAccountsLocationsRecommendersRecommendationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *BillingAccountsLocationsRecommendersRecommendationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BillingAccountsLocationsRecommendersRecommendationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211207")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "recommender.billingAccounts.locations.recommenders.recommendations.get" call.
// Exactly one of *GoogleCloudRecommenderV1Recommendation or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleCloudRecommenderV1Recommendation.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *BillingAccountsLocationsRecommendersRecommendationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRecommenderV1Recommendation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudRecommenderV1Recommendation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the requested recommendation. Requires the recommender.*.get IAM permission for the specified recommender.",
	//   "flatPath": "v1/billingAccounts/{billingAccountsId}/locations/{locationsId}/recommenders/{recommendersId}/recommendations/{recommendationsId}",
	//   "httpMethod": "GET",
	//   "id": "recommender.billingAccounts.locations.recommenders.recommendations.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Name of the recommendation.",
	//       "location": "path",
	//       "pattern": "^billingAccounts/[^/]+/locations/[^/]+/recommenders/[^/]+/recommendations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudRecommenderV1Recommendation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "recommender.billingAccounts.locations.recommenders.recommendations.list":

type BillingAccountsLocationsRecommendersRecommendationsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists recommendations for the specified Cloud Resource.
// Requires the recommender.*.list IAM permission for the specified
// recommender.
//
// - parent: The container resource on which to execute the request.
//   Acceptable formats: *
//   `projects/[PROJECT_NUMBER]/locations/[LOCATION]/recommenders/[RECOMM
//   ENDER_ID]` *
//   `projects/[PROJECT_ID]/locations/[LOCATION]/recommenders/[RECOMMENDE
//   R_ID]` *
//   `billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION]/recommend
//   ers/[RECOMMENDER_ID]` *
//   `folders/[FOLDER_ID]/locations/[LOCATION]/recommenders/[RECOMMENDER_
//   ID]` *
//   `organizations/[ORGANIZATION_ID]/locations/[LOCATION]/recommenders/[
//   RECOMMENDER_ID]` LOCATION here refers to GCP Locations:
//   https://cloud.google.com/about/locations/ RECOMMENDER_ID refers to
//   supported recommenders:
//   https://cloud.google.com/recommender/docs/recommenders.
func (r *BillingAccountsLocationsRecommendersRecommendationsService) List(parent string) *BillingAccountsLocationsRecommendersRecommendationsListCall {
	c := &BillingAccountsLocationsRecommendersRecommendationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filter expression to
// restrict the recommendations returned. Supported filter fields: *
// `state_info.state` * `recommenderSubtype` * `priority` Examples: *
// `stateInfo.state = ACTIVE OR stateInfo.state = DISMISSED` *
// `recommenderSubtype = REMOVE_ROLE OR recommenderSubtype =
// REPLACE_ROLE` * `priority = P1 OR priority = P2` * `stateInfo.state =
// ACTIVE AND (priority = P1 OR priority = P2)` (These expressions are
// based on the filter language described at https://google.aip.dev/160)
func (c *BillingAccountsLocationsRecommendersRecommendationsListCall) Filter(filter string) *BillingAccountsLocationsRecommendersRecommendationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of results to return from this request. Non-positive values are
// ignored. If not specified, the server will determine the number of
// results to return.
func (c *BillingAccountsLocationsRecommendersRecommendationsListCall) PageSize(pageSize int64) *BillingAccountsLocationsRecommendersRecommendationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": If present,
// retrieves the next batch of results from the preceding call to this
// method. `page_token` must be the value of `next_page_token` from the
// previous response. The values of other method parameters must be
// identical to those in the previous call.
func (c *BillingAccountsLocationsRecommendersRecommendationsListCall) PageToken(pageToken string) *BillingAccountsLocationsRecommendersRecommendationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *BillingAccountsLocationsRecommendersRecommendationsListCall) Fields(s ...googleapi.Field) *BillingAccountsLocationsRecommendersRecommendationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *BillingAccountsLocationsRecommendersRecommendationsListCall) IfNoneMatch(entityTag string) *BillingAccountsLocationsRecommendersRecommendationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *BillingAccountsLocationsRecommendersRecommendationsListCall) Context(ctx context.Context) *BillingAccountsLocationsRecommendersRecommendationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *BillingAccountsLocationsRecommendersRecommendationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BillingAccountsLocationsRecommendersRecommendationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211207")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/recommendations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "recommender.billingAccounts.locations.recommenders.recommendations.list" call.
// Exactly one of *GoogleCloudRecommenderV1ListRecommendationsResponse
// or error will be non-nil. Any non-2xx status code is an error.
// Response headers are in either
// *GoogleCloudRecommenderV1ListRecommendationsResponse.ServerResponse.He
// ader or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *BillingAccountsLocationsRecommendersRecommendationsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRecommenderV1ListRecommendationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudRecommenderV1ListRecommendationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists recommendations for the specified Cloud Resource. Requires the recommender.*.list IAM permission for the specified recommender.",
	//   "flatPath": "v1/billingAccounts/{billingAccountsId}/locations/{locationsId}/recommenders/{recommendersId}/recommendations",
	//   "httpMethod": "GET",
	//   "id": "recommender.billingAccounts.locations.recommenders.recommendations.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "Filter expression to restrict the recommendations returned. Supported filter fields: * `state_info.state` * `recommenderSubtype` * `priority` Examples: * `stateInfo.state = ACTIVE OR stateInfo.state = DISMISSED` * `recommenderSubtype = REMOVE_ROLE OR recommenderSubtype = REPLACE_ROLE` * `priority = P1 OR priority = P2` * `stateInfo.state = ACTIVE AND (priority = P1 OR priority = P2)` (These expressions are based on the filter language described at https://google.aip.dev/160)",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "Optional. The maximum number of results to return from this request. Non-positive values are ignored. If not specified, the server will determine the number of results to return.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "Optional. If present, retrieves the next batch of results from the preceding call to this method. `page_token` must be the value of `next_page_token` from the previous response. The values of other method parameters must be identical to those in the previous call.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The container resource on which to execute the request. Acceptable formats: * `projects/[PROJECT_NUMBER]/locations/[LOCATION]/recommenders/[RECOMMENDER_ID]` * `projects/[PROJECT_ID]/locations/[LOCATION]/recommenders/[RECOMMENDER_ID]` * `billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION]/recommenders/[RECOMMENDER_ID]` * `folders/[FOLDER_ID]/locations/[LOCATION]/recommenders/[RECOMMENDER_ID]` * `organizations/[ORGANIZATION_ID]/locations/[LOCATION]/recommenders/[RECOMMENDER_ID]` LOCATION here refers to GCP Locations: https://cloud.google.com/about/locations/ RECOMMENDER_ID refers to supported recommenders: https://cloud.google.com/recommender/docs/recommenders.",
	//       "location": "path",
	//       "pattern": "^billingAccounts/[^/]+/locations/[^/]+/recommenders/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/recommendations",
	//   "response": {
	//     "$ref": "GoogleCloudRecommenderV1ListRecommendationsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *BillingAccountsLocationsRecommendersRecommendationsListCall) Pages(ctx context.Context, f func(*GoogleCloudRecommenderV1ListRecommendationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "recommender.billingAccounts.locations.recommenders.recommendations.markClaimed":

type BillingAccountsLocationsRecommendersRecommendationsMarkClaimedCall struct {
	s                                                        *Service
	name                                                     string
	googlecloudrecommenderv1markrecommendationclaimedrequest *GoogleCloudRecommenderV1MarkRecommendationClaimedRequest
	urlParams_                                               gensupport.URLParams
	ctx_                                                     context.Context
	header_                                                  http.Header
}

// MarkClaimed: Marks the Recommendation State as Claimed. Users can use
// this method to indicate to the Recommender API that they are starting
// to apply the recommendation themselves. This stops the recommendation
// content from being updated. Associated insights are frozen and placed
// in the ACCEPTED state. MarkRecommendationClaimed can be applied to
// recommendations in CLAIMED, SUCCEEDED, FAILED, or ACTIVE state.
// Requires the recommender.*.update IAM permission for the specified
// recommender.
//
// - name: Name of the recommendation.
func (r *BillingAccountsLocationsRecommendersRecommendationsService) MarkClaimed(name string, googlecloudrecommenderv1markrecommendationclaimedrequest *GoogleCloudRecommenderV1MarkRecommendationClaimedRequest) *BillingAccountsLocationsRecommendersRecommendationsMarkClaimedCall {
	c := &BillingAccountsLocationsRecommendersRecommendationsMarkClaimedCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudrecommenderv1markrecommendationclaimedrequest = googlecloudrecommenderv1markrecommendationclaimedrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *BillingAccountsLocationsRecommendersRecommendationsMarkClaimedCall) Fields(s ...googleapi.Field) *BillingAccountsLocationsRecommendersRecommendationsMarkClaimedCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *BillingAccountsLocationsRecommendersRecommendationsMarkClaimedCall) Context(ctx context.Context) *BillingAccountsLocationsRecommendersRecommendationsMarkClaimedCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *BillingAccountsLocationsRecommendersRecommendationsMarkClaimedCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BillingAccountsLocationsRecommendersRecommendationsMarkClaimedCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211207")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudrecommenderv1markrecommendationclaimedrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:markClaimed")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "recommender.billingAccounts.locations.recommenders.recommendations.markClaimed" call.
// Exactly one of *GoogleCloudRecommenderV1Recommendation or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleCloudRecommenderV1Recommendation.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *BillingAccountsLocationsRecommendersRecommendationsMarkClaimedCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRecommenderV1Recommendation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudRecommenderV1Recommendation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Marks the Recommendation State as Claimed. Users can use this method to indicate to the Recommender API that they are starting to apply the recommendation themselves. This stops the recommendation content from being updated. Associated insights are frozen and placed in the ACCEPTED state. MarkRecommendationClaimed can be applied to recommendations in CLAIMED, SUCCEEDED, FAILED, or ACTIVE state. Requires the recommender.*.update IAM permission for the specified recommender.",
	//   "flatPath": "v1/billingAccounts/{billingAccountsId}/locations/{locationsId}/recommenders/{recommendersId}/recommendations/{recommendationsId}:markClaimed",
	//   "httpMethod": "POST",
	//   "id": "recommender.billingAccounts.locations.recommenders.recommendations.markClaimed",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Name of the recommendation.",
	//       "location": "path",
	//       "pattern": "^billingAccounts/[^/]+/locations/[^/]+/recommenders/[^/]+/recommendations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}:markClaimed",
	//   "request": {
	//     "$ref": "GoogleCloudRecommenderV1MarkRecommendationClaimedRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudRecommenderV1Recommendation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "recommender.billingAccounts.locations.recommenders.recommendations.markFailed":

type BillingAccountsLocationsRecommendersRecommendationsMarkFailedCall struct {
	s                                                       *Service
	name                                                    string
	googlecloudrecommenderv1markrecommendationfailedrequest *GoogleCloudRecommenderV1MarkRecommendationFailedRequest
	urlParams_                                              gensupport.URLParams
	ctx_                                                    context.Context
	header_                                                 http.Header
}

// MarkFailed: Marks the Recommendation State as Failed. Users can use
// this method to indicate to the Recommender API that they have applied
// the recommendation themselves, and the operation failed. This stops
// the recommendation content from being updated. Associated insights
// are frozen and placed in the ACCEPTED state. MarkRecommendationFailed
// can be applied to recommendations in ACTIVE, CLAIMED, SUCCEEDED, or
// FAILED state. Requires the recommender.*.update IAM permission for
// the specified recommender.
//
// - name: Name of the recommendation.
func (r *BillingAccountsLocationsRecommendersRecommendationsService) MarkFailed(name string, googlecloudrecommenderv1markrecommendationfailedrequest *GoogleCloudRecommenderV1MarkRecommendationFailedRequest) *BillingAccountsLocationsRecommendersRecommendationsMarkFailedCall {
	c := &BillingAccountsLocationsRecommendersRecommendationsMarkFailedCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudrecommenderv1markrecommendationfailedrequest = googlecloudrecommenderv1markrecommendationfailedrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *BillingAccountsLocationsRecommendersRecommendationsMarkFailedCall) Fields(s ...googleapi.Field) *BillingAccountsLocationsRecommendersRecommendationsMarkFailedCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *BillingAccountsLocationsRecommendersRecommendationsMarkFailedCall) Context(ctx context.Context) *BillingAccountsLocationsRecommendersRecommendationsMarkFailedCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *BillingAccountsLocationsRecommendersRecommendationsMarkFailedCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BillingAccountsLocationsRecommendersRecommendationsMarkFailedCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211207")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudrecommenderv1markrecommendationfailedrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:markFailed")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "recommender.billingAccounts.locations.recommenders.recommendations.markFailed" call.
// Exactly one of *GoogleCloudRecommenderV1Recommendation or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleCloudRecommenderV1Recommendation.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *BillingAccountsLocationsRecommendersRecommendationsMarkFailedCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRecommenderV1Recommendation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudRecommenderV1Recommendation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Marks the Recommendation State as Failed. Users can use this method to indicate to the Recommender API that they have applied the recommendation themselves, and the operation failed. This stops the recommendation content from being updated. Associated insights are frozen and placed in the ACCEPTED state. MarkRecommendationFailed can be applied to recommendations in ACTIVE, CLAIMED, SUCCEEDED, or FAILED state. Requires the recommender.*.update IAM permission for the specified recommender.",
	//   "flatPath": "v1/billingAccounts/{billingAccountsId}/locations/{locationsId}/recommenders/{recommendersId}/recommendations/{recommendationsId}:markFailed",
	//   "httpMethod": "POST",
	//   "id": "recommender.billingAccounts.locations.recommenders.recommendations.markFailed",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Name of the recommendation.",
	//       "location": "path",
	//       "pattern": "^billingAccounts/[^/]+/locations/[^/]+/recommenders/[^/]+/recommendations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}:markFailed",
	//   "request": {
	//     "$ref": "GoogleCloudRecommenderV1MarkRecommendationFailedRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudRecommenderV1Recommendation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "recommender.billingAccounts.locations.recommenders.recommendations.markSucceeded":

type BillingAccountsLocationsRecommendersRecommendationsMarkSucceededCall struct {
	s                                                          *Service
	name                                                       string
	googlecloudrecommenderv1markrecommendationsucceededrequest *GoogleCloudRecommenderV1MarkRecommendationSucceededRequest
	urlParams_                                                 gensupport.URLParams
	ctx_                                                       context.Context
	header_                                                    http.Header
}

// MarkSucceeded: Marks the Recommendation State as Succeeded. Users can
// use this method to indicate to the Recommender API that they have
// applied the recommendation themselves, and the operation was
// successful. This stops the recommendation content from being updated.
// Associated insights are frozen and placed in the ACCEPTED state.
// MarkRecommendationSucceeded can be applied to recommendations in
// ACTIVE, CLAIMED, SUCCEEDED, or FAILED state. Requires the
// recommender.*.update IAM permission for the specified recommender.
//
// - name: Name of the recommendation.
func (r *BillingAccountsLocationsRecommendersRecommendationsService) MarkSucceeded(name string, googlecloudrecommenderv1markrecommendationsucceededrequest *GoogleCloudRecommenderV1MarkRecommendationSucceededRequest) *BillingAccountsLocationsRecommendersRecommendationsMarkSucceededCall {
	c := &BillingAccountsLocationsRecommendersRecommendationsMarkSucceededCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudrecommenderv1markrecommendationsucceededrequest = googlecloudrecommenderv1markrecommendationsucceededrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *BillingAccountsLocationsRecommendersRecommendationsMarkSucceededCall) Fields(s ...googleapi.Field) *BillingAccountsLocationsRecommendersRecommendationsMarkSucceededCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *BillingAccountsLocationsRecommendersRecommendationsMarkSucceededCall) Context(ctx context.Context) *BillingAccountsLocationsRecommendersRecommendationsMarkSucceededCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *BillingAccountsLocationsRecommendersRecommendationsMarkSucceededCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BillingAccountsLocationsRecommendersRecommendationsMarkSucceededCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211207")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudrecommenderv1markrecommendationsucceededrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:markSucceeded")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "recommender.billingAccounts.locations.recommenders.recommendations.markSucceeded" call.
// Exactly one of *GoogleCloudRecommenderV1Recommendation or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleCloudRecommenderV1Recommendation.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *BillingAccountsLocationsRecommendersRecommendationsMarkSucceededCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRecommenderV1Recommendation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudRecommenderV1Recommendation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Marks the Recommendation State as Succeeded. Users can use this method to indicate to the Recommender API that they have applied the recommendation themselves, and the operation was successful. This stops the recommendation content from being updated. Associated insights are frozen and placed in the ACCEPTED state. MarkRecommendationSucceeded can be applied to recommendations in ACTIVE, CLAIMED, SUCCEEDED, or FAILED state. Requires the recommender.*.update IAM permission for the specified recommender.",
	//   "flatPath": "v1/billingAccounts/{billingAccountsId}/locations/{locationsId}/recommenders/{recommendersId}/recommendations/{recommendationsId}:markSucceeded",
	//   "httpMethod": "POST",
	//   "id": "recommender.billingAccounts.locations.recommenders.recommendations.markSucceeded",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Name of the recommendation.",
	//       "location": "path",
	//       "pattern": "^billingAccounts/[^/]+/locations/[^/]+/recommenders/[^/]+/recommendations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}:markSucceeded",
	//   "request": {
	//     "$ref": "GoogleCloudRecommenderV1MarkRecommendationSucceededRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudRecommenderV1Recommendation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "recommender.folders.locations.insightTypes.insights.get":

type FoldersLocationsInsightTypesInsightsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the requested insight. Requires the recommender.*.get IAM
// permission for the specified insight type.
//
// - name: Name of the insight.
func (r *FoldersLocationsInsightTypesInsightsService) Get(name string) *FoldersLocationsInsightTypesInsightsGetCall {
	c := &FoldersLocationsInsightTypesInsightsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FoldersLocationsInsightTypesInsightsGetCall) Fields(s ...googleapi.Field) *FoldersLocationsInsightTypesInsightsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *FoldersLocationsInsightTypesInsightsGetCall) IfNoneMatch(entityTag string) *FoldersLocationsInsightTypesInsightsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FoldersLocationsInsightTypesInsightsGetCall) Context(ctx context.Context) *FoldersLocationsInsightTypesInsightsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FoldersLocationsInsightTypesInsightsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersLocationsInsightTypesInsightsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211207")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "recommender.folders.locations.insightTypes.insights.get" call.
// Exactly one of *GoogleCloudRecommenderV1Insight or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleCloudRecommenderV1Insight.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *FoldersLocationsInsightTypesInsightsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRecommenderV1Insight, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudRecommenderV1Insight{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the requested insight. Requires the recommender.*.get IAM permission for the specified insight type.",
	//   "flatPath": "v1/folders/{foldersId}/locations/{locationsId}/insightTypes/{insightTypesId}/insights/{insightsId}",
	//   "httpMethod": "GET",
	//   "id": "recommender.folders.locations.insightTypes.insights.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Name of the insight.",
	//       "location": "path",
	//       "pattern": "^folders/[^/]+/locations/[^/]+/insightTypes/[^/]+/insights/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudRecommenderV1Insight"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "recommender.folders.locations.insightTypes.insights.list":

type FoldersLocationsInsightTypesInsightsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists insights for the specified Cloud Resource. Requires the
// recommender.*.list IAM permission for the specified insight type.
//
// - parent: The container resource on which to execute the request.
//   Acceptable formats: *
//   `projects/[PROJECT_NUMBER]/locations/[LOCATION]/insightTypes/[INSIGH
//   T_TYPE_ID]` *
//   `projects/[PROJECT_ID]/locations/[LOCATION]/insightTypes/[INSIGHT_TY
//   PE_ID]` *
//   `billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION]/insightTy
//   pes/[INSIGHT_TYPE_ID]` *
//   `folders/[FOLDER_ID]/locations/[LOCATION]/insightTypes/[INSIGHT_TYPE
//   _ID]` *
//   `organizations/[ORGANIZATION_ID]/locations/[LOCATION]/insightTypes/[
//   INSIGHT_TYPE_ID]` LOCATION here refers to GCP Locations:
//   https://cloud.google.com/about/locations/ INSIGHT_TYPE_ID refers to
//   supported insight types:
//   https://cloud.google.com/recommender/docs/insights/insight-types.
func (r *FoldersLocationsInsightTypesInsightsService) List(parent string) *FoldersLocationsInsightTypesInsightsListCall {
	c := &FoldersLocationsInsightTypesInsightsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filter expression to
// restrict the insights returned. Supported filter fields: *
// `stateInfo.state` * `insightSubtype` * `severity` Examples: *
// `stateInfo.state = ACTIVE OR stateInfo.state = DISMISSED` *
// `insightSubtype = PERMISSIONS_USAGE` * `severity = CRITICAL OR
// severity = HIGH` * `stateInfo.state = ACTIVE AND (severity = CRITICAL
// OR severity = HIGH)` (These expressions are based on the filter
// language described at https://google.aip.dev/160)
func (c *FoldersLocationsInsightTypesInsightsListCall) Filter(filter string) *FoldersLocationsInsightTypesInsightsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of results to return from this request. Non-positive values are
// ignored. If not specified, the server will determine the number of
// results to return.
func (c *FoldersLocationsInsightTypesInsightsListCall) PageSize(pageSize int64) *FoldersLocationsInsightTypesInsightsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": If present,
// retrieves the next batch of results from the preceding call to this
// method. `page_token` must be the value of `next_page_token` from the
// previous response. The values of other method parameters must be
// identical to those in the previous call.
func (c *FoldersLocationsInsightTypesInsightsListCall) PageToken(pageToken string) *FoldersLocationsInsightTypesInsightsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FoldersLocationsInsightTypesInsightsListCall) Fields(s ...googleapi.Field) *FoldersLocationsInsightTypesInsightsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *FoldersLocationsInsightTypesInsightsListCall) IfNoneMatch(entityTag string) *FoldersLocationsInsightTypesInsightsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FoldersLocationsInsightTypesInsightsListCall) Context(ctx context.Context) *FoldersLocationsInsightTypesInsightsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FoldersLocationsInsightTypesInsightsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersLocationsInsightTypesInsightsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211207")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/insights")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "recommender.folders.locations.insightTypes.insights.list" call.
// Exactly one of *GoogleCloudRecommenderV1ListInsightsResponse or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudRecommenderV1ListInsightsResponse.ServerResponse.Header
// or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *FoldersLocationsInsightTypesInsightsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRecommenderV1ListInsightsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudRecommenderV1ListInsightsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists insights for the specified Cloud Resource. Requires the recommender.*.list IAM permission for the specified insight type.",
	//   "flatPath": "v1/folders/{foldersId}/locations/{locationsId}/insightTypes/{insightTypesId}/insights",
	//   "httpMethod": "GET",
	//   "id": "recommender.folders.locations.insightTypes.insights.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "Optional. Filter expression to restrict the insights returned. Supported filter fields: * `stateInfo.state` * `insightSubtype` * `severity` Examples: * `stateInfo.state = ACTIVE OR stateInfo.state = DISMISSED` * `insightSubtype = PERMISSIONS_USAGE` * `severity = CRITICAL OR severity = HIGH` * `stateInfo.state = ACTIVE AND (severity = CRITICAL OR severity = HIGH)` (These expressions are based on the filter language described at https://google.aip.dev/160)",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "Optional. The maximum number of results to return from this request. Non-positive values are ignored. If not specified, the server will determine the number of results to return.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "Optional. If present, retrieves the next batch of results from the preceding call to this method. `page_token` must be the value of `next_page_token` from the previous response. The values of other method parameters must be identical to those in the previous call.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The container resource on which to execute the request. Acceptable formats: * `projects/[PROJECT_NUMBER]/locations/[LOCATION]/insightTypes/[INSIGHT_TYPE_ID]` * `projects/[PROJECT_ID]/locations/[LOCATION]/insightTypes/[INSIGHT_TYPE_ID]` * `billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION]/insightTypes/[INSIGHT_TYPE_ID]` * `folders/[FOLDER_ID]/locations/[LOCATION]/insightTypes/[INSIGHT_TYPE_ID]` * `organizations/[ORGANIZATION_ID]/locations/[LOCATION]/insightTypes/[INSIGHT_TYPE_ID]` LOCATION here refers to GCP Locations: https://cloud.google.com/about/locations/ INSIGHT_TYPE_ID refers to supported insight types: https://cloud.google.com/recommender/docs/insights/insight-types.",
	//       "location": "path",
	//       "pattern": "^folders/[^/]+/locations/[^/]+/insightTypes/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/insights",
	//   "response": {
	//     "$ref": "GoogleCloudRecommenderV1ListInsightsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *FoldersLocationsInsightTypesInsightsListCall) Pages(ctx context.Context, f func(*GoogleCloudRecommenderV1ListInsightsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "recommender.folders.locations.insightTypes.insights.markAccepted":

type FoldersLocationsInsightTypesInsightsMarkAcceptedCall struct {
	s                                                  *Service
	name                                               string
	googlecloudrecommenderv1markinsightacceptedrequest *GoogleCloudRecommenderV1MarkInsightAcceptedRequest
	urlParams_                                         gensupport.URLParams
	ctx_                                               context.Context
	header_                                            http.Header
}

// MarkAccepted: Marks the Insight State as Accepted. Users can use this
// method to indicate to the Recommender API that they have applied some
// action based on the insight. This stops the insight content from
// being updated. MarkInsightAccepted can be applied to insights in
// ACTIVE state. Requires the recommender.*.update IAM permission for
// the specified insight.
//
// - name: Name of the insight.
func (r *FoldersLocationsInsightTypesInsightsService) MarkAccepted(name string, googlecloudrecommenderv1markinsightacceptedrequest *GoogleCloudRecommenderV1MarkInsightAcceptedRequest) *FoldersLocationsInsightTypesInsightsMarkAcceptedCall {
	c := &FoldersLocationsInsightTypesInsightsMarkAcceptedCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudrecommenderv1markinsightacceptedrequest = googlecloudrecommenderv1markinsightacceptedrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FoldersLocationsInsightTypesInsightsMarkAcceptedCall) Fields(s ...googleapi.Field) *FoldersLocationsInsightTypesInsightsMarkAcceptedCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FoldersLocationsInsightTypesInsightsMarkAcceptedCall) Context(ctx context.Context) *FoldersLocationsInsightTypesInsightsMarkAcceptedCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FoldersLocationsInsightTypesInsightsMarkAcceptedCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersLocationsInsightTypesInsightsMarkAcceptedCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211207")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudrecommenderv1markinsightacceptedrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:markAccepted")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "recommender.folders.locations.insightTypes.insights.markAccepted" call.
// Exactly one of *GoogleCloudRecommenderV1Insight or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleCloudRecommenderV1Insight.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *FoldersLocationsInsightTypesInsightsMarkAcceptedCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRecommenderV1Insight, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudRecommenderV1Insight{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Marks the Insight State as Accepted. Users can use this method to indicate to the Recommender API that they have applied some action based on the insight. This stops the insight content from being updated. MarkInsightAccepted can be applied to insights in ACTIVE state. Requires the recommender.*.update IAM permission for the specified insight.",
	//   "flatPath": "v1/folders/{foldersId}/locations/{locationsId}/insightTypes/{insightTypesId}/insights/{insightsId}:markAccepted",
	//   "httpMethod": "POST",
	//   "id": "recommender.folders.locations.insightTypes.insights.markAccepted",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Name of the insight.",
	//       "location": "path",
	//       "pattern": "^folders/[^/]+/locations/[^/]+/insightTypes/[^/]+/insights/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}:markAccepted",
	//   "request": {
	//     "$ref": "GoogleCloudRecommenderV1MarkInsightAcceptedRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudRecommenderV1Insight"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "recommender.folders.locations.recommenders.recommendations.get":

type FoldersLocationsRecommendersRecommendationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the requested recommendation. Requires the
// recommender.*.get IAM permission for the specified recommender.
//
// - name: Name of the recommendation.
func (r *FoldersLocationsRecommendersRecommendationsService) Get(name string) *FoldersLocationsRecommendersRecommendationsGetCall {
	c := &FoldersLocationsRecommendersRecommendationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FoldersLocationsRecommendersRecommendationsGetCall) Fields(s ...googleapi.Field) *FoldersLocationsRecommendersRecommendationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *FoldersLocationsRecommendersRecommendationsGetCall) IfNoneMatch(entityTag string) *FoldersLocationsRecommendersRecommendationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FoldersLocationsRecommendersRecommendationsGetCall) Context(ctx context.Context) *FoldersLocationsRecommendersRecommendationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FoldersLocationsRecommendersRecommendationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersLocationsRecommendersRecommendationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211207")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "recommender.folders.locations.recommenders.recommendations.get" call.
// Exactly one of *GoogleCloudRecommenderV1Recommendation or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleCloudRecommenderV1Recommendation.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *FoldersLocationsRecommendersRecommendationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRecommenderV1Recommendation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudRecommenderV1Recommendation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the requested recommendation. Requires the recommender.*.get IAM permission for the specified recommender.",
	//   "flatPath": "v1/folders/{foldersId}/locations/{locationsId}/recommenders/{recommendersId}/recommendations/{recommendationsId}",
	//   "httpMethod": "GET",
	//   "id": "recommender.folders.locations.recommenders.recommendations.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Name of the recommendation.",
	//       "location": "path",
	//       "pattern": "^folders/[^/]+/locations/[^/]+/recommenders/[^/]+/recommendations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudRecommenderV1Recommendation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "recommender.folders.locations.recommenders.recommendations.list":

type FoldersLocationsRecommendersRecommendationsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists recommendations for the specified Cloud Resource.
// Requires the recommender.*.list IAM permission for the specified
// recommender.
//
// - parent: The container resource on which to execute the request.
//   Acceptable formats: *
//   `projects/[PROJECT_NUMBER]/locations/[LOCATION]/recommenders/[RECOMM
//   ENDER_ID]` *
//   `projects/[PROJECT_ID]/locations/[LOCATION]/recommenders/[RECOMMENDE
//   R_ID]` *
//   `billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION]/recommend
//   ers/[RECOMMENDER_ID]` *
//   `folders/[FOLDER_ID]/locations/[LOCATION]/recommenders/[RECOMMENDER_
//   ID]` *
//   `organizations/[ORGANIZATION_ID]/locations/[LOCATION]/recommenders/[
//   RECOMMENDER_ID]` LOCATION here refers to GCP Locations:
//   https://cloud.google.com/about/locations/ RECOMMENDER_ID refers to
//   supported recommenders:
//   https://cloud.google.com/recommender/docs/recommenders.
func (r *FoldersLocationsRecommendersRecommendationsService) List(parent string) *FoldersLocationsRecommendersRecommendationsListCall {
	c := &FoldersLocationsRecommendersRecommendationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filter expression to
// restrict the recommendations returned. Supported filter fields: *
// `state_info.state` * `recommenderSubtype` * `priority` Examples: *
// `stateInfo.state = ACTIVE OR stateInfo.state = DISMISSED` *
// `recommenderSubtype = REMOVE_ROLE OR recommenderSubtype =
// REPLACE_ROLE` * `priority = P1 OR priority = P2` * `stateInfo.state =
// ACTIVE AND (priority = P1 OR priority = P2)` (These expressions are
// based on the filter language described at https://google.aip.dev/160)
func (c *FoldersLocationsRecommendersRecommendationsListCall) Filter(filter string) *FoldersLocationsRecommendersRecommendationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of results to return from this request. Non-positive values are
// ignored. If not specified, the server will determine the number of
// results to return.
func (c *FoldersLocationsRecommendersRecommendationsListCall) PageSize(pageSize int64) *FoldersLocationsRecommendersRecommendationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": If present,
// retrieves the next batch of results from the preceding call to this
// method. `page_token` must be the value of `next_page_token` from the
// previous response. The values of other method parameters must be
// identical to those in the previous call.
func (c *FoldersLocationsRecommendersRecommendationsListCall) PageToken(pageToken string) *FoldersLocationsRecommendersRecommendationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FoldersLocationsRecommendersRecommendationsListCall) Fields(s ...googleapi.Field) *FoldersLocationsRecommendersRecommendationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *FoldersLocationsRecommendersRecommendationsListCall) IfNoneMatch(entityTag string) *FoldersLocationsRecommendersRecommendationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FoldersLocationsRecommendersRecommendationsListCall) Context(ctx context.Context) *FoldersLocationsRecommendersRecommendationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FoldersLocationsRecommendersRecommendationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersLocationsRecommendersRecommendationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211207")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/recommendations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "recommender.folders.locations.recommenders.recommendations.list" call.
// Exactly one of *GoogleCloudRecommenderV1ListRecommendationsResponse
// or error will be non-nil. Any non-2xx status code is an error.
// Response headers are in either
// *GoogleCloudRecommenderV1ListRecommendationsResponse.ServerResponse.He
// ader or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *FoldersLocationsRecommendersRecommendationsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRecommenderV1ListRecommendationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudRecommenderV1ListRecommendationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists recommendations for the specified Cloud Resource. Requires the recommender.*.list IAM permission for the specified recommender.",
	//   "flatPath": "v1/folders/{foldersId}/locations/{locationsId}/recommenders/{recommendersId}/recommendations",
	//   "httpMethod": "GET",
	//   "id": "recommender.folders.locations.recommenders.recommendations.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "Filter expression to restrict the recommendations returned. Supported filter fields: * `state_info.state` * `recommenderSubtype` * `priority` Examples: * `stateInfo.state = ACTIVE OR stateInfo.state = DISMISSED` * `recommenderSubtype = REMOVE_ROLE OR recommenderSubtype = REPLACE_ROLE` * `priority = P1 OR priority = P2` * `stateInfo.state = ACTIVE AND (priority = P1 OR priority = P2)` (These expressions are based on the filter language described at https://google.aip.dev/160)",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "Optional. The maximum number of results to return from this request. Non-positive values are ignored. If not specified, the server will determine the number of results to return.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "Optional. If present, retrieves the next batch of results from the preceding call to this method. `page_token` must be the value of `next_page_token` from the previous response. The values of other method parameters must be identical to those in the previous call.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The container resource on which to execute the request. Acceptable formats: * `projects/[PROJECT_NUMBER]/locations/[LOCATION]/recommenders/[RECOMMENDER_ID]` * `projects/[PROJECT_ID]/locations/[LOCATION]/recommenders/[RECOMMENDER_ID]` * `billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION]/recommenders/[RECOMMENDER_ID]` * `folders/[FOLDER_ID]/locations/[LOCATION]/recommenders/[RECOMMENDER_ID]` * `organizations/[ORGANIZATION_ID]/locations/[LOCATION]/recommenders/[RECOMMENDER_ID]` LOCATION here refers to GCP Locations: https://cloud.google.com/about/locations/ RECOMMENDER_ID refers to supported recommenders: https://cloud.google.com/recommender/docs/recommenders.",
	//       "location": "path",
	//       "pattern": "^folders/[^/]+/locations/[^/]+/recommenders/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/recommendations",
	//   "response": {
	//     "$ref": "GoogleCloudRecommenderV1ListRecommendationsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *FoldersLocationsRecommendersRecommendationsListCall) Pages(ctx context.Context, f func(*GoogleCloudRecommenderV1ListRecommendationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "recommender.folders.locations.recommenders.recommendations.markClaimed":

type FoldersLocationsRecommendersRecommendationsMarkClaimedCall struct {
	s                                                        *Service
	name                                                     string
	googlecloudrecommenderv1markrecommendationclaimedrequest *GoogleCloudRecommenderV1MarkRecommendationClaimedRequest
	urlParams_                                               gensupport.URLParams
	ctx_                                                     context.Context
	header_                                                  http.Header
}

// MarkClaimed: Marks the Recommendation State as Claimed. Users can use
// this method to indicate to the Recommender API that they are starting
// to apply the recommendation themselves. This stops the recommendation
// content from being updated. Associated insights are frozen and placed
// in the ACCEPTED state. MarkRecommendationClaimed can be applied to
// recommendations in CLAIMED, SUCCEEDED, FAILED, or ACTIVE state.
// Requires the recommender.*.update IAM permission for the specified
// recommender.
//
// - name: Name of the recommendation.
func (r *FoldersLocationsRecommendersRecommendationsService) MarkClaimed(name string, googlecloudrecommenderv1markrecommendationclaimedrequest *GoogleCloudRecommenderV1MarkRecommendationClaimedRequest) *FoldersLocationsRecommendersRecommendationsMarkClaimedCall {
	c := &FoldersLocationsRecommendersRecommendationsMarkClaimedCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudrecommenderv1markrecommendationclaimedrequest = googlecloudrecommenderv1markrecommendationclaimedrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FoldersLocationsRecommendersRecommendationsMarkClaimedCall) Fields(s ...googleapi.Field) *FoldersLocationsRecommendersRecommendationsMarkClaimedCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FoldersLocationsRecommendersRecommendationsMarkClaimedCall) Context(ctx context.Context) *FoldersLocationsRecommendersRecommendationsMarkClaimedCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FoldersLocationsRecommendersRecommendationsMarkClaimedCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersLocationsRecommendersRecommendationsMarkClaimedCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211207")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudrecommenderv1markrecommendationclaimedrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:markClaimed")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "recommender.folders.locations.recommenders.recommendations.markClaimed" call.
// Exactly one of *GoogleCloudRecommenderV1Recommendation or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleCloudRecommenderV1Recommendation.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *FoldersLocationsRecommendersRecommendationsMarkClaimedCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRecommenderV1Recommendation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudRecommenderV1Recommendation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Marks the Recommendation State as Claimed. Users can use this method to indicate to the Recommender API that they are starting to apply the recommendation themselves. This stops the recommendation content from being updated. Associated insights are frozen and placed in the ACCEPTED state. MarkRecommendationClaimed can be applied to recommendations in CLAIMED, SUCCEEDED, FAILED, or ACTIVE state. Requires the recommender.*.update IAM permission for the specified recommender.",
	//   "flatPath": "v1/folders/{foldersId}/locations/{locationsId}/recommenders/{recommendersId}/recommendations/{recommendationsId}:markClaimed",
	//   "httpMethod": "POST",
	//   "id": "recommender.folders.locations.recommenders.recommendations.markClaimed",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Name of the recommendation.",
	//       "location": "path",
	//       "pattern": "^folders/[^/]+/locations/[^/]+/recommenders/[^/]+/recommendations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}:markClaimed",
	//   "request": {
	//     "$ref": "GoogleCloudRecommenderV1MarkRecommendationClaimedRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudRecommenderV1Recommendation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "recommender.folders.locations.recommenders.recommendations.markFailed":

type FoldersLocationsRecommendersRecommendationsMarkFailedCall struct {
	s                                                       *Service
	name                                                    string
	googlecloudrecommenderv1markrecommendationfailedrequest *GoogleCloudRecommenderV1MarkRecommendationFailedRequest
	urlParams_                                              gensupport.URLParams
	ctx_                                                    context.Context
	header_                                                 http.Header
}

// MarkFailed: Marks the Recommendation State as Failed. Users can use
// this method to indicate to the Recommender API that they have applied
// the recommendation themselves, and the operation failed. This stops
// the recommendation content from being updated. Associated insights
// are frozen and placed in the ACCEPTED state. MarkRecommendationFailed
// can be applied to recommendations in ACTIVE, CLAIMED, SUCCEEDED, or
// FAILED state. Requires the recommender.*.update IAM permission for
// the specified recommender.
//
// - name: Name of the recommendation.
func (r *FoldersLocationsRecommendersRecommendationsService) MarkFailed(name string, googlecloudrecommenderv1markrecommendationfailedrequest *GoogleCloudRecommenderV1MarkRecommendationFailedRequest) *FoldersLocationsRecommendersRecommendationsMarkFailedCall {
	c := &FoldersLocationsRecommendersRecommendationsMarkFailedCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudrecommenderv1markrecommendationfailedrequest = googlecloudrecommenderv1markrecommendationfailedrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FoldersLocationsRecommendersRecommendationsMarkFailedCall) Fields(s ...googleapi.Field) *FoldersLocationsRecommendersRecommendationsMarkFailedCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FoldersLocationsRecommendersRecommendationsMarkFailedCall) Context(ctx context.Context) *FoldersLocationsRecommendersRecommendationsMarkFailedCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FoldersLocationsRecommendersRecommendationsMarkFailedCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersLocationsRecommendersRecommendationsMarkFailedCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211207")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudrecommenderv1markrecommendationfailedrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:markFailed")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "recommender.folders.locations.recommenders.recommendations.markFailed" call.
// Exactly one of *GoogleCloudRecommenderV1Recommendation or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleCloudRecommenderV1Recommendation.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *FoldersLocationsRecommendersRecommendationsMarkFailedCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRecommenderV1Recommendation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudRecommenderV1Recommendation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Marks the Recommendation State as Failed. Users can use this method to indicate to the Recommender API that they have applied the recommendation themselves, and the operation failed. This stops the recommendation content from being updated. Associated insights are frozen and placed in the ACCEPTED state. MarkRecommendationFailed can be applied to recommendations in ACTIVE, CLAIMED, SUCCEEDED, or FAILED state. Requires the recommender.*.update IAM permission for the specified recommender.",
	//   "flatPath": "v1/folders/{foldersId}/locations/{locationsId}/recommenders/{recommendersId}/recommendations/{recommendationsId}:markFailed",
	//   "httpMethod": "POST",
	//   "id": "recommender.folders.locations.recommenders.recommendations.markFailed",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Name of the recommendation.",
	//       "location": "path",
	//       "pattern": "^folders/[^/]+/locations/[^/]+/recommenders/[^/]+/recommendations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}:markFailed",
	//   "request": {
	//     "$ref": "GoogleCloudRecommenderV1MarkRecommendationFailedRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudRecommenderV1Recommendation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "recommender.folders.locations.recommenders.recommendations.markSucceeded":

type FoldersLocationsRecommendersRecommendationsMarkSucceededCall struct {
	s                                                          *Service
	name                                                       string
	googlecloudrecommenderv1markrecommendationsucceededrequest *GoogleCloudRecommenderV1MarkRecommendationSucceededRequest
	urlParams_                                                 gensupport.URLParams
	ctx_                                                       context.Context
	header_                                                    http.Header
}

// MarkSucceeded: Marks the Recommendation State as Succeeded. Users can
// use this method to indicate to the Recommender API that they have
// applied the recommendation themselves, and the operation was
// successful. This stops the recommendation content from being updated.
// Associated insights are frozen and placed in the ACCEPTED state.
// MarkRecommendationSucceeded can be applied to recommendations in
// ACTIVE, CLAIMED, SUCCEEDED, or FAILED state. Requires the
// recommender.*.update IAM permission for the specified recommender.
//
// - name: Name of the recommendation.
func (r *FoldersLocationsRecommendersRecommendationsService) MarkSucceeded(name string, googlecloudrecommenderv1markrecommendationsucceededrequest *GoogleCloudRecommenderV1MarkRecommendationSucceededRequest) *FoldersLocationsRecommendersRecommendationsMarkSucceededCall {
	c := &FoldersLocationsRecommendersRecommendationsMarkSucceededCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudrecommenderv1markrecommendationsucceededrequest = googlecloudrecommenderv1markrecommendationsucceededrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FoldersLocationsRecommendersRecommendationsMarkSucceededCall) Fields(s ...googleapi.Field) *FoldersLocationsRecommendersRecommendationsMarkSucceededCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FoldersLocationsRecommendersRecommendationsMarkSucceededCall) Context(ctx context.Context) *FoldersLocationsRecommendersRecommendationsMarkSucceededCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FoldersLocationsRecommendersRecommendationsMarkSucceededCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersLocationsRecommendersRecommendationsMarkSucceededCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211207")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudrecommenderv1markrecommendationsucceededrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:markSucceeded")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "recommender.folders.locations.recommenders.recommendations.markSucceeded" call.
// Exactly one of *GoogleCloudRecommenderV1Recommendation or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleCloudRecommenderV1Recommendation.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *FoldersLocationsRecommendersRecommendationsMarkSucceededCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRecommenderV1Recommendation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudRecommenderV1Recommendation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Marks the Recommendation State as Succeeded. Users can use this method to indicate to the Recommender API that they have applied the recommendation themselves, and the operation was successful. This stops the recommendation content from being updated. Associated insights are frozen and placed in the ACCEPTED state. MarkRecommendationSucceeded can be applied to recommendations in ACTIVE, CLAIMED, SUCCEEDED, or FAILED state. Requires the recommender.*.update IAM permission for the specified recommender.",
	//   "flatPath": "v1/folders/{foldersId}/locations/{locationsId}/recommenders/{recommendersId}/recommendations/{recommendationsId}:markSucceeded",
	//   "httpMethod": "POST",
	//   "id": "recommender.folders.locations.recommenders.recommendations.markSucceeded",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Name of the recommendation.",
	//       "location": "path",
	//       "pattern": "^folders/[^/]+/locations/[^/]+/recommenders/[^/]+/recommendations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}:markSucceeded",
	//   "request": {
	//     "$ref": "GoogleCloudRecommenderV1MarkRecommendationSucceededRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudRecommenderV1Recommendation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "recommender.organizations.locations.insightTypes.insights.get":

type OrganizationsLocationsInsightTypesInsightsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the requested insight. Requires the recommender.*.get IAM
// permission for the specified insight type.
//
// - name: Name of the insight.
func (r *OrganizationsLocationsInsightTypesInsightsService) Get(name string) *OrganizationsLocationsInsightTypesInsightsGetCall {
	c := &OrganizationsLocationsInsightTypesInsightsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsLocationsInsightTypesInsightsGetCall) Fields(s ...googleapi.Field) *OrganizationsLocationsInsightTypesInsightsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *OrganizationsLocationsInsightTypesInsightsGetCall) IfNoneMatch(entityTag string) *OrganizationsLocationsInsightTypesInsightsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsLocationsInsightTypesInsightsGetCall) Context(ctx context.Context) *OrganizationsLocationsInsightTypesInsightsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsLocationsInsightTypesInsightsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsInsightTypesInsightsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211207")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "recommender.organizations.locations.insightTypes.insights.get" call.
// Exactly one of *GoogleCloudRecommenderV1Insight or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleCloudRecommenderV1Insight.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsLocationsInsightTypesInsightsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRecommenderV1Insight, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudRecommenderV1Insight{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the requested insight. Requires the recommender.*.get IAM permission for the specified insight type.",
	//   "flatPath": "v1/organizations/{organizationsId}/locations/{locationsId}/insightTypes/{insightTypesId}/insights/{insightsId}",
	//   "httpMethod": "GET",
	//   "id": "recommender.organizations.locations.insightTypes.insights.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Name of the insight.",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/locations/[^/]+/insightTypes/[^/]+/insights/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudRecommenderV1Insight"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "recommender.organizations.locations.insightTypes.insights.list":

type OrganizationsLocationsInsightTypesInsightsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists insights for the specified Cloud Resource. Requires the
// recommender.*.list IAM permission for the specified insight type.
//
// - parent: The container resource on which to execute the request.
//   Acceptable formats: *
//   `projects/[PROJECT_NUMBER]/locations/[LOCATION]/insightTypes/[INSIGH
//   T_TYPE_ID]` *
//   `projects/[PROJECT_ID]/locations/[LOCATION]/insightTypes/[INSIGHT_TY
//   PE_ID]` *
//   `billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION]/insightTy
//   pes/[INSIGHT_TYPE_ID]` *
//   `folders/[FOLDER_ID]/locations/[LOCATION]/insightTypes/[INSIGHT_TYPE
//   _ID]` *
//   `organizations/[ORGANIZATION_ID]/locations/[LOCATION]/insightTypes/[
//   INSIGHT_TYPE_ID]` LOCATION here refers to GCP Locations:
//   https://cloud.google.com/about/locations/ INSIGHT_TYPE_ID refers to
//   supported insight types:
//   https://cloud.google.com/recommender/docs/insights/insight-types.
func (r *OrganizationsLocationsInsightTypesInsightsService) List(parent string) *OrganizationsLocationsInsightTypesInsightsListCall {
	c := &OrganizationsLocationsInsightTypesInsightsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filter expression to
// restrict the insights returned. Supported filter fields: *
// `stateInfo.state` * `insightSubtype` * `severity` Examples: *
// `stateInfo.state = ACTIVE OR stateInfo.state = DISMISSED` *
// `insightSubtype = PERMISSIONS_USAGE` * `severity = CRITICAL OR
// severity = HIGH` * `stateInfo.state = ACTIVE AND (severity = CRITICAL
// OR severity = HIGH)` (These expressions are based on the filter
// language described at https://google.aip.dev/160)
func (c *OrganizationsLocationsInsightTypesInsightsListCall) Filter(filter string) *OrganizationsLocationsInsightTypesInsightsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of results to return from this request. Non-positive values are
// ignored. If not specified, the server will determine the number of
// results to return.
func (c *OrganizationsLocationsInsightTypesInsightsListCall) PageSize(pageSize int64) *OrganizationsLocationsInsightTypesInsightsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": If present,
// retrieves the next batch of results from the preceding call to this
// method. `page_token` must be the value of `next_page_token` from the
// previous response. The values of other method parameters must be
// identical to those in the previous call.
func (c *OrganizationsLocationsInsightTypesInsightsListCall) PageToken(pageToken string) *OrganizationsLocationsInsightTypesInsightsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsLocationsInsightTypesInsightsListCall) Fields(s ...googleapi.Field) *OrganizationsLocationsInsightTypesInsightsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *OrganizationsLocationsInsightTypesInsightsListCall) IfNoneMatch(entityTag string) *OrganizationsLocationsInsightTypesInsightsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsLocationsInsightTypesInsightsListCall) Context(ctx context.Context) *OrganizationsLocationsInsightTypesInsightsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsLocationsInsightTypesInsightsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsInsightTypesInsightsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211207")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/insights")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "recommender.organizations.locations.insightTypes.insights.list" call.
// Exactly one of *GoogleCloudRecommenderV1ListInsightsResponse or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudRecommenderV1ListInsightsResponse.ServerResponse.Header
// or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *OrganizationsLocationsInsightTypesInsightsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRecommenderV1ListInsightsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudRecommenderV1ListInsightsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists insights for the specified Cloud Resource. Requires the recommender.*.list IAM permission for the specified insight type.",
	//   "flatPath": "v1/organizations/{organizationsId}/locations/{locationsId}/insightTypes/{insightTypesId}/insights",
	//   "httpMethod": "GET",
	//   "id": "recommender.organizations.locations.insightTypes.insights.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "Optional. Filter expression to restrict the insights returned. Supported filter fields: * `stateInfo.state` * `insightSubtype` * `severity` Examples: * `stateInfo.state = ACTIVE OR stateInfo.state = DISMISSED` * `insightSubtype = PERMISSIONS_USAGE` * `severity = CRITICAL OR severity = HIGH` * `stateInfo.state = ACTIVE AND (severity = CRITICAL OR severity = HIGH)` (These expressions are based on the filter language described at https://google.aip.dev/160)",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "Optional. The maximum number of results to return from this request. Non-positive values are ignored. If not specified, the server will determine the number of results to return.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "Optional. If present, retrieves the next batch of results from the preceding call to this method. `page_token` must be the value of `next_page_token` from the previous response. The values of other method parameters must be identical to those in the previous call.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The container resource on which to execute the request. Acceptable formats: * `projects/[PROJECT_NUMBER]/locations/[LOCATION]/insightTypes/[INSIGHT_TYPE_ID]` * `projects/[PROJECT_ID]/locations/[LOCATION]/insightTypes/[INSIGHT_TYPE_ID]` * `billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION]/insightTypes/[INSIGHT_TYPE_ID]` * `folders/[FOLDER_ID]/locations/[LOCATION]/insightTypes/[INSIGHT_TYPE_ID]` * `organizations/[ORGANIZATION_ID]/locations/[LOCATION]/insightTypes/[INSIGHT_TYPE_ID]` LOCATION here refers to GCP Locations: https://cloud.google.com/about/locations/ INSIGHT_TYPE_ID refers to supported insight types: https://cloud.google.com/recommender/docs/insights/insight-types.",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/locations/[^/]+/insightTypes/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/insights",
	//   "response": {
	//     "$ref": "GoogleCloudRecommenderV1ListInsightsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *OrganizationsLocationsInsightTypesInsightsListCall) Pages(ctx context.Context, f func(*GoogleCloudRecommenderV1ListInsightsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "recommender.organizations.locations.insightTypes.insights.markAccepted":

type OrganizationsLocationsInsightTypesInsightsMarkAcceptedCall struct {
	s                                                  *Service
	name                                               string
	googlecloudrecommenderv1markinsightacceptedrequest *GoogleCloudRecommenderV1MarkInsightAcceptedRequest
	urlParams_                                         gensupport.URLParams
	ctx_                                               context.Context
	header_                                            http.Header
}

// MarkAccepted: Marks the Insight State as Accepted. Users can use this
// method to indicate to the Recommender API that they have applied some
// action based on the insight. This stops the insight content from
// being updated. MarkInsightAccepted can be applied to insights in
// ACTIVE state. Requires the recommender.*.update IAM permission for
// the specified insight.
//
// - name: Name of the insight.
func (r *OrganizationsLocationsInsightTypesInsightsService) MarkAccepted(name string, googlecloudrecommenderv1markinsightacceptedrequest *GoogleCloudRecommenderV1MarkInsightAcceptedRequest) *OrganizationsLocationsInsightTypesInsightsMarkAcceptedCall {
	c := &OrganizationsLocationsInsightTypesInsightsMarkAcceptedCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudrecommenderv1markinsightacceptedrequest = googlecloudrecommenderv1markinsightacceptedrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsLocationsInsightTypesInsightsMarkAcceptedCall) Fields(s ...googleapi.Field) *OrganizationsLocationsInsightTypesInsightsMarkAcceptedCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsLocationsInsightTypesInsightsMarkAcceptedCall) Context(ctx context.Context) *OrganizationsLocationsInsightTypesInsightsMarkAcceptedCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsLocationsInsightTypesInsightsMarkAcceptedCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsInsightTypesInsightsMarkAcceptedCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211207")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudrecommenderv1markinsightacceptedrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:markAccepted")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "recommender.organizations.locations.insightTypes.insights.markAccepted" call.
// Exactly one of *GoogleCloudRecommenderV1Insight or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleCloudRecommenderV1Insight.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsLocationsInsightTypesInsightsMarkAcceptedCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRecommenderV1Insight, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudRecommenderV1Insight{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Marks the Insight State as Accepted. Users can use this method to indicate to the Recommender API that they have applied some action based on the insight. This stops the insight content from being updated. MarkInsightAccepted can be applied to insights in ACTIVE state. Requires the recommender.*.update IAM permission for the specified insight.",
	//   "flatPath": "v1/organizations/{organizationsId}/locations/{locationsId}/insightTypes/{insightTypesId}/insights/{insightsId}:markAccepted",
	//   "httpMethod": "POST",
	//   "id": "recommender.organizations.locations.insightTypes.insights.markAccepted",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Name of the insight.",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/locations/[^/]+/insightTypes/[^/]+/insights/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}:markAccepted",
	//   "request": {
	//     "$ref": "GoogleCloudRecommenderV1MarkInsightAcceptedRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudRecommenderV1Insight"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "recommender.organizations.locations.recommenders.recommendations.get":

type OrganizationsLocationsRecommendersRecommendationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the requested recommendation. Requires the
// recommender.*.get IAM permission for the specified recommender.
//
// - name: Name of the recommendation.
func (r *OrganizationsLocationsRecommendersRecommendationsService) Get(name string) *OrganizationsLocationsRecommendersRecommendationsGetCall {
	c := &OrganizationsLocationsRecommendersRecommendationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsLocationsRecommendersRecommendationsGetCall) Fields(s ...googleapi.Field) *OrganizationsLocationsRecommendersRecommendationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *OrganizationsLocationsRecommendersRecommendationsGetCall) IfNoneMatch(entityTag string) *OrganizationsLocationsRecommendersRecommendationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsLocationsRecommendersRecommendationsGetCall) Context(ctx context.Context) *OrganizationsLocationsRecommendersRecommendationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsLocationsRecommendersRecommendationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsRecommendersRecommendationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211207")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "recommender.organizations.locations.recommenders.recommendations.get" call.
// Exactly one of *GoogleCloudRecommenderV1Recommendation or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleCloudRecommenderV1Recommendation.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsLocationsRecommendersRecommendationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRecommenderV1Recommendation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudRecommenderV1Recommendation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the requested recommendation. Requires the recommender.*.get IAM permission for the specified recommender.",
	//   "flatPath": "v1/organizations/{organizationsId}/locations/{locationsId}/recommenders/{recommendersId}/recommendations/{recommendationsId}",
	//   "httpMethod": "GET",
	//   "id": "recommender.organizations.locations.recommenders.recommendations.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Name of the recommendation.",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/locations/[^/]+/recommenders/[^/]+/recommendations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudRecommenderV1Recommendation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "recommender.organizations.locations.recommenders.recommendations.list":

type OrganizationsLocationsRecommendersRecommendationsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists recommendations for the specified Cloud Resource.
// Requires the recommender.*.list IAM permission for the specified
// recommender.
//
// - parent: The container resource on which to execute the request.
//   Acceptable formats: *
//   `projects/[PROJECT_NUMBER]/locations/[LOCATION]/recommenders/[RECOMM
//   ENDER_ID]` *
//   `projects/[PROJECT_ID]/locations/[LOCATION]/recommenders/[RECOMMENDE
//   R_ID]` *
//   `billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION]/recommend
//   ers/[RECOMMENDER_ID]` *
//   `folders/[FOLDER_ID]/locations/[LOCATION]/recommenders/[RECOMMENDER_
//   ID]` *
//   `organizations/[ORGANIZATION_ID]/locations/[LOCATION]/recommenders/[
//   RECOMMENDER_ID]` LOCATION here refers to GCP Locations:
//   https://cloud.google.com/about/locations/ RECOMMENDER_ID refers to
//   supported recommenders:
//   https://cloud.google.com/recommender/docs/recommenders.
func (r *OrganizationsLocationsRecommendersRecommendationsService) List(parent string) *OrganizationsLocationsRecommendersRecommendationsListCall {
	c := &OrganizationsLocationsRecommendersRecommendationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filter expression to
// restrict the recommendations returned. Supported filter fields: *
// `state_info.state` * `recommenderSubtype` * `priority` Examples: *
// `stateInfo.state = ACTIVE OR stateInfo.state = DISMISSED` *
// `recommenderSubtype = REMOVE_ROLE OR recommenderSubtype =
// REPLACE_ROLE` * `priority = P1 OR priority = P2` * `stateInfo.state =
// ACTIVE AND (priority = P1 OR priority = P2)` (These expressions are
// based on the filter language described at https://google.aip.dev/160)
func (c *OrganizationsLocationsRecommendersRecommendationsListCall) Filter(filter string) *OrganizationsLocationsRecommendersRecommendationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of results to return from this request. Non-positive values are
// ignored. If not specified, the server will determine the number of
// results to return.
func (c *OrganizationsLocationsRecommendersRecommendationsListCall) PageSize(pageSize int64) *OrganizationsLocationsRecommendersRecommendationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": If present,
// retrieves the next batch of results from the preceding call to this
// method. `page_token` must be the value of `next_page_token` from the
// previous response. The values of other method parameters must be
// identical to those in the previous call.
func (c *OrganizationsLocationsRecommendersRecommendationsListCall) PageToken(pageToken string) *OrganizationsLocationsRecommendersRecommendationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsLocationsRecommendersRecommendationsListCall) Fields(s ...googleapi.Field) *OrganizationsLocationsRecommendersRecommendationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *OrganizationsLocationsRecommendersRecommendationsListCall) IfNoneMatch(entityTag string) *OrganizationsLocationsRecommendersRecommendationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsLocationsRecommendersRecommendationsListCall) Context(ctx context.Context) *OrganizationsLocationsRecommendersRecommendationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsLocationsRecommendersRecommendationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsRecommendersRecommendationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211207")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/recommendations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "recommender.organizations.locations.recommenders.recommendations.list" call.
// Exactly one of *GoogleCloudRecommenderV1ListRecommendationsResponse
// or error will be non-nil. Any non-2xx status code is an error.
// Response headers are in either
// *GoogleCloudRecommenderV1ListRecommendationsResponse.ServerResponse.He
// ader or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *OrganizationsLocationsRecommendersRecommendationsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRecommenderV1ListRecommendationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudRecommenderV1ListRecommendationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists recommendations for the specified Cloud Resource. Requires the recommender.*.list IAM permission for the specified recommender.",
	//   "flatPath": "v1/organizations/{organizationsId}/locations/{locationsId}/recommenders/{recommendersId}/recommendations",
	//   "httpMethod": "GET",
	//   "id": "recommender.organizations.locations.recommenders.recommendations.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "Filter expression to restrict the recommendations returned. Supported filter fields: * `state_info.state` * `recommenderSubtype` * `priority` Examples: * `stateInfo.state = ACTIVE OR stateInfo.state = DISMISSED` * `recommenderSubtype = REMOVE_ROLE OR recommenderSubtype = REPLACE_ROLE` * `priority = P1 OR priority = P2` * `stateInfo.state = ACTIVE AND (priority = P1 OR priority = P2)` (These expressions are based on the filter language described at https://google.aip.dev/160)",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "Optional. The maximum number of results to return from this request. Non-positive values are ignored. If not specified, the server will determine the number of results to return.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "Optional. If present, retrieves the next batch of results from the preceding call to this method. `page_token` must be the value of `next_page_token` from the previous response. The values of other method parameters must be identical to those in the previous call.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The container resource on which to execute the request. Acceptable formats: * `projects/[PROJECT_NUMBER]/locations/[LOCATION]/recommenders/[RECOMMENDER_ID]` * `projects/[PROJECT_ID]/locations/[LOCATION]/recommenders/[RECOMMENDER_ID]` * `billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION]/recommenders/[RECOMMENDER_ID]` * `folders/[FOLDER_ID]/locations/[LOCATION]/recommenders/[RECOMMENDER_ID]` * `organizations/[ORGANIZATION_ID]/locations/[LOCATION]/recommenders/[RECOMMENDER_ID]` LOCATION here refers to GCP Locations: https://cloud.google.com/about/locations/ RECOMMENDER_ID refers to supported recommenders: https://cloud.google.com/recommender/docs/recommenders.",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/locations/[^/]+/recommenders/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/recommendations",
	//   "response": {
	//     "$ref": "GoogleCloudRecommenderV1ListRecommendationsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *OrganizationsLocationsRecommendersRecommendationsListCall) Pages(ctx context.Context, f func(*GoogleCloudRecommenderV1ListRecommendationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "recommender.organizations.locations.recommenders.recommendations.markClaimed":

type OrganizationsLocationsRecommendersRecommendationsMarkClaimedCall struct {
	s                                                        *Service
	name                                                     string
	googlecloudrecommenderv1markrecommendationclaimedrequest *GoogleCloudRecommenderV1MarkRecommendationClaimedRequest
	urlParams_                                               gensupport.URLParams
	ctx_                                                     context.Context
	header_                                                  http.Header
}

// MarkClaimed: Marks the Recommendation State as Claimed. Users can use
// this method to indicate to the Recommender API that they are starting
// to apply the recommendation themselves. This stops the recommendation
// content from being updated. Associated insights are frozen and placed
// in the ACCEPTED state. MarkRecommendationClaimed can be applied to
// recommendations in CLAIMED, SUCCEEDED, FAILED, or ACTIVE state.
// Requires the recommender.*.update IAM permission for the specified
// recommender.
//
// - name: Name of the recommendation.
func (r *OrganizationsLocationsRecommendersRecommendationsService) MarkClaimed(name string, googlecloudrecommenderv1markrecommendationclaimedrequest *GoogleCloudRecommenderV1MarkRecommendationClaimedRequest) *OrganizationsLocationsRecommendersRecommendationsMarkClaimedCall {
	c := &OrganizationsLocationsRecommendersRecommendationsMarkClaimedCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudrecommenderv1markrecommendationclaimedrequest = googlecloudrecommenderv1markrecommendationclaimedrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsLocationsRecommendersRecommendationsMarkClaimedCall) Fields(s ...googleapi.Field) *OrganizationsLocationsRecommendersRecommendationsMarkClaimedCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsLocationsRecommendersRecommendationsMarkClaimedCall) Context(ctx context.Context) *OrganizationsLocationsRecommendersRecommendationsMarkClaimedCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsLocationsRecommendersRecommendationsMarkClaimedCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsRecommendersRecommendationsMarkClaimedCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211207")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudrecommenderv1markrecommendationclaimedrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:markClaimed")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "recommender.organizations.locations.recommenders.recommendations.markClaimed" call.
// Exactly one of *GoogleCloudRecommenderV1Recommendation or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleCloudRecommenderV1Recommendation.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsLocationsRecommendersRecommendationsMarkClaimedCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRecommenderV1Recommendation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudRecommenderV1Recommendation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Marks the Recommendation State as Claimed. Users can use this method to indicate to the Recommender API that they are starting to apply the recommendation themselves. This stops the recommendation content from being updated. Associated insights are frozen and placed in the ACCEPTED state. MarkRecommendationClaimed can be applied to recommendations in CLAIMED, SUCCEEDED, FAILED, or ACTIVE state. Requires the recommender.*.update IAM permission for the specified recommender.",
	//   "flatPath": "v1/organizations/{organizationsId}/locations/{locationsId}/recommenders/{recommendersId}/recommendations/{recommendationsId}:markClaimed",
	//   "httpMethod": "POST",
	//   "id": "recommender.organizations.locations.recommenders.recommendations.markClaimed",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Name of the recommendation.",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/locations/[^/]+/recommenders/[^/]+/recommendations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}:markClaimed",
	//   "request": {
	//     "$ref": "GoogleCloudRecommenderV1MarkRecommendationClaimedRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudRecommenderV1Recommendation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "recommender.organizations.locations.recommenders.recommendations.markFailed":

type OrganizationsLocationsRecommendersRecommendationsMarkFailedCall struct {
	s                                                       *Service
	name                                                    string
	googlecloudrecommenderv1markrecommendationfailedrequest *GoogleCloudRecommenderV1MarkRecommendationFailedRequest
	urlParams_                                              gensupport.URLParams
	ctx_                                                    context.Context
	header_                                                 http.Header
}

// MarkFailed: Marks the Recommendation State as Failed. Users can use
// this method to indicate to the Recommender API that they have applied
// the recommendation themselves, and the operation failed. This stops
// the recommendation content from being updated. Associated insights
// are frozen and placed in the ACCEPTED state. MarkRecommendationFailed
// can be applied to recommendations in ACTIVE, CLAIMED, SUCCEEDED, or
// FAILED state. Requires the recommender.*.update IAM permission for
// the specified recommender.
//
// - name: Name of the recommendation.
func (r *OrganizationsLocationsRecommendersRecommendationsService) MarkFailed(name string, googlecloudrecommenderv1markrecommendationfailedrequest *GoogleCloudRecommenderV1MarkRecommendationFailedRequest) *OrganizationsLocationsRecommendersRecommendationsMarkFailedCall {
	c := &OrganizationsLocationsRecommendersRecommendationsMarkFailedCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudrecommenderv1markrecommendationfailedrequest = googlecloudrecommenderv1markrecommendationfailedrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsLocationsRecommendersRecommendationsMarkFailedCall) Fields(s ...googleapi.Field) *OrganizationsLocationsRecommendersRecommendationsMarkFailedCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsLocationsRecommendersRecommendationsMarkFailedCall) Context(ctx context.Context) *OrganizationsLocationsRecommendersRecommendationsMarkFailedCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsLocationsRecommendersRecommendationsMarkFailedCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsRecommendersRecommendationsMarkFailedCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211207")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudrecommenderv1markrecommendationfailedrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:markFailed")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "recommender.organizations.locations.recommenders.recommendations.markFailed" call.
// Exactly one of *GoogleCloudRecommenderV1Recommendation or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleCloudRecommenderV1Recommendation.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsLocationsRecommendersRecommendationsMarkFailedCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRecommenderV1Recommendation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudRecommenderV1Recommendation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Marks the Recommendation State as Failed. Users can use this method to indicate to the Recommender API that they have applied the recommendation themselves, and the operation failed. This stops the recommendation content from being updated. Associated insights are frozen and placed in the ACCEPTED state. MarkRecommendationFailed can be applied to recommendations in ACTIVE, CLAIMED, SUCCEEDED, or FAILED state. Requires the recommender.*.update IAM permission for the specified recommender.",
	//   "flatPath": "v1/organizations/{organizationsId}/locations/{locationsId}/recommenders/{recommendersId}/recommendations/{recommendationsId}:markFailed",
	//   "httpMethod": "POST",
	//   "id": "recommender.organizations.locations.recommenders.recommendations.markFailed",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Name of the recommendation.",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/locations/[^/]+/recommenders/[^/]+/recommendations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}:markFailed",
	//   "request": {
	//     "$ref": "GoogleCloudRecommenderV1MarkRecommendationFailedRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudRecommenderV1Recommendation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "recommender.organizations.locations.recommenders.recommendations.markSucceeded":

type OrganizationsLocationsRecommendersRecommendationsMarkSucceededCall struct {
	s                                                          *Service
	name                                                       string
	googlecloudrecommenderv1markrecommendationsucceededrequest *GoogleCloudRecommenderV1MarkRecommendationSucceededRequest
	urlParams_                                                 gensupport.URLParams
	ctx_                                                       context.Context
	header_                                                    http.Header
}

// MarkSucceeded: Marks the Recommendation State as Succeeded. Users can
// use this method to indicate to the Recommender API that they have
// applied the recommendation themselves, and the operation was
// successful. This stops the recommendation content from being updated.
// Associated insights are frozen and placed in the ACCEPTED state.
// MarkRecommendationSucceeded can be applied to recommendations in
// ACTIVE, CLAIMED, SUCCEEDED, or FAILED state. Requires the
// recommender.*.update IAM permission for the specified recommender.
//
// - name: Name of the recommendation.
func (r *OrganizationsLocationsRecommendersRecommendationsService) MarkSucceeded(name string, googlecloudrecommenderv1markrecommendationsucceededrequest *GoogleCloudRecommenderV1MarkRecommendationSucceededRequest) *OrganizationsLocationsRecommendersRecommendationsMarkSucceededCall {
	c := &OrganizationsLocationsRecommendersRecommendationsMarkSucceededCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudrecommenderv1markrecommendationsucceededrequest = googlecloudrecommenderv1markrecommendationsucceededrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsLocationsRecommendersRecommendationsMarkSucceededCall) Fields(s ...googleapi.Field) *OrganizationsLocationsRecommendersRecommendationsMarkSucceededCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsLocationsRecommendersRecommendationsMarkSucceededCall) Context(ctx context.Context) *OrganizationsLocationsRecommendersRecommendationsMarkSucceededCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsLocationsRecommendersRecommendationsMarkSucceededCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsRecommendersRecommendationsMarkSucceededCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211207")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudrecommenderv1markrecommendationsucceededrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:markSucceeded")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "recommender.organizations.locations.recommenders.recommendations.markSucceeded" call.
// Exactly one of *GoogleCloudRecommenderV1Recommendation or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleCloudRecommenderV1Recommendation.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsLocationsRecommendersRecommendationsMarkSucceededCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRecommenderV1Recommendation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudRecommenderV1Recommendation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Marks the Recommendation State as Succeeded. Users can use this method to indicate to the Recommender API that they have applied the recommendation themselves, and the operation was successful. This stops the recommendation content from being updated. Associated insights are frozen and placed in the ACCEPTED state. MarkRecommendationSucceeded can be applied to recommendations in ACTIVE, CLAIMED, SUCCEEDED, or FAILED state. Requires the recommender.*.update IAM permission for the specified recommender.",
	//   "flatPath": "v1/organizations/{organizationsId}/locations/{locationsId}/recommenders/{recommendersId}/recommendations/{recommendationsId}:markSucceeded",
	//   "httpMethod": "POST",
	//   "id": "recommender.organizations.locations.recommenders.recommendations.markSucceeded",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Name of the recommendation.",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/locations/[^/]+/recommenders/[^/]+/recommendations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}:markSucceeded",
	//   "request": {
	//     "$ref": "GoogleCloudRecommenderV1MarkRecommendationSucceededRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudRecommenderV1Recommendation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "recommender.projects.locations.insightTypes.insights.get":

type ProjectsLocationsInsightTypesInsightsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the requested insight. Requires the recommender.*.get IAM
// permission for the specified insight type.
//
// - name: Name of the insight.
func (r *ProjectsLocationsInsightTypesInsightsService) Get(name string) *ProjectsLocationsInsightTypesInsightsGetCall {
	c := &ProjectsLocationsInsightTypesInsightsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsInsightTypesInsightsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsInsightTypesInsightsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsInsightTypesInsightsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsInsightTypesInsightsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsInsightTypesInsightsGetCall) Context(ctx context.Context) *ProjectsLocationsInsightTypesInsightsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsInsightTypesInsightsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsInsightTypesInsightsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211207")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "recommender.projects.locations.insightTypes.insights.get" call.
// Exactly one of *GoogleCloudRecommenderV1Insight or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleCloudRecommenderV1Insight.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsInsightTypesInsightsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRecommenderV1Insight, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudRecommenderV1Insight{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the requested insight. Requires the recommender.*.get IAM permission for the specified insight type.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/insightTypes/{insightTypesId}/insights/{insightsId}",
	//   "httpMethod": "GET",
	//   "id": "recommender.projects.locations.insightTypes.insights.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Name of the insight.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/insightTypes/[^/]+/insights/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudRecommenderV1Insight"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "recommender.projects.locations.insightTypes.insights.list":

type ProjectsLocationsInsightTypesInsightsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists insights for the specified Cloud Resource. Requires the
// recommender.*.list IAM permission for the specified insight type.
//
// - parent: The container resource on which to execute the request.
//   Acceptable formats: *
//   `projects/[PROJECT_NUMBER]/locations/[LOCATION]/insightTypes/[INSIGH
//   T_TYPE_ID]` *
//   `projects/[PROJECT_ID]/locations/[LOCATION]/insightTypes/[INSIGHT_TY
//   PE_ID]` *
//   `billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION]/insightTy
//   pes/[INSIGHT_TYPE_ID]` *
//   `folders/[FOLDER_ID]/locations/[LOCATION]/insightTypes/[INSIGHT_TYPE
//   _ID]` *
//   `organizations/[ORGANIZATION_ID]/locations/[LOCATION]/insightTypes/[
//   INSIGHT_TYPE_ID]` LOCATION here refers to GCP Locations:
//   https://cloud.google.com/about/locations/ INSIGHT_TYPE_ID refers to
//   supported insight types:
//   https://cloud.google.com/recommender/docs/insights/insight-types.
func (r *ProjectsLocationsInsightTypesInsightsService) List(parent string) *ProjectsLocationsInsightTypesInsightsListCall {
	c := &ProjectsLocationsInsightTypesInsightsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filter expression to
// restrict the insights returned. Supported filter fields: *
// `stateInfo.state` * `insightSubtype` * `severity` Examples: *
// `stateInfo.state = ACTIVE OR stateInfo.state = DISMISSED` *
// `insightSubtype = PERMISSIONS_USAGE` * `severity = CRITICAL OR
// severity = HIGH` * `stateInfo.state = ACTIVE AND (severity = CRITICAL
// OR severity = HIGH)` (These expressions are based on the filter
// language described at https://google.aip.dev/160)
func (c *ProjectsLocationsInsightTypesInsightsListCall) Filter(filter string) *ProjectsLocationsInsightTypesInsightsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of results to return from this request. Non-positive values are
// ignored. If not specified, the server will determine the number of
// results to return.
func (c *ProjectsLocationsInsightTypesInsightsListCall) PageSize(pageSize int64) *ProjectsLocationsInsightTypesInsightsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": If present,
// retrieves the next batch of results from the preceding call to this
// method. `page_token` must be the value of `next_page_token` from the
// previous response. The values of other method parameters must be
// identical to those in the previous call.
func (c *ProjectsLocationsInsightTypesInsightsListCall) PageToken(pageToken string) *ProjectsLocationsInsightTypesInsightsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsInsightTypesInsightsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsInsightTypesInsightsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsInsightTypesInsightsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsInsightTypesInsightsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsInsightTypesInsightsListCall) Context(ctx context.Context) *ProjectsLocationsInsightTypesInsightsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsInsightTypesInsightsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsInsightTypesInsightsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211207")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/insights")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "recommender.projects.locations.insightTypes.insights.list" call.
// Exactly one of *GoogleCloudRecommenderV1ListInsightsResponse or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudRecommenderV1ListInsightsResponse.ServerResponse.Header
// or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsInsightTypesInsightsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRecommenderV1ListInsightsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudRecommenderV1ListInsightsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists insights for the specified Cloud Resource. Requires the recommender.*.list IAM permission for the specified insight type.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/insightTypes/{insightTypesId}/insights",
	//   "httpMethod": "GET",
	//   "id": "recommender.projects.locations.insightTypes.insights.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "Optional. Filter expression to restrict the insights returned. Supported filter fields: * `stateInfo.state` * `insightSubtype` * `severity` Examples: * `stateInfo.state = ACTIVE OR stateInfo.state = DISMISSED` * `insightSubtype = PERMISSIONS_USAGE` * `severity = CRITICAL OR severity = HIGH` * `stateInfo.state = ACTIVE AND (severity = CRITICAL OR severity = HIGH)` (These expressions are based on the filter language described at https://google.aip.dev/160)",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "Optional. The maximum number of results to return from this request. Non-positive values are ignored. If not specified, the server will determine the number of results to return.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "Optional. If present, retrieves the next batch of results from the preceding call to this method. `page_token` must be the value of `next_page_token` from the previous response. The values of other method parameters must be identical to those in the previous call.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The container resource on which to execute the request. Acceptable formats: * `projects/[PROJECT_NUMBER]/locations/[LOCATION]/insightTypes/[INSIGHT_TYPE_ID]` * `projects/[PROJECT_ID]/locations/[LOCATION]/insightTypes/[INSIGHT_TYPE_ID]` * `billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION]/insightTypes/[INSIGHT_TYPE_ID]` * `folders/[FOLDER_ID]/locations/[LOCATION]/insightTypes/[INSIGHT_TYPE_ID]` * `organizations/[ORGANIZATION_ID]/locations/[LOCATION]/insightTypes/[INSIGHT_TYPE_ID]` LOCATION here refers to GCP Locations: https://cloud.google.com/about/locations/ INSIGHT_TYPE_ID refers to supported insight types: https://cloud.google.com/recommender/docs/insights/insight-types.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/insightTypes/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/insights",
	//   "response": {
	//     "$ref": "GoogleCloudRecommenderV1ListInsightsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsInsightTypesInsightsListCall) Pages(ctx context.Context, f func(*GoogleCloudRecommenderV1ListInsightsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "recommender.projects.locations.insightTypes.insights.markAccepted":

type ProjectsLocationsInsightTypesInsightsMarkAcceptedCall struct {
	s                                                  *Service
	name                                               string
	googlecloudrecommenderv1markinsightacceptedrequest *GoogleCloudRecommenderV1MarkInsightAcceptedRequest
	urlParams_                                         gensupport.URLParams
	ctx_                                               context.Context
	header_                                            http.Header
}

// MarkAccepted: Marks the Insight State as Accepted. Users can use this
// method to indicate to the Recommender API that they have applied some
// action based on the insight. This stops the insight content from
// being updated. MarkInsightAccepted can be applied to insights in
// ACTIVE state. Requires the recommender.*.update IAM permission for
// the specified insight.
//
// - name: Name of the insight.
func (r *ProjectsLocationsInsightTypesInsightsService) MarkAccepted(name string, googlecloudrecommenderv1markinsightacceptedrequest *GoogleCloudRecommenderV1MarkInsightAcceptedRequest) *ProjectsLocationsInsightTypesInsightsMarkAcceptedCall {
	c := &ProjectsLocationsInsightTypesInsightsMarkAcceptedCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudrecommenderv1markinsightacceptedrequest = googlecloudrecommenderv1markinsightacceptedrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsInsightTypesInsightsMarkAcceptedCall) Fields(s ...googleapi.Field) *ProjectsLocationsInsightTypesInsightsMarkAcceptedCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsInsightTypesInsightsMarkAcceptedCall) Context(ctx context.Context) *ProjectsLocationsInsightTypesInsightsMarkAcceptedCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsInsightTypesInsightsMarkAcceptedCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsInsightTypesInsightsMarkAcceptedCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211207")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudrecommenderv1markinsightacceptedrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:markAccepted")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "recommender.projects.locations.insightTypes.insights.markAccepted" call.
// Exactly one of *GoogleCloudRecommenderV1Insight or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleCloudRecommenderV1Insight.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsInsightTypesInsightsMarkAcceptedCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRecommenderV1Insight, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudRecommenderV1Insight{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Marks the Insight State as Accepted. Users can use this method to indicate to the Recommender API that they have applied some action based on the insight. This stops the insight content from being updated. MarkInsightAccepted can be applied to insights in ACTIVE state. Requires the recommender.*.update IAM permission for the specified insight.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/insightTypes/{insightTypesId}/insights/{insightsId}:markAccepted",
	//   "httpMethod": "POST",
	//   "id": "recommender.projects.locations.insightTypes.insights.markAccepted",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Name of the insight.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/insightTypes/[^/]+/insights/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}:markAccepted",
	//   "request": {
	//     "$ref": "GoogleCloudRecommenderV1MarkInsightAcceptedRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudRecommenderV1Insight"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "recommender.projects.locations.recommenders.recommendations.get":

type ProjectsLocationsRecommendersRecommendationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the requested recommendation. Requires the
// recommender.*.get IAM permission for the specified recommender.
//
// - name: Name of the recommendation.
func (r *ProjectsLocationsRecommendersRecommendationsService) Get(name string) *ProjectsLocationsRecommendersRecommendationsGetCall {
	c := &ProjectsLocationsRecommendersRecommendationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsRecommendersRecommendationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsRecommendersRecommendationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsRecommendersRecommendationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsRecommendersRecommendationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsRecommendersRecommendationsGetCall) Context(ctx context.Context) *ProjectsLocationsRecommendersRecommendationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsRecommendersRecommendationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsRecommendersRecommendationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211207")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "recommender.projects.locations.recommenders.recommendations.get" call.
// Exactly one of *GoogleCloudRecommenderV1Recommendation or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleCloudRecommenderV1Recommendation.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsRecommendersRecommendationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRecommenderV1Recommendation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudRecommenderV1Recommendation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the requested recommendation. Requires the recommender.*.get IAM permission for the specified recommender.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/recommenders/{recommendersId}/recommendations/{recommendationsId}",
	//   "httpMethod": "GET",
	//   "id": "recommender.projects.locations.recommenders.recommendations.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Name of the recommendation.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/recommenders/[^/]+/recommendations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudRecommenderV1Recommendation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "recommender.projects.locations.recommenders.recommendations.list":

type ProjectsLocationsRecommendersRecommendationsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists recommendations for the specified Cloud Resource.
// Requires the recommender.*.list IAM permission for the specified
// recommender.
//
// - parent: The container resource on which to execute the request.
//   Acceptable formats: *
//   `projects/[PROJECT_NUMBER]/locations/[LOCATION]/recommenders/[RECOMM
//   ENDER_ID]` *
//   `projects/[PROJECT_ID]/locations/[LOCATION]/recommenders/[RECOMMENDE
//   R_ID]` *
//   `billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION]/recommend
//   ers/[RECOMMENDER_ID]` *
//   `folders/[FOLDER_ID]/locations/[LOCATION]/recommenders/[RECOMMENDER_
//   ID]` *
//   `organizations/[ORGANIZATION_ID]/locations/[LOCATION]/recommenders/[
//   RECOMMENDER_ID]` LOCATION here refers to GCP Locations:
//   https://cloud.google.com/about/locations/ RECOMMENDER_ID refers to
//   supported recommenders:
//   https://cloud.google.com/recommender/docs/recommenders.
func (r *ProjectsLocationsRecommendersRecommendationsService) List(parent string) *ProjectsLocationsRecommendersRecommendationsListCall {
	c := &ProjectsLocationsRecommendersRecommendationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filter expression to
// restrict the recommendations returned. Supported filter fields: *
// `state_info.state` * `recommenderSubtype` * `priority` Examples: *
// `stateInfo.state = ACTIVE OR stateInfo.state = DISMISSED` *
// `recommenderSubtype = REMOVE_ROLE OR recommenderSubtype =
// REPLACE_ROLE` * `priority = P1 OR priority = P2` * `stateInfo.state =
// ACTIVE AND (priority = P1 OR priority = P2)` (These expressions are
// based on the filter language described at https://google.aip.dev/160)
func (c *ProjectsLocationsRecommendersRecommendationsListCall) Filter(filter string) *ProjectsLocationsRecommendersRecommendationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of results to return from this request. Non-positive values are
// ignored. If not specified, the server will determine the number of
// results to return.
func (c *ProjectsLocationsRecommendersRecommendationsListCall) PageSize(pageSize int64) *ProjectsLocationsRecommendersRecommendationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": If present,
// retrieves the next batch of results from the preceding call to this
// method. `page_token` must be the value of `next_page_token` from the
// previous response. The values of other method parameters must be
// identical to those in the previous call.
func (c *ProjectsLocationsRecommendersRecommendationsListCall) PageToken(pageToken string) *ProjectsLocationsRecommendersRecommendationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsRecommendersRecommendationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsRecommendersRecommendationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsRecommendersRecommendationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsRecommendersRecommendationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsRecommendersRecommendationsListCall) Context(ctx context.Context) *ProjectsLocationsRecommendersRecommendationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsRecommendersRecommendationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsRecommendersRecommendationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211207")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/recommendations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "recommender.projects.locations.recommenders.recommendations.list" call.
// Exactly one of *GoogleCloudRecommenderV1ListRecommendationsResponse
// or error will be non-nil. Any non-2xx status code is an error.
// Response headers are in either
// *GoogleCloudRecommenderV1ListRecommendationsResponse.ServerResponse.He
// ader or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsRecommendersRecommendationsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRecommenderV1ListRecommendationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudRecommenderV1ListRecommendationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists recommendations for the specified Cloud Resource. Requires the recommender.*.list IAM permission for the specified recommender.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/recommenders/{recommendersId}/recommendations",
	//   "httpMethod": "GET",
	//   "id": "recommender.projects.locations.recommenders.recommendations.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "Filter expression to restrict the recommendations returned. Supported filter fields: * `state_info.state` * `recommenderSubtype` * `priority` Examples: * `stateInfo.state = ACTIVE OR stateInfo.state = DISMISSED` * `recommenderSubtype = REMOVE_ROLE OR recommenderSubtype = REPLACE_ROLE` * `priority = P1 OR priority = P2` * `stateInfo.state = ACTIVE AND (priority = P1 OR priority = P2)` (These expressions are based on the filter language described at https://google.aip.dev/160)",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "Optional. The maximum number of results to return from this request. Non-positive values are ignored. If not specified, the server will determine the number of results to return.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "Optional. If present, retrieves the next batch of results from the preceding call to this method. `page_token` must be the value of `next_page_token` from the previous response. The values of other method parameters must be identical to those in the previous call.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The container resource on which to execute the request. Acceptable formats: * `projects/[PROJECT_NUMBER]/locations/[LOCATION]/recommenders/[RECOMMENDER_ID]` * `projects/[PROJECT_ID]/locations/[LOCATION]/recommenders/[RECOMMENDER_ID]` * `billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION]/recommenders/[RECOMMENDER_ID]` * `folders/[FOLDER_ID]/locations/[LOCATION]/recommenders/[RECOMMENDER_ID]` * `organizations/[ORGANIZATION_ID]/locations/[LOCATION]/recommenders/[RECOMMENDER_ID]` LOCATION here refers to GCP Locations: https://cloud.google.com/about/locations/ RECOMMENDER_ID refers to supported recommenders: https://cloud.google.com/recommender/docs/recommenders.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/recommenders/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/recommendations",
	//   "response": {
	//     "$ref": "GoogleCloudRecommenderV1ListRecommendationsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsRecommendersRecommendationsListCall) Pages(ctx context.Context, f func(*GoogleCloudRecommenderV1ListRecommendationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "recommender.projects.locations.recommenders.recommendations.markClaimed":

type ProjectsLocationsRecommendersRecommendationsMarkClaimedCall struct {
	s                                                        *Service
	name                                                     string
	googlecloudrecommenderv1markrecommendationclaimedrequest *GoogleCloudRecommenderV1MarkRecommendationClaimedRequest
	urlParams_                                               gensupport.URLParams
	ctx_                                                     context.Context
	header_                                                  http.Header
}

// MarkClaimed: Marks the Recommendation State as Claimed. Users can use
// this method to indicate to the Recommender API that they are starting
// to apply the recommendation themselves. This stops the recommendation
// content from being updated. Associated insights are frozen and placed
// in the ACCEPTED state. MarkRecommendationClaimed can be applied to
// recommendations in CLAIMED, SUCCEEDED, FAILED, or ACTIVE state.
// Requires the recommender.*.update IAM permission for the specified
// recommender.
//
// - name: Name of the recommendation.
func (r *ProjectsLocationsRecommendersRecommendationsService) MarkClaimed(name string, googlecloudrecommenderv1markrecommendationclaimedrequest *GoogleCloudRecommenderV1MarkRecommendationClaimedRequest) *ProjectsLocationsRecommendersRecommendationsMarkClaimedCall {
	c := &ProjectsLocationsRecommendersRecommendationsMarkClaimedCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudrecommenderv1markrecommendationclaimedrequest = googlecloudrecommenderv1markrecommendationclaimedrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsRecommendersRecommendationsMarkClaimedCall) Fields(s ...googleapi.Field) *ProjectsLocationsRecommendersRecommendationsMarkClaimedCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsRecommendersRecommendationsMarkClaimedCall) Context(ctx context.Context) *ProjectsLocationsRecommendersRecommendationsMarkClaimedCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsRecommendersRecommendationsMarkClaimedCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsRecommendersRecommendationsMarkClaimedCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211207")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudrecommenderv1markrecommendationclaimedrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:markClaimed")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "recommender.projects.locations.recommenders.recommendations.markClaimed" call.
// Exactly one of *GoogleCloudRecommenderV1Recommendation or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleCloudRecommenderV1Recommendation.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsRecommendersRecommendationsMarkClaimedCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRecommenderV1Recommendation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudRecommenderV1Recommendation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Marks the Recommendation State as Claimed. Users can use this method to indicate to the Recommender API that they are starting to apply the recommendation themselves. This stops the recommendation content from being updated. Associated insights are frozen and placed in the ACCEPTED state. MarkRecommendationClaimed can be applied to recommendations in CLAIMED, SUCCEEDED, FAILED, or ACTIVE state. Requires the recommender.*.update IAM permission for the specified recommender.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/recommenders/{recommendersId}/recommendations/{recommendationsId}:markClaimed",
	//   "httpMethod": "POST",
	//   "id": "recommender.projects.locations.recommenders.recommendations.markClaimed",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Name of the recommendation.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/recommenders/[^/]+/recommendations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}:markClaimed",
	//   "request": {
	//     "$ref": "GoogleCloudRecommenderV1MarkRecommendationClaimedRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudRecommenderV1Recommendation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "recommender.projects.locations.recommenders.recommendations.markFailed":

type ProjectsLocationsRecommendersRecommendationsMarkFailedCall struct {
	s                                                       *Service
	name                                                    string
	googlecloudrecommenderv1markrecommendationfailedrequest *GoogleCloudRecommenderV1MarkRecommendationFailedRequest
	urlParams_                                              gensupport.URLParams
	ctx_                                                    context.Context
	header_                                                 http.Header
}

// MarkFailed: Marks the Recommendation State as Failed. Users can use
// this method to indicate to the Recommender API that they have applied
// the recommendation themselves, and the operation failed. This stops
// the recommendation content from being updated. Associated insights
// are frozen and placed in the ACCEPTED state. MarkRecommendationFailed
// can be applied to recommendations in ACTIVE, CLAIMED, SUCCEEDED, or
// FAILED state. Requires the recommender.*.update IAM permission for
// the specified recommender.
//
// - name: Name of the recommendation.
func (r *ProjectsLocationsRecommendersRecommendationsService) MarkFailed(name string, googlecloudrecommenderv1markrecommendationfailedrequest *GoogleCloudRecommenderV1MarkRecommendationFailedRequest) *ProjectsLocationsRecommendersRecommendationsMarkFailedCall {
	c := &ProjectsLocationsRecommendersRecommendationsMarkFailedCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudrecommenderv1markrecommendationfailedrequest = googlecloudrecommenderv1markrecommendationfailedrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsRecommendersRecommendationsMarkFailedCall) Fields(s ...googleapi.Field) *ProjectsLocationsRecommendersRecommendationsMarkFailedCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsRecommendersRecommendationsMarkFailedCall) Context(ctx context.Context) *ProjectsLocationsRecommendersRecommendationsMarkFailedCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsRecommendersRecommendationsMarkFailedCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsRecommendersRecommendationsMarkFailedCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211207")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudrecommenderv1markrecommendationfailedrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:markFailed")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "recommender.projects.locations.recommenders.recommendations.markFailed" call.
// Exactly one of *GoogleCloudRecommenderV1Recommendation or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleCloudRecommenderV1Recommendation.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsRecommendersRecommendationsMarkFailedCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRecommenderV1Recommendation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudRecommenderV1Recommendation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Marks the Recommendation State as Failed. Users can use this method to indicate to the Recommender API that they have applied the recommendation themselves, and the operation failed. This stops the recommendation content from being updated. Associated insights are frozen and placed in the ACCEPTED state. MarkRecommendationFailed can be applied to recommendations in ACTIVE, CLAIMED, SUCCEEDED, or FAILED state. Requires the recommender.*.update IAM permission for the specified recommender.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/recommenders/{recommendersId}/recommendations/{recommendationsId}:markFailed",
	//   "httpMethod": "POST",
	//   "id": "recommender.projects.locations.recommenders.recommendations.markFailed",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Name of the recommendation.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/recommenders/[^/]+/recommendations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}:markFailed",
	//   "request": {
	//     "$ref": "GoogleCloudRecommenderV1MarkRecommendationFailedRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudRecommenderV1Recommendation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "recommender.projects.locations.recommenders.recommendations.markSucceeded":

type ProjectsLocationsRecommendersRecommendationsMarkSucceededCall struct {
	s                                                          *Service
	name                                                       string
	googlecloudrecommenderv1markrecommendationsucceededrequest *GoogleCloudRecommenderV1MarkRecommendationSucceededRequest
	urlParams_                                                 gensupport.URLParams
	ctx_                                                       context.Context
	header_                                                    http.Header
}

// MarkSucceeded: Marks the Recommendation State as Succeeded. Users can
// use this method to indicate to the Recommender API that they have
// applied the recommendation themselves, and the operation was
// successful. This stops the recommendation content from being updated.
// Associated insights are frozen and placed in the ACCEPTED state.
// MarkRecommendationSucceeded can be applied to recommendations in
// ACTIVE, CLAIMED, SUCCEEDED, or FAILED state. Requires the
// recommender.*.update IAM permission for the specified recommender.
//
// - name: Name of the recommendation.
func (r *ProjectsLocationsRecommendersRecommendationsService) MarkSucceeded(name string, googlecloudrecommenderv1markrecommendationsucceededrequest *GoogleCloudRecommenderV1MarkRecommendationSucceededRequest) *ProjectsLocationsRecommendersRecommendationsMarkSucceededCall {
	c := &ProjectsLocationsRecommendersRecommendationsMarkSucceededCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudrecommenderv1markrecommendationsucceededrequest = googlecloudrecommenderv1markrecommendationsucceededrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsRecommendersRecommendationsMarkSucceededCall) Fields(s ...googleapi.Field) *ProjectsLocationsRecommendersRecommendationsMarkSucceededCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsRecommendersRecommendationsMarkSucceededCall) Context(ctx context.Context) *ProjectsLocationsRecommendersRecommendationsMarkSucceededCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsRecommendersRecommendationsMarkSucceededCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsRecommendersRecommendationsMarkSucceededCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211207")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudrecommenderv1markrecommendationsucceededrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:markSucceeded")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "recommender.projects.locations.recommenders.recommendations.markSucceeded" call.
// Exactly one of *GoogleCloudRecommenderV1Recommendation or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleCloudRecommenderV1Recommendation.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsRecommendersRecommendationsMarkSucceededCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRecommenderV1Recommendation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudRecommenderV1Recommendation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Marks the Recommendation State as Succeeded. Users can use this method to indicate to the Recommender API that they have applied the recommendation themselves, and the operation was successful. This stops the recommendation content from being updated. Associated insights are frozen and placed in the ACCEPTED state. MarkRecommendationSucceeded can be applied to recommendations in ACTIVE, CLAIMED, SUCCEEDED, or FAILED state. Requires the recommender.*.update IAM permission for the specified recommender.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/recommenders/{recommendersId}/recommendations/{recommendationsId}:markSucceeded",
	//   "httpMethod": "POST",
	//   "id": "recommender.projects.locations.recommenders.recommendations.markSucceeded",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Name of the recommendation.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/recommenders/[^/]+/recommendations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}:markSucceeded",
	//   "request": {
	//     "$ref": "GoogleCloudRecommenderV1MarkRecommendationSucceededRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudRecommenderV1Recommendation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}
