// Copyright 2021 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package serviceconsumermanagement provides access to the Service Consumer Management API.
//
// For product documentation, see: https://cloud.google.com/service-consumer-management/docs/overview
//
// Creating a client
//
// Usage example:
//
//   import "google.golang.org/api/serviceconsumermanagement/v1beta1"
//   ...
//   ctx := context.Background()
//   serviceconsumermanagementService, err := serviceconsumermanagement.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for authentication.
//
// For information on how to create and obtain Application Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API keys), use option.WithAPIKey:
//
//   serviceconsumermanagementService, err := serviceconsumermanagement.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth flow), use option.WithTokenSource:
//
//   config := &oauth2.Config{...}
//   // ...
//   token, err := config.Exchange(ctx, ...)
//   serviceconsumermanagementService, err := serviceconsumermanagement.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See https://godoc.org/google.golang.org/api/option/ for details on options.
package serviceconsumermanagement // import "google.golang.org/api/serviceconsumermanagement/v1beta1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	googleapi "google.golang.org/api/googleapi"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint

const apiId = "serviceconsumermanagement:v1beta1"
const apiName = "serviceconsumermanagement"
const apiVersion = "v1beta1"
const basePath = "https://serviceconsumermanagement.googleapis.com/"
const mtlsBasePath = "https://serviceconsumermanagement.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the
	// email address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new APIService.
func NewService(ctx context.Context, opts ...option.ClientOption) (*APIService, error) {
	scopesOption := option.WithScopes(
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s, err := New(client)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new APIService. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*APIService, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	s := &APIService{client: client, BasePath: basePath}
	s.Operations = NewOperationsService(s)
	s.Services = NewServicesService(s)
	return s, nil
}

type APIService struct {
	client    *http.Client
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Operations *OperationsService

	Services *ServicesService
}

func (s *APIService) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewOperationsService(s *APIService) *OperationsService {
	rs := &OperationsService{s: s}
	return rs
}

type OperationsService struct {
	s *APIService
}

func NewServicesService(s *APIService) *ServicesService {
	rs := &ServicesService{s: s}
	rs.ConsumerQuotaMetrics = NewServicesConsumerQuotaMetricsService(s)
	return rs
}

type ServicesService struct {
	s *APIService

	ConsumerQuotaMetrics *ServicesConsumerQuotaMetricsService
}

func NewServicesConsumerQuotaMetricsService(s *APIService) *ServicesConsumerQuotaMetricsService {
	rs := &ServicesConsumerQuotaMetricsService{s: s}
	rs.Limits = NewServicesConsumerQuotaMetricsLimitsService(s)
	return rs
}

type ServicesConsumerQuotaMetricsService struct {
	s *APIService

	Limits *ServicesConsumerQuotaMetricsLimitsService
}

func NewServicesConsumerQuotaMetricsLimitsService(s *APIService) *ServicesConsumerQuotaMetricsLimitsService {
	rs := &ServicesConsumerQuotaMetricsLimitsService{s: s}
	rs.ProducerOverrides = NewServicesConsumerQuotaMetricsLimitsProducerOverridesService(s)
	return rs
}

type ServicesConsumerQuotaMetricsLimitsService struct {
	s *APIService

	ProducerOverrides *ServicesConsumerQuotaMetricsLimitsProducerOverridesService
}

func NewServicesConsumerQuotaMetricsLimitsProducerOverridesService(s *APIService) *ServicesConsumerQuotaMetricsLimitsProducerOverridesService {
	rs := &ServicesConsumerQuotaMetricsLimitsProducerOverridesService{s: s}
	return rs
}

type ServicesConsumerQuotaMetricsLimitsProducerOverridesService struct {
	s *APIService
}

// Api: Api is a light-weight descriptor for an API Interface.
// Interfaces are also described as "protocol buffer services" in some
// contexts, such as by the "service" keyword in a .proto file, but they
// are different from API Services, which represent a concrete
// implementation of an interface as opposed to simply a description of
// methods and bindings. They are also sometimes simply referred to as
// "APIs" in other contexts, such as the name of this message itself.
// See https://cloud.google.com/apis/design/glossary for detailed
// terminology.
type Api struct {
	// Methods: The methods of this interface, in unspecified order.
	Methods []*Method `json:"methods,omitempty"`

	// Mixins: Included interfaces. See Mixin.
	Mixins []*Mixin `json:"mixins,omitempty"`

	// Name: The fully qualified name of this interface, including package
	// name followed by the interface's simple name.
	Name string `json:"name,omitempty"`

	// Options: Any metadata attached to the interface.
	Options []*Option `json:"options,omitempty"`

	// SourceContext: Source context for the protocol buffer service
	// represented by this message.
	SourceContext *SourceContext `json:"sourceContext,omitempty"`

	// Syntax: The source syntax of the service.
	//
	// Possible values:
	//   "SYNTAX_PROTO2" - Syntax `proto2`.
	//   "SYNTAX_PROTO3" - Syntax `proto3`.
	Syntax string `json:"syntax,omitempty"`

	// Version: A version string for this interface. If specified, must have
	// the form `major-version.minor-version`, as in `1.10`. If the minor
	// version is omitted, it defaults to zero. If the entire version field
	// is empty, the major version is derived from the package name, as
	// outlined below. If the field is not empty, the version in the package
	// name will be verified to be consistent with what is provided here.
	// The versioning schema uses semantic versioning (http://semver.org)
	// where the major version number indicates a breaking change and the
	// minor version an additive, non-breaking change. Both version numbers
	// are signals to users what to expect from different versions, and
	// should be carefully chosen based on the product plan. The major
	// version is also reflected in the package name of the interface, which
	// must end in `v`, as in `google.feature.v1`. For major versions 0 and
	// 1, the suffix can be omitted. Zero major versions must only be used
	// for experimental, non-GA interfaces.
	Version string `json:"version,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Methods") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Methods") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Api) MarshalJSON() ([]byte, error) {
	type NoMethod Api
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AuthProvider: Configuration for an authentication provider, including
// support for JSON Web Token (JWT)
// (https://tools.ietf.org/html/draft-ietf-oauth-json-web-token-32).
type AuthProvider struct {
	// Audiences: The list of JWT audiences
	// (https://tools.ietf.org/html/draft-ietf-oauth-json-web-token-32#section-4.1.3).
	// that are allowed to access. A JWT containing any of these audiences
	// will be accepted. When this setting is absent, JWTs with audiences: -
	// "https://[service.name]/[google.protobuf.Api.name]" -
	// "https://[service.name]/" will be accepted. For example, if no
	// audiences are in the setting, LibraryService API will accept JWTs
	// with the following audiences: -
	// https://library-example.googleapis.com/google.example.library.v1.LibraryService
	// - https://library-example.googleapis.com/ Example: audiences:
	// bookstore_android.apps.googleusercontent.com,
	// bookstore_web.apps.googleusercontent.com
	Audiences string `json:"audiences,omitempty"`

	// AuthorizationUrl: Redirect URL if JWT token is required but not
	// present or is expired. Implement authorizationUrl of
	// securityDefinitions in OpenAPI spec.
	AuthorizationUrl string `json:"authorizationUrl,omitempty"`

	// Id: The unique identifier of the auth provider. It will be referred
	// to by `AuthRequirement.provider_id`. Example: "bookstore_auth".
	Id string `json:"id,omitempty"`

	// Issuer: Identifies the principal that issued the JWT. See
	// https://tools.ietf.org/html/draft-ietf-oauth-json-web-token-32#section-4.1.1
	// Usually a URL or an email address. Example:
	// https://securetoken.google.com Example:
	// 1234567-compute@developer.gserviceaccount.com
	Issuer string `json:"issuer,omitempty"`

	// JwksUri: URL of the provider's public key set to validate signature
	// of the JWT. See OpenID Discovery
	// (https://openid.net/specs/openid-connect-discovery-1_0.html#ProviderMetadata).
	// Optional if the key set document: - can be retrieved from OpenID
	// Discovery
	// (https://openid.net/specs/openid-connect-discovery-1_0.html) of the
	// issuer. - can be inferred from the email domain of the issuer (e.g. a
	// Google service account). Example:
	// https://www.googleapis.com/oauth2/v1/certs
	JwksUri string `json:"jwksUri,omitempty"`

	// JwtLocations: Defines the locations to extract the JWT. JWT locations
	// can be either from HTTP headers or URL query parameters. The rule is
	// that the first match wins. The checking order is: checking all
	// headers first, then URL query parameters. If not specified, default
	// to use following 3 locations: 1) Authorization: Bearer 2)
	// x-goog-iap-jwt-assertion 3) access_token query parameter Default
	// locations can be specified as followings: jwt_locations: - header:
	// Authorization value_prefix: "Bearer " - header:
	// x-goog-iap-jwt-assertion - query: access_token
	JwtLocations []*JwtLocation `json:"jwtLocations,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Audiences") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Audiences") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AuthProvider) MarshalJSON() ([]byte, error) {
	type NoMethod AuthProvider
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AuthRequirement: User-defined authentication requirements, including
// support for JSON Web Token (JWT)
// (https://tools.ietf.org/html/draft-ietf-oauth-json-web-token-32).
type AuthRequirement struct {
	// Audiences: NOTE: This will be deprecated soon, once
	// AuthProvider.audiences is implemented and accepted in all the runtime
	// components. The list of JWT audiences
	// (https://tools.ietf.org/html/draft-ietf-oauth-json-web-token-32#section-4.1.3).
	// that are allowed to access. A JWT containing any of these audiences
	// will be accepted. When this setting is absent, only JWTs with
	// audience "https://Service_name/API_name" will be accepted. For
	// example, if no audiences are in the setting, LibraryService API will
	// only accept JWTs with the following audience
	// "https://library-example.googleapis.com/google.example.library.v1.Libr
	// aryService". Example: audiences:
	// bookstore_android.apps.googleusercontent.com,
	// bookstore_web.apps.googleusercontent.com
	Audiences string `json:"audiences,omitempty"`

	// ProviderId: id from authentication provider. Example: provider_id:
	// bookstore_auth
	ProviderId string `json:"providerId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Audiences") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Audiences") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AuthRequirement) MarshalJSON() ([]byte, error) {
	type NoMethod AuthRequirement
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Authentication: `Authentication` defines the authentication
// configuration for API methods provided by an API service. Example:
// name: calendar.googleapis.com authentication: providers: - id:
// google_calendar_auth jwks_uri:
// https://www.googleapis.com/oauth2/v1/certs issuer:
// https://securetoken.google.com rules: - selector: "*" requirements:
// provider_id: google_calendar_auth - selector:
// google.calendar.Delegate oauth: canonical_scopes:
// https://www.googleapis.com/auth/calendar.read
type Authentication struct {
	// Providers: Defines a set of authentication providers that a service
	// supports.
	Providers []*AuthProvider `json:"providers,omitempty"`

	// Rules: A list of authentication rules that apply to individual API
	// methods. **NOTE:** All service configuration rules follow "last one
	// wins" order.
	Rules []*AuthenticationRule `json:"rules,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Providers") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Providers") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Authentication) MarshalJSON() ([]byte, error) {
	type NoMethod Authentication
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AuthenticationRule: Authentication rules for the service. By default,
// if a method has any authentication requirements, every request must
// include a valid credential matching one of the requirements. It's an
// error to include more than one kind of credential in a single
// request. If a method doesn't have any auth requirements, request
// credentials will be ignored.
type AuthenticationRule struct {
	// AllowWithoutCredential: If true, the service accepts API keys without
	// any other credential. This flag only applies to HTTP and gRPC
	// requests.
	AllowWithoutCredential bool `json:"allowWithoutCredential,omitempty"`

	// Oauth: The requirements for OAuth credentials.
	Oauth *OAuthRequirements `json:"oauth,omitempty"`

	// Requirements: Requirements for additional authentication providers.
	Requirements []*AuthRequirement `json:"requirements,omitempty"`

	// Selector: Selects the methods to which this rule applies. Refer to
	// selector for syntax details.
	Selector string `json:"selector,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "AllowWithoutCredential") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AllowWithoutCredential")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AuthenticationRule) MarshalJSON() ([]byte, error) {
	type NoMethod AuthenticationRule
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Backend: `Backend` defines the backend configuration for a service.
type Backend struct {
	// Rules: A list of API backend rules that apply to individual API
	// methods. **NOTE:** All service configuration rules follow "last one
	// wins" order.
	Rules []*BackendRule `json:"rules,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Rules") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Rules") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Backend) MarshalJSON() ([]byte, error) {
	type NoMethod Backend
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BackendRule: A backend rule provides configuration for an individual
// API element.
type BackendRule struct {
	// Address: The address of the API backend. The scheme is used to
	// determine the backend protocol and security. The following schemes
	// are accepted: SCHEME PROTOCOL SECURITY http:// HTTP None https://
	// HTTP TLS grpc:// gRPC None grpcs:// gRPC TLS It is recommended to
	// explicitly include a scheme. Leaving out the scheme may cause
	// constrasting behaviors across platforms. If the port is unspecified,
	// the default is: - 80 for schemes without TLS - 443 for schemes with
	// TLS For HTTP backends, use protocol to specify the protocol version.
	Address string `json:"address,omitempty"`

	// Deadline: The number of seconds to wait for a response from a
	// request. The default varies based on the request protocol and
	// deployment environment.
	Deadline float64 `json:"deadline,omitempty"`

	// DisableAuth: When disable_auth is true, a JWT ID token won't be
	// generated and the original "Authorization" HTTP header will be
	// preserved. If the header is used to carry the original token and is
	// expected by the backend, this field must be set to true to preserve
	// the header.
	DisableAuth bool `json:"disableAuth,omitempty"`

	// JwtAudience: The JWT audience is used when generating a JWT ID token
	// for the backend. This ID token will be added in the HTTP
	// "authorization" header, and sent to the backend.
	JwtAudience string `json:"jwtAudience,omitempty"`

	// OperationDeadline: The number of seconds to wait for the completion
	// of a long running operation. The default is no deadline.
	OperationDeadline float64 `json:"operationDeadline,omitempty"`

	// Possible values:
	//   "PATH_TRANSLATION_UNSPECIFIED"
	//   "CONSTANT_ADDRESS" - Use the backend address as-is, with no
	// modification to the path. If the URL pattern contains variables, the
	// variable names and values will be appended to the query string. If a
	// query string parameter and a URL pattern variable have the same name,
	// this may result in duplicate keys in the query string. # Examples
	// Given the following operation config: Method path:
	// /api/company/{cid}/user/{uid} Backend address:
	// https://example.cloudfunctions.net/getUser Requests to the following
	// request paths will call the backend at the translated path: Request
	// path: /api/company/widgetworks/user/johndoe Translated:
	// https://example.cloudfunctions.net/getUser?cid=widgetworks&uid=johndoe
	// Request path: /api/company/widgetworks/user/johndoe?timezone=EST
	// Translated:
	// https://example.cloudfunctions.net/getUser?timezone=EST&cid=widgetworks&uid=johndoe
	//   "APPEND_PATH_TO_ADDRESS" - The request path will be appended to the
	// backend address. # Examples Given the following operation config:
	// Method path: /api/company/{cid}/user/{uid} Backend address:
	// https://example.appspot.com Requests to the following request paths
	// will call the backend at the translated path: Request path:
	// /api/company/widgetworks/user/johndoe Translated:
	// https://example.appspot.com/api/company/widgetworks/user/johndoe
	// Request path: /api/company/widgetworks/user/johndoe?timezone=EST
	// Translated:
	// https://example.appspot.com/api/company/widgetworks/user/johndoe?timezone=EST
	PathTranslation string `json:"pathTranslation,omitempty"`

	// Protocol: The protocol used for sending a request to the backend. The
	// supported values are "http/1.1" and "h2". The default value is
	// inferred from the scheme in the address field: SCHEME PROTOCOL
	// http:// http/1.1 https:// http/1.1 grpc:// h2 grpcs:// h2 For secure
	// HTTP backends (https://) that support HTTP/2, set this field to "h2"
	// for improved performance. Configuring this field to non-default
	// values is only supported for secure HTTP backends. This field will be
	// ignored for all other backends. See
	// https://www.iana.org/assignments/tls-extensiontype-values/tls-extensiontype-values.xhtml#alpn-protocol-ids
	// for more details on the supported values.
	Protocol string `json:"protocol,omitempty"`

	// Selector: Selects the methods to which this rule applies. Refer to
	// selector for syntax details.
	Selector string `json:"selector,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Address") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Address") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BackendRule) MarshalJSON() ([]byte, error) {
	type NoMethod BackendRule
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *BackendRule) UnmarshalJSON(data []byte) error {
	type NoMethod BackendRule
	var s1 struct {
		Deadline          gensupport.JSONFloat64 `json:"deadline"`
		OperationDeadline gensupport.JSONFloat64 `json:"operationDeadline"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Deadline = float64(s1.Deadline)
	s.OperationDeadline = float64(s1.OperationDeadline)
	return nil
}

// Billing: Billing related configuration of the service. The following
// example shows how to configure monitored resources and metrics for
// billing, `consumer_destinations` is the only supported destination
// and the monitored resources need at least one label key
// `cloud.googleapis.com/location` to indicate the location of the
// billing usage, using different monitored resources between monitoring
// and billing is recommended so they can be evolved independently:
// monitored_resources: - type: library.googleapis.com/billing_branch
// labels: - key: cloud.googleapis.com/location description: |
// Predefined label to support billing location restriction. - key: city
// description: | Custom label to define the city where the library
// branch is located in. - key: name description: Custom label to define
// the name of the library branch. metrics: - name:
// library.googleapis.com/book/borrowed_count metric_kind: DELTA
// value_type: INT64 unit: "1" billing: consumer_destinations: -
// monitored_resource: library.googleapis.com/billing_branch metrics: -
// library.googleapis.com/book/borrowed_count
type Billing struct {
	// ConsumerDestinations: Billing configurations for sending metrics to
	// the consumer project. There can be multiple consumer destinations per
	// service, each one must have a different monitored resource type. A
	// metric can be used in at most one consumer destination.
	ConsumerDestinations []*BillingDestination `json:"consumerDestinations,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "ConsumerDestinations") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ConsumerDestinations") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *Billing) MarshalJSON() ([]byte, error) {
	type NoMethod Billing
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BillingDestination: Configuration of a specific billing destination
// (Currently only support bill against consumer project).
type BillingDestination struct {
	// Metrics: Names of the metrics to report to this billing destination.
	// Each name must be defined in Service.metrics section.
	Metrics []string `json:"metrics,omitempty"`

	// MonitoredResource: The monitored resource type. The type must be
	// defined in Service.monitored_resources section.
	MonitoredResource string `json:"monitoredResource,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Metrics") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Metrics") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BillingDestination) MarshalJSON() ([]byte, error) {
	type NoMethod BillingDestination
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Context: `Context` defines which contexts an API requests. Example:
// context: rules: - selector: "*" requested: -
// google.rpc.context.ProjectContext - google.rpc.context.OriginContext
// The above specifies that all methods in the API request
// `google.rpc.context.ProjectContext` and
// `google.rpc.context.OriginContext`. Available context types are
// defined in package `google.rpc.context`. This also provides mechanism
// to allowlist any protobuf message extension that can be sent in grpc
// metadata using “x-goog-ext--bin” and “x-goog-ext--jspb”
// format. For example, list any service specific protobuf types that
// can appear in grpc metadata as follows in your yaml file: Example:
// context: rules: - selector:
// "google.example.library.v1.LibraryService.CreateBook"
// allowed_request_extensions: - google.foo.v1.NewExtension
// allowed_response_extensions: - google.foo.v1.NewExtension You can
// also specify extension ID instead of fully qualified extension name
// here.
type Context struct {
	// Rules: A list of RPC context rules that apply to individual API
	// methods. **NOTE:** All service configuration rules follow "last one
	// wins" order.
	Rules []*ContextRule `json:"rules,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Rules") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Rules") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Context) MarshalJSON() ([]byte, error) {
	type NoMethod Context
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ContextRule: A context rule provides information about the context
// for an individual API element.
type ContextRule struct {
	// AllowedRequestExtensions: A list of full type names or extension IDs
	// of extensions allowed in grpc side channel from client to backend.
	AllowedRequestExtensions []string `json:"allowedRequestExtensions,omitempty"`

	// AllowedResponseExtensions: A list of full type names or extension IDs
	// of extensions allowed in grpc side channel from backend to client.
	AllowedResponseExtensions []string `json:"allowedResponseExtensions,omitempty"`

	// Provided: A list of full type names of provided contexts.
	Provided []string `json:"provided,omitempty"`

	// Requested: A list of full type names of requested contexts.
	Requested []string `json:"requested,omitempty"`

	// Selector: Selects the methods to which this rule applies. Refer to
	// selector for syntax details.
	Selector string `json:"selector,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "AllowedRequestExtensions") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AllowedRequestExtensions")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *ContextRule) MarshalJSON() ([]byte, error) {
	type NoMethod ContextRule
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Control: Selects and configures the service controller used by the
// service. The service controller handles features like abuse, quota,
// billing, logging, monitoring, etc.
type Control struct {
	// Environment: The service control environment to use. If empty, no
	// control plane feature (like quota and billing) will be enabled.
	Environment string `json:"environment,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Environment") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Environment") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Control) MarshalJSON() ([]byte, error) {
	type NoMethod Control
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CustomError: Customize service error responses. For example, list any
// service specific protobuf types that can appear in error detail lists
// of error responses. Example: custom_error: types: -
// google.foo.v1.CustomError - google.foo.v1.AnotherError
type CustomError struct {
	// Rules: The list of custom error rules that apply to individual API
	// messages. **NOTE:** All service configuration rules follow "last one
	// wins" order.
	Rules []*CustomErrorRule `json:"rules,omitempty"`

	// Types: The list of custom error detail types, e.g.
	// 'google.foo.v1.CustomError'.
	Types []string `json:"types,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Rules") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Rules") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CustomError) MarshalJSON() ([]byte, error) {
	type NoMethod CustomError
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CustomErrorRule: A custom error rule.
type CustomErrorRule struct {
	// IsErrorType: Mark this message as possible payload in error response.
	// Otherwise, objects of this type will be filtered when they appear in
	// error payload.
	IsErrorType bool `json:"isErrorType,omitempty"`

	// Selector: Selects messages to which this rule applies. Refer to
	// selector for syntax details.
	Selector string `json:"selector,omitempty"`

	// ForceSendFields is a list of field names (e.g. "IsErrorType") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "IsErrorType") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CustomErrorRule) MarshalJSON() ([]byte, error) {
	type NoMethod CustomErrorRule
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CustomHttpPattern: A custom pattern is used for defining custom HTTP
// verb.
type CustomHttpPattern struct {
	// Kind: The name of this custom HTTP verb.
	Kind string `json:"kind,omitempty"`

	// Path: The path matched by this custom verb.
	Path string `json:"path,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Kind") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Kind") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CustomHttpPattern) MarshalJSON() ([]byte, error) {
	type NoMethod CustomHttpPattern
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Documentation: `Documentation` provides the information for
// describing a service. Example: documentation: summary: > The Google
// Calendar API gives access to most calendar features. pages: - name:
// Overview content: (== include google/foo/overview.md ==) - name:
// Tutorial content: (== include google/foo/tutorial.md ==) subpages; -
// name: Java content: (== include google/foo/tutorial_java.md ==)
// rules: - selector: google.calendar.Calendar.Get description: > ... -
// selector: google.calendar.Calendar.Put description: > ...
// Documentation is provided in markdown syntax. In addition to standard
// markdown features, definition lists, tables and fenced code blocks
// are supported. Section headers can be provided and are interpreted
// relative to the section nesting of the context where a documentation
// fragment is embedded. Documentation from the IDL is merged with
// documentation defined via the config at normalization time, where
// documentation provided by config rules overrides IDL provided. A
// number of constructs specific to the API platform are supported in
// documentation text. In order to reference a proto element, the
// following notation can be used: [fully.qualified.proto.name][] To
// override the display text used for the link, this can be used:
// [display text][fully.qualified.proto.name] Text can be excluded from
// doc using the following notation: (-- internal comment --) A few
// directives are available in documentation. Note that directives must
// appear on a single line to be properly identified. The `include`
// directive includes a markdown file from an external source: (==
// include path/to/file ==) The `resource_for` directive marks a message
// to be the resource of a collection in REST view. If it is not
// specified, tools attempt to infer the resource from the operations in
// a collection: (== resource_for v1.shelves.books ==) The directive
// `suppress_warning` does not directly affect documentation and is
// documented together with service config validation.
type Documentation struct {
	// DocumentationRootUrl: The URL to the root of documentation.
	DocumentationRootUrl string `json:"documentationRootUrl,omitempty"`

	// Overview: Declares a single overview page. For example:
	// documentation: summary: ... overview: (== include overview.md ==)
	// This is a shortcut for the following declaration (using pages style):
	// documentation: summary: ... pages: - name: Overview content: (==
	// include overview.md ==) Note: you cannot specify both `overview`
	// field and `pages` field.
	Overview string `json:"overview,omitempty"`

	// Pages: The top level pages for the documentation set.
	Pages []*Page `json:"pages,omitempty"`

	// Rules: A list of documentation rules that apply to individual API
	// elements. **NOTE:** All service configuration rules follow "last one
	// wins" order.
	Rules []*DocumentationRule `json:"rules,omitempty"`

	// ServiceRootUrl: Specifies the service root url if the default one
	// (the service name from the yaml file) is not suitable. This can be
	// seen in any fully specified service urls as well as sections that
	// show a base that other urls are relative to.
	ServiceRootUrl string `json:"serviceRootUrl,omitempty"`

	// Summary: A short description of what the service does. The summary
	// must be plain text. It becomes the overview of the service displayed
	// in Google Cloud Console. NOTE: This field is equivalent to the
	// standard field `description`.
	Summary string `json:"summary,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "DocumentationRootUrl") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DocumentationRootUrl") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *Documentation) MarshalJSON() ([]byte, error) {
	type NoMethod Documentation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DocumentationRule: A documentation rule provides information about
// individual API elements.
type DocumentationRule struct {
	// DeprecationDescription: Deprecation description of the selected
	// element(s). It can be provided if an element is marked as
	// `deprecated`.
	DeprecationDescription string `json:"deprecationDescription,omitempty"`

	// Description: Description of the selected proto element (e.g. a
	// message, a method, a 'service' definition, or a field). Defaults to
	// leading & trailing comments taken from the proto source definition of
	// the proto element.
	Description string `json:"description,omitempty"`

	// Selector: The selector is a comma-separated list of patterns for any
	// element such as a method, a field, an enum value. Each pattern is a
	// qualified name of the element which may end in "*", indicating a
	// wildcard. Wildcards are only allowed at the end and for a whole
	// component of the qualified name, i.e. "foo.*" is ok, but not "foo.b*"
	// or "foo.*.bar". A wildcard will match one or more components. To
	// specify a default for all applicable elements, the whole pattern "*"
	// is used.
	Selector string `json:"selector,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "DeprecationDescription") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DeprecationDescription")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *DocumentationRule) MarshalJSON() ([]byte, error) {
	type NoMethod DocumentationRule
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Empty: A generic empty message that you can re-use to avoid defining
// duplicated empty messages in your APIs. A typical example is to use
// it as the request or the response type of an API method. For
// instance: service Foo { rpc Bar(google.protobuf.Empty) returns
// (google.protobuf.Empty); } The JSON representation for `Empty` is
// empty JSON object `{}`.
type Empty struct {
}

// Endpoint: `Endpoint` describes a network address of a service that
// serves a set of APIs. It is commonly known as a service endpoint. A
// service may expose any number of service endpoints, and all service
// endpoints share the same service definition, such as quota limits and
// monitoring metrics. Example: type: google.api.Service name:
// library-example.googleapis.com endpoints: # Declares network address
// `https://library-example.googleapis.com` # for service
// `library-example.googleapis.com`. The `https` scheme # is implicit
// for all service endpoints. Other schemes may be # supported in the
// future. - name: library-example.googleapis.com allow_cors: false -
// name: content-staging-library-example.googleapis.com # Allows HTTP
// OPTIONS calls to be passed to the API frontend, for it # to decide
// whether the subsequent cross-origin request is allowed # to proceed.
// allow_cors: true
type Endpoint struct {
	// AllowCors: Allowing CORS
	// (https://en.wikipedia.org/wiki/Cross-origin_resource_sharing), aka
	// cross-domain traffic, would allow the backends served from this
	// endpoint to receive and respond to HTTP OPTIONS requests. The
	// response will be used by the browser to determine whether the
	// subsequent cross-origin request is allowed to proceed.
	AllowCors bool `json:"allowCors,omitempty"`

	// Name: The canonical name of this endpoint.
	Name string `json:"name,omitempty"`

	// Target: The specification of an Internet routable address of API
	// frontend that will handle requests to this API Endpoint
	// (https://cloud.google.com/apis/design/glossary). It should be either
	// a valid IPv4 address or a fully-qualified domain name. For example,
	// "8.8.8.8" or "myservice.appspot.com".
	Target string `json:"target,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AllowCors") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AllowCors") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Endpoint) MarshalJSON() ([]byte, error) {
	type NoMethod Endpoint
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Enum: Enum type definition.
type Enum struct {
	// Enumvalue: Enum value definitions.
	Enumvalue []*EnumValue `json:"enumvalue,omitempty"`

	// Name: Enum type name.
	Name string `json:"name,omitempty"`

	// Options: Protocol buffer options.
	Options []*Option `json:"options,omitempty"`

	// SourceContext: The source context.
	SourceContext *SourceContext `json:"sourceContext,omitempty"`

	// Syntax: The source syntax.
	//
	// Possible values:
	//   "SYNTAX_PROTO2" - Syntax `proto2`.
	//   "SYNTAX_PROTO3" - Syntax `proto3`.
	Syntax string `json:"syntax,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Enumvalue") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Enumvalue") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Enum) MarshalJSON() ([]byte, error) {
	type NoMethod Enum
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// EnumValue: Enum value definition.
type EnumValue struct {
	// Name: Enum value name.
	Name string `json:"name,omitempty"`

	// Number: Enum value number.
	Number int64 `json:"number,omitempty"`

	// Options: Protocol buffer options.
	Options []*Option `json:"options,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *EnumValue) MarshalJSON() ([]byte, error) {
	type NoMethod EnumValue
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Field: A single field of a message type.
type Field struct {
	// Cardinality: The field cardinality.
	//
	// Possible values:
	//   "CARDINALITY_UNKNOWN" - For fields with unknown cardinality.
	//   "CARDINALITY_OPTIONAL" - For optional fields.
	//   "CARDINALITY_REQUIRED" - For required fields. Proto2 syntax only.
	//   "CARDINALITY_REPEATED" - For repeated fields.
	Cardinality string `json:"cardinality,omitempty"`

	// DefaultValue: The string value of the default value of this field.
	// Proto2 syntax only.
	DefaultValue string `json:"defaultValue,omitempty"`

	// JsonName: The field JSON name.
	JsonName string `json:"jsonName,omitempty"`

	// Kind: The field type.
	//
	// Possible values:
	//   "TYPE_UNKNOWN" - Field type unknown.
	//   "TYPE_DOUBLE" - Field type double.
	//   "TYPE_FLOAT" - Field type float.
	//   "TYPE_INT64" - Field type int64.
	//   "TYPE_UINT64" - Field type uint64.
	//   "TYPE_INT32" - Field type int32.
	//   "TYPE_FIXED64" - Field type fixed64.
	//   "TYPE_FIXED32" - Field type fixed32.
	//   "TYPE_BOOL" - Field type bool.
	//   "TYPE_STRING" - Field type string.
	//   "TYPE_GROUP" - Field type group. Proto2 syntax only, and
	// deprecated.
	//   "TYPE_MESSAGE" - Field type message.
	//   "TYPE_BYTES" - Field type bytes.
	//   "TYPE_UINT32" - Field type uint32.
	//   "TYPE_ENUM" - Field type enum.
	//   "TYPE_SFIXED32" - Field type sfixed32.
	//   "TYPE_SFIXED64" - Field type sfixed64.
	//   "TYPE_SINT32" - Field type sint32.
	//   "TYPE_SINT64" - Field type sint64.
	Kind string `json:"kind,omitempty"`

	// Name: The field name.
	Name string `json:"name,omitempty"`

	// Number: The field number.
	Number int64 `json:"number,omitempty"`

	// OneofIndex: The index of the field type in `Type.oneofs`, for message
	// or enumeration types. The first type has index 1; zero means the type
	// is not in the list.
	OneofIndex int64 `json:"oneofIndex,omitempty"`

	// Options: The protocol buffer options.
	Options []*Option `json:"options,omitempty"`

	// Packed: Whether to use alternative packed wire representation.
	Packed bool `json:"packed,omitempty"`

	// TypeUrl: The field type URL, without the scheme, for message or
	// enumeration types. Example:
	// "type.googleapis.com/google.protobuf.Timestamp".
	TypeUrl string `json:"typeUrl,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Cardinality") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Cardinality") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Field) MarshalJSON() ([]byte, error) {
	type NoMethod Field
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Http: Defines the HTTP configuration for an API service. It contains
// a list of HttpRule, each specifying the mapping of an RPC method to
// one or more HTTP REST API methods.
type Http struct {
	// FullyDecodeReservedExpansion: When set to true, URL path parameters
	// will be fully URI-decoded except in cases of single segment matches
	// in reserved expansion, where "%2F" will be left encoded. The default
	// behavior is to not decode RFC 6570 reserved characters in multi
	// segment matches.
	FullyDecodeReservedExpansion bool `json:"fullyDecodeReservedExpansion,omitempty"`

	// Rules: A list of HTTP configuration rules that apply to individual
	// API methods. **NOTE:** All service configuration rules follow "last
	// one wins" order.
	Rules []*HttpRule `json:"rules,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "FullyDecodeReservedExpansion") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "FullyDecodeReservedExpansion") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Http) MarshalJSON() ([]byte, error) {
	type NoMethod Http
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HttpRule: # gRPC Transcoding gRPC Transcoding is a feature for
// mapping between a gRPC method and one or more HTTP REST endpoints. It
// allows developers to build a single API service that supports both
// gRPC APIs and REST APIs. Many systems, including Google APIs
// (https://github.com/googleapis/googleapis), Cloud Endpoints
// (https://cloud.google.com/endpoints), gRPC Gateway
// (https://github.com/grpc-ecosystem/grpc-gateway), and Envoy
// (https://github.com/envoyproxy/envoy) proxy support this feature and
// use it for large scale production services. `HttpRule` defines the
// schema of the gRPC/REST mapping. The mapping specifies how different
// portions of the gRPC request message are mapped to the URL path, URL
// query parameters, and HTTP request body. It also controls how the
// gRPC response message is mapped to the HTTP response body. `HttpRule`
// is typically specified as an `google.api.http` annotation on the gRPC
// method. Each mapping specifies a URL path template and an HTTP
// method. The path template may refer to one or more fields in the gRPC
// request message, as long as each field is a non-repeated field with a
// primitive (non-message) type. The path template controls how fields
// of the request message are mapped to the URL path. Example: service
// Messaging { rpc GetMessage(GetMessageRequest) returns (Message) {
// option (google.api.http) = { get: "/v1/{name=messages/*}" }; } }
// message GetMessageRequest { string name = 1; // Mapped to URL path. }
// message Message { string text = 1; // The resource content. } This
// enables an HTTP REST to gRPC mapping as below: HTTP | gRPC
// -----|----- `GET /v1/messages/123456` | `GetMessage(name:
// "messages/123456")` Any fields in the request message which are not
// bound by the path template automatically become HTTP query parameters
// if there is no HTTP request body. For example: service Messaging {
// rpc GetMessage(GetMessageRequest) returns (Message) { option
// (google.api.http) = { get:"/v1/messages/{message_id}" }; } } message
// GetMessageRequest { message SubMessage { string subfield = 1; }
// string message_id = 1; // Mapped to URL path. int64 revision = 2; //
// Mapped to URL query parameter `revision`. SubMessage sub = 3; //
// Mapped to URL query parameter `sub.subfield`. } This enables a HTTP
// JSON to RPC mapping as below: HTTP | gRPC -----|----- `GET
// /v1/messages/123456?revision=2&sub.subfield=foo` |
// `GetMessage(message_id: "123456" revision: 2 sub:
// SubMessage(subfield: "foo"))` Note that fields which are mapped to
// URL query parameters must have a primitive type or a repeated
// primitive type or a non-repeated message type. In the case of a
// repeated type, the parameter can be repeated in the URL as
// `...?param=A&param=B`. In the case of a message type, each field of
// the message is mapped to a separate parameter, such as
// `...?foo.a=A&foo.b=B&foo.c=C`. For HTTP methods that allow a request
// body, the `body` field specifies the mapping. Consider a REST update
// method on the message resource collection: service Messaging { rpc
// UpdateMessage(UpdateMessageRequest) returns (Message) { option
// (google.api.http) = { patch: "/v1/messages/{message_id}" body:
// "message" }; } } message UpdateMessageRequest { string message_id =
// 1; // mapped to the URL Message message = 2; // mapped to the body }
// The following HTTP JSON to RPC mapping is enabled, where the
// representation of the JSON in the request body is determined by
// protos JSON encoding: HTTP | gRPC -----|----- `PATCH
// /v1/messages/123456 { "text": "Hi!" }` | `UpdateMessage(message_id:
// "123456" message { text: "Hi!" })` The special name `*` can be used
// in the body mapping to define that every field not bound by the path
// template should be mapped to the request body. This enables the
// following alternative definition of the update method: service
// Messaging { rpc UpdateMessage(Message) returns (Message) { option
// (google.api.http) = { patch: "/v1/messages/{message_id}" body: "*" };
// } } message Message { string message_id = 1; string text = 2; } The
// following HTTP JSON to RPC mapping is enabled: HTTP | gRPC
// -----|----- `PATCH /v1/messages/123456 { "text": "Hi!" }` |
// `UpdateMessage(message_id: "123456" text: "Hi!")` Note that when
// using `*` in the body mapping, it is not possible to have HTTP
// parameters, as all fields not bound by the path end in the body. This
// makes this option more rarely used in practice when defining REST
// APIs. The common usage of `*` is in custom methods which don't use
// the URL at all for transferring data. It is possible to define
// multiple HTTP methods for one RPC by using the `additional_bindings`
// option. Example: service Messaging { rpc
// GetMessage(GetMessageRequest) returns (Message) { option
// (google.api.http) = { get: "/v1/messages/{message_id}"
// additional_bindings { get:
// "/v1/users/{user_id}/messages/{message_id}" } }; } } message
// GetMessageRequest { string message_id = 1; string user_id = 2; } This
// enables the following two alternative HTTP JSON to RPC mappings: HTTP
// | gRPC -----|----- `GET /v1/messages/123456` |
// `GetMessage(message_id: "123456")` `GET /v1/users/me/messages/123456`
// | `GetMessage(user_id: "me" message_id: "123456")` ## Rules for HTTP
// mapping 1. Leaf request fields (recursive expansion nested messages
// in the request message) are classified into three categories: -
// Fields referred by the path template. They are passed via the URL
// path. - Fields referred by the HttpRule.body. They are passed via the
// HTTP request body. - All other fields are passed via the URL query
// parameters, and the parameter name is the field path in the request
// message. A repeated field can be represented as multiple query
// parameters under the same name. 2. If HttpRule.body is "*", there is
// no URL query parameter, all fields are passed via URL path and HTTP
// request body. 3. If HttpRule.body is omitted, there is no HTTP
// request body, all fields are passed via URL path and URL query
// parameters. ### Path template syntax Template = "/" Segments [ Verb ]
// ; Segments = Segment { "/" Segment } ; Segment = "*" | "**" | LITERAL
// | Variable ; Variable = "{" FieldPath [ "=" Segments ] "}" ;
// FieldPath = IDENT { "." IDENT } ; Verb = ":" LITERAL ; The syntax `*`
// matches a single URL path segment. The syntax `**` matches zero or
// more URL path segments, which must be the last part of the URL path
// except the `Verb`. The syntax `Variable` matches part of the URL path
// as specified by its template. A variable template must not contain
// other variables. If a variable matches a single path segment, its
// template may be omitted, e.g. `{var}` is equivalent to `{var=*}`. The
// syntax `LITERAL` matches literal text in the URL path. If the
// `LITERAL` contains any reserved character, such characters should be
// percent-encoded before the matching. If a variable contains exactly
// one path segment, such as "{var}" or "{var=*}", when such a
// variable is expanded into a URL path on the client side, all
// characters except `[-_.~0-9a-zA-Z]` are percent-encoded. The server
// side does the reverse decoding. Such variables show up in the
// Discovery Document
// (https://developers.google.com/discovery/v1/reference/apis) as
// `{var}`. If a variable contains multiple path segments, such as
// "{var=foo/*}" or "{var=**}", when such a variable is expanded
// into a URL path on the client side, all characters except
// `[-_.~/0-9a-zA-Z]` are percent-encoded. The server side does the
// reverse decoding, except "%2F" and "%2f" are left unchanged. Such
// variables show up in the Discovery Document
// (https://developers.google.com/discovery/v1/reference/apis) as
// `{+var}`. ## Using gRPC API Service Configuration gRPC API Service
// Configuration (service config) is a configuration language for
// configuring a gRPC service to become a user-facing product. The
// service config is simply the YAML representation of the
// `google.api.Service` proto message. As an alternative to annotating
// your proto file, you can configure gRPC transcoding in your service
// config YAML files. You do this by specifying a `HttpRule` that maps
// the gRPC method to a REST endpoint, achieving the same effect as the
// proto annotation. This can be particularly useful if you have a proto
// that is reused in multiple services. Note that any transcoding
// specified in the service config will override any matching
// transcoding configuration in the proto. Example: http: rules: #
// Selects a gRPC method and applies HttpRule to it. - selector:
// example.v1.Messaging.GetMessage get:
// /v1/messages/{message_id}/{sub.subfield} ## Special notes When gRPC
// Transcoding is used to map a gRPC to JSON REST endpoints, the proto
// to JSON conversion must follow the proto3 specification
// (https://developers.google.com/protocol-buffers/docs/proto3#json).
// While the single segment variable follows the semantics of RFC 6570
// (https://tools.ietf.org/html/rfc6570) Section 3.2.2 Simple String
// Expansion, the multi segment variable **does not** follow RFC 6570
// Section 3.2.3 Reserved Expansion. The reason is that the Reserved
// Expansion does not expand special characters like `?` and `#`, which
// would lead to invalid URLs. As the result, gRPC Transcoding uses a
// custom encoding for multi segment variables. The path variables
// **must not** refer to any repeated or mapped field, because client
// libraries are not capable of handling such variable expansion. The
// path variables **must not** capture the leading "/" character. The
// reason is that the most common use case "{var}" does not capture the
// leading "/" character. For consistency, all path variables must share
// the same behavior. Repeated message fields must not be mapped to URL
// query parameters, because no client library can support such
// complicated mapping. If an API needs to use a JSON array for request
// or response body, it can map the request or response body to a
// repeated field. However, some gRPC Transcoding implementations may
// not support this feature.
type HttpRule struct {
	// AdditionalBindings: Additional HTTP bindings for the selector. Nested
	// bindings must not contain an `additional_bindings` field themselves
	// (that is, the nesting may only be one level deep).
	AdditionalBindings []*HttpRule `json:"additionalBindings,omitempty"`

	// Body: The name of the request field whose value is mapped to the HTTP
	// request body, or `*` for mapping all request fields not captured by
	// the path pattern to the HTTP body, or omitted for not having any HTTP
	// request body. NOTE: the referred field must be present at the
	// top-level of the request message type.
	Body string `json:"body,omitempty"`

	// Custom: The custom pattern is used for specifying an HTTP method that
	// is not included in the `pattern` field, such as HEAD, or "*" to leave
	// the HTTP method unspecified for this rule. The wild-card rule is
	// useful for services that provide content to Web (HTML) clients.
	Custom *CustomHttpPattern `json:"custom,omitempty"`

	// Delete: Maps to HTTP DELETE. Used for deleting a resource.
	Delete string `json:"delete,omitempty"`

	// Get: Maps to HTTP GET. Used for listing and getting information about
	// resources.
	Get string `json:"get,omitempty"`

	// Patch: Maps to HTTP PATCH. Used for updating a resource.
	Patch string `json:"patch,omitempty"`

	// Post: Maps to HTTP POST. Used for creating a resource or performing
	// an action.
	Post string `json:"post,omitempty"`

	// Put: Maps to HTTP PUT. Used for replacing a resource.
	Put string `json:"put,omitempty"`

	// ResponseBody: Optional. The name of the response field whose value is
	// mapped to the HTTP response body. When omitted, the entire response
	// message will be used as the HTTP response body. NOTE: The referred
	// field must be present at the top-level of the response message type.
	ResponseBody string `json:"responseBody,omitempty"`

	// Selector: Selects a method to which this rule applies. Refer to
	// selector for syntax details.
	Selector string `json:"selector,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AdditionalBindings")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AdditionalBindings") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *HttpRule) MarshalJSON() ([]byte, error) {
	type NoMethod HttpRule
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// JwtLocation: Specifies a location to extract JWT from an API request.
type JwtLocation struct {
	// Header: Specifies HTTP header name to extract JWT token.
	Header string `json:"header,omitempty"`

	// Query: Specifies URL query parameter name to extract JWT token.
	Query string `json:"query,omitempty"`

	// ValuePrefix: The value prefix. The value format is
	// "value_prefix{token}" Only applies to "in" header type. Must be empty
	// for "in" query type. If not empty, the header value has to match
	// (case sensitive) this prefix. If not matched, JWT will not be
	// extracted. If matched, JWT will be extracted after the prefix is
	// removed. For example, for "Authorization: Bearer {JWT}",
	// value_prefix="Bearer " with a space at the end.
	ValuePrefix string `json:"valuePrefix,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Header") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Header") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *JwtLocation) MarshalJSON() ([]byte, error) {
	type NoMethod JwtLocation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// LabelDescriptor: A description of a label.
type LabelDescriptor struct {
	// Description: A human-readable description for the label.
	Description string `json:"description,omitempty"`

	// Key: The label key.
	Key string `json:"key,omitempty"`

	// ValueType: The type of data that can be assigned to the label.
	//
	// Possible values:
	//   "STRING" - A variable-length string. This is the default.
	//   "BOOL" - Boolean; true or false.
	//   "INT64" - A 64-bit signed integer.
	ValueType string `json:"valueType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Description") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *LabelDescriptor) MarshalJSON() ([]byte, error) {
	type NoMethod LabelDescriptor
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// LogDescriptor: A description of a log type. Example in YAML format: -
// name: library.googleapis.com/activity_history description: The
// history of borrowing and returning library items. display_name:
// Activity labels: - key: /customer_id description: Identifier of a
// library customer
type LogDescriptor struct {
	// Description: A human-readable description of this log. This
	// information appears in the documentation and can contain details.
	Description string `json:"description,omitempty"`

	// DisplayName: The human-readable name for this log. This information
	// appears on the user interface and should be concise.
	DisplayName string `json:"displayName,omitempty"`

	// Labels: The set of labels that are available to describe a specific
	// log entry. Runtime requests that contain labels not specified here
	// are considered invalid.
	Labels []*LabelDescriptor `json:"labels,omitempty"`

	// Name: The name of the log. It must be less than 512 characters long
	// and can include the following characters: upper- and lower-case
	// alphanumeric characters [A-Za-z0-9], and punctuation characters
	// including slash, underscore, hyphen, period [/_-.].
	Name string `json:"name,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Description") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *LogDescriptor) MarshalJSON() ([]byte, error) {
	type NoMethod LogDescriptor
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Logging: Logging configuration of the service. The following example
// shows how to configure logs to be sent to the producer and consumer
// projects. In the example, the `activity_history` log is sent to both
// the producer and consumer projects, whereas the `purchase_history`
// log is only sent to the producer project. monitored_resources: -
// type: library.googleapis.com/branch labels: - key: /city description:
// The city where the library branch is located in. - key: /name
// description: The name of the branch. logs: - name: activity_history
// labels: - key: /customer_id - name: purchase_history logging:
// producer_destinations: - monitored_resource:
// library.googleapis.com/branch logs: - activity_history -
// purchase_history consumer_destinations: - monitored_resource:
// library.googleapis.com/branch logs: - activity_history
type Logging struct {
	// ConsumerDestinations: Logging configurations for sending logs to the
	// consumer project. There can be multiple consumer destinations, each
	// one must have a different monitored resource type. A log can be used
	// in at most one consumer destination.
	ConsumerDestinations []*LoggingDestination `json:"consumerDestinations,omitempty"`

	// ProducerDestinations: Logging configurations for sending logs to the
	// producer project. There can be multiple producer destinations, each
	// one must have a different monitored resource type. A log can be used
	// in at most one producer destination.
	ProducerDestinations []*LoggingDestination `json:"producerDestinations,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "ConsumerDestinations") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ConsumerDestinations") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *Logging) MarshalJSON() ([]byte, error) {
	type NoMethod Logging
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// LoggingDestination: Configuration of a specific logging destination
// (the producer project or the consumer project).
type LoggingDestination struct {
	// Logs: Names of the logs to be sent to this destination. Each name
	// must be defined in the Service.logs section. If the log name is not a
	// domain scoped name, it will be automatically prefixed with the
	// service name followed by "/".
	Logs []string `json:"logs,omitempty"`

	// MonitoredResource: The monitored resource type. The type must be
	// defined in the Service.monitored_resources section.
	MonitoredResource string `json:"monitoredResource,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Logs") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Logs") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *LoggingDestination) MarshalJSON() ([]byte, error) {
	type NoMethod LoggingDestination
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Method: Method represents a method of an API interface.
type Method struct {
	// Name: The simple name of this method.
	Name string `json:"name,omitempty"`

	// Options: Any metadata attached to the method.
	Options []*Option `json:"options,omitempty"`

	// RequestStreaming: If true, the request is streamed.
	RequestStreaming bool `json:"requestStreaming,omitempty"`

	// RequestTypeUrl: A URL of the input message type.
	RequestTypeUrl string `json:"requestTypeUrl,omitempty"`

	// ResponseStreaming: If true, the response is streamed.
	ResponseStreaming bool `json:"responseStreaming,omitempty"`

	// ResponseTypeUrl: The URL of the output message type.
	ResponseTypeUrl string `json:"responseTypeUrl,omitempty"`

	// Syntax: The source syntax of this method.
	//
	// Possible values:
	//   "SYNTAX_PROTO2" - Syntax `proto2`.
	//   "SYNTAX_PROTO3" - Syntax `proto3`.
	Syntax string `json:"syntax,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Method) MarshalJSON() ([]byte, error) {
	type NoMethod Method
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// MetricDescriptor: Defines a metric type and its schema. Once a metric
// descriptor is created, deleting or altering it stops data collection
// and makes the metric type's existing data unusable.
type MetricDescriptor struct {
	// Description: A detailed description of the metric, which can be used
	// in documentation.
	Description string `json:"description,omitempty"`

	// DisplayName: A concise name for the metric, which can be displayed in
	// user interfaces. Use sentence case without an ending period, for
	// example "Request count". This field is optional but it is recommended
	// to be set for any metrics associated with user-visible concepts, such
	// as Quota.
	DisplayName string `json:"displayName,omitempty"`

	// Labels: The set of labels that can be used to describe a specific
	// instance of this metric type. For example, the
	// `appengine.googleapis.com/http/server/response_latencies` metric type
	// has a label for the HTTP response code, `response_code`, so you can
	// look at latencies for successful responses or just for responses that
	// failed.
	Labels []*LabelDescriptor `json:"labels,omitempty"`

	// LaunchStage: Optional. The launch stage of the metric definition.
	//
	// Possible values:
	//   "LAUNCH_STAGE_UNSPECIFIED" - Do not use this default value.
	//   "UNIMPLEMENTED" - The feature is not yet implemented. Users can not
	// use it.
	//   "PRELAUNCH" - Prelaunch features are hidden from users and are only
	// visible internally.
	//   "EARLY_ACCESS" - Early Access features are limited to a closed
	// group of testers. To use these features, you must sign up in advance
	// and sign a Trusted Tester agreement (which includes confidentiality
	// provisions). These features may be unstable, changed in
	// backward-incompatible ways, and are not guaranteed to be released.
	//   "ALPHA" - Alpha is a limited availability test for releases before
	// they are cleared for widespread use. By Alpha, all significant design
	// issues are resolved and we are in the process of verifying
	// functionality. Alpha customers need to apply for access, agree to
	// applicable terms, and have their projects allowlisted. Alpha releases
	// don’t have to be feature complete, no SLAs are provided, and there
	// are no technical support obligations, but they will be far enough
	// along that customers can actually use them in test environments or
	// for limited-use tests -- just like they would in normal production
	// cases.
	//   "BETA" - Beta is the point at which we are ready to open a release
	// for any customer to use. There are no SLA or technical support
	// obligations in a Beta release. Products will be complete from a
	// feature perspective, but may have some open outstanding issues. Beta
	// releases are suitable for limited production use cases.
	//   "GA" - GA features are open to all developers and are considered
	// stable and fully qualified for production use.
	//   "DEPRECATED" - Deprecated features are scheduled to be shut down
	// and removed. For more information, see the “Deprecation Policy”
	// section of our [Terms of Service](https://cloud.google.com/terms/)
	// and the [Google Cloud Platform Subject to the Deprecation
	// Policy](https://cloud.google.com/terms/deprecation) documentation.
	LaunchStage string `json:"launchStage,omitempty"`

	// Metadata: Optional. Metadata which can be used to guide usage of the
	// metric.
	Metadata *MetricDescriptorMetadata `json:"metadata,omitempty"`

	// MetricKind: Whether the metric records instantaneous values, changes
	// to a value, etc. Some combinations of `metric_kind` and `value_type`
	// might not be supported.
	//
	// Possible values:
	//   "METRIC_KIND_UNSPECIFIED" - Do not use this default value.
	//   "GAUGE" - An instantaneous measurement of a value.
	//   "DELTA" - The change in a value during a time interval.
	//   "CUMULATIVE" - A value accumulated over a time interval. Cumulative
	// measurements in a time series should have the same start time and
	// increasing end times, until an event resets the cumulative value to
	// zero and sets a new start time for the following points.
	MetricKind string `json:"metricKind,omitempty"`

	// MonitoredResourceTypes: Read-only. If present, then a time series,
	// which is identified partially by a metric type and a
	// MonitoredResourceDescriptor, that is associated with this metric type
	// can only be associated with one of the monitored resource types
	// listed here.
	MonitoredResourceTypes []string `json:"monitoredResourceTypes,omitempty"`

	// Name: The resource name of the metric descriptor.
	Name string `json:"name,omitempty"`

	// Type: The metric type, including its DNS name prefix. The type is not
	// URL-encoded. All user-defined metric types have the DNS name
	// `custom.googleapis.com` or `external.googleapis.com`. Metric types
	// should use a natural hierarchical grouping. For example:
	// "custom.googleapis.com/invoice/paid/amount"
	// "external.googleapis.com/prometheus/up"
	// "appengine.googleapis.com/http/server/response_latencies"
	Type string `json:"type,omitempty"`

	// Unit: The units in which the metric value is reported. It is only
	// applicable if the `value_type` is `INT64`, `DOUBLE`, or
	// `DISTRIBUTION`. The `unit` defines the representation of the stored
	// metric values. Different systems might scale the values to be more
	// easily displayed (so a value of `0.02kBy` _might_ be displayed as
	// `20By`, and a value of `3523kBy` _might_ be displayed as `3.5MBy`).
	// However, if the `unit` is `kBy`, then the value of the metric is
	// always in thousands of bytes, no matter how it might be displayed. If
	// you want a custom metric to record the exact number of CPU-seconds
	// used by a job, you can create an `INT64 CUMULATIVE` metric whose
	// `unit` is `s{CPU}` (or equivalently `1s{CPU}` or just `s`). If the
	// job uses 12,005 CPU-seconds, then the value is written as `12005`.
	// Alternatively, if you want a custom metric to record data in a more
	// granular way, you can create a `DOUBLE CUMULATIVE` metric whose
	// `unit` is `ks{CPU}`, and then write the value `12.005` (which is
	// `12005/1000`), or use `Kis{CPU}` and write `11.723` (which is
	// `12005/1024`). The supported units are a subset of The Unified Code
	// for Units of Measure (https://unitsofmeasure.org/ucum.html) standard:
	// **Basic units (UNIT)** * `bit` bit * `By` byte * `s` second * `min`
	// minute * `h` hour * `d` day * `1` dimensionless **Prefixes (PREFIX)**
	// * `k` kilo (10^3) * `M` mega (10^6) * `G` giga (10^9) * `T` tera
	// (10^12) * `P` peta (10^15) * `E` exa (10^18) * `Z` zetta (10^21) *
	// `Y` yotta (10^24) * `m` milli (10^-3) * `u` micro (10^-6) * `n` nano
	// (10^-9) * `p` pico (10^-12) * `f` femto (10^-15) * `a` atto (10^-18)
	// * `z` zepto (10^-21) * `y` yocto (10^-24) * `Ki` kibi (2^10) * `Mi`
	// mebi (2^20) * `Gi` gibi (2^30) * `Ti` tebi (2^40) * `Pi` pebi (2^50)
	// **Grammar** The grammar also includes these connectors: * `/`
	// division or ratio (as an infix operator). For examples, `kBy/{email}`
	// or `MiBy/10ms` (although you should almost never have `/s` in a
	// metric `unit`; rates should always be computed at query time from the
	// underlying cumulative or delta value). * `.` multiplication or
	// composition (as an infix operator). For examples, `GBy.d` or
	// `k{watt}.h`. The grammar for a unit is as follows: Expression =
	// Component { "." Component } { "/" Component } ; Component = ( [
	// PREFIX ] UNIT | "%" ) [ Annotation ] | Annotation | "1" ; Annotation
	// = "{" NAME "}" ; Notes: * `Annotation` is just a comment if it
	// follows a `UNIT`. If the annotation is used alone, then the unit is
	// equivalent to `1`. For examples, `{request}/s == 1/s`,
	// `By{transmitted}/s == By/s`. * `NAME` is a sequence of non-blank
	// printable ASCII characters not containing `{` or `}`. * `1`
	// represents a unitary dimensionless unit
	// (https://en.wikipedia.org/wiki/Dimensionless_quantity) of 1, such as
	// in `1/s`. It is typically used when none of the basic units are
	// appropriate. For example, "new users per day" can be represented as
	// `1/d` or `{new-users}/d` (and a metric value `5` would mean "5 new
	// users). Alternatively, "thousands of page views per day" would be
	// represented as `1000/d` or `k1/d` or `k{page_views}/d` (and a metric
	// value of `5.3` would mean "5300 page views per day"). * `%`
	// represents dimensionless value of 1/100, and annotates values giving
	// a percentage (so the metric values are typically in the range of
	// 0..100, and a metric value `3` means "3 percent"). * `10^2.%`
	// indicates a metric contains a ratio, typically in the range 0..1,
	// that will be multiplied by 100 and displayed as a percentage (so a
	// metric value `0.03` means "3 percent").
	Unit string `json:"unit,omitempty"`

	// ValueType: Whether the measurement is an integer, a floating-point
	// number, etc. Some combinations of `metric_kind` and `value_type`
	// might not be supported.
	//
	// Possible values:
	//   "VALUE_TYPE_UNSPECIFIED" - Do not use this default value.
	//   "BOOL" - The value is a boolean. This value type can be used only
	// if the metric kind is `GAUGE`.
	//   "INT64" - The value is a signed 64-bit integer.
	//   "DOUBLE" - The value is a double precision floating point number.
	//   "STRING" - The value is a text string. This value type can be used
	// only if the metric kind is `GAUGE`.
	//   "DISTRIBUTION" - The value is a `Distribution`.
	//   "MONEY" - The value is money.
	ValueType string `json:"valueType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Description") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *MetricDescriptor) MarshalJSON() ([]byte, error) {
	type NoMethod MetricDescriptor
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// MetricDescriptorMetadata: Additional annotations that can be used to
// guide the usage of a metric.
type MetricDescriptorMetadata struct {
	// IngestDelay: The delay of data points caused by ingestion. Data
	// points older than this age are guaranteed to be ingested and
	// available to be read, excluding data loss due to errors.
	IngestDelay string `json:"ingestDelay,omitempty"`

	// LaunchStage: Deprecated. Must use the MetricDescriptor.launch_stage
	// instead.
	//
	// Possible values:
	//   "LAUNCH_STAGE_UNSPECIFIED" - Do not use this default value.
	//   "UNIMPLEMENTED" - The feature is not yet implemented. Users can not
	// use it.
	//   "PRELAUNCH" - Prelaunch features are hidden from users and are only
	// visible internally.
	//   "EARLY_ACCESS" - Early Access features are limited to a closed
	// group of testers. To use these features, you must sign up in advance
	// and sign a Trusted Tester agreement (which includes confidentiality
	// provisions). These features may be unstable, changed in
	// backward-incompatible ways, and are not guaranteed to be released.
	//   "ALPHA" - Alpha is a limited availability test for releases before
	// they are cleared for widespread use. By Alpha, all significant design
	// issues are resolved and we are in the process of verifying
	// functionality. Alpha customers need to apply for access, agree to
	// applicable terms, and have their projects allowlisted. Alpha releases
	// don’t have to be feature complete, no SLAs are provided, and there
	// are no technical support obligations, but they will be far enough
	// along that customers can actually use them in test environments or
	// for limited-use tests -- just like they would in normal production
	// cases.
	//   "BETA" - Beta is the point at which we are ready to open a release
	// for any customer to use. There are no SLA or technical support
	// obligations in a Beta release. Products will be complete from a
	// feature perspective, but may have some open outstanding issues. Beta
	// releases are suitable for limited production use cases.
	//   "GA" - GA features are open to all developers and are considered
	// stable and fully qualified for production use.
	//   "DEPRECATED" - Deprecated features are scheduled to be shut down
	// and removed. For more information, see the “Deprecation Policy”
	// section of our [Terms of Service](https://cloud.google.com/terms/)
	// and the [Google Cloud Platform Subject to the Deprecation
	// Policy](https://cloud.google.com/terms/deprecation) documentation.
	LaunchStage string `json:"launchStage,omitempty"`

	// SamplePeriod: The sampling period of metric data points. For metrics
	// which are written periodically, consecutive data points are stored at
	// this time interval, excluding data loss due to errors. Metrics with a
	// higher granularity have a smaller sampling period.
	SamplePeriod string `json:"samplePeriod,omitempty"`

	// ForceSendFields is a list of field names (e.g. "IngestDelay") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "IngestDelay") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *MetricDescriptorMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod MetricDescriptorMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// MetricRule: Bind API methods to metrics. Binding a method to a metric
// causes that metric's configured quota behaviors to apply to the
// method call.
type MetricRule struct {
	// MetricCosts: Metrics to update when the selected methods are called,
	// and the associated cost applied to each metric. The key of the map is
	// the metric name, and the values are the amount increased for the
	// metric against which the quota limits are defined. The value must not
	// be negative.
	MetricCosts map[string]string `json:"metricCosts,omitempty"`

	// Selector: Selects the methods to which this rule applies. Refer to
	// selector for syntax details.
	Selector string `json:"selector,omitempty"`

	// ForceSendFields is a list of field names (e.g. "MetricCosts") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MetricCosts") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *MetricRule) MarshalJSON() ([]byte, error) {
	type NoMethod MetricRule
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Mixin: Declares an API Interface to be included in this interface.
// The including interface must redeclare all the methods from the
// included interface, but documentation and options are inherited as
// follows: - If after comment and whitespace stripping, the
// documentation string of the redeclared method is empty, it will be
// inherited from the original method. - Each annotation belonging to
// the service config (http, visibility) which is not set in the
// redeclared method will be inherited. - If an http annotation is
// inherited, the path pattern will be modified as follows. Any version
// prefix will be replaced by the version of the including interface
// plus the root path if specified. Example of a simple mixin: package
// google.acl.v1; service AccessControl { // Get the underlying ACL
// object. rpc GetAcl(GetAclRequest) returns (Acl) { option
// (google.api.http).get = "/v1/{resource=**}:getAcl"; } } package
// google.storage.v2; service Storage { // rpc GetAcl(GetAclRequest)
// returns (Acl); // Get a data record. rpc GetData(GetDataRequest)
// returns (Data) { option (google.api.http).get = "/v2/{resource=**}";
// } } Example of a mixin configuration: apis: - name:
// google.storage.v2.Storage mixins: - name: google.acl.v1.AccessControl
// The mixin construct implies that all methods in `AccessControl` are
// also declared with same name and request/response types in `Storage`.
// A documentation generator or annotation processor will see the
// effective `Storage.GetAcl` method after inheriting documentation and
// annotations as follows: service Storage { // Get the underlying ACL
// object. rpc GetAcl(GetAclRequest) returns (Acl) { option
// (google.api.http).get = "/v2/{resource=**}:getAcl"; } ... } Note how
// the version in the path pattern changed from `v1` to `v2`. If the
// `root` field in the mixin is specified, it should be a relative path
// under which inherited HTTP paths are placed. Example: apis: - name:
// google.storage.v2.Storage mixins: - name: google.acl.v1.AccessControl
// root: acls This implies the following inherited HTTP annotation:
// service Storage { // Get the underlying ACL object. rpc
// GetAcl(GetAclRequest) returns (Acl) { option (google.api.http).get =
// "/v2/acls/{resource=**}:getAcl"; } ... }
type Mixin struct {
	// Name: The fully qualified name of the interface which is included.
	Name string `json:"name,omitempty"`

	// Root: If non-empty specifies a path under which inherited HTTP paths
	// are rooted.
	Root string `json:"root,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Mixin) MarshalJSON() ([]byte, error) {
	type NoMethod Mixin
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// MonitoredResourceDescriptor: An object that describes the schema of a
// MonitoredResource object using a type name and a set of labels. For
// example, the monitored resource descriptor for Google Compute Engine
// VM instances has a type of "gce_instance" and specifies the use of
// the labels "instance_id" and "zone" to identify particular VM
// instances. Different APIs can support different monitored resource
// types. APIs generally provide a `list` method that returns the
// monitored resource descriptors used by the API.
type MonitoredResourceDescriptor struct {
	// Description: Optional. A detailed description of the monitored
	// resource type that might be used in documentation.
	Description string `json:"description,omitempty"`

	// DisplayName: Optional. A concise name for the monitored resource type
	// that might be displayed in user interfaces. It should be a Title
	// Cased Noun Phrase, without any article or other determiners. For
	// example, "Google Cloud SQL Database".
	DisplayName string `json:"displayName,omitempty"`

	// Labels: Required. A set of labels used to describe instances of this
	// monitored resource type. For example, an individual Google Cloud SQL
	// database is identified by values for the labels "database_id" and
	// "zone".
	Labels []*LabelDescriptor `json:"labels,omitempty"`

	// LaunchStage: Optional. The launch stage of the monitored resource
	// definition.
	//
	// Possible values:
	//   "LAUNCH_STAGE_UNSPECIFIED" - Do not use this default value.
	//   "UNIMPLEMENTED" - The feature is not yet implemented. Users can not
	// use it.
	//   "PRELAUNCH" - Prelaunch features are hidden from users and are only
	// visible internally.
	//   "EARLY_ACCESS" - Early Access features are limited to a closed
	// group of testers. To use these features, you must sign up in advance
	// and sign a Trusted Tester agreement (which includes confidentiality
	// provisions). These features may be unstable, changed in
	// backward-incompatible ways, and are not guaranteed to be released.
	//   "ALPHA" - Alpha is a limited availability test for releases before
	// they are cleared for widespread use. By Alpha, all significant design
	// issues are resolved and we are in the process of verifying
	// functionality. Alpha customers need to apply for access, agree to
	// applicable terms, and have their projects allowlisted. Alpha releases
	// don’t have to be feature complete, no SLAs are provided, and there
	// are no technical support obligations, but they will be far enough
	// along that customers can actually use them in test environments or
	// for limited-use tests -- just like they would in normal production
	// cases.
	//   "BETA" - Beta is the point at which we are ready to open a release
	// for any customer to use. There are no SLA or technical support
	// obligations in a Beta release. Products will be complete from a
	// feature perspective, but may have some open outstanding issues. Beta
	// releases are suitable for limited production use cases.
	//   "GA" - GA features are open to all developers and are considered
	// stable and fully qualified for production use.
	//   "DEPRECATED" - Deprecated features are scheduled to be shut down
	// and removed. For more information, see the “Deprecation Policy”
	// section of our [Terms of Service](https://cloud.google.com/terms/)
	// and the [Google Cloud Platform Subject to the Deprecation
	// Policy](https://cloud.google.com/terms/deprecation) documentation.
	LaunchStage string `json:"launchStage,omitempty"`

	// Name: Optional. The resource name of the monitored resource
	// descriptor:
	// "projects/{project_id}/monitoredResourceDescriptors/{type}" where
	// {type} is the value of the `type` field in this object and
	// {project_id} is a project ID that provides API-specific context for
	// accessing the type. APIs that do not use project information can use
	// the resource name format "monitoredResourceDescriptors/{type}".
	Name string `json:"name,omitempty"`

	// Type: Required. The monitored resource type. For example, the type
	// "cloudsql_database" represents databases in Google Cloud SQL. For a
	// list of types, see Monitoring resource types
	// (https://cloud.google.com/monitoring/api/resources) and Logging
	// resource types
	// (https://cloud.google.com/logging/docs/api/v2/resource-list).
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Description") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *MonitoredResourceDescriptor) MarshalJSON() ([]byte, error) {
	type NoMethod MonitoredResourceDescriptor
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Monitoring: Monitoring configuration of the service. The example
// below shows how to configure monitored resources and metrics for
// monitoring. In the example, a monitored resource and two metrics are
// defined. The `library.googleapis.com/book/returned_count` metric is
// sent to both producer and consumer projects, whereas the
// `library.googleapis.com/book/num_overdue` metric is only sent to the
// consumer project. monitored_resources: - type:
// library.googleapis.com/Branch display_name: "Library Branch"
// description: "A branch of a library." launch_stage: GA labels: - key:
// resource_container description: "The Cloud container (ie. project id)
// for the Branch." - key: location description: "The location of the
// library branch." - key: branch_id description: "The id of the
// branch." metrics: - name: library.googleapis.com/book/returned_count
// display_name: "Books Returned" description: "The count of books that
// have been returned." launch_stage: GA metric_kind: DELTA value_type:
// INT64 unit: "1" labels: - key: customer_id description: "The id of
// the customer." - name: library.googleapis.com/book/num_overdue
// display_name: "Books Overdue" description: "The current number of
// overdue books." launch_stage: GA metric_kind: GAUGE value_type: INT64
// unit: "1" labels: - key: customer_id description: "The id of the
// customer." monitoring: producer_destinations: - monitored_resource:
// library.googleapis.com/Branch metrics: -
// library.googleapis.com/book/returned_count consumer_destinations: -
// monitored_resource: library.googleapis.com/Branch metrics: -
// library.googleapis.com/book/returned_count -
// library.googleapis.com/book/num_overdue
type Monitoring struct {
	// ConsumerDestinations: Monitoring configurations for sending metrics
	// to the consumer project. There can be multiple consumer destinations.
	// A monitored resource type may appear in multiple monitoring
	// destinations if different aggregations are needed for different sets
	// of metrics associated with that monitored resource type. A monitored
	// resource and metric pair may only be used once in the Monitoring
	// configuration.
	ConsumerDestinations []*MonitoringDestination `json:"consumerDestinations,omitempty"`

	// ProducerDestinations: Monitoring configurations for sending metrics
	// to the producer project. There can be multiple producer destinations.
	// A monitored resource type may appear in multiple monitoring
	// destinations if different aggregations are needed for different sets
	// of metrics associated with that monitored resource type. A monitored
	// resource and metric pair may only be used once in the Monitoring
	// configuration.
	ProducerDestinations []*MonitoringDestination `json:"producerDestinations,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "ConsumerDestinations") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ConsumerDestinations") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *Monitoring) MarshalJSON() ([]byte, error) {
	type NoMethod Monitoring
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// MonitoringDestination: Configuration of a specific monitoring
// destination (the producer project or the consumer project).
type MonitoringDestination struct {
	// Metrics: Types of the metrics to report to this monitoring
	// destination. Each type must be defined in Service.metrics section.
	Metrics []string `json:"metrics,omitempty"`

	// MonitoredResource: The monitored resource type. The type must be
	// defined in Service.monitored_resources section.
	MonitoredResource string `json:"monitoredResource,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Metrics") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Metrics") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *MonitoringDestination) MarshalJSON() ([]byte, error) {
	type NoMethod MonitoringDestination
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// OAuthRequirements: OAuth scopes are a way to define data and
// permissions on data. For example, there are scopes defined for
// "Read-only access to Google Calendar" and "Access to Cloud Platform".
// Users can consent to a scope for an application, giving it permission
// to access that data on their behalf. OAuth scope specifications
// should be fairly coarse grained; a user will need to see and
// understand the text description of what your scope means. In most
// cases: use one or at most two OAuth scopes for an entire family of
// products. If your product has multiple APIs, you should probably be
// sharing the OAuth scope across all of those APIs. When you need finer
// grained OAuth consent screens: talk with your product management
// about how developers will use them in practice. Please note that even
// though each of the canonical scopes is enough for a request to be
// accepted and passed to the backend, a request can still fail due to
// the backend requiring additional scopes or permissions.
type OAuthRequirements struct {
	// CanonicalScopes: The list of publicly documented OAuth scopes that
	// are allowed access. An OAuth token containing any of these scopes
	// will be accepted. Example: canonical_scopes:
	// https://www.googleapis.com/auth/calendar,
	// https://www.googleapis.com/auth/calendar.read
	CanonicalScopes string `json:"canonicalScopes,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CanonicalScopes") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CanonicalScopes") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *OAuthRequirements) MarshalJSON() ([]byte, error) {
	type NoMethod OAuthRequirements
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Operation: This resource represents a long-running operation that is
// the result of a network API call.
type Operation struct {
	// Done: If the value is `false`, it means the operation is still in
	// progress. If `true`, the operation is completed, and either `error`
	// or `response` is available.
	Done bool `json:"done,omitempty"`

	// Error: The error result of the operation in case of failure or
	// cancellation.
	Error *Status `json:"error,omitempty"`

	// Metadata: Service-specific metadata associated with the operation. It
	// typically contains progress information and common metadata such as
	// create time. Some services might not provide such metadata. Any
	// method that returns a long-running operation should document the
	// metadata type, if any.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`

	// Name: The server-assigned name, which is only unique within the same
	// service that originally returns it. If you use the default HTTP
	// mapping, the `name` should be a resource name ending with
	// `operations/{unique_id}`.
	Name string `json:"name,omitempty"`

	// Response: The normal response of the operation in case of success. If
	// the original method returns no data on success, such as `Delete`, the
	// response is `google.protobuf.Empty`. If the original method is
	// standard `Get`/`Create`/`Update`, the response should be the
	// resource. For other methods, the response should have the type
	// `XxxResponse`, where `Xxx` is the original method name. For example,
	// if the original method name is `TakeSnapshot()`, the inferred
	// response type is `TakeSnapshotResponse`.
	Response googleapi.RawMessage `json:"response,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Done") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Done") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Operation) MarshalJSON() ([]byte, error) {
	type NoMethod Operation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Option: A protocol buffer option, which can be attached to a message,
// field, enumeration, etc.
type Option struct {
	// Name: The option's name. For protobuf built-in options (options
	// defined in descriptor.proto), this is the short name. For example,
	// "map_entry". For custom options, it should be the fully-qualified
	// name. For example, "google.api.http".
	Name string `json:"name,omitempty"`

	// Value: The option's value packed in an Any message. If the value is a
	// primitive, the corresponding wrapper type defined in
	// google/protobuf/wrappers.proto should be used. If the value is an
	// enum, it should be stored as an int32 value using the
	// google.protobuf.Int32Value type.
	Value googleapi.RawMessage `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Option) MarshalJSON() ([]byte, error) {
	type NoMethod Option
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Page: Represents a documentation page. A page can contain subpages to
// represent nested documentation set structure.
type Page struct {
	// Content: The Markdown content of the page. You can use (== include
	// {path} ==) to include content from a Markdown file. The content can
	// be used to produce the documentation page such as HTML format page.
	Content string `json:"content,omitempty"`

	// Name: The name of the page. It will be used as an identity of the
	// page to generate URI of the page, text of the link to this page in
	// navigation, etc. The full page name (start from the root page name to
	// this page concatenated with `.`) can be used as reference to the page
	// in your documentation. For example: pages: - name: Tutorial content:
	// (== include tutorial.md ==) subpages: - name: Java content: (==
	// include tutorial_java.md ==) You can reference `Java` page using
	// Markdown reference link syntax: `Java`.
	Name string `json:"name,omitempty"`

	// Subpages: Subpages of this page. The order of subpages specified here
	// will be honored in the generated docset.
	Subpages []*Page `json:"subpages,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Content") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Content") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Page) MarshalJSON() ([]byte, error) {
	type NoMethod Page
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Quota: Quota configuration helps to achieve fairness and budgeting in
// service usage. The metric based quota configuration works this way: -
// The service configuration defines a set of metrics. - For API calls,
// the quota.metric_rules maps methods to metrics with corresponding
// costs. - The quota.limits defines limits on the metrics, which will
// be used for quota checks at runtime. An example quota configuration
// in yaml format: quota: limits: - name: apiWriteQpsPerProject metric:
// library.googleapis.com/write_calls unit: "1/min/{project}" # rate
// limit for consumer projects values: STANDARD: 10000 # The metric
// rules bind all methods to the read_calls metric, # except for the
// UpdateBook and DeleteBook methods. These two methods # are mapped to
// the write_calls metric, with the UpdateBook method # consuming at
// twice rate as the DeleteBook method. metric_rules: - selector: "*"
// metric_costs: library.googleapis.com/read_calls: 1 - selector:
// google.example.library.v1.LibraryService.UpdateBook metric_costs:
// library.googleapis.com/write_calls: 2 - selector:
// google.example.library.v1.LibraryService.DeleteBook metric_costs:
// library.googleapis.com/write_calls: 1 Corresponding Metric
// definition: metrics: - name: library.googleapis.com/read_calls
// display_name: Read requests metric_kind: DELTA value_type: INT64 -
// name: library.googleapis.com/write_calls display_name: Write requests
// metric_kind: DELTA value_type: INT64
type Quota struct {
	// Limits: List of `QuotaLimit` definitions for the service.
	Limits []*QuotaLimit `json:"limits,omitempty"`

	// MetricRules: List of `MetricRule` definitions, each one mapping a
	// selected method to one or more metrics.
	MetricRules []*MetricRule `json:"metricRules,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Limits") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Limits") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Quota) MarshalJSON() ([]byte, error) {
	type NoMethod Quota
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// QuotaLimit: `QuotaLimit` defines a specific limit that applies over a
// specified duration for a limit type. There can be at most one limit
// for a duration and limit type combination defined within a
// `QuotaGroup`.
type QuotaLimit struct {
	// DefaultLimit: Default number of tokens that can be consumed during
	// the specified duration. This is the number of tokens assigned when a
	// client application developer activates the service for his/her
	// project. Specifying a value of 0 will block all requests. This can be
	// used if you are provisioning quota to selected consumers and blocking
	// others. Similarly, a value of -1 will indicate an unlimited quota. No
	// other negative values are allowed. Used by group-based quotas only.
	DefaultLimit int64 `json:"defaultLimit,omitempty,string"`

	// Description: Optional. User-visible, extended description for this
	// quota limit. Should be used only when more context is needed to
	// understand this limit than provided by the limit's display name (see:
	// `display_name`).
	Description string `json:"description,omitempty"`

	// DisplayName: User-visible display name for this limit. Optional. If
	// not set, the UI will provide a default display name based on the
	// quota configuration. This field can be used to override the default
	// display name generated from the configuration.
	DisplayName string `json:"displayName,omitempty"`

	// Duration: Duration of this limit in textual notation. Must be "100s"
	// or "1d". Used by group-based quotas only.
	Duration string `json:"duration,omitempty"`

	// FreeTier: Free tier value displayed in the Developers Console for
	// this limit. The free tier is the number of tokens that will be
	// subtracted from the billed amount when billing is enabled. This field
	// can only be set on a limit with duration "1d", in a billable group;
	// it is invalid on any other limit. If this field is not set, it
	// defaults to 0, indicating that there is no free tier for this
	// service. Used by group-based quotas only.
	FreeTier int64 `json:"freeTier,omitempty,string"`

	// MaxLimit: Maximum number of tokens that can be consumed during the
	// specified duration. Client application developers can override the
	// default limit up to this maximum. If specified, this value cannot be
	// set to a value less than the default limit. If not specified, it is
	// set to the default limit. To allow clients to apply overrides with no
	// upper bound, set this to -1, indicating unlimited maximum quota. Used
	// by group-based quotas only.
	MaxLimit int64 `json:"maxLimit,omitempty,string"`

	// Metric: The name of the metric this quota limit applies to. The quota
	// limits with the same metric will be checked together during runtime.
	// The metric must be defined within the service config.
	Metric string `json:"metric,omitempty"`

	// Name: Name of the quota limit. The name must be provided, and it must
	// be unique within the service. The name can only include alphanumeric
	// characters as well as '-'. The maximum length of the limit name is 64
	// characters.
	Name string `json:"name,omitempty"`

	// Unit: Specify the unit of the quota limit. It uses the same syntax as
	// Metric.unit. The supported unit kinds are determined by the quota
	// backend system. Here are some examples: * "1/min/{project}" for quota
	// per minute per project. Note: the order of unit components is
	// insignificant. The "1" at the beginning is required to follow the
	// metric unit syntax.
	Unit string `json:"unit,omitempty"`

	// Values: Tiered limit values. You must specify this as a key:value
	// pair, with an integer value that is the maximum number of requests
	// allowed for the specified unit. Currently only STANDARD is supported.
	Values map[string]string `json:"values,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DefaultLimit") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DefaultLimit") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *QuotaLimit) MarshalJSON() ([]byte, error) {
	type NoMethod QuotaLimit
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Service: `Service` is the root object of Google API service
// configuration (service config). It describes the basic information
// about a logical service, such as the service name and the user-facing
// title, and delegates other aspects to sub-sections. Each sub-section
// is either a proto message or a repeated proto message that configures
// a specific aspect, such as auth. For more information, see each proto
// message definition. Example: type: google.api.Service name:
// calendar.googleapis.com title: Google Calendar API apis: - name:
// google.calendar.v3.Calendar visibility: rules: - selector:
// "google.calendar.v3.*" restriction: PREVIEW backend: rules: -
// selector: "google.calendar.v3.*" address: calendar.example.com
// authentication: providers: - id: google_calendar_auth jwks_uri:
// https://www.googleapis.com/oauth2/v1/certs issuer:
// https://securetoken.google.com rules: - selector: "*" requirements:
// provider_id: google_calendar_auth
type Service struct {
	// Apis: A list of API interfaces exported by this service. Only the
	// `name` field of the google.protobuf.Api needs to be provided by the
	// configuration author, as the remaining fields will be derived from
	// the IDL during the normalization process. It is an error to specify
	// an API interface here which cannot be resolved against the associated
	// IDL files.
	Apis []*Api `json:"apis,omitempty"`

	// Authentication: Auth configuration.
	Authentication *Authentication `json:"authentication,omitempty"`

	// Backend: API backend configuration.
	Backend *Backend `json:"backend,omitempty"`

	// Billing: Billing configuration.
	Billing *Billing `json:"billing,omitempty"`

	// ConfigVersion: Obsolete. Do not use. This field has no semantic
	// meaning. The service config compiler always sets this field to `3`.
	ConfigVersion int64 `json:"configVersion,omitempty"`

	// Context: Context configuration.
	Context *Context `json:"context,omitempty"`

	// Control: Configuration for the service control plane.
	Control *Control `json:"control,omitempty"`

	// CustomError: Custom error configuration.
	CustomError *CustomError `json:"customError,omitempty"`

	// Documentation: Additional API documentation.
	Documentation *Documentation `json:"documentation,omitempty"`

	// Endpoints: Configuration for network endpoints. If this is empty,
	// then an endpoint with the same name as the service is automatically
	// generated to service all defined APIs.
	Endpoints []*Endpoint `json:"endpoints,omitempty"`

	// Enums: A list of all enum types included in this API service. Enums
	// referenced directly or indirectly by the `apis` are automatically
	// included. Enums which are not referenced but shall be included should
	// be listed here by name by the configuration author. Example: enums: -
	// name: google.someapi.v1.SomeEnum
	Enums []*Enum `json:"enums,omitempty"`

	// Http: HTTP configuration.
	Http *Http `json:"http,omitempty"`

	// Id: A unique ID for a specific instance of this message, typically
	// assigned by the client for tracking purpose. Must be no longer than
	// 63 characters and only lower case letters, digits, '.', '_' and '-'
	// are allowed. If empty, the server may choose to generate one instead.
	Id string `json:"id,omitempty"`

	// Logging: Logging configuration.
	Logging *Logging `json:"logging,omitempty"`

	// Logs: Defines the logs used by this service.
	Logs []*LogDescriptor `json:"logs,omitempty"`

	// Metrics: Defines the metrics used by this service.
	Metrics []*MetricDescriptor `json:"metrics,omitempty"`

	// MonitoredResources: Defines the monitored resources used by this
	// service. This is required by the Service.monitoring and
	// Service.logging configurations.
	MonitoredResources []*MonitoredResourceDescriptor `json:"monitoredResources,omitempty"`

	// Monitoring: Monitoring configuration.
	Monitoring *Monitoring `json:"monitoring,omitempty"`

	// Name: The service name, which is a DNS-like logical identifier for
	// the service, such as `calendar.googleapis.com`. The service name
	// typically goes through DNS verification to make sure the owner of the
	// service also owns the DNS name.
	Name string `json:"name,omitempty"`

	// ProducerProjectId: The Google project that owns this service.
	ProducerProjectId string `json:"producerProjectId,omitempty"`

	// Quota: Quota configuration.
	Quota *Quota `json:"quota,omitempty"`

	// SourceInfo: Output only. The source information for this
	// configuration if available.
	SourceInfo *SourceInfo `json:"sourceInfo,omitempty"`

	// SystemParameters: System parameter configuration.
	SystemParameters *SystemParameters `json:"systemParameters,omitempty"`

	// SystemTypes: A list of all proto message types included in this API
	// service. It serves similar purpose as [google.api.Service.types],
	// except that these types are not needed by user-defined APIs.
	// Therefore, they will not show up in the generated discovery doc. This
	// field should only be used to define system APIs in ESF.
	SystemTypes []*Type `json:"systemTypes,omitempty"`

	// Title: The product title for this service, it is the name displayed
	// in Google Cloud Console.
	Title string `json:"title,omitempty"`

	// Types: A list of all proto message types included in this API
	// service. Types referenced directly or indirectly by the `apis` are
	// automatically included. Messages which are not referenced but shall
	// be included, such as types used by the `google.protobuf.Any` type,
	// should be listed here by name by the configuration author. Example:
	// types: - name: google.protobuf.Int32
	Types []*Type `json:"types,omitempty"`

	// Usage: Configuration controlling usage of this service.
	Usage *Usage `json:"usage,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Apis") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Apis") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Service) MarshalJSON() ([]byte, error) {
	type NoMethod Service
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SourceContext: `SourceContext` represents information about the
// source of a protobuf element, like the file in which it is defined.
type SourceContext struct {
	// FileName: The path-qualified name of the .proto file that contained
	// the associated protobuf element. For example:
	// "google/protobuf/source_context.proto".
	FileName string `json:"fileName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FileName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FileName") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SourceContext) MarshalJSON() ([]byte, error) {
	type NoMethod SourceContext
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SourceInfo: Source information used to create a Service Config
type SourceInfo struct {
	// SourceFiles: All files used during config generation.
	SourceFiles []googleapi.RawMessage `json:"sourceFiles,omitempty"`

	// ForceSendFields is a list of field names (e.g. "SourceFiles") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "SourceFiles") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SourceInfo) MarshalJSON() ([]byte, error) {
	type NoMethod SourceInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Status: The `Status` type defines a logical error model that is
// suitable for different programming environments, including REST APIs
// and RPC APIs. It is used by gRPC (https://github.com/grpc). Each
// `Status` message contains three pieces of data: error code, error
// message, and error details. You can find out more about this error
// model and how to work with it in the API Design Guide
// (https://cloud.google.com/apis/design/errors).
type Status struct {
	// Code: The status code, which should be an enum value of
	// google.rpc.Code.
	Code int64 `json:"code,omitempty"`

	// Details: A list of messages that carry the error details. There is a
	// common set of message types for APIs to use.
	Details []googleapi.RawMessage `json:"details,omitempty"`

	// Message: A developer-facing error message, which should be in
	// English. Any user-facing error message should be localized and sent
	// in the google.rpc.Status.details field, or localized by the client.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Status) MarshalJSON() ([]byte, error) {
	type NoMethod Status
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SystemParameter: Define a parameter's name and location. The
// parameter may be passed as either an HTTP header or a URL query
// parameter, and if both are passed the behavior is
// implementation-dependent.
type SystemParameter struct {
	// HttpHeader: Define the HTTP header name to use for the parameter. It
	// is case insensitive.
	HttpHeader string `json:"httpHeader,omitempty"`

	// Name: Define the name of the parameter, such as "api_key" . It is
	// case sensitive.
	Name string `json:"name,omitempty"`

	// UrlQueryParameter: Define the URL query parameter name to use for the
	// parameter. It is case sensitive.
	UrlQueryParameter string `json:"urlQueryParameter,omitempty"`

	// ForceSendFields is a list of field names (e.g. "HttpHeader") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "HttpHeader") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SystemParameter) MarshalJSON() ([]byte, error) {
	type NoMethod SystemParameter
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SystemParameterRule: Define a system parameter rule mapping system
// parameter definitions to methods.
type SystemParameterRule struct {
	// Parameters: Define parameters. Multiple names may be defined for a
	// parameter. For a given method call, only one of them should be used.
	// If multiple names are used the behavior is implementation-dependent.
	// If none of the specified names are present the behavior is
	// parameter-dependent.
	Parameters []*SystemParameter `json:"parameters,omitempty"`

	// Selector: Selects the methods to which this rule applies. Use '*' to
	// indicate all methods in all APIs. Refer to selector for syntax
	// details.
	Selector string `json:"selector,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Parameters") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Parameters") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SystemParameterRule) MarshalJSON() ([]byte, error) {
	type NoMethod SystemParameterRule
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SystemParameters: ### System parameter configuration A system
// parameter is a special kind of parameter defined by the API system,
// not by an individual API. It is typically mapped to an HTTP header
// and/or a URL query parameter. This configuration specifies which
// methods change the names of the system parameters.
type SystemParameters struct {
	// Rules: Define system parameters. The parameters defined here will
	// override the default parameters implemented by the system. If this
	// field is missing from the service config, default system parameters
	// will be used. Default system parameters and names is
	// implementation-dependent. Example: define api key for all methods
	// system_parameters rules: - selector: "*" parameters: - name: api_key
	// url_query_parameter: api_key Example: define 2 api key names for a
	// specific method. system_parameters rules: - selector: "/ListShelves"
	// parameters: - name: api_key http_header: Api-Key1 - name: api_key
	// http_header: Api-Key2 **NOTE:** All service configuration rules
	// follow "last one wins" order.
	Rules []*SystemParameterRule `json:"rules,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Rules") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Rules") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SystemParameters) MarshalJSON() ([]byte, error) {
	type NoMethod SystemParameters
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Type: A protocol buffer message type.
type Type struct {
	// Fields: The list of fields.
	Fields []*Field `json:"fields,omitempty"`

	// Name: The fully qualified message name.
	Name string `json:"name,omitempty"`

	// Oneofs: The list of types appearing in `oneof` definitions in this
	// type.
	Oneofs []string `json:"oneofs,omitempty"`

	// Options: The protocol buffer options.
	Options []*Option `json:"options,omitempty"`

	// SourceContext: The source context.
	SourceContext *SourceContext `json:"sourceContext,omitempty"`

	// Syntax: The source syntax.
	//
	// Possible values:
	//   "SYNTAX_PROTO2" - Syntax `proto2`.
	//   "SYNTAX_PROTO3" - Syntax `proto3`.
	Syntax string `json:"syntax,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Fields") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Fields") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Type) MarshalJSON() ([]byte, error) {
	type NoMethod Type
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Usage: Configuration controlling usage of a service.
type Usage struct {
	// ProducerNotificationChannel: The full resource name of a channel used
	// for sending notifications to the service producer. Google Service
	// Management currently only supports Google Cloud Pub/Sub
	// (https://cloud.google.com/pubsub) as a notification channel. To use
	// Google Cloud Pub/Sub as the channel, this must be the name of a Cloud
	// Pub/Sub topic that uses the Cloud Pub/Sub topic name format
	// documented in https://cloud.google.com/pubsub/docs/overview.
	ProducerNotificationChannel string `json:"producerNotificationChannel,omitempty"`

	// Requirements: Requirements that must be satisfied before a consumer
	// project can use the service. Each requirement is of the form /; for
	// example 'serviceusage.googleapis.com/billing-enabled'. For Google
	// APIs, a Terms of Service requirement must be included here. Google
	// Cloud APIs must include "serviceusage.googleapis.com/tos/cloud".
	// Other Google APIs should include
	// "serviceusage.googleapis.com/tos/universal". Additional ToS can be
	// included based on the business needs.
	Requirements []string `json:"requirements,omitempty"`

	// Rules: A list of usage rules that apply to individual API methods.
	// **NOTE:** All service configuration rules follow "last one wins"
	// order.
	Rules []*UsageRule `json:"rules,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "ProducerNotificationChannel") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "ProducerNotificationChannel") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Usage) MarshalJSON() ([]byte, error) {
	type NoMethod Usage
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// UsageRule: Usage configuration rules for the service. NOTE: Under
// development. Use this rule to configure unregistered calls for the
// service. Unregistered calls are calls that do not contain consumer
// project identity. (Example: calls that do not contain an API key). By
// default, API methods do not allow unregistered calls, and each method
// call must be identified by a consumer project identity. Use this rule
// to allow/disallow unregistered calls. Example of an API that wants to
// allow unregistered calls for entire service. usage: rules: -
// selector: "*" allow_unregistered_calls: true Example of a method that
// wants to allow unregistered calls. usage: rules: - selector:
// "google.example.library.v1.LibraryService.CreateBook"
// allow_unregistered_calls: true
type UsageRule struct {
	// AllowUnregisteredCalls: If true, the selected method allows
	// unregistered calls, e.g. calls that don't identify any user or
	// application.
	AllowUnregisteredCalls bool `json:"allowUnregisteredCalls,omitempty"`

	// Selector: Selects the methods to which this rule applies. Use '*' to
	// indicate all methods in all APIs. Refer to selector for syntax
	// details.
	Selector string `json:"selector,omitempty"`

	// SkipServiceControl: If true, the selected method should skip service
	// control and the control plane features, such as quota and billing,
	// will not be available. This flag is used by Google Cloud Endpoints to
	// bypass checks for internal methods, such as service health check
	// methods.
	SkipServiceControl bool `json:"skipServiceControl,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "AllowUnregisteredCalls") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AllowUnregisteredCalls")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *UsageRule) MarshalJSON() ([]byte, error) {
	type NoMethod UsageRule
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// V1Beta1BatchCreateProducerOverridesResponse: Response message for
// BatchCreateProducerOverrides
type V1Beta1BatchCreateProducerOverridesResponse struct {
	// Overrides: The overrides that were created.
	Overrides []*V1Beta1QuotaOverride `json:"overrides,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Overrides") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Overrides") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *V1Beta1BatchCreateProducerOverridesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod V1Beta1BatchCreateProducerOverridesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// V1Beta1ConsumerQuotaLimit: Consumer quota settings for a quota limit.
type V1Beta1ConsumerQuotaLimit struct {
	// IsPrecise: Whether this limit is precise or imprecise.
	IsPrecise bool `json:"isPrecise,omitempty"`

	// Metric: The name of the parent metric of this limit. An example name
	// would be: `compute.googleapis.com/cpus`
	Metric string `json:"metric,omitempty"`

	// Name: The resource name of the quota limit. An example name would be:
	// `services/compute.googleapis.com/projects/123/quotas/metrics/compute.g
	// oogleapis.com%2Fcpus/limits/%2Fproject%2Fregion` The resource name is
	// intended to be opaque and should not be parsed for its component
	// strings, since its representation could change in the future.
	Name string `json:"name,omitempty"`

	// QuotaBuckets: Summary of the enforced quota buckets, organized by
	// quota dimension, ordered from least specific to most specific (for
	// example, the global default bucket, with no quota dimensions, will
	// always appear first).
	QuotaBuckets []*V1Beta1QuotaBucket `json:"quotaBuckets,omitempty"`

	// Unit: The limit unit. An example unit would be:
	// `1/{project}/{region}` Note that `{project}` and `{region}` are not
	// placeholders in this example; the literal characters `{` and `}`
	// occur in the string.
	Unit string `json:"unit,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "IsPrecise") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "IsPrecise") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *V1Beta1ConsumerQuotaLimit) MarshalJSON() ([]byte, error) {
	type NoMethod V1Beta1ConsumerQuotaLimit
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// V1Beta1ConsumerQuotaMetric: Consumer quota settings for a quota
// metric.
type V1Beta1ConsumerQuotaMetric struct {
	// ConsumerQuotaLimits: The consumer quota for each quota limit defined
	// on the metric.
	ConsumerQuotaLimits []*V1Beta1ConsumerQuotaLimit `json:"consumerQuotaLimits,omitempty"`

	// DescendantConsumerQuotaLimits: The quota limits targeting the
	// descendant containers of the consumer in request. If the consumer in
	// request is of type `organizations` or `folders`, the field will list
	// per-project limits in the metric; if the consumer in request is of
	// type `project`, the field will be empty. The `quota_buckets` field of
	// each descendant consumer quota limit will not be populated.
	DescendantConsumerQuotaLimits []*V1Beta1ConsumerQuotaLimit `json:"descendantConsumerQuotaLimits,omitempty"`

	// DisplayName: The display name of the metric. An example name would
	// be: "CPUs"
	DisplayName string `json:"displayName,omitempty"`

	// Metric: The name of the metric. An example name would be:
	// `compute.googleapis.com/cpus`
	Metric string `json:"metric,omitempty"`

	// Name: The resource name of the quota settings on this metric for this
	// consumer. An example name would be:
	// `services/serviceconsumermanagement.googleapis.com/projects/123/quota/
	// metrics/compute.googleapis.com%2Fcpus The resource name is intended
	// to be opaque and should not be parsed for its component strings,
	// since its representation could change in the future.
	Name string `json:"name,omitempty"`

	// Unit: The units in which the metric value is reported.
	Unit string `json:"unit,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ConsumerQuotaLimits")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ConsumerQuotaLimits") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *V1Beta1ConsumerQuotaMetric) MarshalJSON() ([]byte, error) {
	type NoMethod V1Beta1ConsumerQuotaMetric
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// V1Beta1DisableConsumerResponse: Response message for the
// `DisableConsumer` method. This response message is assigned to the
// `response` field of the returned Operation when that operation is
// done.
type V1Beta1DisableConsumerResponse struct {
}

// V1Beta1EnableConsumerResponse: Response message for the
// `EnableConsumer` method. This response message is assigned to the
// `response` field of the returned Operation when that operation is
// done.
type V1Beta1EnableConsumerResponse struct {
}

// V1Beta1GenerateServiceIdentityResponse: Response message for the
// `GenerateServiceIdentity` method. This response message is assigned
// to the `response` field of the returned Operation when that operation
// is done.
type V1Beta1GenerateServiceIdentityResponse struct {
	// Identity: ServiceIdentity that was created or retrieved.
	Identity *V1Beta1ServiceIdentity `json:"identity,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Identity") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Identity") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *V1Beta1GenerateServiceIdentityResponse) MarshalJSON() ([]byte, error) {
	type NoMethod V1Beta1GenerateServiceIdentityResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// V1Beta1ImportProducerOverridesRequest: Request message for
// ImportProducerOverrides
type V1Beta1ImportProducerOverridesRequest struct {
	// Force: Whether to force the creation of the quota overrides. Setting
	// the force parameter to 'true' ignores all quota safety checks that
	// would fail the request. QuotaSafetyCheck lists all such validations.
	Force bool `json:"force,omitempty"`

	// ForceOnly: The list of quota safety checks to ignore before the
	// override mutation. Unlike 'force' field that ignores all the quota
	// safety checks, the 'force_only' field ignores only the specified
	// checks; other checks are still enforced. The 'force' and 'force_only'
	// fields cannot both be set.
	//
	// Possible values:
	//   "QUOTA_SAFETY_CHECK_UNSPECIFIED" - Unspecified quota safety check.
	//   "LIMIT_DECREASE_BELOW_USAGE" - Validates that a quota mutation
	// would not cause the consumer's effective limit to be lower than the
	// consumer's quota usage.
	//   "LIMIT_DECREASE_PERCENTAGE_TOO_HIGH" - Validates that a quota
	// mutation would not cause the consumer's effective limit to decrease
	// by more than 10 percent.
	ForceOnly []string `json:"forceOnly,omitempty"`

	// InlineSource: The import data is specified in the request message
	// itself
	InlineSource *V1Beta1OverrideInlineSource `json:"inlineSource,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Force") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Force") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *V1Beta1ImportProducerOverridesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod V1Beta1ImportProducerOverridesRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// V1Beta1ImportProducerOverridesResponse: Response message for
// ImportProducerOverrides
type V1Beta1ImportProducerOverridesResponse struct {
	// Overrides: The overrides that were created from the imported data.
	Overrides []*V1Beta1QuotaOverride `json:"overrides,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Overrides") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Overrides") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *V1Beta1ImportProducerOverridesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod V1Beta1ImportProducerOverridesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// V1Beta1ImportProducerQuotaPoliciesResponse: Response message for
// ImportProducerQuotaPolicies
type V1Beta1ImportProducerQuotaPoliciesResponse struct {
	// Policies: The policies that were created from the imported data.
	Policies []*V1Beta1ProducerQuotaPolicy `json:"policies,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Policies") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Policies") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *V1Beta1ImportProducerQuotaPoliciesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod V1Beta1ImportProducerQuotaPoliciesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// V1Beta1ListConsumerQuotaMetricsResponse: Response message for
// ListConsumerQuotaMetrics.
type V1Beta1ListConsumerQuotaMetricsResponse struct {
	// Metrics: Quota settings for the consumer, organized by quota metric.
	Metrics []*V1Beta1ConsumerQuotaMetric `json:"metrics,omitempty"`

	// NextPageToken: Token identifying which result to start with; returned
	// by a previous list call.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Metrics") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Metrics") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *V1Beta1ListConsumerQuotaMetricsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod V1Beta1ListConsumerQuotaMetricsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// V1Beta1ListProducerOverridesResponse: Response message for
// ListProducerOverrides.
type V1Beta1ListProducerOverridesResponse struct {
	// NextPageToken: Token identifying which result to start with; returned
	// by a previous list call.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Overrides: Producer overrides on this limit.
	Overrides []*V1Beta1QuotaOverride `json:"overrides,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *V1Beta1ListProducerOverridesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod V1Beta1ListProducerOverridesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// V1Beta1OverrideInlineSource: Import data embedded in the request
// message
type V1Beta1OverrideInlineSource struct {
	// Overrides: The overrides to create. Each override must have a value
	// for 'metric' and 'unit', to specify which metric and which limit the
	// override should be applied to. The 'name' field of the override does
	// not need to be set; it is ignored.
	Overrides []*V1Beta1QuotaOverride `json:"overrides,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Overrides") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Overrides") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *V1Beta1OverrideInlineSource) MarshalJSON() ([]byte, error) {
	type NoMethod V1Beta1OverrideInlineSource
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// V1Beta1ProducerQuotaPolicy: Quota policy created by service producer.
type V1Beta1ProducerQuotaPolicy struct {
	// Container: The cloud resource container at which the quota policy is
	// created. The format is {container_type}/{container_number}
	Container string `json:"container,omitempty"`

	// Dimensions:  If this map is nonempty, then this policy applies only
	// to specific values for dimensions defined in the limit unit. For
	// example, an policy on a limit with the unit 1/{project}/{region}
	// could contain an entry with the key "region" and the value
	// "us-east-1"; the policy is only applied to quota consumed in that
	// region. This map has the following restrictions: * Keys that are not
	// defined in the limit's unit are not valid keys. Any string appearing
	// in {brackets} in the unit (besides {project} or {user}) is a defined
	// key. * "project" is not a valid key; the project is already specified
	// in the parent resource name. * "user" is not a valid key; the API
	// does not support quota polcies that apply only to a specific user. *
	// If "region" appears as a key, its value must be a valid Cloud region.
	// * If "zone" appears as a key, its value must be a valid Cloud zone. *
	// If any valid key other than "region" or "zone" appears in the map,
	// then all valid keys other than "region" or "zone" must also appear in
	// the map.
	Dimensions map[string]string `json:"dimensions,omitempty"`

	// Metric: The name of the metric to which this policy applies. An
	// example name would be: `compute.googleapis.com/cpus`
	Metric string `json:"metric,omitempty"`

	// Name: The resource name of the producer policy. An example name would
	// be:
	// `services/compute.googleapis.com/organizations/123/consumerQuotaMetric
	// s/compute.googleapis.com%2Fcpus/limits/%2Fproject%2Fregion/producerQuo
	// taPolicies/4a3f2c1d`
	Name string `json:"name,omitempty"`

	// PolicyValue: The quota policy value. Can be any nonnegative integer,
	// or -1 (unlimited quota).
	PolicyValue int64 `json:"policyValue,omitempty,string"`

	// Unit: The limit unit of the limit to which this policy applies. An
	// example unit would be: `1/{project}/{region}` Note that `{project}`
	// and `{region}` are not placeholders in this example; the literal
	// characters `{` and `}` occur in the string.
	Unit string `json:"unit,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Container") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Container") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *V1Beta1ProducerQuotaPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod V1Beta1ProducerQuotaPolicy
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// V1Beta1QuotaBucket: A quota bucket is a quota provisioning unit for a
// specific set of dimensions.
type V1Beta1QuotaBucket struct {
	// AdminOverride: Admin override on this quota bucket.
	AdminOverride *V1Beta1QuotaOverride `json:"adminOverride,omitempty"`

	// ConsumerOverride: Consumer override on this quota bucket.
	ConsumerOverride *V1Beta1QuotaOverride `json:"consumerOverride,omitempty"`

	// DefaultLimit: The default limit of this quota bucket, as specified by
	// the service configuration.
	DefaultLimit int64 `json:"defaultLimit,omitempty,string"`

	// Dimensions: The dimensions of this quota bucket. If this map is
	// empty, this is the global bucket, which is the default quota value
	// applied to all requests that do not have a more specific override. If
	// this map is nonempty, the default limit, effective limit, and quota
	// overrides apply only to requests that have the dimensions given in
	// the map. For example, if the map has key "region" and value
	// "us-east-1", then the specified effective limit is only effective in
	// that region, and the specified overrides apply only in that region.
	Dimensions map[string]string `json:"dimensions,omitempty"`

	// EffectiveLimit: The effective limit of this quota bucket. Equal to
	// default_limit if there are no overrides.
	EffectiveLimit int64 `json:"effectiveLimit,omitempty,string"`

	// ProducerOverride: Producer override on this quota bucket.
	ProducerOverride *V1Beta1QuotaOverride `json:"producerOverride,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AdminOverride") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AdminOverride") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *V1Beta1QuotaBucket) MarshalJSON() ([]byte, error) {
	type NoMethod V1Beta1QuotaBucket
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// V1Beta1QuotaOverride: A quota override
type V1Beta1QuotaOverride struct {
	// AdminOverrideAncestor: The resource name of the ancestor that
	// requested the override. For example: "organizations/12345" or
	// "folders/67890". Used by admin overrides only.
	AdminOverrideAncestor string `json:"adminOverrideAncestor,omitempty"`

	// Dimensions:  If this map is nonempty, then this override applies only
	// to specific values for dimensions defined in the limit unit. For
	// example, an override on a limit with the unit 1/{project}/{region}
	// could contain an entry with the key "region" and the value
	// "us-east-1"; the override is only applied to quota consumed in that
	// region. This map has the following restrictions: * Keys that are not
	// defined in the limit's unit are not valid keys. Any string appearing
	// in {brackets} in the unit (besides {project} or {user}) is a defined
	// key. * "project" is not a valid key; the project is already specified
	// in the parent resource name. * "user" is not a valid key; the API
	// does not support quota overrides that apply only to a specific user.
	// * If "region" appears as a key, its value must be a valid Cloud
	// region. * If "zone" appears as a key, its value must be a valid Cloud
	// zone. * If any valid key other than "region" or "zone" appears in the
	// map, then all valid keys other than "region" or "zone" must also
	// appear in the map.
	Dimensions map[string]string `json:"dimensions,omitempty"`

	// Metric: The name of the metric to which this override applies. An
	// example name would be: `compute.googleapis.com/cpus`
	Metric string `json:"metric,omitempty"`

	// Name: The resource name of the producer override. An example name
	// would be:
	// `services/compute.googleapis.com/projects/123/consumerQuotaMetrics/com
	// pute.googleapis.com%2Fcpus/limits/%2Fproject%2Fregion/producerOverride
	// s/4a3f2c1d`
	Name string `json:"name,omitempty"`

	// OverrideValue: The overriding quota limit value. Can be any
	// nonnegative integer, or -1 (unlimited quota).
	OverrideValue int64 `json:"overrideValue,omitempty,string"`

	// Unit: The limit unit of the limit to which this override applies. An
	// example unit would be: `1/{project}/{region}` Note that `{project}`
	// and `{region}` are not placeholders in this example; the literal
	// characters `{` and `}` occur in the string.
	Unit string `json:"unit,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "AdminOverrideAncestor") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AdminOverrideAncestor") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *V1Beta1QuotaOverride) MarshalJSON() ([]byte, error) {
	type NoMethod V1Beta1QuotaOverride
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// V1Beta1RefreshConsumerResponse: Response message for the
// `RefreshConsumer` method. This response message is assigned to the
// `response` field of the returned Operation when that operation is
// done.
type V1Beta1RefreshConsumerResponse struct {
}

// V1Beta1ServiceIdentity: A service identity in the Identity and Access
// Management API.
type V1Beta1ServiceIdentity struct {
	// Email: The email address of the service identity.
	Email string `json:"email,omitempty"`

	// Name: P4 service identity resource name. An example name would be:
	// `services/serviceconsumermanagement.googleapis.com/projects/123/servic
	// eIdentities/default`
	Name string `json:"name,omitempty"`

	// Tag: The P4 service identity configuration tag. This must be defined
	// in activation_grants. If not specified when creating the account, the
	// tag is set to "default".
	Tag string `json:"tag,omitempty"`

	// UniqueId: The unique and stable id of the service identity.
	UniqueId string `json:"uniqueId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Email") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Email") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *V1Beta1ServiceIdentity) MarshalJSON() ([]byte, error) {
	type NoMethod V1Beta1ServiceIdentity
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// V1beta1AddVisibilityLabelsResponse: Response message for the
// `AddVisibilityLabels` method. This response message is assigned to
// the `response` field of the returned Operation when that operation is
// done.
type V1beta1AddVisibilityLabelsResponse struct {
	// Labels: The updated set of visibility labels for this consumer on
	// this service.
	Labels []string `json:"labels,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Labels") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Labels") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *V1beta1AddVisibilityLabelsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod V1beta1AddVisibilityLabelsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// V1beta1DefaultIdentity: A default identity in the Identity and Access
// Management API.
type V1beta1DefaultIdentity struct {
	// Email: The email address of the default identity.
	Email string `json:"email,omitempty"`

	// Name: Default identity resource name. An example name would be:
	// `services/serviceconsumermanagement.googleapis.com/projects/123/defaul
	// tIdentity`
	Name string `json:"name,omitempty"`

	// Tag: The Default Identity tag. If specified when creating the
	// account, the tag must be present in activation_grants. If not
	// specified when creating the account, the tag is set to the tag
	// specified in activation_grants.
	Tag string `json:"tag,omitempty"`

	// UniqueId: The unique and stable id of the default identity.
	UniqueId string `json:"uniqueId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Email") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Email") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *V1beta1DefaultIdentity) MarshalJSON() ([]byte, error) {
	type NoMethod V1beta1DefaultIdentity
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// V1beta1DisableConsumerResponse: Response message for the
// `DisableConsumer` method. This response message is assigned to the
// `response` field of the returned Operation when that operation is
// done.
type V1beta1DisableConsumerResponse struct {
}

// V1beta1EnableConsumerResponse: Response message for the
// `EnableConsumer` method. This response message is assigned to the
// `response` field of the returned Operation when that operation is
// done.
type V1beta1EnableConsumerResponse struct {
}

// V1beta1GenerateDefaultIdentityResponse: Response message for the
// `GenerateDefaultIdentity` method. This response message is assigned
// to the `response` field of the returned Operation when that operation
// is done.
type V1beta1GenerateDefaultIdentityResponse struct {
	// AttachStatus: Status of the role attachment. Under development
	// (go/si-attach-role), currently always return
	// ATTACH_STATUS_UNSPECIFIED)
	//
	// Possible values:
	//   "ATTACH_STATUS_UNSPECIFIED" - Indicates that the AttachStatus was
	// not set.
	//   "ATTACHED" - The default identity was attached to a role
	// successfully in this request.
	//   "ATTACH_SKIPPED" - The request specified that no attempt should be
	// made to attach the role.
	//   "PREVIOUSLY_ATTACHED" - Role was attached to the consumer project
	// at some point in time. Tenant manager doesn't make assertion about
	// the current state of the identity with respect to the consumer. Role
	// attachment should happen only once after activation and cannot be
	// reattached after customer removes it. (go/si-attach-role)
	//   "ATTACH_DENIED_BY_ORG_POLICY" - Role attachment was denied in this
	// request by customer set org policy. (go/si-attach-role)
	AttachStatus string `json:"attachStatus,omitempty"`

	// Identity: DefaultIdentity that was created or retrieved.
	Identity *V1beta1DefaultIdentity `json:"identity,omitempty"`

	// Role: Role attached to consumer project. Empty if not attached in
	// this request. (Under development, currently always return empty.)
	Role string `json:"role,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AttachStatus") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AttachStatus") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *V1beta1GenerateDefaultIdentityResponse) MarshalJSON() ([]byte, error) {
	type NoMethod V1beta1GenerateDefaultIdentityResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// V1beta1GenerateServiceAccountResponse: Response message for the
// `GenerateServiceAccount` method. This response message is assigned to
// the `response` field of the returned Operation when that operation is
// done.
type V1beta1GenerateServiceAccountResponse struct {
	// Account: ServiceAccount that was created or retrieved.
	Account *V1beta1ServiceAccount `json:"account,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Account") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Account") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *V1beta1GenerateServiceAccountResponse) MarshalJSON() ([]byte, error) {
	type NoMethod V1beta1GenerateServiceAccountResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// V1beta1RefreshConsumerResponse: Response message for the
// `RefreshConsumer` method. This response message is assigned to the
// `response` field of the returned Operation when that operation is
// done.
type V1beta1RefreshConsumerResponse struct {
}

// V1beta1RemoveVisibilityLabelsResponse: Response message for the
// `RemoveVisibilityLabels` method. This response message is assigned to
// the `response` field of the returned Operation when that operation is
// done.
type V1beta1RemoveVisibilityLabelsResponse struct {
	// Labels: The updated set of visibility labels for this consumer on
	// this service.
	Labels []string `json:"labels,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Labels") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Labels") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *V1beta1RemoveVisibilityLabelsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod V1beta1RemoveVisibilityLabelsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// V1beta1ServiceAccount: A service account in the Identity and Access
// Management API.
type V1beta1ServiceAccount struct {
	// Email: The email address of the service account.
	Email string `json:"email,omitempty"`

	// IamAccountName: Deprecated. See b/136209818.
	IamAccountName string `json:"iamAccountName,omitempty"`

	// Name: P4 SA resource name. An example name would be:
	// `services/serviceconsumermanagement.googleapis.com/projects/123/servic
	// eAccounts/default`
	Name string `json:"name,omitempty"`

	// Tag: The P4 SA configuration tag. This must be defined in
	// activation_grants. If not specified when creating the account, the
	// tag is set to "default".
	Tag string `json:"tag,omitempty"`

	// UniqueId: The unique and stable id of the service account.
	UniqueId string `json:"uniqueId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Email") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Email") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *V1beta1ServiceAccount) MarshalJSON() ([]byte, error) {
	type NoMethod V1beta1ServiceAccount
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// method id "serviceconsumermanagement.operations.get":

type OperationsGetCall struct {
	s            *APIService
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can
// use this method to poll the operation result at intervals as
// recommended by the API service.
//
// - name: The name of the operation resource.
func (r *OperationsService) Get(name string) *OperationsGetCall {
	c := &OperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OperationsGetCall) Fields(s ...googleapi.Field) *OperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *OperationsGetCall) IfNoneMatch(entityTag string) *OperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OperationsGetCall) Context(ctx context.Context) *OperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211207")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "serviceconsumermanagement.operations.get" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OperationsGetCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the latest state of a long-running operation. Clients can use this method to poll the operation result at intervals as recommended by the API service.",
	//   "flatPath": "v1beta1/operations/{operationsId}",
	//   "httpMethod": "GET",
	//   "id": "serviceconsumermanagement.operations.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The name of the operation resource.",
	//       "location": "path",
	//       "pattern": "^operations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/{+name}",
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "serviceconsumermanagement.services.consumerQuotaMetrics.get":

type ServicesConsumerQuotaMetricsGetCall struct {
	s            *APIService
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves a summary of quota information for a specific quota
// metric.
//
// - name: The resource name of the quota metric, returned by a
//   ListConsumerQuotaMetrics call. An example name would be:
//   `services/compute.googleapis.com/projects/123/consumerQuotaMetrics/c
//   ompute.googleapis.com%2Fcpus`.
func (r *ServicesConsumerQuotaMetricsService) Get(name string) *ServicesConsumerQuotaMetricsGetCall {
	c := &ServicesConsumerQuotaMetricsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// View sets the optional parameter "view": Specifies the level of
// detail for quota information in the response.
//
// Possible values:
//   "QUOTA_VIEW_UNSPECIFIED" - No quota view specified. Requests that
// do not specify a quota view will typically default to the BASIC view.
//   "BASIC" - Only buckets with overrides are shown in the response.
//   "FULL" - Include per-location buckets even if they do not have
// overrides. When the view is FULL, and a limit has regional or zonal
// quota, the limit will include buckets for all regions or zones that
// could support overrides, even if none are currently present. In some
// cases this will cause the response to become very large; callers that
// do not need this extra information should use the BASIC view instead.
func (c *ServicesConsumerQuotaMetricsGetCall) View(view string) *ServicesConsumerQuotaMetricsGetCall {
	c.urlParams_.Set("view", view)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ServicesConsumerQuotaMetricsGetCall) Fields(s ...googleapi.Field) *ServicesConsumerQuotaMetricsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ServicesConsumerQuotaMetricsGetCall) IfNoneMatch(entityTag string) *ServicesConsumerQuotaMetricsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ServicesConsumerQuotaMetricsGetCall) Context(ctx context.Context) *ServicesConsumerQuotaMetricsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ServicesConsumerQuotaMetricsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ServicesConsumerQuotaMetricsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211207")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "serviceconsumermanagement.services.consumerQuotaMetrics.get" call.
// Exactly one of *V1Beta1ConsumerQuotaMetric or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *V1Beta1ConsumerQuotaMetric.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ServicesConsumerQuotaMetricsGetCall) Do(opts ...googleapi.CallOption) (*V1Beta1ConsumerQuotaMetric, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &V1Beta1ConsumerQuotaMetric{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Retrieves a summary of quota information for a specific quota metric.",
	//   "flatPath": "v1beta1/services/{servicesId}/{servicesId1}/{servicesId2}/consumerQuotaMetrics/{consumerQuotaMetricsId}",
	//   "httpMethod": "GET",
	//   "id": "serviceconsumermanagement.services.consumerQuotaMetrics.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The resource name of the quota metric, returned by a ListConsumerQuotaMetrics call. An example name would be: `services/compute.googleapis.com/projects/123/consumerQuotaMetrics/compute.googleapis.com%2Fcpus`",
	//       "location": "path",
	//       "pattern": "^services/[^/]+/[^/]+/[^/]+/consumerQuotaMetrics/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "view": {
	//       "description": "Specifies the level of detail for quota information in the response.",
	//       "enum": [
	//         "QUOTA_VIEW_UNSPECIFIED",
	//         "BASIC",
	//         "FULL"
	//       ],
	//       "enumDescriptions": [
	//         "No quota view specified. Requests that do not specify a quota view will typically default to the BASIC view.",
	//         "Only buckets with overrides are shown in the response.",
	//         "Include per-location buckets even if they do not have overrides. When the view is FULL, and a limit has regional or zonal quota, the limit will include buckets for all regions or zones that could support overrides, even if none are currently present. In some cases this will cause the response to become very large; callers that do not need this extra information should use the BASIC view instead."
	//       ],
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/{+name}",
	//   "response": {
	//     "$ref": "V1Beta1ConsumerQuotaMetric"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "serviceconsumermanagement.services.consumerQuotaMetrics.importProducerOverrides":

type ServicesConsumerQuotaMetricsImportProducerOverridesCall struct {
	s                                     *APIService
	parent                                string
	v1beta1importproduceroverridesrequest *V1Beta1ImportProducerOverridesRequest
	urlParams_                            gensupport.URLParams
	ctx_                                  context.Context
	header_                               http.Header
}

// ImportProducerOverrides: Create or update multiple producer overrides
// atomically, all on the same consumer, but on many different metrics
// or limits. The name field in the quota override message should not be
// set.
//
// - parent: The resource name of the consumer. An example name would
//   be: `services/compute.googleapis.com/projects/123`.
func (r *ServicesConsumerQuotaMetricsService) ImportProducerOverrides(parent string, v1beta1importproduceroverridesrequest *V1Beta1ImportProducerOverridesRequest) *ServicesConsumerQuotaMetricsImportProducerOverridesCall {
	c := &ServicesConsumerQuotaMetricsImportProducerOverridesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.v1beta1importproduceroverridesrequest = v1beta1importproduceroverridesrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ServicesConsumerQuotaMetricsImportProducerOverridesCall) Fields(s ...googleapi.Field) *ServicesConsumerQuotaMetricsImportProducerOverridesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ServicesConsumerQuotaMetricsImportProducerOverridesCall) Context(ctx context.Context) *ServicesConsumerQuotaMetricsImportProducerOverridesCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ServicesConsumerQuotaMetricsImportProducerOverridesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ServicesConsumerQuotaMetricsImportProducerOverridesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211207")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.v1beta1importproduceroverridesrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/consumerQuotaMetrics:importProducerOverrides")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "serviceconsumermanagement.services.consumerQuotaMetrics.importProducerOverrides" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ServicesConsumerQuotaMetricsImportProducerOverridesCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Create or update multiple producer overrides atomically, all on the same consumer, but on many different metrics or limits. The name field in the quota override message should not be set.",
	//   "flatPath": "v1beta1/services/{servicesId}/{servicesId1}/{servicesId2}/consumerQuotaMetrics:importProducerOverrides",
	//   "httpMethod": "POST",
	//   "id": "serviceconsumermanagement.services.consumerQuotaMetrics.importProducerOverrides",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "The resource name of the consumer. An example name would be: `services/compute.googleapis.com/projects/123`",
	//       "location": "path",
	//       "pattern": "^services/[^/]+/[^/]+/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/{+parent}/consumerQuotaMetrics:importProducerOverrides",
	//   "request": {
	//     "$ref": "V1Beta1ImportProducerOverridesRequest"
	//   },
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "serviceconsumermanagement.services.consumerQuotaMetrics.list":

type ServicesConsumerQuotaMetricsListCall struct {
	s            *APIService
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Retrieves a summary of all quota information about this
// consumer that is visible to the service producer, for each quota
// metric defined by the service. Each metric includes information about
// all of its defined limits. Each limit includes the limit
// configuration (quota unit, preciseness, default value), the current
// effective limit value, and all of the overrides applied to the limit.
//
// - parent: Parent of the quotas resource. An example parent would be:
//   `services/serviceconsumermanagement.googleapis.com/projects/123`.
func (r *ServicesConsumerQuotaMetricsService) List(parent string) *ServicesConsumerQuotaMetricsListCall {
	c := &ServicesConsumerQuotaMetricsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Requested size of
// the next page of data.
func (c *ServicesConsumerQuotaMetricsListCall) PageSize(pageSize int64) *ServicesConsumerQuotaMetricsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Token identifying
// which result to start with; returned by a previous list call.
func (c *ServicesConsumerQuotaMetricsListCall) PageToken(pageToken string) *ServicesConsumerQuotaMetricsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// View sets the optional parameter "view": Specifies the level of
// detail for quota information in the response.
//
// Possible values:
//   "QUOTA_VIEW_UNSPECIFIED" - No quota view specified. Requests that
// do not specify a quota view will typically default to the BASIC view.
//   "BASIC" - Only buckets with overrides are shown in the response.
//   "FULL" - Include per-location buckets even if they do not have
// overrides. When the view is FULL, and a limit has regional or zonal
// quota, the limit will include buckets for all regions or zones that
// could support overrides, even if none are currently present. In some
// cases this will cause the response to become very large; callers that
// do not need this extra information should use the BASIC view instead.
func (c *ServicesConsumerQuotaMetricsListCall) View(view string) *ServicesConsumerQuotaMetricsListCall {
	c.urlParams_.Set("view", view)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ServicesConsumerQuotaMetricsListCall) Fields(s ...googleapi.Field) *ServicesConsumerQuotaMetricsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ServicesConsumerQuotaMetricsListCall) IfNoneMatch(entityTag string) *ServicesConsumerQuotaMetricsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ServicesConsumerQuotaMetricsListCall) Context(ctx context.Context) *ServicesConsumerQuotaMetricsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ServicesConsumerQuotaMetricsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ServicesConsumerQuotaMetricsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211207")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/consumerQuotaMetrics")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "serviceconsumermanagement.services.consumerQuotaMetrics.list" call.
// Exactly one of *V1Beta1ListConsumerQuotaMetricsResponse or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *V1Beta1ListConsumerQuotaMetricsResponse.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ServicesConsumerQuotaMetricsListCall) Do(opts ...googleapi.CallOption) (*V1Beta1ListConsumerQuotaMetricsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &V1Beta1ListConsumerQuotaMetricsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Retrieves a summary of all quota information about this consumer that is visible to the service producer, for each quota metric defined by the service. Each metric includes information about all of its defined limits. Each limit includes the limit configuration (quota unit, preciseness, default value), the current effective limit value, and all of the overrides applied to the limit.",
	//   "flatPath": "v1beta1/services/{servicesId}/{servicesId1}/{servicesId2}/consumerQuotaMetrics",
	//   "httpMethod": "GET",
	//   "id": "serviceconsumermanagement.services.consumerQuotaMetrics.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "Requested size of the next page of data.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "Token identifying which result to start with; returned by a previous list call.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Parent of the quotas resource. An example parent would be: `services/serviceconsumermanagement.googleapis.com/projects/123`",
	//       "location": "path",
	//       "pattern": "^services/[^/]+/[^/]+/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "view": {
	//       "description": "Specifies the level of detail for quota information in the response.",
	//       "enum": [
	//         "QUOTA_VIEW_UNSPECIFIED",
	//         "BASIC",
	//         "FULL"
	//       ],
	//       "enumDescriptions": [
	//         "No quota view specified. Requests that do not specify a quota view will typically default to the BASIC view.",
	//         "Only buckets with overrides are shown in the response.",
	//         "Include per-location buckets even if they do not have overrides. When the view is FULL, and a limit has regional or zonal quota, the limit will include buckets for all regions or zones that could support overrides, even if none are currently present. In some cases this will cause the response to become very large; callers that do not need this extra information should use the BASIC view instead."
	//       ],
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/{+parent}/consumerQuotaMetrics",
	//   "response": {
	//     "$ref": "V1Beta1ListConsumerQuotaMetricsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ServicesConsumerQuotaMetricsListCall) Pages(ctx context.Context, f func(*V1Beta1ListConsumerQuotaMetricsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "serviceconsumermanagement.services.consumerQuotaMetrics.limits.get":

type ServicesConsumerQuotaMetricsLimitsGetCall struct {
	s            *APIService
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves a summary of quota information for a specific quota
// limit.
//
// - name: The resource name of the quota limit, returned by a
//   ListConsumerQuotaMetrics or GetConsumerQuotaMetric call. An example
//   name would be:
//   `services/compute.googleapis.com/projects/123/consumerQuotaMetrics/c
//   ompute.googleapis.com%2Fcpus/limits/%2Fproject%2Fregion`.
func (r *ServicesConsumerQuotaMetricsLimitsService) Get(name string) *ServicesConsumerQuotaMetricsLimitsGetCall {
	c := &ServicesConsumerQuotaMetricsLimitsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// View sets the optional parameter "view": Specifies the level of
// detail for quota information in the response.
//
// Possible values:
//   "QUOTA_VIEW_UNSPECIFIED" - No quota view specified. Requests that
// do not specify a quota view will typically default to the BASIC view.
//   "BASIC" - Only buckets with overrides are shown in the response.
//   "FULL" - Include per-location buckets even if they do not have
// overrides. When the view is FULL, and a limit has regional or zonal
// quota, the limit will include buckets for all regions or zones that
// could support overrides, even if none are currently present. In some
// cases this will cause the response to become very large; callers that
// do not need this extra information should use the BASIC view instead.
func (c *ServicesConsumerQuotaMetricsLimitsGetCall) View(view string) *ServicesConsumerQuotaMetricsLimitsGetCall {
	c.urlParams_.Set("view", view)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ServicesConsumerQuotaMetricsLimitsGetCall) Fields(s ...googleapi.Field) *ServicesConsumerQuotaMetricsLimitsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ServicesConsumerQuotaMetricsLimitsGetCall) IfNoneMatch(entityTag string) *ServicesConsumerQuotaMetricsLimitsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ServicesConsumerQuotaMetricsLimitsGetCall) Context(ctx context.Context) *ServicesConsumerQuotaMetricsLimitsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ServicesConsumerQuotaMetricsLimitsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ServicesConsumerQuotaMetricsLimitsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211207")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "serviceconsumermanagement.services.consumerQuotaMetrics.limits.get" call.
// Exactly one of *V1Beta1ConsumerQuotaLimit or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *V1Beta1ConsumerQuotaLimit.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ServicesConsumerQuotaMetricsLimitsGetCall) Do(opts ...googleapi.CallOption) (*V1Beta1ConsumerQuotaLimit, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &V1Beta1ConsumerQuotaLimit{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Retrieves a summary of quota information for a specific quota limit.",
	//   "flatPath": "v1beta1/services/{servicesId}/{servicesId1}/{servicesId2}/consumerQuotaMetrics/{consumerQuotaMetricsId}/limits/{limitsId}",
	//   "httpMethod": "GET",
	//   "id": "serviceconsumermanagement.services.consumerQuotaMetrics.limits.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The resource name of the quota limit, returned by a ListConsumerQuotaMetrics or GetConsumerQuotaMetric call. An example name would be: `services/compute.googleapis.com/projects/123/consumerQuotaMetrics/compute.googleapis.com%2Fcpus/limits/%2Fproject%2Fregion`",
	//       "location": "path",
	//       "pattern": "^services/[^/]+/[^/]+/[^/]+/consumerQuotaMetrics/[^/]+/limits/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "view": {
	//       "description": "Specifies the level of detail for quota information in the response.",
	//       "enum": [
	//         "QUOTA_VIEW_UNSPECIFIED",
	//         "BASIC",
	//         "FULL"
	//       ],
	//       "enumDescriptions": [
	//         "No quota view specified. Requests that do not specify a quota view will typically default to the BASIC view.",
	//         "Only buckets with overrides are shown in the response.",
	//         "Include per-location buckets even if they do not have overrides. When the view is FULL, and a limit has regional or zonal quota, the limit will include buckets for all regions or zones that could support overrides, even if none are currently present. In some cases this will cause the response to become very large; callers that do not need this extra information should use the BASIC view instead."
	//       ],
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/{+name}",
	//   "response": {
	//     "$ref": "V1Beta1ConsumerQuotaLimit"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "serviceconsumermanagement.services.consumerQuotaMetrics.limits.producerOverrides.create":

type ServicesConsumerQuotaMetricsLimitsProducerOverridesCreateCall struct {
	s                    *APIService
	parent               string
	v1beta1quotaoverride *V1Beta1QuotaOverride
	urlParams_           gensupport.URLParams
	ctx_                 context.Context
	header_              http.Header
}

// Create: Creates a producer override. A producer override is applied
// by the owner or administrator of a service to increase or decrease
// the amount of quota a consumer of the service is allowed to use. To
// create multiple overrides at once, use ImportProducerOverrides
// instead. If an override with the specified dimensions already exists,
// this call will fail. To overwrite an existing override if one is
// already present ("upsert" semantics), use ImportProducerOverrides
// instead.
//
// - parent: The resource name of the parent quota limit, returned by a
//   ListConsumerQuotaMetrics or GetConsumerQuotaMetric call. An example
//   name would be:
//   `services/compute.googleapis.com/projects/123/consumerQuotaMetrics/c
//   ompute.googleapis.com%2Fcpus/limits/%2Fproject%2Fregion`.
func (r *ServicesConsumerQuotaMetricsLimitsProducerOverridesService) Create(parent string, v1beta1quotaoverride *V1Beta1QuotaOverride) *ServicesConsumerQuotaMetricsLimitsProducerOverridesCreateCall {
	c := &ServicesConsumerQuotaMetricsLimitsProducerOverridesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.v1beta1quotaoverride = v1beta1quotaoverride
	return c
}

// Force sets the optional parameter "force": Whether to force the
// creation of the quota override. Setting the force parameter to 'true'
// ignores all quota safety checks that would fail the request.
// QuotaSafetyCheck lists all such validations.
func (c *ServicesConsumerQuotaMetricsLimitsProducerOverridesCreateCall) Force(force bool) *ServicesConsumerQuotaMetricsLimitsProducerOverridesCreateCall {
	c.urlParams_.Set("force", fmt.Sprint(force))
	return c
}

// ForceOnly sets the optional parameter "forceOnly": The list of quota
// safety checks to ignore before the override mutation. Unlike 'force'
// field that ignores all the quota safety checks, the 'force_only'
// field ignores only the specified checks; other checks are still
// enforced. The 'force' and 'force_only' fields cannot both be set.
//
// Possible values:
//   "QUOTA_SAFETY_CHECK_UNSPECIFIED" - Unspecified quota safety check.
//   "LIMIT_DECREASE_BELOW_USAGE" - Validates that a quota mutation
// would not cause the consumer's effective limit to be lower than the
// consumer's quota usage.
//   "LIMIT_DECREASE_PERCENTAGE_TOO_HIGH" - Validates that a quota
// mutation would not cause the consumer's effective limit to decrease
// by more than 10 percent.
func (c *ServicesConsumerQuotaMetricsLimitsProducerOverridesCreateCall) ForceOnly(forceOnly ...string) *ServicesConsumerQuotaMetricsLimitsProducerOverridesCreateCall {
	c.urlParams_.SetMulti("forceOnly", append([]string{}, forceOnly...))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ServicesConsumerQuotaMetricsLimitsProducerOverridesCreateCall) Fields(s ...googleapi.Field) *ServicesConsumerQuotaMetricsLimitsProducerOverridesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ServicesConsumerQuotaMetricsLimitsProducerOverridesCreateCall) Context(ctx context.Context) *ServicesConsumerQuotaMetricsLimitsProducerOverridesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ServicesConsumerQuotaMetricsLimitsProducerOverridesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ServicesConsumerQuotaMetricsLimitsProducerOverridesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211207")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.v1beta1quotaoverride)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/producerOverrides")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "serviceconsumermanagement.services.consumerQuotaMetrics.limits.producerOverrides.create" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ServicesConsumerQuotaMetricsLimitsProducerOverridesCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates a producer override. A producer override is applied by the owner or administrator of a service to increase or decrease the amount of quota a consumer of the service is allowed to use. To create multiple overrides at once, use ImportProducerOverrides instead. If an override with the specified dimensions already exists, this call will fail. To overwrite an existing override if one is already present (\"upsert\" semantics), use ImportProducerOverrides instead.",
	//   "flatPath": "v1beta1/services/{servicesId}/{servicesId1}/{servicesId2}/consumerQuotaMetrics/{consumerQuotaMetricsId}/limits/{limitsId}/producerOverrides",
	//   "httpMethod": "POST",
	//   "id": "serviceconsumermanagement.services.consumerQuotaMetrics.limits.producerOverrides.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "force": {
	//       "description": "Whether to force the creation of the quota override. Setting the force parameter to 'true' ignores all quota safety checks that would fail the request. QuotaSafetyCheck lists all such validations.",
	//       "location": "query",
	//       "type": "boolean"
	//     },
	//     "forceOnly": {
	//       "description": "The list of quota safety checks to ignore before the override mutation. Unlike 'force' field that ignores all the quota safety checks, the 'force_only' field ignores only the specified checks; other checks are still enforced. The 'force' and 'force_only' fields cannot both be set.",
	//       "enum": [
	//         "QUOTA_SAFETY_CHECK_UNSPECIFIED",
	//         "LIMIT_DECREASE_BELOW_USAGE",
	//         "LIMIT_DECREASE_PERCENTAGE_TOO_HIGH"
	//       ],
	//       "enumDescriptions": [
	//         "Unspecified quota safety check.",
	//         "Validates that a quota mutation would not cause the consumer's effective limit to be lower than the consumer's quota usage.",
	//         "Validates that a quota mutation would not cause the consumer's effective limit to decrease by more than 10 percent."
	//       ],
	//       "location": "query",
	//       "repeated": true,
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "The resource name of the parent quota limit, returned by a ListConsumerQuotaMetrics or GetConsumerQuotaMetric call. An example name would be: `services/compute.googleapis.com/projects/123/consumerQuotaMetrics/compute.googleapis.com%2Fcpus/limits/%2Fproject%2Fregion`",
	//       "location": "path",
	//       "pattern": "^services/[^/]+/[^/]+/[^/]+/consumerQuotaMetrics/[^/]+/limits/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/{+parent}/producerOverrides",
	//   "request": {
	//     "$ref": "V1Beta1QuotaOverride"
	//   },
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "serviceconsumermanagement.services.consumerQuotaMetrics.limits.producerOverrides.delete":

type ServicesConsumerQuotaMetricsLimitsProducerOverridesDeleteCall struct {
	s          *APIService
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a producer override.
//
// - name: The resource name of the override to delete. An example name
//   would be:
//   `services/compute.googleapis.com/projects/123/consumerQuotaMetrics/c
//   ompute.googleapis.com%2Fcpus/limits/%2Fproject%2Fregion/producerOver
//   rides/4a3f2c1d`.
func (r *ServicesConsumerQuotaMetricsLimitsProducerOverridesService) Delete(name string) *ServicesConsumerQuotaMetricsLimitsProducerOverridesDeleteCall {
	c := &ServicesConsumerQuotaMetricsLimitsProducerOverridesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Force sets the optional parameter "force": Whether to force the
// deletion of the quota override. Setting the force parameter to 'true'
// ignores all quota safety checks that would fail the request.
// QuotaSafetyCheck lists all such validations.
func (c *ServicesConsumerQuotaMetricsLimitsProducerOverridesDeleteCall) Force(force bool) *ServicesConsumerQuotaMetricsLimitsProducerOverridesDeleteCall {
	c.urlParams_.Set("force", fmt.Sprint(force))
	return c
}

// ForceOnly sets the optional parameter "forceOnly": The list of quota
// safety checks to ignore before the override mutation. Unlike 'force'
// field that ignores all the quota safety checks, the 'force_only'
// field ignores only the specified checks; other checks are still
// enforced. The 'force' and 'force_only' fields cannot both be set.
//
// Possible values:
//   "QUOTA_SAFETY_CHECK_UNSPECIFIED" - Unspecified quota safety check.
//   "LIMIT_DECREASE_BELOW_USAGE" - Validates that a quota mutation
// would not cause the consumer's effective limit to be lower than the
// consumer's quota usage.
//   "LIMIT_DECREASE_PERCENTAGE_TOO_HIGH" - Validates that a quota
// mutation would not cause the consumer's effective limit to decrease
// by more than 10 percent.
func (c *ServicesConsumerQuotaMetricsLimitsProducerOverridesDeleteCall) ForceOnly(forceOnly ...string) *ServicesConsumerQuotaMetricsLimitsProducerOverridesDeleteCall {
	c.urlParams_.SetMulti("forceOnly", append([]string{}, forceOnly...))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ServicesConsumerQuotaMetricsLimitsProducerOverridesDeleteCall) Fields(s ...googleapi.Field) *ServicesConsumerQuotaMetricsLimitsProducerOverridesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ServicesConsumerQuotaMetricsLimitsProducerOverridesDeleteCall) Context(ctx context.Context) *ServicesConsumerQuotaMetricsLimitsProducerOverridesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ServicesConsumerQuotaMetricsLimitsProducerOverridesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ServicesConsumerQuotaMetricsLimitsProducerOverridesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211207")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "serviceconsumermanagement.services.consumerQuotaMetrics.limits.producerOverrides.delete" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ServicesConsumerQuotaMetricsLimitsProducerOverridesDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes a producer override.",
	//   "flatPath": "v1beta1/services/{servicesId}/{servicesId1}/{servicesId2}/consumerQuotaMetrics/{consumerQuotaMetricsId}/limits/{limitsId}/producerOverrides/{producerOverridesId}",
	//   "httpMethod": "DELETE",
	//   "id": "serviceconsumermanagement.services.consumerQuotaMetrics.limits.producerOverrides.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "force": {
	//       "description": "Whether to force the deletion of the quota override. Setting the force parameter to 'true' ignores all quota safety checks that would fail the request. QuotaSafetyCheck lists all such validations.",
	//       "location": "query",
	//       "type": "boolean"
	//     },
	//     "forceOnly": {
	//       "description": "The list of quota safety checks to ignore before the override mutation. Unlike 'force' field that ignores all the quota safety checks, the 'force_only' field ignores only the specified checks; other checks are still enforced. The 'force' and 'force_only' fields cannot both be set.",
	//       "enum": [
	//         "QUOTA_SAFETY_CHECK_UNSPECIFIED",
	//         "LIMIT_DECREASE_BELOW_USAGE",
	//         "LIMIT_DECREASE_PERCENTAGE_TOO_HIGH"
	//       ],
	//       "enumDescriptions": [
	//         "Unspecified quota safety check.",
	//         "Validates that a quota mutation would not cause the consumer's effective limit to be lower than the consumer's quota usage.",
	//         "Validates that a quota mutation would not cause the consumer's effective limit to decrease by more than 10 percent."
	//       ],
	//       "location": "query",
	//       "repeated": true,
	//       "type": "string"
	//     },
	//     "name": {
	//       "description": "The resource name of the override to delete. An example name would be: `services/compute.googleapis.com/projects/123/consumerQuotaMetrics/compute.googleapis.com%2Fcpus/limits/%2Fproject%2Fregion/producerOverrides/4a3f2c1d`",
	//       "location": "path",
	//       "pattern": "^services/[^/]+/[^/]+/[^/]+/consumerQuotaMetrics/[^/]+/limits/[^/]+/producerOverrides/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/{+name}",
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "serviceconsumermanagement.services.consumerQuotaMetrics.limits.producerOverrides.list":

type ServicesConsumerQuotaMetricsLimitsProducerOverridesListCall struct {
	s            *APIService
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all producer overrides on this limit.
//
// - parent: The resource name of the parent quota limit, returned by a
//   ListConsumerQuotaMetrics or GetConsumerQuotaMetric call. An example
//   name would be:
//   `services/compute.googleapis.com/projects/123/consumerQuotaMetrics/c
//   ompute.googleapis.com%2Fcpus/limits/%2Fproject%2Fregion`.
func (r *ServicesConsumerQuotaMetricsLimitsProducerOverridesService) List(parent string) *ServicesConsumerQuotaMetricsLimitsProducerOverridesListCall {
	c := &ServicesConsumerQuotaMetricsLimitsProducerOverridesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Requested size of
// the next page of data.
func (c *ServicesConsumerQuotaMetricsLimitsProducerOverridesListCall) PageSize(pageSize int64) *ServicesConsumerQuotaMetricsLimitsProducerOverridesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Token identifying
// which result to start with; returned by a previous list call.
func (c *ServicesConsumerQuotaMetricsLimitsProducerOverridesListCall) PageToken(pageToken string) *ServicesConsumerQuotaMetricsLimitsProducerOverridesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ServicesConsumerQuotaMetricsLimitsProducerOverridesListCall) Fields(s ...googleapi.Field) *ServicesConsumerQuotaMetricsLimitsProducerOverridesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ServicesConsumerQuotaMetricsLimitsProducerOverridesListCall) IfNoneMatch(entityTag string) *ServicesConsumerQuotaMetricsLimitsProducerOverridesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ServicesConsumerQuotaMetricsLimitsProducerOverridesListCall) Context(ctx context.Context) *ServicesConsumerQuotaMetricsLimitsProducerOverridesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ServicesConsumerQuotaMetricsLimitsProducerOverridesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ServicesConsumerQuotaMetricsLimitsProducerOverridesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211207")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/producerOverrides")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "serviceconsumermanagement.services.consumerQuotaMetrics.limits.producerOverrides.list" call.
// Exactly one of *V1Beta1ListProducerOverridesResponse or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *V1Beta1ListProducerOverridesResponse.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ServicesConsumerQuotaMetricsLimitsProducerOverridesListCall) Do(opts ...googleapi.CallOption) (*V1Beta1ListProducerOverridesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &V1Beta1ListProducerOverridesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists all producer overrides on this limit.",
	//   "flatPath": "v1beta1/services/{servicesId}/{servicesId1}/{servicesId2}/consumerQuotaMetrics/{consumerQuotaMetricsId}/limits/{limitsId}/producerOverrides",
	//   "httpMethod": "GET",
	//   "id": "serviceconsumermanagement.services.consumerQuotaMetrics.limits.producerOverrides.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "Requested size of the next page of data.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "Token identifying which result to start with; returned by a previous list call.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "The resource name of the parent quota limit, returned by a ListConsumerQuotaMetrics or GetConsumerQuotaMetric call. An example name would be: `services/compute.googleapis.com/projects/123/consumerQuotaMetrics/compute.googleapis.com%2Fcpus/limits/%2Fproject%2Fregion`",
	//       "location": "path",
	//       "pattern": "^services/[^/]+/[^/]+/[^/]+/consumerQuotaMetrics/[^/]+/limits/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/{+parent}/producerOverrides",
	//   "response": {
	//     "$ref": "V1Beta1ListProducerOverridesResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ServicesConsumerQuotaMetricsLimitsProducerOverridesListCall) Pages(ctx context.Context, f func(*V1Beta1ListProducerOverridesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "serviceconsumermanagement.services.consumerQuotaMetrics.limits.producerOverrides.patch":

type ServicesConsumerQuotaMetricsLimitsProducerOverridesPatchCall struct {
	s                    *APIService
	name                 string
	v1beta1quotaoverride *V1Beta1QuotaOverride
	urlParams_           gensupport.URLParams
	ctx_                 context.Context
	header_              http.Header
}

// Patch: Updates a producer override.
//
// - name: The resource name of the override to update. An example name
//   would be:
//   `services/compute.googleapis.com/projects/123/consumerQuotaMetrics/c
//   ompute.googleapis.com%2Fcpus/limits/%2Fproject%2Fregion/producerOver
//   rides/4a3f2c1d`.
func (r *ServicesConsumerQuotaMetricsLimitsProducerOverridesService) Patch(name string, v1beta1quotaoverride *V1Beta1QuotaOverride) *ServicesConsumerQuotaMetricsLimitsProducerOverridesPatchCall {
	c := &ServicesConsumerQuotaMetricsLimitsProducerOverridesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.v1beta1quotaoverride = v1beta1quotaoverride
	return c
}

// Force sets the optional parameter "force": Whether to force the
// update of the quota override. Setting the force parameter to 'true'
// ignores all quota safety checks that would fail the request.
// QuotaSafetyCheck lists all such validations.
func (c *ServicesConsumerQuotaMetricsLimitsProducerOverridesPatchCall) Force(force bool) *ServicesConsumerQuotaMetricsLimitsProducerOverridesPatchCall {
	c.urlParams_.Set("force", fmt.Sprint(force))
	return c
}

// ForceOnly sets the optional parameter "forceOnly": The list of quota
// safety checks to ignore before the override mutation. Unlike 'force'
// field that ignores all the quota safety checks, the 'force_only'
// field ignores only the specified checks; other checks are still
// enforced. The 'force' and 'force_only' fields cannot both be set.
//
// Possible values:
//   "QUOTA_SAFETY_CHECK_UNSPECIFIED" - Unspecified quota safety check.
//   "LIMIT_DECREASE_BELOW_USAGE" - Validates that a quota mutation
// would not cause the consumer's effective limit to be lower than the
// consumer's quota usage.
//   "LIMIT_DECREASE_PERCENTAGE_TOO_HIGH" - Validates that a quota
// mutation would not cause the consumer's effective limit to decrease
// by more than 10 percent.
func (c *ServicesConsumerQuotaMetricsLimitsProducerOverridesPatchCall) ForceOnly(forceOnly ...string) *ServicesConsumerQuotaMetricsLimitsProducerOverridesPatchCall {
	c.urlParams_.SetMulti("forceOnly", append([]string{}, forceOnly...))
	return c
}

// UpdateMask sets the optional parameter "updateMask": Update only the
// specified fields. If unset, all modifiable fields will be updated.
func (c *ServicesConsumerQuotaMetricsLimitsProducerOverridesPatchCall) UpdateMask(updateMask string) *ServicesConsumerQuotaMetricsLimitsProducerOverridesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ServicesConsumerQuotaMetricsLimitsProducerOverridesPatchCall) Fields(s ...googleapi.Field) *ServicesConsumerQuotaMetricsLimitsProducerOverridesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ServicesConsumerQuotaMetricsLimitsProducerOverridesPatchCall) Context(ctx context.Context) *ServicesConsumerQuotaMetricsLimitsProducerOverridesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ServicesConsumerQuotaMetricsLimitsProducerOverridesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ServicesConsumerQuotaMetricsLimitsProducerOverridesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211207")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.v1beta1quotaoverride)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "serviceconsumermanagement.services.consumerQuotaMetrics.limits.producerOverrides.patch" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ServicesConsumerQuotaMetricsLimitsProducerOverridesPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates a producer override.",
	//   "flatPath": "v1beta1/services/{servicesId}/{servicesId1}/{servicesId2}/consumerQuotaMetrics/{consumerQuotaMetricsId}/limits/{limitsId}/producerOverrides/{producerOverridesId}",
	//   "httpMethod": "PATCH",
	//   "id": "serviceconsumermanagement.services.consumerQuotaMetrics.limits.producerOverrides.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "force": {
	//       "description": "Whether to force the update of the quota override. Setting the force parameter to 'true' ignores all quota safety checks that would fail the request. QuotaSafetyCheck lists all such validations.",
	//       "location": "query",
	//       "type": "boolean"
	//     },
	//     "forceOnly": {
	//       "description": "The list of quota safety checks to ignore before the override mutation. Unlike 'force' field that ignores all the quota safety checks, the 'force_only' field ignores only the specified checks; other checks are still enforced. The 'force' and 'force_only' fields cannot both be set.",
	//       "enum": [
	//         "QUOTA_SAFETY_CHECK_UNSPECIFIED",
	//         "LIMIT_DECREASE_BELOW_USAGE",
	//         "LIMIT_DECREASE_PERCENTAGE_TOO_HIGH"
	//       ],
	//       "enumDescriptions": [
	//         "Unspecified quota safety check.",
	//         "Validates that a quota mutation would not cause the consumer's effective limit to be lower than the consumer's quota usage.",
	//         "Validates that a quota mutation would not cause the consumer's effective limit to decrease by more than 10 percent."
	//       ],
	//       "location": "query",
	//       "repeated": true,
	//       "type": "string"
	//     },
	//     "name": {
	//       "description": "The resource name of the override to update. An example name would be: `services/compute.googleapis.com/projects/123/consumerQuotaMetrics/compute.googleapis.com%2Fcpus/limits/%2Fproject%2Fregion/producerOverrides/4a3f2c1d`",
	//       "location": "path",
	//       "pattern": "^services/[^/]+/[^/]+/[^/]+/consumerQuotaMetrics/[^/]+/limits/[^/]+/producerOverrides/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Update only the specified fields. If unset, all modifiable fields will be updated.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/{+name}",
	//   "request": {
	//     "$ref": "V1Beta1QuotaOverride"
	//   },
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}
