package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetTURNCredentials invokes the ccc.GetTURNCredentials API synchronously
func (client *Client) GetTURNCredentials(request *GetTURNCredentialsRequest) (response *GetTURNCredentialsResponse, err error) {
	response = CreateGetTURNCredentialsResponse()
	err = client.DoAction(request, response)
	return
}

// GetTURNCredentialsWithChan invokes the ccc.GetTURNCredentials API asynchronously
func (client *Client) GetTURNCredentialsWithChan(request *GetTURNCredentialsRequest) (<-chan *GetTURNCredentialsResponse, <-chan error) {
	responseChan := make(chan *GetTURNCredentialsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetTURNCredentials(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetTURNCredentialsWithCallback invokes the ccc.GetTURNCredentials API asynchronously
func (client *Client) GetTURNCredentialsWithCallback(request *GetTURNCredentialsRequest, callback func(response *GetTURNCredentialsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetTURNCredentialsResponse
		var err error
		defer close(result)
		response, err = client.GetTURNCredentials(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetTURNCredentialsRequest is the request struct for api GetTURNCredentials
type GetTURNCredentialsRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
	UserName   string `position:"Query" name:"UserName"`
}

// GetTURNCredentialsResponse is the response struct for api GetTURNCredentials
type GetTURNCredentialsResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Username       string `json:"Username" xml:"Username"`
	Password       string `json:"Password" xml:"Password"`
}

// CreateGetTURNCredentialsRequest creates a request to invoke GetTURNCredentials API
func CreateGetTURNCredentialsRequest() (request *GetTURNCredentialsRequest) {
	request = &GetTURNCredentialsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2017-07-05", "GetTURNCredentials", "", "")
	request.Method = requests.POST
	return
}

// CreateGetTURNCredentialsResponse creates a response to parse from GetTURNCredentials response
func CreateGetTURNCredentialsResponse() (response *GetTURNCredentialsResponse) {
	response = &GetTURNCredentialsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
