package companyreg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AcceptBookkeepingAuditResult invokes the companyreg.AcceptBookkeepingAuditResult API synchronously
func (client *Client) AcceptBookkeepingAuditResult(request *AcceptBookkeepingAuditResultRequest) (response *AcceptBookkeepingAuditResultResponse, err error) {
	response = CreateAcceptBookkeepingAuditResultResponse()
	err = client.DoAction(request, response)
	return
}

// AcceptBookkeepingAuditResultWithChan invokes the companyreg.AcceptBookkeepingAuditResult API asynchronously
func (client *Client) AcceptBookkeepingAuditResultWithChan(request *AcceptBookkeepingAuditResultRequest) (<-chan *AcceptBookkeepingAuditResultResponse, <-chan error) {
	responseChan := make(chan *AcceptBookkeepingAuditResultResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AcceptBookkeepingAuditResult(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AcceptBookkeepingAuditResultWithCallback invokes the companyreg.AcceptBookkeepingAuditResult API asynchronously
func (client *Client) AcceptBookkeepingAuditResultWithCallback(request *AcceptBookkeepingAuditResultRequest, callback func(response *AcceptBookkeepingAuditResultResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AcceptBookkeepingAuditResultResponse
		var err error
		defer close(result)
		response, err = client.AcceptBookkeepingAuditResult(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AcceptBookkeepingAuditResultRequest is the request struct for api AcceptBookkeepingAuditResult
type AcceptBookkeepingAuditResultRequest struct {
	*requests.RpcRequest
	Note             string           `position:"Query" name:"Note"`
	OrgCode          string           `position:"Query" name:"OrgCode"`
	OrgAddress       string           `position:"Query" name:"OrgAddress"`
	OrgName          string           `position:"Query" name:"OrgName"`
	ServiceStartTime requests.Integer `position:"Query" name:"ServiceStartTime"`
	AuditResult      requests.Boolean `position:"Query" name:"AuditResult"`
	BizId            string           `position:"Query" name:"BizId"`
	OrgMobile        string           `position:"Query" name:"OrgMobile"`
}

// AcceptBookkeepingAuditResultResponse is the response struct for api AcceptBookkeepingAuditResult
type AcceptBookkeepingAuditResultResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateAcceptBookkeepingAuditResultRequest creates a request to invoke AcceptBookkeepingAuditResult API
func CreateAcceptBookkeepingAuditResultRequest() (request *AcceptBookkeepingAuditResultRequest) {
	request = &AcceptBookkeepingAuditResultRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("companyreg", "2019-05-08", "AcceptBookkeepingAuditResult", "", "")
	request.Method = requests.POST
	return
}

// CreateAcceptBookkeepingAuditResultResponse creates a response to parse from AcceptBookkeepingAuditResult response
func CreateAcceptBookkeepingAuditResultResponse() (response *AcceptBookkeepingAuditResultResponse) {
	response = &AcceptBookkeepingAuditResultResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
