package companyreg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CloseIntention invokes the companyreg.CloseIntention API synchronously
func (client *Client) CloseIntention(request *CloseIntentionRequest) (response *CloseIntentionResponse, err error) {
	response = CreateCloseIntentionResponse()
	err = client.DoAction(request, response)
	return
}

// CloseIntentionWithChan invokes the companyreg.CloseIntention API asynchronously
func (client *Client) CloseIntentionWithChan(request *CloseIntentionRequest) (<-chan *CloseIntentionResponse, <-chan error) {
	responseChan := make(chan *CloseIntentionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CloseIntention(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CloseIntentionWithCallback invokes the companyreg.CloseIntention API asynchronously
func (client *Client) CloseIntentionWithCallback(request *CloseIntentionRequest, callback func(response *CloseIntentionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CloseIntentionResponse
		var err error
		defer close(result)
		response, err = client.CloseIntention(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CloseIntentionRequest is the request struct for api CloseIntention
type CloseIntentionRequest struct {
	*requests.RpcRequest
	Note  string `position:"Query" name:"Note"`
	BizId string `position:"Query" name:"BizId"`
}

// CloseIntentionResponse is the response struct for api CloseIntention
type CloseIntentionResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
}

// CreateCloseIntentionRequest creates a request to invoke CloseIntention API
func CreateCloseIntentionRequest() (request *CloseIntentionRequest) {
	request = &CloseIntentionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("companyreg", "2019-05-08", "CloseIntention", "", "")
	request.Method = requests.POST
	return
}

// CreateCloseIntentionResponse creates a response to parse from CloseIntention response
func CreateCloseIntentionResponse() (response *CloseIntentionResponse) {
	response = &CloseIntentionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
